; ****************************************************************************
; v9918.asm : MSX1 VDP emulation (tms9918a)
; ****************************************************************************

.386
.model flat, c

include vdp.inc
include z80.inc
include bootmsx.inc
include config.inc

extrn		z80:Z80STATE, vdp:VDPSTATE, msxmem:MSXMEMP, g_cf:CONFIG, 
		Mode3Clr:DWORD, ClrTbl:WORD

.const

Mode2Add	DD	0, 01600h, -0800h, 0800h

RegMask		DB	2, 07bh, 0fh, 0ffh, 7, 07fh, 7, 0ffh

.data?

pSurface		DD	?
pNameTbl		DD	?
pPatternTbl		DD	?
pColorTbl		DD	?
BitMask			DD	?
pSpriteTbl		DD	?
pSpritePatternTbl	DD	?
SpriteLines		DB	192 DUP (?)
bSprCurrent		DB	?
bSprLine		DB	?
bSprIllegal		DB	?

.code

VDP1Write1	PROC
	mov	ebx, vdp.dwRead
	mov	ecx, msxmem.pVideo
	mov	vdp.fIsFirst, 0
	cmp	[ebx + ecx], dh
	je	no_need
	mov	[ebx + ecx], dh
	mov	vdp.fModified, 1
no_need:
	mov	vdp.bReadAhead, dh
	inc	ebx
	and	ebx, 3fffh
	mov	vdp.dwRead, ebx
	ret
VDP1Write1	ENDP


VDP1Read1	PROC
	mov	ebx, vdp.dwRead
	mov	ecx, msxmem.pVideo
	mov	dh, vdp.bReadAhead
	mov	dl, [ebx + ecx]
	mov	vdp.bReadAhead, dl
	inc	ebx
	mov	vdp.fIsFirst, 0
	and	ebx, 3fffh
	mov	vdp.dwRead, ebx
	ret
VDP1Read1	ENDP


VDP1Write2	PROC
	mov	ecx, 1
	cmp	vdp.fIsFirst, ch
	je	first
	mov	vdp.fIsFirst, ch
	test	dh, 80h
	jnz	register
	mov	dl, vdp.bFirst
	test	dh, 40h
	jz	readahead
	and	edx, 03fffh
	mov	vdp.dwRead, edx
	ret

readahead:
	and	edx, 03fffh
	mov	ecx, msxmem.pVideo
	mov	bl, [edx + ecx]
	mov	vdp.bReadAhead, bl
	inc	edx
	and	edx, 03fffh
	mov	vdp.dwRead, edx
	ret

first:
	mov	vdp.fIsFirst, cl
	mov	vdp.bFirst, dh
	ret

register:
	mov	bl, dh
	and	ebx, 7
	mov	dl, vdp.bFirst
	and	dl, RegMask[ebx]
	cmp	vdp.bControlReg[ebx], dl
	je	no_need
	mov	vdp.fModified, cx
	mov	vdp.bControlReg[ebx], dl
	cmp	ebx, ecx
	je	checkint
no_need:
	ret

checkint:
	mov	dh, vdp.bStatusReg
	shr	dh, 2
	and	dl, dh
	and	dl, 20h
	mov	z80.fINT, dl
	ret
VDP1Write2	ENDP


VDP1Read2	PROC
	mov	cl, vdp.bStatusReg
	mov	dh, cl
	and	ecx, 7fh
	mov	vdp.bStatusReg, cl
	mov	z80.fINT, ch
	mov	vdp.fIsFirst, ch
	ret
VDP1Read2	ENDP


VDP1NotBuildScreen PROC C
	mov	al, vdp.bControlReg[1]
	and	al, BIT_5
	mov	z80.fINT, al
	
	mov	al, vdp.bStatusReg
	or	al, 80h
	cmp	vdp.fModified, 0
	jne	nbs_newspriteninfo
	mov	vdp.bStatusReg, al
nbs_nospriteinfo:
	ret

nbs_newspriteninfo:
	mov	vdp.bStatusReg, 80h
	; no stuff in screen 0
	test	vdp.bControlReg[1], 10h
	jnz	nbs_nospriteinfo
	
	push	ebx
	push	esi
	push	edi
	push	ebp
	pushf
	mov	ax, ds
	mov	es, ax
	mov	edi, msxmem.pSurfaceBack
	mov	pSurface, edi
	mov	eax, 80808080h
	mov	ecx, 256 * 192 / 4
	cld
	rep	stosd
	call	bs_loadtbl
	jmp	bs_sprites
VDP1NotBuildScreen ENDP


VDP1BuildScreen PROC C
	push	ebx
	push	esi
	push	edi
	push	ebp
	pushf
	
	mov	ax, ds
	mov	es, ax
	mov	eax, msxmem.pSurface
	mov	pSurface, eax
	
	; interrupt
	mov	al, vdp.bControlReg[1]
	and	al, BIT_5
	mov	z80.fINT, al
	mov	vdp.bStatusReg, 80h

	; backdrop
	mov	al, vdp.bControlReg[7]
	and	ax, 15
	sub	ax, 1
	adc	ax, 0
	mov	vdp.wBackDrop, ax

	; calculate screen mode
	mov	eax, dword ptr vdp.bControlReg
	mov	ebx, GRAPHIC_1
	and	eax, BIT_1 OR BIT_11 OR BIT_12
	je	bs_foundmode

	mov	ebx, GRAPHIC_2
	cmp	eax, BIT_1
	je	bs_foundmode

	mov	ebx, TEXT_1
	cmp	eax, BIT_12
	je	bs_foundmode

	mov	ebx, MULTICOLOR
	cmp	eax, BIT_11
	je	bs_foundmode
	mov	ebx, UNKNOWN
bs_foundmode:
	mov	vdp.wScreenMode, bx
	test	vdp.bControlReg[1], BIT_6
	jz	bs_blank
	jmp	cs:ScreenJumpTbl[ebx*4]

bs_blank:
	mov	edi, pSurface
	mov	eax, 80808080h
	mov	ecx, 256 * 192 / 4
	cld
	rep	stosd
bs_end:
	popf
	pop	ebp
	pop	edi
	pop	esi
	pop	ebx
	ret

ALIGN 4
ScreenJumpTbl DWORD bs_blank, bs_text1, 0, bs_multicolor, bs_graphic1, bs_graphic2

PIXEL	MACRO
	LOCAL	bs_blank

	add	al, al
	mov	[edi], dl
	jnc	bs_blank
	mov	[edi], dh
bs_blank:
	inc	edi
	ENDM


bs_text1:
	; first fill in the borders
	mov	ebp, pSurface
	mov	eax, 80808080h
	mov	[ebp], eax
	mov	[ebp+4], eax
	add	ebp, 0f8h
	mov	ecx, 190
bs_loop:
	lea	edi, [ebp+4]
	mov	[ebp], eax
	add	ebp, 8
	mov	[edi], eax
	add	edi, 8
	mov	[ebp], eax
	mov	[edi], eax
	add	ebp, 0fch
	dec	ecx
	jne	bs_loop
	lea	edi, [ebp+4]
	mov	[ebp], eax
	mov	[edi], eax

	xor	eax, eax
	mov	al, vdp.bControlReg[2]
	mov	ebx, msxmem.pVideo
	shl	eax, 10
	mov	vdp.pNameTable, eax
	add	eax, ebx
	mov	pNameTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[4]
	shl	eax, 11
	add	eax, ebx
	mov	pPatternTbl, eax
	xor	edx, edx
	mov	dl, vdp.bControlReg[7]
	mov	edi, pSurface
	mov	dx, ClrTbl[edx*2]
	mov	esi, pNameTbl
	add	edi, 8
	mov	ecx, 24
	xor	eax, eax
	mov	ebp, pPatternTbl
bs_nextrow0:
	push	ecx
	mov	ecx, 40
bs_nextcol0:
	push	ecx
	; load char number from nametable
	mov	al, [esi]
	mov	ecx, 8
	lea	ebx, [eax*8+ebp]
	; draw ch
bs_nextcharrow0:
	mov	al, [ebx]
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	inc	ebx
	add	edi, 100h - 6
	dec	ecx
	jne	bs_nextcharrow0
	; ch drawn; next
	sub	edi, 800h - 6
	inc	esi
	pop	ecx
	dec	ecx
	jne	bs_nextcol0
	add	edi, 710h
	pop	ecx
	dec	ecx
	jne	bs_nextrow0
	popf
	pop	ebp
	pop	edi
	pop	esi
	pop	ebx
	ret

bs_graphic1:
	call	bs_loadtbl
	mov	edi, pSurface
	mov	esi, pNameTbl
	mov	ecx, 24 * 32
	xor	eax, eax
bs_nextchar1:
	; load char number from nametable
	mov	al, [esi]
	; load color
	push	ecx
	mov	ebx, eax
	shr	ebx, 3
	add	ebx, pColorTbl
	mov	ecx, 8
	xor	edx, edx
	mov	dl, [ebx]
	; calculate pattern
	lea	ebx, [eax*8]
	add	ebx, pPatternTbl
	; color stuff
	mov	dx, ClrTbl[edx*2]
	; draw char
bs_nextcharrow1:
	mov	al, [ebx]
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	inc	ebx
	add	edi, 100h - 8
	dec	ecx
	jne	bs_nextcharrow1
	pop	ecx
	inc	esi
	dec	ecx
	test	ecx, 31
	jz	bs_nextrow1
	sub	edi, 800h - 8
	jmp	bs_nextchar1

bs_nextrow1:
	sub	edi, 0f8h
	test	ecx, ecx
	jne	bs_nextchar1
	jmp	bs_sprites

bs_graphic2:
	; calculate tables
	mov	al, vdp.bControlReg[2]
	mov	ebx, msxmem.pVideo
	shl	eax, 10
	mov	vdp.pNameTable, eax
	add	eax, ebx
	mov	pNameTbl, eax
	mov	al, vdp.bControlReg[3]
	and	eax, 128
	shl	eax, 6
	add	eax, ebx
	mov	pColorTbl, eax
	mov	al, vdp.bControlReg[4]
	and	eax, 4
	shl	eax, 11
	add	eax, ebx
	mov	pPatternTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[5]
	shl	eax, 7
	add	eax, ebx
	mov	pSpriteTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[6]
	shl	eax, 11
	add	eax, ebx
	mov	pSpritePatternTbl, eax
	; pattern number mask
	mov	ah, vdp.bControlReg[3]
	mov	al, 0ffh
	mov	edi, pSurface
	shr	eax, 2
	and	eax, 255 SHL 3
	mov	BitMask, eax
	; ok, go !
	mov	esi, pNameTbl
	call	bs_drawpart
	mov	al, vdp.bControlReg[3]
	and	eax, 040h
	shl	eax, 5
	add	pColorTbl, eax
	mov	al, vdp.bControlReg[4]
	and	eax, 2
	shl	eax, 10
	add	pPatternTbl, eax
	call	bs_drawpart
	mov	al, vdp.bControlReg[3]
	shr	eax, 3
	and	eax, 1100b
	mov	eax, Mode2Add[eax]
	add	pColorTbl, eax
	mov	al, vdp.bControlReg[4]
	and	eax, 3
	mov	eax, Mode2Add[eax*4]
	add	pPatternTbl, eax
	call	bs_drawpart

bs_sprites::
	mov	eax, 04040404h
	mov	edi, offset SpriteLines
	mov	ecx, 192 / 4
	cld
	rep	stosd
	mov	al, vdp.bControlReg[1]
	and	eax, 3
	cmp	g_cf.fIllegalSprites, ah
	jne	bs_doillegal
	or	eax, 4
bs_doillegal:
	mov	esi, pSpriteTbl
	mov	edi, JumpSpr[eax*4]
	mov	ecx, 32
	mov	bSprLine, 255
bs_spritesloop:
	cmp	byte ptr [esi], 208
	je	bs_spritesend
	mov	bSprCurrent, cl
	push	ecx
	push	esi
	push	edi
	call	edi
	pop	edi
	pop	esi
	pop	ecx
	add	esi, 4
	dec	ecx
	jne	bs_spritesloop
bs_spritesend:
	mov	al, bSprIllegal
	test	al, al
	jz	bs_noillegal
	neg	al
	add	al, 32 + 40h
	or	vdp.bStatusReg, al
	popf
	pop	ebp
	pop	edi
	pop	esi
	pop	ebx
	ret

bs_noillegal:
	neg	cl
	add	cl, 32
	or	vdp.bStatusReg, cl
	popf
	pop	ebp
	pop	edi
	pop	esi
	pop	ebx
	ret


bs_drawpart:
	xor	eax, eax
	mov	ecx, 8 * 32
bs_nextchar2:
	; load ch number from nametable
	mov	al, [esi]
	push	ecx
	lea	ebx,[eax*8]
	; calculate pattern address
	mov	ebp, pPatternTbl
	add	ebp, ebx
	; calculate color address
	and	ebx, BitMask
	add	ebx, pColorTbl
	mov	ecx, 8
bs_nextcharrow2:
	mov	al, [ebx]
	inc	ebx
	mov	dx, ClrTbl[eax*2]
	mov	al, [ebp]
	inc	ebp
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	PIXEL
	add	edi, 100h - 8
	dec	ecx
	jne	bs_nextcharrow2
	inc	esi
	pop	ecx
	dec	ecx
	test	ecx, 31
	jz	bs_nextrow2
	sub	edi, 800h - 8
	jmp	bs_nextchar2
bs_nextrow2:
	sub	edi, 0f8h
	test	ecx, ecx
	jne	bs_nextchar2
	retn

DSPRITE MACRO s, i
	LOCAL	nodisplacement, loop, skipline, onscreen, nocollision, skippixel, nextpxl,nostore, ok, NotDisplay, nd_loop, is_ok, nostore2

	; color
	mov	dl, [esi+3]
	and	dl, 15
	jz	NotDisplay
	add	dl, 90h

	; location
	xor	ebx, ebx
	mov	bh, [esi]
	mov	bl, [esi+1]
	inc	bh

	; pattern
	xor	ecx, ecx
	mov	cl, [esi+2]
	mov	eax, pSpritePatternTbl
	IF s EQ 16
		and	ecx, 0fch
	ENDIF
	mov	ebp, pSurface
	lea	edi, [ecx*8+eax]

	; horizontal offset
	mov	dh, s
	test	byte ptr [esi+3], 80h
	jz	onscreen
	sub	bl, 32
	jae	onscreen
	add	dh, bl
	ja	NotDisplay
	sub	bl, bl
onscreen:
	; illegal lines table
	mov	esi, ebx
	shr	esi, 8

	mov	ecx, s
loop:
	cmp	bh, 191
	ja	skipline
	mov	al, SpriteLines[esi]
	test	al, al
	jnz	ok
	call	bs_illegalline
	IF i NE 0
		jmp	short skipline
	ELSE
		jmp	short nostore
	ENDIF
ok:
	dec	al
	mov	SpriteLines[esi], al
nostore:

	push	ecx
	IF s EQ 16
		mov	ah, [edi]
		mov	al, [edi+16]
	ELSE
		mov	ah, [edi]
	ENDIF
	mov	ecx, s
	sub	cl, dh
	shl	ax, cl
	mov	cl, dh
nextpxl:
	add	ax, ax
	jnc	skippixel
	cmp	byte ptr [ebp+ebx], 90h
	jb	nocollision
	or	vdp.bStatusReg, 20h
	jmp	short skippixel
nocollision:
	mov	[ebp+ebx], dl
skippixel:
	add	bl, 1
	dec	ecx
	ja	nextpxl
	add	bl, cl
	sub	bl, dh
	pop	ecx
skipline:
	inc	bh
	inc	edi
	inc	esi
	and	esi, 0ffh
	dec	ecx
	jne	loop
	retn

NotDisplay:
	xor	edx, edx
	mov	bh, [esi]
	inc	bh
	mov	dl, bh
	mov	ecx, s
nd_loop:
	cmp	al, 192
	jae	is_ok
	mov	bl, SpriteLines[edx]
	test	bl, bl
	jnz	is_ok
	call	bs_illegalline
	jmp	short nostore2
is_ok:
	dec	bl
	mov	SpriteLines[edx], bl
nostore2:
	inc	bh
	inc	dl
	dec	ecx
	jne	nd_loop
	ret
	ENDM

LSPRITE MACRO s, i
	LOCAL	NotDisplay, NextLine, OnScreenHor, SkipLine, DisplayLine, SkipLine, NoStore, \
		NextPixel, NextPixel2, NextPixel3, is_ok, NoCollision, NoCollision2, \
		NoCollision3, NoCollision4, blank, blank2, blank3, blank4, NotNextPattern, \
		NotNextPattern2, NextLine2, DisplayLine2, NoStore3, SkipLine2, NextLine3, nostore4
	
	; destination address
	xor	ebx, ebx
	mov	bh, [esi]
	mov	bl, [esi+1]
	inc	bh

	; color
	mov	dl, [esi+3]
	and	dl, 15
	jz	NotDisplay
	add	dl, 90h

	; pattern address
	xor	eax, eax
	mov	al, [esi+2]
	IF s EQ 16
		and	al, 0fch
	ENDIF
	mov	ecx, pSpritePatternTbl
	mov	ebp, pSurface
	lea	edi, [ecx+eax*8]

	; horizontal correction
	test	byte ptr [esi+3], 80h
	jz	OnScreenHor
	sub	bl, 32
	jae	OnScreenHor
	mov	dh, bl
	add	dh, s * 2
	jz	NotDisplay
	inc	dh
	shr	dh, 33
	not	bl
	and	bl, 1

	; illegal lines
	mov	esi, ebx
	shr	esi, 8

	; draw sprite
	mov	ecx, s * 2
NextLine:
	push	ecx
	cmp	bh, 192
	jae	SkipLine
	mov	al, SpriteLines[esi]
	test	al, al
	jnz	DisplayLine
	call	bs_illegalline
	IF i NE 0
		jmp	short SkipLine
	ELSE
		jmp	short NoStore
	ENDIF
DisplayLine:
	dec	al
	mov	SpriteLines[esi], al
NoStore:
	mov	ah, [edi]
	IF s EQ 16
		mov	al, [edi+16]
	ENDIF
	mov	cl, s
	sub	cl, dh
	shl	ax, cl
	mov	cl, dh
NextPixel:
	add	ax, ax
	jnc	Blank2
	cmp	byte ptr [ebp+ebx], 90h
	jc	NoCollision
	or	vdp.bStatusReg, 20h
	jmp	short blank
NoCollision:
	mov	[ebp+ebx], dl
blank:
	test	bl, bl
	jz	blank2
	cmp	byte ptr [ebp+ebx-1], 90h
	jb	NoCollision2
	or	vdp.bStatusReg, 20h
	jmp	short blank2
NoCollision2:
	mov	[ebp+ebx-1], dl
blank2:
	add	bl, 2
	dec	cl
	ja	NextPixel
	sub	bl, dh
	sub	bl, dh
SkipLine:
	inc	esi
	and	esi, 255
	pop	ecx
	test	ecx, 1
	jz	NotNextPattern
	inc	edi
NotNextPattern:
	inc	bh
	dec	ecx
	jne	NextLine
	retn

OnScreenHor:
	mov	esi, ebx
	shr	esi, 8
	; draw sprite
	mov	dh, s
	mov	cl, dh
	add	cl, cl
NextLine2:
	push	ecx
	mov	cl, dh
	cmp	bh, 192
	jae	SkipLine2
	mov	al, SpriteLines[esi]
	test	al, al
	jnz	DisplayLine2
	call	bs_illegalline
	IF i NE 0
		jmp	short SkipLine2
	ELSE
		jmp	short NoStore3
	ENDIF
DisplayLine2:
	dec	al
	mov	SpriteLines[esi], al
NoStore3:
	mov	ah, [edi]
	IF s EQ 16
		mov	al, [edi+16]
	ENDIF
NextPixel2:
	add	ax, ax
	jnc	blank4
	cmp	byte ptr [ebp+ebx], 90h
	jb	NoCollision3
	or	vdp.bStatusReg, 20h
	jmp	short blank3
NoCollision3:
	mov	[ebp+ebx], dl
blank3:
	cmp	bl, 255
	jae	blank4
	cmp	byte ptr [ebp+ebx+1], 90h
	jb	NoCollision4
	or	vdp.bStatusReg, 20h
	jmp	short blank4
NoCollision4:
	mov	[ebp+ebx+1], dl
blank4:
	add	bl, 2
	dec	cl
	ja	NextPixel2
	add	bl, cl
	add	bl, cl
	sub	bl, dh
	sub	bl, dh
SkipLine2:
	inc	esi
	and	esi, 255
	pop	ecx
	test	cl, 1
	jz	NotNextPattern2
	inc	edi
NotNextPattern2:
	inc	bh
	dec	cl
	jne	NextLine2
	retn

NotDisplay:
	xor	edx, edx
	mov	dl, bh
	mov	ecx, s * 2
NextLine3:
	mov	bl, SpriteLines[edx]
	test	bl, bl
	jnz	is_ok
	call	bs_illegalline
	jmp	short nostore4
is_ok:
	dec	bl
	mov	SpriteLines[edx], bl
nostore4:
	inc	bh
	inc	dl
	dec	ecx
	jne	NextLine3
	ret
	ENDM

bs_illegalline:
	cmp	bSprLine, 255
	jz	bs_illegal
	cmp	bSprLine, bh
	ja	bs_notillegal
bs_illegal:
	mov	bSprLine, bh
	mov	al, bSprCurrent
	mov	bSprIllegal, al
bs_notillegal:
	retn

bs_sprite8x8x1:
	DSPRITE 8, 0

bs_sprite8x8x2:
	LSPRITE 8, 0

bs_sprite16x16x1:
	DSPRITE 16, 0

bs_sprite16x16x2:
	LSPRITE 16, 0

bs_sprite8x8x1_i:
	DSPRITE 8, 1

bs_sprite8x8x2_i:
	LSPRITE 8, 1

bs_sprite16x16x1_i:
	DSPRITE 16, 1

bs_sprite16x16x2_i:
	LSPRITE 16, 1

ALIGN 4
JumpSpr	DD	bs_sprite8x8x1, bs_sprite8x8x2, bs_sprite16x16x1, bs_sprite16x16x2
	DD	bs_sprite8x8x1_i, bs_sprite8x8x2_i, bs_sprite16x16x1_i, bs_sprite16x16x2_i

bs_multicolor:
	call	bs_loadtbl
	sub	esi, esi
	mov	ebp, pSurface
	mov	ecx, 24 * 32
bs_nextchar3:
	; get colors address (from pattern table !)
	push	ecx
	mov	ebx, pNameTbl
	xor	eax, eax
	mov	al, [ebx+esi]
	mov	ecx, esi
	shr	ecx, 4
	and	ecx, 6
	lea	ebx, [eax*8+ecx]
	add	ebx, pPatternTbl
	mov	ecx, 2
bs_nextcharrow3:
	; get colors
	mov	al, [ebx]
	xor	edx, edx
	mov	dl, al
	shr	dl, 4
	inc	ebx
	mov	edx, Mode3Clr[edx*4]
	mov	[ebp], edx
	mov	[ebp+100h], edx
	mov	[ebp+200h], edx
	mov	[ebp+300h], edx
	and	eax, 15
	add	ebp, 4
	mov	edx, Mode3Clr[eax*4]
	mov	[ebp], edx
	mov	[ebp+100h], edx
	mov	[ebp+200h], edx
	mov	[ebp+300h], edx
	add	ebp, 400h-4
	dec	ecx
	jne	bs_nextcharrow3
	inc	esi
	pop	ecx
	dec	ecx
	test	ecx, 31
	jz	bs_nextrow3
	sub	ebp, 800h-8
	jmp	bs_nextchar3
bs_nextrow3:
	sub	ebp, 0f8h
	test	ecx, ecx
	jne	bs_nextchar3
	jmp	bs_sprites

bs_loadtbl::
	xor	eax, eax
	mov	al, vdp.bControlReg[2]
	mov	ebx, msxmem.pVideo
	shl	eax, 10
	mov	vdp.pNameTable, eax
	add	eax, ebx
	mov	pNameTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[3]
	shl	eax, 6
	add	eax, ebx
	mov	pColorTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[4]
	shl	eax, 11
	add	eax, ebx
	mov	pPatternTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[5]
	shl	eax, 7
	add	eax, ebx
	mov	pSpriteTbl, eax
	xor	eax, eax
	mov	al, vdp.bControlReg[6]
	shl	eax, 11
	add	eax, ebx
	mov	pSpritePatternTbl, eax
	retn
VDP1BuildScreen ENDP

END
