// config.h
#define _MAX_PATH	260

typedef struct tagCARTRIDGE
	{
	char		fEnabled ;
	char		iType ;
	char		iSCCtype ;
	char		iROMtype ;
	char		szROMfile[_MAX_PATH] ;
	char		szSRAMfile[_MAX_PATH] ;
	} CARTRIDGE ;

#define	CONFIG_CARTRIDGE_NONE			0
#define	CONFIG_CARTRIDGE_SCC			1
#define	CONFIG_CARTRIDGE_ROM			2

#define CONFIG_CARTRIDGE_SCCROM			0
#define CONFIG_CARTRIDGE_SDSCCP			1
#define CONFIG_CARTRIDGE_THSCCP			2

#define	CONFIG_CARTRIDGE_STANDARD		0
#define	CONFIG_CARTRIDGE_KONAMI4_8KB	1
#define	CONFIG_CARTRIDGE_KONAMI4_16KB	2
#define	CONFIG_CARTRIDGE_KONAMI5_8KB	3
#define	CONFIG_CARTRIDGE_KONAMI5_16KB	4
#define	CONFIG_CARTRIDGE_ASCII_8KB		5
#define	CONFIG_CARTRIDGE_ASCII_16KB		6
#define	CONFIG_CARTRIDGE_GM2			7

typedef struct tagMEMORY
	{
	char		iMem[4][4][4] ;	 /* [primary][secundary][page] */
	char		fSlotExpanded[4] ;
	char		iMapperSize[16] ;
	} MEMORY ;

#define CONFIG_MEMORY_EMPTY			0
#define CONFIG_MEMORY_BIOS			1
#define CONFIG_MEMORY_SUBBIOS		2
#define CONFIG_MEMORY_DISKROM		3
#define CONFIG_MEMORY_DOS2			4
#define CONFIG_MEMORY_RAM			5
#define CONFIG_MEMORY_RAMMM			6
#define CONFIG_MEMORY_CARTA			7
#define CONFIG_MEMORY_CARTB			8
#define CONFIG_MEMORY_CARTC			9

typedef struct tagCONFIG
	{
	char			iMSXversion ;
	char			iMSXlanguage ;
	char			iVRAMsize ;
	char			iFPS ;
	char			fIllegalSprites ;
	long			apeClr[15] ;
	CARTRIDGE		cart[3] ;
	MEMORY			mem ;
	} CONFIG ;

#define CONFIG_VERSION_MSX1			0
#define CONFIG_VERSION_MSX2			1
#define CONFIG_VERSION_MSX2P		2
#define CONFIG_VERSION_MSXTURBOR	3

#define CONFIG_LANGUAGE_INT			0
#define CONFIG_LANGUAGE_JAPANESE	1

#define CONFIG_VRAM_64KB			0
#define CONFIG_VRAM_128KB			1
#define CONFIG_VRAM_196KB			2

#define CONFIG_FPS_60				0
#define CONFIG_FPS_30				1
#define CONFIG_FPS_20				2
#define CONFIG_FPS_15				3
#define CONFIG_FPS_12				4
#define CONFIG_FPS_10				5

#define CONFIG_MAX_NAMELEN			64

int GetCurrentConfig (CONFIG*, char*) ;
int SetCurrentConfig (const CONFIG*, const char*) ;

typedef struct tagSAVECONFIG
	{
	char		szName[CONFIG_MAX_NAMELEN] ;
	CONFIG		cf ;
	} SAVECONFIG ;

typedef struct tagFILECONFIG
	{
	char		sID[4] ;
	short		iVersion ;
	short		iCount ;
	short		fCurrent ;
	SAVECONFIG	scfCurrent ;
	SAVECONFIG	scf[1] ;
	} FILECONFIG ;

//void LoadConfigs (HWND, FILECONFIG**, int *) ;
//void SaveConfigs (HWND, FILECONFIG*,int) ;
///oid LoadDefaultConfig (HWND) ;
