// error.c
#include <windows.h>
#include "resource.h"

extern const char		g_szAppName[] ;
extern HINSTANCE		g_hInstance ;

int MessageBoxID (HWND hwnd, int iID, UINT uMB)
	{
	char		szMessage[256] ;

	LoadString (g_hInstance, iID, szMessage, sizeof (szMessage) ) ;
	return MessageBox (hwnd, szMessage, NULL, uMB) ;
	}

int ErrorFileID (HWND hwnd, char *szFile, int iID, UINT uMB)
	{
	char	szBuf1[256], szBuf2[_MAX_PATH + 256] ;

	LoadString (g_hInstance, iID, szBuf1, sizeof (szBuf1) ) ;
	wsprintf (szBuf2, szBuf1, szFile) ;
	return MessageBox (hwnd, szBuf2, NULL, uMB) ;
	}

void ErrorFile (HWND hwnd, char *szFile)
	{
	int		iErrID ;
	
	switch (GetLastError ())
		{
		case ERROR_FILE_NOT_FOUND:
			iErrID = IDS_ERRFILENOTFOUND ;
			break ;

		case ERROR_PATH_NOT_FOUND:
			iErrID = IDS_ERRPATHNOTFOUND ;
			break ;

		case ERROR_TOO_MANY_OPEN_FILES:
			iErrID = IDS_ERRTOOMANYFILES ;
			break ;

		case ERROR_ACCESS_DENIED:
			iErrID = IDS_ERRFILEACCESS ;
			break ;

		case ERROR_INVALID_DRIVE:
			iErrID = IDS_ERRINVALIDDRIVE ;
			break ;

		case ERROR_WRITE_PROTECT:
			iErrID = IDS_ERRWRITEPROTECT ;
			break ;

		case ERROR_NOT_READY:
			iErrID = IDS_ERRDRIVENOTREADY ;
			break ;

		case ERROR_NOT_DOS_DISK:
			iErrID = IDS_ERRNOTDOSDISK ;
			break ;

		case ERROR_READ_FAULT:
			iErrID = IDS_ERRREADFAULT ;
			break ;

		case ERROR_WRITE_FAULT:
			iErrID = IDS_ERRWRITEFAULT ;
			break ;
		
		case ERROR_DISK_FULL:
			iErrID = IDS_ERRDISKFULL ;
			break ;

		case ERROR_DISK_CHANGE:
			iErrID = IDS_ERRDISKCHANGED ;
			break ;

		case ERROR_FILE_CORRUPT:
			iErrID = IDS_ERRFILECORRUPT ;
			break ;

		case ERROR_DISK_CORRUPT:
			iErrID = IDS_ERRDISKCORRUPT ;
			break ;

		default:
			iErrID = IDS_FILEERRUNKNOWN ;
		}

	ErrorFileID (hwnd, szFile, iErrID, MB_ICONEXCLAMATION) ;
	}
