; getrc.asm : Retrieves info about a Konami ROM

COMMENT $
This source file is a piece of The Game Master 2, re-coded in intel 
assembler. It is used for determining the RC number of a Konami ROM cartridge.

This RC number can be used elsewhere in the program, in conjunction
with a table for gathering information about a ROM file, as what megaROM
type, what MSX computer it should run on, etc.

So far, not supported are: Green Beret, Sony Billiards, Sparkie, Crazy Train, Pooyan, 
	Athletic Land (weird version)

I've added: The Game Master, The Game Master 2, Synthesizer, Mah Jong 2 $

 .386
 .MODEL FLAT, C

GetRC PROTO C pROM : PTR BYTE, pRC : PTR WORD

COMMENT $
pROM is a pointer to the memory which contains the actual ROM. Only the first 4Kb is needed.
pRC is a pointer to a WORD which will contain the RC number, if successful. $

.const

RCTable		WORD 5850h, 700
		WORD 55A4h, 700
		WORD 6AA9h, 701
		WORD 6649h, 701
		WORD 6CD5h, 701
		WORD 6661h, 701
		WORD 6803h, 701
		WORD 65C5h, 702
		WORD 6640h, 702
		WORD 5F17h, 702
		WORD 5B7Eh, 703
		WORD 5CE8h, 703
		WORD 5BE9h, 703
		WORD 6A4Ch, 704
		WORD 5E17h, 705
		WORD 5E0Fh, 705
		WORD 77BCh, 706
		WORD 7A37h, 706
		WORD 7894h, 706
		WORD 6D5Bh, 707
		WORD 774Bh, 710
		WORD 7917h, 710
		WORD 7889h, 710
		WORD 766Bh, 711
		WORD 779Fh, 711
		WORD 77D5h, 711
		WORD 6776h, 712
		WORD 5B72h, 713
		WORD 5E21h, 713
		WORD 4C65h, 713
		WORD 6761h, 714
		WORD 6614h, 714
		WORD 68C6h, 714
		WORD 47D4h, 715
		WORD 83A4h, 716
		WORD 6C2Ch, 717
		WORD 72A2h, 718
		WORD 711Ch, 718
		WORD 71A3h, 718
		WORD 76DCh, 720
		WORD 4695h, 721
		WORD 5E1Eh, 723
		WORD 5E35h, 723
		WORD 5EB0h, 723
		WORD 6876h, 724
		WORD 57D8h, 724
		WORD 57EDh, 724
		WORD 6D85h, 725
		WORD 6AB8h, 725
		WORD 5D62h, 727
		WORD 643Bh, 727
		WORD 6518h, 727
		WORD 719Ch, 728
		WORD 6B48h, 728
		WORD 68ADh, 729
		WORD 678Dh, 729
		WORD 682Eh, 729
		WORD 7402h, 730
		WORD 6504h, 731
		WORD 6907h, 731
		WORD 6B22h, 731
		WORD 87B8h, 733
		WORD 5478h, 735	; added
		WORD 6553h, 741	; added
		WORD 7991h, 744
		WORD 7936h, 744
		WORD 79C1h, 744
		WORD 7B24h, 744
		WORD 7AF5h, 744
		WORD 85E4h, 747
		WORD 7ECDh, 765	; added
		WORD 0

.code

GetRC PROC C, pROM : PTR BYTE,  pRC : PTR WORD
	push	ebx
	; the ROM must begin with the 'AB' code
	mov	ebx, pROM
	cmp	WORD PTR [ebx], 'BA'
	jne	grc_error
	
	; checking for modern RC information
	mov	ax, [ebx + 010h]
	cmp	ax, 'BA'
	je	grc_newtype
	cmp	ax, 'DC'
	je	grc_newtype
	cmp	ax, 'FE'
	je	grc_newtype
	cmp	ax, 'ZY'
	je	grc_gm2
	
	; no modern RC information; add memory address 5000h thru 50FFh
	mov	ecx, 100h
	add	ebx, 1000h
	sub	edx, edx
	sub	eax, eax
grc_next:
	mov	al, [ebx]
	inc	ebx
	add	edx, eax
	dec	ecx
	jne	grc_next

	; now dx contains result of addition
	mov	ebx, OFFSET RCTable
grc_tblnext:
	; AGI ! only first time though, so who cares? (this loop is executed 256 times)
	mov	ax, [ebx]
	test	ax, ax
	je	grc_error
	cmp	ax, dx
	je	grc_found
	add	ebx, 4
	jmp	short grc_tblnext

grc_error:
	; fail... :(
	pop	ebx
	sub	eax, eax
	ret

grc_found:
	; get the RC number from the table, store and return success
	mov	ax, [ebx + 2]
	mov	ebx, pRC
	mov	[ebx], ax
	pop	ebx
	mov	eax, 1
	ret

grc_gm2:
	; store Game Master 2 RC and return success
	mov	ebx, pRC
	mov	WORD PTR [ebx], 755
	pop	ebx
	mov	eax, 1
	ret

grc_newtype:
	; the RC number is stored in two bytes after the 'AB'/'CD'/'EF' code in BCD.
	mov	ax, [ebx + 012h]
	; must be a 700 number, or fail.
	cmp	al, 7
	jne	grc_error
	; convert to non-BCD
	mov	al, ah
	and	al, 0fh
	shr	ah, 4
	cmp	al, 9
	ja	grc_error
	cmp	ah, 6
	ja	grc_error
	aad
	; make 700-based
	add	ax, 700
	; store and return success
	mov	ebx, pRC
	mov	[ebx], ax
	pop	ebx
	mov	eax, 1
	ret
GetRC ENDP

END
