; ****************************************************************************
; io.asm
; ****************************************************************************


.386
.model flat, c

include io.inc
include memory.inc
include vdp.inc

PUBLIC	vdp

.data?

vdp	VDPSTATE { }
regC	BYTE	?
CurPSG	BYTE	?
PSGReg	BYTE	16 DUP (?)

.const

MSX1ReadIO	DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; 80 - 87
		DD	VDP1Read1, VDP1Read2, Readxx, Readxx, Readxx, Readxx, ReadMegaRAM, Readxx
			; 88 - 8F
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; 90 - 97
		DD	VDP1Read1, VDP1Read2, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; 98 - 9F
		DD	Readxx, Readxx, Reada2, Readxx, Readxx, Readxx, Readxx, Readxx
			; A0 - A7
		DD	ReadPrimSS, Reada9, Readaa, Readxx, Readxx, Readxx, Readxx, Readxx
			; A8 - AF
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; B0 - B7
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; B8 - BF
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; C0 - C7
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; C8 - CF
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; D0 - D7
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; D8 - DF
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; E0 - E7
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; E8 - EF
		DD	Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx, Readxx
			; F0 - F7
		DD	Readxx, Readxx, Readxx, Readxx, ReadMMpage0, ReadMMpage1, ReadMMpage2, ReadMMpage3
			; F8 - FF


MSX1WriteIO	DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; 80 - 87
		DD	VDP1Write1, VDP1Write2, Writexx, Writexx, Writexx, Writexx, WriteMegaRAM, Writexx
			; 88 - 8F
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; 90 - 97
		DD	VDP1Write1, VDP1Write2, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; 98 - 9F
		DD	Writea0, Writea1, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; A0 - A7
		DD	WritePrimSS, Writexx, Writeaa, Writeab, Writexx, Writexx, Writexx, Writexx
			; A8 - AF
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; B0 - B7
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; B8 - BF
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; C0 - C7
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; C8 - CF
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; D0 - D7
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; D8 - DF
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; E0 - E7
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; E8 - EF
		DD	Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx, Writexx
			; F0 - F7
		DD	Writexx, Writexx, Writexx, Writexx, WriteMMpage0, WriteMMpage1, WriteMMpage2, WriteMMpage3
			; F8 - FF

.code

ReadIO	PROC
	mov	bl, dl
	sub	bl, 80h
	jc	Readxx
	and	ebx, 0ffh
	jmp	MSX1ReadIO[ebx*4]

Readxx::
	mov	dh, 0ffh
	ret

GetJoystick PROTO C

Reada2::
	mov	bl, CurPSG
	and	ebx, 15
	cmp	ebx, 14
	je	joy
	mov	dh, PSGReg[ebx]
	ret

joy:
	push	eax
	call	GetJoystick
	mov	dh, al
	pop	eax
	ret

EXTERN	g_byScanLines:BYTE

Reada9::
	mov	bl, regC
	and	ebx, 15
	mov	dh, g_byScanLines[ebx]
	not	dh
	ret

Readaa::
	mov	dh, regC
	ret

ReadIO	ENDP

WriteIO	PROC
	mov	bl, dl
	sub	bl, 80h
	jc	Writexx
	and	ebx, 0ffh
	jmp	MSX1WriteIO[ebx*4]

Writexx::
	ret

WritePPI PROTO
WritePSG PROTO

Writeab::
	mov	cl, dh
	shr	cl, 1
	and	cl, 111b
	mov	dl, regC
	mov	ch, NOT 1
	rol	ch, cl
	and	dl, ch
	and	dh, 1
	shl	dh, cl
	or	dh, dl

Writeaa::
	mov	regC, dh
	push	eax
	add	dh, dh
	sbb	eax, eax
	push	eax
	call	WritePPI
	pop	eax
	pop	eax
	ret

Writea0::
	mov	CurPSG, dh
	ret

Writea1::
	mov	bl, CurPSG
	and	ebx, 15
	mov	PSGReg[ebx], dh
	mov	dl, dh
	push	eax
	push	edx
	push	ebx
	call	WritePSG
	add	sp, 8
	pop	eax
	ret

WriteIO	ENDP

END
