// keyboard.c
#include <windows.h>

static const char chKeyTbl[] = {
		// normal
		'7', '6', '5', '4', '3', '2', '1', '0', 
		';', ']', '[','\\', '=', '-', '9', '8', 
		'b', 'a','\0', '/', '.', ',', '`','\'', 
		'j', 'i', 'h', 'g', 'f', 'e', 'd', 'c', 
		'r', 'q', 'p', 'o', 'n', 'm', 'l', 'k', 
		'z', 'y', 'x', 'w', 'v', 'u', 't', 's', 
		// shift
		'&', '^', '%', '$', '#', '@', '!', ')', 
		':', '}', '{', '|', '+', '_', '(', '*', 
		'B', 'A','\0', '?', '>', '<', '~', '"', 
		'J', 'I', 'H', 'G', 'F', 'E', 'D', 'C', 
		'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 
		'Z', 'Y', 'X', 'W', 'V', 'U', 'T', 'S',
		// control
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\x02','\x01','\0','\0','\0','\0','\0','\0', 
		'\x0a','\x09','\x08','\x07','\x06','\x05','\x04','\x03', 
		'\x12','\x11','\x10','\x0f','\x0e','\x0d','\x0c','\x0b', 
		'\x1a','\x19','\x18','\x17','\x16','\x15','\x14','\x13', 
		// graph
		'\0','\0','','\0','','','','\0', 
		'\0','\0','\0','\0','','','','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'','\0','\0','\0','\0','\0','\0','\0', 
		// graph + shift
		'\0','\0','\0','\0','\0','','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','','','','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','','','\0','\0','\0','\0','\0', 
		// code
		'','\0','','','','','','\0', 
		'\0','\0','\0','\0','\0','\0','','\0', 
		'','','\0','','','','\0','\0', 
		'','','','','','','','', 
		'','','','','','','','\0', 
		'','','','','','','','', 
		// code + shift
		'\0','\0','','','\xb6','','','\0', 
		'\0','\0','\0','\0','\0','\0','','\0', 
		'\0','','\0','','\0','','\0','\0', 
		'','\0','','','','\0','\0','\0', 
		'\0','\0','\0','\0','','\0','','\0', 
		'\0','\0','\0','\0','\0','','\0','\0' } ;
BYTE			g_byScanLines[9], g_pKeyState[24], g_chKeyTbl[7*48], g_vkTbl[] = {
				VK_F3, VK_F2, VK_F1, VK_NEXT, VK_CAPITAL, VK_PRIOR, VK_CONTROL, VK_SHIFT, 
				VK_RETURN, VK_END, VK_BACK, VK_F8, VK_TAB, VK_ESCAPE, VK_F5, VK_F4, 
				VK_RIGHT, VK_DOWN, VK_UP, VK_LEFT, VK_DELETE, VK_INSERT, VK_HOME, VK_SPACE } ;
static BOOL		bIgnoreChar, bKeyChanged ;
int				nCurCh, nCurChCount ;


// keyboard
static BYTE	byAltScan ;

void OnChar (WPARAM wParam, LPARAM lParam)
	{
	int		i ;
	BYTE		scan ;
	
	if (bIgnoreChar)
		{
		bIgnoreChar = FALSE ;
		return ;
		}
	
	scan = LOBYTE (HIWORD (lParam) ) ;
	
	for (i=0;i<(7*48);i++)
		{
		if (chKeyTbl[i] == (char)wParam)
			{
			if (scan != 0 && scan != byAltScan)
				{
				g_chKeyTbl[i] = scan ;
				}
			else
				{
				nCurCh = i ;
				nCurChCount = 4 ;
				}
			
			bKeyChanged = TRUE ;
			
			break ;
			}
		}
	
	return ;
	}

void OnKey (WPARAM wParam, LPARAM lParam)
	{
	int		i ;
	BYTE		scan ;
	
	if (!byAltScan && wParam == VK_MENU)
		byAltScan = LOBYTE (HIWORD (lParam) ) ;
	
	for (i=0;i<24;i++)
		{
		if (g_vkTbl[i] == (BYTE)wParam)
			{
			g_pKeyState[i] = !(lParam & 0x80000000) ;
			
			bIgnoreChar = TRUE ;
			bKeyChanged = TRUE ;
			return ;
			}
		}
	if (lParam & 0x80000000) // key up
		{
		scan = LOBYTE (HIWORD (lParam) ) ;
		
		for (i=0;i<(7*48);i++)
			{
			if (g_chKeyTbl[i] == scan)
				{
				g_chKeyTbl[i] = 0 ;
				
				bIgnoreChar = FALSE ;
				bKeyChanged = TRUE ;
				return ;
				}
			}
		}
	
	bIgnoreChar = FALSE ;
	return ;
	}

void ResetKeyb ()
	{
	memset (g_pKeyState, 0, 24) ;
	memset (g_chKeyTbl, 0, 7*48) ;
	bKeyChanged = TRUE ;
	
	nCurChCount = 0 ;
	nCurCh = -1 ;
	}

void AssembleKeyb ()
	{
	int				i, n ;
	BYTE				line ;
	static const BYTE	Key[] = { 0, 1, 2, 4, 5, 16, 17 } ;
	static BOOL		bKeySkip = FALSE ;
	
	if (!bKeyChanged)
		return ;
	
	for (i=0;i<3;i++)
		{
		line=0 ;
		
		for (n=0;n<8;n++)
			{
			line *= 2 ;
			if (g_pKeyState[i * 8 + n])
				line |= 1 ;
			}
		
		g_byScanLines[6 + i] = line ;
		}
	
	for (i=0;i<6;i++)
		g_byScanLines[i] = 0 ;
	
	for (i=0;i<(7*48);i++)
		{
		if (g_chKeyTbl[i])
			{
			n = (i % 48) / 8 ;
			
			g_byScanLines[n] = 0x80 >> (i % 8) ;
				
			g_byScanLines[6] |= Key[i / 48] ;
			}
		}
	
	if (nCurChCount > 0 && nCurCh != -1)
		{
		n = (nCurCh % 48) / 8 ;
		
		g_byScanLines[n] = 0x80 >> (nCurCh % 8) ;
		
		if (Key[nCurCh / 48] != 1)
			g_byScanLines[6] |= Key[nCurCh / 48] ;
		else
			{
			if (n < 2 || (n == 2 && ((nCurCh % 8) > 1)) )
				g_byScanLines[6] |= 1 ;
			}
		}
	bKeyChanged = FALSE ;
	}
