// mem.c:	custom memory functions
#include <windows.h>
#include <assert.h>
#include "mem.h" // just to check prototypes

static const char	szMemory[] = 
	"Out of memory. Close other applications and try again." ;
extern const char	g_szAppName[] ;
extern HWND			g_hwndMain ;

void MemoryAlert ()
	{
	MessageBox (g_hwndMain, szMemory, g_szAppName, MB_ICONSTOP) ;
	}

BOOL MemoryNew (void **ppv, UINT uSize)
	{
	void	*pnew ;
	
	assert (uSize > 0) ;
	
	pnew = LocalAlloc (LMEM_FIXED, uSize) ;
	
	if (pnew != NULL)
		{
		*ppv = pnew ;
		return TRUE ;
		}
	else 
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

BOOL MemoryNewZero (void **ppv, UINT uSize)
	{
	void	*pnew ;
	
	assert (uSize > 0) ;
	
	pnew = LocalAlloc (LMEM_FIXED | LMEM_ZEROINIT, uSize) ;
	
	if (pnew != NULL)
		{
		*ppv = pnew ;
		return TRUE ;
		}
	else 
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

void MemoryFree (void **ppv)
	{
	if (*ppv != NULL)
		{	
		LocalFree ((HLOCAL)*ppv) ;
		*ppv = NULL ;
		}
	}

BOOL MemoryReSize (void **ppv, UINT uNewSize)
	{
	void	*pv ;

	if (*ppv == NULL)
		pv = LocalAlloc (LMEM_FIXED, uNewSize) ;
	else
		pv = LocalReAlloc ((HLOCAL) *ppv, uNewSize, 0) ;

	if (pv !=  NULL)
		{
		*ppv = pv ;
		return TRUE ;
		}
	else
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

UINT GetMemorySize (void *pv)
	{
	return LocalSize ((HLOCAL) pv) ;
	}
