; memory.asm

.386
.model flat, c

include bootmsx.inc
include memory.inc

EXTRN	msxmem : MSXMEMP

.data?

ALIGN 4 

state		MEMSTATE { }

ALIGN 4

FastReadTbl	DWORD	8 DUP (?)	; per 8 kb
FastWriteTbl	DWORD	4 DUP (?)	; per 16 kb

.code

; *****************************************************************************
; InitMemory resets memory state to default

InitMemory	PROC
	push	edi
	push	ebx
	pushf
	
	; clear the whole thing
	mov	edi, OFFSET state
	mov	ecx, sizeof state
	xor	eax, eax
	cld
	push	ds
	pop	es
	rep	stosb	[edi]

	; memory mappers
	mov	dword ptr state.bMM, 00010203h
	
	; cartridges
im_next_outer:
	mov	dh, msxmem.bLastCartPage[eax]
	xor	ebx, ebx
im_next:
	mov	dl, bl
	and	dl, dh
	mov	state.bCarts[eax * 4 + ebx], dl
	inc	ebx
	cmp	ebx, 4
	jne	im_next
	inc	eax
	cmp	eax, 4
	jne	im_next_outer

	popf
	pop	ebx
	pop	edi
	ret
InitMemory	ENDP

; *****************************************************************************
; DoMemory : fills FastReadTbl and FastWriteTbl

DoMemory	PROC
	push	ebx
	push	edx
	; page 0
	mov	bl, state.bPrimSelect
	and	ebx, 3
	mov	cl, state.bSecSelect[ebx]
	and	ecx, 3
	shl	ebx, 4
	shl	ecx, 2
	or	ebx, ecx
	mov	dl, msxmem.bMapType[ebx+0]
	cmp	dl, MAP_RAMMM
	je	dm0_rammm
	mov	ecx, msxmem.pMap[ebx*4+0]
	mov	FastReadTbl[0], ecx
	lea	ebx, [ecx+2000h]
	cmp	dl, MAP_ROM
	mov	FastReadTbl[4], ebx
	jne	dm0_ram
	mov	ecx, MAP_ROM
dm0_ram:
	mov	FastWriteTbl[0], ecx
	jmp	dm_page1
dm0_rammm:
	xor	ecx, ecx
	mov	cl, state.bMM[0]
	mov	edx, ebx
	shr	edx, 2
	and	cl, msxmem.bLastMMpage[edx]
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx]
	mov	FastReadTbl[0], ecx
	mov	FastWriteTbl[0], ecx
	add	ecx, 2000h
	mov	FastReadTbl[4], ecx
	; page 1
dm_page1:
	mov	bl, state.bPrimSelect
	and	ebx, 1100b
	shr	ebx, 2
	mov	cl, state.bSecSelect[ebx]
	and	ecx, 1100b
	shl	ebx, 4
	or	ebx, ecx
	mov	dl, msxmem.bMapType[ebx+1]
	cmp	dl, MAP_RAMMM
	je	dm1_rammm
	jb	dm1_cart
	mov	ecx, msxmem.pMap[ebx*4+4]
	mov	FastReadTbl[8], ecx
	lea	ebx, [ecx+2000h]
	cmp	dl, MAP_ROM
	mov	FastReadTbl[12], ebx
	jne	dm1_ram
	mov	ecx, MAP_ROM
dm1_ram:
	mov	FastWriteTbl[4], ecx
	jmp	dm_page2
dm1_rammm:
	xor	ecx, ecx
	mov	cl, state.bMM[1]
	mov	edx, ebx
	shr	edx, 2
	and	cl, msxmem.bLastMMpage[edx]
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx]
	mov	FastReadTbl[8], ecx
	mov	FastWriteTbl[4], ecx
	add	ecx, 2000h
	mov	FastReadTbl[12], ecx
	jmp	dm_page2
dm1_cart:
	mov	ecx, edx
	and	ecx, 255
	inc	dl
	mov	dh, msxmem.bCartType[ecx]
	shl	dl, 5
	or	dl, dh
	and	edx, 255
	mov	FastWriteTbl[4], edx
	lea	edx, [ecx*4]
	mov	ebx, msxmem.pCarts[edx]
	mov	cl, state.bCarts[edx]
	shl	ecx, 13
	add	ecx, ebx
	mov	FastReadTbl[8], ecx
	xor	ecx, ecx
	mov	cl, state.bCarts[edx+1]
	shl	ecx, 13
	add	ecx, ebx
	mov	FastReadTbl[12], ecx
	; page 2
dm_page2:
	mov	bl, state.bPrimSelect
	and	ebx, 30h
	shr	ebx, 4
	mov	cl, state.bSecSelect[ebx]
	and	ecx, 30h
	shr	ecx, 2
	shl	ebx, 4
	or	ebx, ecx
	mov	dl, msxmem.bMapType[ebx+2]
	cmp	dl, MAP_RAMMM
	je	dm2_rammm
	jb	dm2_cart
	mov	ecx, msxmem.pMap[ebx*4+2*4]
	mov	FastReadTbl[16], ecx
	lea	ebx, [ecx+2000h]
	cmp	dl, MAP_ROM
	mov	FastReadTbl[20], ebx
	jne	dm2_ram
	mov	ecx, MAP_ROM
dm2_ram:
	mov	FastWriteTbl[8], ecx
	jmp	dm_page3
dm2_rammm:
	xor	ecx, ecx
	mov	cl, state.bMM[2]
	mov	edx, ebx
	shr	edx, 2
	and	cl, msxmem.bLastMMpage[edx]
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx]
	mov	FastReadTbl[16], ecx
	mov	FastWriteTbl[8], ecx
	add	ecx, 2000h
	mov	FastReadTbl[20], ecx
	jmp	dm_page3
dm2_cart:
	mov	ecx, edx
	and	ecx, 255
	inc	dl
	mov	dh, msxmem.bCartType[ecx]
	shl	dl, 5
	or	dl, dh
	and	edx, 255
	mov	FastWriteTbl[8], edx
	lea	edx, [ecx*4]
	mov	ebx, msxmem.pCarts[edx]
	mov	cl, state.bCarts[edx+2]
	shl	ecx, 13
	add	ecx, ebx
	mov	FastReadTbl[16], ecx
	xor	ecx, ecx
	mov	cl, state.bCarts[edx+3]
	shl	ecx, 13
	add	ecx, ebx
	mov	FastReadTbl[20], ecx
	; page 3
dm_page3:
	mov	bl, state.bPrimSelect
	and	ebx, 0c0h
	shr	ebx, 6
	mov	cl, state.bSecSelect[ebx]
	and	ecx, 0c0h
	shl	ebx, 4
	shr	ecx, 4
	or	ebx, ecx
	mov	dl, msxmem.bMapType[ebx+3]
	cmp	dl, MAP_RAMMM
	je	dm3_rammm
	mov	ecx, msxmem.pMap[ebx*4+3*4]
	mov	FastReadTbl[24], ecx
	lea	ebx, [ecx+2000h]
	cmp	dl, MAP_ROM
	mov	FastReadTbl[28], ebx
	jne	dm3_ram
	mov	ecx, MAP_ROM
dm3_ram:
	mov	FastWriteTbl[12], ecx
	pop	edx
	pop	ebx
	ret
dm3_rammm:
	xor	ecx, ecx
	mov	cl, state.bMM[3]
	mov	edx, ebx
	shr	edx, 2
	and	cl, msxmem.bLastMMpage[edx]
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx]
	mov	FastReadTbl[24], ecx
	mov	FastWriteTbl[12], ecx
	add	ecx, 2000h
	mov	FastReadTbl[28], ecx
	pop	edx
	pop	ebx
	ret
DoMemory	ENDP

; *****************************************************************************
; The Read functions

ReadMem_dl	PROC
	cmp	cx, 0ffffh
	je	rm_ssr
	mov	ebx, ecx
	rol	ebx, 16 + 5
	and	ebx, 11100b
	and	ecx, 1fffh
	mov	ebx, FastReadTbl[ebx]
	mov	dl, [ebx + ecx]
	ret		

rm_ssr:
	mov	bl, state.bPrimSelect
	shr	bl, 6
	and	ebx, 3
	cmp	msxmem.bSlotExpanded[ebx], 0
	jz	rm_notexpanded
	mov	dl, state.bSecSelect[ebx]
	not	dl
	ret

rm_notexpanded:
	mov	ebx, FastReadTbl[28]
	mov	dl, [ebx + 01fffh]
	ret
ReadMem_dl	ENDP


ReadMem_dh	PROC
	cmp	cx, 0ffffh
	je	rm_ssr
	mov	ebx, ecx
	rol	ebx, 16 + 5
	and	ebx, 11100b
	and	ecx, 1fffh
	mov	ebx, FastReadTbl[ebx]
	mov	dh, [ebx + ecx]
	ret		

rm_ssr:
	mov	bl, state.bPrimSelect
	shr	bl, 6
	and	ebx, 3
	cmp	msxmem.bSlotExpanded[ebx], 0
	jz	rm_notexpanded
	mov	dh, state.bSecSelect[ebx]
	not	dh
	ret

rm_notexpanded:
	mov	ebx, FastReadTbl[28]
	mov	dh, [ebx + 01fffh]
	ret
ReadMem_dh	ENDP


ReadPC_dl	PROC
	cmp	di, 0ffffh
	je	rm_ssr
	mov	ebx, edi
	mov	ecx, edi
	rol	ebx, 16 + 5
	and	ebx, 11100b
	and	ecx, 1fffh
	inc	edi
	mov	ebx, FastReadTbl[ebx]
	mov	dl, [ebx + ecx]
	ret		

rm_ssr:
	mov	bl, state.bPrimSelect
	shr	bl, 6
	and	ebx, 3
	inc	edi
	cmp	msxmem.bSlotExpanded[ebx], 0
	jz	rm_notexpanded
	mov	dl, state.bSecSelect[ebx]
	not	dl
	ret

rm_notexpanded:
	mov	ebx, FastReadTbl[28]
	mov	dl, [ebx + 01fffh]
	ret
ReadPC_dl	ENDP


ReadPC_dh	PROC
	cmp	di, 0ffffh
	je	rm_ssr
	mov	ebx, edi
	mov	ecx, edi
	rol	ebx, 16 + 5
	and	ebx, 11100b
	and	ecx, 1fffh
	inc	edi
	mov	ebx, FastReadTbl[ebx]
	mov	dh, [ebx + ecx]
	ret		

rm_ssr:
	mov	bl, state.bPrimSelect
	shr	bl, 6
	and	ebx, 3
	inc	edi
	cmp	msxmem.bSlotExpanded[ebx], 0
	jz	rm_notexpanded
	mov	dh, state.bSecSelect[ebx]
	not	dh
	ret

rm_notexpanded:
	mov	ebx, FastReadTbl[28]
	mov	dh, [ebx + 01fffh]
	ret
ReadPC_dh	ENDP

; *****************************************************************************
; The Write functions

WriteSCC PROTO C

WRITE_MEM MACRO	reg
	LOCAL	WriteJmp

	cmp	cx, 0ffffh
	je	wm_ssr
wm_notssr:
	mov	ebx, ecx
	rol	ebx, 16 + 4
	and	ebx, 1100b
	; AGI
	mov	ebx, FastWriteTbl[ebx]
	cmp	ebx, 0ffh
	jbe	wm_notram
	and	ecx, 3fffh
	; AGI
	mov	[ebx + ecx], reg
	ret

wm_ssr:
	mov	bl, state.bPrimSelect
	shr	bl, 6
	and	ebx, 3
	cmp	msxmem.bSlotExpanded[ebx], 0
	je	wm_notssr
	mov	state.bSecSelect[ebx], reg
	jmp	DoMemory

wm_notram:
	jmp	WriteJmp[ebx*4]

WriteJmp	DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom

		DWORD	wm_rom, wm_a_fm, wm_a_dos2, wm_a_kon4_8, wm_a_kon5_8, wm_a_asc_8
		DWORD	wm_a_asc_8s, wm_a_asc_16, wm_a_gm2, wm_a_rtype
		DWORD	wm_a_thsccp, wm_a_sdsccp, wm_a_sccp, wm_a_mr256, wm_a_mr512, wm_a_mr768
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom

		DWORD	wm_rom, wm_b_fm, wm_b_dos2, wm_b_kon4_8, wm_b_kon5_8, wm_b_asc_8
		DWORD	wm_b_asc_8s, wm_b_asc_16, wm_b_gm2, wm_b_rtype
		DWORD	wm_b_thsccp, wm_b_sdsccp, wm_b_sccp, wm_b_mr256, wm_b_mr512, wm_b_mr768
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom

		DWORD	wm_rom, wm_c_fm, wm_c_dos2, wm_c_kon4_8, wm_c_kon5_8, wm_c_asc_8
		DWORD	wm_c_asc_8s, wm_c_asc_16, wm_c_gm2, wm_c_rtype
		DWORD	wm_c_thsccp, wm_c_sdsccp, wm_c_sccp, wm_c_mr256, wm_c_mr512, wm_c_mr768
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom

		DWORD	wm_rom, wm_d_fm, wm_d_dos2, wm_d_kon4_8, wm_d_kon5_8, wm_d_asc_8
		DWORD	wm_d_asc_8s, wm_d_asc_16, wm_d_gm2, wm_d_rtype
		DWORD	wm_d_thsccp, wm_d_sdsccp, wm_d_sccp, wm_d_mr256, wm_d_mr512, wm_d_mr768
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom
		DWORD	wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom, wm_rom


wm_rom:
	ret	; that was easy, wasn't it?

WM_FM_PAC MACRO cart
	LOCAL	sram, check, ok, not_sram1, not_sram2, no

	cmp	cx, 5ffeh
	jb	sram
	jne	not_sram1
	mov	state.bExtraCarts[cart*8+0], reg
	jmp	check
not_sram1:
	cmp	cx, 5fffh
	jne	not_sram2
	mov	state.bExtraCarts[cart*8+1], reg
	jmp	check
not_sram2:
	cmp	cx, 7ff7h
	jne	no
	mov	bl, reg
	add	bl, bl
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bExtraCarts[cart*8+2], bl
check:
	xor	ecx, ecx
	mov	cl, msxmem.bLastCartPage[cart]
	cmp	word ptr state.bExtraCarts[cart*8], 0694dh
	lea	ebx, [ecx+1]
	je	ok
	mov	bl, state.bExtraCarts[cart*8+2]
ok:
	mov	state.bCarts[cart*4], bl
	inc	bl
	mov	state.bCarts[cart*4+1], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[12], ebx
	sub	ebx, 2000h
	mov	FastReadTbl[8], ebx
	mov	cl, state.bExtraCarts[cart*8+2]
	shr	cl, 1
	mov	[ebx+3ff7h], cl
	ret

sram:
	mov	bl, state.bCarts[cart*4]
	cmp	bl, msxmem.bLastCartPage[cart]
	jb	no
	and	ecx, 1fffh
	mov	ebx, FastReadTbl[8]
	mov	[ebx+ecx], reg
no:
	ret
	ENDM

wm_a_fm:
	WM_FM_PAC 0

wm_b_fm:
	WM_FM_PAC 1

wm_c_fm:
	WM_FM_PAC 2

wm_d_fm:
	WM_FM_PAC 3

WM_DOS2	MACRO cart
	LOCAL	no

	cmp	cx, 6000h
	jne	no

	xor	ebx, ebx
	mov	bl, reg
	add	bl, bl
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4], bl
	inc	bl
	mov	state.bCarts[cart*4+1], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[12], ebx
	sub	ebx, 2000h
	mov	FastReadTbl[8], ebx
no:
	ret
	ENDM

wm_a_dos2:
	WM_DOS2	0
	
wm_b_dos2:
	WM_DOS2	1
	
wm_c_dos2:
	WM_DOS2	2
	
wm_d_dos2:
	WM_DOS2	3

WM_KON4_8 MACRO cart
	LOCAL	fail
	
	test	ecx, 01fffh
	jnz	fail
	sub	cx, 04000h
	jbe	fail
	shr	ecx, 13
	and	ecx, 3
;	xor	ebx, ebx
	mov	bl, reg
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8 + ecx*4], ebx
fail:
	ret
	ENDM

wm_a_kon4_8:
	WM_KON4_8 0

wm_b_kon4_8:
	WM_KON4_8 1

wm_c_kon4_8:
	WM_KON4_8 2

wm_d_kon4_8:
	WM_KON4_8 3


WM_ASC_8 MACRO cart
	LOCAL	fail
	
	mov	ebx, ecx
	and	ebx, 0e000h
	cmp	ebx, 06000h
	jb	fail
	shr	ecx, 11
	and	ecx, 3
	xor	ebx, ebx
	mov	bl, reg
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8 + ecx*4], ebx
fail:
	ret
	ENDM

wm_a_asc_8:
	WM_ASC_8 0

wm_b_asc_8:
	WM_ASC_8 1

wm_c_asc_8:
	WM_ASC_8 2

wm_d_asc_8:
	WM_ASC_8 3

WM_ASC_8S MACRO cart
	LOCAL	fail, srampage, sram, upper
	
	cmp	cx, 8000h
	jae	sram
	mov	ebx, ecx
	and	ebx, 0e000h
	cmp	ebx, 06000h
	jne	fail
	shr	ecx, 11
	and	ecx, 3
	xor	ebx, ebx
	mov	bl, msxmem.bLastCartPage[cart]
	cmp	reg, bl
	lea	ebx, [ebx+1]
	ja	srampage
	mov	bl, reg
	and	bl, msxmem.bLastCartPage[cart]
srampage:
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8 + ecx*4], ebx
fail:
	ret

sram:
	cmp	cx, 0a000h
	jae	upper
	mov	bl, msxmem.bLastCartPage[cart]
	cmp	state.bCarts[cart*4+2], bl
	jbe	fail
	and	ecx, 01fffh
	mov	ebx, FastReadTbl[16]
	mov	[ebx + ecx], reg
	ret
upper:
	mov	bl, msxmem.bLastCartPage[cart]
	cmp	state.bCarts[cart*4+3], bl
	jbe	fail
	and	ecx, 01fffh
	mov	ebx, FastReadTbl[20]
	mov	[ebx + ecx], reg
	ret
	ENDM

wm_a_asc_8s:
	WM_ASC_8S 0

wm_b_asc_8s:
	WM_ASC_8S 1

wm_c_asc_8s:
	WM_ASC_8S 2

wm_d_asc_8s:
	WM_ASC_8S 3

WM_KON5_8 MACRO	cart
	LOCAL	fail, not, write, loop

	test	ecx, 1000h
	jz	fail

	test	ecx, 0800h
	jnz	write

	sub	ecx, 05000h
	shr	ecx, 13
	and	ecx, 3
	mov	bl, reg
	and	ebx, 03fh
	cmp	ecx, 2
	jne	not
	cmp	bl, 03fh
	jne	not
	mov	bl, msxmem.bLastCartPage[cart]
	inc	bl
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8+ecx*4], ebx
fail:
	ret
not:
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8+ecx*4], ebx
	ret

write:
	cmp	cx, 09800h
	jb	fail
	cmp	cx, 0a000h
	jae	fail
	mov	bl, msxmem.bLastCartPage[cart]
	inc	bl
	cmp	state.bCarts[cart*4+2], bl
	jne	fail
	and	ecx, 0ffh
	push	edx
	push	eax
	push	ecx
	mov	al, reg
	push	eax
	push	ecx
	pushd	cart*4
	call	WriteSCC
	add	sp, 12
	pop	ecx
	pop	eax
	pop	edx
	test	cl, cl
	js	fail
	mov	ebx, FastReadTbl[16]
	lea	ebx, [ebx + ecx + 1800h]
	mov	ecx, 8
loop:
	mov	[ebx], reg
	add	ebx, 100h
	dec	ecx
	jne	loop
	ret
	ENDM

wm_a_kon5_8:
	WM_KON5_8 0

wm_b_kon5_8:
	WM_KON5_8 1

wm_c_kon5_8:
	WM_KON5_8 2

wm_d_kon5_8:
	WM_KON5_8 3

WM_ASC_16 MACRO cart
	LOCAL	fail

	mov	ebx, ecx
	and	ebx, 0e800h
	cmp	ebx, 06000h
	jne	fail
	shr	ecx, 11
	and	ecx, 2
	xor	ebx, ebx
	mov	bl, reg
	add	bl, bl
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4+ecx+0], bl
	inc	bl
	mov	state.bCarts[cart*4+ecx+1], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[12+ecx*4], ebx
	sub	ebx, 2000h
	mov	FastReadTbl[8+ecx*4], ebx
fail:
	ret
	ENDM

wm_a_asc_16:
	WM_ASC_16 0

wm_b_asc_16:
	WM_ASC_16 1

wm_c_asc_16:
	WM_ASC_16 2

wm_d_asc_16:
	WM_ASC_16 3

WM_GM2	MACRO cart
	LOCAL	sram, fail, write

	cmp	cx, 0b000h
	jae	write
	and	ecx, 0f000h
	sub	ecx, 04000h
	shr	ecx, 13
	jbe	fail		; CF=1 or ZF=1
	mov	bl, reg
	test	bl, 10h
	jnz	sram
	and	ebx, 15
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8 + ecx*4], ebx
	ret

sram:
	shr	bl, 5
	and	ebx, 1
	add	ebx, 16
	mov	state.bCarts[cart*4+ecx], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8 + ecx*4], ebx
	ret

write:
	cmp	state.bCarts[cart*4+3], 10h
	jb	fail
	and	ecx, 0fffh
	mov	ebx, FastReadTbl[20]
	mov	[ecx+ebx], reg
	mov	[ecx+ebx+1000h], reg
fail:
	ret
	ENDM

wm_a_gm2:
	WM_GM2	0

wm_b_gm2:
	WM_GM2	1

wm_c_gm2:
	WM_GM2	2

wm_d_gm2:
	WM_GM2	3

WM_RTYPE MACRO cart
	LOCAL	fail

COMMENT $
	mov	ebx, ecx
	and	ebx, 0e000h
	cmp	ebx, 06000h
	jne	fail
	shr	ecx, 11
	and	ecx, 2
	xor	ebx, ebx
	mov	bl, msxmem.bLastCartPage[cart]
	sub	bl, reg
	sub	bl, reg
	dec	bl
	and	bl, msxmem.bLastCartPage[cart]
	mov	state.bCarts[cart*4+ecx+0], bl
	inc	bl
	mov	state.bCarts[cart*4+ecx+1], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[12+ecx*4], ebx
	sub	ebx, 2000h
	mov	FastReadTbl[8+ecx*4], ebx
$
	and	ecx, 0f000h
	cmp	ecx, 07000h
	jne	fail
	mov	bl, reg
	add	bl, bl
	mov	cl, bl
	not	bl
	and	cl, 0f0h
	and	ebx, 0fh
	and	cl, msxmem.bLastCartPage[cart]
	or	bl, cl
	mov	state.bCarts[cart*4+2], bl
	inc	bl
	mov	state.bCarts[cart*4+3], bl
	shl	ebx, 13
	add	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[20], ebx
	sub	ebx, 2000h
	mov	FastReadTbl[16], ebx
fail:
	ret
	ENDM

wm_a_rtype:
	WM_RTYPE 0

wm_b_rtype:
	WM_RTYPE 1

wm_c_rtype:
	WM_RTYPE 2

wm_d_rtype:
	WM_RTYPE 3

WM_SCCP macro	cart, type
	local	page, fail, modereg, sccpage, noscc, putpage, write_sccp, write, \
		next_scc, next_sccp, next_m, rom_mode, not_scc, do_scc, next_scc1, \
		next_scc2, next_scc3, next_scc4, do_write, do_write_5
	
	cmp	cx, 0bffeh
	jae	modereg
	
	mov	ebx, ecx
	sub	ebx, 4000h
	shr	ebx, 13
	and	ebx, 3
	and	ecx, 1fffh
	cmp	state.bExtraCarts[cart*8 + ebx], bh
	je	page
	IFIDNI <type>, <the>
		cmp	state.bCarts[cart*4+ebx], 8
		jae	fail
		mov	ebx, FastReadTbl[8+ebx*4]
		mov	[ebx + ecx], reg
	ELSEIFIDNI <type>, <sd>
		cmp	state.bCarts[cart*4+ebx], 8
		jb	fail
		cmp	state.bCarts[cart*4+ebx], 10h
		jae	fail
		mov	ebx, FastReadTbl[8+ebx*4]
		mov	[ebx + ecx], reg
	ELSEIFIDNI <type>, <128>
		cmp	state.bCarts[cart*4+ebx], 10h
		jae	fail
		mov	ebx, FastReadTbl[8+ebx*4]
		mov	[ebx + ecx], reg
	ELSE
		.ERR <type par wrong>
	ENDIF
	ret

page:
	cmp	ecx, 1000h
	jb	fail
	cmp	ecx, 1800h
	jae	write
	cmp	ebx, 2
	jb	noscc
	je	sccpage
	mov	state.bExtraCarts[cart*8+5], reg
	test	reg, 80h
	jz	noscc
	test	state.bExtraCarts[cart*8+6], 20h
	mov	ecx, 11h
	jnz	putpage
	jmp	noscc

sccpage:
	mov	state.bExtraCarts[cart*8+4], reg
	mov	cl, reg
	not	cl
	and	cl, 03fh
	jnz	noscc
	test	state.bExtraCarts[cart*8+6], 20h
	mov	ecx, 10h
	jz	putpage

noscc:
	mov	cl, reg
	and	ecx, 15
putpage:
	mov	state.bCarts[cart*4+ebx], cl
	shl	ecx, 13
	add	ecx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8+ebx*4], ecx
fail:
	ret

write:
	cmp	state.bCarts[cart*4+ebx], 10h
	jb	fail
	ja	write_sccp
	and	ecx, 255
	push	edx
	push	eax
	push	ecx
	mov	al, reg
	push	eax
	push	ecx
	pushd	cart*4+1
	call	WriteSCC
	add	sp, 12
	pop	ecx
	pop	eax
	pop	edx
	cmp	cl, 80h
	jae	fail
	push	ecx
	call	do_write
	pop	ecx
	cmp	cl, 60h
	jb	fail
	and	ecx, 1fh
	jmp	do_write_5

write_sccp:
	and	ecx, 255
	push	edx
	push	eax
	push	ecx
	mov	al, reg
	push	eax
	push	ecx
	pushd	cart*4+2
	call	WriteSCC
	add	sp, 12
	pop	ecx
	pop	eax
	pop	edx
	cmp	cl, 0a0h
	jae	fail
	cmp	cl, 80h
	jb	do_write
	and	ecx, 1fh
do_write_5:
	mov	ebx, msxmem.pCarts[cart]
	lea	ebx, [ebx+ecx+21860h]
	mov	cl, 8
next_scc3:
	mov	[ebx], reg
	mov	[ebx+40h], reg
	add	ebx, 100h
	dec	cl
	jne	next_scc3
	add	ebx, 1820h
	mov	cl, 8
next_scc4:
	mov	[ebx], reg
	add	ebx, 100h
	dec	cl
	jne	next_scc4
	ret

do_write:
	mov	ebx, msxmem.pCarts[cart]
	lea	ebx, [ebx+ecx+21800h]
	mov	cl, 8
next_scc1:
	mov	[ebx], reg
	add	ebx, 100h
	dec	cl
	jne	next_scc1
	add	ebx, 1800h
	mov	cl, 8
next_scc2:
	mov	[ebx], reg
	add	ebx, 100h
	dec	cl
	jne	next_scc2
	ret

modereg:
	mov	state.bExtraCarts[cart*8+6], reg
	test	reg, 10h
	jz	rom_mode
	xor	ebx, ebx
	mov	ecx, 1
next_m:
	mov	state.bExtraCarts[cart*8+ebx], cl
	inc	ebx
	cmp	ebx, 4
	jb	next_m
	jmp	do_scc

rom_mode:
	mov	cl, reg
	and	cl, 1
	mov	state.bExtraCarts[cart*8+0], cl
	mov	cl, reg
	and	cl, 2
	mov	state.bExtraCarts[cart*8+1], cl
	mov	cl, reg
	not	cl
	and	cl, 24h
	setz	cl
	mov	state.bExtraCarts[cart*8+2], cl
	mov	state.bExtraCarts[cart*8+3], 0
	
	; and for the SCC pages
do_scc:
	mov	cl, state.bExtraCarts[cart*8+4]
	mov	bl, cl
	and	ecx, 15
	not	bl
	and	bl, 03fh
	jnz	not_scc
	test	state.bExtraCarts[cart*8+6], 20h
	jnz	not_scc
	mov	cl, 10h
not_scc:
	mov	ebx, 2
	call	putpage

	mov	cl, state.bExtraCarts[cart*8+5]
	mov	bl, cl
	and	ecx, 15
	test	bl, 80h
	mov	ebx, 3
	jz	putpage
	test	state.bExtraCarts[cart*8+6], 20h
	jz	putpage
	mov	ecx, 11h
	jmp	putpage
	ENDM

wm_a_thsccp:
	WM_SCCP	0, the

wm_b_thsccp:
	WM_SCCP	1, the

wm_c_thsccp:
	WM_SCCP	2, the

wm_d_thsccp:
	WM_SCCP	3, the

wm_a_sdsccp:
	WM_SCCP	0, sd

wm_b_sdsccp:
	WM_SCCP	1, sd

wm_c_sdsccp:
	WM_SCCP	2, sd

wm_d_sdsccp:
	WM_SCCP	3, sd

wm_a_sccp:
	WM_SCCP	0, 128

wm_b_sccp:
	WM_SCCP	1, 128

wm_c_sccp:
	WM_SCCP	2, 128

wm_d_sccp:
	WM_SCCP	3, 128

WM_MEGARAM MACRO cart, size
	LOCAL	rom, ok, fail

	cmp	state.bMegaRAM, MEGARAM_ROM
	mov	ebx, ecx
	je	rom
	sub	ebx, 4000h
	shr	ebx, 13
	and	ebx, 3
	and	ecx, 1fffh
	IFDIFI	<size>, <31>
		cmp	state.bCarts[cart*4+ebx], size
		ja	fail
	ENDIF
	mov	ebx, FastReadTbl[8+ebx*4]
	mov	[ebx+ecx], reg
fail:
	ret

rom:
	sub	ebx, 4000h
	shr	ebx, 13
	and	ebx, 3
	xor	ecx, ecx
	IFIDNI	<size>, <31>
		mov	cl, reg
		and	cl, size
	ELSE
		mov	cl, reg
		cmp	cl, size
		jbe	ok
		mov	cl, size + 1
ok:
	ENDIF
	mov	state.bCarts[cart*4+ebx], cl
	shl	ecx, 13
	and	ebx, msxmem.pCarts[cart*4]
	mov	FastReadTbl[8+ebx*4], ebx
	ret
	ENDM

wm_a_mr256:
	WM_MEGARAM 0, 31

wm_b_mr256:
	WM_MEGARAM 1, 31

wm_c_mr256:
	WM_MEGARAM 2, 31

wm_d_mr256:
	WM_MEGARAM 3, 31

wm_a_mr512:
	WM_MEGARAM 0, 63

wm_b_mr512:
	WM_MEGARAM 1, 63

wm_c_mr512:
	WM_MEGARAM 2, 63

wm_d_mr512:
	WM_MEGARAM 3, 63

wm_a_mr768:
	WM_MEGARAM 0, 95

wm_b_mr768:
	WM_MEGARAM 1, 95

wm_c_mr768:
	WM_MEGARAM 2, 95

wm_d_mr768:
	WM_MEGARAM 3, 95

	ENDM


WriteMem_dl	PROC
	WRITE_MEM dl
WriteMem_dl	ENDP


WriteMem_dh	PROC
	WRITE_MEM dh
WriteMem_dh	ENDP


; *****************************************************************************
; The IO functions

WritePrimSS	PROC
	cmp	state.bPrimSelect, dh
	je	no_need
	mov	state.bPrimSelect, dh
	jmp	DoMemory
no_need:
	ret
WritePrimSS	ENDP


ReadPrimSS	PROC
	mov	dh, state.bPrimSelect
	ret
ReadPrimSS	ENDP



WriteMMpage0	PROC
	mov	bl, state.bPrimSelect
	and	ebx, 3
	mov	cl, state.bSecSelect[ebx]
	and	ecx, 3
	lea	ebx, [ebx*4+ecx]
	mov	cl, dh
	and	cl, msxmem.bMaxMMpage
	mov	state.bMM[0], cl
	cmp	msxmem.bMapType[ebx*4+0], MAP_RAMMM
	jne	wm_nomm
	and	cl, msxmem.bLastMMpage[ebx]
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx*4]
	mov	FastWriteTbl[0], ecx
	mov	FastReadTbl[0], ecx
	add	ecx, 2000h
	mov	FastReadTbl[4], ecx
wm_nomm:
	ret
WriteMMpage0	ENDP


WriteMMpage1	PROC
	mov	bl, state.bPrimSelect
	shr	ebx, 2
	and	ebx, 3
	mov	cl, state.bSecSelect[ebx]
	shr	ecx, 2
	and	ecx, 3
	lea	ebx, [ebx*4+ecx]
	mov	cl, dh
	and	cl, msxmem.bMaxMMpage
	mov	state.bMM[1], cl
	and	cl, msxmem.bLastMMpage[ebx]
	cmp	msxmem.bMapType[ebx*4+1], MAP_RAMMM
	jne	wm_nomm
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx*4]
	mov	FastWriteTbl[4], ecx
	mov	FastReadTbl[8], ecx
	add	ecx, 2000h
	mov	FastReadTbl[12], ecx
wm_nomm:
	ret
WriteMMpage1	ENDP


WriteMMpage2	PROC
	mov	bl, state.bPrimSelect
	shr	ebx, 4
	and	ebx, 3
	mov	cl, state.bSecSelect[ebx]
	shr	ecx, 4
	and	ecx, 3
	lea	ebx, [ebx*4+ecx]
	mov	cl, dh
	and	cl, msxmem.bMaxMMpage
	mov	state.bMM[2], cl
	and	cl, msxmem.bLastMMpage[ebx]
	cmp	msxmem.bMapType[ebx*4+2], MAP_RAMMM
	jne	wm_nomm
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx*4]
	mov	FastWriteTbl[8], ecx
	mov	FastReadTbl[16], ecx
	add	ecx, 2000h
	mov	FastReadTbl[20], ecx
wm_nomm:
	ret
WriteMMpage2	ENDP


WriteMMpage3	PROC
	mov	bl, state.bPrimSelect
	shr	ebx, 6
	and	ebx, 3
	mov	cl, state.bSecSelect[ebx]
	shr	ecx, 6
	and	ecx, 3
	lea	ebx, [ebx*4+ecx]
	mov	cl, dh
	and	cl, msxmem.bMaxMMpage
	mov	state.bMM[3], cl
	and	cl, msxmem.bLastMMpage[ebx]
	cmp	msxmem.bMapType[ebx*4+3], MAP_RAMMM
	jne	wm_nomm
	shl	ecx, 14
	add	ecx, msxmem.pMMRAM[ebx*4]
	mov	FastWriteTbl[12], ecx
	mov	FastReadTbl[24], ecx
	add	ecx, 2000h
	mov	FastReadTbl[28], ecx
wm_nomm:
	ret
WriteMMpage3	ENDP


ReadMMpage0	PROC
	cmp	msxmem.bMaxMMpage, 0
	je	rm_nomm
	mov	dh, state.bMM[0]
	ret
rm_nomm:
	mov	dh, 0ffh
	ret
ReadMMpage0	ENDP
	

ReadMMpage1	PROC
	cmp	msxmem.bMaxMMpage, 0
	je	rm_nomm
	mov	dh, state.bMM[1]
	ret
rm_nomm:
	mov	dh, 0ffh
	ret
ReadMMpage1	ENDP


ReadMMpage2	PROC
	cmp	msxmem.bMaxMMpage, 0
	je	rm_nomm
	mov	dh, state.bMM[2]
	ret
rm_nomm:
	mov	dh, 0ffh
	ret
ReadMMpage2	ENDP


ReadMMpage3	PROC
	cmp	msxmem.bMaxMMpage, 0
	je	rm_nomm
	mov	dh, state.bMM[3]
	ret
rm_nomm:
	mov	dh, 0ffh
	ret
ReadMMpage3	ENDP

ReadMegaRAM	PROC
	mov	dh, MEGARAM_RAM
	mov	state.bMegaRAM, dh
	ret
ReadMegaRAM	ENDP

WriteMegaRAM	PROC
	mov	state.bMegaRAM, MEGARAM_ROM
	ret
WriteMegaRAM	ENDP

END
