// sound.c
#include <windows.h>
#include <dsound.h>
#include "sound.h"

extern HWND g_hwndMain ;

BOOL SetSoundBuffer (LPDIRECTSOUNDBUFFER*, BYTE*, int) ;

static struct DSHELPER
	{
	LPDIRECTSOUND		lpDS ;
	LPDIRECTSOUNDBUFFER lpDSBPrim, lpDSBPPI, lpDSBSCC[4][5][2], lpDSBPSG[3][2] ;
	BOOL				fUse16,fSCCPlay[4][5][2] ;
	VOLSETTINGS			vol ;
	} ds ;

struct SOUND
	{
	// PPI status
	BOOL	fClick, fPPIOut ;
	// SCC status
	BYTE	SCCWave[4][5][32] ;
	BYTE	SCCReg[4][16] ;

	BOOL	UpdateWave[4][5] ;
	BOOL	UpdateReg[4] ;
	// PSG
	BYTE	PSGReg[13] ;
	BOOL	fUpdatePSG ;
	} snd ;

// PPI emulation
static BYTE		g_byClick[] = { 0x80, 0x80, 0x60, 0xc0, 0xff, 0xc0, 0x60, 0x80, 0x80 } ;

static void InitPPI ()
	{
	if (!ds.vol.PPI.fEnable) return ;

	SetSoundBuffer (&ds.lpDSBPPI, g_byClick, sizeof (g_byClick) ) ;
	}

void WritePPI (BOOL fState)
	{
	if (!snd.fPPIOut && fState)
		snd.fClick = TRUE ;

	snd.fPPIOut = fState ;
	}

void UpdatePPI ()
	{
	HRESULT		hr ;
	char		szBuf[256] ;
	
	if (snd.fClick && ds.lpDSBPPI)
		{
		hr = ds.lpDSBPPI->lpVtbl->Play (ds.lpDSBPPI, 0, 0, 0) ;

		if (hr == DSERR_BUFFERLOST)
			{
			if (SetSoundBuffer (&ds.lpDSBPPI, g_byClick, sizeof (g_byClick) ) )
				{
				hr = ds.lpDSBPPI->lpVtbl->Play (ds.lpDSBPPI, 0, 0, 0) ;
				}
			}

		if (DS_OK != hr)
			{
			wsprintf (szBuf, "Failed to play PPI sound buffer (%d).", hr & 15) ;
			MessageBox (g_hwndMain, szBuf, "DirectSound problem", MB_ICONEXCLAMATION) ;
			}
		}
	
	snd.fClick = FALSE ;
	}

// SCC stuff

void WriteSCC (int type, BYTE bReg, BYTE bVal)
	{
	int		iCart ;
	BOOL	fSCCP ;

	iCart = (type / 4) ;
	fSCCP = (type % 3) == 2 ;

	if (fSCCP)
		{
		if (bReg < 0xa0)
			{
			if (snd.SCCWave[iCart][bReg / 32][bReg & 31] != bVal)
				{
				snd.SCCWave[iCart][bReg / 32][bReg & 31] = bVal ;
				snd.UpdateWave[iCart][bReg / 32] = TRUE ;
				}
			}
		else if (bReg < 0xc0)
			{
			if (snd.SCCReg[iCart][bReg & 15] != bVal)
				{
				snd.SCCReg[iCart][bReg & 15] = bVal ;
				snd.UpdateReg[iCart] = TRUE ;
				}
			}
		}
	else
		{
		if (bReg < 0x60)
			{
			if (snd.SCCWave[iCart][bReg / 32][bReg & 31] != bVal)
				{
				snd.SCCWave[iCart][bReg / 32][bReg & 31] = bVal ;
				snd.UpdateWave[iCart][bReg / 32] = TRUE ;
				}
			}
		else if (bReg < 0x80)
			{
			if ( (snd.SCCWave[iCart][3][bReg & 31] != bVal) || 
				 (snd.SCCWave[iCart][4][bReg & 31] != bVal) )
				{
				snd.SCCWave[iCart][3][bReg & 31] = bVal ;
				snd.SCCWave[iCart][4][bReg & 31] = bVal ;
				snd.UpdateWave[iCart][3] = TRUE ;
				snd.UpdateWave[iCart][4] = TRUE ;
				}
			}
		else if (bReg < 0xa0)
			{
			if (snd.SCCReg[iCart][bReg & 15] != bVal)
				{
				snd.SCCReg[iCart][bReg & 15] = bVal ;
				snd.UpdateReg[iCart] = TRUE ;
				}
			}
		}
	}

static void InitSCC () {}

static void SetWave (int iCart, int iChan)
	{
	BYTE	bWave[32], bWaveSmall[8] ;
	int		i, x, ii, t, n ;

	for (i=0;i<32;i++)
		bWave[i] = (snd.SCCWave[iCart][iChan][i] ^ 0x80) ;
	
	SetSoundBuffer (&ds.lpDSBSCC[iCart][iChan][0], bWave, 32) ;
	ds.lpDSBSCC[iCart][iChan][0]->lpVtbl->SetPan (ds.lpDSBSCC[iCart][iChan][0], ds.vol.SCC[iCart].lPan * 1000) ;

	for (i=0;i<8;i++)
		{
		x=0;
		for (ii=0,t=0;ii<4;ii++)
			{
			n=(abs ((signed int)((signed char)snd.SCCWave[iCart][iChan][i*4+ii])));
			
			if (n > t) { x=ii ; t=n ; }
			}

		bWaveSmall[i] = (snd.SCCWave[iCart][iChan][i*4+x] ^ 0x80) ;
		}

	SetSoundBuffer (&ds.lpDSBSCC[iCart][iChan][1], bWaveSmall, 8) ;
	ds.lpDSBSCC[iCart][iChan][1]->lpVtbl->SetPan (ds.lpDSBSCC[iCart][iChan][1], ds.vol.SCC[iCart].lPan * 1000) ;
	}

static void UpdateSCC ()
	{
	int		iCart, iChan, iVol, iFreq ;
	BOOL	fActive, fUseHigh ;
	static int	iVols[16] = { -10000, -900, -777, -671, -501, -433, -374, -323, -279, -241, -208, -180, -155, -134, -115, 0 } ;
//	static int	iVols[16] = { -2143, -2000, -1857, -1714, -1571, -1429, -1286, -1143, -1000, -857, -714, -571, -429, -286, -143, 0 } ;

	for (iCart=0;iCart<4;iCart++)
		{
		if (!ds.vol.SCC[iCart].fEnable)
			continue ;
		
		for (iChan=0;iChan<5;iChan++)
			{
			// sound properties
			iVol = snd.SCCReg[iCart][10+iChan] ;
			iFreq = snd.SCCReg[iCart][iChan*2] + 256*(snd.SCCReg[iCart][iChan*2+1]&15) ;
			fActive = (snd.SCCReg[iCart][15] & (1 << iChan) ) && iVol && (iFreq > 8) ;
			fUseHigh = (iFreq <= 35) ;

			// if there are any changes to be made, first make it shut up
/*			if (snd.UpdateReg[iCart] || snd.UpdateWave[iCart][iChan])
				{
				if (ds.fSCCPlay[iCart][iChan][0])
					{
					ds.lpDSBSCC[iCart][iChan][0]->lpVtbl->Stop (ds.lpDSBSCC[iCart][iChan][0]) ;
					ds.fSCCPlay[iCart][iChan][0] = FALSE ;
					}
				
				if (ds.fSCCPlay[iCart][iChan][1])
					{
					ds.lpDSBSCC[iCart][iChan][1]->lpVtbl->Stop (ds.lpDSBSCC[iCart][iChan][1]) ;
					ds.fSCCPlay[iCart][iChan][1] = FALSE ;
					}
				}
  */
			// if the waveform needs updating, simply copy it again
			if (snd.UpdateWave[iCart][iChan])
				{
				snd.UpdateWave[iCart][iChan] = FALSE ;
				SetWave (iCart, iChan) ;
				}

			if (snd.UpdateReg[iCart])
				{
				if (fActive)
					{
					if (!ds.lpDSBSCC[iCart][iChan][0])
						SetWave (iCart, iChan) ;

					if (fUseHigh)
						{
						if (ds.lpDSBSCC[iCart][iChan][0])
							{
							ds.lpDSBSCC[iCart][iChan][0]->lpVtbl->SetVolume (ds.lpDSBSCC[iCart][iChan][0], iVols[iVol]) ;
							ds.lpDSBSCC[iCart][iChan][0]->lpVtbl->SetFrequency (ds.lpDSBSCC[iCart][iChan][0], 3579545 / iFreq) ;
							}
						}
					else
						{
						if (ds.lpDSBSCC[iCart][iChan][1])
							{
							ds.lpDSBSCC[iCart][iChan][1]->lpVtbl->SetVolume (ds.lpDSBSCC[iCart][iChan][1], iVols[iVol]) ;
							ds.lpDSBSCC[iCart][iChan][1]->lpVtbl->SetFrequency (ds.lpDSBSCC[iCart][iChan][1], 3579545 / (4 * iFreq) ) ;
							}
						}
					}
				}

			if (fActive)
				{
				// play fUseHigh
				if (!ds.fSCCPlay[iCart][iChan][!fUseHigh])
					{
					if (ds.lpDSBSCC[iCart][iChan][!fUseHigh])
						{
						ds.lpDSBSCC[iCart][iChan][!fUseHigh]->lpVtbl->Play (ds.lpDSBSCC[iCart][iChan][!fUseHigh], 0, 0, DSBPLAY_LOOPING) ;
						ds.fSCCPlay[iCart][iChan][!fUseHigh] = TRUE ;
						}
					}

				if (ds.fSCCPlay[iCart][iChan][fUseHigh])
					{
					ds.lpDSBSCC[iCart][iChan][fUseHigh]->lpVtbl->Stop (ds.lpDSBSCC[iCart][iChan][fUseHigh]) ;
					ds.fSCCPlay[iCart][iChan][fUseHigh] = FALSE ;
					}
				}
			else
				{
				// silent both
				if (ds.fSCCPlay[iCart][iChan][0])
					{
					ds.lpDSBSCC[iCart][iChan][0]->lpVtbl->Stop (ds.lpDSBSCC[iCart][iChan][0]) ;
					ds.fSCCPlay[iCart][iChan][0] = FALSE ;
					}

				if (ds.fSCCPlay[iCart][iChan][1])
					{
					ds.lpDSBSCC[iCart][iChan][1]->lpVtbl->Stop (ds.lpDSBSCC[iCart][iChan][1]) ;
					ds.fSCCPlay[iCart][iChan][1] = FALSE ;
					}
				}
			}
		}
	}

// PSG stuff
static BYTE	g_bToneHigh[8] = { 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0x40, 0x40, 0x40 } ;
static BYTE g_bToneMid[32] = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 } ;

static void PSGSetWave (int iChan)
	{
	if (!ds.vol.PSG.fEnable)
		return ;

	SetSoundBuffer (&ds.lpDSBPSG[iChan][0], g_bToneMid, sizeof (g_bToneMid) ) ;
	SetSoundBuffer (&ds.lpDSBPSG[iChan][1], g_bToneHigh, sizeof (g_bToneHigh) ) ;
	}

static void InitPSG ()
	{
	int		i ;

	for (i=0;i<3;i++)
		PSGSetWave (i) ;
	}

static void UpdatePSG ()
	{
	static int	iVols[16] = { -10000, -900, -777, -671, -501, -433, -374, -323, -279, -241, -208, -180, -155, -134, -115, 0 } ;
	int		i, iVol, iFreq ;
	BOOL	fActive ;

	if (snd.fUpdatePSG)
		{
		for (i=0;i<3;i++)
			{
			iFreq = snd.PSGReg[i*2] + 256 * (snd.PSGReg[i*2+1] & 15) ;
			iVol = snd.PSGReg[8+i] & 15 ;
			fActive = iVol && (iFreq > 8) && !(snd.PSGReg[7] & (1 << i) )  ;

			if (fActive)
				{
				if (iFreq > 35)
					{
					if (ds.lpDSBPSG[i][1])
						ds.lpDSBPSG[i][1]->lpVtbl->Stop (ds.lpDSBPSG[i][1]) ;

					if (!ds.lpDSBPSG[i][0])
						PSGSetWave (i) ;

					if (ds.lpDSBPSG[i][0])
						{
						ds.lpDSBPSG[i][0]->lpVtbl->SetVolume (ds.lpDSBPSG[i][0], iVols[iVol]) ;
						ds.lpDSBPSG[i][0]->lpVtbl->SetFrequency (ds.lpDSBPSG[i][0], 3579545 / iFreq) ;
						ds.lpDSBPSG[i][0]->lpVtbl->Play (ds.lpDSBPSG[i][0], 0, 0, DSBPLAY_LOOPING) ;
						}
					}
				else
					{
					if (ds.lpDSBPSG[i][0])
						ds.lpDSBPSG[i][0]->lpVtbl->Stop (ds.lpDSBPSG[i][0]) ;

					if (!ds.lpDSBPSG[i][1])
						PSGSetWave (i) ;

					if (ds.lpDSBPSG[i][1])
						{
						ds.lpDSBPSG[i][1]->lpVtbl->SetVolume (ds.lpDSBPSG[i][1], iVols[iVol]) ;
						ds.lpDSBPSG[i][1]->lpVtbl->SetFrequency (ds.lpDSBPSG[i][1], 3579545 / (4 * iFreq) ) ;
						ds.lpDSBPSG[i][1]->lpVtbl->Play (ds.lpDSBPSG[i][1], 0, 0, DSBPLAY_LOOPING) ;
						}
					}
				}
			else
				{
				if (ds.lpDSBPSG[i][0])
					ds.lpDSBPSG[i][0]->lpVtbl->Stop (ds.lpDSBPSG[i][0]) ;

				if (ds.lpDSBPSG[i][1])
					ds.lpDSBPSG[i][1]->lpVtbl->Stop (ds.lpDSBPSG[i][1]) ;
				}
			}
		}
	
	snd.fUpdatePSG = FALSE ;
	}

void WritePSG (BYTE bReg, BYTE bVal)
	{
	if ( (bReg & 15) > 13)
		return ;

	snd.PSGReg[bReg & 15] = bVal ;
	snd.fUpdatePSG = TRUE ;
	}

// init and release stuff

BOOL SetSoundBuffer (LPDIRECTSOUNDBUFFER *ppDSB, BYTE *pdata, int iSize)
	{
	HRESULT			hr ;
	WAVEFORMATEX	wf ;
	DSBUFFERDESC	dsbd ;
	DWORD			dw ;
	WORD			*pwdata ;
	int				i, iTotal ;
	char			szBuf[256] ;

	iTotal = (ds.fUse16 ? iSize * 2 : iSize) ;

	if (*ppDSB == NULL)
		{
		wf.wFormatTag = WAVE_FORMAT_PCM ;
		wf.nChannels = 1 ;
		wf.nSamplesPerSec = 22050 ;
		if (ds.fUse16)
			{
			wf.nAvgBytesPerSec = 44100 ;
			wf.nBlockAlign = 2 ;
			wf.wBitsPerSample = 16 ;
			}
		else
			{
			wf.nAvgBytesPerSec = 22050 ;
			wf.nBlockAlign = 1 ;
			wf.wBitsPerSample = 8 ;
			}
		wf.cbSize = 0 ;

		memset (&dsbd, 0, sizeof (dsbd) ) ;
		dsbd.dwSize = sizeof (dsbd) ;
		dsbd.dwFlags = DSBCAPS_STATIC | DSBCAPS_CTRLDEFAULT | DSBCAPS_LOCHARDWARE ;
		dsbd.dwBufferBytes = iTotal ;
		dsbd.dwReserved = 0 ;
		dsbd.lpwfxFormat = &wf ;

		hr = ds.lpDS->lpVtbl->CreateSoundBuffer (ds.lpDS, &dsbd, ppDSB, NULL) ;

		if (hr != DS_OK)
			{
			*ppDSB = NULL ;

			wsprintf (szBuf, "Failed to create sound buffer (%d).", hr & 15) ;
			MessageBox (g_hwndMain, szBuf, "DirectSound problem", MB_ICONEXCLAMATION) ;

			return FALSE ;
			}
		}

	hr = (*ppDSB)->lpVtbl->Lock (*ppDSB, 0, iTotal, &pwdata, &dw, NULL, NULL, 0) ;
	
	if (hr == DSERR_BUFFERLOST)
		{
		if (DS_OK != (*ppDSB)->lpVtbl->Restore (*ppDSB) )
			return FALSE ;
		 
		hr = (*ppDSB)->lpVtbl->Lock (*ppDSB, 0, iTotal, &pwdata, &dw, NULL, NULL, 0) ;

		if (DS_OK != hr)
			{
			wsprintf (szBuf, "Failed to lock sound buffer (%d).", hr & 15) ;
			MessageBox (g_hwndMain, szBuf, "DirectSound problem", MB_ICONEXCLAMATION) ;

			return FALSE ;
			}
		}
	else if (hr != DS_OK)
		{
		wsprintf (szBuf, "Failed to lock sound buffer (%d).", hr & 15) ;
		MessageBox (g_hwndMain, szBuf, "DirectSound problem", MB_ICONEXCLAMATION) ;

		return FALSE ;
		}
	
	if (ds.fUse16)
		{
		for (i=0;i<iSize;i++)
			pwdata[i] = pdata[i] * 256 ;
		}
	else
		{
		memcpy (pwdata, pdata, iSize) ;
		}
	
	(*ppDSB)->lpVtbl->Unlock (*ppDSB, pwdata, dw, NULL, 0) ;
	
	return TRUE ;	
	}

BOOL InitSound (VOLSETTINGS *vol)
	{
	WAVEFORMATEX	wf ;
	DSBUFFERDESC	dsbd ;
	DSCAPS			dsc ;

	memset (&snd, 0, sizeof (snd) ) ;
	memset (&ds, 0, sizeof (ds) ) ;
 
	if (DS_OK != DirectSoundCreate (NULL, &ds.lpDS, NULL) )
		{
		MessageBox (g_hwndMain, "Failed to create DirectSound object.", 
			NULL, MB_ICONEXCLAMATION) ;

		return FALSE ;
		}

	/* some devives like the AWE32 don't support 8 bits, but do 
	   support 16 bit samples; om such devices, 16 bits samples 
	   should be used */
	dsc.dwSize = sizeof (dsc) ;
	if (DS_OK == ds.lpDS->lpVtbl->GetCaps (ds.lpDS, &dsc) )
		{
		ds.fUse16 = (dsc.dwFlags & DSCAPS_SECONDARY16BIT) && 
			!(dsc.dwFlags & DSCAPS_SECONDARY8BIT) ;
		}

	if (DS_OK != ds.lpDS->lpVtbl->SetCooperativeLevel (ds.lpDS, g_hwndMain, DSSCL_PRIORITY) )
		{
		MessageBox (g_hwndMain, "Failed to set cooperative level.", 
			NULL, MB_ICONEXCLAMATION) ;
		
		ds.lpDS->lpVtbl->Release (ds.lpDS) ;

		return FALSE ;
		}

	memset (&dsbd, 0, sizeof (dsbd) ) ;
	dsbd.dwSize = sizeof(dsbd) ;
	dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER ;

	if (DS_OK != ds.lpDS->lpVtbl->CreateSoundBuffer (ds.lpDS, &dsbd, &ds.lpDSBPrim, NULL) ) 
		{
		MessageBox (g_hwndMain, "Failed to create primary buffer.", 
			NULL, MB_ICONEXCLAMATION) ;
		
		ds.lpDS->lpVtbl->Release (ds.lpDS) ;

		return FALSE ;
		}

	wf.wFormatTag = WAVE_FORMAT_PCM ;
	wf.nChannels = 2 ;
	wf.nSamplesPerSec = 44100 ;
	wf.nAvgBytesPerSec = 44100 * 2 * 2 ;
	wf.nBlockAlign = 4 ;
	wf.wBitsPerSample = 16 ;
	wf.cbSize = 0 ;

	if (DS_OK != ds.lpDSBPrim->lpVtbl->SetFormat (ds.lpDSBPrim, &wf) )
		{
		MessageBox (g_hwndMain, "Failed to set format of primary buffer.", 
			NULL, MB_ICONEXCLAMATION) ;

		ds.lpDS->lpVtbl->Release (ds.lpDS) ;

		return FALSE ;
		}
	
	if (DS_OK != ds.lpDSBPrim->lpVtbl->Play (ds.lpDSBPrim, 0, 0, DSBPLAY_LOOPING) )
		{
		MessageBox (g_hwndMain, "Failed to play primary buffer.", 
			NULL, MB_ICONEXCLAMATION) ;
		
		ds.lpDS->lpVtbl->Release (ds.lpDS) ;

		return FALSE ;
		}
	
	ds.vol = *vol ;

	InitPPI () ;
	InitSCC () ;
	InitPSG () ;

	return TRUE ;
	}

void ReleaseSound ()
	{
	// we won't bother about the buffers.
	if (ds.lpDS)
		ds.lpDS->lpVtbl->Release (ds.lpDS) ;
	}

void UpdateSound ()
	{
	UpdatePPI () ;
	UpdateSCC () ;
	UpdatePSG () ;
	}

void ResetSound ()
	{
	memset (&snd, 0, sizeof (snd) ) ;
	UpdateSound () ;
	}
