// sound.h
#ifndef __INC_SOUND__

#define __INC_SOUND__

typedef struct tagVOLUME
	{
	BOOL	fEnable ;
	LONG	lPan, lVol ;
	} VOLUME ;

typedef struct tagVOLSETTINGS
	{
	VOLUME	PPI, PSG, SCC[4], FM ;
	} VOLSETTINGS ;

BOOL InitSound (VOLSETTINGS*) ;
void ReleaseSound () ;

void ResetSound () ;
void UpdateSound () ;

void MuteSound () ;
void SetSound (VOLSETTINGS*) ;

void WritePSG (BYTE bReg, BYTE bVal) ;
void WriteSCC (int type, BYTE bReg, BYTE bVal) ;
void WritePPI (BOOL) ;
void WriteFM (BYTE bReg, BYTE bVal) ;

#define SCC1_NORMAL		0
#define SCC1_SCCPN		1
#define SCC1_SCCPP		2
#define SCC2_NORMAL		4
#define SCC2_SCCPN		5
#define SCC2_SCCPP		6
#define SCC3_NORMAL		8
#define SCC3_SCCPN		9
#define SCC3_SCCPP		10
#define SCC4_NORMAL		12
#define SCC4_SCCPN		13
#define SCC4_SCCPP		14

#endif
