/*
**
**
** File: scc.h -- header file for software implementation of
**	Konami's SCC sound chip for MSX. SCC and SCC+.
**
** Made by: Sean Young. Made modular and support more than one SCC, and 
** support SCC+.
** Based on Sound.c in fMSX by (C) Ville Hallik (ville@physic.ut.ee) 1996
** Based on PSG emulator updates (C) 1996 Michael Cuddy, Fen's Ende Software.
** http://www.fensende.com/Users/mcuddy
*/

#ifndef _H_SCC_SCC_
#define _H_SCC_SCC_

/* generating signed or unsigned samples? */
//#define SCC_AUDIO_CONV(A) (0x80+(A))	/* use this macro for signed samples */
#define SCC_AUDIO_CONV(A) (A)		/* use this macro for unsigned samples */
//#define SCC_AUDIO_CONV16(A) (0x8000+(A))/* use this macro for signed samples */
#define SCC_AUDIO_CONV16(A) (A)	/* use this macro for unsigned samples */

/* comment this for no interpolation (faster) */
#define SCC_INTERPOLATE

/* the clock frequency the SCC gets thru clock signal. Should be 3579545 */
#ifndef SCC_CLOCK
#define SCC_CLOCK (3579545)
#endif /* SCC_CLOCK */

typedef unsigned char byte ;
typedef signed char sbyte ;
typedef unsigned short word ;
typedef signed short sword ;

#define SCC_MEGAROM	(0)	/* if emulating megarom SCC */
#define SCC_PLUSCOMP	(1)	/* if emulating SCC+ in compatiblity mode */
#define SCC_PLUSEXT	(2)	/* if emulating SCC+ in extended mode */

/* the registers */
#define SCC_1FINE	(0)
#define SCC_1COARSE	(1)
#define SCC_2FINE	(2)
#define SCC_2COARSE	(3)
#define SCC_3FINE	(4)
#define SCC_3COARSE	(5)
#define SCC_4FINE	(6)
#define SCC_4COARSE	(7)
#define SCC_5FINE	(8)
#define SCC_5COARSE	(9)
#define SCC_1VOL	(10)
#define SCC_2VOL	(11)
#define SCC_3VOL	(12)
#define SCC_4VOL	(13)
#define SCC_5VOL	(14)
#define SCC_ENABLE	(15)
#define SCC_DEFORM	(16)

/* the virtual SCC */
typedef struct SCC_f SCC ;

struct SCC_f {
    void	*Buf ;
    int		UserBuffer ; /* if user provided buffer */
    byte	Regs[17] ;
    byte	Waves[5*32] ;

    /* state variables */
    int		Counter0, Counter1, Counter2, Counter3, Counter4 ;
} ;

/*
** Initialize SCC emulator(s).
**
** 'num' is the number of virtual SCC's to allocate 'freq' is 
** sampling frequency, 'rate' is 16 or 8 bit sampling rate and 
** 'bufsiz' is the size of the buffer that should be updated at 
** each interval varargs are user-supplied buffers, one for each 
** SCC (or NULL to let SCC library allocate buffers)
*/
int SCCInit (int num, int freq, int rate, int bufsiz, ...) ;

/*
** shutdown the SCC emulators .. make sure that no sound system stuff
** is touching our audio buffers ...
*/
void SCCShutdown (void) ;

/*
** reset all chip registers for SCC number 'num' 
*/
void SCCResetChip (int num) ;

/*
** called to update all chips; should be called about 50 - 70 times per
** second ... (depends on sample rate and buffer size). 'part' is the
** number of samples that should be generated. If set to 0, the maximum
** buffersize is used.
*/
void SCCUpdate (int part) ;

/*
** return pointer to synthesized data
*/
void* SCCBuffer(int n);

/*
** write value 'v' in register 'r' on SCC 'n' of type 't' 
*/
void SCCWriteReg (int n, int r, byte v, int t) ;

#endif /* _H_SCC_SCC_ */

/*
** change log
*/
