// z80.h : c translation of z80.inc

#pragma pack(1)

int DoZ80 (void) ;
void DoZ80Step (void) ;

#define FLAG_C		0x01
#define FLAG_N		0x02
#define FLAG_P		0x04
#define FLAG_V		0x04
#define FLAG_3		0x08
#define FLAG_H		0x10
#define FLAG_5		0x20
#define FLAG_Z		0x40
#define FLAG_S		0x80

#define IFF_RESET	0
#define IFF_SET		(FLAG_P)

typedef struct tagZ80STATE
	{
	WORD	rAF, rBC, rDE, rHL, rIX, rIY ;
	WORD	rAF_, rBC_, rDE_, rHL_, rPC, rSP ;
	DWORD	dwTstates ;
	WORD	wIM, rIR ;
	BYTE	fIFF, fINT, fNoInt ;
	} Z80STATE ;

#define T_60HZ		(3579545 / 60)
#define T_50HZ		(3579545 / 50)

#pragma pack()

