; ****************************************************************************
; z80.inc : z80 emulation header
; ****************************************************************************

DoZ80		PROTO C
DoZ80Step	PROTO C

BIT_0		EQU 0001H
BIT_1		EQU 0002H
BIT_2		EQU 0004H
BIT_3		EQU 0008H
BIT_4		EQU 0010H
BIT_5		EQU 0020H
BIT_6		EQU 0040H
BIT_7		EQU 0080H
BIT_8		EQU 0100H
BIT_9		EQU 0200H
BIT_10		EQU 0400H
BIT_11		EQU 0800H
BIT_12		EQU 1000H
BIT_13		EQU 2000H
BIT_14		EQU 4000H
BIT_15		EQU 8000H

FLAG_C		EQU 01H
FLAG_N		EQU 02H
FLAG_P		EQU 04H
FLAG_V		EQU 04H
FLAG_3		EQU 08H
FLAG_H		EQU 10H
FLAG_5		EQU 20H
FLAG_Z		EQU 40H
FLAG_S		EQU 80H

IFF_RESET	EQU 0
IFF_SET		EQU (FLAG_P)

Z80STATE struct
	union
	 rAF		WORD	0
	 struct
	  rF		BYTE	0
	  rA		BYTE	0
	 ends
	ends
	union
	 rBC		WORD	0
	 struct
	  rC		BYTE	0
	  rB		BYTE	0
	 ends
	ends
	union
	 rDE		WORD	0
	 struct
	  rE		BYTE	0
	  rD		BYTE	0
	 ends
	ends
	union
	 rHL		WORD	0
	 struct
	  rL		BYTE	0
	  rH		BYTE	0
	 ends
	ends
	union
	 rIX		WORD	0
	 struct
	  rIXl		BYTE	0
	  rIXh		BYTE	0
	 ends
	ends
	union
	 rIY		WORD	0
	 struct
	  rIYl		BYTE	0
	  rIYh		BYTE	0
	 ends
	ends
	rAF_		WORD	0
	rBC_		WORD	0
	rDE_		WORD	0
	rHL_		WORD	0
	rPC		WORD	0
	rSP		WORD	0
	dwTstates	DWORD	0
	wIM		WORD	0
	union
	 rIR		WORD	0
	 struct
	  rR		BYTE	0
	  rI		BYTE	0
	 ends
	ends
	fIFF		BYTE	0
	fINT		BYTE	0	; INT pin high if set
	fNoINT		BYTE	0	; nonzero if no int for next instruction (after EI)
Z80STATE ends
