Unit AVI;

Interface

Type
  TFourCC = Packed Array[0..3] Of Char;

Const
  CC_hdrl : TFourCC = ('h','d','r','l');
  CC_avih : TFourCC = ('a','v','i','h');
  CC_iavs : TFourCC = ('i','a','v','s');
  CC_vids : TFourCC = ('v','i','d','s');
  CC_auds : TFourCC = ('a','u','d','s');
  CC_dvsd : TFourCC = ('d','v','s','d');
  CC_dvhd : TFourCC = ('d','v','h','d');
  CC_dvsl : TFourCC = ('d','v','s','l');
  CC_strh : TFourCC = ('s','t','r','h');
  CC_strf : TFourCC = ('s','t','r','f');
  CC_strl : TFourCC = ('s','t','r','l');
  CC_LIST : TFourCC = ('L','I','S','T');
  CC_RIFF : TFourCC = ('R','I','F','F');
  CC_AVI  : TFourCC = ('A','V','I',' ');
  CC_movi : TFourCC = ('m','o','v','i');
  CC_00dc : TFourCC = ('0','0','d','c');
  CC_01dc : TFourCC = ('0','1','d','c');
  CC_00db : TFourCC = ('0','0','d','b');
  CC_01db : TFourCC = ('0','1','d','b');
  CC_01wb : TFourCC = ('0','1','w','b');
  CC_idx1 : TFourCC = ('i','d','x','1');
  CC_RLE  : TFourCC = ('R','L','E',' ');
  CC_DIB  : TFourCC = ('D','I','B',' ');
  CC_none : TFourCC = (' ',' ',' ',' ');

  AVIF_HASINDEX       = $00000010;
  AVIF_MUSTUSEINDEX   = $00000020;
  AVIF_ISINTERLEAVED  = $00000100;
  AVIF_TRUSTCKTYPE    = $00000800;
  AVIF_WASCAPTUREFILE = $00010000;
  AVIF_COPYRIGHTED    = $00020000;  

  AVIIF_KEYFRAME = $00000010;

Type
  TAVIRect = Packed Record
    Left,Top,Right,Bottom: Word;
  End;
  TChunk = Packed Record
    FourCC : TFourCC;
    dwSize : LongInt;
  End;
  TMainAVIHeader = Packed Record
    dwMicroSecPerFrame    : LongInt;
    dwMaxBytesPerSec      : LongInt;
    dwPaddingGranularity  : LongInt;
    dwFlags               : LongInt;
    dwTotalFrames         : LongInt;
    dwInitialFrames       : LongInt;
    dwStreams             : LongInt;
    dwSuggestedBufferSize : LongInt;
    dwWidth               : LongInt;
    dwHeight              : LongInt;
    dwReserved            : Array[0..3] Of LongInt;
  End;
  TAVIHeader = Packed Record
    Chunk                 : TChunk;              { "avih" }
    Header                : TMainAVIHeader;
  End;
  TAVIStreamHeader = Packed Record
    fccType               : TFourCC;             { "iavs"/"vids"/"auds" }
    fccHandler            : TFourCC;             { "dvsd"/"RLE " }
    dwFlags               : LongInt;
    wPriority             : Word;
    wLanguage             : Word;
    dwInitialFrames       : LongInt;
    dwScale               : LongInt;
    dwRate                : LongInt;
    dwStart               : LongInt;
    dwLength              : LongInt;
    dwSuggestedBufferSize : LongInt;
    dwQuality             : LongInt;
    dwSampleSize          : LongInt;
    rcFrame               : TAVIRect;
  End;
  TStreamHeader = Packed Record
    Chunk                 : TChunk;              { "strh" }
    StreamHeader          : TAVIStreamHeader;
  End;
  TDVInfo = Packed Record
    dwDVAAuxSrc           : LongInt;
    dwDVAAuxCtl           : LongInt;
    dwDVAAuxSrc1          : LongInt;
    dwDVAAuxCtl1          : LongInt;
    dwDVVAuxSrc           : LongInt;
    dwDVVAuxCtl           : LongInt;
    dwDVReserved          : Array[0..1] Of LongInt;
  End;
  BITMAPFILEHEADER = Record
    bfType      : Array[0..1] Of Char;
    bfSize      : LongInt;
    bfReserved1 : Word;
    bfReserved2 : Word;
    bfOffBits   : LongInt;
  End;
  BITMAPINFOHEADER = Record
    biSize          : LongInt;
    biWidth         : LongInt;
    biHeight        : LongInt;
    biPlanes        : Word;
    biBitCount      : Word;
    biCompression   : LongInt;
    bisizeImage     : LongInt;
    biXPelsPerMeter : LongInt;
    biYPelsPerMeter : LongInt;
    biClrUsed       : LongInt;
    biClrImportant  : LongInt;
  End;
  RGBQuad = Record
    B,G,R,Reserved : Byte;
  End;
  TBitmapInfo = Packed Record
    bmiHeader             : BITMAPINFOHEADER;
    bmiColors             : Array[0..255] Of RGBQuad;
  End;
  TWaveFormatEx = Packed Record
    wFormatTag            : Word;
    nChannels             : Word;
    nSamplesPerSec        : LongInt;
    nAvgBytesPerSec       : LongInt;
    nBlockAlign           : Word;
    wBitsPerSample        : Word;
    cbSize                : Word;
  End;
  TStreamFormatDV = Packed Record
    Chunk                 : TChunk;              { "strf" }
    DVInfo                : TDVInfo;
  End;
  TStreamFormatV = Packed Record
    Chunk                 : TChunk;              { "strf" }
    BI                    : TBitmapInfo;
    DVInfo                : TDVInfo;
  End;
  TStreamFormatA = Packed Record
    Chunk                 : TChunk;              { "strf" }
    waveFmt               : TWaveFormatEx;
  End;
  TStreamListDV = Packed Record
    Chunk                 : TChunk;              { "LIST" }
    strl                  : TFourCC;             { "strl" }
    StreamHeader          : TStreamHeader;
    StreamFormat          : TStreamFormatDV;
  End;
  TStreamListV = Packed Record
    Chunk                 : TChunk;              { "LIST" }
    strl                  : TFourCC;             { "strl" }
    StreamHeader          : TStreamHeader;
    StreamFormat          : TStreamFormatV;
  End;
  TStreamListA = Packed Record
    Chunk                 : TChunk;              { "LIST" }
    strl                  : TFourCC;             { "strl" }
    StreamHeader          : TStreamHeader;
    StreamFormat          : TStreamFormatA;
  End;
  THeaderList = Packed Record
    Chunk                 : TChunk;              { "LIST" }
    hdrl                  : TFourCC;             { "hdrl" }
    AVIHeader             : TAVIHeader;
  End;
  TRIFF = Packed Record
    Chunk                 : TChunk;              { "RIFF" }
    AVI                   : TFourCC;             { "AVI " }
    HeaderList            : THeaderList;
  End;
  TMovI = Packed Record
    Chunk                 : TChunk;              { "LIST" }
    movi                  : TFourCC;             { "movi" }
  End;
  TIndex = Packed Record
    FourCC   : TFourCC;
    L1,L2,L3 : LongInt;
  End;

Implementation

End.

// ----------------------------------------------------------------------
// PCAE and PCAEWin - PC Atari Emulator - Atari 2600 emulator
// Copyright (C) 2000 John Dullea
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------