unit frmPrefsUnt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, PathDialog;

type
  TfrmPrefs = class(TForm)
    cbAutoCenter: TCheckBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    edtFPS: TEdit;
    cbPitfall2: TCheckBox;
    btnOK: TBitBtn;
    rbCol1: TRadioButton;
    rbCol2: TRadioButton;
    rbCol3: TRadioButton;
    rbCol4: TRadioButton;
    rbCol5: TRadioButton;
    rbCol6: TRadioButton;
    rbDis1: TRadioButton;
    rbDis2: TRadioButton;
    rbDis3: TRadioButton;
    rbDis4: TRadioButton;
    rbDis5: TRadioButton;
    rbDis6: TRadioButton;
    rbDis7: TRadioButton;
    rbDis8: TRadioButton;
    Label2: TLabel;
    Label3: TLabel;
    GroupBox3: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    dlgFont: TFontDialog;
    Label9: TLabel;
    cbSound: TCheckBox;
    BitBtn1: TBitBtn;
    cbAlternateMenu: TCheckBox;
    cbUseDefaultSize: TCheckBox;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    cbHideAllOnZoomFull: TCheckBox;
    cbShowFPS: TCheckBox;
    Label13: TLabel;
    cbFG1: TColorBox;
    cbBG1: TColorBox;
    cbFG2: TColorBox;
    cbBG2: TColorBox;
    lmdbeGamePath: TEdit;
    btnGamePath: TSpeedButton;
    dlgPath: TPathDialog;
    lmdbeShotPath: TEdit;
    btnShotPath: TSpeedButton;
    lmdbeBoxFrontScanPath: TEdit;
    btnBoxFrontScanPath: TSpeedButton;
    lmdbeBoxBackScanPath: TEdit;
    btnBoxBackScanPath: TSpeedButton;
    lmdbeBoxSideScanPath: TEdit;
    btnBoxSideScanPath: TSpeedButton;
    lmdbeCartScanPath: TEdit;
    btnCartScanPath: TSpeedButton;
    lmdbeManualPath: TEdit;
    btnManualPath: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnGamePathClick(Sender: TObject);
    procedure btnShotPathClick(Sender: TObject);
    procedure btnBoxFrontScanPathClick(Sender: TObject);
    procedure btnBoxBackScanPathClick(Sender: TObject);
    procedure btnBoxSideScanPathClick(Sender: TObject);
    procedure btnCartScanPathClick(Sender: TObject);
    procedure btnManualPathClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPrefs: TfrmPrefs;

implementation

{$R *.DFM}

Uses frmMenuUnt,HandTIA, frmDebuggerunt, frmTIARefUnt,
     frmExpRefUnt, HexWrite;

procedure TfrmPrefs.FormShow(Sender: TObject);
{
  Procedure SetCustomColor(C: TLMDColorEdit);
  Begin
    While C.CustomColors.Count > 0 Do C.CustomColors.Delete(0);
    C.CustomColors.Add('ColorA=' + Copy(C.Text,Length(C.Text) - 5,6));
  End; // SetCustomColor

  Function MyColorToString(C: TColor): String;
  Begin
    MyColorToString := '$00' + HexByte(TRGBQuad(C).rgbRed) +
                               HexByte(TRGBQuad(C).rgbGreen) +
                               HexByte(TRGBQuad(C).rgbBlue);
  End; // MyColorToString
}
begin
  Case Config.MenuDisplayScheme Of
      dsNameExt4: rbDis1.Checked := True;
      dsNameExt3: rbDis2.Checked := True;
      dsNameExt2: rbDis3.Checked := True;
     dsNameOnly4: rbDis4.Checked := True;
     dsNameOnly3: rbDis5.Checked := True;
     dsNameOnly2: rbDis6.Checked := True;
  dsRealNameLeft: rbDis7.Checked := True;
dsRealNameCenter: rbDis8.Checked := True;
  End; // Case

  Case Config.MenuColorScheme Of
    csGameType: rbCol1.Checked := True;
csAlphabetical: rbCol2.Checked := True;
      csEvery3: rbCol3.Checked := True;
      csEvery4: rbCol4.Checked := True;
      csEvery5: rbCol5.Checked := True;
      csEvery6: rbCol6.Checked := True;
  End; // Case

  cbAutoCenter.Checked        := Config.AutoCenter;
  cbPitfall2.Checked          := Config.Pitfall2DSP;
  cbSound.Checked             := Config.DoSound;
  cbAlternateMenu.Checked     := Config.AlternateGameMenu;
  cbUseDefaultSize.Checked    := Config.UseDefaultSize;
  cbHideAllOnZoomFull.Checked := Config.HideAllOnZoomFull;
  cbShowFPS.Checked           := Config.ShowFPS;
  edtFPS.Text                 := IntToStr(Config.FrameRate);
  lmdbeGamePath.Text          := Config.GamePath;
  lmdbeShotPath.Text          := Config.ScreenShotPath;
  lmdbeBoxFrontScanPath.Text  := Config.BoxFrontScanPath;
  lmdbeBoxBackScanPath.Text   := Config.BoxBackScanPath;
  lmdbeBoxSideScanPath.Text   := Config.BoxSideScanPath;
  lmdbeCartScanPath.Text      := Config.CartScanPath;
  lmdbeManualPath.Text        := Config.ManualPath;
  cbFG1.Selected              := Config.MenuForeColor1;
  cbBG1.Selected              := Config.MenuBackColor1;
  cbFG2.Selected              := Config.MenuForeColor2;
  cbBG2.Selected              := Config.MenuBackColor2;
//  lmdceF1.Text                := MyColorToString(Config.MenuForeColor1);
//  lmdceB1.Text                := MyColorToString(Config.MenuBackColor1);
//  lmdceF2.Text                := MyColorToString(Config.MenuForeColor2);
//  lmdceB2.Text                := MyColorToString(Config.MenuBackColor2);

//  SetCustomColor(lmdceF1);
//  SetCustomColor(lmdceB1);
//  SetCustomColor(lmdceF2);
//  SetCustomColor(lmdceB2);
end;

procedure TfrmPrefs.btnOKClick(Sender: TObject);
Var I,J: Integer;
begin
  If rbDis1.Checked Then Config.MenuDisplayScheme := dsNameExt4 Else
   If rbDis2.Checked Then Config.MenuDisplayScheme := dsNameExt3 Else
    If rbDis3.Checked Then Config.MenuDisplayScheme := dsNameExt4 Else
     If rbDis4.Checked Then Config.MenuDisplayScheme := dsNameOnly4 Else
      If rbDis5.Checked Then Config.MenuDisplayScheme := dsNameOnly3 Else
       If rbDis6.Checked Then Config.MenuDisplayScheme := dsNameOnly2 Else
        If rbDis7.Checked Then Config.MenuDisplayScheme := dsRealNameLeft Else
         If rbDis8.Checked Then Config.MenuDisplayScheme := dsRealNameCenter;

  If rbCol1.Checked Then Config.MenuColorScheme := csGameType Else
   If rbCol2.Checked Then Config.MenuColorScheme := csAlphabetical Else
    If rbCol3.Checked Then Config.MenuColorScheme := csEvery3 Else
     If rbCol4.Checked Then Config.MenuColorScheme := csEvery4 Else
      If rbCol5.Checked Then Config.MenuColorScheme := csEvery5 Else
       If rbCol6.Checked Then Config.MenuColorScheme := csEvery6;

  Config.AutoCenter  := cbAutoCenter.Checked;
  Config.Pitfall2DSP := cbPitfall2.Checked;
  Val(Trim(edtFPS.Text),I,J);
  If (J = 0) And (I >= 0) And (I <= 600) Then Config.FrameRate := I;
  If Trim(edtFPS.Text) = '' Then Config.FrameRate := 0;
  Config.MenuForeColor1    := cbFG1.Selected;//StringToColor(lmdceF1.Text);
  Config.MenuBackColor1    := cbBG1.Selected;//StringToColor(lmdceB1.Text);
  Config.MenuForeColor2    := cbFG2.Selected;//StringToColor(lmdceF2.Text);
  Config.MenuBackColor2    := cbBG2.Selected;//StringToColor(lmdceB2.Text);
  Config.GamePath          := lmdbeGamePath.Text;
  Config.ScreenShotPath    := lmdbeShotPath.Text;
  Config.BoxFrontScanPath  := lmdbeBoxFrontScanPath.Text;
  Config.BoxBackScanPath   := lmdbeBoxBackScanPath.Text;
  Config.BoxSideScanPath   := lmdbeBoxSideScanPath.Text;
  Config.CartScanPath      := lmdbeCartScanPath.Text;
  Config.ManualPath        := lmdbeManualPath.Text;
  Config.DoSound           := cbSound.Checked;
  Config.AlternateGameMenu := cbAlternateMenu.Checked;
  Config.UseDefaultSize    := cbUseDefaultSize.Checked;
  Config.HideAllOnZoomFull := cbHideAllOnZoomFull.Checked;
  Config.ShowFPS           := cbShowFPS.Checked;
  frmMenu.SaveConfiguration(Config,Version);
end;

procedure TfrmPrefs.BitBtn2Click(Sender: TObject);
begin
  dlgFont.Font.Name  := frmMenu.Font.Name;
  dlgFont.Font.Size  := frmMenu.Font.Size;
  dlgFont.Font.Style := frmMenu.Font.Style;
  If dlgFont.Execute Then
  Begin
    frmMenu.Font.Name  := dlgFont.Font.Name;
    frmMenu.Font.Size  := dlgFont.Font.Size;
    frmMenu.Font.Style := dlgFont.Font.Style;
    frmMenu.SaveConfiguration(Config,Version);
  End;
end;

procedure TfrmPrefs.BitBtn3Click(Sender: TObject);
begin
  dlgFont.Font.Name  := FontName;
  dlgFont.Font.Size  := FontSize;
  dlgFont.Font.Style := FontStyle;
  If dlgFont.Execute Then
  Begin
    FontName  := dlgFont.Font.Name;
    FontSize  := dlgFont.Font.Size;
    FontStyle := dlgFont.Font.Style;
    frmDebugger.Font.Name := FontName;
    frmDebugger.Font.Size := FontSize;
    frmTIARef.Font.Name := FontName;
    frmTIARef.Font.Size := FontSize;
    frmExpRef.Font.Name := FontName;
    frmExpRef.Font.Size := FontSize;
    If frmDebugger.Visible Then frmDebugger.FormResize(Self);
    frmMenu.SaveConfiguration(Config,Version);
  End;
end;

procedure TfrmPrefs.FormCreate(Sender: TObject);
begin
  Scaled := False;
end;

procedure TfrmPrefs.btnGamePathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeGamePath.Text;
  If dlgPath.Execute Then lmdbeGamePath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnShotPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeShotPath.Text;
  If dlgPath.Execute Then lmdbeShotPath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnBoxFrontScanPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeBoxFrontScanPath.Text;
  If dlgPath.Execute Then lmdbeBoxFrontScanPath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnBoxBackScanPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeBoxBackScanPath.Text;
  If dlgPath.Execute Then lmdbeBoxBackScanPath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnBoxSideScanPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeBoxSideScanPath.Text;
  If dlgPath.Execute Then lmdbeBoxSideScanPath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnCartScanPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeCartScanPath.Text;
  If dlgPath.Execute Then lmdbeCartScanPath.Text := dlgPath.Directory;
end;

procedure TfrmPrefs.btnManualPathClick(Sender: TObject);
begin
  dlgPath.Directory := lmdbeManualPath.Text;
  If dlgPath.Execute Then lmdbeManualPath.Text := dlgPath.Directory;
end;

end.

// ----------------------------------------------------------------------
// PCAE and PCAEWin - PC Atari Emulator - Atari 2600 emulator
// Copyright (C) 2000 John Dullea
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------
