unit frmProfileSettingsUnt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Profile, ExtCtrls;

type
  TfrmProfileSettings = class(TForm)
    lblFilename: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    edtTitle: TEdit;
    GroupBox1: TGroupBox;
    rb2k: TRadioButton;
    rb4k: TRadioButton;
    rb8k: TRadioButton;
    rb16k: TRadioButton;
    rbSuperChip: TRadioButton;
    rbParkerBros: TRadioButton;
    rbMNetwork: TRadioButton;
    rbStarpath: TRadioButton;
    rbCBS: TRadioButton;
    rbTigerVision: TRadioButton;
    rbPitfall2: TRadioButton;
    rbActivision: TRadioButton;
    GroupBox2: TGroupBox;
    rbJoystick: TRadioButton;
    rbPaddle: TRadioButton;
    rbVTP: TRadioButton;
    rbDriving: TRadioButton;
    rbKeyboard: TRadioButton;
    rbUnknownCart: TRadioButton;
    rbUnknownCont: TRadioButton;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    edt200: TEdit;
    edt204: TEdit;
    edt215: TEdit;
    edt250: TEdit;
    edt305: TEdit;
    rbMegaBoy: TRadioButton;
    rb32In1: TRadioButton;
    rbBooster: TRadioButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label8: TLabel;
    edtManufacturer: TEdit;
    Label9: TLabel;
    edtYear: TEdit;
    Label10: TLabel;
    cbSize: TComboBox;
    Label11: TLabel;
    cbPalette: TComboBox;
    rbCommaVid: TRadioButton;
    rbCompumate: TRadioButton;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProfileSettings: TfrmProfileSettings;

implementation

{$R *.DFM}

Uses HandTIA, frmMenuunt, frmMainunt;

procedure TfrmProfileSettings.FormShow(Sender: TObject);
Var
  I     : Integer;
  Index : Integer;
  Found : Boolean;

  Function GetPos(I: Integer): String;
  Begin
    If I <> NoPosSet Then GetPos := IntToStr(I) Else GetPos := '';
  End; // GetPos

begin
  lblFileName.Caption := ExtractFileName(MenuInfo.FileName);
  Index               := -1;
  If MenuInfo.ProfileRec <> Nil Then
  Begin
    edtTitle.Text        := MenuInfo.ProfileRec.RealName;
    edtManufacturer.Text := MenuInfo.ProfileRec.Manufacturer;
    If MenuInfo.ProfileRec.Year <> 0
     Then edtYear.Text := IntToStr(MenuInfo.ProfileRec.Year)
     Else edtYear.Text := '';
    Case MenuInfo.ProfileRec.Cart Of
         ct2k: rb2k.Checked          := True;
         ct4k: rb4k.Checked          := True;
         ct8k: rb8k.Checked          := True;
        ct16k: rb16k.Checked         := True;
  ctSuperChip: rbSuperChip.Checked   := True;
 ctParkerBros: rbParkerBros.Checked  := True;
   ctMNetwork: rbMNetwork.Checked    := True;
   ctStarpath: rbStarpath.Checked    := True;
        ctCBS: rbCBS.Checked         := True;
ctTigerVision: rbTigerVision.Checked := True;
   ctPitfall2: rbPitfall2.Checked    := True;
 ctActivision: rbActivision.Checked  := True;
    ctMegaBoy: rbMegaboy.Checked     := True;
      ct32In1: rb32In1.Checked       := True;
   ctCommaVid: rbCommaVid.Checked    := True;
  ctCompumate: rbCompumate.Checked   := True;
    Else
      rbUnknownCart.Checked := True;
    End; // Case
    Case MenuInfo.ProfileRec.Cont Of
crJoystick: rbJoystick.Checked := True;
  crPaddle: rbPaddle.Checked   := True;
     crVTP: rbVTP.Checked      := True;
 crDriving: rbDriving.Checked  := True;
crKeyboard: rbKeyboard.Checked := True;
 crBooster: rbBooster.Checked  := True;
    Else
      rbUnknownCont.Checked := True;
    End; // Case
    I := 0;
    Found := False;
    While (I < cbSize.Items.Count) And Not Found Do
    Begin
      If IntToStr(MenuInfo.ProfileRec.DefaultSize) = cbSize.Items.Strings[I]
       Then Found := True
       Else Inc(I);
    End; // While
    If Found Then Index := I;
    cbPalette.ItemIndex := Integer(MenuInfo.ProfileRec.Palette) - 1;
  End
  Else
  Begin
    edtTitle.Text         := '';
    rbUnknownCart.Checked := True;
    rbUnknownCont.Checked := True;
    edtManufacturer.Text  := '';
    edtYear.Text          := '';
    cbPalette.ItemIndex   := -1;
  End;
  edt200.Text := GetPos(MenuInfo.Pos200);
  edt204.Text := GetPos(MenuInfo.Pos204);
  edt215.Text := GetPos(MenuInfo.Pos215);
  edt250.Text := GetPos(MenuInfo.Pos250);
  edt305.Text := GetPos(MenuInfo.Pos305);
  cbSize.ItemIndex := Index;
end;

procedure TfrmProfileSettings.btnOKClick(Sender: TObject);
Var
  UPos         : Integer;
  RealName     : String;
  Path         : String;
  Dir          : String;
  Name         : String;
  I            : Integer;
  Manufacturer : String;
  Year         : Integer;
  DefaultSize  : Integer;

  Function GetPos(St: String): Integer;
  Var I,J: Integer;
  Begin
    St := Trim(St);
    If St <> '' Then
    Begin
      Val(St,I,J);
      If J = 0 Then GetPos := I Else GetPos := NoPosSet;
    End
    Else GetPos := NoPosSet;
  End; // GetPos

  Function GetNum(St: String): Integer;
  Var I,J: Integer;
  Begin
    St := Trim(St);
    If St <> '' Then
    Begin
      Val(St,I,J);
      If J = 0 Then GetNum := I Else GetNum := 0;
    End
    Else GetNum := 0;
  End; // GetYear

begin
       If rb2k.Checked          Then Game.Cart := ct2k
  Else If rb4k.Checked          Then Game.Cart := ct4k
  Else If rb8k.Checked          Then Game.Cart := ct8k
  Else If rb16k.Checked         Then Game.Cart := ct16k
  Else If rbSuperChip.Checked   Then Game.Cart := ctSuperChip
  Else If rbParkerBros.Checked  Then Game.Cart := ctParkerBros
  Else If rbMNetwork.Checked    Then Game.Cart := ctMNetwork
  Else If rbStarpath.Checked    Then Game.Cart := ctStarpath
  Else If rbCBS.Checked         Then Game.Cart := ctCBS
  Else If rbTigerVision.Checked Then Game.Cart := ctTigerVision
  Else If rbPitfall2.Checked    Then Game.Cart := ctPitfall2
  Else If rbActivision.Checked  Then Game.Cart := ctActivision
  Else If rbMegaBoy.Checked     Then Game.Cart := ctMegaBoy
  Else If rb32In1.Checked       Then Game.Cart := ct32In1
  Else If rbCommaVid.Checked    Then Game.Cart := ctCommaVid
  Else If rbCompumate.Checked   Then Game.Cart := ctCompumate
  Else Game.Cart := ctUnknown;

       If rbJoystick.Checked    Then Game.Controller := crJoystick
  Else If rbPaddle.Checked      Then Game.Controller := crPaddle
  Else If rbVTP.Checked         Then Game.Controller := crVTP
  Else If rbDriving.Checked     Then Game.Controller := crDriving
  Else If rbKeyboard.Checked    Then Game.Controller := crKeyboard
  Else If rbBooster.Checked     Then Game.Controller := crBooster
  Else Game.Controller := crUnknown;

  If Game.UserSetPos = NoPosSet Then UPos := 0 Else UPos := Game.UserSetPos;
  If Config.AutoCenter
   Then Game.UserSetPos := Game.VUserAdd + UPos + Game.VAdd
   Else Game.UserSetPos := Game.VUserAdd + UPos;
  Game.VUserAdd := 0;
  Case (Config.MaxRows - 200) Of
     0: frmMain.Pos200 := Game.UserSetPos;
     4: frmMain.Pos204 := Game.UserSetPos;
    15: frmMain.Pos215 := Game.UserSetPos;
    50: frmMain.Pos250 := Game.UserSetPos;
   105: frmMain.Pos305 := Game.UserSetPos;
  Else
    frmMain.Pos200 := Game.UserSetPos;
  End; { Case }
  RealName     := Trim(edtTitle.Text);
  Manufacturer := Trim(edtManufacturer.Text);
  Year         := GetNum(edtYear.Text);
  If (cbSize.ItemIndex >= 0) And (cbSize.itemIndex < cbSize.Items.Count)
   Then DefaultSize := GetNum(cbSize.Items[cbSize.ItemIndex])
   Else DefaultSize := 0;

  // Remove double quotes from title (switch to single quotes)

  For I := 1 To Length(RealName) Do If RealName[I] = '"' Then RealName[I] := '''';

  frmMain.Pos200 := GetPos(edt200.Text);
  frmMain.Pos204 := GetPos(edt204.Text);
  frmMain.Pos215 := GetPos(edt215.Text);
  frmMain.Pos250 := GetPos(edt250.Text);
  frmMain.Pos305 := GetPos(edt305.Text);

  // Save profile information

  If MenuInfo.ProfileRec = Nil Then
  Begin
    Path := ExpandFileName(UpperCase(MenuInfo.FileName));
    Name := ExtractFileName(Path);
    Dir  := ExtractFilePath(Path);
    AddToProfile(Name,RealName,Game.Cart,Game.Controller,
                 frmMain.Pos200,frmMain.Pos204,frmMain.Pos215,frmMain.Pos250,frmMain.Pos305,
                 Manufacturer,Year,DefaultSize,TPaletteDef(cbPalette.ItemIndex + 1));
    Game.Cart := FindProfile(ExtractFileName(MenuInfo.FileName),MenuInfo.Cont,MenuInfo.Pos200,MenuInfo.Pos204,
                             MenuInfo.Pos215,MenuInfo.Pos250,MenuInfo.Pos305,MenuInfo.ProfileRec);
  End;
  MakeProfile(ExtractFilePath(Application.ExeName));

  MenuInfo.ProfileRec.Cart         := Game.Cart;
  MenuInfo.ProfileRec.Cont         := Game.Controller;
  MenuInfo.ProfileRec.RealName     := RealName;
  MenuInfo.ProfileRec.Pos200       := frmMain.Pos200;
  MenuInfo.ProfileRec.Pos204       := frmMain.Pos204;
  MenuInfo.ProfileRec.Pos215       := frmMain.Pos215;
  MenuInfo.ProfileRec.Pos250       := frmMain.Pos250;
  MenuInfo.ProfileRec.Pos305       := frmMain.Pos305;
  MenuInfo.ProfileRec.Manufacturer := Manufacturer;
  MenuInfo.ProfileRec.Year         := Year;
  MenuInfo.ProfileRec.DefaultSize  := DefaultSize;
  MenuInfo.ProfileRec.Palette      := TPaletteDef(cbPalette.ItemIndex + 1);
  MenuInfo.Title                   := RealName;

//  PosSet := True;  // Trigger profile rebuild on program exit
end;

procedure TfrmProfileSettings.FormCreate(Sender: TObject);
begin
  Scaled := False;
end;

end.

// ----------------------------------------------------------------------
// PCAE and PCAEWin - PC Atari Emulator - Atari 2600 emulator
// Copyright (C) 2000 John Dullea
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------
