unit DXshadow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DXDraws, DXclass, DirectX, ExtCtrls, StdCtrls;

type
  TfrmDX = class(TDXForm)
    DXDraw: TDXDraw;
    DXTimer1: TDXTimer;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    ScrollBar1: TScrollBar;
    procedure DXDrawInitialize(Sender: TObject);
    procedure DXTimer1Timer(Sender: TObject; LagCount: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    SceneMeshBuilder      :Idirect3DRMMeshBuilder;
    ObjectMesh            :Idirect3DRMMeshBuilder;
    SceneFrame            :IDirect3DRMFrame;
    Light                 :Idirect3DRMLight;
    LightFrame            :Idirect3DRMFrame;
    PlaneFrame            :IDirect3DRMFrame;
    SphereFrame           :IDirect3DRMFrame;
    Shadow                :Idirect3DRMVisual;


  end;

var
  frmDX: TfrmDX;
  filename:string;
implementation

{$R *.DFM}

procedure TfrmDX.DXDrawInitialize(Sender: TObject);
begin
DXtimer1.Enabled:=false;
{create meshbulder}
DXdraw.D3DRM.CreateMeshBuilder(SceneMeshBuilder);
DXdraw.D3DRM.CreateMeshBuilder(ObjectMesh);
{create frame}
DXdraw.D3DRM.CreateFrame(DXdraw.scene,LightFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,SceneFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,SphereFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,PlaneFrame);
{setup view}
DXdraw.Camera.SetPosition(DXdraw.scene,0,5,-30);
{direction in Z axes    UP vector in Y axes }
DXdraw.Camera.SetOrientation(DXdraw.scene,0,0,1,0,1,0);
DXtimer1.Enabled:=true;
{default scene light}
DXDraw.D3DRM.CreateLightRGB(D3DRMLIGHT_AMBIENT, 0.9, 0.9, 0.9, Light);
DXDraw.Scene.AddLight(Light);
{  Spot Light create and setting  }
DXDraw.D3DRM.CreateLightRGB(D3DRMLIGHT_SPOT, 1, 1, 1, Light);
with light do
       begin
        setPenUmbra(0.2);   // outer Cone
        setUmbra(0.15);     // inner Cone
        SetRange(40);
       end;

{load plane}
FileName := ExtractFilePath(Application.ExeName)+'plane.x';
ChDir(ExtractFilePath(FileName));
SceneMeshBuilder.Load(PChar(FileName), nil, D3DRMLOAD_FROMFILE, nil, nil);
SceneMeshBuilder.Scale(3, 3, 3);
SceneFrame.AddVisual(SceneMeshBuilder);


{load sphere}
FileName := ExtractFilePath(Application.ExeName)+'sphere.x';
ChDir(ExtractFilePath(FileName));
ObjectMesh.Load(PChar(FileName), nil, D3DRMLOAD_FROMFILE, nil, nil);
ObjectMesh.Scale(0.5, 0.5, 0.5);


{Create Shadow}
DXdraw.D3DRM.CreateShadow(ObjectMesh,
                          Light,
                          0,1,0,
                          0,1,0,Shadow);

{add light}
LightFrame.AddLight(Light);
{set position}
LightFrame.setposition(Dxdraw.scene,0,10,0);
{add shadow to sphereFrame}
SphereFrame.addVisual(shadow);
{add mesh to sphereFrame}
SphereFrame.addVisual(ObjectMesh);
{set position}
SphereFrame.SetPosition(Dxdraw.scene,0,5,0);
end;

procedure TfrmDX.DXTimer1Timer(Sender: TObject; LagCount: Integer);
begin
DXdraw.Render;
DXdraw.scene.move(1);
DXdraw.flip;
end;

procedure TfrmDX.FormKeyPress(Sender: TObject; var Key: Char);
begin
if key=#27 then close;
if key='1' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_WIREFRAME);
                ObjectMesh.SetQuality(D3DRMRENDER_WIREFRAME);
                end;
if key='2' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_FLAT);
                ObjectMesh.SetQuality(D3DRMRENDER_FLAT);
                end;
if key='3' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_PHONG);
                ObjectMesh.SetQuality(D3DRMRENDER_PHONG);
                end;

end;

procedure TfrmDX.Image1Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_WIREFRAME);
ObjectMesh.SetQuality(D3DRMRENDER_WIREFRAME);
end;

procedure TfrmDX.Image2Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_FLAT);
ObjectMesh.SetQuality(D3DRMRENDER_FLAT);

end;

procedure TfrmDX.Image3Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_PHONG);
ObjectMesh.SetQuality(D3DRMRENDER_PHONG);

end;

procedure TfrmDX.ScrollBar1Change(Sender: TObject);
begin
sphereframe.setposition(DXdraw.scene,0,-Scrollbar1.position/10,0);
DXdraw.flip;
end;

procedure TfrmDX.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
DXdraw.render;
end;

procedure TfrmDX.FormResize(Sender: TObject);
begin
  DXDraw.Width  := ClientWidth - ScrollBar1.Width;
  DXDraw.Height := ClientHeight;
  DXDraw.SurfaceWidth := DXDraw.Width;
  DXDraw.SurfaceHeight := DXDraw.Height;
end;

end.
