unit frmInfoUnt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TfrmInfo = class(TForm)
    imgScreenShot: TImage;
    imgBoxFrontScan: TImage;
    imgCartScan: TImage;
    imgBoxBackScan: TImage;
    imgBoxSideScan: TImage;
    btnManual: TBitBtn;
    procedure FormClick(Sender: TObject);
    procedure btnManualClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Cap   : String;
    FName : String;
    Procedure ClearImage(Var Img: TImage; Stretch: Boolean);
  public
    { Public declarations }
    Procedure LoadImages(FileName: String);
  end;

var
  frmInfo: TfrmInfo;

implementation

{$R *.DFM}

Uses HandTIA,JPEG, frmManualUnt, frmAltMenuUnt;

Procedure TfrmInfo.ClearImage(Var Img: TImage; Stretch: Boolean);
Var R: TRect;
Begin
  R.Left   := Img.Left;
  R.Top    := Img.Top;
  R.Right  := Img.Width;
  R.Bottom := Img.Height;
  Img.Free;
  Img := TImage.Create(Self);
  Img.Parent      := Self;
  Img.Left        := R.Left;
  Img.Top         := R.Top;
  Img.Width       := R.Right;
  Img.Height      := R.Bottom;
  Img.Stretch     := Stretch;
  Img.Visible     := True;
  Img.Enabled     := True;
  Img.AutoSize    := False;
  Img.Transparent := False;
  Img.OnClick     := FormClick;
End; // TfrmInfo.ClearImage

Procedure TfrmInfo.LoadImages(FileName: String);
Var
  St  : String;
  SS  : String;
  BF  : String;
  BB  : String;
  BS  : String;
  CS  : String;
  ZIP : Boolean;

begin
  ClearImage(imgScreenShot,False);
  ClearImage(imgBoxFrontScan,True);
  ClearImage(imgBoxBackScan,True);
  ClearImage(imgBoxSideScan,True);
  ClearImage(imgCartScan,True);
  Cap   := Caption;
  St    := FileName;
  FName := St;
  St := UpperCase(RemoveFileExt(St));
  SS := UpperCase(Config.ScreenShotPath);
  BF := UpperCase(Config.BoxFrontScanPath);
  BB := UpperCase(Config.BoxBackScanPath);
  BS := UpperCase(Config.BoxSideScanPath);
  CS := UpperCase(Config.CartScanPath);
  If (SS <> '') And Not (SS[Length(SS)] In [':','\']) Then SS := SS + '\';
  If (BF <> '') And Not (BF[Length(BF)] In [':','\']) Then BF := BF + '\';
  If (BB <> '') And Not (BB[Length(BB)] In [':','\']) Then BB := BB + '\';
  If (BS <> '') And Not (BS[Length(BS)] In [':','\']) Then BS := BS + '\';
  If (CS <> '') And Not (CS[Length(CS)] In [':','\']) Then CS := CS + '\';

       If FileExistsZip(SS,St + '.BMP',True,ZIP) Then frmAltMenu.OpenFile(SS + St + '.BMP',imgScreenShot,ZIP)
  Else If FileExistsZip(SS,St + '.JPG',True,ZIP) Then frmAltMenu.OpenFile(SS + St + '.JPG',imgScreenShot,ZIP);

       If FileExistsZip(BF,St + '.BMP',True,ZIP) Then frmAltMenu.OpenFile(BF + St + '.BMP',imgBoxFrontScan,ZIP)
  Else If FileExistsZip(BF,St + '.JPG',True,ZIP) Then frmAltMenu.OpenFile(BF + St + '.JPG',imgBoxFrontScan,ZIP);

       If FileExistsZip(BB,St + '.BMP',True,ZIP) Then frmAltMenu.OpenFile(BB + St + '.BMP',imgBoxBackScan,ZIP)
  Else If FileExistsZip(BB,St + '.JPG',True,ZIP) Then frmAltMenu.OpenFile(BB + St + '.JPG',imgBoxBackScan,ZIP);

       If FileExistsZip(BS,St + '.BMP',True,ZIP) Then frmAltMenu.OpenFile(BS + St + '.BMP',imgBoxSideScan,ZIP)
  Else If FileExistsZip(BS,St + '.JPG',True,ZIP) Then frmAltMenu.OpenFile(BS + St + '.JPG',imgBoxSideScan,ZIP);

       If FileExistsZip(CS,St + '.BMP',True,ZIP) Then frmAltMenu.OpenFile(CS + St + '.BMP',imgCartScan,ZIP)
  Else If FileExistsZip(CS,St + '.JPG',True,ZIP) Then frmAltMenu.OpenFile(CS + St + '.JPG',imgCartScan,ZIP);
end; // TfrmInfo.LoadImages

procedure TfrmInfo.FormClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmInfo.btnManualClick(Sender: TObject);
Var
  MP     : String;
  St     : String;
  I      : Integer;
  ZIP    : Boolean;
  Manual : String;

  Procedure OpenManual(FileName: String; RTF: Boolean);
  Var Flags: OLEVariant;
  Begin
    Try
      Flags  := 0;
      Manual := ExtractFileName(FileName);
      frmManual.wbManual.Navigate('file://' + FileName, Flags, Flags, Flags, Flags);
      frmManual.ShowModal;
    Except
      ShowMessage('There was a problem opening the manual.'#13#10 +
                  'Make sure you have Internet Explorer available'#13#10 +
                  'and that it has the necessary plugins.');
    End;
  End; // OpenManual

begin
  St   := UpperCase(FName);
  I    := Length(St);
  While (St[I] <> '.') And (I > 0) Do Dec(I);
  If I <> 0 Then St := Copy(St,1,I - 1);

  MP := UpperCase(Config.ManualPath);
  If (MP <> '') And Not (MP[Length(MP)] In [':','\']) Then MP := MP + '\';

       If FileExistsZip(MP,St + '.TXT',True,ZIP)  Then OpenManual(MP + St + '.TXT',False)
  Else If FileExistsZip(MP,St + '.RTF',True,ZIP)  Then OpenManual(MP + St + '.RTF',True)
  Else If FileExistsZip(MP,St + '.PDF',True,ZIP)  Then OpenManual(MP + St + '.PDF',True)
  Else If FileExistsZip(MP,St + '.HTM',True,ZIP)  Then OpenManual(MP + St + '.HTM',True)
  Else If FileExistsZip(MP,St + '.HTML',True,ZIP) Then OpenManual(MP + St + '.HTML',True);
  If ZIP Then DeleteFile(Manual);
end;

procedure TfrmInfo.FormCreate(Sender: TObject);
begin
  Scaled := False;
end;

end.

// ----------------------------------------------------------------------
// PCAE and PCAEWin - PC Atari Emulator - Atari 2600 emulator
// Copyright (C) 2000 John Dullea
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------
