unit DXSprite;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DXDraws, DXclass, DirectX, ExtCtrls, StdCtrls;

type
  TfrmDX = class(TDXForm)
    DXDraw: TDXDraw;
    DXTimer1: TDXTimer;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    ScrollBar1: TScrollBar;
    procedure DXDrawInitialize(Sender: TObject);
    procedure DXTimer1Timer(Sender: TObject; LagCount: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    SceneMeshBuilder      :Idirect3DRMMeshBuilder;
    ObjectMesh            :Idirect3DRMMeshBuilder;
    SceneFrame            :IDirect3DRMFrame;
    Light                 :Idirect3DRMLight;
    LightFrame            :Idirect3DRMFrame;
    PlaneFrame            :IDirect3DRMFrame;
    SphereFrame           :IDirect3DRMFrame;
    Shadow                :Idirect3DRMVisual;
    // -----------------------------------------
    Frame,Axis,Circle     :IDirect3DRMFrame;
    tex                   :IDirect3DRMTexture;
    inf                  :D3DRMIMAGE;
  end;

var
  frmDX: TfrmDX;
  filename:string;
implementation

{$R *.DFM}

procedure TfrmDX.DXDrawInitialize(Sender: TObject);
begin
DXtimer1.Enabled:=false;
{create meshbulder}
DXdraw.D3DRM.CreateMeshBuilder(SceneMeshBuilder);
DXdraw.D3DRM.CreateMeshBuilder(ObjectMesh);
{create frame}
DXdraw.D3DRM.CreateFrame(DXdraw.scene,LightFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,SceneFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,SphereFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,PlaneFrame);
DXdraw.D3DRM.CreateFrame(DXdraw.scene,frame);

{setup view}
DXdraw.Camera.SetPosition(DXdraw.scene,0,2,-10);
{direction in Z axes    UP vector in Y axes }
DXdraw.Camera.SetOrientation(DXdraw.scene,0,0,1,0,1,0);
//DXdraw.Camera.SetRotation(DXdraw.scene,0,1,0,0.04);
DXtimer1.Enabled:=true;
{default scene light}
DXDraw.D3DRM.CreateLightRGB(D3DRMLIGHT_AMBIENT, 0.9, 0.9, 0.9, Light);
DXDraw.Scene.AddLight(Light);
{  Spot Light create and setting  }
DXDraw.D3DRM.CreateLightRGB(D3DRMLIGHT_SPOT, 1, 1, 1, Light);
with light do
       begin
        setPenUmbra(0.2);   // outer Cone
        setUmbra(0.15);     // inner Cone
        SetRange(40);
       end;

{load plane}
FileName := ExtractFilePath(Application.ExeName)+'plane.x';
ChDir(ExtractFilePath(FileName));
SceneMeshBuilder.Load(PChar(FileName), nil, D3DRMLOAD_FROMFILE, nil, nil);
SceneMeshBuilder.Scale(3, 3, 3);
SceneFrame.SetPosition(DXdraw.scene,0,-1,0);
SceneFrame.AddVisual(SceneMeshBuilder);

frame.SetPosition(DXdraw.scene,0,0,0);
frame.SetOrientation(DXdraw.scene,0,1,0,0,0,1);
//frame.setrotation(Dxdraw.scene,0,0.9,0,0.04);

Dxdraw.D3DRM.CreateTexture(inf,tex);               // create texture
Dxdraw.D3DRM.LoadTexture(pchar('expl.bmp'),tex);   // load texture
tex.SetColors(256);                                // set color
tex.SetShades(1);                                  // set shade
tex.SetDecalScale(0);                              // set scale N=>0, if >0 then scale down
tex.SetDecalOrigin(64,64);                         // set origin
tex.SetDecalTransparency(true);                    // transparency ON (default black color)
Dxdraw.D3DRM.CreateFrame(frame,axis);              // create axis frame
Frame.SetRotation(DXdraw.scene,0,0,1,0.04);        // set rotation for frame around Z
axis.SetRotation(DXdraw.scene,0,1,0,0.04);         // set rotation for AXIS around Y
Dxdraw.D3DRM.CreateFrame(axis,circle);             // create circle frame
circle.SetPosition(axis,2.6,0,0);                  // set position

circle.AddVisual(tex);                             // add texture(sprite) to circle

end;

procedure TfrmDX.DXTimer1Timer(Sender: TObject; LagCount: Integer);
begin
DXdraw.Render;
DXdraw.scene.move(1);
DXdraw.flip;

end;

procedure TfrmDX.FormKeyPress(Sender: TObject; var Key: Char);
begin
if key=#27 then close;
if key='1' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_WIREFRAME);
                ObjectMesh.SetQuality(D3DRMRENDER_WIREFRAME);
                end;
if key='2' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_FLAT);
                ObjectMesh.SetQuality(D3DRMRENDER_FLAT);
                end;
if key='3' then begin
                SceneMeshBuilder.SetQuality(D3DRMRENDER_PHONG);
                ObjectMesh.SetQuality(D3DRMRENDER_PHONG);
                end;

end;

procedure TfrmDX.Image1Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_WIREFRAME);
ObjectMesh.SetQuality(D3DRMRENDER_WIREFRAME);
end;

procedure TfrmDX.Image2Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_FLAT);
ObjectMesh.SetQuality(D3DRMRENDER_FLAT);

end;

procedure TfrmDX.Image3Click(Sender: TObject);
begin
SceneMeshBuilder.SetQuality(D3DRMRENDER_PHONG);
ObjectMesh.SetQuality(D3DRMRENDER_PHONG);

end;

procedure TfrmDX.ScrollBar1Change(Sender: TObject);
begin
tex.SetDecalSize(scrollbar1.position,scrollbar1.position);
DXdraw.flip;
end;

procedure TfrmDX.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
DXdraw.render;
end;

end.
