/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <windows.h>
//#include "types.h"
//#include "memory.h"
//#include "cheat.h"

//TYPES
typedef unsigned char		_u8;
typedef unsigned short		_u16;
typedef unsigned int		_u32;
typedef	signed char			_s8;
typedef signed short		_s16;
typedef signed int			_s32;

//BOOL
typedef int					BOOL;
#define TRUE				1
#define FALSE				0


//#include "font.h"

static _u8 *cheatCurrent;

const int RAM_SIZE = 0xA0000;

void CheatResetRAM(void)
{
	cheatCurrent=0;
}

void CheatAddRAM(_u8 *ramPtr)
{
	cheatCurrent = ramPtr;
}


struct CHEATF {
           struct CHEATF *next;
           char *name;
           _u32 addr;
           _u8 val;
	   int status;
};

struct CHEATF *cheats=0,*cheatsl=0;


#define CHEATC_NONE     0x8000
#define CHEATC_EXCLUDED 0x4000
#define CHEATC_NOSHOW   0xC000

static _u16 *CheatComp=0;
static int savecheats;

static int AddCheatEntry(char *name, _u32 addr, _u8 val, int status);

static void CheatMemErr(void)
{
 //DispMessage("Error allocating memory for cheat data.");
}

/* This function doesn't allocate any memory for "name" */
static int AddCheatEntry(char *name, _u32 addr, _u8 val, int status)
{
 struct CHEATF *temp;
 if(!(temp=malloc(sizeof(struct CHEATF))))
 {
  CheatMemErr();
  return(0);
 }
 temp->name=name;
 temp->addr=addr;
 temp->val=val;
 temp->status=status;

 temp->next=0;

 if(cheats)
 {
  cheatsl->next=temp;
  cheatsl=temp;
 }
 else
  cheats=cheatsl=temp;

 return(1);
}

extern int toggle_cheats;
int LoadGameCheats(char *name)
{
 FILE *fp;
 unsigned int addr;
 unsigned int val;
 unsigned int status;
 int x;

 char linebuf[256+4+2+2+1+1]; /* 256 for name, 4 for address, 2 for value, 2 for semicolons, 1 for status, 1 for null */
 char namebuf[257];
 int tc=0;

 savecheats=0;
 if(!(fp=fopen(name,"rb")))
  return 0;
 
 toggle_cheats = fgetc( fp );
 savecheats=1;

 while(fgets(linebuf,256+4+2+2+1+1,fp)>0)
 { 
  addr=val=status=0;
  namebuf[0]=0; // If the cheat doesn't have a name...
  if(linebuf[0]==':')  
  {
   strncpy(namebuf,&linebuf[1+8+2+2],257);
   if(sscanf(&linebuf[1],"%08X%*[:]%02x",&addr,&val)!=2)
    continue;
   status=0;
  }
  else
  {
   strncpy(namebuf,&linebuf[8+2+2],257);
   if(sscanf(linebuf,"%08X%*[:]%02x",&addr,&val)!=2) continue;
   status=1;
  }
  for(x=0;x<257;x++)
  {
   if(namebuf[x]==10 || namebuf[x]==13)
   {
    namebuf[x]=0;
    break;
   }
  }
  namebuf[256]=0;
  if(!(name=malloc(strlen(namebuf)+1)))
   CheatMemErr();
  else
  {
   strcpy(name,namebuf);
   AddCheatEntry(name,addr,val,status);
   tc++;
  }
 }
 fclose(fp);
 return 1;
}

void FlushGameCheats(char *name)
{
 if(CheatComp)
 {
  free(CheatComp);
  CheatComp=0;
 }
 if(!savecheats)
 {
  if(cheats)
  {
   struct CHEATF *next=cheats;
   for(;;)
   {  
    struct CHEATF *last=next;
    next=next->next;
    free(last->name);
    free(last);
    if(!next) break;
   }
   cheats=cheatsl=0;
  }
 }
 else
 {
  if(cheats)
  {
   struct CHEATF *next=cheats;
   FILE *fp;
   if((fp=fopen(name,"wb")))
   {
 	  fprintf(fp,"%1d\n", toggle_cheats );

    for(;;)
    {
     struct CHEATF *t;
     if(next->status)
      fprintf(fp,"%08X:%02x:%s\n",next->addr,next->val,next->name);
     else
      fprintf(fp,":%08X:%02x:%s\n",next->addr,next->val,next->name);
     free(next->name);
     t=next;
     next=next->next;
     free(t);
     if(!next) break;
    }
    fclose(fp);
   }
   else
    //DispMessage("Error saving cheats.");
		0;
   cheats=cheatsl=0;
  }
  else
   remove(name);
 }
}


int AddCheat(char *name, _u32 addr, _u8 val)
{
 char *t;

 if(!(t=malloc(strlen(name)+1)))
 {
  CheatMemErr();
  return(0);
 }
 strcpy(t,name);
 if(!AddCheatEntry(t,addr,val,1))
 {
  free(t);
  return(0);
 }
 savecheats=1;
 return(1);
}

int DelCheat(_u32 which)
{
 struct CHEATF *prev;
 struct CHEATF *cur;
 _u32 x=0;

 for(prev=0,cur=cheats;;)
 {
  if(x==which)          // Remove this cheat.
  {
   if(prev)             // Update pointer to this cheat.
   {
    if(cur->next)       // More cheats.
     prev->next=cur->next;
    else                // No more.
    {
     prev->next=0;
     cheatsl=prev;      // Set the previous cheat as the last cheat.
    }
   }
   else                 // This is the first cheat.
   {
    if(cur->next)       // More cheats
     cheats=cur->next;
    else
     cheats=cheatsl=0;  // No (more) cheats.
   }
   free(cur->name);     // Now that all references to this cheat are removed,
   free(cur);           // free the memory.   
   break;
  }                     // *END REMOVE THIS CHEAT*


  if(!cur->next)        // No more cheats to go through(this shouldn't ever happen...)
   return(0);
  prev=cur;
  cur=prev->next;
  x++;
 }

 savecheats=1;
 return(1);
}

void ApplyPeriodicCheats(void)
{
 struct CHEATF *cur=cheats;
 if(!cur) return;

 for(;;)
 {
  if(cur->status)
   if(cheatCurrent)
    cheatCurrent[cur->addr]=cur->val;
  if(cur->next)
   cur=cur->next;
  else
   break;
 }
}


void ListCheats(int (*callb)(char *name, _u32 a, _u8 v, int s))
{
  struct CHEATF *next=cheats;

  while(next)
  {
   if(!callb(next->name,next->addr+0xc000,next->val,next->status)) break;
   next=next->next;
  }
}

int GetCheat(_u32 which, char **name, _u32 *a, _u8 *v, int *s)
{
 struct CHEATF *next=cheats;
 _u32 x=0;

 while(next)
 {
  if(x==which)
  {
   if(name)
    *name=next->name;
   if(a)
    *a=next->addr; 
   if(v)
    *v=next->val;
   if(s)
    *s=next->status;

   return(1);
  }
  next=next->next;
  x++;
 }
 return(0);
}

/* name can be NULL if the name isn't going to be changed. */
/* same goes for a, v, and s(except the values of each one must be <0) */

int SetCheat(_u32 which, char *name, int a, int v, int s)
{
 struct CHEATF *next=cheats;
 _u32 x=0;

 while(next)
 {
  if(x==which)
  {
   if(name)
   {
    char *t;

    if((t=realloc(next->name,strlen(name+1))))
    {
     next->name=t;
     strcpy(next->name,name);
    }
    else
     return(0);
   }
   if(a>=0)
    next->addr=a;
   if(v>=0)
    next->val=v;
   if(s>=0)
    next->status=s;
   savecheats=1;
   return(1);
  }
  next=next->next;
  x++;
 }
 return(0);
}


static int InitCheatComp(void)
{
 _u32 x;

 CheatComp=malloc(RAM_SIZE*sizeof(_u16));
 if(!CheatComp)
 {
  CheatMemErr();
  return(0);
 }
 for(x=0;x<RAM_SIZE;x++)
  CheatComp[x]=CHEATC_NONE;
 
 return(1);
}

void CheatSearchSetCurrentAsOriginal(void)
{
 _u32 x;
 for(x=0;x<RAM_SIZE;x++)
  if(!(CheatComp[x]&CHEATC_NOSHOW))
  {
   if(cheatCurrent)
    CheatComp[x]=cheatCurrent[x];
   else
    CheatComp[x]|=CHEATC_NONE;
  }
}

void CheatSearchShowExcluded(void)
{
 _u32 x;

 for(x=0;x<RAM_SIZE;x++)
  CheatComp[x]&=~CHEATC_EXCLUDED;
}


int CheatSearchGetCount(void)
{
 _u32 x,c=0;

 if(CheatComp)
 {
  for(x=00;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW) && cheatCurrent)
    c++;
 }

 return c;
}
/* This function will give the initial value of the search and the current value at a location. */

void CheatSearchGet(int (*callb)(_u32 a, _u8 last, _u8 current))
{
  _u32 x;

  if(!CheatComp)
  {
   if(!InitCheatComp())
    CheatMemErr();
   return;
  }

  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW) && cheatCurrent)
    if(!callb(x,CheatComp[x],cheatCurrent[x]))
     break;
}

void CheatSearchGetRange(_u32 first, _u32 last, int (*callb)(_u32 a, _u8 last, _u8 current))
{
  _u32 x;
  _u32 in=0;

  if(!CheatComp)
  {
   if(!InitCheatComp())
    CheatMemErr();
   return;
  }

  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW) && cheatCurrent)
   {
    if(in>=first)
     if(!callb(x,CheatComp[x],cheatCurrent[x]))
      break;
    in++;
    if(in>last) return;
   }
}

void CheatSearchBegin(void)
{
 _u32 x;

 if(!CheatComp)
 {
  if(!InitCheatComp())
  {
   CheatMemErr();
   return;
  }
 }
 for(x=0;x<RAM_SIZE;x++)
 {
  if(cheatCurrent)
   CheatComp[x]=cheatCurrent[x];
  else
   CheatComp[x]=CHEATC_NONE;
 }
}


static int CAbs(int x)
{
 if(x<0)
  return(0-x);
 return x;
}

void CheatSearchEnd(int type, _u8 v1, _u8 v2)
{
 _u32 x;

 if(!CheatComp)
 {
  if(!InitCheatComp())
  {
   CheatMemErr();
   return;
  }
 }


 if(!type)      // Change to a specific value.
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CheatComp[x]==v1 && cheatCurrent[x]==v2)
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==1)           // Search for relative change(between values).
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CheatComp[x]==v1 && CAbs(CheatComp[x]-cheatCurrent[x])==v2)
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==2)                          // Purely relative change.
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CAbs(CheatComp[x]-cheatCurrent[x])==v2)
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==3)                          // Any change.
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CheatComp[x]!=cheatCurrent[x])
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==4)                         // Value decreased.
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(!(cheatCurrent[x]<CheatComp[x]))
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==5)                         // Value increased.
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(!(cheatCurrent[x]>CheatComp[x]))
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==6)													// No change
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CheatComp[x]==cheatCurrent[x])
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==7)													// O==V1
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(CheatComp[x]==v1)
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 else if(type==8)													// C==V2
 {
  for(x=0;x<RAM_SIZE;x++)
   if(!(CheatComp[x]&CHEATC_NOSHOW))
   {
    if(cheatCurrent[x]==v2)
    {

    }
    else
     CheatComp[x]|=CHEATC_EXCLUDED;
   }
 }
 if(type>8)
  CheatSearchSetCurrentAsOriginal();
}
