/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javacc.parser.JavaCCErrors;

public class Options {
    protected static Map optionValues = null;
    private static Set cmdLineSetting = null;
    private static Set inputFileSetting = null;

    protected Options() {
    }

    protected static int intValue(String string) {
        return (Integer)optionValues.get(string);
    }

    protected static boolean booleanValue(String string) {
        return (Boolean)optionValues.get(string);
    }

    protected static String stringValue(String string) {
        return (String)optionValues.get(string);
    }

    public static Map getOptions() {
        return new HashMap(optionValues);
    }

    public static void init() {
        optionValues = new HashMap();
        cmdLineSetting = new HashSet();
        inputFileSetting = new HashSet();
        optionValues.put("LOOKAHEAD", new Integer(1));
        optionValues.put("CHOICE_AMBIGUITY_CHECK", new Integer(2));
        optionValues.put("OTHER_AMBIGUITY_CHECK", new Integer(1));
        optionValues.put("STATIC", Boolean.TRUE);
        optionValues.put("DEBUG_PARSER", Boolean.FALSE);
        optionValues.put("DEBUG_LOOKAHEAD", Boolean.FALSE);
        optionValues.put("DEBUG_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("ERROR_REPORTING", Boolean.TRUE);
        optionValues.put("JAVA_UNICODE_ESCAPE", Boolean.FALSE);
        optionValues.put("UNICODE_INPUT", Boolean.FALSE);
        optionValues.put("IGNORE_CASE", Boolean.FALSE);
        optionValues.put("USER_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("USER_CHAR_STREAM", Boolean.FALSE);
        optionValues.put("BUILD_PARSER", Boolean.TRUE);
        optionValues.put("BUILD_TOKEN_MANAGER", Boolean.TRUE);
        optionValues.put("TOKEN_MANAGER_USES_PARSER", Boolean.FALSE);
        optionValues.put("SANITY_CHECK", Boolean.TRUE);
        optionValues.put("FORCE_LA_CHECK", Boolean.FALSE);
        optionValues.put("COMMON_TOKEN_ACTION", Boolean.FALSE);
        optionValues.put("CACHE_TOKENS", Boolean.FALSE);
        optionValues.put("KEEP_LINE_COLUMN", Boolean.TRUE);
        optionValues.put("GENERATE_CHAINED_EXCEPTION", Boolean.FALSE);
        optionValues.put("GENERATE_GENERICS", Boolean.FALSE);
        optionValues.put("GENERATE_STRING_BUILDER", Boolean.FALSE);
        optionValues.put("GENERATE_ANNOTATIONS", Boolean.FALSE);
        optionValues.put("SUPPORT_CLASS_VISIBILITY_PUBLIC", Boolean.TRUE);
        optionValues.put("OUTPUT_DIRECTORY", ".");
        optionValues.put("JDK_VERSION", "1.5");
        optionValues.put("TOKEN_EXTENDS", "");
        optionValues.put("TOKEN_FACTORY", "");
        optionValues.put("GRAMMAR_ENCODING", "");
    }

    public static String getOptionsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(optionValues.get(string));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static boolean isOption(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '-';
    }

    public static Object upgradeValue(String string, Object object) {
        if (string.equalsIgnoreCase("NODE_FACTORY") && object.getClass() == Boolean.class) {
            object = (Boolean)object != false ? "*" : "";
        }
        return object;
    }

    public static void setInputFileOption(Object object, Object object2, String string, Object object3) {
        String string2 = string.toUpperCase();
        if (!optionValues.containsKey(string2)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object v = optionValues.get(string2);
        object3 = Options.upgradeValue(string, object3);
        if (v != null) {
            if (v.getClass() != object3.getClass() || object3 instanceof Integer && (Integer)object3 <= 0) {
                JavaCCErrors.warning(object2, "Bad option value \"" + object3 + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(string2)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(string2)) {
                if (!v.equals(object3)) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(string2, object3);
        inputFileSetting.add(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(String string) {
        Object object;
        String string2;
        block14: {
            int n;
            String string3;
            block15: {
                string3 = string.charAt(0) == '-' ? string.substring(1) : string;
                int n2 = string3.indexOf(61);
                int n3 = string3.indexOf(58);
                n = n2 < 0 ? n3 : (n3 < 0 ? n2 : (n2 < n3 ? n2 : n3));
                if (n >= 0) break block15;
                string2 = string3.toUpperCase();
                if (optionValues.containsKey(string2)) {
                    object = Boolean.TRUE;
                    break block14;
                } else if (string2.length() > 2 && string2.charAt(0) == 'N' && string2.charAt(1) == 'O') {
                    object = Boolean.FALSE;
                    string2 = string2.substring(2);
                    break block14;
                } else {
                    System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
                    return;
                }
            }
            string2 = string3.substring(0, n).toUpperCase();
            if (string3.substring(n + 1).equalsIgnoreCase("TRUE")) {
                object = Boolean.TRUE;
            } else if (string3.substring(n + 1).equalsIgnoreCase("FALSE")) {
                object = Boolean.FALSE;
            } else {
                try {
                    int n4 = Integer.parseInt(string3.substring(n + 1));
                    if (n4 <= 0) {
                        System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
                        return;
                    }
                    object = new Integer(n4);
                }
                catch (NumberFormatException numberFormatException) {
                    object = string3.substring(n + 1);
                    if (string3.length() <= n + 2 || string3.charAt(n + 1) != '\"' || string3.charAt(string3.length() - 1) != '\"') break block14;
                    object = string3.substring(n + 2, string3.length() - 1);
                }
            }
        }
        if (!optionValues.containsKey(string2)) {
            System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
            return;
        }
        Object v = optionValues.get(string2);
        if (object.getClass() != v.getClass()) {
            System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
            return;
        }
        if (cmdLineSetting.contains(string2)) {
            System.out.println("Warning: Duplicate option setting \"" + string + "\" will be ignored.");
            return;
        }
        object = Options.upgradeValue(string2, object);
        optionValues.put(string2, object);
        cmdLineSetting.add(string2);
    }

    public static void normalize() {
        if (Options.getDebugLookahead() && !Options.getDebugParser()) {
            if (cmdLineSetting.contains("DEBUG_PARSER") || inputFileSetting.contains("DEBUG_PARSER")) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            optionValues.put("DEBUG_PARSER", Boolean.TRUE);
        }
        optionValues.put("GENERATE_CHAINED_EXCEPTION", Options.jdkVersionAtLeast(1.4));
        optionValues.put("GENERATE_GENERICS", Options.jdkVersionAtLeast(1.5));
        optionValues.put("GENERATE_STRING_BUILDER", Options.jdkVersionAtLeast(1.5));
        optionValues.put("GENERATE_ANNOTATIONS", Options.jdkVersionAtLeast(1.5));
    }

    public static int getLookahead() {
        return Options.intValue("LOOKAHEAD");
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue("CHOICE_AMBIGUITY_CHECK");
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue("OTHER_AMBIGUITY_CHECK");
    }

    public static boolean getStatic() {
        return Options.booleanValue("STATIC");
    }

    public static boolean getDebugParser() {
        return Options.booleanValue("DEBUG_PARSER");
    }

    public static boolean getDebugLookahead() {
        return Options.booleanValue("DEBUG_LOOKAHEAD");
    }

    public static boolean getDebugTokenManager() {
        return Options.booleanValue("DEBUG_TOKEN_MANAGER");
    }

    public static boolean getErrorReporting() {
        return Options.booleanValue("ERROR_REPORTING");
    }

    public static boolean getJavaUnicodeEscape() {
        return Options.booleanValue("JAVA_UNICODE_ESCAPE");
    }

    public static boolean getUnicodeInput() {
        return Options.booleanValue("UNICODE_INPUT");
    }

    public static boolean getIgnoreCase() {
        return Options.booleanValue("IGNORE_CASE");
    }

    public static boolean getUserTokenManager() {
        return Options.booleanValue("USER_TOKEN_MANAGER");
    }

    public static boolean getUserCharStream() {
        return Options.booleanValue("USER_CHAR_STREAM");
    }

    public static boolean getBuildParser() {
        return Options.booleanValue("BUILD_PARSER");
    }

    public static boolean getBuildTokenManager() {
        return Options.booleanValue("BUILD_TOKEN_MANAGER");
    }

    public static boolean getTokenManagerUsesParser() {
        return Options.booleanValue("TOKEN_MANAGER_USES_PARSER");
    }

    public static boolean getSanityCheck() {
        return Options.booleanValue("SANITY_CHECK");
    }

    public static boolean getForceLaCheck() {
        return Options.booleanValue("FORCE_LA_CHECK");
    }

    public static boolean getCommonTokenAction() {
        return Options.booleanValue("COMMON_TOKEN_ACTION");
    }

    public static boolean getCacheTokens() {
        return Options.booleanValue("CACHE_TOKENS");
    }

    public static boolean getKeepLineColumn() {
        return Options.booleanValue("KEEP_LINE_COLUMN");
    }

    public static String getJdkVersion() {
        return Options.stringValue("JDK_VERSION");
    }

    public static boolean getGenerateChainedException() {
        return Options.booleanValue("GENERATE_CHAINED_EXCEPTION");
    }

    public static boolean getGenerateGenerics() {
        return Options.booleanValue("GENERATE_GENERICS");
    }

    public static boolean getGenerateStringBuilder() {
        return Options.booleanValue("GENERATE_STRING_BUILDER");
    }

    public static boolean getGenerateAnnotations() {
        return Options.booleanValue("GENERATE_ANNOTATIONS");
    }

    public static boolean getSupportClassVisibilityPublic() {
        return Options.booleanValue("SUPPORT_CLASS_VISIBILITY_PUBLIC");
    }

    public static boolean jdkVersionAtLeast(double d) {
        double d2 = Double.parseDouble(Options.getJdkVersion());
        return d2 >= d;
    }

    public static String getTokenExtends() {
        return Options.stringValue("TOKEN_EXTENDS");
    }

    public static String getTokenFactory() {
        return Options.stringValue("TOKEN_FACTORY");
    }

    public static String getGrammarEncoding() {
        if (Options.stringValue("GRAMMAR_ENCODING").equals("")) {
            return System.getProperties().getProperty("file.encoding");
        }
        return Options.stringValue("GRAMMAR_ENCODING");
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue("OUTPUT_DIRECTORY"));
    }

    public static String stringBufOrBuild() {
        if (Options.getGenerateStringBuilder()) {
            return "StringBuilder";
        }
        return "StringBuffer";
    }
}

