/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_u;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.jca.Providers;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;

public final class RSACipher
extends CipherSpi {
    private static final byte[] a = new byte[0];
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 3;
    private static final int e = 4;
    private static final String f = "NoPadding";
    private static final String g = "PKCS1Padding";
    private static final String h = "OAEP";
    private int i;
    private String j;
    private RSAPadding k;
    private OAEPParameterSpec l = null;
    private byte[] m;
    private int n;
    private int o;
    private RSAPublicKey p;
    private RSAPrivateKey q;
    private String r = "SHA-1";

    public RSACipher() {
        SunJCE.a(this.getClass());
        this.j = g;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase(f)) {
            this.j = f;
        } else if (string.equalsIgnoreCase(g)) {
            this.j = g;
        } else {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (string2.equals("oaeppadding")) {
                this.j = h;
            } else if (string2.startsWith("oaepwith") && string2.endsWith("andmgf1padding")) {
                this.j = h;
                this.r = string.substring(8, string.length() - 14);
                if (Providers.getProviderList().getService("MessageDigest", this.r) == null) {
                    throw new NoSuchPaddingException("MessageDigest not available for " + string);
                }
            } else {
                throw new NoSuchPaddingException("Padding " + string + " not supported");
            }
        }
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        return this.o;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.l != null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(h, "SunJCE");
                algorithmParameters.init(this.l);
                return algorithmParameters;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Cannot find OAEP  AlgorithmParameters implementation in SunJCE provider");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Cannot find SunJCE provider");
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException("OAEPParameterSpec not supported");
            }
        }
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.a(n, key, secureRandom, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Wrong parameters");
            invalidKeyException.initCause(invalidAlgorithmParameterException);
            throw invalidKeyException;
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(n, key, secureRandom, algorithmParameterSpec);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null) {
            this.a(n, key, secureRandom, null);
        } else {
            try {
                OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
                this.a(n, key, secureRandom, oAEPParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("Wrong parameter");
                invalidAlgorithmParameterException.initCause(invalidParameterSpecException);
                throw invalidAlgorithmParameterException;
            }
        }
    }

    private void a(int n, Key key, SecureRandom secureRandom, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n2;
        boolean bl;
        switch (n) {
            case 1: 
            case 3: {
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + n);
            }
        }
        RSAKey rSAKey = RSAKeyFactory.toRSAKey(key);
        if (key instanceof RSAPublicKey) {
            this.i = bl ? 1 : 4;
            this.p = (RSAPublicKey)key;
            this.q = null;
        } else {
            this.i = bl ? 3 : 2;
            this.q = (RSAPrivateKey)key;
            this.p = null;
        }
        this.o = n2 = RSACore.getByteLength(rSAKey.getModulus());
        this.n = 0;
        if (this.j == f) {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.k = RSAPadding.getInstance(3, n2, secureRandom);
            this.m = new byte[n2];
        } else if (this.j == g) {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            int n3 = this.i <= 2 ? 2 : 1;
            this.k = RSAPadding.getInstance(n3, n2, secureRandom);
            if (bl) {
                int n4 = this.k.getMaxDataSize();
                this.m = new byte[n4];
            } else {
                this.m = new byte[n2];
            }
        } else {
            OAEPParameterSpec oAEPParameterSpec;
            if (this.i == 3 || this.i == 4) {
                throw new InvalidKeyException("OAEP cannot be used to sign or verify signatures");
            }
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
                }
                oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
            } else {
                oAEPParameterSpec = new OAEPParameterSpec(this.r, "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            }
            this.k = RSAPadding.getInstance(4, n2, secureRandom, oAEPParameterSpec);
            if (bl) {
                int n5 = this.k.getMaxDataSize();
                this.m = new byte[n5];
            } else {
                this.m = new byte[n2];
            }
        }
    }

    private void a(byte[] byArray, int n, int n2) {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (this.n + n2 > this.m.length) {
            this.n = this.m.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.m, this.n, n2);
        this.n += n2;
    }

    private byte[] a() throws BadPaddingException, IllegalBlockSizeException {
        if (this.n > this.m.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.m.length + " bytes");
        }
        try {
            switch (this.i) {
                case 3: {
                    byte[] byArray = this.k.pad(this.m, 0, this.n);
                    byte[] byArray2 = RSACore.rsa(byArray, this.q);
                    return byArray2;
                }
                case 4: {
                    byte[] byArray = RSACore.convert(this.m, 0, this.n);
                    byte[] byArray3 = RSACore.rsa(byArray, this.p);
                    byte[] byArray4 = this.k.unpad(byArray3);
                    return byArray4;
                }
                case 1: {
                    byte[] byArray = this.k.pad(this.m, 0, this.n);
                    byte[] byArray5 = RSACore.rsa(byArray, this.p);
                    return byArray5;
                }
                case 2: {
                    byte[] byArray = RSACore.convert(this.m, 0, this.n);
                    byte[] byArray6 = RSACore.rsa(byArray, this.q);
                    byte[] byArray7 = this.k.unpad(byArray6);
                    return byArray7;
                }
            }
            throw new AssertionError((Object)"Internal error");
        }
        finally {
            this.n = 0;
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.a(byArray, n, n2);
        return a;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.a(byArray, n, n2);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.a(byArray, n, n2);
        return this.a();
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.o > byArray2.length - n3) {
            throw new ShortBufferException("Need " + this.o + " bytes for output");
        }
        this.a(byArray, n, n2);
        byte[] byArray3 = this.a();
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        return n4;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (byArray.length > this.m.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        this.a(byArray, 0, byArray.length);
        try {
            return this.a();
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray.length > this.m.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        this.a(byArray, 0, byArray.length);
        try {
            byte[] byArray2 = this.a();
            return SunJCE_u.a(byArray2, string, n);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Unwrapping failed", badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Unwrapping failed", illegalBlockSizeException);
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        RSAKey rSAKey = RSAKeyFactory.toRSAKey(key);
        return rSAKey.getModulus().bitLength();
    }
}

