/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.util.CacheMap;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    private static final int PRINCIPALS_CACHE_SIZE = 10;
    private static final int ACC_CACHE_SIZE = 10;
    private CacheMap principalsCache;
    private CacheMap accCache;

    public synchronized AccessControlContext delegatedContext(AccessControlContext accessControlContext, Subject subject) throws SecurityException {
        AccessControlContext accessControlContext2;
        Principal[] principalArray;
        if (this.principalsCache == null || this.accCache == null) {
            this.principalsCache = new CacheMap(10);
            this.accCache = new CacheMap(10);
        }
        if ((principalArray = (Principal[])this.principalsCache.get(subject)) == null) {
            principalArray = subject.getPrincipals().toArray(new Principal[0]);
            this.principalsCache.put(subject, principalArray);
        }
        if ((accessControlContext2 = (AccessControlContext)this.accCache.get(subject)) == null) {
            accessControlContext2 = JMXSubjectDomainCombiner.getContext(subject);
            this.accCache.put(subject, accessControlContext2);
        }
        final Principal[] principalArray2 = principalArray;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < principalArray2.length; ++i) {
                    String string = principalArray2[i].getClass().getName() + "." + principalArray2[i].getName();
                    SubjectDelegationPermission subjectDelegationPermission = new SubjectDelegationPermission(string);
                    AccessController.checkPermission(subjectDelegationPermission);
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, accessControlContext);
        return accessControlContext2;
    }
}

