/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthContext;

class SynthArrowButton
extends JButton
implements SwingConstants,
UIResource {
    private int direction;

    public SynthArrowButton(int n) {
        this.setFocusable(false);
        this.setDirection(n);
        this.setDefaultCapable(false);
    }

    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    public void updateUI() {
        this.setUI(new SynthArrowButtonUI());
    }

    public void setDirection(int n) {
        this.direction = n;
        this.putClientProperty("__arrow_direction__", new Integer(n));
        this.repaint();
    }

    public int getDirection() {
        return this.direction;
    }

    private static class SynthArrowButtonUI
    extends SynthButtonUI {
        private SynthArrowButtonUI() {
        }

        protected void installDefaults(AbstractButton abstractButton) {
            super.installDefaults(abstractButton);
            this.updateStyle(abstractButton);
        }

        protected void paint(SynthContext synthContext, Graphics graphics) {
            SynthArrowButton synthArrowButton = (SynthArrowButton)synthContext.getComponent();
            synthContext.getPainter().paintArrowButtonForeground(synthContext, graphics, 0, 0, synthArrowButton.getWidth(), synthArrowButton.getHeight(), synthArrowButton.getDirection());
        }

        void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
            synthContext.getPainter().paintArrowButtonBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }

        public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            synthContext.getPainter().paintArrowButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            SynthContext synthContext = this.getContext(jComponent);
            int n = synthContext.getStyle().getInt(synthContext, "ArrowButton.size", 16);
            synthContext.dispose();
            return new Dimension(n, n);
        }
    }
}

