/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import sun.awt.AWTAutoShutdown;
import sun.awt.AWTSecurityManager;
import sun.awt.MostRecentKeyValue;
import sun.awt.MostRecentThreadAppContext;
import sun.awt.SunToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppContext {
    public static final Object EVENT_QUEUE_KEY = new StringBuffer("EventQueue");
    private static Map<ThreadGroup, AppContext> threadGroup2appContext = null;
    private static AppContext mainAppContext = null;
    private final HashMap table = new HashMap();
    private final ThreadGroup threadGroup;
    private PropertyChangeSupport changeSupport = null;
    public static final String DISPOSED_PROPERTY_NAME = "disposed";
    public static final String GUI_DISPOSED = "guidisposed";
    private boolean isDisposed = false;
    private static int numAppContexts;
    private final ClassLoader contextClassLoader;
    private static MostRecentThreadAppContext mostRecentThreadAppContext;
    private long DISPOSAL_TIMEOUT = 5000L;
    private long THREAD_INTERRUPT_TIMEOUT = 1000L;
    private MostRecentKeyValue mostRecentKeyValue = null;
    private MostRecentKeyValue shadowMostRecentKeyValue = null;

    public static Set<AppContext> getAppContexts() {
        return threadGroup2appContext == null ? new HashSet<AppContext>() : new HashSet<AppContext>(threadGroup2appContext.values());
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    AppContext(ThreadGroup threadGroup) {
        ++numAppContexts;
        if (threadGroup2appContext == null) {
            threadGroup2appContext = Collections.synchronizedMap(new IdentityHashMap());
        }
        this.threadGroup = threadGroup;
        threadGroup2appContext.put(threadGroup, this);
        this.contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static final AppContext getAppContext() {
        AWTSecurityManager aWTSecurityManager;
        AppContext appContext;
        SecurityManager securityManager;
        if (numAppContexts == 1) {
            return mainAppContext;
        }
        final Thread thread = Thread.currentThread();
        AppContext appContext2 = null;
        MostRecentThreadAppContext mostRecentThreadAppContext = AppContext.mostRecentThreadAppContext;
        appContext2 = mostRecentThreadAppContext != null && mostRecentThreadAppContext.thread == thread ? mostRecentThreadAppContext.appContext : (AppContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = thread.getThreadGroup();
                AppContext appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                while (appContext == null) {
                    if ((threadGroup2 = threadGroup2.getParent()) == null) {
                        throw new RuntimeException("Invalid ThreadGroup");
                    }
                    appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                }
                for (ThreadGroup threadGroup3 = threadGroup; threadGroup3 != threadGroup2; threadGroup3 = threadGroup3.getParent()) {
                    threadGroup2appContext.put(threadGroup3, appContext);
                }
                AppContext.mostRecentThreadAppContext = new MostRecentThreadAppContext(thread, appContext);
                return appContext;
            }
        });
        if (appContext2 == mainAppContext && (securityManager = System.getSecurityManager()) != null && securityManager instanceof AWTSecurityManager && (appContext = (aWTSecurityManager = (AWTSecurityManager)securityManager).getAppContext()) != null) {
            appContext2 = appContext;
        }
        return appContext2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws IllegalThreadStateException {
        Object object;
        if (this.threadGroup.parentOf(Thread.currentThread().getThreadGroup())) {
            throw new IllegalThreadStateException("Current Thread is contained within AppContext to be disposed.");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
        }
        object2 = this.changeSupport;
        if (object2 != null) {
            ((PropertyChangeSupport)object2).firePropertyChange(DISPOSED_PROPERTY_NAME, false, true);
        }
        final Object object3 = new Object();
        Runnable runnable = new Runnable((PropertyChangeSupport)object2, object3){
            final /* synthetic */ PropertyChangeSupport val$changeSupport;
            final /* synthetic */ Object val$notificationLock;
            {
                this.val$changeSupport = propertyChangeSupport;
                this.val$notificationLock = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Frame[] frameArray = Frame.getFrames();
                for (int i = frameArray.length - 1; i >= 0; --i) {
                    frameArray[i].dispose();
                }
                if (this.val$changeSupport != null) {
                    this.val$changeSupport.firePropertyChange(AppContext.GUI_DISPOSED, false, true);
                }
                Object object = this.val$notificationLock;
                synchronized (object) {
                    this.val$notificationLock.notifyAll();
                }
            }
        };
        Object object4 = object3;
        synchronized (object4) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object3.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = object3;
                synchronized (object) {
                    object3.notifyAll();
                }
            }
        };
        object4 = object3;
        synchronized (object4) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object3.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.threadGroup.interrupt();
        long l = System.currentTimeMillis();
        long l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadGroup.stop();
        l = System.currentTimeMillis();
        l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = this.threadGroup.activeGroupCount();
        if (n > 0) {
            object = new ThreadGroup[n];
            n = this.threadGroup.enumerate((ThreadGroup[])object);
            for (int i = 0; i < n; ++i) {
                threadGroup2appContext.remove(object[i]);
            }
        }
        threadGroup2appContext.remove(this.threadGroup);
        object = mostRecentThreadAppContext;
        if (object != null && object.appContext == this) {
            mostRecentThreadAppContext = null;
        }
        try {
            this.threadGroup.destroy();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            this.table.clear();
        }
        --numAppContexts;
        this.mostRecentKeyValue = null;
    }

    static void stopEventDispatchThreads() {
        for (AppContext appContext : AppContext.getAppContexts()) {
            PostShutdownEventRunnable postShutdownEventRunnable = new PostShutdownEventRunnable(appContext);
            if (appContext != AppContext.getAppContext()) {
                CreateThreadAction createThreadAction = new CreateThreadAction(appContext, postShutdownEventRunnable);
                Thread thread = (Thread)AccessController.doPrivileged(createThreadAction);
                thread.start();
                continue;
            }
            postShutdownEventRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                return mostRecentKeyValue.value;
            }
            Object v = this.table.get(object);
            if (this.mostRecentKeyValue == null) {
                this.mostRecentKeyValue = new MostRecentKeyValue(object, v);
                this.shadowMostRecentKeyValue = new MostRecentKeyValue(object, v);
            } else {
                MostRecentKeyValue mostRecentKeyValue2 = this.mostRecentKeyValue;
                this.shadowMostRecentKeyValue.setPair(object, v);
                this.mostRecentKeyValue = this.shadowMostRecentKeyValue;
                this.shadowMostRecentKeyValue = mostRecentKeyValue2;
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                mostRecentKeyValue.value = object2;
            }
            return this.table.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
            if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
                mostRecentKeyValue.value = null;
            }
            return this.table.remove(object);
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public String toString() {
        return this.getClass().getName() + "[threadGroup=" + this.threadGroup.getName() + "]";
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                mainAppContext = new AppContext(threadGroup);
                numAppContexts = 1;
                return mainAppContext;
            }
        });
        mostRecentThreadAppContext = null;
    }

    static final class CreateThreadAction
    implements PrivilegedAction {
        private final AppContext appContext;
        private final Runnable runnable;

        public CreateThreadAction(AppContext appContext, Runnable runnable) {
            this.appContext = appContext;
            this.runnable = runnable;
        }

        public Object run() {
            Thread thread = new Thread(this.appContext.getThreadGroup(), this.runnable);
            thread.setContextClassLoader(this.appContext.getContextClassLoader());
            thread.setPriority(6);
            thread.setDaemon(true);
            return thread;
        }
    }

    static final class PostShutdownEventRunnable
    implements Runnable {
        private final AppContext appContext;

        public PostShutdownEventRunnable(AppContext appContext) {
            this.appContext = appContext;
        }

        public void run() {
            EventQueue eventQueue = (EventQueue)this.appContext.get(EVENT_QUEUE_KEY);
            if (eventQueue != null) {
                eventQueue.postEvent(AWTAutoShutdown.getShutdownEvent());
            }
        }
    }
}

