/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import java.io.Serializable;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

class WListPeer
extends WComponentPeer
implements ListPeer {
    private FontMetrics fm;

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public boolean isFocusable() {
        return true;
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n = list.countItems();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isSelected(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void removeAll() {
        this.clear();
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public void addItem(String string, int n) {
        this.addItems(new String[]{string}, n, this.fm.stringWidth(string));
    }

    native void addItems(String[] var1, int var2, int var3);

    public native void delItems(int var1, int var2);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    public native void select(int var1);

    public native void deselect(int var1);

    public native void makeVisible(int var1);

    public native void setMultipleSelections(boolean var1);

    public native int getMaxWidth();

    public Dimension preferredSize(int n) {
        Serializable serializable;
        if (this.fm == null) {
            serializable = (List)this.target;
            this.fm = this.getFontMetrics(((Component)serializable).getFont());
        }
        serializable = this.minimumSize(n);
        ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, this.getMaxWidth() + 20);
        return serializable;
    }

    public Dimension minimumSize(int n) {
        return new Dimension(20 + this.fm.stringWidth("0123456789abcde"), this.fm.getHeight() * n + 4);
    }

    WListPeer(List list) {
        super(list);
    }

    native void create(WComponentPeer var1);

    void initialize() {
        Object object;
        String[] stringArray;
        List list = (List)this.target;
        this.fm = this.getFontMetrics(list.getFont());
        int n = list.countItems();
        if (n > 0) {
            stringArray = new String[n];
            object = 0;
            Object object2 = 0;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = list.getItem(i);
                object2 = this.fm.stringWidth(stringArray[i]);
                if (object2 <= object) continue;
                object = object2;
            }
            this.addItems(stringArray, 0, (int)object);
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        stringArray = (String[])list.getSelectedIndexes();
        for (object = 0; object < stringArray.length; ++object) {
            this.select((int)stringArray[object]);
        }
        object = list.getVisibleIndex();
        if (object < 0 && stringArray.length > 0) {
            object = stringArray[0];
        }
        if (object >= 0) {
            this.makeVisible((int)object);
        }
        super.initialize();
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    private native void updateMaxItemWidth();

    native boolean isSelected(int var1);

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(((List)this.target).getFont());
        this.updateMaxItemWidth();
    }

    void handleAction(final int n, final long l, final int n2) {
        final List list = (List)this.target;
        WToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n);
                WListPeer.this.postEvent(new ActionEvent(WListPeer.this.target, 1001, list.getItem(n), l, n2));
            }
        });
    }

    void handleListChanged(final int n) {
        final List list = (List)this.target;
        WToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                WListPeer.this.postEvent(new ItemEvent(list, 701, new Integer(n), WListPeer.this.isSelected(n) ? 1 : 2));
            }
        });
    }
}

