/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.security.auth.kerberos.DelegationPermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCred;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

abstract class InitialToken
extends Krb5Token {
    private static final int CHECKSUM_TYPE = 32771;
    private static final int CHECKSUM_LENGTH_SIZE = 4;
    private static final int CHECKSUM_BINDINGS_SIZE = 16;
    private static final int CHECKSUM_FLAGS_SIZE = 4;
    private static final int CHECKSUM_DELEG_OPT_SIZE = 2;
    private static final int CHECKSUM_DELEG_LGTH_SIZE = 2;
    private static final int CHECKSUM_DELEG_FLAG = 1;
    private static final int CHECKSUM_MUTUAL_FLAG = 2;
    private static final int CHECKSUM_REPLAY_FLAG = 4;
    private static final int CHECKSUM_SEQUENCE_FLAG = 8;
    private static final int CHECKSUM_CONF_FLAG = 16;
    private static final int CHECKSUM_INTEG_FLAG = 32;
    private final byte[] CHECKSUM_FIRST_BYTES = new byte[]{16, 0, 0, 0};
    private final int CHANNEL_BINDING_AF_INET = 2;
    private final int CHANNEL_BINDING_AF_NULL_ADDR = 255;

    InitialToken() {
    }

    private byte[] computeChannelBinding(ChannelBinding channelBinding) throws GSSException {
        byte[] byArray;
        InetAddress inetAddress = channelBinding.getInitiatorAddress();
        InetAddress inetAddress2 = channelBinding.getAcceptorAddress();
        byte[] byArray2 = null;
        int n = 255;
        byte[] byArray3 = null;
        int n2 = 255;
        int n3 = 20;
        if (inetAddress != null) {
            n = 2;
            byArray2 = inetAddress.getAddress();
            if (byArray2.length != 4) {
                throw new GSSException(11, -1, "Cannot handle non AF-INET addresses in ChannelBinding.");
            }
            n3 += byArray2.length;
        }
        if (inetAddress2 != null) {
            n2 = 2;
            byArray3 = inetAddress2.getAddress();
            if (byArray3.length != 4) {
                throw new GSSException(11, -1, "Cannot handle non AF-INET addresses in ChannelBinding.");
            }
            n3 += byArray3.length;
        }
        if ((byArray = channelBinding.getApplicationData()) != null) {
            n3 += byArray.length;
        }
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        InitialToken.writeLittleEndian(n, byArray4, n4);
        n4 += 4;
        if (byArray2 != null) {
            InitialToken.writeLittleEndian(byArray2.length, byArray4, n4);
            System.arraycopy(byArray2, 0, byArray4, n4 += 4, byArray2.length);
            n4 += byArray2.length;
        } else {
            n4 += 4;
        }
        InitialToken.writeLittleEndian(n2, byArray4, n4);
        n4 += 4;
        if (byArray3 != null) {
            InitialToken.writeLittleEndian(byArray3.length, byArray4, n4);
            System.arraycopy(byArray3, 0, byArray4, n4 += 4, byArray3.length);
            n4 += byArray3.length;
        } else {
            n4 += 4;
        }
        if (byArray != null) {
            InitialToken.writeLittleEndian(byArray.length, byArray4, n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 4, byArray.length);
            n4 += byArray.length;
        } else {
            n4 += 4;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(byArray4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new GSSException(11, -1, "Could not get MD5 Message Digest - " + noSuchAlgorithmException.getMessage());
        }
    }

    public abstract byte[] encode() throws IOException;

    protected class OverloadedChecksum {
        private byte[] checksumBytes = null;
        private Credentials delegCreds = null;
        private int flags = 0;

        public OverloadedChecksum(Krb5Context krb5Context, Credentials credentials, Credentials credentials2) throws KrbException, IOException, GSSException {
            Object object;
            Object object2;
            byte[] byArray = null;
            int n = 0;
            int n2 = 24;
            if (krb5Context.getCredDelegState()) {
                if (!credentials.isForwardable()) {
                    krb5Context.setCredDelegState(false);
                } else {
                    object2 = null;
                    object = krb5Context.getCipherHelper(credentials2.getSessionKey());
                    object2 = this.useNullKey((CipherHelper)object) ? new KrbCred(credentials, credentials2, EncryptionKey.NULL_KEY) : new KrbCred(credentials, credentials2, credentials2.getSessionKey());
                    byArray = ((KrbCred)object2).getMessage();
                    n2 += 4 + byArray.length;
                }
            }
            this.checksumBytes = new byte[n2];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[0];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[1];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[2];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[3];
            object2 = krb5Context.getChannelBinding();
            if (object2 != null) {
                object = InitialToken.this.computeChannelBinding(krb5Context.getChannelBinding());
                System.arraycopy(object, 0, this.checksumBytes, n, ((Object)object).length);
            }
            n += 16;
            if (krb5Context.getCredDelegState()) {
                this.flags |= 1;
            }
            if (krb5Context.getMutualAuthState()) {
                this.flags |= 2;
            }
            if (krb5Context.getReplayDetState()) {
                this.flags |= 4;
            }
            if (krb5Context.getSequenceDetState()) {
                this.flags |= 8;
            }
            if (krb5Context.getIntegState()) {
                this.flags |= 0x20;
            }
            if (krb5Context.getConfState()) {
                this.flags |= 0x10;
            }
            object = new byte[4];
            Krb5Token.writeLittleEndian(this.flags, (byte[])object);
            this.checksumBytes[n++] = (byte)object[0];
            this.checksumBytes[n++] = (byte)object[1];
            this.checksumBytes[n++] = (byte)object[2];
            this.checksumBytes[n++] = (byte)object[3];
            if (krb5Context.getCredDelegState()) {
                PrincipalName principalName = credentials2.getServer();
                StringBuffer stringBuffer = new StringBuffer("\"");
                stringBuffer.append(principalName.getName()).append('\"');
                String string = principalName.getRealmAsString();
                stringBuffer.append(" \"krbtgt/").append(string).append('@');
                stringBuffer.append(string).append('\"');
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    DelegationPermission delegationPermission = new DelegationPermission(stringBuffer.toString());
                    securityManager.checkPermission(delegationPermission);
                }
                this.checksumBytes[n++] = 1;
                this.checksumBytes[n++] = 0;
                if (byArray.length > 65535) {
                    throw new GSSException(-1);
                }
                Krb5Token.writeLittleEndian(byArray.length, (byte[])object);
                this.checksumBytes[n++] = (byte)object[0];
                this.checksumBytes[n++] = (byte)object[1];
                System.arraycopy(byArray, 0, this.checksumBytes, n, byArray.length);
            }
        }

        public OverloadedChecksum(Krb5Context krb5Context, Checksum checksum, EncryptionKey encryptionKey) throws GSSException, KrbException, IOException {
            Object object;
            Object object2;
            int n;
            boolean bl = false;
            this.checksumBytes = checksum.getBytes();
            if (this.checksumBytes[0] != InitialToken.this.CHECKSUM_FIRST_BYTES[0] || this.checksumBytes[1] != InitialToken.this.CHECKSUM_FIRST_BYTES[1] || this.checksumBytes[2] != InitialToken.this.CHECKSUM_FIRST_BYTES[2] || this.checksumBytes[3] != InitialToken.this.CHECKSUM_FIRST_BYTES[3]) {
                throw new GSSException(-1);
            }
            byte[] byArray = new byte[16];
            System.arraycopy(this.checksumBytes, 4, byArray, 0, 16);
            byte[] byArray2 = new byte[16];
            boolean bl2 = !Arrays.equals(byArray2, byArray);
            ChannelBinding channelBinding = krb5Context.getChannelBinding();
            if (bl2 || channelBinding != null) {
                n = 0;
                object2 = null;
                if (bl2 && channelBinding != null) {
                    object = InitialToken.this.computeChannelBinding(channelBinding);
                    n = !Arrays.equals(object, byArray) ? 1 : 0;
                    object2 = "Bytes mismatch!";
                } else if (channelBinding == null) {
                    object2 = "ChannelBinding not provided!";
                    n = 1;
                } else {
                    object2 = "Token missing ChannelBinding!";
                    n = 1;
                }
                if (n != 0) {
                    throw new GSSException(1, -1, (String)object2);
                }
            }
            this.flags = Krb5Token.readLittleEndian(this.checksumBytes, 20, 4);
            if ((this.flags & 1) > 0) {
                n = Krb5Token.readLittleEndian(this.checksumBytes, 26, 2);
                object2 = new byte[n];
                System.arraycopy(this.checksumBytes, 28, object2, 0, n);
                object = krb5Context.getCipherHelper(encryptionKey);
                this.delegCreds = this.useNullKey((CipherHelper)object) ? new KrbCred((byte[])object2, EncryptionKey.NULL_KEY).getDelegatedCreds()[0] : new KrbCred((byte[])object2, encryptionKey).getDelegatedCreds()[0];
            }
        }

        private boolean useNullKey(CipherHelper cipherHelper) {
            boolean bl = true;
            if (cipherHelper.getProto() == 1 || cipherHelper.isArcFour()) {
                bl = false;
            }
            return bl;
        }

        public Checksum getChecksum() throws KrbException {
            return new Checksum(this.checksumBytes, 32771);
        }

        public Credentials getDelegatedCreds() {
            return this.delegCreds;
        }

        public void setContextFlags(Krb5Context krb5Context) {
            if ((this.flags & 1) > 0) {
                krb5Context.setCredDelegState(true);
            }
            if ((this.flags & 2) == 0) {
                krb5Context.setMutualAuthState(false);
            }
            if ((this.flags & 4) == 0) {
                krb5Context.setReplayDetState(false);
            }
            if ((this.flags & 8) == 0) {
                krb5Context.setSequenceDetState(false);
            }
            if ((this.flags & 0x10) == 0) {
                krb5Context.setConfState(false);
            }
            if ((this.flags & 0x20) == 0) {
                krb5Context.setIntegState(false);
            }
        }
    }
}

