/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean initOidTable = false;
    private static Map<String, ObjectIdentifier> oidTable;
    private static final Map<ObjectIdentifier, String> nameTable;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    private boolean constructedFromDer = true;
    protected DerValue params;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    public static final ObjectIdentifier SHA256_oid;
    public static final ObjectIdentifier SHA384_oid;
    public static final ObjectIdentifier SHA512_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static ObjectIdentifier DH_oid;
    public static ObjectIdentifier DH_PKIX_oid;
    public static ObjectIdentifier DSA_oid;
    public static ObjectIdentifier DSA_OIW_oid;
    public static ObjectIdentifier RSA_oid;
    public static ObjectIdentifier RSAEncryption_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] sha256WithRSAEncryption_data;
    private static final int[] sha384WithRSAEncryption_data;
    private static final int[] sha512WithRSAEncryption_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    public static ObjectIdentifier md2WithRSAEncryption_oid;
    public static ObjectIdentifier md5WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static ObjectIdentifier sha256WithRSAEncryption_oid;
    public static ObjectIdentifier sha384WithRSAEncryption_oid;
    public static ObjectIdentifier sha512WithRSAEncryption_oid;
    public static ObjectIdentifier shaWithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_oid;
    public static final ObjectIdentifier pbeWithMD5AndDES_oid;
    public static final ObjectIdentifier pbeWithMD5AndRC2_oid;
    public static final ObjectIdentifier pbeWithSHA1AndDES_oid;
    public static final ObjectIdentifier pbeWithSHA1AndRC2_oid;
    public static ObjectIdentifier pbeWithSHA1AndDESede_oid;
    public static ObjectIdentifier pbeWithSHA1AndRC2_40_oid;

    @Deprecated
    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        return AlgorithmId.get(string);
    }

    public AlgorithmParameters getParameters() {
        return this.algParams;
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = AlgorithmId.algOID(string);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + string);
        }
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId get(AlgorithmParameters algorithmParameters) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = null;
        String string = algorithmParameters.getAlgorithm();
        try {
            objectIdentifier = AlgorithmId.algOID(string);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + string);
        }
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier, algorithmParameters);
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (derValue.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.tag == 5) {
                if (derValue2.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                derValue2 = null;
            }
            if (derInputStream.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        AlgorithmId algorithmId = new AlgorithmId(objectIdentifier, derValue2);
        if (derValue2 != null) {
            algorithmId.decodeParams();
        }
        return algorithmId;
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.algid = objectIdentifier;
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, AlgorithmParameters algorithmParameters) {
        this.algid = objectIdentifier;
        this.algParams = algorithmParameters;
        this.constructedFromDer = false;
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.algid = objectIdentifier;
        this.params = derValue;
        if (this.params != null) {
            this.decodeParams();
        }
    }

    @Deprecated
    public AlgorithmId() {
    }

    protected void decodeParams() throws IOException {
        try {
            this.algParams = AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.algid);
        if (!this.constructedFromDer) {
            this.params = this.algParams != null ? new DerValue(this.algParams.getEncoded()) : null;
        }
        if (this.params == null) {
            derOutputStream.putNull();
        } else {
            derOutputStream.putDerValue(this.params);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid);
        if (this.params == null) {
            derOutputStream2.putNull();
        } else {
            derOutputStream2.putDerValue(this.params);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private static ObjectIdentifier algOID(String string) throws IOException {
        if (string.indexOf(46) != -1) {
            if (string.startsWith("OID.")) {
                return new ObjectIdentifier(string.substring("OID.".length()));
            }
            return new ObjectIdentifier(string);
        }
        if (string.equalsIgnoreCase("MD5")) {
            return MD5_oid;
        }
        if (string.equalsIgnoreCase("MD2")) {
            return MD2_oid;
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("SHA-1")) {
            return SHA_oid;
        }
        if (string.equalsIgnoreCase("SHA-256") || string.equalsIgnoreCase("SHA256")) {
            return SHA256_oid;
        }
        if (string.equalsIgnoreCase("SHA-384") || string.equalsIgnoreCase("SHA384")) {
            return SHA384_oid;
        }
        if (string.equalsIgnoreCase("SHA-512") || string.equalsIgnoreCase("SHA512")) {
            return SHA512_oid;
        }
        if (string.equalsIgnoreCase("RSA")) {
            return RSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("Diffie-Hellman") || string.equalsIgnoreCase("DH")) {
            return DH_oid;
        }
        if (string.equalsIgnoreCase("DSA")) {
            return DSA_oid;
        }
        if (string.equalsIgnoreCase("MD5withRSA") || string.equalsIgnoreCase("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("MD2withRSA") || string.equalsIgnoreCase("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("SHAwithDSA") || string.equalsIgnoreCase("SHA1withDSA") || string.equalsIgnoreCase("SHA/DSA") || string.equalsIgnoreCase("SHA1/DSA") || string.equalsIgnoreCase("DSAWithSHA1") || string.equalsIgnoreCase("DSS") || string.equalsIgnoreCase("SHA-1/DSA")) {
            return sha1WithDSA_oid;
        }
        if (string.equalsIgnoreCase("SHA1WithRSA") || string.equalsIgnoreCase("SHA1/RSA")) {
            return sha1WithRSAEncryption_oid;
        }
        if (!initOidTable) {
            Provider[] providerArray = Security.getProviders();
            block0: for (int i = 0; i < providerArray.length; ++i) {
                Enumeration<Object> enumeration = providerArray[i].keys();
                while (enumeration.hasMoreElements()) {
                    int n;
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.toUpperCase().startsWith("ALG.ALIAS") || (n = string2.toUpperCase().indexOf("OID.", 0)) == -1) continue;
                    if ((n += "OID.".length()) == string2.length()) continue block0;
                    if (oidTable == null) {
                        oidTable = new HashMap<String, ObjectIdentifier>();
                    }
                    String string3 = string2.substring(n);
                    String string4 = providerArray[i].getProperty(string2).toUpperCase();
                    if (oidTable.get(string4) != null) continue;
                    oidTable.put(string4, new ObjectIdentifier(string3));
                }
            }
            initOidTable = true;
        }
        return oidTable.get(string.toUpperCase());
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public String getName() {
        String string = nameTable.get(this.algid);
        return string == null ? this.algid.toString() : string;
    }

    public String toString() {
        return this.getName() + this.paramsToString();
    }

    public byte[] getEncodedParams() throws IOException {
        return this.params == null ? null : this.params.toByteArray();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        if (this.algParams != null) {
            return this.algParams.toString();
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId algorithmId) {
        boolean bl = this.params == null ? algorithmId.params == null : this.params.equals(algorithmId.params);
        return this.algid.equals(algorithmId.algid) && bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AlgorithmId) {
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        return this.algid.equals(objectIdentifier);
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.algid.toString());
        stringBuilder.append(this.paramsToString());
        return stringBuilder.toString().hashCode();
    }

    static {
        MD2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 2, 2});
        MD5_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 2, 5});
        SHA_oid = ObjectIdentifier.newInternal(new int[]{1, 3, 14, 3, 2, 26});
        SHA256_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1});
        SHA384_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2});
        SHA512_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3});
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{1, 2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
        sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
        sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        pbeWithMD5AndDES_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 3});
        pbeWithMD5AndRC2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 6});
        pbeWithSHA1AndDES_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 10});
        pbeWithSHA1AndRC2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 11});
        pbeWithSHA1AndDESede_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 12, 1, 3});
        pbeWithSHA1AndRC2_40_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 12, 1, 6});
        DH_oid = ObjectIdentifier.newInternal(DH_data);
        DH_PKIX_oid = ObjectIdentifier.newInternal(DH_PKIX_data);
        DSA_OIW_oid = ObjectIdentifier.newInternal(DSA_OIW_data);
        DSA_oid = ObjectIdentifier.newInternal(DSA_PKIX_data);
        RSA_oid = ObjectIdentifier.newInternal(RSA_data);
        RSAEncryption_oid = ObjectIdentifier.newInternal(RSAEncryption_data);
        md2WithRSAEncryption_oid = ObjectIdentifier.newInternal(md2WithRSAEncryption_data);
        md5WithRSAEncryption_oid = ObjectIdentifier.newInternal(md5WithRSAEncryption_data);
        sha1WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha1WithRSAEncryption_data);
        sha1WithRSAEncryption_OIW_oid = ObjectIdentifier.newInternal(sha1WithRSAEncryption_OIW_data);
        sha256WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha256WithRSAEncryption_data);
        sha384WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha384WithRSAEncryption_data);
        sha512WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha512WithRSAEncryption_data);
        shaWithDSA_OIW_oid = ObjectIdentifier.newInternal(shaWithDSA_OIW_data);
        sha1WithDSA_OIW_oid = ObjectIdentifier.newInternal(sha1WithDSA_OIW_data);
        sha1WithDSA_oid = ObjectIdentifier.newInternal(dsaWithSHA1_PKIX_data);
        nameTable = new HashMap<ObjectIdentifier, String>();
        nameTable.put(MD5_oid, "MD5");
        nameTable.put(MD2_oid, "MD2");
        nameTable.put(SHA_oid, "SHA");
        nameTable.put(SHA256_oid, "SHA256");
        nameTable.put(SHA384_oid, "SHA384");
        nameTable.put(SHA512_oid, "SHA512");
        nameTable.put(RSAEncryption_oid, "RSA");
        nameTable.put(RSA_oid, "RSA");
        nameTable.put(DH_oid, "Diffie-Hellman");
        nameTable.put(DH_PKIX_oid, "Diffie-Hellman");
        nameTable.put(DSA_oid, "DSA");
        nameTable.put(DSA_OIW_oid, "DSA");
        nameTable.put(md5WithRSAEncryption_oid, "MD5withRSA");
        nameTable.put(md2WithRSAEncryption_oid, "MD2withRSA");
        nameTable.put(sha1WithDSA_oid, "SHA1withDSA");
        nameTable.put(sha1WithDSA_OIW_oid, "SHA1withDSA");
        nameTable.put(shaWithDSA_OIW_oid, "SHA1withDSA");
        nameTable.put(sha1WithRSAEncryption_oid, "SHA1withRSA");
        nameTable.put(sha1WithRSAEncryption_OIW_oid, "SHA1withRSA");
        nameTable.put(sha256WithRSAEncryption_oid, "SHA256withRSA");
        nameTable.put(sha384WithRSAEncryption_oid, "SHA384withRSA");
        nameTable.put(sha512WithRSAEncryption_oid, "SHA512withRSA");
        nameTable.put(pbeWithMD5AndDES_oid, "PBEWithMD5AndDES");
        nameTable.put(pbeWithMD5AndRC2_oid, "PBEWithMD5AndRC2");
        nameTable.put(pbeWithSHA1AndDES_oid, "PBEWithSHA1AndDES");
        nameTable.put(pbeWithSHA1AndRC2_oid, "PBEWithSHA1AndRC2");
        nameTable.put(pbeWithSHA1AndDESede_oid, "PBEWithSHA1AndDESede");
        nameTable.put(pbeWithSHA1AndRC2_40_oid, "PBEWithSHA1AndRC2_40");
    }
}

