/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JPDA;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.LaunchSelection;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.AssociationDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Launcher
implements Runnable {
    private DownloadWindow _downloadWindow = null;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private boolean _exit = true;
    private JAuthenticator _ja;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._launchDesc = launchDesc;
        this._downloadWindow = new DownloadWindow();
        Trace.println((String)("new Launcher: " + launchDesc.toString()), (TraceLevel)TraceLevel.BASIC);
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray;
        this._exit = bl;
        new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        DiskCacheEntry diskCacheEntry = null;
        try {
            if (launchDesc.isApplicationDescriptor()) {
                diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getCanonicalHome());
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
        }
        if (diskCacheEntry == null) {
            return;
        }
        File file = diskCacheEntry.getFile();
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    public void run() {
        block6: {
            LaunchDesc launchDesc = this._launchDesc;
            boolean bl = LaunchDownload.updateLaunchDescInCache(launchDesc);
            this.removeTempJnlpFile(launchDesc);
            if (launchDesc.getResources() != null) {
                Globals.getDebugOptionsFromProperties(launchDesc.getResources().getResourceProperties());
            }
            if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
                this._ja = JAuthenticator.getInstance(this._downloadWindow.getFrame());
                Authenticator.setDefault((Authenticator)((Object)this._ja));
            }
            int n = 0;
            boolean bl2 = false;
            boolean bl3 = Globals.isSilentMode();
            boolean bl4 = Globals.isImportMode() || launchDesc.getLaunchType() == 3;
            try {
                do {
                    bl2 = n == 3;
                    this._downloadWindow.setLaunchDesc(launchDesc, true);
                    launchDesc = this.handleLaunchFile(launchDesc, this._args, !bl2, bl4, bl3, bl);
                    ++n;
                } while (launchDesc != null && !bl2);
            }
            catch (ExitException exitException) {
                int n2;
                int n3 = n2 = exitException.getReason() == 0 ? 0 : -1;
                if (exitException.getReason() == 2) {
                    LaunchErrorDialog.show(this._downloadWindow == null ? null : this._downloadWindow.getFrame(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block6;
                Main.systemExit(n2);
            }
        }
    }

    private LaunchDesc handleLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ExitException {
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        VersionID versionID = new VersionID("1.5");
        if (!versionString.contains(new VersionID("1.5")) && !versionString.contains(new VersionID("1.0"))) {
            JNLPException.setDefaultLaunchDesc(launchDesc);
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
        }
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!(bl2 || launchDesc.isLibrary() || launchDesc.isJRESpecified())) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        boolean bl5 = launchDesc.getLaunchType() == 4;
        return this.handleApplicationDesc(launchDesc, stringArray, bl5, bl, bl2, bl3, bl4);
    }

    private LaunchDesc handleApplicationDesc(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws ExitException {
        Object object;
        Object object2;
        boolean bl6;
        JNLPException.setDefaultLaunchDesc(launchDesc);
        JREInfo jREInfo = null;
        jREInfo = launchDesc.getSelectedJRE();
        JFrame jFrame = this._downloadWindow.getFrame();
        URL uRL = launchDesc.getCanonicalHome();
        if (uRL == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException, 2);
        }
        LocalApplicationProperties localApplicationProperties = null;
        if (bl) {
            localApplicationProperties = Cache.getLocalApplicationProperties(stringArray[0], launchDesc);
            if (localApplicationProperties == null || !Globals.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            uRL = localApplicationProperties.getLocation();
        } else {
            localApplicationProperties = Cache.getLocalApplicationProperties(uRL, launchDesc);
        }
        Trace.println((String)("LaunchDesc location: " + uRL + ", version: " + localApplicationProperties.getVersionId()), (TraceLevel)TraceLevel.BASIC);
        boolean bl7 = LaunchDownload.isInCache(launchDesc);
        boolean bl8 = bl6 = bl7 && Globals.isOffline();
        if (!bl3) {
            if (jREInfo == null) {
                JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
                if (jREDesc != null) {
                    String string;
                    boolean bl9;
                    object2 = Config.getProperty((String)"deployment.javaws.autodownload");
                    if (object2 != null && ((String)object2).equalsIgnoreCase("NEVER")) {
                        throw new ExitException(new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 2);
                    }
                    object = jREDesc.getSource();
                    URL uRL2 = jREDesc.getHref();
                    boolean bl10 = bl9 = uRL2 == null;
                    if (bl9) {
                        string = Config.getProperty((String)"deployment.javaws.installURL");
                        try {
                            uRL2 = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new ExitException(malformedURLException, 2);
                        }
                    }
                    string = null;
                    string = LaunchDownload.getAvailableVersion(uRL2, jREDesc.getVersion(), bl9, JREInfo.getKnownPlatforms());
                    if (string == null) {
                        string = jREDesc.getVersion();
                    }
                    if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, true, string) ? !SecureStaticVersioning.promptDownload(jFrame, launchDesc, localApplicationProperties, string, (String)object) : object2 != null && ((String)object2).equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(jFrame, launchDesc)) {
                        throw new ExitException(null, 0);
                    }
                }
            } else if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, false, jREInfo.getProduct()) && !SecureStaticVersioning.promptUse(jFrame, launchDesc, localApplicationProperties, jREInfo)) {
                throw new ExitException(null, 0);
            }
        }
        int n = Config.getIntProperty((String)"deployment.javaws.update.timeout");
        boolean bl11 = !bl7 || !bl3 && jREInfo == null || !bl6 && (localApplicationProperties.forceUpdateCheck() || bl || new RapidUpdateCheck().doUpdateCheck(launchDesc, localApplicationProperties, n));
        Trace.println((String)("Offline mode: " + bl6 + "\nIsInCache: " + bl7 + "\nforceUpdate: " + bl11 + "\nInstalled JRE: " + jREInfo + "\nIsInstaller: " + bl), (TraceLevel)TraceLevel.BASIC);
        if (bl11 && bl6) {
            throw new ExitException(new OfflineLaunchException(), 2);
        }
        object2 = new ArrayList();
        if (bl11) {
            object = this.downloadResources(launchDesc, !bl3 && jREInfo == null, !bl && bl2, (ArrayList)object2, bl4);
            if (object != null) {
                this.removeTempJnlpFile(launchDesc);
                return object;
            }
            if (localApplicationProperties.forceUpdateCheck()) {
                localApplicationProperties.setForceUpdateCheck(false);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            if (!bl4) {
                Launcher.checkCacheMax();
            }
        }
        if (SingleInstanceManager.isServerRunning((String)launchDesc.getCanonicalHome().toString())) {
            object = Globals.getApplicationArgs();
            if (object != null) {
                launchDesc.getApplicationDescriptor().setArguments((String[])object);
            }
            if (SingleInstanceManager.connectToServer((String)launchDesc.toString())) {
                throw new ExitException(null, 0);
            }
        }
        if (!bl4) {
            SplashScreen.generateCustomSplash(jFrame, launchDesc, bl11 || bl5);
        }
        if (!bl3 && !((ArrayList)object2).isEmpty()) {
            if (bl) {
                // empty if block
            }
            this.executeInstallers((ArrayList)object2);
            if (jREInfo == null) {
                object = Config.getJavaHome() + File.separator + "bin" + File.separator;
                Config.getInstance().notifyJREInstalled((String)object);
            }
        }
        if (!bl4 && this._downloadWindow.getFrame() != null) {
            object = ResourceManager.getString((String)"launch.launchApplication");
            if (launchDesc.getLaunchType() == 4) {
                object = ResourceManager.getString((String)"launch.launchInstaller");
            }
            this._downloadWindow.showLaunchingApplication((String)object);
        }
        if (!bl3) {
            boolean bl12;
            if (jREInfo == null) {
                Config.refreshProps();
                jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    object = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Exception)object, 2);
                }
            }
            object = launchDesc.getResources().getSelectedJRE();
            long l = ((JREDesc)object).getMinHeap();
            long l2 = ((JREDesc)object).getMaxHeap();
            boolean bl13 = JnlpxArgs.isCurrentRunningJREHeap(l, l2);
            Properties properties = launchDesc.getResources().getResourceProperties();
            String string = ((JREDesc)object).getVmArgs();
            boolean bl14 = JnlpxArgs.isAuxArgsMatch(properties, string);
            boolean bl15 = bl12 = JPDA.getDebuggeeType() == 1 || JPDA.getDebuggeeType() == 3;
            if (bl12 || !JnlpxArgs.getJVMCommand().equals(new File(jREInfo.getPath())) || !bl13 || !bl14) {
                try {
                    stringArray = this.insertApplicationArgs(stringArray);
                    Launcher.execProgram(jREInfo, stringArray, l, l2, properties, string);
                }
                catch (IOException iOException) {
                    throw new ExitException(new JreExecException(jREInfo.getPath(), iOException), 2);
                }
                if (JnlpxArgs.shouldRemoveArgumentFile()) {
                    JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                }
                throw new ExitException(null, 0);
            }
        }
        JnlpxArgs.removeArgumentFile(stringArray);
        if (bl3) {
            this._downloadWindow.disposeWindow();
            this.notifyLocalInstallHandler(launchDesc, localApplicationProperties, bl11 || bl5, bl3, bl4, null);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        this.continueLaunch(localApplicationProperties, bl6, uRL, launchDesc, bl11 || bl5, bl3, bl4);
        return null;
    }

    public static void checkCacheMax() {
        long l = Config.getCacheSizeMax();
        if (l > 0L) {
            try {
                long l2 = Cache.getCacheSize();
                if (l2 > l * 90L / 100L) {
                    String string = Config.getTempDirectory() + File.separator + "cachemax.timestamp";
                    File file = new File(string);
                    file.createNewFile();
                    long l3 = file.lastModified();
                    long l4 = new Date().getTime();
                    if (l4 - l3 > 60000L) {
                        file.setLastModified(l4);
                        final String string2 = ResourceManager.getString((String)"jnlp.cache.warning.title");
                        final String string3 = ResourceManager.getString((String)"jnlp.cache.warning.message", (String)Launcher.sizeString(l2), (String)Launcher.sizeString(l));
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DialogFactory.showMessageDialog((int)3, (Object)string3, (String)string2, (boolean)true);
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private static String sizeString(long l) {
        if (l > 0x100000L) {
            return "" + l / 0x100000L + "Mb";
        }
        return "" + l + "bytes";
    }

    private void executeInstallers(ArrayList arrayList) throws ExitException {
        if (this._downloadWindow.getFrame() != null) {
            String string = ResourceManager.getString((String)"launch.launchInstaller");
            this._downloadWindow.showLaunchingApplication(string);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Launcher.this._downloadWindow.setVisible(false);
                }
            }).start();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(file.getPath(), launchDesc);
                localApplicationProperties.setLocallyInstalled(false);
                localApplicationProperties.store();
                Trace.println((String)("Installing extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (Globals.isSystemCache()) {
                    arrayList2.add("-system");
                }
                arrayList2.add("-installer");
                arrayList2.add(file.getAbsolutePath());
                String[] stringArray = arrayList2.toArray(new String[0]);
                JREInfo jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    this._downloadWindow.setVisible(true);
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 2);
                }
                boolean bl = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                Properties properties = launchDesc.getResources().getResourceProperties();
                Process process = Launcher.execProgram(jREInfo, stringArray, -1L, -1L, properties, null);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(bl));
                localApplicationProperties.refresh();
                if (localApplicationProperties.isRebootNeeded()) {
                    boolean bl2 = false;
                    ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                    if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(this._downloadWindow.getFrame())) {
                        bl2 = true;
                    }
                    localApplicationProperties.setLocallyInstalled(true);
                    localApplicationProperties.setRebootNeeded(false);
                    localApplicationProperties.store();
                    if (bl2 && extensionInstallHandler.doReboot()) {
                        throw new ExitException(null, 1);
                    }
                }
                if (localApplicationProperties.isLocallyInstalled()) continue;
                this._downloadWindow.setVisible(true);
                throw new ExitException(new LaunchDescException(launchDesc, ResourceManager.getString((String)"Launch.error.installfailed"), null), 2);
            }
            catch (JNLPException jNLPException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(jNLPException, 2);
            }
            catch (IOException iOException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(iOException, 2);
            }
            catch (InterruptedException interruptedException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(interruptedException, 2);
            }
        }
    }

    public static void executeUninstallers(ArrayList arrayList) throws ExitException {
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                Serializable serializable;
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(file.getPath(), launchDesc);
                Trace.println((String)("uninstalling extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                if (!launchDesc.isInstaller()) {
                    throw new ExitException(null, 2);
                }
                String[] stringArray = new String[]{"-silent", launchDesc.isSecure() ? "" : "-secure", "-installer", file.getAbsolutePath()};
                JREInfo jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    serializable = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Exception)serializable, 2);
                }
                serializable = launchDesc.getResources().getResourceProperties();
                Process process = Launcher.execProgram(jREInfo, stringArray, -1L, -1L, serializable, null);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                localApplicationProperties.refresh();
                if (!localApplicationProperties.isRebootNeeded()) continue;
                boolean bl = false;
                ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(null)) {
                    bl = true;
                }
                localApplicationProperties.setRebootNeeded(false);
                localApplicationProperties.setLocallyInstalled(false);
                localApplicationProperties.store();
                if (!bl || !extensionInstallHandler.doReboot()) continue;
                throw new ExitException(null, 1);
            }
            catch (JNLPException jNLPException) {
                throw new ExitException(jNLPException, 2);
            }
            catch (IOException iOException) {
                throw new ExitException(iOException, 2);
            }
            catch (InterruptedException interruptedException) {
                throw new ExitException(interruptedException, 2);
            }
        }
    }

    private static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, Properties properties, String string) throws IOException {
        int n;
        String string2 = null;
        String string3 = null;
        string3 = jREInfo.getPath();
        string2 = Config.isDebugMode() && Config.isDebugVMMode() ? jREInfo.getDebugJavaPath() : jREInfo.getPath();
        if (string2.length() == 0 || string3.length() == 0) {
            throw new IllegalArgumentException("must exist");
        }
        String[] stringArray2 = JnlpxArgs.getArgumentList(string3, l, l2, properties, string);
        int n2 = 1 + stringArray2.length + stringArray.length;
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        stringArray3[n3++] = string2;
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n3++] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n3++] = stringArray[n];
        }
        stringArray3 = JPDA.JpdaSetup(stringArray3, jREInfo);
        Trace.println((String)("Launching new JRE version: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        for (n = 0; n < stringArray3.length; ++n) {
            stringArray3[n] = Config.getInstance().escapeBackslashAndQuoteString(stringArray3[n]);
            Trace.println((String)("cmd " + n + " : " + stringArray3[n]), (TraceLevel)TraceLevel.BASIC);
        }
        if (Globals.TCKHarnessRun) {
            Main.tckprintln("JVM Starting");
        }
        Trace.flush();
        return Runtime.getRuntime().exec(stringArray3);
    }

    private void continueLaunch(LocalApplicationProperties localApplicationProperties, boolean bl, URL uRL, LaunchDesc launchDesc, boolean bl2, boolean bl3, boolean bl4) throws ExitException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        AppPolicy appPolicy = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        try {
            LaunchDownload.checkSignedLaunchDesc(launchDesc);
            LaunchDownload.checkSignedResources(launchDesc);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        final JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader(launchDesc, appPolicy);
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        System.setSecurityManager(new JavaWebStartSecurity());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(jNLPClassLoader);
                    try {
                        UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        unsupportedLookAndFeelException.printStackTrace();
                        Trace.ignoredException((Exception)unsupportedLookAndFeelException);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException((Exception)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException((Exception)invocationTargetException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavawsConsoleController.showConsoleIfEnable();
            }
        });
        String string = null;
        Class<?> clazz = null;
        try {
            string = LaunchDownload.getMainClassName(launchDesc, true);
            Trace.println((String)("Main-class: " + string), (TraceLevel)TraceLevel.BASIC);
            if (string == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = jNLPClassLoader.loadClass(string);
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string);
            }
            object3 = clazz.getClassLoader();
            if (object3 != jNLPClassLoader) {
                SecurityException securityException = new SecurityException("Bad main-class name");
                throw new ExitException(securityException, 2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (Exception exception) {
            throw new ExitException(exception, 2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ExitException(new Exception(), 2);
        }
        object3 = launchDesc.getCodebase();
        if (object3 == null) {
            object3 = URLUtil.getBase((URL)uRL);
        }
        try {
            object2 = "http";
            serializable = launchDesc.getCanonicalHome();
            if (serializable.getProtocol().equalsIgnoreCase("file") && serializable.getHost().equals("")) {
                object2 = "file";
            }
            BasicServiceImpl.initialize((URL)object3, bl, BrowserSupport.isWebBrowserSupported(), (String)object2);
            if (launchDesc.getLaunchType() == 4) {
                object = localApplicationProperties.getInstallDirectory();
                if (object == null) {
                    object = Cache.getNewExtensionInstallDirectory();
                    localApplicationProperties.setInstallDirectory((String)object);
                }
                ExtensionInstallerServiceImpl.initialize((String)(launchDesc.isSecure() ? null : object), localApplicationProperties, this._downloadWindow);
            }
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        try {
            object2 = this._downloadWindow;
            this._downloadWindow = null;
            this.notifyLocalInstallHandler(launchDesc, localApplicationProperties, bl2, bl3, bl4, ((DownloadWindow)object2).getFrame());
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            this.executeMainClass(launchDesc, localApplicationProperties, clazz, (DownloadWindow)object2);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExitException(illegalAccessException, 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExitException(illegalArgumentException, 2);
        }
        catch (InstantiationException instantiationException) {
            throw new ExitException(instantiationException, 2);
        }
        catch (InvocationTargetException invocationTargetException) {
            serializable = invocationTargetException;
            object = invocationTargetException.getTargetException();
            if (object instanceof Exception) {
                serializable = (Exception)invocationTargetException.getTargetException();
            } else {
                ((Throwable)object).printStackTrace();
            }
            throw new ExitException((Exception)serializable, 2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 2);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        if (launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private LaunchDesc downloadResources(LaunchDesc launchDesc, boolean bl, boolean bl2, ArrayList arrayList, boolean bl3) throws ExitException {
        if (!this._shownDownloadWindow && !bl3) {
            this._shownDownloadWindow = true;
            this._downloadWindow.buildIntroScreen();
            this._downloadWindow.showLoadingProgressScreen();
            this._downloadWindow.setVisible(true);
            SplashScreen.hide();
        }
        try {
            LaunchDesc launchDesc2;
            if (bl2 && (launchDesc2 = LaunchDownload.getUpdatedLaunchDesc(launchDesc)) != null) {
                return launchDesc2;
            }
            LaunchDownload.downloadExtensions(launchDesc, this._downloadWindow, 0, arrayList);
            if (bl) {
                LaunchDownload.downloadJRE(launchDesc, this._downloadWindow, arrayList);
            }
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, this._downloadWindow, false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 2);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        return null;
    }

    private void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, boolean bl3, Frame frame) {
        if (localApplicationProperties == null) {
            return;
        }
        localApplicationProperties.setLastAccessed(new Date());
        localApplicationProperties.incrementLaunchCount();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (launchDesc.isApplicationDescriptor() && (launchDesc.getLocation() != null || launchDesc.getInformation().supportsOfflineOperation())) {
            Object object;
            if (localInstallHandler != null && localInstallHandler.isLocalInstallSupported()) {
                object = localApplicationProperties.getAssociations();
                if (object != null && ((AssociationDesc[])object).length > 0) {
                    if (bl) {
                        localInstallHandler.removeAssociations(launchDesc, localApplicationProperties);
                        localInstallHandler.createAssociations(launchDesc, localApplicationProperties, true, frame);
                    }
                } else {
                    localInstallHandler.createAssociations(launchDesc, localApplicationProperties, bl3, frame);
                }
                if (localApplicationProperties.isLocallyInstalled()) {
                    if (bl && !localApplicationProperties.isLocallyInstalledSystem()) {
                        localInstallHandler.uninstall(launchDesc, localApplicationProperties, true);
                        localInstallHandler.install(launchDesc, localApplicationProperties);
                    }
                } else {
                    localInstallHandler.installFromLaunch(launchDesc, localApplicationProperties, bl3, frame);
                }
            }
            if (bl) {
                object = launchDesc.getInformation().getTitle();
                String string = launchDesc.getCanonicalHome().toString();
                String string2 = localApplicationProperties.getRegisteredTitle();
                if (string2 != null && string2.length() != 0) {
                    Config.getInstance().addRemoveProgramsRemove(string2, Globals.isSystemCache());
                }
                localApplicationProperties.setRegisteredTitle((String)object);
                Config.getInstance().addRemoveProgramsAdd(Config.getInstance().toExecArg(string), (String)object, Globals.isSystemCache());
            }
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            this.executeApplet(launchDesc, clazz, downloadWindow);
        } else {
            this.executeApplication(launchDesc, localApplicationProperties, clazz, downloadWindow);
        }
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            downloadWindow.reset();
            stringArray = new String[]{localApplicationProperties.isLocallyInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setLocallyInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            downloadWindow.disposeWindow();
            SplashScreen.hide();
            stringArray = Globals.getApplicationArgs() != null ? Globals.getApplicationArgs() : launchDesc.getApplicationDescriptor().getArguments();
        }
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        PerfLogger.setEndTime((String)"Calling Application main");
        PerfLogger.outputLog();
        method.invoke(null, objectArray);
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException {
        AppletDesc appletDesc = launchDesc.getAppletDescriptor();
        int n = appletDesc.getWidth();
        int n2 = appletDesc.getHeight();
        Applet applet = null;
        applet = (Applet)clazz.newInstance();
        SplashScreen.hide();
        if (downloadWindow.getFrame() == null) {
            downloadWindow.buildIntroScreen();
            downloadWindow.showLaunchingApplication(launchDesc.getInformation().getTitle());
        }
        final JFrame jFrame = downloadWindow.getFrame();
        boolean bl = BrowserSupport.isWebBrowserSupported();
        AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

            public void showDocument(URL uRL) {
                BrowserSupport.showDocument(uRL);
            }

            public void relativeResize(Dimension dimension) {
                Dimension dimension2 = jFrame.getSize();
                dimension2.width += dimension.width;
                dimension2.height += dimension.height;
                jFrame.setSize(dimension2);
            }
        };
        URL uRL = BasicServiceImpl.getInstance().getCodeBase();
        URL uRL2 = appletDesc.getDocumentBase();
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
        jFrame.removeWindowListener(downloadWindow);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                appletContainer.stopApplet();
            }
        });
        downloadWindow.clearWindow();
        jFrame.setTitle(launchDesc.getInformation().getTitle());
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", appletContainer);
        jFrame.pack();
        Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
        jFrame.setSize(dimension);
        jFrame.getRootPane().revalidate();
        jFrame.getRootPane().repaint();
        jFrame.setResizable(false);
        if (!jFrame.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jFrame.setVisible(true);
                }
            });
        }
        appletContainer.startApplet();
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getCanonicalHome());
            if (diskCacheEntry != null) {
                Cache.removeEntry(diskCacheEntry);
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
        }
        JFrame jFrame = this._downloadWindow == null ? null : this._downloadWindow.getFrame();
        throw new ExitException(exception, 2);
    }

    private static class EatInput
    implements Runnable {
        private InputStream _is;

        EatInput(InputStream inputStream) {
            this._is = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                int n = 0;
                while (n != -1) {
                    n = this._is.read(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void eatInput(InputStream inputStream) {
            EatInput eatInput = new EatInput(inputStream);
            new Thread(eatInput).start();
        }
    }

    private class RapidUpdateCheck
    extends Thread {
        private LaunchDesc _ld = null;
        private LocalApplicationProperties _lap;
        private boolean _updateAvailable;
        private boolean _checkCompleted;
        private boolean _checkFaulted = false;
        private Object _signalObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doUpdateCheck(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, int n) {
            this._ld = launchDesc;
            this._lap = localApplicationProperties;
            boolean bl = false;
            Object object = this._signalObject;
            synchronized (object) {
                this._updateAvailable = false;
                this._checkCompleted = false;
                this.start();
                do {
                    if (launchDesc.getInformation().supportsOfflineOperation()) {
                        try {
                            this._signalObject.wait(n);
                            bl = this._updateAvailable;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                        }
                        continue;
                    }
                    try {
                        this._signalObject.wait(n);
                        bl = this._updateAvailable || !this._checkCompleted;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                } while (!this._checkFaulted && (this._ld.isHttps() && !this._checkCompleted || Launcher.this._ja != null && Launcher.this._ja.isChallanging()));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                bl = LaunchDownload.isUpdateAvailable(this._ld);
                bl2 = true;
            }
            catch (FailedDownloadingResourceException failedDownloadingResourceException) {
                Throwable throwable;
                if (this._ld.isHttps() && (throwable = failedDownloadingResourceException.getWrappedException()) != null && throwable instanceof SSLHandshakeException) {
                    Main.systemExit(0);
                }
                bl3 = true;
                Trace.ignoredException((Exception)failedDownloadingResourceException);
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            Object object = this._signalObject;
            synchronized (object) {
                this._updateAvailable = bl;
                this._checkCompleted = bl2;
                this._checkFaulted = bl3;
                this._signalObject.notify();
            }
            if (this._updateAvailable) {
                this._lap.setForceUpdateCheck(true);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
    }
}

