/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.net;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.net.CanceledDownloadException;
import com.sun.javaws.net.HttpDownload;
import com.sun.javaws.net.HttpDownloadListener;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class BasicDownloadLayer
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private HttpRequest _httpRequest;

    public BasicDownloadLayer(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    public void download(HttpResponse httpResponse, File file, final HttpDownloadListener httpDownloadListener, int n) throws CanceledDownloadException, IOException {
        final int n2 = httpResponse.getContentLength();
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(0, n2);
        }
        Trace.println((String)"Doing download", (TraceLevel)TraceLevel.NETWORK);
        BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        String string = httpResponse.getContentEncoding();
        try {
            if (string != null && string.compareTo("pack200-gzip") == 0 && Globals.havePack200()) {
                Trace.println((String)("download:encoding Pack200: = " + string), (TraceLevel)TraceLevel.NETWORK);
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (httpDownloadListener != null && propertyChangeEvent.getPropertyName().compareTo("unpack.progress") == 0) {
                            String string = (String)propertyChangeEvent.getNewValue();
                            int n = string != null ? Integer.parseInt(string) : 0;
                            httpDownloadListener.downloadProgress(n * n2 / 100, n2);
                        }
                    }
                });
                JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);
                unpacker.unpack((InputStream)bufferedInputStream, jarOutputStream);
                jarOutputStream.close();
            } else {
                Trace.println((String)("download:encoding GZIP/Plain = " + string), (TraceLevel)TraceLevel.NETWORK);
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = new byte[32768];
                while ((n3 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                    if (!(n != 0 && n != 1 || n5 != 0 || DownloadProtocol.isJarHeaderValid(byArray))) {
                        throw new IOException("Invalid jar file");
                    }
                    bufferedOutputStream.write(byArray, 0, n3);
                    if ((n4 += n3) > n2 && n2 != 0) {
                        n4 = n2;
                    }
                    if (httpDownloadListener != null) {
                        httpDownloadListener.downloadProgress(n4, n2);
                    }
                    ++n5;
                }
            }
            Trace.println((String)("Wrote URL " + httpResponse.getRequest() + " to file " + file), (TraceLevel)TraceLevel.NETWORK);
            ((InputStream)bufferedInputStream).close();
            bufferedInputStream = null;
            bufferedOutputStream.close();
            bufferedOutputStream = null;
        }
        catch (IOException iOException) {
            Trace.println((String)("Got exception while downloading resource: " + iOException), (TraceLevel)TraceLevel.NETWORK);
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
                bufferedInputStream = null;
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
                bufferedOutputStream = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(n2, n2);
        }
    }

    class PropertyChangeListenerTask
    implements PropertyChangeListener {
        HttpDownloadListener _dl = null;

        PropertyChangeListenerTask(HttpDownloadListener httpDownloadListener) {
            this._dl = httpDownloadListener;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().compareTo("unpack.progress") == 0) {
                String string = (String)propertyChangeEvent.getNewValue();
                if (this._dl != null && string != null) {
                    this._dl.downloadProgress(Integer.parseInt(string), 100);
                }
            }
        }
    }
}

