/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.cache.CachedJarFile;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JNLPCachedJarURLConnection
extends JarURLConnection {
    private URL displayURL = null;
    private URL realURL = null;
    private String _entryName;
    private JarEntry _jarEntry;
    private JarFile _jarFile = null;
    private String _contentType;
    private boolean _useCachedJar = false;

    public String toString() {
        return this.getClass().getName() + ":" + this.displayURL;
    }

    public Permission getPermission() throws IOException {
        this.connect();
        FilePermission filePermission = new FilePermission(this._jarFile.getName(), "read");
        return filePermission;
    }

    public JNLPCachedJarURLConnection(URL uRL, URL uRL2) throws MalformedURLException, IOException {
        super(uRL);
        this.realURL = uRL;
        this.displayURL = uRL2;
        this._entryName = this.getEntryName();
    }

    public URL getJarFileURL() {
        return this.displayURL;
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        return new CachedJarFile(this._jarFile);
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this._jarEntry;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            URLConnection uRLConnection = this.realURL.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                this._jarFile = ((JarURLConnection)uRLConnection).getJarFile();
            }
            if (this._jarFile == null) {
                throw new IOException("Cannot connect to cached JAR");
            }
            this._useCachedJar = true;
            if (this._entryName != null) {
                this._jarEntry = this._jarFile.getJarEntry(this._entryName);
                if (this._jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this._entryName + " not found");
                }
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this._useCachedJar) {
            Object var1_1 = null;
            if (this._entryName == null) {
                throw new IOException("no entry name specified");
            }
            if (this._jarEntry == null) {
                throw new FileNotFoundException("JAR entry " + this._entryName + " not found");
            }
            return this._jarFile.getInputStream(this._jarEntry);
        }
        return super.getInputStream();
    }

    public Object getContent() throws IOException {
        this.connect();
        if (this._useCachedJar && this._entryName == null) {
            return this._jarFile;
        }
        return super.getContent();
    }

    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._useCachedJar) {
            if (this._contentType == null) {
                if (this._entryName == null) {
                    this._contentType = "x-java/jar";
                } else {
                    try {
                        this.connect();
                        InputStream inputStream = this._jarFile.getInputStream(this._jarEntry);
                        this._contentType = JNLPCachedJarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._contentType == null) {
                    this._contentType = JNLPCachedJarURLConnection.guessContentTypeFromName(this._entryName);
                }
                if (this._contentType == null) {
                    this._contentType = "content/unknown";
                }
            }
        } else {
            this._contentType = super.getContentType();
        }
        return this._contentType;
    }

    public int getContentLength() {
        if (this._useCachedJar) {
            return -1;
        }
        return super.getContentLength();
    }
}

