/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.emulator.AbstractVariable;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.exceptions.Fx702pErr2Exception;
import com.fx702p.emulator.exceptions.Fx702pErr6Exception;
import java.math.BigDecimal;

public class FullVariable
extends AbstractVariable {
    private boolean isString = false;
    private StringVariable stringVariable = new StringVariable();
    private NumberVariable numberVariable = new NumberVariable();
    private Fx702pMemory memory;
    private String stringValue = "";
    private BigDecimal numberValue = BigDecimal.ZERO;
    public static final int MAX_LENGTH = 30;

    public FullVariable(Fx702pMemory aMemory, int aComparisonIndex) {
        super(aComparisonIndex);
        this.memory = aMemory;
    }

    public boolean isStringVariable() {
        return this.isString;
    }

    public Object getValue() {
        if (this.isString) {
            return this.stringVariable.getValue();
        }
        return this.numberVariable.getValue();
    }

    public void setValue(Object aValue) {
        if (this.isString) {
            this.stringVariable.setValue(aValue);
        } else {
            this.numberVariable.setValue(aValue);
        }
    }

    public boolean isLoopVariable() {
        return true;
    }

    public void clear() {
        this.isString = false;
        this.numberVariable.clear();
        this.stringVariable.clear();
    }

    public Variable getStringVariable() {
        return this.stringVariable;
    }

    public Variable getNumberVariable() {
        return this.numberVariable;
    }

    private class NumberVariable
    implements Variable {
        private NumberVariable() {
        }

        public boolean isStringVariable() {
            return false;
        }

        public boolean isLoopVariable() {
            return FullVariable.this.isLoopVariable();
        }

        public void clear() {
            FullVariable.this.numberValue = BigDecimal.ZERO;
        }

        public Object getValue() {
            if (FullVariable.this.isString) {
                throw new Fx702pErr6Exception();
            }
            return FullVariable.this.numberValue;
        }

        public void setValue(Object aValue) {
            if (!(aValue instanceof BigDecimal)) {
                throw new Fx702pErr2Exception();
            }
            FullVariable.this.isString = false;
            FullVariable.this.numberValue = (BigDecimal)aValue;
            FullVariable.this.memory.getWatcher().variableModified(FullVariable.this);
            FullVariable.this.memory.markAsModified();
        }

        public int getComparisonIndex() {
            return FullVariable.this.getComparisonIndex();
        }

        public int compareTo(Variable aVariable) {
            return FullVariable.this.compareTo(aVariable);
        }
    }

    private class StringVariable
    implements Variable {
        private StringVariable() {
        }

        public boolean isStringVariable() {
            return true;
        }

        public boolean isLoopVariable() {
            return false;
        }

        public void clear() {
            FullVariable.this.stringValue = "";
        }

        public Object getValue() {
            if (FullVariable.this.isString) {
                return FullVariable.this.stringValue;
            }
            return "";
        }

        public void setValue(Object aValue) {
            if (aValue instanceof String) {
                if (((String)aValue).length() > 30) {
                    throw new Fx702pErr6Exception();
                }
            } else {
                throw new Fx702pErr2Exception();
            }
            FullVariable.this.isString = true;
            FullVariable.this.stringValue = (String)aValue;
            FullVariable.this.memory.getWatcher().variableModified(FullVariable.this);
            FullVariable.this.memory.markAsModified();
        }

        public int getComparisonIndex() {
            return FullVariable.this.getComparisonIndex();
        }

        public int compareTo(Variable aVariable) {
            return FullVariable.this.compareTo(aVariable);
        }
    }
}

