/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.debug.Fx702pDebugger;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Fx702pKey;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.commands.AbstractCommand;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.commands.MultiLineWaitCommand;
import com.fx702p.emulator.commands.StartInputCommand;
import com.fx702p.emulator.implementation.Fx702pCursor;
import com.fx702p.emulator.implementation.Fx702pDefaultMemory;
import com.fx702p.emulator.implementation.Fx702pDisplayBuffer;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pEngine;
import com.fx702p.emulator.implementation.Fx702pInputBuffer;
import com.fx702p.emulator.implementation.Fx702pInterpreterHolder;
import com.fx702p.emulator.implementation.Fx702pKeyboard;
import com.fx702p.emulator.implementation.Fx702pModes;
import com.fx702p.emulator.implementation.MultiLinePrinter;
import com.fx702p.interpreters.Fx702pAbstractInterpreter;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.parser.ParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Fx702pDefaultEmulator
implements Fx702pEmulator {
    protected Fx702pDisplay display;
    protected Fx702pMemory memory;
    protected Fx702pKeyboard keyboard;
    protected Fx702pModes modes;
    protected Fx702pCursor cursor;
    protected Fx702pDisplayBuffer displayBuffer;
    protected Fx702pInputBuffer inputBuffer;
    protected Fx702pEngine engine;
    protected Fx702pInterpreterHolder interpreterHolder;
    protected Fx702pDebugger debugger = null;
    protected boolean clearDisplayBeforeNextPrint = false;
    protected boolean setCursorVisibleAfterNextChar = false;
    protected boolean reusableResult = false;

    public Fx702pDefaultEmulator(Fx702pDisplay aFx702pDisplay) {
        this.display = aFx702pDisplay;
        this.memory = new Fx702pDefaultMemory();
        this.modes = new Fx702pModes(this);
        this.keyboard = new Fx702pKeyboard(this);
        this.cursor = new Fx702pCursor(this);
        this.displayBuffer = new Fx702pDisplayBuffer(this);
        this.inputBuffer = new Fx702pInputBuffer(this);
        this.interpreterHolder = new Fx702pInterpreterHolder(this);
        this.engine = new Fx702pEngine(this);
    }

    protected void callMethod(Fx702pEmulatorComponent.MethodCaller aMethodCaller) {
        aMethodCaller.callMethod(this.keyboard);
        aMethodCaller.callMethod(this.displayBuffer);
        aMethodCaller.callMethod(this.inputBuffer);
        aMethodCaller.callMethod(this.cursor);
        aMethodCaller.callMethod(this.display);
        if (this.debugger != null) {
            aMethodCaller.callMethod(this.debugger);
        }
        this.interpreterHolder.forwardCall(aMethodCaller);
        aMethodCaller.callMethod(this.engine);
    }

    public Fx702pDisplay getDisplay() {
        return this.display;
    }

    public Fx702pMemory getMemory() {
        return this.memory;
    }

    public void run() {
        this.displayRunModeMessage();
        this.engine.run();
    }

    public void setMode(int aMode) {
        this.modes.setMode(aMode);
    }

    public void setRunMode() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.setRunMode();
            }
        });
        this.displayRunModeMessage();
    }

    public void setWrtMode() {
    }

    public void setDefm(int aDefm) {
        this.memory.setDefm(aDefm);
        this.print("VAR: " + this.memory.getVariablesCount() + " PRG: " + this.memory.getProgramStepsCount());
        this.resultPrinted();
    }

    public void keyPressed(Fx702pKey aKey) {
        this.keyboard.keyPressed(aKey);
    }

    public void keyRepeated(Fx702pKey aKey) {
        this.keyboard.keyRepeated(aKey);
    }

    public void keyReleased(Fx702pKey aKey) {
        this.keyboard.keyReleased(aKey);
    }

    public void clearPrefixes() {
        this.keyboard.clearPrefixes();
    }

    public void f1Prefix() {
        this.keyboard.f1Prefix();
    }

    public void f2Prefix() {
        this.keyboard.f2Prefix();
    }

    public void modePrefix() {
        this.keyboard.modePrefix();
    }

    public void arcPrefix() {
        this.keyboard.arcPrefix();
    }

    public void hypPrefix() {
        this.keyboard.hypPrefix();
    }

    public Character getKey() {
        return this.keyboard.getKey();
    }

    public void allClear() {
        this.setReusableResult(false);
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.allClear();
            }
        });
    }

    public void loadProgram(File aProgramFile) throws Exception {
        try {
            this.memory.load(aProgramFile, this.interpreterHolder.getCalculator(), this.display);
            this.afterLoad();
        }
        catch (ParseException exception) {
            this.display.reportError("Cannot load Programs File", "Cannot parse file " + aProgramFile.getName(), exception);
        }
        catch (Throwable exception) {
            this.display.reportError("Cannot load Programs File", "Error while reading " + aProgramFile.getName() + this.getLoadErrorLine(exception), exception);
        }
    }

    public void reloadProgram() throws Exception {
        if (this.memory.getActiveProgram().canBeLoaded()) {
            try {
                this.memory.getActiveProgram().reload(this.interpreterHolder.getCalculator(), this.display);
                this.afterLoad();
            }
            catch (FileNotFoundException exception) {
                this.display.reportError("Cannot reload", "Error whilst reloading from file", exception);
            }
            catch (ParseException exception) {
                this.display.reportError("Cannot reload", "Cannot parse file " + this.memory.getActiveProgram().getProgramFileName(), exception);
            }
            catch (Throwable exception) {
                this.display.reportError("Cannot reload", "Error while reading " + this.memory.getActiveProgram().getProgramFileName() + this.getLoadErrorLine(exception), exception);
            }
        }
    }

    protected String getLoadErrorLine(Throwable anException) {
        int line;
        if (anException instanceof Fx702pException && (line = ((Fx702pException)anException).getLine()) >= 0) {
            return ", line " + line;
        }
        return "";
    }

    public void reloadAll() throws Exception {
        if (this.memory.canBeLoaded()) {
            try {
                this.memory.reload(this.interpreterHolder.getCalculator(), this.display);
                this.afterLoad();
            }
            catch (FileNotFoundException exception) {
                this.display.reportError("Cannot reload All", "Error whilst reloading All from file", exception);
            }
            catch (ParseException exception) {
                this.display.reportError("Cannot reload All", "Cannot parse file " + this.memory.getProgramsFileName(), exception);
            }
            catch (Throwable exception) {
                this.display.reportError("Cannot reload All", "Error while reading " + this.memory.getProgramsFileName() + this.getLoadErrorLine(exception), exception);
            }
        }
    }

    protected void afterLoad() {
        if (this.memory.isAllLoaded()) {
            this.setActiveProgramIndex(0);
            this.displayRunModeMessage();
        }
        if (!this.getActiveProgram().isEmpty()) {
            this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

                public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                    aFx702pEmulatorComponent.loadProgram(Fx702pDefaultEmulator.this.getActiveProgramIndex());
                }
            });
        } else {
            this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

                public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                    aFx702pEmulatorComponent.clearProgram(Fx702pDefaultEmulator.this.getActiveProgramIndex());
                }
            });
        }
    }

    public void saveProgram() {
        if (this.memory.getActiveProgram().canBeSaved(this.memory)) {
            try {
                this.memory.getActiveProgram().save(this);
            }
            catch (IOException exception) {
                this.display.reportError("Cannot save", "Error whilst saving to file", exception);
            }
        }
    }

    public void saveProgramAs(File aProgramFile, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) {
        try {
            this.memory.getActiveProgram().saveAs(this, aProgramFile, aSaveVariablesFlag, aSaveBreakpointsFlag);
        }
        catch (IOException exception) {
            this.display.reportError("Cannot save", "Error whilst saving to file", exception);
        }
    }

    public void saveAll() {
        if (this.memory.canBeSaved()) {
            try {
                this.memory.saveAll(this.getDisplay());
            }
            catch (IOException exception) {
                this.display.reportError("Cannot save", "Error whilst saving to file", exception);
            }
        }
    }

    public void saveAllAs(File aProgramsFile, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) {
        try {
            this.memory.saveAllAs(aProgramsFile, aSaveVariablesFlag, aSaveBreakpointsFlag);
        }
        catch (IOException exception) {
            this.display.reportError("Cannot save", "Error whilst saving to file", exception);
        }
    }

    public void runActiveProgram() {
        if (Thread.currentThread().equals(this)) {
            this.setProgramRunningMode();
        } else {
            this.addCommand(new AbstractCommand(){

                public void execute(Fx702pEmulator anEmulator) {
                    Fx702pDefaultEmulator.this.setProgramRunningMode();
                }
            });
        }
    }

    protected void forwardDebugAndStepActiveProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.debugAndStepActiveProgram();
            }
        });
    }

    public void setDebugger(Fx702pDebugger aDebugger) {
        this.debugger = aDebugger;
    }

    public void debugActiveProgram() {
        if (this.debugger != null) {
            this.interpreterHolder.getBasicInterpreter().setExtraVisitor(this.debugger);
            this.runActiveProgram();
        }
    }

    public void debugAndStepActiveProgram() {
        if (this.debugger != null) {
            this.interpreterHolder.getBasicInterpreter().setExtraVisitor(this.debugger);
            if (Thread.currentThread().equals(this)) {
                this.debugAndStepActiveProgram();
            } else {
                this.addCommand(new AbstractCommand(){

                    public void execute(Fx702pEmulator anEmulator) {
                        Fx702pDefaultEmulator.this.forwardDebugAndStepActiveProgram();
                    }
                });
            }
        }
    }

    public void endDebug() {
        this.debugger = null;
    }

    public void stepInProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.stepInProgram();
            }
        });
    }

    public Fx702pEmulator.ProgramStatus continueExecution() {
        return this.interpreterHolder.getBasicInterpreter().continueExecution();
    }

    public boolean isContinuationDebuggable() {
        return this.interpreterHolder.getBasicInterpreter().isContinuationDebuggable();
    }

    public void setSpeed(int aSpeed) {
        this.engine.setSpeed(aSpeed);
    }

    public void nextLoop(final Variable aVariable) {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.nextLoop(aVariable);
            }
        });
    }

    public void endLoop(final Variable aVariable) {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.endLoop(aVariable);
            }
        });
    }

    protected void setProgramRunningMode() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.runProgram();
            }
        });
    }

    public void endProgram() {
        this.interpreterHolder.getBasicInterpreter().setExtraVisitor(null);
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.endProgram();
            }
        });
    }

    public void stopProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.stopProgram();
            }
        });
    }

    public void contProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.contProgram();
            }
        });
    }

    public void suspendProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.suspendProgram();
            }
        });
    }

    public void resumeProgram() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.resumeProgram();
            }
        });
    }

    public void stop() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.stop();
            }
        });
    }

    public void lastAnswer() {
        this.interpreterHolder.lastAnswer();
    }

    public void cont() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.cont();
            }
        });
    }

    public void printResult(String aString) {
        if (aString == null) {
            this.clearDisplay();
        } else {
            this.print(aString);
            this.resultPrinted();
        }
    }

    protected void resultPrinted() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.resultPrinted();
            }
        });
    }

    public void print(String aString) {
        this.printAndExecute(aString, null);
    }

    public void print(MultiLinePrinter aMultiLinePrinter) {
        this.display.showBusy(true);
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.startMultiLinePrint();
            }
        });
        this.printNextLine(aMultiLinePrinter);
    }

    public void printNextLine(MultiLinePrinter aMultiLinePrinter) {
        String line = aMultiLinePrinter.getLine();
        if (line != null) {
            int timeToWait = aMultiLinePrinter.getTimeToWait();
            aMultiLinePrinter.next();
            this.clearDisplay();
            this.printAndExecute(line, new MultiLineWaitCommand(timeToWait, aMultiLinePrinter));
        } else {
            this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

                public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                    aFx702pEmulatorComponent.endMultiLinePrint();
                }
            });
            this.display.showBusy(false);
        }
    }

    public void printAndExecute(String aString, Command aCommand) {
        String stillToPrint = this.displayBuffer.print(aString);
        if (stillToPrint != null) {
            this.startScroll();
            this.engine.addToPrintAndScroll(stillToPrint, aCommand);
        } else {
            this.engine.addCommand(aCommand);
        }
    }

    protected void startScroll() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.startScroll();
            }
        });
    }

    public void printAndScroll(String aString) {
        String stillToPrint = this.displayBuffer.printAndScroll(aString);
        if (stillToPrint == null) {
            this.endScroll();
        } else {
            this.engine.addToPrintAndScroll(stillToPrint);
        }
    }

    public void fastScroll() {
        this.engine.fastScroll();
    }

    public void normalScroll() {
        this.engine.normalScroll();
    }

    public void endScroll() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.endScroll();
            }
        });
    }

    protected void endPrint() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.resultPrinted();
            }
        });
    }

    public void printWait(final int aPrintWait, final Command aCommand) {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.waitAfterPrint(aPrintWait, aCommand);
            }
        });
    }

    public void endWaitAfterPrint() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.endWaitAfterPrint();
            }
        });
    }

    public void cancelWaitAfterPrint() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.cancelWaitAfterPrint();
            }
        });
        this.display.showBusy(false);
    }

    public void setCursorPosition(int aCursorPosition) {
        this.display.setCursorPosition(aCursorPosition);
    }

    public void clearDisplay() {
        this.setReusableResult(false);
        this.displayBuffer.clearDisplay();
    }

    public boolean isReusableResult() {
        return this.reusableResult;
    }

    public void setReusableResult(boolean aReusableResultFlag) {
        this.reusableResult = aReusableResultFlag;
    }

    public void input(String anInputPrompt) {
        this.printAndExecute(anInputPrompt + "?", new StartInputCommand(anInputPrompt));
    }

    public void startInput(final String anInputPrompt) {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.input(anInputPrompt);
            }
        });
    }

    public void enterString(final String aString) {
        this.setReusableResult(false);
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.enterString(aString);
            }
        });
    }

    public void clear() {
        this.inputBuffer.clear();
    }

    public void insertSpace() {
        this.inputBuffer.insertSpace();
    }

    public void moveCursorRight() {
        this.inputBuffer.moveCursorRight();
    }

    public void moveCursorLeft() {
        this.inputBuffer.moveCursorLeft();
    }

    public void home() {
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.home();
            }
        });
    }

    public void reportError(final Throwable anError) {
        if (anError instanceof Fx702pException) {
            this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

                public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                    aFx702pEmulatorComponent.reportFx702pError((Fx702pException)anError);
                }
            });
        } else {
            this.display.reportError("Internal Error", "Unknown errror", anError);
        }
    }

    public boolean askConfirmation(String aQuestion, String aDetailedQuestion) {
        return this.display.askConfirmation(aQuestion, aDetailedQuestion);
    }

    public void execute() {
        final String toExecute = this.inputBuffer.toString();
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.execute(toExecute);
            }
        });
    }

    public Fx702pBasicProgram getProgram(int aProgramIndex) {
        return this.getMemory().getProgram(aProgramIndex);
    }

    public Fx702pBasicProgram getActiveProgram() {
        return this.getMemory().getActiveProgram();
    }

    public int getActiveProgramIndex() {
        return this.getMemory().getActiveProgramIndex();
    }

    public void setActiveProgramIndex(final int aProgramIndex) {
        this.getMemory().setActiveProgramIndex(aProgramIndex);
        this.callMethod(new Fx702pEmulatorComponent.MethodCaller(){

            public void callMethod(Fx702pEmulatorComponent aFx702pEmulatorComponent) {
                aFx702pEmulatorComponent.setActiveProgramIndex(aProgramIndex);
            }
        });
    }

    public void addCommand(Command aCommand) {
        this.engine.addCommand(aCommand);
    }

    public void stat() {
        this.getCurrentInterpreter().stat(this.inputBuffer.toString());
    }

    public void del() {
        this.getCurrentInterpreter().del(this.inputBuffer.toString());
    }

    public void astat() {
        this.getCurrentInterpreter().astat();
    }

    public void sac() {
        this.getCurrentInterpreter().sac();
    }

    protected Fx702pAbstractInterpreter getCurrentInterpreter() {
        return this.interpreterHolder.getCurrentInterpreter();
    }

    public void displayRunModeMessage() {
        this.clearDisplay();
        this.print("READY P" + this.interpreterHolder.getBasicInterpreter().getActiveProgramIndex());
        this.resultPrinted();
    }
}

