/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.commands.AbstractCommand;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.commands.EndWaitAfterPrintCommand;
import com.fx702p.emulator.commands.PrintAndScrollCommand;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pDefaultEmulator;
import com.fx702p.emulator.implementation.Fx702pTemporizer;
import com.fx702p.interpreters.Fx702pException;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class Fx702pEngine
extends Fx702pAbstractEmulatorComponent {
    protected LinkedList<Command> commandsQueue = new LinkedList();
    protected ContinuationCommand continuationCommand;
    protected boolean processContinuationCommand = false;
    protected boolean inputMode = false;
    protected Timer delayedCommand = null;
    protected DelayedTimerTask delayedTimerTask = null;
    protected Command afterScrollCommand = null;
    protected Command afterWaitCommand = null;
    protected long printScrollDelay = 500L;
    protected Fx702pDefaultEmulator emulator;
    protected EngineBehavior behavior;
    protected Fx702pTemporizer temporizer = new Fx702pTemporizer();
    public static final String DELAYED_COMMAND_NAME = "Delayed Command";
    protected final RunModeBehavior RUN_MODE_BEHAVIOR = new RunModeBehavior();
    protected final ProgramRunningBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final ErrorInProgramBehavior ERROR_IN_PROGRAM_BEHAVIOR = new ErrorInProgramBehavior();
    protected final ProgramStoppedBehavior PROGRAM_STOPPED_BEHAVIOR = new ProgramStoppedBehavior();
    protected final ProgramSuspendedBehavior PROGRAM_SUSPENDED_BEHAVIOR = new ProgramSuspendedBehavior();
    protected final ProgramSuspendedInputBehavior PROGRAM_SUSPENDED_INPUT_BEHAVIOR = new ProgramSuspendedInputBehavior();
    protected final InputBehavior INPUT_BEHAVIOR = new InputBehavior();

    public Fx702pEngine(Fx702pDefaultEmulator anEmulator) {
        this.emulator = anEmulator;
        this.setInitialBehavior();
    }

    protected void setInitialBehavior() {
        this.behavior = this.RUN_MODE_BEHAVIOR;
    }

    protected void setBehavior(EngineBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    public void run() {
        this.commandLoop();
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void suspendProgram() {
        this.behavior.suspendProgram();
    }

    public void resumeProgram() {
        this.behavior.resumeProgram();
    }

    public void stepInProgram() {
        this.behavior.stepInProgram();
    }

    public void debugAndStepActiveProgram() {
        this.behavior.debugAndStepActiveProgram();
    }

    public void startScroll() {
        this.behavior.startScroll();
    }

    public void endScroll() {
        this.behavior.endScroll();
    }

    public void fastScroll() {
        this.behavior.fastScroll();
    }

    public void normalScroll() {
        this.behavior.normalScroll();
    }

    public void addToPrintAndScroll(String aString) {
        this.behavior.addToPrintAndScroll(aString);
    }

    public void addToPrintAndScroll(String aString, Command aCommand) {
        this.afterScrollCommand = aCommand;
        this.addToPrintAndScroll(aString);
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.afterWaitCommand = aCommand;
        this.setBehavior(new WaitAfterPrintBehavior(this.behavior));
        this.processContinuationCommand = false;
        this.addDelayedCommand(new EndWaitAfterPrintCommand(), (long)aPrintWait * 50L);
    }

    public void endWaitAfterPrint() {
        this.behavior.endWaitAfterPrint();
    }

    public void cancelWaitAfterPrint() {
        this.behavior.cancelWaitAfterPrint();
    }

    public void startMultiLinePrint() {
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void setSpeed(int aSpeed) {
        this.temporizer.setSpeed(aSpeed);
    }

    protected long getPrintScrollDelay() {
        return this.printScrollDelay;
    }

    protected void setNormalPrintScrollDelay() {
        this.printScrollDelay = 500L;
    }

    protected void setFastPrintScrollDelay() {
        this.printScrollDelay = 30L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandLoop() {
        while (true) {
            Command command = null;
            LinkedList<Command> linkedList = this.commandsQueue;
            synchronized (linkedList) {
                if (this.commandsQueue.isEmpty() && !this.processContinuationCommand) {
                    try {
                        this.commandsQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (!this.commandsQueue.isEmpty()) {
                    command = this.commandsQueue.removeFirst();
                }
            }
            if (command != null) {
                this.executeCommand(command);
                continue;
            }
            if (!this.processContinuationCommand || this.continuationCommand == null) continue;
            this.continuationCommand.execute(this.emulator);
            this.temporizer.temporize();
        }
    }

    protected void executeCommand(Command aCommand) {
        aCommand.preExecute(this.emulator);
        aCommand.execute(this.emulator);
        aCommand.postExecute(this.emulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command aCommand) {
        if (aCommand != null) {
            LinkedList<Command> linkedList = this.commandsQueue;
            synchronized (linkedList) {
                if (aCommand instanceof ContinuationCommand) {
                    this.addCommand((ContinuationCommand)aCommand);
                } else {
                    this.commandsQueue.addLast(aCommand);
                    this.commandsQueue.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCommand(ContinuationCommand aContinuationCommand) {
        LinkedList<Command> linkedList = this.commandsQueue;
        synchronized (linkedList) {
            this.continuationCommand = aContinuationCommand;
            this.commandsQueue.notify();
        }
    }

    protected void stopProcessingContinuationCommands() {
        this.processContinuationCommand = false;
        this.continuationCommand = null;
        this.cancelDelayedCommand();
    }

    protected synchronized void addDelayedCommand(Command aCommand, long aDelay) {
        if (this.delayedCommand != null) {
            this.delayedCommand.cancel();
        }
        this.delayedCommand = new Timer(DELAYED_COMMAND_NAME);
        this.delayedTimerTask = new DelayedTimerTask(aCommand);
        this.delayedCommand.schedule((TimerTask)this.delayedTimerTask, aDelay);
    }

    protected synchronized void cancelDelayedCommand() {
        if (this.delayedCommand != null) {
            this.delayedCommand.cancel();
        }
        this.delayedCommand = null;
        this.delayedTimerTask = null;
    }

    protected synchronized void cancelAfterWaitCommand() {
        this.afterWaitCommand = null;
    }

    protected synchronized void resetDelayedCommand() {
        this.delayedCommand = null;
        this.delayedTimerTask = null;
    }

    protected synchronized void runDelayedCommand() {
        if (this.delayedCommand != null & this.delayedTimerTask != null) {
            this.delayedCommand.cancel();
            if (!this.delayedTimerTask.isExecuted()) {
                this.executeCommand(this.delayedTimerTask.getCommand());
            }
            this.resetDelayedCommand();
        }
    }

    protected class WaitAfterPrintStopped
    extends WaitAfterPrintBehavior {
        public WaitAfterPrintStopped(EngineBehavior aPreviousBehavior) {
            super(aPreviousBehavior);
        }

        public void stop() {
        }
    }

    protected class WaitAfterPrintBehavior
    extends BasicBehavior {
        protected EngineBehavior previousBehavior;

        public WaitAfterPrintBehavior(EngineBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void allClear() {
            Fx702pEngine.this.emulator.cancelWaitAfterPrint();
        }

        public void cont() {
            Fx702pEngine.this.cancelDelayedCommand();
        }

        public void stop() {
            Fx702pEngine.this.cancelDelayedCommand();
            Fx702pEngine.this.setBehavior(new WaitAfterPrintStopped(this.previousBehavior));
        }

        public void endWaitAfterPrint() {
            Fx702pEngine.this.setBehavior(this.previousBehavior);
            if (Fx702pEngine.this.afterWaitCommand != null) {
                Fx702pEngine.this.addCommand(Fx702pEngine.this.afterWaitCommand);
                Fx702pEngine.this.afterWaitCommand = null;
            } else {
                Fx702pEngine.this.processContinuationCommand = true;
            }
        }

        public void cancelWaitAfterPrint() {
            Fx702pEngine.this.setBehavior(this.previousBehavior);
            Fx702pEngine.this.cancelDelayedCommand();
            Fx702pEngine.this.cancelAfterWaitCommand();
            Fx702pEngine.this.processContinuationCommand = true;
        }

        public void endProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.RUN_MODE_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }
    }

    protected class ScrollStoppedBehavior
    extends ScrollBehavior {
        protected String stillToPrint;

        public ScrollStoppedBehavior(EngineBehavior aPreviousBehavior) {
            super(aPreviousBehavior);
            this.stillToPrint = null;
            if (Fx702pEngine.this.delayedTimerTask != null && Fx702pEngine.this.delayedTimerTask.getCommand() instanceof PrintAndScrollCommand) {
                this.stillToPrint = ((PrintAndScrollCommand)Fx702pEngine.this.delayedTimerTask.getCommand()).getStringToPrintAndScroll();
            }
            Fx702pEngine.this.cancelDelayedCommand();
        }

        public void cont() {
            Fx702pEngine.this.setBehavior(new ScrollBehavior(this.previousBehavior));
            this.addToPrintAndScroll(this.stillToPrint);
        }
    }

    protected class ScrollBehavior
    extends BasicBehavior {
        protected EngineBehavior previousBehavior;

        public ScrollBehavior(EngineBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void endScroll() {
            Fx702pEngine.this.setNormalPrintScrollDelay();
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.resetDelayedCommand();
            Fx702pEngine.this.setBehavior(this.previousBehavior);
            if (Fx702pEngine.this.afterScrollCommand != null) {
                Fx702pEngine.this.addCommand(Fx702pEngine.this.afterScrollCommand);
            }
        }

        public void allClear() {
            Fx702pEngine.this.cancelDelayedCommand();
            Fx702pEngine.this.setBehavior(this.previousBehavior);
        }

        public void fastScroll() {
            Fx702pEngine.this.setFastPrintScrollDelay();
            this.resetScrolling();
        }

        public void normalScroll() {
            Fx702pEngine.this.setNormalPrintScrollDelay();
            this.resetScrolling();
        }

        protected void resetScrolling() {
            String stillToPrint = null;
            if (Fx702pEngine.this.delayedTimerTask != null && Fx702pEngine.this.delayedTimerTask.getCommand() instanceof PrintAndScrollCommand) {
                stillToPrint = ((PrintAndScrollCommand)Fx702pEngine.this.delayedTimerTask.getCommand()).getStringToPrintAndScroll();
            }
            Fx702pEngine.this.cancelDelayedCommand();
            Fx702pEngine.this.addDelayedCommand(new PrintAndScrollCommand(stillToPrint), Fx702pEngine.this.getPrintScrollDelay());
        }

        public void stop() {
            Fx702pEngine.this.setBehavior(new ScrollStoppedBehavior(this.previousBehavior));
        }
    }

    protected class ErrorBehavior
    extends BasicBehavior {
        protected EngineBehavior previousBehavior;
        protected boolean previousProcessContinuationCommand;

        public ErrorBehavior(EngineBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
            this.previousProcessContinuationCommand = Fx702pEngine.this.processContinuationCommand;
            Fx702pEngine.this.processContinuationCommand = false;
        }

        public void allClear() {
            Fx702pEngine.this.processContinuationCommand = this.previousProcessContinuationCommand;
            Fx702pEngine.this.setBehavior(this.previousBehavior);
            Fx702pEngine.this.behavior.allClear();
        }
    }

    protected class InputBehavior
    extends ProgramRunningBehavior {
        protected InputBehavior() {
        }

        public void stop() {
        }

        public void contProgram() {
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.inputMode = false;
            Fx702pEngine.this.addCommand(new ContinuationCommand());
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
        }
    }

    protected class ProgramSuspendedInputBehavior
    extends InputBehavior {
        protected ProgramSuspendedInputBehavior() {
        }

        public void contProgram() {
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.inputMode = false;
            Fx702pEngine.this.addCommand(new StepCommand());
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
        }
    }

    protected class ProgramSuspendedBehavior
    extends EmptyBehavior {
        protected ProgramSuspendedBehavior() {
        }

        public void resumeProgram() {
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.inputMode = false;
            Fx702pEngine.this.addCommand(new ContinuationCommand());
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            Fx702pEngine.this.runDelayedCommand();
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.inputMode = false;
            Fx702pEngine.this.addCommand(new StepCommand());
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void startScroll() {
            Fx702pEngine.this.setBehavior(new ScrollBehavior(this));
        }

        public void endProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.RUN_MODE_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }

        public void addToPrintAndScroll(String aString) {
            Fx702pEngine.this.addDelayedCommand(new PrintAndScrollCommand(aString), Fx702pEngine.this.getPrintScrollDelay());
        }

        public void input(String anInputPrompt) {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_SUSPENDED_INPUT_BEHAVIOR);
            Fx702pEngine.this.processContinuationCommand = false;
            Fx702pEngine.this.inputMode = true;
        }
    }

    protected class ProgramStoppedBehavior
    extends RunModeBehavior {
        protected ProgramStoppedBehavior() {
        }

        public void cont() {
            Fx702pEngine.this.emulator.contProgram();
        }

        public void stepInProgram() {
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.inputMode = false;
            Fx702pEngine.this.addCommand(new StepCommand());
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void setRunMode() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.RUN_MODE_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }
    }

    protected class ErrorInProgramBehavior
    extends EmptyBehavior {
        protected ErrorInProgramBehavior() {
        }

        public void endProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.RUN_MODE_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }

        public void allClear() {
            Fx702pEngine.this.addCommand(new EndProgramCommand());
        }
    }

    protected class ProgramRunningBehavior
    extends BasicBehavior {
        protected ProgramRunningBehavior() {
        }

        public void setRunMode() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.RUN_MODE_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }

        public void endProgram() {
            this.setRunMode();
        }

        public void stop() {
            Fx702pEngine.this.emulator.stopProgram();
        }

        public void input(String anInputPrompt) {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.INPUT_BEHAVIOR);
            Fx702pEngine.this.processContinuationCommand = false;
            Fx702pEngine.this.inputMode = true;
        }

        public void reportFx702pError(Fx702pException aAnError) {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.ERROR_IN_PROGRAM_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }
    }

    protected class RunModeBehavior
    extends BasicBehavior {
        protected RunModeBehavior() {
        }

        public void runProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.addCommand(new ContinuationCommand());
        }

        public void contProgram() {
            this.runProgram();
        }

        public void debugAndStepActiveProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pEngine.this.processContinuationCommand = true;
            Fx702pEngine.this.addCommand(new StepCommand());
        }
    }

    protected abstract class BasicBehavior
    extends EmptyBehavior {
        protected BasicBehavior() {
        }

        public void stopProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_STOPPED_BEHAVIOR);
            Fx702pEngine.this.stopProcessingContinuationCommands();
        }

        public void suspendProgram() {
            Fx702pEngine.this.setBehavior(Fx702pEngine.this.PROGRAM_SUSPENDED_BEHAVIOR);
            Fx702pEngine.this.processContinuationCommand = false;
            Fx702pEngine.this.continuationCommand = null;
        }

        public void startScroll() {
            Fx702pEngine.this.processContinuationCommand = false;
            Fx702pEngine.this.setBehavior(new ScrollBehavior(this));
        }

        public void addToPrintAndScroll(String aString) {
            Fx702pEngine.this.addDelayedCommand(new PrintAndScrollCommand(aString), Fx702pEngine.this.getPrintScrollDelay());
        }
    }

    protected abstract class EmptyBehavior
    implements EngineBehavior {
        protected EmptyBehavior() {
        }

        public void allClear() {
        }

        public void cont() {
        }

        public void contProgram() {
        }

        public void endProgram() {
        }

        public void endScroll() {
        }

        public void endWaitAfterPrint() {
        }

        public void cancelWaitAfterPrint() {
        }

        public void input(String anInputPrompt) {
        }

        public void reportFx702pError(Fx702pException aAnError) {
        }

        public void resumeProgram() {
        }

        public void runProgram() {
        }

        public void setRunMode() {
        }

        public void startScroll() {
        }

        public void fastScroll() {
        }

        public void normalScroll() {
        }

        public void stepInProgram() {
        }

        public void debugAndStepActiveProgram() {
        }

        public void stop() {
        }

        public void stopProgram() {
        }

        public void suspendProgram() {
        }

        public void addToPrintAndScroll(String aString) {
        }
    }

    protected static interface EngineBehavior {
        public void setRunMode();

        public void runProgram();

        public void endProgram();

        public void stopProgram();

        public void contProgram();

        public void suspendProgram();

        public void resumeProgram();

        public void stepInProgram();

        public void debugAndStepActiveProgram();

        public void stop();

        public void cont();

        public void input(String var1);

        public void reportFx702pError(Fx702pException var1);

        public void allClear();

        public void startScroll();

        public void endScroll();

        public void fastScroll();

        public void normalScroll();

        public void endWaitAfterPrint();

        public void cancelWaitAfterPrint();

        public void addToPrintAndScroll(String var1);
    }

    protected class DelayedTimerTask
    extends TimerTask {
        protected Command command;
        protected boolean executed = false;

        public DelayedTimerTask(Command aCommand) {
            this.command = aCommand;
        }

        public void run() {
            if (!this.executed) {
                Fx702pEngine.this.addCommand(this.command);
                this.executed = true;
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public boolean isExecuted() {
            return this.executed;
        }
    }

    protected class BreakpointStepCommand
    extends StepCommand {
        protected BreakpointStepCommand() {
        }

        public void execute(Fx702pEmulator anEmulator) {
            Fx702pEngine.this.processContinuationCommand = false;
            super.execute(anEmulator);
        }
    }

    protected class StepCommand
    extends ContinuationCommand {
        protected StepCommand() {
        }

        public void execute(Fx702pEmulator anEmulator) {
            Fx702pEmulator.ProgramStatus programStatus = anEmulator.continueExecution();
            switch (programStatus) {
                case RUNNING: {
                    if (anEmulator.isContinuationDebuggable()) {
                        anEmulator.suspendProgram();
                        break;
                    }
                    Fx702pEngine.this.addCommand(new StepCommand());
                    break;
                }
                case SUSPENDED: {
                    Fx702pEngine.this.processContinuationCommand = true;
                    Fx702pEngine.this.addCommand(new BreakpointStepCommand());
                    break;
                }
                case ENDED: {
                    anEmulator.endProgram();
                }
            }
        }
    }

    protected class EndProgramCommand
    extends AbstractCommand {
        protected EndProgramCommand() {
        }

        public void execute(Fx702pEmulator anEmulator) {
            anEmulator.endProgram();
        }
    }

    protected class ContinuationCommand
    extends AbstractCommand {
        protected ContinuationCommand() {
        }

        public void execute(Fx702pEmulator anEmulator) {
            Fx702pEmulator.ProgramStatus programStatus = anEmulator.continueExecution();
            switch (programStatus) {
                case RUNNING: {
                    Fx702pEngine.this.addCommand(new ContinuationCommand());
                    break;
                }
                case SUSPENDED: {
                    anEmulator.suspendProgram();
                    break;
                }
                case ENDED: {
                    anEmulator.endProgram();
                }
            }
        }

        public void postExecute(Fx702pEmulator anEmulator) {
        }
    }
}

