/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.interpreters.Fx702pFormatter;
import com.fx702p.interpreters.formatters.DecimalFormatSymbols;
import com.fx702p.interpreters.formatters.Fx702pDecimalFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;

public class NormalFormatter
implements Fx702pFormatter {
    protected RoundingMode roundingMode = RoundingMode.HALF_DOWN;
    public static final double MIN_NO_EXPONENT = 0.001;
    public static final double MAX_NO_EXPONENT = 1.0E10;
    public static final String EXPONENT_FORMAT = "#.#########E00";
    public static final String[] NO_EXPONENT_FORMATS = new String[]{"#.############", "#.###########", "#.##########", "#.#########", "#.########", "##.#######", "###.######", "####.#####", "#####.####", "######.###", "#######.##", "########.#", "#########"};

    public void setRoundingMode(RoundingMode aRoundingMode) {
        this.roundingMode = aRoundingMode;
    }

    public String format(BigDecimal aNumber) {
        if (aNumber.compareTo(BigDecimal.ZERO) == 0) {
            return " 0";
        }
        Fx702pDecimalFormat decimalFormat = this.getFx702pDecimalFormat(aNumber);
        String formattedNumber = decimalFormat.format(aNumber).replace("E", "e ");
        if (formattedNumber.charAt(0) != '-') {
            return ' ' + formattedNumber;
        }
        return formattedNumber;
    }

    protected Fx702pDecimalFormat getFx702pDecimalFormat(BigDecimal aNumber) {
        Fx702pDecimalFormat decimalFormat;
        if (Math.abs(aNumber.doubleValue()) < 0.001 || Math.abs(aNumber.doubleValue()) >= 1.0E10) {
            decimalFormat = new Fx702pDecimalFormat(this.getExponentFormat());
        } else {
            int magnitude = (int)Math.floor(Math.log10(Math.abs(aNumber.doubleValue()))) + 3;
            decimalFormat = new Fx702pDecimalFormat(this.getNoExponentFormats()[magnitude]);
        }
        this.prepareDecimalFormat(decimalFormat);
        return decimalFormat;
    }

    protected void prepareDecimalFormat(Fx702pDecimalFormat aFx702pDecimalFormat) {
        aFx702pDecimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        aFx702pDecimalFormat.setRoundingMode(this.roundingMode);
    }

    protected String getExponentFormat() {
        return EXPONENT_FORMAT;
    }

    protected String[] getNoExponentFormats() {
        return NO_EXPONENT_FORMATS;
    }
}

