/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.swing.DebugControlPanel;
import com.fx702p.swing.Fx702pSwingDebugger;
import com.fx702p.swing.Fx702pSwingKeyboardAndDisplay;
import com.fx702p.swing.SourceCodePanel;
import com.fx702p.swing.SwingUtils;
import com.fx702p.swing.WatchPanel;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DebugWindow
extends JFrame
implements Fx702pEmulatorComponent {
    protected boolean forwardKeys = true;
    protected DebugControlPanel debugControlPanel;
    protected SourceCodePanel sourceCode;
    protected WatchPanel watchPanel;
    protected JSplitPane splitPane;
    protected Fx702pSwingKeyboardAndDisplay fx702pSwingKeyboardAndDisplay;
    protected int programIndex;
    protected KeyboardFocusManager keyboardFocusManager;
    protected KeyEventDispatcher keyEventDispatcher;
    public static final int PLAY_GLOBAL_ACCELERATOR_CODE = 122;
    public static final int PLAY_GLOBAL_ACCELERATOR_MODIFIERS = 0;
    public static final int END_GLOBAL_ACCELERATOR_CODE = 113;
    public static final int END_GLOBAL_ACCELERATOR_MODIFIERS = SwingUtils.getDefaultModifierForCurrentPlatform();
    public static final int SUSPEND_GLOBAL_ACCELERATOR_CODE = 114;
    public static final int SUSPEND_GLOBAL_ACCELERATOR_MODIFIERS = 0;
    public static final int STEP_OR_START_GLOBAL_ACCELERATOR_CODE = 117;
    public static final int STEP_OR_START_GLOBAL_ACCELERATOR_MODIFIERS = 0;
    public static final int REPLAY_GLOBAL_ACCELERATOR_CODE = 118;
    public static final int REPLAY_GLOBAL_ACCELERATOR_MODIFIERS = 0;

    public DebugWindow(Fx702pBasicProgram aBasicProgram, Fx702pSwingKeyboardAndDisplay aFx702pSwingKeyboardAndDisplay, int aProgramIndex) {
        super("Fx702p Debugger P" + aProgramIndex + ' ' + aBasicProgram.getName());
        this.fx702pSwingKeyboardAndDisplay = aFx702pSwingKeyboardAndDisplay;
        this.programIndex = aProgramIndex;
        Fx702pSwingDebugger debugger = new Fx702pSwingDebugger(this.getEmulator(), this);
        this.getEmulator().setDebugger(debugger);
        JPanel controlAndSourcePanel = new JPanel();
        controlAndSourcePanel.setLayout(new BoxLayout(controlAndSourcePanel, 1));
        this.debugControlPanel = new DebugControlPanel(this);
        this.debugControlPanel.setAlignmentX(0.0f);
        controlAndSourcePanel.add(this.debugControlPanel);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setAlignmentX(0.0f);
        controlAndSourcePanel.add(this.splitPane);
        this.sourceCode = new SourceCodePanel(this, aBasicProgram);
        JScrollPane sourceScrollPane = new JScrollPane(this.sourceCode, 22, 30);
        this.splitPane.setTopComponent(sourceScrollPane);
        sourceScrollPane.setBorder(BorderFactory.createTitledBorder("Source Code"));
        this.watchPanel = new WatchPanel(this.fx702pSwingKeyboardAndDisplay, aBasicProgram);
        this.splitPane.setBottomComponent(this.watchPanel);
        this.splitPane.setResizeWeight(0.8);
        this.getRootPane().setContentPane(controlAndSourcePanel);
        this.pack();
        this.addKeyEventDispatcher();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent aWindowEvent) {
                DebugWindow.this.watchPanel.setInitialDividerLocation();
            }

            public void windowClosing(WindowEvent aWindowEvent) {
                DebugWindow.this.closeDebugWindow();
            }
        });
        this.fx702pSwingKeyboardAndDisplay.setDebugWindowPosition(this);
        this.fx702pSwingKeyboardAndDisplay.getEmulator().getMemory().setWatcher(this.watchPanel);
    }

    public void startKeysForwarding() {
        this.forwardKeys = true;
    }

    public void stopKeysForwarding() {
        this.forwardKeys = false;
    }

    protected void addKeyEventDispatcher() {
        this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent aKeyEvent) {
                return DebugWindow.this.dispatchGlobalDebuggerKeyEvent(aKeyEvent);
            }
        };
        this.keyboardFocusManager.addKeyEventDispatcher(this.keyEventDispatcher);
    }

    protected void removeKeyEventDispatcher() {
        if (this.keyboardFocusManager != null && this.keyEventDispatcher != null) {
            this.keyboardFocusManager.removeKeyEventDispatcher(this.keyEventDispatcher);
        }
    }

    protected boolean dispatchGlobalDebuggerKeyEvent(KeyEvent aKeyEvent) {
        block15: {
            block14: {
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null || SwingUtilities.getWindowAncestor(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JDialog || SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this.watchPanel) || SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this.fx702pSwingKeyboardAndDisplay.getConsole())) {
                    return false;
                }
                if (aKeyEvent.getID() != 401) break block14;
                switch (aKeyEvent.getKeyCode()) {
                    case 113: {
                        if (aKeyEvent.getModifiers() == END_GLOBAL_ACCELERATOR_MODIFIERS) {
                            this.endProgram();
                            return true;
                        }
                        break block15;
                    }
                    case 114: {
                        if (aKeyEvent.getModifiers() == 0) {
                            this.suspendProgram();
                            return true;
                        }
                        break block15;
                    }
                    case 117: {
                        if (aKeyEvent.getModifiers() == 0) {
                            this.stepOrStart();
                            return true;
                        }
                        break block15;
                    }
                    case 118: {
                        if (aKeyEvent.getModifiers() == 0) {
                            this.replay();
                            return true;
                        }
                        break block15;
                    }
                    case 122: {
                        if (aKeyEvent.getModifiers() == 0) {
                            this.debugActiveProgram();
                            return true;
                        }
                        break block15;
                    }
                    default: {
                        return this.fx702pSwingKeyboardAndDisplay.processKey(aKeyEvent);
                    }
                }
            }
            if (aKeyEvent.getID() == 402) {
                return this.fx702pSwingKeyboardAndDisplay.processKey(aKeyEvent);
            }
        }
        return false;
    }

    public Fx702pSwingKeyboardAndDisplay getSwingKeyboardAndDisplay() {
        return this.fx702pSwingKeyboardAndDisplay;
    }

    public Fx702pEmulator getEmulator() {
        return this.fx702pSwingKeyboardAndDisplay.getEmulator();
    }

    protected void closeDebugWindow() {
        this.fx702pSwingKeyboardAndDisplay.getEmulator().getMemory().setWatcher(null);
        if (this.debugControlPanel.isDebugActive()) {
            int answer = JOptionPane.showConfirmDialog(this, "Debugged program is running. Stop it?", "Closing confirmation", 2);
            if (answer == 0) {
                this.getEmulator().endProgram();
                this.getEmulator().endDebug();
                this.dispose();
            }
        } else {
            this.getEmulator().endDebug();
            this.dispose();
        }
        this.removeKeyEventDispatcher();
    }

    public void selectBreakpoint(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        this.sourceCode.selectBreakpoint(aBasicLine, aSelectionStart, aSelectionEnd);
    }

    public void select(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        this.sourceCode.select(aBasicLine, aSelectionStart, aSelectionEnd);
    }

    public void subSelect(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        this.sourceCode.subSelect(aBasicLine, aSelectionStart, aSelectionEnd);
    }

    public void clearSelection() {
        this.sourceCode.clearSelection();
    }

    public void debugActiveProgram() {
        this.debugControlPanel.debugActiveProgram();
    }

    public void allClear() {
        this.debugControlPanel.allClear();
        this.sourceCode.allClear();
    }

    public void home() {
    }

    public void cont() {
        this.debugControlPanel.cont();
    }

    public void contProgram() {
        this.debugControlPanel.contProgram();
        this.watchPanel.contProgram();
    }

    public void endProgram() {
        this.sourceCode.clearSelection();
        this.debugControlPanel.endProgram();
        this.watchPanel.endProgram();
    }

    public void endScroll() {
        this.debugControlPanel.endScroll();
    }

    public void endWaitAfterPrint() {
        this.debugControlPanel.endWaitAfterPrint();
    }

    public void cancelWaitAfterPrint() {
        this.debugControlPanel.cancelWaitAfterPrint();
    }

    public void enterString(String aString) {
        this.debugControlPanel.enterString(aString);
    }

    public void execute(String aString) {
        this.debugControlPanel.execute(aString);
    }

    public void input(String anInputPrompt) {
        this.debugControlPanel.input(anInputPrompt);
    }

    public void reportFx702pError(Fx702pException anError) {
        this.debugControlPanel.reportFx702pError(anError);
    }

    public void resultPrinted() {
        this.debugControlPanel.resultPrinted();
    }

    public void startMultiLinePrint() {
    }

    public void endMultiLinePrint() {
    }

    public void runProgram() {
        this.debugControlPanel.runProgram();
        this.watchPanel.runProgram();
    }

    public void setRunMode() {
        this.debugControlPanel.setRunMode();
        this.watchPanel.setRunMode();
    }

    public void setWrtMode() {
        this.debugControlPanel.setWrtMode();
        this.watchPanel.setWrtMode();
    }

    public void startScroll() {
        this.debugControlPanel.startScroll();
    }

    public void stepInProgram() {
        this.debugControlPanel.stepInProgram();
        this.watchPanel.stepInProgram();
    }

    public void stepOrStart() {
        this.debugControlPanel.stepOrStart();
    }

    public void debugAndStepActiveProgram() {
        this.debugControlPanel.debugAndStepActiveProgram();
        this.watchPanel.debugAndStepActiveProgram();
    }

    public void nextLoop(Variable aVariable) {
        this.debugControlPanel.nextLoop(aVariable);
    }

    public void endLoop(Variable aVariable) {
        this.debugControlPanel.endLoop(aVariable);
    }

    public void stop() {
        this.debugControlPanel.stop();
    }

    public void stopProgram() {
        this.debugControlPanel.stopProgram();
    }

    public void suspendProgram() {
        this.debugControlPanel.suspendProgram();
    }

    public void resumeProgram() {
        this.debugControlPanel.resumeProgram();
        this.watchPanel.resumeProgram();
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.debugControlPanel.waitAfterPrint(aPrintWait, null);
    }

    public void loadProgram(int aProgramIndex) {
        if (aProgramIndex == this.programIndex || aProgramIndex == -1) {
            this.debugControlPanel.loadProgram(aProgramIndex);
            this.sourceCode.setActiveProgram(this.getEmulator().getActiveProgram());
            this.fixSize();
        }
    }

    public void replay() {
        this.debugControlPanel.replay();
    }

    public void clearProgram(int aProgramIndex) {
        if (aProgramIndex == this.programIndex || aProgramIndex == -1) {
            this.debugControlPanel.clearProgram(aProgramIndex);
            this.sourceCode.clearProgram();
            this.fixSize();
        }
    }

    public void setActiveProgramIndex(int aProgramIndex) {
        if (aProgramIndex != this.programIndex) {
            this.programIndex = aProgramIndex;
            this.debugControlPanel.setActiveProgramIndex(aProgramIndex);
            Fx702pBasicProgram basicProgram = this.getEmulator().getProgram(aProgramIndex);
            this.sourceCode.setActiveProgram(basicProgram);
            this.watchPanel.setActiveProgram(basicProgram);
            this.fixSize();
        }
    }

    protected void fixSize() {
        this.setSize(this.getPreferredSize());
        this.invalidate();
    }
}

