// license:GPL_2.0
// copyright-holders:Robbbert

/*********************************************
Super Street Fighter II: The New Challengers
*********************************************/
ROM_START( ssf2s01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c48s01.p1", 0x000000, 0x80000, CRC(ea1d3237) SHA1(f7a8dded94299b34657d066a89f55bfd91c7070c) )
	ROM_LOAD16_WORD_SWAP( "c48s01.p2", 0x080000, 0x80000, CRC(07a12776) SHA1(db22da16b038767a31a7dc7c04fd3071ae228fd3) )
	ROM_LOAD16_WORD_SWAP( "c48j.p3",     0x100000, 0x80000, CRC(0918d19a) SHA1(c23be61dd193058eb1391d39fbc22fbcf0640ee0) )
	ROM_LOAD16_WORD_SWAP( "c48j.p4",     0x180000, 0x80000, CRC(014e0c6d) SHA1(4a5689a05900564c2544c95741cd450ce55da0a7) )
	ROM_LOAD16_WORD_SWAP( "c48j.p5",     0x200000, 0x80000, CRC(eb6a9b1b) SHA1(daedb669b0025f6efb0f3302a40d88dcde2fc76f) )

	ROM_REGION( 0xc00000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c48r1.m1",   0x00000, 0x08000, CRC(eb247e8c) SHA1(24296c18d9b1136d69712bf1c9d9d15463041e83) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD( "c48.q1",  0x000000, 0x080000, CRC(a6f9da5c) SHA1(6d19f83a01bd25b838d5c2871f7964529d926c98) )
	ROM_LOAD( "c48.q2",  0x080000, 0x080000, CRC(8c66ae26) SHA1(32a82aee6ed4480e5a990f9af161734c7c0a1403) )
	ROM_LOAD( "c48.q3",  0x100000, 0x080000, CRC(695cc2ca) SHA1(c2675f0233608b76de528d2a6ef19846d1348060) )
	ROM_LOAD( "c48.q4",  0x180000, 0x080000, CRC(9d9ebe32) SHA1(9b26329370041374f1a90b479a172d2bc2801c4d) )
	ROM_LOAD( "c48.q5",  0x200000, 0x080000, CRC(4770e7b7) SHA1(0e764f0befb9227b0b36508d8ca8ec9be31bcb05) )
	ROM_LOAD( "c48.q6",  0x280000, 0x080000, CRC(4e79c951) SHA1(1144781d7dc57ef8a6458d982f5c91548ff59e27) )
	ROM_LOAD( "c48.q7",  0x300000, 0x080000, CRC(cdd14313) SHA1(ebe767a9d4b51dba4282fa0a36a546a88620dd59) )
	ROM_LOAD( "c48.q8",  0x380000, 0x080000, CRC(6f5a088c) SHA1(6c0b4690479647a99d76335f174be8455b4ff118) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2j.key",    0x00, 0x14, CRC(bca45cc2) SHA1(5e9ccfde4b476efdce4e4fcbaf8facefe41a4c89) )
ROM_END

ROM_START( ssf2s02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c48ud.p1", 0x000000, 0x80000, CRC(fad5daf8) SHA1(5bed5d5af8dffc54d3b3371274a3905f46384f79) )
	ROM_LOAD16_WORD_SWAP( "c48ud.p2", 0x080000, 0x80000, CRC(0d31af65) SHA1(7e903e18cb899627fedd8ad92594b75b5d8ee8fd) )
	ROM_LOAD16_WORD_SWAP( "c48ud.p3",  0x100000, 0x80000, CRC(75c651ef) SHA1(8c6f60d3cf10d802190438c403a719bc30ccbeaa) )
	ROM_LOAD16_WORD_SWAP( "c48ud.p4",  0x180000, 0x80000, CRC(85c3ec00) SHA1(29ab3eccc5f9c0dd6bd19eaa83c72e1a1d44b320) )
	ROM_LOAD16_WORD_SWAP( "c48s02.p5",  0x200000, 0x80000, CRC(9320e350) SHA1(bec5dcd85faf10c72cc79e5d5af311ffb5445c47) )

	ROM_REGION( 0xc00000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c48r1.m1",   0x00000, 0x08000, CRC(eb247e8c) SHA1(24296c18d9b1136d69712bf1c9d9d15463041e83) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD( "c48.q1",  0x000000, 0x080000, CRC(a6f9da5c) SHA1(6d19f83a01bd25b838d5c2871f7964529d926c98) )
	ROM_LOAD( "c48.q2",  0x080000, 0x080000, CRC(8c66ae26) SHA1(32a82aee6ed4480e5a990f9af161734c7c0a1403) )
	ROM_LOAD( "c48.q3",  0x100000, 0x080000, CRC(695cc2ca) SHA1(c2675f0233608b76de528d2a6ef19846d1348060) )
	ROM_LOAD( "c48.q4",  0x180000, 0x080000, CRC(9d9ebe32) SHA1(9b26329370041374f1a90b479a172d2bc2801c4d) )
	ROM_LOAD( "c48.q5",  0x200000, 0x080000, CRC(4770e7b7) SHA1(0e764f0befb9227b0b36508d8ca8ec9be31bcb05) )
	ROM_LOAD( "c48.q6",  0x280000, 0x080000, CRC(4e79c951) SHA1(1144781d7dc57ef8a6458d982f5c91548ff59e27) )
	ROM_LOAD( "c48.q7",  0x300000, 0x080000, CRC(cdd14313) SHA1(ebe767a9d4b51dba4282fa0a36a546a88620dd59) )
	ROM_LOAD( "c48.q8",  0x380000, 0x080000, CRC(6f5a088c) SHA1(6c0b4690479647a99d76335f174be8455b4ff118) )
ROM_END

ROM_START( ssf2s03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c48s03.p1",  0x000000, 0x80000, CRC(e7dcfc8d) SHA1(7a6e703a5cfd9fbdceab84e5f5e0d443e6c95dcc) )
	ROM_LOAD16_WORD_SWAP( "c48.p2",  0x080000, 0x80000, CRC(b082aa67) SHA1(ca26b4bb1947cb30eaf6b61f606b859d18da4c4c) )
	ROM_LOAD16_WORD_SWAP( "c48.p3",  0x100000, 0x80000, CRC(02b9c137) SHA1(ba624441e1b4bfb67c71f6a116fe43539eaa4a15) )
	ROM_LOAD16_WORD_SWAP( "c48r1.p4",  0x180000, 0x80000, CRC(70d470c5) SHA1(ba03c8f4c76f72f4483e91547e03d1a0cf6db485) )
	ROM_LOAD16_WORD_SWAP( "c48.p5",  0x200000, 0x80000, CRC(2409001d) SHA1(f532ebb2efbb8f8ba311d10ff897490352c87f97) )

	ROM_REGION( 0xc00000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c48r1.m1",   0x00000, 0x08000, CRC(eb247e8c) SHA1(24296c18d9b1136d69712bf1c9d9d15463041e83) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD( "c48.q1",  0x000000, 0x080000, CRC(a6f9da5c) SHA1(6d19f83a01bd25b838d5c2871f7964529d926c98) )
	ROM_LOAD( "c48.q2",  0x080000, 0x080000, CRC(8c66ae26) SHA1(32a82aee6ed4480e5a990f9af161734c7c0a1403) )
	ROM_LOAD( "c48.q3",  0x100000, 0x080000, CRC(695cc2ca) SHA1(c2675f0233608b76de528d2a6ef19846d1348060) )
	ROM_LOAD( "c48.q4",  0x180000, 0x080000, CRC(9d9ebe32) SHA1(9b26329370041374f1a90b479a172d2bc2801c4d) )
	ROM_LOAD( "c48.q5",  0x200000, 0x080000, CRC(4770e7b7) SHA1(0e764f0befb9227b0b36508d8ca8ec9be31bcb05) )
	ROM_LOAD( "c48.q6",  0x280000, 0x080000, CRC(4e79c951) SHA1(1144781d7dc57ef8a6458d982f5c91548ff59e27) )
	ROM_LOAD( "c48.q7",  0x300000, 0x080000, CRC(cdd14313) SHA1(ebe767a9d4b51dba4282fa0a36a546a88620dd59) )
	ROM_LOAD( "c48.q8",  0x380000, 0x080000, CRC(6f5a088c) SHA1(6c0b4690479647a99d76335f174be8455b4ff118) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2.key",     0x00, 0x14, CRC(e469ccbb) SHA1(43d49107e96a4a14f1f25931ad3ae6065958150e) )
ROM_END

/**********************************
Dungeons & Dragons: Tower of Doom
***********************************/
ROM_START( ddtods01 ) //ddtodh
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c50s01.p1", 0x000000, 0x80000, CRC(a6c1428e) SHA1(63aa92b657d114834aa21842968c781f7464e46c) )
	ROM_LOAD16_WORD_SWAP( "c50s01.p2", 0x080000, 0x80000, CRC(7ff26bb4) SHA1(f6335123ad83c3973056cc32a2391fa23ade981f) )
	ROM_LOAD16_WORD_SWAP( "c50h.p3", 0x100000, 0x80000, CRC(a6e562ba) SHA1(42998024a3bb4464843411ebe7283c6f5369694d) )
	ROM_LOAD16_WORD_SWAP( "c50.p4",  0x180000, 0x80000, CRC(6225495a) SHA1(a9a02abb072e3482ac92d7aed8ce9a5bcf636bc0) )
	ROM_LOAD16_WORD_SWAP( "c50.p5",  0x200000, 0x80000, CRC(b3480ec3) SHA1(a66f8dba67101fd71c2af4f3c3d71e55778a9f2c) )

	ROM_REGION( 0xc00000, "gfx", 0 )
	ROM_LOAD64_WORD( "c50.c1",   0x000000, 0x200000, CRC(da3cb7d6) SHA1(d59bb53d5f32889eb6eb7f8b1c8781948c97283d) )
	ROM_LOAD64_WORD( "c50.c2",   0x000002, 0x200000, CRC(92b63172) SHA1(9bed7dbbb17729f2ad3d318396f5335c0bd39937) )
	ROM_LOAD64_WORD( "c50.c3",   0x000004, 0x200000, CRC(b98757f5) SHA1(3eead22e097906bf0e1e151cd0a9c75abc5a32d4) )
	ROM_LOAD64_WORD( "c50.c4",   0x000006, 0x200000, CRC(8121ce46) SHA1(40c4dc969318d38f0c6d5401c9c64371f51aa12c) )
	ROM_LOAD64_WORD( "c50.c5",   0x800000, 0x100000, CRC(837e6f3f) SHA1(c060183474fba0e82d765b9f282b84838550dff6) )
	ROM_LOAD64_WORD( "c50.c6",   0x800002, 0x100000, CRC(f0916bdb) SHA1(9354d258dd26cbbf12c78ecfc277c357cbdb360e) )
	ROM_LOAD64_WORD( "c50.c7",   0x800004, 0x100000, CRC(cef393ef) SHA1(830b33c86cc24776d17ad65fa89a3b16c40446a1) )
	ROM_LOAD64_WORD( "c50.c8",   0x800006, 0x100000, CRC(8953fe9e) SHA1(f4795beb006335d13e3934aa9760e775eb0bb950) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c50.m1",   0x00000, 0x08000, CRC(3f5e2424) SHA1(4aa744576bc6752c43a90a27a816ebd90076b248) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c50.q1",   0x000000, 0x200000, CRC(0c499b67) SHA1(a8ebd8a1cd6dece8344b7cb0439d85843fb97616) )
	ROM_LOAD16_WORD_SWAP( "c50.q2",   0x200000, 0x200000, CRC(2f0b5a4e) SHA1(8d1ebbb811aa469b0f0d29d719d2b9af28fb63a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddtodh.key",   0x00, 0x14, CRC(65f33a1c) SHA1(4bc2c0968115365fd8cd721b769f62ed32b02cf5) )
ROM_END

ROM_START( ddtods02 ) // ddstodpdec (Plus decrypted version) */
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c50s02.p1", 0x000000, 0x280000, CRC(2b2fcbb7) SHA1(07f790991fbcf60df6cfdafc3ffc957932ad8029) )

	ROM_REGION( 0xc00000, "gfx", 0 )
	ROM_LOAD64_WORD( "c50.c1",   0x000000, 0x200000, CRC(da3cb7d6) SHA1(d59bb53d5f32889eb6eb7f8b1c8781948c97283d) )
	ROM_LOAD64_WORD( "c50.c2",   0x000002, 0x200000, CRC(92b63172) SHA1(9bed7dbbb17729f2ad3d318396f5335c0bd39937) )
	ROM_LOAD64_WORD( "c50.c3",   0x000004, 0x200000, CRC(b98757f5) SHA1(3eead22e097906bf0e1e151cd0a9c75abc5a32d4) )
	ROM_LOAD64_WORD( "c50.c4",   0x000006, 0x200000, CRC(8121ce46) SHA1(40c4dc969318d38f0c6d5401c9c64371f51aa12c) )
	ROM_LOAD64_WORD( "c50.c5",   0x800000, 0x100000, CRC(837e6f3f) SHA1(c060183474fba0e82d765b9f282b84838550dff6) )
	ROM_LOAD64_WORD( "c50.c6",   0x800002, 0x100000, CRC(f0916bdb) SHA1(9354d258dd26cbbf12c78ecfc277c357cbdb360e) )
	ROM_LOAD64_WORD( "c50.c7",   0x800004, 0x100000, CRC(cef393ef) SHA1(830b33c86cc24776d17ad65fa89a3b16c40446a1) )
	ROM_LOAD64_WORD( "c50.c8",   0x800006, 0x100000, CRC(8953fe9e) SHA1(f4795beb006335d13e3934aa9760e775eb0bb950) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c50.m1",   0x00000, 0x08000, CRC(3f5e2424) SHA1(4aa744576bc6752c43a90a27a816ebd90076b248) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c50.q1",   0x000000, 0x200000, CRC(0c499b67) SHA1(a8ebd8a1cd6dece8344b7cb0439d85843fb97616) )
	ROM_LOAD16_WORD_SWAP( "c50.q2",   0x200000, 0x200000, CRC(2f0b5a4e) SHA1(8d1ebbb811aa469b0f0d29d719d2b9af28fb63a2) )
ROM_END

 /*****************************
 Super Street Fighter II Turbo
*******************************/
ROM_START( ssf2t01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t01.p1", 0x000000, 0x80000, CRC(0092faf8) SHA1(38762cc1b087c7ba059baed0ebd2e9bb194d0660) )
	ROM_LOAD16_WORD_SWAP( "c51t01.p2", 0x080000, 0x80000, CRC(59859b5f) SHA1(fa2fd9d3a0554fdfe7ab3444e173b0ed7823d90a) )
	ROM_LOAD16_WORD_SWAP( "c51.p3", 0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4", 0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5", 0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6", 0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7", 0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t02.p1", 0x000000, 0x80000, CRC(cc8b73a9) SHA1(cc66b5bb7b90e8999c34efaceae14e21e174f487) )
	ROM_LOAD16_WORD_SWAP( "c51t02.p2", 0x080000, 0x80000, CRC(a3bfab29) SHA1(eb0c4108dff4b8b453712c247a3bbd7b43db077d) )
	ROM_LOAD16_WORD_SWAP( "c51.p3", 0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4", 0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5", 0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6", 0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7", 0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t03.p1", 0x000000, 0x80000, CRC(b10bf65f) SHA1(a2caeee7bc9b155659f237a35ba5ff23aad440d6) )
	ROM_LOAD16_WORD_SWAP( "c51t03.p2", 0x080000, 0x80000, CRC(b24ba1c6) SHA1(a418ece021fe23242d54c85f56690de4a9dda83c) )
	ROM_LOAD16_WORD_SWAP( "c51u.p3",  0x100000, 0x80000, CRC(ffa3c6de) SHA1(7cce55a3e07b5ba2e2e37e4c66a52678a1b19a63) )
	ROM_LOAD16_WORD_SWAP( "c51u.p4", 0x180000, 0x80000, CRC(83f9382b) SHA1(273ff4d4242ce22b755d35e5d2cf2517d625bdd2) )
	ROM_LOAD16_WORD_SWAP( "c51u.p5", 0x200000, 0x80000, CRC(6ab673e8) SHA1(840af0d0ce634fb98e4f89173c4f1f95ec2cf94b) )
	ROM_LOAD16_WORD_SWAP( "c51t03.p6",  0x280000, 0x80000, CRC(f965162c) SHA1(a3c3b8a31413ac0db004643b6994d455e53989db) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2tu.key",   0x00, 0x14, CRC(f7d62def) SHA1(27a797fd6fe435e14ca334947df38d56f89f79de) )
ROM_END

ROM_START( ssf2t04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t04.p1", 0x000000, 0x80000, CRC(69808638) SHA1(a288e0ce3be18af25d54a4ed9fc914be5dfad78d) )
	ROM_LOAD16_WORD_SWAP( "c51t04.p2", 0x080000, 0x80000, CRC(90bd9148) SHA1(127c0442d80e89db0f5325b329a418bf269f2548) )
	ROM_LOAD16_WORD_SWAP( "c51u.p3",  0x100000, 0x80000, CRC(ffa3c6de) SHA1(7cce55a3e07b5ba2e2e37e4c66a52678a1b19a63) )
	ROM_LOAD16_WORD_SWAP( "c51u.p4", 0x180000, 0x80000, CRC(83f9382b) SHA1(273ff4d4242ce22b755d35e5d2cf2517d625bdd2) )
	ROM_LOAD16_WORD_SWAP( "c51u.p5", 0x200000, 0x80000, CRC(6ab673e8) SHA1(840af0d0ce634fb98e4f89173c4f1f95ec2cf94b) )
	ROM_LOAD16_WORD_SWAP( "c51u.p6",  0x280000, 0x80000, CRC(b3c71810) SHA1(b51515f4f4aee5bbbfc8b79372d0bc6e0c140912) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2tu.key",   0x00, 0x14, CRC(f7d62def) SHA1(27a797fd6fe435e14ca334947df38d56f89f79de) )
ROM_END

ROM_START( ssf2t05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t05.p1", 0x000000, 0x80000, CRC(ed99d850) SHA1(d2dcb8395d630fcd1776fd32a9c685646e1f18be) )
	ROM_LOAD16_WORD_SWAP( "c51t05.p2", 0x080000, 0x80000, CRC(38d9b364) SHA1(814e67441a9d92ed89edf20dacb17a0f100020e3) )
	ROM_LOAD16_WORD_SWAP( "c51ad.p3",  0x100000, 0x80000, CRC(c63358d0) SHA1(dde4d9e9adce4dee02322c0fd71615eed0af62e6) )
	ROM_LOAD16_WORD_SWAP( "c51ad.p4",  0x180000, 0x80000, CRC(ccb29808) SHA1(10e7b135a936409fe7c4d7959ea375634a8c68e4) )
	ROM_LOAD16_WORD_SWAP( "c51ad.p5",  0x200000, 0x80000, CRC(61f94982) SHA1(d2f22f50c21393deda7d5838dbd2b265722acd38) )
	ROM_LOAD16_WORD_SWAP( "c51ad.p6",  0x280000, 0x80000, CRC(d399c36c) SHA1(b4c4217843e5c3ef00ab04d58ca9368d2d734065) )
	ROM_LOAD16_WORD_SWAP( "c51t05.p7",  0x300000, 0x80000, CRC(317b5dbc) SHA1(1e1037b071251c28ed9cd5ccd6d52b72cc86396a) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )
ROM_END

ROM_START( ssf2t06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t06.p1", 0x000000, 0x80000, CRC(8f7d4954) SHA1(ace9981370b8f6df3186c9d9a1d3a614cc519af1) )
	ROM_LOAD16_WORD_SWAP( "c51.p2",  0x080000, 0x80000, CRC(d0bc29c6) SHA1(d9f89bcd79cba26db2100a00dd7bd8ee6ecb75f3) )
	ROM_LOAD16_WORD_SWAP( "c51.p3",  0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4",  0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5",  0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6",  0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",  0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t07.p1", 0x000000, 0x80000, CRC(c8c491d1) SHA1(5e12ccd36c8cd086d3d628e7f121aefcbc17340e) )
	ROM_LOAD16_WORD_SWAP( "c51t07.p2", 0x080000, 0x80000, CRC(b018ceea) SHA1(75fa14f93c82ade94713556cffcfd17dfcef3e35) )
	ROM_LOAD16_WORD_SWAP( "c51.p3", 0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4", 0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5", 0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6", 0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7", 0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t08.p1", 0x000000, 0x80000, CRC(abd7a3e0) SHA1(088166ab28e7a3abf90720c1c6108ff8946b6f7b) )
	ROM_LOAD16_WORD_SWAP( "c51t08.p2", 0x080000, 0x80000, CRC(94a4434b) SHA1(1729bed0121995ddffc21b3d3841f6eaddab8064) )
	ROM_LOAD16_WORD_SWAP( "c51.p3", 0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4", 0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5", 0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6", 0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7", 0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t09 ) // fix difficulty in non-japanese regions
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t09.p1", 0x000000, 0x80000, CRC(2b8989d5) SHA1(9db44d3dd92ffd1586c340242eabffcabd8a10ce) )
	ROM_LOAD16_WORD_SWAP( "c51.p2",    0x080000, 0x80000, CRC(d0bc29c6) SHA1(d9f89bcd79cba26db2100a00dd7bd8ee6ecb75f3) )
	ROM_LOAD16_WORD_SWAP( "c51.p3",    0x100000, 0x80000, CRC(65222964) SHA1(025bb708dc5b6365cc7fe60fc3f242511ad8f384) )
	ROM_LOAD16_WORD_SWAP( "c51.p4",    0x180000, 0x80000, CRC(8fe9f531) SHA1(b5d9ed498f730fdb968992bdec33605db1a007f4) )
	ROM_LOAD16_WORD_SWAP( "c51.p5",    0x200000, 0x80000, CRC(8a7d0cb6) SHA1(27ea0cea73a93c27257bf2a170d1deaf938cc311) )
	ROM_LOAD16_WORD_SWAP( "c51.p6",    0x280000, 0x80000, CRC(74c24062) SHA1(f3eca09e0544c6aa46b0c4bead2246ab1e9a97d9) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",    0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x000000, 0x000014, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2t10 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51t10.p1", 0x000000, 0x80000, CRC(3207daa4) SHA1(c5193d37438e3f6bbd763754162108c7bb3a5274) )
	ROM_LOAD16_WORD_SWAP( "c51u.p2", 0x080000, 0x80000, CRC(532b5ffd) SHA1(769a8a9d4e04e291ce7427b89e537bba2258ca82) )
	ROM_LOAD16_WORD_SWAP( "c51u.p3", 0x100000, 0x80000, CRC(ffa3c6de) SHA1(7cce55a3e07b5ba2e2e37e4c66a52678a1b19a63) )
	ROM_LOAD16_WORD_SWAP( "c51u.p4", 0x180000, 0x80000, CRC(83f9382b) SHA1(273ff4d4242ce22b755d35e5d2cf2517d625bdd2) )
	ROM_LOAD16_WORD_SWAP( "c51u.p5", 0x200000, 0x80000, CRC(6ab673e8) SHA1(840af0d0ce634fb98e4f89173c4f1f95ec2cf94b) )
	ROM_LOAD16_WORD_SWAP( "c51u.p6", 0x280000, 0x80000, CRC(b3c71810) SHA1(b51515f4f4aee5bbbfc8b79372d0bc6e0c140912) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",  0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2tu.key",   0x00, 0x14, CRC(f7d62def) SHA1(27a797fd6fe435e14ca334947df38d56f89f79de) )
ROM_END


 /****************************************
 Super Street Fighter II Turbo New Legacy
******************************************/
ROM_START( ssf2tnl3 ) // 0.3
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl3.p1",  0x000000, 0x80000, CRC(740f6b37) SHA1(37565be3e91aa2992c8af4812b7dec8aeb530dbc) )
	ROM_LOAD16_WORD_SWAP( "tnl3.p2",  0x080000, 0x80000, CRC(2c36133d) SHA1(05a6ad9c7fe79891a9ebae78dd23752253c05ea5) )
	ROM_LOAD16_WORD_SWAP( "tnl3.p3",  0x100000, 0x80000, CRC(b5f228f8) SHA1(df9a6236cb6fab4a1b0f8e81740469ca90191f06) )
	ROM_LOAD16_WORD_SWAP( "tnl3.p4",  0x180000, 0x80000, CRC(92e48cc2) SHA1(a9c5d39b1be5934da8f8fc6f5727b6b4e74da87a) )
	ROM_LOAD16_WORD_SWAP( "tnl3.p5",  0x200000, 0x80000, CRC(f535d195) SHA1(9d7a251311db7603084eb2c96bfb81f4a222159e) )
	ROM_LOAD16_WORD_SWAP( "tnl3.p6",  0x280000, 0x80000, CRC(b1be7707) SHA1(ea9a81cf169e119b179a00da2dd65724beda5933) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl4 ) // 0.4
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl4.p1",  0x000000, 0x80000, CRC(8eb183f3) SHA1(f874a0b759a1ca758400163855812f3b3f4fa8d5) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p2",  0x080000, 0x80000, CRC(9966e741) SHA1(318a01fe3d18bd3de695f88cd6f878996a3c59b9) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p3",  0x100000, 0x80000, CRC(5b79d5b5) SHA1(a6db98500be81a1c1b6803eb487b875e24fe5237) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p4",  0x180000, 0x80000, CRC(5d65a16c) SHA1(a17cd9fa5467fc7c3db35d81c8cd741f62fd7727) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p5",  0x200000, 0x80000, CRC(fa3b5717) SHA1(7ee72ac88d953ef32072971da789dd78441915ea) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p6",  0x280000, 0x80000, CRC(ac0f3088) SHA1(641884bd25f0ab93db6193c1999c4b10b6f1e248) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p7",  0x300000, 0x80000, CRC(2a738eb9) SHA1(88220fe35efa74d836985014dea7f20d5c6b6d34) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl4.c1",   0x000000, 0x200000, CRC(8b62f4f1) SHA1(52f91f34c373164a8e70fe93312b7f91e2775e77) )
	ROM_LOAD64_WORD( "tnl4.c2",   0x000002, 0x200000, CRC(0dc638b9) SHA1(a2cdc5bd7dece412704dd7681d1eb2af26d4f7cf) )
	ROM_LOAD64_WORD( "tnl4.c3",   0x000004, 0x200000, CRC(c204a74d) SHA1(e838f41e15aea92b632a5e1eeab9a4184786e435) )
	ROM_LOAD64_WORD( "tnl4.c4",   0x000006, 0x200000, CRC(b3367347) SHA1(279fb945009464cb5a2d596968fc47bb1094d8d4) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "tnl4.c9",   0xc00000, 0x100000, CRC(f2153d42) SHA1(7dfb8ad42f5f24c7197c74e819159556929ea75a) )
	ROM_LOAD64_WORD( "tnl4.c10",   0xc00002, 0x100000, CRC(a25a0007) SHA1(76bc2908d03e7a34f68dd95a447e55338944ac3c) )
	ROM_LOAD64_WORD( "tnl4.c11",   0xc00004, 0x100000, CRC(c75be82e) SHA1(ec5c42510f074b1c26f43a4f2a1c31f3e7c26bae) )
	ROM_LOAD64_WORD( "tnl4.c12",   0xc00006, 0x100000, CRC(3d0ce365) SHA1(1cf1845631e8dcf492c35d6114bdd61f25768ff7) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl5 ) // 0.5
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl5.p1",  0x000000, 0x80000, CRC(70c01f45) SHA1(231bbe1c05d51756f08b875f77a1a565c9bcb3e9) )
	ROM_LOAD16_WORD_SWAP( "tnl5.p2",  0x080000, 0x80000, CRC(08d8e5c6) SHA1(6568a968d53d18ebfd461ebcf2b584ddf2e234fc) )
	ROM_LOAD16_WORD_SWAP( "tnl5.p3",  0x100000, 0x80000, CRC(8149324a) SHA1(2db45feefdbf81d1ee8069bcaa2c49367a437139) )
	ROM_LOAD16_WORD_SWAP( "tnl5.p4",  0x180000, 0x80000, CRC(b6e40ec8) SHA1(8c30aa4473a546e6e73f00231c6f88cb641d88ed) )
	ROM_LOAD16_WORD_SWAP( "tnl5.p5",  0x200000, 0x80000, CRC(9ea93262) SHA1(ea3ccbea7b772e64154b06484dc3d8a4c2c812e2) )
	ROM_LOAD16_WORD_SWAP( "tnl4.p6",  0x280000, 0x80000, CRC(ac0f3088) SHA1(641884bd25f0ab93db6193c1999c4b10b6f1e248) )
	ROM_LOAD16_WORD_SWAP( "tnl5.p7",  0x300000, 0x80000, CRC(e2752a05) SHA1(114b6edbb56a550602882e646cb4e9227562fa69) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl5.c1",   0x000000, 0x200000, CRC(d7456444) SHA1(eb9c6efc803b5ba91a84baf5a04c6779e48757ea) )
	ROM_LOAD64_WORD( "tnl5.c2",   0x000002, 0x200000, CRC(fb5b1890) SHA1(b1dc29fe6665f4c1b749a44dd25cb29ad40a439f) )
	ROM_LOAD64_WORD( "tnl5.c3",   0x000004, 0x200000, CRC(40a8dbad) SHA1(cc108db910eb97fe509423bdedb777cb3fec983f) )
	ROM_LOAD64_WORD( "tnl5.c4",   0x000006, 0x200000, CRC(740f32cc) SHA1(5fd95a6c9847a380d15f0edc8faf5da12bae6ca1) )
	ROM_LOAD64_WORD( "tnl5.c5",   0x800000, 0x100000, CRC(1a6e6aa9) SHA1(f80f984621feab2db4443831da3f33685d1da3b5) )
	ROM_LOAD64_WORD( "tnl5.c6",   0x800002, 0x100000, CRC(0f6251bd) SHA1(2500363513f64d2e08d634a630146a02caef5e44) )
	ROM_LOAD64_WORD( "tnl5.c7",   0x800004, 0x100000, CRC(8b1eccaf) SHA1(439769a26efe15e35c1ba7e3c96687393e3fcb3c) )
	ROM_LOAD64_WORD( "tnl5.c8",   0x800006, 0x100000, CRC(26eb0233) SHA1(13b734c095c87a167db696aeea8478e6810c3f99) )
	ROM_LOAD64_WORD( "tnl4.c9",   0xc00000, 0x100000, CRC(f2153d42) SHA1(7dfb8ad42f5f24c7197c74e819159556929ea75a) )
	ROM_LOAD64_WORD( "tnl4.c10",   0xc00002, 0x100000, CRC(a25a0007) SHA1(76bc2908d03e7a34f68dd95a447e55338944ac3c) )
	ROM_LOAD64_WORD( "tnl4.c11",   0xc00004, 0x100000, CRC(c75be82e) SHA1(ec5c42510f074b1c26f43a4f2a1c31f3e7c26bae) )
	ROM_LOAD64_WORD( "tnl4.c12",   0xc00006, 0x100000, CRC(3d0ce365) SHA1(1cf1845631e8dcf492c35d6114bdd61f25768ff7) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl6 ) // 0.6
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl6.p1",  0x000000, 0x80000, CRC(46722af4) SHA1(4629e0eacbb6721f5b47476583887ce7f03da88a) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p2",  0x080000, 0x80000, CRC(c8167018) SHA1(9a21774c9786651b796964527e0a0e03aa914827) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p3",  0x100000, 0x80000, CRC(244be873) SHA1(e0379881fb6c48b3de78ec27cc6a13b66711dbbf) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p4",  0x180000, 0x80000, CRC(3a7f1f24) SHA1(c744dc57acb99e57f5f274aea5aadca74ef2534b) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p5",  0x200000, 0x80000, CRC(af0babd3) SHA1(d68317b81b611834be4e07d0501253f429de9500) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p6",  0x280000, 0x80000, CRC(2c717380) SHA1(3b352d66083fa97560202a225425b1a3a2b6c6db) )
	ROM_LOAD16_WORD_SWAP( "tnl6.p7",  0x300000, 0x80000, CRC(af970b89) SHA1(0967b53d3ab4a51eb0fcffee460197ba8c0d2c42) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl6.c1",   0x000000, 0x200000, CRC(c74a5e1c) SHA1(fc324ac2b5bd5b2d61ba50067bd170cf6a29ec40) )
	ROM_LOAD64_WORD( "tnl6.c2",   0x000002, 0x200000, CRC(d666749d) SHA1(c2611ee2a52738b417b078a7e4ea9463eac6d82f) )
	ROM_LOAD64_WORD( "tnl6.c3",   0x000004, 0x200000, CRC(378925a1) SHA1(c5030e7609fde6034a5e2abcbb84144224677e5f) )
	ROM_LOAD64_WORD( "tnl6.c4",   0x000006, 0x200000, CRC(41187858) SHA1(71077b72007bc552a00f096940566288bd84aa78) )
	ROM_LOAD64_WORD( "tnl5.c5",   0x800000, 0x100000, CRC(1a6e6aa9) SHA1(f80f984621feab2db4443831da3f33685d1da3b5) )
	ROM_LOAD64_WORD( "tnl5.c6",   0x800002, 0x100000, CRC(0f6251bd) SHA1(2500363513f64d2e08d634a630146a02caef5e44) )
	ROM_LOAD64_WORD( "tnl5.c7",   0x800004, 0x100000, CRC(8b1eccaf) SHA1(439769a26efe15e35c1ba7e3c96687393e3fcb3c) )
	ROM_LOAD64_WORD( "tnl5.c8",   0x800006, 0x100000, CRC(26eb0233) SHA1(13b734c095c87a167db696aeea8478e6810c3f99) )
	ROM_LOAD64_WORD( "tnl6.c9",   0xc00000, 0x100000, CRC(40144981) SHA1(21e1f400d99e6d520a33665f10de482e8ba591d9) )
	ROM_LOAD64_WORD( "tnl6.c10",   0xc00002, 0x100000, CRC(49953e2c) SHA1(1715c951bc8c7a995c2491f24bb5dc2effde8dce) )
	ROM_LOAD64_WORD( "tnl6.c11",   0xc00004, 0x100000, CRC(8c7ef38b) SHA1(00af700701c2ee6d6b5d21f94203159cce7809df) )
	ROM_LOAD64_WORD( "tnl6.c12",   0xc00006, 0x100000, CRC(9ad47db1) SHA1(1c1674be2eb9255f00e1676228bcaae3f7aa0b9c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl7 )  // 0.7
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl7.p1",  0x000000, 0x80000, CRC(571944fb) SHA1(f08288e84871b645560d78efe2a934cf1be8eebb) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p2",  0x080000, 0x80000, CRC(ad4e5240) SHA1(9b7edb4de9168ed056c55228a28ad96cc9697641) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p3",  0x100000, 0x80000, CRC(6fe99f40) SHA1(b3b352e54b5b7909a3a14dfe9ace915a7abe1ac4) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p4",  0x180000, 0x80000, CRC(d2de5788) SHA1(b5c673236058c2a30dba02978e1c44c1e3fdc2dc) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p5",  0x200000, 0x80000, CRC(2da4d098) SHA1(7e192904ba5774bc592e39fadaba8e290a09fb26) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p6",  0x280000, 0x80000, CRC(04462bf4) SHA1(4e62fd11def071f185ad3bfaf080454b183bf4c5) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p7",  0x300000, 0x80000, CRC(23d51921) SHA1(d234f50ba8314604a142fa52efefd4821a0afd96) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl7.c1",   0x000000, 0x200000, CRC(c05989e6) SHA1(dc99172f8616a855aa283adfe7883c0c2523316a) )
	ROM_LOAD64_WORD( "tnl7.c2",   0x000002, 0x200000, CRC(ee15fca6) SHA1(d1f55129212ca0c9c8bbed87acc2690289d37a1f) )
	ROM_LOAD64_WORD( "tnl7.c3",   0x000004, 0x200000, CRC(2e9d2558) SHA1(5e53735d6d3ba461e5ee07ef09bf2f422012752c) )
	ROM_LOAD64_WORD( "tnl7.c4",   0x000006, 0x200000, CRC(6f01ec3b) SHA1(7d7237141c629ca0680f6149c4864be8e5b5d269) )
	ROM_LOAD64_WORD( "tnl7.c5",   0x800000, 0x100000, CRC(08c6976b) SHA1(56aa74632b0a6b92b1ff33bc62a150642671b8d1) )
	ROM_LOAD64_WORD( "tnl7.c6",   0x800002, 0x100000, CRC(4d94aee3) SHA1(48b7e01bbf4fba4de0eed51c2016ed9b912c0766) )
	ROM_LOAD64_WORD( "tnl7.c7",   0x800004, 0x100000, CRC(fab6dfd6) SHA1(e60dd3f3570c431955984c124a6499ed139d85f1) )
	ROM_LOAD64_WORD( "tnl7.c8",   0x800006, 0x100000, CRC(5080bc5c) SHA1(4bd20a8566601f14678426d85c76b245a87d8b87) )
	ROM_LOAD64_WORD( "tnl7.c9",   0xc00000, 0x100000, CRC(9c871fdd) SHA1(c6ed78a6755e581d9235c8c8836cb51044ecd0fe) )
	ROM_LOAD64_WORD( "tnl7.c10",   0xc00002, 0x100000, CRC(a05ad3bd) SHA1(6857d7846a9f87f8c601e4adf80f199e58c0dcbb) )
	ROM_LOAD64_WORD( "tnl7.c11",   0xc00004, 0x100000, CRC(36894d02) SHA1(c036f79c08511cb1c7f14ca450dbe80b7b43b3dc) )
	ROM_LOAD64_WORD( "tnl7.c12",   0xc00006, 0x100000, CRC(46d6f9bd) SHA1(5d70eabff1e64a8da6c813ab2756a15019942926) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl71 )  // 0.7.1
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl71.p1",   0x000000, 0x80000, CRC(ff8a0f1e) SHA1(ec0f8942445b157a297a699027b6286223603c56) )
	ROM_LOAD16_WORD_SWAP( "tnl71.p2",   0x080000, 0x80000, CRC(570b7843) SHA1(e06c64c08bb72d7893bff9b6584034c4270c20a9) )
	ROM_LOAD16_WORD_SWAP( "tnl71.p3",   0x100000, 0x80000, CRC(866c980e) SHA1(3ba97699fa0a5442d9b734bbb4856434c538f712) )
	ROM_LOAD16_WORD_SWAP( "tnl71.p4",   0x180000, 0x80000, CRC(adb6474e) SHA1(2f88020c9461bee68368a6a7b4ac5cc39e737303) )
	ROM_LOAD16_WORD_SWAP( "tnl71.p5",   0x200000, 0x80000, CRC(f4ebe547) SHA1(f9743a860233ad00edac71660ed07ac581b38e6e) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p6",  0x280000, 0x80000, CRC(04462bf4) SHA1(4e62fd11def071f185ad3bfaf080454b183bf4c5) )
	ROM_LOAD16_WORD_SWAP( "tnl7.p7",  0x300000, 0x80000, CRC(23d51921) SHA1(d234f50ba8314604a142fa52efefd4821a0afd96) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl7.c1",   0x000000, 0x200000, CRC(c05989e6) SHA1(dc99172f8616a855aa283adfe7883c0c2523316a) )
	ROM_LOAD64_WORD( "tnl7.c2",   0x000002, 0x200000, CRC(ee15fca6) SHA1(d1f55129212ca0c9c8bbed87acc2690289d37a1f) )
	ROM_LOAD64_WORD( "tnl7.c3",   0x000004, 0x200000, CRC(2e9d2558) SHA1(5e53735d6d3ba461e5ee07ef09bf2f422012752c) )
	ROM_LOAD64_WORD( "tnl7.c4",   0x000006, 0x200000, CRC(6f01ec3b) SHA1(7d7237141c629ca0680f6149c4864be8e5b5d269) )
	ROM_LOAD64_WORD( "tnl7.c5",   0x800000, 0x100000, CRC(08c6976b) SHA1(56aa74632b0a6b92b1ff33bc62a150642671b8d1) )
	ROM_LOAD64_WORD( "tnl7.c6",   0x800002, 0x100000, CRC(4d94aee3) SHA1(48b7e01bbf4fba4de0eed51c2016ed9b912c0766) )
	ROM_LOAD64_WORD( "tnl7.c7",   0x800004, 0x100000, CRC(fab6dfd6) SHA1(e60dd3f3570c431955984c124a6499ed139d85f1) )
	ROM_LOAD64_WORD( "tnl7.c8",   0x800006, 0x100000, CRC(5080bc5c) SHA1(4bd20a8566601f14678426d85c76b245a87d8b87) )
	ROM_LOAD64_WORD( "tnl7.c9",   0xc00000, 0x100000, CRC(9c871fdd) SHA1(c6ed78a6755e581d9235c8c8836cb51044ecd0fe) )
	ROM_LOAD64_WORD( "tnl7.c10",   0xc00002, 0x100000, CRC(a05ad3bd) SHA1(6857d7846a9f87f8c601e4adf80f199e58c0dcbb) )
	ROM_LOAD64_WORD( "tnl7.c11",   0xc00004, 0x100000, CRC(36894d02) SHA1(c036f79c08511cb1c7f14ca450dbe80b7b43b3dc) )
	ROM_LOAD64_WORD( "tnl7.c12",   0xc00006, 0x100000, CRC(46d6f9bd) SHA1(5d70eabff1e64a8da6c813ab2756a15019942926) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl8 )  // 0.8
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl8.p1",   0x000000, 0x80000, CRC(09b53b58) SHA1(0b27760e4b0d0de08f73c9d4e70c6a66874b6d23) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p2",   0x080000, 0x80000, CRC(71202594) SHA1(ef59591a158000d4770ffeb418917c490c7d4ebf) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p3",   0x100000, 0x80000, CRC(bbbd5ef6) SHA1(4c47553353e89a8a9d849755daee9413bbba2cbf) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p4",   0x180000, 0x80000, CRC(ddb5dee6) SHA1(d7a40359c2e85d8e7040b088021b183de8e9401c) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p5",   0x200000, 0x80000, CRC(7c228198) SHA1(920d63a4ef82c779153e372909694f567a731c22) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p6",   0x280000, 0x80000, CRC(cbbd989b) SHA1(75ee6d619351ddd5e65aeb7d05a6a400868c030d) )
	ROM_LOAD16_WORD_SWAP( "tnl8.p7",   0x300000, 0x80000, CRC(bb18adff) SHA1(597ffa3f34f0566d3160113ee2950f3449367823) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl8.c1",   0x000000, 0x200000, CRC(63e77950) SHA1(f52ee73f9417168c6e6603e79427cd8056967094) )
	ROM_LOAD64_WORD( "tnl8.c2",   0x000002, 0x200000, CRC(dd35a143) SHA1(5f04a113faee805a4bc828b70c6a9a02be25f779) )
	ROM_LOAD64_WORD( "tnl8.c3",   0x000004, 0x200000, CRC(f4ac22f3) SHA1(307ab4f81bff22d6380ef63206266afa1cbe8c43) )
	ROM_LOAD64_WORD( "tnl8.c4",   0x000006, 0x200000, CRC(71cf7604) SHA1(fcc79ab169187eec81f64bb1f61d4e6422d95ad9) )
	ROM_LOAD64_WORD( "tnl7.c5",   0x800000, 0x100000, CRC(08c6976b) SHA1(56aa74632b0a6b92b1ff33bc62a150642671b8d1) )
	ROM_LOAD64_WORD( "tnl7.c6",   0x800002, 0x100000, CRC(4d94aee3) SHA1(48b7e01bbf4fba4de0eed51c2016ed9b912c0766) )
	ROM_LOAD64_WORD( "tnl7.c7",   0x800004, 0x100000, CRC(fab6dfd6) SHA1(e60dd3f3570c431955984c124a6499ed139d85f1) )
	ROM_LOAD64_WORD( "tnl7.c8",   0x800006, 0x100000, CRC(5080bc5c) SHA1(4bd20a8566601f14678426d85c76b245a87d8b87) )
	ROM_LOAD64_WORD( "tnl8.c9",   0xc00000, 0x100000, CRC(648519f7) SHA1(5810d710dcbbd1b34168a0390176bfa170f49fcf) )
	ROM_LOAD64_WORD( "tnl8.c10",   0xc00002, 0x100000, CRC(efd2eb24) SHA1(500311f92817520983bb7f6957cdc5eb9bc3135a) )
	ROM_LOAD64_WORD( "tnl8.c11",   0xc00004, 0x100000, CRC(3294c78b) SHA1(8166a2c0434c301f7ef5eec5362f41ce0382a8c1) )
	ROM_LOAD64_WORD( "tnl8.c12",   0xc00006, 0x100000, CRC(fc283290) SHA1(ee35fb03fd1e3ca238d9155d3bc8491d38173826) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END

ROM_START( ssf2tnl )  // 0.9
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "tnl.p1",   0x000000, 0x80000, CRC(4beda7d5) SHA1(2045e322043387a05fb1773d45bcc2c1215a9a98) )
	ROM_LOAD16_WORD_SWAP( "tnl.p2",   0x080000, 0x80000, CRC(d00594d8) SHA1(2ee61a9ecbeab64d2b03e38b1e753c4d800b62b1) )
	ROM_LOAD16_WORD_SWAP( "tnl.p3",   0x100000, 0x80000, CRC(c7e8ded4) SHA1(3fd9b943e7fc61925910e53eded1ac3e8083845e) )
	ROM_LOAD16_WORD_SWAP( "tnl.p4",   0x180000, 0x80000, CRC(16b305b7) SHA1(af0a85295ecefc7d8a4c612b8f0e0c8c3ed5748d) )
	ROM_LOAD16_WORD_SWAP( "tnl.p5",   0x200000, 0x80000, CRC(43ad0333) SHA1(5ae4b127a9dd3f4c7c9396fb7f2398d6dc820524) )
	ROM_LOAD16_WORD_SWAP( "tnl.p6",   0x280000, 0x80000, CRC(1c1696e4) SHA1(a3baf599b2e8a9cb124e1f80a819688626047ed5) )
	ROM_LOAD16_WORD_SWAP( "tnl.p7",   0x300000, 0x80000, CRC(6b2068bc) SHA1(db5e69a0748df373a0ecff39cd1ac2c426f0e6d5) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "tnl.c1",        0x000000, 0x200000, CRC(c1df58ed) SHA1(b24d6033aefc8dee1b946bb82c5496725716c8cd) )
	ROM_LOAD64_WORD( "tnl.c2",        0x000002, 0x200000, CRC(0f1bdf35) SHA1(f2c037e52fc704f4237bf8df3bf427b534851195) )
	ROM_LOAD64_WORD( "tnl.c3",        0x000004, 0x200000, CRC(13acf82f) SHA1(a8bcc134644f355232493896af9c0b8287984f3c) )
	ROM_LOAD64_WORD( "tnl.c4",        0x000006, 0x200000, CRC(7a7e1bba) SHA1(f62de983c5bd7c9ccb3367dd8e2171f7f0c87e61) )
	ROM_LOAD64_WORD( "tnl.c5",        0x800000, 0x100000, CRC(d24d002b) SHA1(ef63edabca6cdaf53b526349e9100ae1792f32e7) )
	ROM_LOAD64_WORD( "tnl.c6",        0x800002, 0x100000, CRC(8e81e9c4) SHA1(5f77a3d30230481f62573cb7f92dd263a866cae2) )
	ROM_LOAD64_WORD( "tnl.c7",        0x800004, 0x100000, CRC(261285bc) SHA1(d01cac512858500a1d52575844c0a280eafe1965) )
	ROM_LOAD64_WORD( "tnl.c8",        0x800006, 0x100000, CRC(ffa37375) SHA1(3589e3f1048d55cd8f8a9986b487bcc5d096d6d8) )
	ROM_LOAD64_WORD( "tnl8.c9",       0xc00000, 0x100000, CRC(648519f7) SHA1(5810d710dcbbd1b34168a0390176bfa170f49fcf) )
	ROM_LOAD64_WORD( "tnl8.c10",      0xc00002, 0x100000, CRC(efd2eb24) SHA1(500311f92817520983bb7f6957cdc5eb9bc3135a) )
	ROM_LOAD64_WORD( "tnl8.c11",      0xc00004, 0x100000, CRC(3294c78b) SHA1(8166a2c0434c301f7ef5eec5362f41ce0382a8c1) )
	ROM_LOAD64_WORD( "tnl8.c12",      0xc00006, 0x100000, CRC(fc283290) SHA1(ee35fb03fd1e3ca238d9155d3bc8491d38173826) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2t.key",    0x00, 0x14, CRC(524d608e) SHA1(fcd2b9a1a640a0dee4a674dc9cfb3975466f7757) )
ROM_END


/************************************************************
 Super Street Fighter II X: Turbo New Grand Master Challenge
**************************************************************/
ROM_START( ssf2x01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51x01.p1", 0x000000, 0x80000, CRC(44df446f) SHA1(a134ab9d1d21aa6ccb88212d0acbf40633b5db2f) )
	ROM_LOAD16_WORD_SWAP( "c51x01.p2", 0x080000, 0x80000, CRC(d9805fbc) SHA1(48a1fe09a9ba225fb86bd367fe14f531bb8984d7) )
	ROM_LOAD16_WORD_SWAP( "c51j.p3",  0x100000, 0x80000, CRC(f4ff18f5) SHA1(aa713c9e1a2eba35bf1c9b40bb262ff7e46b9ce4) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p4", 0x180000, 0x80000, CRC(260d0370) SHA1(5339cf87000caef74d491815391be59cfd701c8b) )
	ROM_LOAD16_WORD_SWAP( "c51x01.p5",  0x200000, 0x80000, CRC(ba26298f) SHA1(6eb6f69d573a6102ba3908942d4669afaac64f75) )
	ROM_LOAD16_WORD_SWAP( "c51j.p6",  0x280000, 0x80000, CRC(2de76f10) SHA1(8cbe96dfeaa41306caa2819b82272ce3b0b9f926) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2xj.key",   0x00, 0x14, CRC(160d1424) SHA1(187baff83b54acfdcedd9b9222a4cc768040c622) )
ROM_END

ROM_START( ssf2x02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p1", 0x000000, 0x80000, CRC(a7417b79) SHA1(189c3ed546bb2844e9fa9fe7e9aacef728bc8939) )
	ROM_LOAD16_WORD_SWAP( "c51x02.p2", 0x080000, 0x80000, CRC(1a734f1f) SHA1(2c87f37d6f87bf2355e65a3d714ee1849e1636b4) )
	ROM_LOAD16_WORD_SWAP( "c51j.p3",   0x100000, 0x80000, CRC(f4ff18f5) SHA1(aa713c9e1a2eba35bf1c9b40bb262ff7e46b9ce4) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p4", 0x180000, 0x80000, CRC(260d0370) SHA1(5339cf87000caef74d491815391be59cfd701c8b) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p5", 0x200000, 0x80000, CRC(1324d02a) SHA1(c23a6ea09819bd33b6e2f58aa28c317ce53a46a0) )
	ROM_LOAD16_WORD_SWAP( "c51j.p6",   0x280000, 0x80000, CRC(2de76f10) SHA1(8cbe96dfeaa41306caa2819b82272ce3b0b9f926) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",    0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2xj.key",   0x00, 0x14, CRC(160d1424) SHA1(187baff83b54acfdcedd9b9222a4cc768040c622) )
ROM_END

ROM_START( ssf2x03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51x03.p1", 0x000000, 0x80000, CRC(62b59bf0) SHA1(b8ef9a39dd594f243dab3b440c871730356403c8) )
	ROM_LOAD16_WORD_SWAP( "c51j.p2", 0x080000, 0x80000, CRC(af7767b4) SHA1(61e7364408bf07c01634913c112b6245acce48ab) )
	ROM_LOAD16_WORD_SWAP( "c51j.p3",  0x100000, 0x80000, CRC(f4ff18f5) SHA1(aa713c9e1a2eba35bf1c9b40bb262ff7e46b9ce4) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p4", 0x180000, 0x80000, CRC(260d0370) SHA1(5339cf87000caef74d491815391be59cfd701c8b) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p5",  0x200000, 0x80000, CRC(1324d02a) SHA1(c23a6ea09819bd33b6e2f58aa28c317ce53a46a0) )
	ROM_LOAD16_WORD_SWAP( "c51j.p6",  0x280000, 0x80000, CRC(2de76f10) SHA1(8cbe96dfeaa41306caa2819b82272ce3b0b9f926) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2xj.key",   0x00, 0x14, CRC(160d1424) SHA1(187baff83b54acfdcedd9b9222a4cc768040c622) )
ROM_END

ROM_START( ssf2x04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51x04.p1", 0x000000, 0x80000, CRC(183e95df) SHA1(009bfc636f67481ae0147a96e9a9b8eaa6137e52) )
	ROM_LOAD16_WORD_SWAP( "c51x04.p2", 0x080000, 0x80000, CRC(6ce1a901) SHA1(dd8d82b744bb40d1c07ad8feabfc02c62cd868aa) )
	ROM_LOAD16_WORD_SWAP( "c51j.p3",  0x100000, 0x80000, CRC(f4ff18f5) SHA1(aa713c9e1a2eba35bf1c9b40bb262ff7e46b9ce4) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p4", 0x180000, 0x80000, CRC(260d0370) SHA1(5339cf87000caef74d491815391be59cfd701c8b) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p5",  0x200000, 0x80000, CRC(1324d02a) SHA1(c23a6ea09819bd33b6e2f58aa28c317ce53a46a0) )
	ROM_LOAD16_WORD_SWAP( "c51j.p6",  0x280000, 0x80000, CRC(2de76f10) SHA1(8cbe96dfeaa41306caa2819b82272ce3b0b9f926) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",   0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2xj.key",   0x00, 0x14, CRC(160d1424) SHA1(187baff83b54acfdcedd9b9222a4cc768040c622) )
ROM_END

ROM_START( ssf2x05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c51x05.p1", 0x000000, 0x80000, CRC(c0b5e5b8) SHA1(8cedb674aac5918dbb38d2efa4036ea602b92f8a) )
	ROM_LOAD16_WORD_SWAP( "c51x05.p2", 0x080000, 0x80000, CRC(4e17998f) SHA1(24b10b541191dfd522f024259d530451785abc2d) )
	ROM_LOAD16_WORD_SWAP( "c51j.p3",   0x100000, 0x80000, CRC(f4ff18f5) SHA1(aa713c9e1a2eba35bf1c9b40bb262ff7e46b9ce4) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p4", 0x180000, 0x80000, CRC(260d0370) SHA1(5339cf87000caef74d491815391be59cfd701c8b) )
	ROM_LOAD16_WORD_SWAP( "c51jr1.p5", 0x200000, 0x80000, CRC(1324d02a) SHA1(c23a6ea09819bd33b6e2f58aa28c317ce53a46a0) )
	ROM_LOAD16_WORD_SWAP( "c51x05.p6", 0x280000, 0x80000, CRC(6745612c) SHA1(d21b010d25d19b1c31b7f02d85978cd4a4444d60) )
	ROM_LOAD16_WORD_SWAP( "c51.p7",    0x300000, 0x80000, CRC(642fae3f) SHA1(746df99b826b9837bba267104132161153c1daff) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c48.c1",   0x000000, 0x200000, CRC(cf94d275) SHA1(bf2a6d98a656d1cb5734da7836686242d3211137) )
	ROM_LOAD64_WORD( "c48.c2",   0x000002, 0x200000, CRC(5eb703af) SHA1(4b302dbb66e8a5c2ad92798699391e981bada427) )
	ROM_LOAD64_WORD( "c48.c3",   0x000004, 0x200000, CRC(ffa60e0f) SHA1(b21b1c749a8241440879bf8e7cb33968ccef97e5) )
	ROM_LOAD64_WORD( "c48.c4",   0x000006, 0x200000, CRC(34e825c5) SHA1(4d320fc96d1ef0b9928a8ce801734245a4c097a5) )
	ROM_LOAD64_WORD( "c48.c5",   0x800000, 0x100000, CRC(b7cc32e7) SHA1(0f4d26af338dab5dce5b7b34d32ad0c573434ace) )
	ROM_LOAD64_WORD( "c48.c6",   0x800002, 0x100000, CRC(8376ad18) SHA1(f4456833fb396e6501f4174c0fe5fd63ea40a188) )
	ROM_LOAD64_WORD( "c48.c7",   0x800004, 0x100000, CRC(f5b1b336) SHA1(4b060501e56b9d61294748da5387cdae5280ec4d) )
	ROM_LOAD64_WORD( "c48.c8",   0x800006, 0x100000, CRC(459d5c6b) SHA1(32b11ba7a12004aff810d719bff7508204c7b7c0) )
	ROM_LOAD64_WORD( "c51.c9",   0xc00000, 0x100000, CRC(e32854af) SHA1(1a5e11e9caa2b96108d89ae660ef1f6bcb469a74) )
	ROM_LOAD64_WORD( "c51.c10",  0xc00002, 0x100000, CRC(760f2927) SHA1(491e28e14ee06821fc9e709efa7b91313bc0c2db) )
	ROM_LOAD64_WORD( "c51.c11",  0xc00004, 0x100000, CRC(1ee90208) SHA1(83df1d9953560edddc2951ea426d29fb014e6a8a) )
	ROM_LOAD64_WORD( "c51.c12",  0xc00006, 0x100000, CRC(f814400f) SHA1(ad6921af36d0bd5dfb89b1fb53c3ca3fd92d7204) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c51.m1",   0x00000, 0x08000, CRC(b47b8835) SHA1(c8b2d50fe3a329bd0592ea160d505155d873dab1) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c51.m2",   0x28000, 0x20000, CRC(0022633f) SHA1(cab3afc79da53e3887eb1ccd1f4d19790728e6cd) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c51.q1",   0x000000, 0x200000, CRC(9bdbd476) SHA1(a8520f77f30b97aae36408e0c4ca1ebbde1808a5) )
	ROM_LOAD16_WORD_SWAP( "c51.q2",   0x200000, 0x200000, CRC(a05e3aab) SHA1(d4eb9cae66c74e956569fea8b815156fbd420f83) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ssf2xj.key",   0x00, 0x14, CRC(160d1424) SHA1(187baff83b54acfdcedd9b9222a4cc768040c622) )
ROM_END

 /******************
 Alien vs. Predator
*********************/
ROM_START( avsps01 ) //avspu3p, avspp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52s01.p1", 0x000000, 0x80000, CRC(2f3dfdd3) SHA1(730a6d70a6cb44a6c60f500d9312c1b8c31d0f4b) )
	ROM_LOAD16_WORD_SWAP( "c52s01.p2", 0x080000, 0x80000, CRC(04229fd7) SHA1(65a5719697c7c1cb46c330c69559666f2bf6e16f) )
	ROM_LOAD16_WORD_SWAP( "c52.p3",  0x100000, 0x80000, CRC(fbfb5d7a) SHA1(5549bc9d780753bc9c10fba82588e5c3d4a2acb2) )
	ROM_LOAD16_WORD_SWAP( "c52.p4",   0x180000, 0x80000, CRC(190b817f) SHA1(9bcfc0a015ffba9cdac25b6270939a9690de5da7) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "avspu.key",    0x00, 0x14, CRC(4e68e346) SHA1(60d5a12c77d07efc01f48968f4a12c59bf6b629e) )
ROM_END

ROM_START( avsps02 ) //avspu3p, avspu3pp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52s02.p1", 0x000000, 0x80000, CRC(bb0f1eba) SHA1(08b13b0044b3ed2d0293799422eebfb3e531e276) )
	ROM_LOAD16_WORD_SWAP( "c52s02.p2", 0x080000, 0x80000, CRC(78106911) SHA1(2b47d9c99f36de5a8028708e6e17ba278d38b155) )
	ROM_LOAD16_WORD_SWAP( "c52s02.p3",  0x100000, 0x80000, CRC(0207cb19) SHA1(a6dab4afc94c6bbaf353deb97e84cff6f76e9f35) )
	ROM_LOAD16_WORD_SWAP( "c52.p4",   0x180000, 0x80000, CRC(190b817f) SHA1(9bcfc0a015ffba9cdac25b6270939a9690de5da7) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "avspu.key",    0x00, 0x14, CRC(4e68e346) SHA1(60d5a12c77d07efc01f48968f4a12c59bf6b629e) )
ROM_END

ROM_START( avsps03 ) //avspdp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52s03.p1", 0x000000, 0x80000, CRC(e76657b7) SHA1(e488710f196489f3706c696d0f008ae63c3ff358) )
	ROM_LOAD16_WORD_SWAP( "c52s03.p2", 0x080000, 0x80000, CRC(8799b67f) SHA1(fe755897231b21ac8e47f1e5bc0ca73ae91e433a) )
	ROM_LOAD16_WORD_SWAP( "c52s02.p3",  0x100000, 0x80000, CRC(0207cb19) SHA1(a6dab4afc94c6bbaf353deb97e84cff6f76e9f35) )
	ROM_LOAD16_WORD_SWAP( "c52d.p4",   0x180000, 0x80000, CRC(63094539) SHA1(f1b776cf4334fa7fa1ee0e5ce81a5996b930996b) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )
ROM_END

ROM_START( avsps04 ) //avspdp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52s04.p1", 0x000000, 0x80000, CRC(02a03d8d) SHA1(9c3d25231ca51a6b6559329958ce0cdb71a9720e) )
	ROM_LOAD16_WORD_SWAP( "c52s03.p2", 0x080000, 0x80000, CRC(8799b67f) SHA1(fe755897231b21ac8e47f1e5bc0ca73ae91e433a) )
	ROM_LOAD16_WORD_SWAP( "c52s02.p3", 0x100000, 0x80000, CRC(0207cb19) SHA1(a6dab4afc94c6bbaf353deb97e84cff6f76e9f35) )
	ROM_LOAD16_WORD_SWAP( "c52d.p4",   0x180000, 0x80000, CRC(63094539) SHA1(f1b776cf4334fa7fa1ee0e5ce81a5996b930996b) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )
ROM_END

ROM_START( avsps05 ) //avsph
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52s05.p1", 0x000000, 0x80000, CRC(5bf9a02d) SHA1(9fd0d2260cd3d7e7ac0d363f8a2cac376742c6fd) )
	ROM_LOAD16_WORD_SWAP( "c52s05.p2", 0x080000, 0x80000, CRC(7eb392f7) SHA1(fbe0e40b060a5b64b4ee529f25d2c01c4dace5e0) )
	ROM_LOAD16_WORD_SWAP( "c52.p3",  0x100000, 0x80000, CRC(fbfb5d7a) SHA1(5549bc9d780753bc9c10fba82588e5c3d4a2acb2) )
	ROM_LOAD16_WORD_SWAP( "c52.p4",   0x180000, 0x80000, CRC(190b817f) SHA1(9bcfc0a015ffba9cdac25b6270939a9690de5da7) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "avsph.key",    0x00, 0x14, CRC(cae7b680) SHA1(b5f7c90c6c258ee9d0943028298bc8a0fcba63fb) )
ROM_END

ROM_START( avsps06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c52d.p1", 0x000000, 0x80000, CRC(66aa8aad) SHA1(eb1928393d0dd4cc1a96c00324508f83f36a7622) )
	ROM_LOAD16_WORD_SWAP( "c52d.p2", 0x080000, 0x80000, CRC(579306c2) SHA1(cabee3fdb624e681013a5a57d2a37339b96518fb) )
	ROM_LOAD16_WORD_SWAP( "c52s06.p3",  0x100000, 0x80000, CRC(3d9b92ac) SHA1(218756eec9180df78b5cd01b446d07616b387759) )
	ROM_LOAD16_WORD_SWAP( "c52s06.p4",  0x180000, 0x80000, CRC(9c3ec898) SHA1(a5bd67bbb9d9f603092ab34126d94c30e0ddda49) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c52.c1",   0x0000000, 0x200000, CRC(8f8b5ae4) SHA1(457ce959aa5db3a003de7dda2b3799b2f1ae279b) )
	ROM_LOAD64_WORD( "c52.c2",   0x0000002, 0x200000, CRC(b00280df) SHA1(bc1291a4a222d410bc99b6f1ed392067d9c3999e) )
	ROM_LOAD64_WORD( "c52.c3",   0x0000004, 0x200000, CRC(94403195) SHA1(efaad001527a5eba8f626aea9037ac6ef9a2c295) )
	ROM_LOAD64_WORD( "c52.c4",   0x0000006, 0x200000, CRC(e1981245) SHA1(809ccb7f10262e227d5e9d9f710e06f0e751f550) )
	ROM_LOAD64_WORD( "c52.c5",   0x0800000, 0x200000, CRC(ebba093e) SHA1(77aaf4197d1dae3321cf9c6d2b7967ee54cf3f30) )
	ROM_LOAD64_WORD( "c52.c6",   0x0800002, 0x200000, CRC(fb228297) SHA1(ebd02a4ba085dc70c0603662e14d61625fa04648) )
	ROM_LOAD64_WORD( "c52.c7",   0x0800004, 0x200000, CRC(34fb7232) SHA1(8b1f15bfa758a61e6ad519af24ca774edc70d194) )
	ROM_LOAD64_WORD( "c52.c8",   0x0800006, 0x200000, CRC(f90baa21) SHA1(20a900819a9d321316e3dfd241210725d7191ecf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c52.m1",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c52.q1",   0x000000, 0x200000, CRC(83499817) SHA1(e65b0ebd61ddc748842a9d4d92404b5305307623) )
	ROM_LOAD16_WORD_SWAP( "c52.q2",   0x200000, 0x200000, CRC(f4110d49) SHA1(f27538776cc1ba8213f19f98728ed8c02508d3ac) )
ROM_END

 /*********************************
 Darkstalkers: The Night Warriors
************************************/
ROM_START( dstlks01 ) //dstlkl
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c53s01.p1", 0x000000, 0x80000, CRC(062da6f1) SHA1(6f470b5a68d70f066fbb29e88d819496de611713) )
	ROM_LOAD16_WORD_SWAP( "c53.p2", 0x080000, 0x80000, CRC(ae413ff2) SHA1(e9b85ac04d6d1a57368c70aa24e3ab8a8d67409f) )
	ROM_LOAD16_WORD_SWAP( "c53.p3", 0x100000, 0x80000, CRC(60678756) SHA1(5d10829ad7522b5de3b318dd8cbf1b506ba4c2d4) )
	ROM_LOAD16_WORD_SWAP( "c53.p4", 0x180000, 0x80000, CRC(912870b3) SHA1(9c7620c7e25d236050411ba94fbc5b3b501970a3) )
	ROM_LOAD16_WORD_SWAP( "c53.p5", 0x200000, 0x80000, CRC(dabae3e8) SHA1(126f8433491db36649f5e1908bbe45eb123048e4) )
	ROM_LOAD16_WORD_SWAP( "c53.p6", 0x280000, 0x80000, CRC(2c6e3077) SHA1(d8042312ec546e3e807e3ef0a14af9b4f716e415) )
	ROM_LOAD16_WORD_SWAP( "c53.p7", 0x300000, 0x80000, CRC(f16db74b) SHA1(7b7e31916a61e7fb35ec20849c6d22d74e169ec0) )
	ROM_LOAD16_WORD_SWAP( "c53.p8", 0x380000, 0x80000, CRC(701e2147) SHA1(c0a0603e01fbed67a600b83902091c1073e2ed27) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c53.c1",   0x0000000, 0x400000, CRC(c51baf99) SHA1(2fb6642908e542e404391eb17392f8270e87bf48) )
	ROM_LOAD64_WORD( "c53.c2",   0x0000002, 0x400000, CRC(3ce83c77) SHA1(93369b23c6d7d834297434691bb047ee3dd9539c) )
	ROM_LOAD64_WORD( "c53.c3",   0x0000004, 0x400000, CRC(4f2408e0) SHA1(cd49c6b3c7e6470c6058f98ccc5210b052bb13e2) )
	ROM_LOAD64_WORD( "c53.c4",   0x0000006, 0x400000, CRC(9ff60250) SHA1(d69ba4dc6bd37d003245f0cf3211d6e2623005b8) )
	ROM_LOAD64_WORD( "c53.c5",   0x1000000, 0x100000, CRC(bd87243c) SHA1(87b33aeb72514e1228ffc27ec6dd534f14882760) )
	ROM_LOAD64_WORD( "c53.c6",   0x1000002, 0x100000, CRC(afec855f) SHA1(cd117833b8d475489b90ff44b57e2c5cb1af3af5) )
	ROM_LOAD64_WORD( "c53.c7",   0x1000004, 0x100000, CRC(3a033625) SHA1(294238f30cba5cf4f8f1de951d54c2077bd95de9) )
	ROM_LOAD64_WORD( "c53.c8",   0x1000006, 0x100000, CRC(2bff6a89) SHA1(8f4e131e5ce0af48fb89f98026d9f0356c7c301f) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c53.m1",   0x00000, 0x08000, CRC(64b685d5) SHA1(6c180e7420db754eca5cad17a40f5a64f5c3bd15) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c53.m2",   0x28000, 0x20000, CRC(cf7c97c7) SHA1(109a4b56ecd59be9c3f5869de99d40619bdaef21) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c53.q1",   0x000000, 0x200000, CRC(4a39deb2) SHA1(7e63e615869958db66a4e52a0272afee5a10e446) )
	ROM_LOAD16_WORD_SWAP( "c53.q2",   0x200000, 0x200000, CRC(1a3e5c03) SHA1(c5a556e125d6c3d68da745b4d56cd7a851f2a23d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "dstlk.key",    0x00, 0x14, CRC(cfa46dec) SHA1(ce57b3d53557f04ac53dac97d67374c288d85866) )
ROM_END

ROM_START( vampj01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c53j01.p1", 0x000000, 0x80000, CRC(55c1be82) SHA1(948e1e322945adc775da8b22165697b5c7999b1b) )
	ROM_LOAD16_WORD_SWAP( "c53j01.p2", 0x080000, 0x80000, CRC(9c12017e) SHA1(0800802748ce61b01a18c06b61fcb8fd7bb34f62) )
	ROM_LOAD16_WORD_SWAP( "c53j.p3", 0x100000, 0x80000, CRC(6c497e92) SHA1(7c1ccdfd77fb50afe024c8402376daaeab641a24) )
	ROM_LOAD16_WORD_SWAP( "c53j.p4", 0x180000, 0x80000, CRC(f1bbecb6) SHA1(6adba89393e05f16f70b57085cabd6b4c20f53e8) )
	ROM_LOAD16_WORD_SWAP( "c53j.p5", 0x200000, 0x80000, CRC(1067ad84) SHA1(5e4cc75cfdfd512b6230c656e7304262b5143aee) )
	ROM_LOAD16_WORD_SWAP( "c53j.p6", 0x280000, 0x80000, CRC(4b89f41f) SHA1(bd78f33a6d448655eecf7448921d282b302fa4cb) )
	ROM_LOAD16_WORD_SWAP( "c53j.p7", 0x300000, 0x80000, CRC(fc0a4aac) SHA1(a2c79eb4dc838c238e182a4da3567ac8db3488d8) )
	ROM_LOAD16_WORD_SWAP( "c53j.p8", 0x380000, 0x80000, CRC(9270c26b) SHA1(c2a7e199a74c9f27704cf935483ebddc6da256a1) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c53.c1",   0x0000000, 0x400000, CRC(c51baf99) SHA1(2fb6642908e542e404391eb17392f8270e87bf48) )
	ROM_LOAD64_WORD( "c53.c2",   0x0000002, 0x400000, CRC(3ce83c77) SHA1(93369b23c6d7d834297434691bb047ee3dd9539c) )
	ROM_LOAD64_WORD( "c53.c3",   0x0000004, 0x400000, CRC(4f2408e0) SHA1(cd49c6b3c7e6470c6058f98ccc5210b052bb13e2) )
	ROM_LOAD64_WORD( "c53.c4",   0x0000006, 0x400000, CRC(9ff60250) SHA1(d69ba4dc6bd37d003245f0cf3211d6e2623005b8) )
	ROM_LOAD64_WORD( "c53.c5",   0x1000000, 0x100000, CRC(bd87243c) SHA1(87b33aeb72514e1228ffc27ec6dd534f14882760) )
	ROM_LOAD64_WORD( "c53.c6",   0x1000002, 0x100000, CRC(afec855f) SHA1(cd117833b8d475489b90ff44b57e2c5cb1af3af5) )
	ROM_LOAD64_WORD( "c53.c7",   0x1000004, 0x100000, CRC(3a033625) SHA1(294238f30cba5cf4f8f1de951d54c2077bd95de9) )
	ROM_LOAD64_WORD( "c53.c8",   0x1000006, 0x100000, CRC(2bff6a89) SHA1(8f4e131e5ce0af48fb89f98026d9f0356c7c301f) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c53.m1",   0x00000, 0x08000, CRC(64b685d5) SHA1(6c180e7420db754eca5cad17a40f5a64f5c3bd15) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c53.m2",   0x28000, 0x20000, CRC(cf7c97c7) SHA1(109a4b56ecd59be9c3f5869de99d40619bdaef21) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c53.q1",   0x000000, 0x200000, CRC(4a39deb2) SHA1(7e63e615869958db66a4e52a0272afee5a10e446) )
	ROM_LOAD16_WORD_SWAP( "c53.q2",   0x200000, 0x200000, CRC(1a3e5c03) SHA1(c5a556e125d6c3d68da745b4d56cd7a851f2a23d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "vampj.key",    0x00, 0x14, CRC(8418cc6f) SHA1(e7128ac94fc7c37a64e4640db08f1769215769e5) )
ROM_END

 /***************
 Armored Warriors
******************/

ROM_START( armwars01 ) //armwar1d
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c55s01.p1", 0x000000, 0x80000, CRC(f4642738) SHA1(91fab6578dad8dba57e964a56be782d936b03663) )
	ROM_LOAD16_WORD_SWAP( "c55r1d.p2", 0x080000, 0x80000, CRC(9bd6a38f) SHA1(da90162b7bff223df59ac362a5f61c580a86d967) )
	ROM_LOAD16_WORD_SWAP( "c55r1d.p3", 0x100000, 0x80000, CRC(4c11d30f) SHA1(463ba1845b1239c839e9419cbc6762d52b7918db) )
	ROM_LOAD16_WORD_SWAP( "c55.p4",   0x180000, 0x80000, CRC(87a60ce8) SHA1(e2085c7c8c6792d055dbbb023c7f4e4aa38ae924) )
	ROM_LOAD16_WORD_SWAP( "c55.p5",   0x200000, 0x80000, CRC(f7b148df) SHA1(f369669713cf647222094c570a2eacd48a8637cf) )
	ROM_LOAD16_WORD_SWAP( "c55.p6",   0x280000, 0x80000, CRC(cc62823e) SHA1(edaf9bebdfc65ae5414090abd6844176eec39a00) )
	ROM_LOAD16_WORD_SWAP( "c55u1.p7", 0x300000, 0x80000, CRC(ddc85ca6) SHA1(e794c679531632e2142c6a5e3b858494389ce65e) )
	ROM_LOAD16_WORD_SWAP( "c55.p8",   0x380000, 0x80000, CRC(07c4fb28) SHA1(58a1ff3d105be7df833dd4f32973766649efcbcf) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c55.c1",   0x0000000, 0x400000, CRC(ae8fe08e) SHA1(b6f09663dcda69b5d7ac13e4afaf1efd692fb61e) )
	ROM_LOAD64_WORD( "c55.c2",   0x0000002, 0x400000, CRC(db560f58) SHA1(0c3716b32eb24544ff5d16b5dcadce195cd10d00) )
	ROM_LOAD64_WORD( "c55.c3",   0x0000004, 0x400000, CRC(bc475b94) SHA1(a157664450895a146a532581dd6f4b63dff21c86) )
	ROM_LOAD64_WORD( "c55.c4",   0x0000006, 0x400000, CRC(07439ff7) SHA1(f71e07c6d77c32828f5e319268b24b13a1a4b0c2) )
	ROM_LOAD64_WORD( "c55.c5",   0x1000000, 0x100000, CRC(c3f9ba63) SHA1(66191a52c39daa89b17ede5804ee41c028036f14) )
	ROM_LOAD64_WORD( "c55.c6",   0x1000002, 0x100000, CRC(815b0e7b) SHA1(549785daac3122253fb94f6541bc7016147f5306) )
	ROM_LOAD64_WORD( "c55.c7",   0x1000004, 0x100000, CRC(0109c71b) SHA1(eb51284ee0c85ff8f605fe1d166b7aa202be1344) )
	ROM_LOAD64_WORD( "c55.c8",   0x1000006, 0x100000, CRC(eb75ffbe) SHA1(e9d1deca60be696ac5bff2017fb5de3525e5239a) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c55.m1",   0x00000, 0x08000, CRC(18a5c0e4) SHA1(bb1353dd74884aaeec9b5f1d0b284d9cad53c0ff) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c55.m2",   0x28000, 0x20000, CRC(c9dfffa6) SHA1(64e71028befe9a2514074be765dd020e1d2ea70b) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c55.q1",   0x000000, 0x200000, CRC(a78f7433) SHA1(e47ffba7b9dac9d0dda985c5d966194be18260f7) )
	ROM_LOAD16_WORD_SWAP( "c55.q2",   0x200000, 0x200000, CRC(77438ed0) SHA1(733ca6c6a792e66e2aa12c5fc06dd459527afe4b) )
ROM_END

ROM_START( armwars02 ) //armwarr1
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c55s02.p1", 0x000000, 0x80000, CRC(4a836a40) SHA1(d6588cd1cc702939a567459d5eb3406e2ca87b29) )
	ROM_LOAD16_WORD_SWAP( "c55r1.p2", 0x080000, 0x80000, CRC(4f89de39) SHA1(1e54ed70a6ed9330ec83fb189f76e9417c6dfc13) )
	ROM_LOAD16_WORD_SWAP( "c55r1.p3", 0x100000, 0x80000, CRC(83df24e5) SHA1(39801452769569c3271b26c6be8d3ce5e72b0629) )
	ROM_LOAD16_WORD_SWAP( "c55.p4",   0x180000, 0x80000, CRC(87a60ce8) SHA1(e2085c7c8c6792d055dbbb023c7f4e4aa38ae924) )
	ROM_LOAD16_WORD_SWAP( "c55.p5",   0x200000, 0x80000, CRC(f7b148df) SHA1(f369669713cf647222094c570a2eacd48a8637cf) )
	ROM_LOAD16_WORD_SWAP( "c55.p6",   0x280000, 0x80000, CRC(cc62823e) SHA1(edaf9bebdfc65ae5414090abd6844176eec39a00) )
	ROM_LOAD16_WORD_SWAP( "c55u1.p7", 0x300000, 0x80000, CRC(ddc85ca6) SHA1(e794c679531632e2142c6a5e3b858494389ce65e) )
	ROM_LOAD16_WORD_SWAP( "c55.p8",   0x380000, 0x80000, CRC(07c4fb28) SHA1(58a1ff3d105be7df833dd4f32973766649efcbcf) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c55.c1",   0x0000000, 0x400000, CRC(ae8fe08e) SHA1(b6f09663dcda69b5d7ac13e4afaf1efd692fb61e) )
	ROM_LOAD64_WORD( "c55.c2",   0x0000002, 0x400000, CRC(db560f58) SHA1(0c3716b32eb24544ff5d16b5dcadce195cd10d00) )
	ROM_LOAD64_WORD( "c55.c3",   0x0000004, 0x400000, CRC(bc475b94) SHA1(a157664450895a146a532581dd6f4b63dff21c86) )
	ROM_LOAD64_WORD( "c55.c4",   0x0000006, 0x400000, CRC(07439ff7) SHA1(f71e07c6d77c32828f5e319268b24b13a1a4b0c2) )
	ROM_LOAD64_WORD( "c55.c5",   0x1000000, 0x100000, CRC(c3f9ba63) SHA1(66191a52c39daa89b17ede5804ee41c028036f14) )
	ROM_LOAD64_WORD( "c55.c6",   0x1000002, 0x100000, CRC(815b0e7b) SHA1(549785daac3122253fb94f6541bc7016147f5306) )
	ROM_LOAD64_WORD( "c55.c7",   0x1000004, 0x100000, CRC(0109c71b) SHA1(eb51284ee0c85ff8f605fe1d166b7aa202be1344) )
	ROM_LOAD64_WORD( "c55.c8",   0x1000006, 0x100000, CRC(eb75ffbe) SHA1(e9d1deca60be696ac5bff2017fb5de3525e5239a) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c55.m1",   0x00000, 0x08000, CRC(18a5c0e4) SHA1(bb1353dd74884aaeec9b5f1d0b284d9cad53c0ff) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c55.m2",   0x28000, 0x20000, CRC(c9dfffa6) SHA1(64e71028befe9a2514074be765dd020e1d2ea70b) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c55.q1",   0x000000, 0x200000, CRC(a78f7433) SHA1(e47ffba7b9dac9d0dda985c5d966194be18260f7) )
	ROM_LOAD16_WORD_SWAP( "c55.q2",   0x200000, 0x200000, CRC(77438ed0) SHA1(733ca6c6a792e66e2aa12c5fc06dd459527afe4b) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "armwar.key",   0x00, 0x14, CRC(fe979382) SHA1(ec4e0b24d6de9660221e63063fba04df48682e1a) )
ROM_END

/**************************
 X-Men Children of the Atom
*****************************/
ROM_START( xmcotas01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c56s01.p1", 0x000000, 0x80000, CRC(bd2f0b84) SHA1(2b5c6deb2bb7e10a142a490781231d2ccfceee1c) )
	ROM_LOAD16_WORD_SWAP( "c56s01.p2", 0x080000, 0x80000, CRC(5de40342) SHA1(c5ba56560155197232869f4f8dbfbfde46daf081) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p3",   0x100000, 0x80000, CRC(c3ed62a2) SHA1(4e3317d7ca981e33318822103a16e59f4ce20deb) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p4",   0x180000, 0x80000, CRC(f03c52e1) SHA1(904b2312ee594f5ece0484cad0eed25cc758185e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p5",   0x200000, 0x80000, CRC(325626b1) SHA1(3f3a0aabbe5ffad8136ac91e0de785103b16059b) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p6",   0x280000, 0x80000, CRC(7194ea10) SHA1(40a5892d816f24cbfd4c310792eeabf689c6fa7e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p7",   0x300000, 0x80000, CRC(ae946df3) SHA1(733671f76d766bda7110df9d338791cc5202b050) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p8",   0x380000, 0x80000, CRC(32a6be1d) SHA1(8f5fcb33b528abed670b4fc3fa62431a6e033c56) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c56.c1",   0x0000000, 0x400000, CRC(bf4df073) SHA1(4d2740c3a827f0ec2cf75ad99c65e393c6a11c23) )
	ROM_LOAD64_WORD( "c56.c2",   0x0000002, 0x400000, CRC(4d7e4cef) SHA1(50b8797b8099a8d76ad063ba1201a13dbb88ae3a) )
	ROM_LOAD64_WORD( "c56.c3",   0x0000004, 0x400000, CRC(513eea17) SHA1(a497477ad9ac13180911d8745ef6ee1955c0b877) )
	ROM_LOAD64_WORD( "c56.c4",   0x0000006, 0x400000, CRC(d23897fc) SHA1(1e31627999736652252164d32662779a1ac6ca29) )
	ROM_LOAD64_WORD( "c56.c5",   0x1000000, 0x400000, CRC(778237b7) SHA1(89a759ec383518ec52f5059d10ec342f2247aa20) )
	ROM_LOAD64_WORD( "c56.c6",   0x1000002, 0x400000, CRC(67b36948) SHA1(692fb6e4096b880aa22996d554b160f664bbd907) )
	ROM_LOAD64_WORD( "c56.c7",   0x1000004, 0x400000, CRC(015a7c4c) SHA1(cccc95dafd076a1a9fa004710006149c42d058ba) )
	ROM_LOAD64_WORD( "c56.c8",   0x1000006, 0x400000, CRC(9dde2758) SHA1(17ba259cad03c7b5d56c0a5eda9ab53521665729) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c56.m1",  0x00000, 0x08000, CRC(40f479ea) SHA1(f29e15f537675305264ae2138a0a537fb9e2008b) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c56.m2",  0x28000, 0x20000, CRC(39d9b5ad) SHA1(af502debfd36100d4fc971ed25fdf9d7121d6f18) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c56.q1",   0x000000, 0x200000, CRC(c848a6bc) SHA1(ac8ac564d3c43225822f8bc330eba9f35b24b0a4) )
	ROM_LOAD16_WORD_SWAP( "c56.q2",   0x200000, 0x200000, CRC(729c188f) SHA1(3279774ad8aebbcf0fc779cdfcbe21044dd192ad) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmcotaj.key",  0x00, 0x14, CRC(d278b4ac) SHA1(06d94e8a203172792f405c73f9cbb37f4738429f) )
ROM_END

ROM_START( xmcotas02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c56s02.p1", 0x000000, 0x80000, CRC(e52f9f70) SHA1(a0e33506e5b95f8a4b37d6be2d4d47a0ef8c5206) )
	ROM_LOAD16_WORD_SWAP( "c56s01.p2", 0x080000, 0x80000, CRC(5de40342) SHA1(c5ba56560155197232869f4f8dbfbfde46daf081) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p3",   0x100000, 0x80000, CRC(c3ed62a2) SHA1(4e3317d7ca981e33318822103a16e59f4ce20deb) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p4",   0x180000, 0x80000, CRC(f03c52e1) SHA1(904b2312ee594f5ece0484cad0eed25cc758185e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p5",   0x200000, 0x80000, CRC(325626b1) SHA1(3f3a0aabbe5ffad8136ac91e0de785103b16059b) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p6",   0x280000, 0x80000, CRC(7194ea10) SHA1(40a5892d816f24cbfd4c310792eeabf689c6fa7e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p7",   0x300000, 0x80000, CRC(ae946df3) SHA1(733671f76d766bda7110df9d338791cc5202b050) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p8",   0x380000, 0x80000, CRC(32a6be1d) SHA1(8f5fcb33b528abed670b4fc3fa62431a6e033c56) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c56.c1",   0x0000000, 0x400000, CRC(bf4df073) SHA1(4d2740c3a827f0ec2cf75ad99c65e393c6a11c23) )
	ROM_LOAD64_WORD( "c56.c2",   0x0000002, 0x400000, CRC(4d7e4cef) SHA1(50b8797b8099a8d76ad063ba1201a13dbb88ae3a) )
	ROM_LOAD64_WORD( "c56.c3",   0x0000004, 0x400000, CRC(513eea17) SHA1(a497477ad9ac13180911d8745ef6ee1955c0b877) )
	ROM_LOAD64_WORD( "c56.c4",   0x0000006, 0x400000, CRC(d23897fc) SHA1(1e31627999736652252164d32662779a1ac6ca29) )
	ROM_LOAD64_WORD( "c56.c5",   0x1000000, 0x400000, CRC(778237b7) SHA1(89a759ec383518ec52f5059d10ec342f2247aa20) )
	ROM_LOAD64_WORD( "c56.c6",   0x1000002, 0x400000, CRC(67b36948) SHA1(692fb6e4096b880aa22996d554b160f664bbd907) )
	ROM_LOAD64_WORD( "c56.c7",   0x1000004, 0x400000, CRC(015a7c4c) SHA1(cccc95dafd076a1a9fa004710006149c42d058ba) )
	ROM_LOAD64_WORD( "c56.c8",   0x1000006, 0x400000, CRC(9dde2758) SHA1(17ba259cad03c7b5d56c0a5eda9ab53521665729) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c56.m1",  0x00000, 0x08000, CRC(40f479ea) SHA1(f29e15f537675305264ae2138a0a537fb9e2008b) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c56.m2",  0x28000, 0x20000, CRC(39d9b5ad) SHA1(af502debfd36100d4fc971ed25fdf9d7121d6f18) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c56.q1",   0x000000, 0x200000, CRC(c848a6bc) SHA1(ac8ac564d3c43225822f8bc330eba9f35b24b0a4) )
	ROM_LOAD16_WORD_SWAP( "c56.q2",   0x200000, 0x200000, CRC(729c188f) SHA1(3279774ad8aebbcf0fc779cdfcbe21044dd192ad) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmcotaj.key",  0x00, 0x14, CRC(d278b4ac) SHA1(06d94e8a203172792f405c73f9cbb37f4738429f) )
ROM_END

ROM_START( xmcotas03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c56s01.p1", 0x000000, 0x80000, CRC(bd2f0b84) SHA1(2b5c6deb2bb7e10a142a490781231d2ccfceee1c) )
	ROM_LOAD16_WORD_SWAP( "c56j2.p2",   0x080000, 0x80000, CRC(54b3fba3) SHA1(47eaff5d36a45e4196f87ed3d02e54d5407e7962) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p3",   0x100000, 0x80000, CRC(c3ed62a2) SHA1(4e3317d7ca981e33318822103a16e59f4ce20deb) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p4",   0x180000, 0x80000, CRC(f03c52e1) SHA1(904b2312ee594f5ece0484cad0eed25cc758185e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p5",   0x200000, 0x80000, CRC(325626b1) SHA1(3f3a0aabbe5ffad8136ac91e0de785103b16059b) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p6",   0x280000, 0x80000, CRC(7194ea10) SHA1(40a5892d816f24cbfd4c310792eeabf689c6fa7e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p7",   0x300000, 0x80000, CRC(ae946df3) SHA1(733671f76d766bda7110df9d338791cc5202b050) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p8",   0x380000, 0x80000, CRC(32a6be1d) SHA1(8f5fcb33b528abed670b4fc3fa62431a6e033c56) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c56.c1",   0x0000000, 0x400000, CRC(bf4df073) SHA1(4d2740c3a827f0ec2cf75ad99c65e393c6a11c23) )
	ROM_LOAD64_WORD( "c56.c2",   0x0000002, 0x400000, CRC(4d7e4cef) SHA1(50b8797b8099a8d76ad063ba1201a13dbb88ae3a) )
	ROM_LOAD64_WORD( "c56.c3",   0x0000004, 0x400000, CRC(513eea17) SHA1(a497477ad9ac13180911d8745ef6ee1955c0b877) )
	ROM_LOAD64_WORD( "c56.c4",   0x0000006, 0x400000, CRC(d23897fc) SHA1(1e31627999736652252164d32662779a1ac6ca29) )
	ROM_LOAD64_WORD( "c56.c5",   0x1000000, 0x400000, CRC(778237b7) SHA1(89a759ec383518ec52f5059d10ec342f2247aa20) )
	ROM_LOAD64_WORD( "c56.c6",   0x1000002, 0x400000, CRC(67b36948) SHA1(692fb6e4096b880aa22996d554b160f664bbd907) )
	ROM_LOAD64_WORD( "c56.c7",   0x1000004, 0x400000, CRC(015a7c4c) SHA1(cccc95dafd076a1a9fa004710006149c42d058ba) )
	ROM_LOAD64_WORD( "c56.c8",   0x1000006, 0x400000, CRC(9dde2758) SHA1(17ba259cad03c7b5d56c0a5eda9ab53521665729) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c56.m1",  0x00000, 0x08000, CRC(40f479ea) SHA1(f29e15f537675305264ae2138a0a537fb9e2008b) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c56.m2",  0x28000, 0x20000, CRC(39d9b5ad) SHA1(af502debfd36100d4fc971ed25fdf9d7121d6f18) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c56.q1",   0x000000, 0x200000, CRC(c848a6bc) SHA1(ac8ac564d3c43225822f8bc330eba9f35b24b0a4) )
	ROM_LOAD16_WORD_SWAP( "c56.q2",   0x200000, 0x200000, CRC(729c188f) SHA1(3279774ad8aebbcf0fc779cdfcbe21044dd192ad) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmcotaj.key",  0x00, 0x14, CRC(d278b4ac) SHA1(06d94e8a203172792f405c73f9cbb37f4738429f) )
ROM_END

ROM_START( xmcotas04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c56s04.p1", 0x000000, 0x80000, CRC(654c6b83) SHA1(b61d8891edb105ad72a76ee0c1018bc5edc64b6c) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p2",   0x080000, 0x80000, CRC(38eed613) SHA1(86ecb58bf03adda705a39a9779862fe2c85cadad) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p3",   0x100000, 0x80000, CRC(c3ed62a2) SHA1(4e3317d7ca981e33318822103a16e59f4ce20deb) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p4",   0x180000, 0x80000, CRC(f03c52e1) SHA1(904b2312ee594f5ece0484cad0eed25cc758185e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p5",   0x200000, 0x80000, CRC(325626b1) SHA1(3f3a0aabbe5ffad8136ac91e0de785103b16059b) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p6",   0x280000, 0x80000, CRC(7194ea10) SHA1(40a5892d816f24cbfd4c310792eeabf689c6fa7e) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p7",   0x300000, 0x80000, CRC(ae946df3) SHA1(733671f76d766bda7110df9d338791cc5202b050) )
	ROM_LOAD16_WORD_SWAP( "c56j1.p8",   0x380000, 0x80000, CRC(32a6be1d) SHA1(8f5fcb33b528abed670b4fc3fa62431a6e033c56) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c56.c1",   0x0000000, 0x400000, CRC(bf4df073) SHA1(4d2740c3a827f0ec2cf75ad99c65e393c6a11c23) )
	ROM_LOAD64_WORD( "c56.c2",   0x0000002, 0x400000, CRC(4d7e4cef) SHA1(50b8797b8099a8d76ad063ba1201a13dbb88ae3a) )
	ROM_LOAD64_WORD( "c56.c3",   0x0000004, 0x400000, CRC(513eea17) SHA1(a497477ad9ac13180911d8745ef6ee1955c0b877) )
	ROM_LOAD64_WORD( "c56.c4",   0x0000006, 0x400000, CRC(d23897fc) SHA1(1e31627999736652252164d32662779a1ac6ca29) )
	ROM_LOAD64_WORD( "c56.c5",   0x1000000, 0x400000, CRC(778237b7) SHA1(89a759ec383518ec52f5059d10ec342f2247aa20) )
	ROM_LOAD64_WORD( "c56.c6",   0x1000002, 0x400000, CRC(67b36948) SHA1(692fb6e4096b880aa22996d554b160f664bbd907) )
	ROM_LOAD64_WORD( "c56.c7",   0x1000004, 0x400000, CRC(015a7c4c) SHA1(cccc95dafd076a1a9fa004710006149c42d058ba) )
	ROM_LOAD64_WORD( "c56.c8",   0x1000006, 0x400000, CRC(9dde2758) SHA1(17ba259cad03c7b5d56c0a5eda9ab53521665729) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c56.m1",  0x00000, 0x08000, CRC(40f479ea) SHA1(f29e15f537675305264ae2138a0a537fb9e2008b) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c56.m2",  0x28000, 0x20000, CRC(39d9b5ad) SHA1(af502debfd36100d4fc971ed25fdf9d7121d6f18) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c56.q1",   0x000000, 0x200000, CRC(c848a6bc) SHA1(ac8ac564d3c43225822f8bc330eba9f35b24b0a4) )
	ROM_LOAD16_WORD_SWAP( "c56.q2",   0x200000, 0x200000, CRC(729c188f) SHA1(3279774ad8aebbcf0fc779cdfcbe21044dd192ad) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmcotaj.key",  0x00, 0x14, CRC(d278b4ac) SHA1(06d94e8a203172792f405c73f9cbb37f4738429f) )
ROM_END

 /***************************
 Cyberbots Fullmetal Madness
******************************/

ROM_START( cybots01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c58s01.p1", 0x000000, 0x80000, CRC(a4fa00db) SHA1(fec6a17933fede227c3ac06b327837c6d5009070) )
	ROM_LOAD16_WORD_SWAP( "c58j.p2", 0x080000, 0x80000, CRC(7b0ffaa9) SHA1(595c3e679ea02282bf8a5aa6c7c09e5c30e839c7) )
	ROM_LOAD16_WORD_SWAP( "c58.p3",  0x100000, 0x80000, CRC(ec40408e) SHA1(dd611c1708e7ef86e4f7cac4b7b0dff7baaee5ed) )
	ROM_LOAD16_WORD_SWAP( "c58.p4",  0x180000, 0x80000, CRC(1ad0bed2) SHA1(2ea005f3e73b05f8f0ec006cd9e95f7731a73897) )
	ROM_LOAD16_WORD_SWAP( "c58.p5",  0x200000, 0x80000, CRC(6245a39a) SHA1(4f607e733e2dea80211497522be6d0f09571928d) )
	ROM_LOAD16_WORD_SWAP( "c58.p6",  0x280000, 0x80000, CRC(4b48e223) SHA1(9714579a7a78b9716e44bca6c18bf1a93aa4e482) )
	ROM_LOAD16_WORD_SWAP( "c58.p7",  0x300000, 0x80000, CRC(e15238f6) SHA1(16abd92ebed921a6a7e8eac4b098dc61f7e5485c) )
	ROM_LOAD16_WORD_SWAP( "c58.p8",  0x380000, 0x80000, CRC(75f4003b) SHA1(8a65026ae35247cda016ce85a34034c62b3aa1a6) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c58.c1",   0x0000000, 0x400000, CRC(f0dce192) SHA1(b743938dc8e772dc3f63ed88a4a54c34fffdba21) )
	ROM_LOAD64_WORD( "c58.c2",   0x0000002, 0x400000, CRC(187aa39c) SHA1(80e3cf5c69f13343de667e1476bb716d45d3ff63) )
	ROM_LOAD64_WORD( "c58.c3",   0x0000004, 0x400000, CRC(8a0e4b12) SHA1(40132f3cc79b0a74460ebd4e0d4ddbe240efc06f) )
	ROM_LOAD64_WORD( "c58.c4",   0x0000006, 0x400000, CRC(34b62612) SHA1(154bbceb7d303a208abb1b2f3d507d5afacc71ed) )
	ROM_LOAD64_WORD( "c58.c5",   0x1000000, 0x400000, CRC(c1537957) SHA1(bfb1cc6786277b94ce28bfd464e2bbb6f6d3486e) )
	ROM_LOAD64_WORD( "c58.c6",   0x1000002, 0x400000, CRC(15349e86) SHA1(b0cde577d29a9f4e718b673c8645529ef0ababc9) )
	ROM_LOAD64_WORD( "c58.c7",   0x1000004, 0x400000, CRC(d83e977d) SHA1(e03f4a120c95a2f476ffc8492bca85e0c5cea068) )
	ROM_LOAD64_WORD( "c58.c8",   0x1000006, 0x400000, CRC(77cdad5c) SHA1(94d0cc5f05de4bc2d43977d91f887005dc10310c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c58.m1",   0x00000, 0x08000, CRC(9c0fb079) SHA1(06d260875a76da08d56ea2b2ae277e8c2dbae6e3) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c58.m2",   0x28000, 0x20000, CRC(51cb0c4e) SHA1(c322957558d8d3e9dad090aebbe485978cbce8f5) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c58.q1",   0x000000, 0x200000, CRC(362ccab2) SHA1(28e537067d4846f22657ee37166d18b8f05f4da1) )
	ROM_LOAD16_WORD_SWAP( "c58.q2",   0x200000, 0x200000, CRC(7066e9cc) SHA1(eb6a9d4998b3311344d73bae88d661d81609c492) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "cybotsj.key",  0x00, 0x14, CRC(d4d560b7) SHA1(66f2d85a25140ab9071a0e192ee40e750381bffc) )
ROM_END

ROM_START( cybots02 ) // cybotsam - see https://archive.org/details/cybotsAM for instructions.
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c58s02.p1",  0x000000, 0x80000, CRC(52e1a8a4) SHA1(859137e41f60f9ca79bdace395847a93d335562b) )
	ROM_LOAD16_WORD_SWAP( "c58s02.p2",  0x080000, 0x80000, CRC(627be72a) SHA1(43d16f8bcbbdfd02535eaf6dadb2e30b2df33ed8) )
	ROM_LOAD16_WORD_SWAP( "c58.p3",  0x100000, 0x80000, CRC(ec40408e) SHA1(dd611c1708e7ef86e4f7cac4b7b0dff7baaee5ed) )
	ROM_LOAD16_WORD_SWAP( "c58.p4",  0x180000, 0x80000, CRC(1ad0bed2) SHA1(2ea005f3e73b05f8f0ec006cd9e95f7731a73897) )
	ROM_LOAD16_WORD_SWAP( "c58.p5",  0x200000, 0x80000, CRC(6245a39a) SHA1(4f607e733e2dea80211497522be6d0f09571928d) )
	ROM_LOAD16_WORD_SWAP( "c58.p6",  0x280000, 0x80000, CRC(4b48e223) SHA1(9714579a7a78b9716e44bca6c18bf1a93aa4e482) )
	ROM_LOAD16_WORD_SWAP( "c58.p7",  0x300000, 0x80000, CRC(e15238f6) SHA1(16abd92ebed921a6a7e8eac4b098dc61f7e5485c) )
	ROM_LOAD16_WORD_SWAP( "c58s02.p8",  0x380000, 0x80000, CRC(bbfd041e) SHA1(240f6705ecc93c6df5cfe380a060a088ad5861f3) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c58.c1",   0x0000000, 0x400000, CRC(f0dce192) SHA1(b743938dc8e772dc3f63ed88a4a54c34fffdba21) )
	ROM_LOAD64_WORD( "c58.c2",   0x0000002, 0x400000, CRC(187aa39c) SHA1(80e3cf5c69f13343de667e1476bb716d45d3ff63) )
	ROM_LOAD64_WORD( "c58.c3",   0x0000004, 0x400000, CRC(8a0e4b12) SHA1(40132f3cc79b0a74460ebd4e0d4ddbe240efc06f) )
	ROM_LOAD64_WORD( "c58.c4",   0x0000006, 0x400000, CRC(34b62612) SHA1(154bbceb7d303a208abb1b2f3d507d5afacc71ed) )
	ROM_LOAD64_WORD( "c58.c5",   0x1000000, 0x400000, CRC(c1537957) SHA1(bfb1cc6786277b94ce28bfd464e2bbb6f6d3486e) )
	ROM_LOAD64_WORD( "c58.c6",   0x1000002, 0x400000, CRC(15349e86) SHA1(b0cde577d29a9f4e718b673c8645529ef0ababc9) )
	ROM_LOAD64_WORD( "c58.c7",   0x1000004, 0x400000, CRC(d83e977d) SHA1(e03f4a120c95a2f476ffc8492bca85e0c5cea068) )
	ROM_LOAD64_WORD( "c58.c8",   0x1000006, 0x400000, CRC(77cdad5c) SHA1(94d0cc5f05de4bc2d43977d91f887005dc10310c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c58.m1",   0x00000, 0x08000, CRC(9c0fb079) SHA1(06d260875a76da08d56ea2b2ae277e8c2dbae6e3) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c58.m2",   0x28000, 0x20000, CRC(51cb0c4e) SHA1(c322957558d8d3e9dad090aebbe485978cbce8f5) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c58.q1",   0x000000, 0x200000, CRC(362ccab2) SHA1(28e537067d4846f22657ee37166d18b8f05f4da1) )
	ROM_LOAD16_WORD_SWAP( "c58.q2",   0x200000, 0x200000, CRC(7066e9cc) SHA1(eb6a9d4998b3311344d73bae88d661d81609c492) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "cybots.key",   0x00, 0x14, CRC(9bbcbef3) SHA1(ec7a322c8dceb16c98f7c2837679e91b738fdd0a) )
ROM_END

 /**************************************
 Street Fighter Alpha: Warriors' Dreams
*****************************************/
ROM_START( sfas01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s01.p1", 0x000000, 0x80000, CRC(14986b54) SHA1(506694488a126c6d3479c0982b36e9f61c0593f6) )
	ROM_LOAD16_WORD_SWAP( "c59r1.p2", 0x080000, 0x80000, CRC(bb90acd5) SHA1(a19795963b90f1152f44cae29e78dd2ce67a41d6) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59s01.p4", 0x180000, 0x80000, CRC(b6c4fec7) SHA1(602c9acb8034219334df05ff4d5dc67514823182) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa.key",      0x00, 0x14, CRC(7c095631) SHA1(aa54369b385435991ae884801228427a0d07cfc7) )
ROM_END

ROM_START( sfas02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s02.p1", 0x000000, 0x80000, CRC(5b02325d) SHA1(6b66a96fe8a51dba65b5f369ccd07428bdece3ef) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa.key",      0x00, 0x14, CRC(7c095631) SHA1(aa54369b385435991ae884801228427a0d07cfc7) )
ROM_END

ROM_START( sfas03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s03.p1", 0x000000, 0x80000, CRC(b67268ef) SHA1(b53802a3ba3ee6c14c01ab54c518dad84148708c) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa.key",      0x00, 0x14, CRC(7c095631) SHA1(aa54369b385435991ae884801228427a0d07cfc7) )
ROM_END

ROM_START( sfas04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s04.p1", 0x000000, 0x80000, CRC(2ebec801) SHA1(5070d307a3ee66d9dfcf754677c086358a87c8c4) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa.key",      0x00, 0x14, CRC(7c095631) SHA1(aa54369b385435991ae884801228427a0d07cfc7) )
ROM_END

ROM_START( sfas05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s05.p1", 0x000000, 0x80000, CRC(4d84ed39) SHA1(5b572b889f42599862e3ce88211398532d0219b5) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa.key",      0x00, 0x14, CRC(7c095631) SHA1(aa54369b385435991ae884801228427a0d07cfc7) )
ROM_END

ROM_START( sfas06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59s06.p1", 0x000000, 0x80000, CRC(9f2ff577) SHA1(e78d7e8e0a5703dea09aed2ac4055d45844cead5) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",   0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",   0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",   0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",   0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",  0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",  0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )
ROM_END

 /*******************
 Street Fighter Zero
**********************/
ROM_START( sfzj01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j01.p1", 0x000000, 0x80000, CRC(c5862434) SHA1(08d486733857f6fb5822681141d009b175c957db) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j02.p1", 0x000000, 0x80000, CRC(0b4ff85a) SHA1(86b9b25310d77846e8c66fa086f2de3d3bc12173) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j03.p1", 0x000000, 0x80000, CRC(d5739c17) SHA1(9d8228a03a11a18d256ed79488ef53e5ede35bc9) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j04.p1", 0x000000, 0x80000, CRC(d1e162ba) SHA1(f603e424f273f2ba0cf2f88ce0d0e0ab91bbe02e) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j05.p1", 0x000000, 0x80000, CRC(e37ed2c7) SHA1(d5cca0476edf419d28606c3af62c511a531c40c0) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j06.p1", 0x000000, 0x80000, CRC(6b0366bf) SHA1(6138f48027beaba73cc744ffc75589fe26ec1339) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",   0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",   0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59j06.p4", 0x180000, 0x80000, CRC(e7bb5d20) SHA1(0f2e4516ba93f02e6869b182d225718e845d1093) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzj07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59j07.p1", 0x000000, 0x80000, CRC(0a2e2f39) SHA1(654e05c1598ec932de03fd1ff8b9fa66ec4ceb60) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",     0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",     0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59s01.p4", 0x180000, 0x80000, CRC(b6c4fec7) SHA1(602c9acb8034219334df05ff4d5dc67514823182) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59.c1",  0x800000, 0x200000, CRC(90fefdb3) SHA1(5eb28c8de57acfeaefebdd01509c7d9ba5244705) )
	ROM_LOAD64_WORD( "c59.c2",  0x800002, 0x200000, CRC(5354c948) SHA1(07588f1ba6addc04fef3274c971174aaf3e632ab) )
	ROM_LOAD64_WORD( "c59.c3",  0x800004, 0x200000, CRC(41a1e790) SHA1(ce25dad542308691dbe9606b26279bbd59ea4b81) )
	ROM_LOAD64_WORD( "c59.c4",  0x800006, 0x200000, CRC(a549df98) SHA1(f054e95df650a891ef56da8bfb31cb2c945a9aed) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

ROM_START( sfzk )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c59k.p1", 0x000000, 0x80000, CRC(ff9f72cc) SHA1(2b79b5833bb9c6396398a336d6e9385fb6af57c4) )
	ROM_LOAD16_WORD_SWAP( "c59.p2",  0x080000, 0x80000, CRC(8b73b0e5) SHA1(5318761f615c21395366b5333e75eaaa73ef2073) )
	ROM_LOAD16_WORD_SWAP( "c59.p3",  0x100000, 0x80000, CRC(0810544d) SHA1(5f39bda3e7b16508eb58e5a2e0cc58c09cf428ce) )
	ROM_LOAD16_WORD_SWAP( "c59.p4",   0x180000, 0x80000, CRC(806e8f38) SHA1(b6d6912aa8f2f590335d7ff9a8214648e7131ebb) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c59k.c1",  0x800000, 0x200000, CRC(2abed9af) SHA1(0996e70f3f6b4aac894aa0ef5a637b06ce6571bf) )
	ROM_LOAD64_WORD( "c59k.c2",  0x800002, 0x200000, CRC(e30c4e37) SHA1(e999e7ac3b85a3cff2332f24faba748683962e7d) )
	ROM_LOAD64_WORD( "c59k.c3",  0x800004, 0x200000, CRC(a5a760b9) SHA1(60940a5057ce3afd2135b08643049532b92fca45) )
	ROM_LOAD64_WORD( "c59k.c4",  0x800006, 0x200000, CRC(c72b7c2d) SHA1(7342fea8e32b39d262f2f4b81f2ba54c1de1ada1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c59.m1",   0x00000, 0x08000, CRC(ffffec7d) SHA1(75b4aef001b72a0f571b51b2b97803facc1832dd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c59.m2",   0x28000, 0x20000, CRC(45f46a08) SHA1(e32dbd27b52ab708278045b5a829376e55a4ca81) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c59.q1",   0x000000, 0x200000, CRC(c4b093cd) SHA1(256526bb693a0b72443f047e060304c9b739acd1) )
	ROM_LOAD16_WORD_SWAP( "c59.q2",   0x200000, 0x200000, CRC(8bdbc4b4) SHA1(0e21c9a75a17a7e7dfd8bb51098c2b9dc4c933ec) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfzj.key",     0x00, 0x14, CRC(355d85b8) SHA1(5da2c407852ce7b28153f3f94de8328802ff2f2d) )
ROM_END

 /*******************
 Marvel Super Heroes
**********************/
ROM_START( mshs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c61s01.p1", 0x000000, 0x80000, CRC(31ae1efc) SHA1(02d3447edceb07ae4e40b068d8a5637547cbc17e) )
	ROM_LOAD16_WORD_SWAP( "c61s01.p2", 0x080000, 0x80000, CRC(d66257ab) SHA1(5d7c4fab12c2e66c0f20f8cd728fdf37120c233b) )
	ROM_LOAD16_WORD_SWAP( "c61j.p3", 0x100000, 0x80000, CRC(f37539e6) SHA1(770febc25ca5615b6c2023727edab3c68b15b2c4) )
	ROM_LOAD16_WORD_SWAP( "c61.p4",  0x180000, 0x80000, CRC(803e3fa4) SHA1(0acdeda65002521bf24130cbf06f9faa1dcef9e5) )
	ROM_LOAD16_WORD_SWAP( "c61.p5",  0x200000, 0x80000, CRC(c45f8e27) SHA1(4d28e0782c31ce56e728ac6ef5edd10437f00637) )
	ROM_LOAD16_WORD_SWAP( "c61.p6",  0x280000, 0x80000, CRC(9ca6f12c) SHA1(26ad682667b983b805e1f577426e5fca8ee3c82b) )
	ROM_LOAD16_WORD_SWAP( "c61.p7",  0x300000, 0x80000, CRC(82ec27af) SHA1(caf76268063ba91d28e8af684d60c2d71f29b9b9) )
	ROM_LOAD16_WORD_SWAP( "c61.p8",  0x380000, 0x80000, CRC(8d931196) SHA1(983e62efcdb4c8db6bce6acf4f86acb9447b565d) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c61.c1",   0x0000000, 0x400000, CRC(09d14566) SHA1(c96463654043f22da5e844c6da17aa9273dc3439) )
	ROM_LOAD64_WORD( "c61.c2",   0x0000002, 0x400000, CRC(ee962057) SHA1(24e359accb5f71a5863d7bad4088719fa547f88c) )
	ROM_LOAD64_WORD( "c61.c3",   0x0000004, 0x400000, CRC(604ece14) SHA1(880fb62b33ba4cceb38635e4ec056fac11a3c70f) )
	ROM_LOAD64_WORD( "c61.c4",   0x0000006, 0x400000, CRC(94a731e8) SHA1(1e784a3412e7361e3001494e1daf840ef8c20449) )
	ROM_LOAD64_WORD( "c61.c5",   0x1000000, 0x400000, CRC(4197973e) SHA1(93aeea1a480b5f452c8a40ae3fff956796b859fa) )
	ROM_LOAD64_WORD( "c61.c6",   0x1000002, 0x400000, CRC(438da4a0) SHA1(ca93b14c3a570f9dd582efbb3f0536a92e535042) )
	ROM_LOAD64_WORD( "c61.c7",   0x1000004, 0x400000, CRC(4db92d94) SHA1(f1b25ccc0627139ad5b287a8f2ab3b4a2fb8b8e4) )
	ROM_LOAD64_WORD( "c61.c8",   0x1000006, 0x400000, CRC(a2b0c6c0) SHA1(71016c01c1a706b73cf5b9ac7e384a030c6cf08d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c61.m1",   0x00000, 0x08000, CRC(c976e6f9) SHA1(281025e5aaf97c0aeddc8bd0f737d092daadad9e) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c61.m2",   0x28000, 0x20000, CRC(ce67d0d9) SHA1(324226597cc5a11603f04085fef7715a314ecc05) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c61.q1",   0x000000, 0x200000, CRC(37ac6d30) SHA1(ec67421fbf4a08a686e76792cb35e9cbf04d022d) )
	ROM_LOAD16_WORD_SWAP( "c61.q2",   0x200000, 0x200000, CRC(de092570) SHA1(a03d0df901f6ea79685eaed67db65bee14ec29c6) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshj.key",     0x00, 0x14, CRC(888761ac) SHA1(a1c72deedab2bafe5d594bba905a6274575b6e56) )
ROM_END

ROM_START( mshs02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c61s02.p1", 0x000000, 0x80000, CRC(ce707863) SHA1(5e60c0ffdd93d2cad0c29b2d45c36c4e22d73899) )
	ROM_LOAD16_WORD_SWAP( "c61s02.p2", 0x080000, 0x80000, CRC(073dcbe9) SHA1(c216d75f980623075c9cb354b6b83243bd4fcbb4) )
	ROM_IGNORE( 0x3D4F47 )
	ROM_LOAD16_WORD_SWAP( "c61.p3",  0x100000, 0x80000, CRC(6a091b9e) SHA1(7fa54e69e1a1ca348cb08d892d55023e9a3ff4cb) )
	ROM_LOAD16_WORD_SWAP( "c61.p4",  0x180000, 0x80000, CRC(803e3fa4) SHA1(0acdeda65002521bf24130cbf06f9faa1dcef9e5) )
	ROM_LOAD16_WORD_SWAP( "c61.p5",  0x200000, 0x80000, CRC(c45f8e27) SHA1(4d28e0782c31ce56e728ac6ef5edd10437f00637) )
	ROM_LOAD16_WORD_SWAP( "c61.p6",  0x280000, 0x80000, CRC(9ca6f12c) SHA1(26ad682667b983b805e1f577426e5fca8ee3c82b) )
	ROM_LOAD16_WORD_SWAP( "c61.p7",  0x300000, 0x80000, CRC(82ec27af) SHA1(caf76268063ba91d28e8af684d60c2d71f29b9b9) )
	ROM_LOAD16_WORD_SWAP( "c61.p8",  0x380000, 0x80000, CRC(8d931196) SHA1(983e62efcdb4c8db6bce6acf4f86acb9447b565d) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c61.c1",   0x0000000, 0x400000, CRC(09d14566) SHA1(c96463654043f22da5e844c6da17aa9273dc3439) )
	ROM_LOAD64_WORD( "c61.c2",   0x0000002, 0x400000, CRC(ee962057) SHA1(24e359accb5f71a5863d7bad4088719fa547f88c) )
	ROM_LOAD64_WORD( "c61.c3",   0x0000004, 0x400000, CRC(604ece14) SHA1(880fb62b33ba4cceb38635e4ec056fac11a3c70f) )
	ROM_LOAD64_WORD( "c61.c4",   0x0000006, 0x400000, CRC(94a731e8) SHA1(1e784a3412e7361e3001494e1daf840ef8c20449) )
	ROM_LOAD64_WORD( "c61.c5",   0x1000000, 0x400000, CRC(4197973e) SHA1(93aeea1a480b5f452c8a40ae3fff956796b859fa) )
	ROM_LOAD64_WORD( "c61.c6",   0x1000002, 0x400000, CRC(438da4a0) SHA1(ca93b14c3a570f9dd582efbb3f0536a92e535042) )
	ROM_LOAD64_WORD( "c61.c7",   0x1000004, 0x400000, CRC(4db92d94) SHA1(f1b25ccc0627139ad5b287a8f2ab3b4a2fb8b8e4) )
	ROM_LOAD64_WORD( "c61.c8",   0x1000006, 0x400000, CRC(a2b0c6c0) SHA1(71016c01c1a706b73cf5b9ac7e384a030c6cf08d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c61.m1",   0x00000, 0x08000, CRC(c976e6f9) SHA1(281025e5aaf97c0aeddc8bd0f737d092daadad9e) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c61.m2",   0x28000, 0x20000, CRC(ce67d0d9) SHA1(324226597cc5a11603f04085fef7715a314ecc05) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c61.q1",   0x000000, 0x200000, CRC(37ac6d30) SHA1(ec67421fbf4a08a686e76792cb35e9cbf04d022d) )
	ROM_LOAD16_WORD_SWAP( "c61.q2",   0x200000, 0x200000, CRC(de092570) SHA1(a03d0df901f6ea79685eaed67db65bee14ec29c6) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "msh.key",      0x00, 0x14, CRC(b494368e) SHA1(8efc561cec2bcc17902d27ed4e27b7d2b9eccdbc) )
ROM_END

ROM_START( mshs03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c61s01.p1", 0x000000, 0x80000, CRC(31ae1efc) SHA1(02d3447edceb07ae4e40b068d8a5637547cbc17e) )
	ROM_LOAD16_WORD_SWAP( "c61j.p2", 0x080000, 0x80000, CRC(61d791c6) SHA1(9f883bcc48058a99c4ba653d0855c58c5d081243) )
	ROM_LOAD16_WORD_SWAP( "c61j.p3", 0x100000, 0x80000, CRC(f37539e6) SHA1(770febc25ca5615b6c2023727edab3c68b15b2c4) )
	ROM_LOAD16_WORD_SWAP( "c61.p4",  0x180000, 0x80000, CRC(803e3fa4) SHA1(0acdeda65002521bf24130cbf06f9faa1dcef9e5) )
	ROM_LOAD16_WORD_SWAP( "c61.p5",  0x200000, 0x80000, CRC(c45f8e27) SHA1(4d28e0782c31ce56e728ac6ef5edd10437f00637) )
	ROM_LOAD16_WORD_SWAP( "c61.p6",  0x280000, 0x80000, CRC(9ca6f12c) SHA1(26ad682667b983b805e1f577426e5fca8ee3c82b) )
	ROM_LOAD16_WORD_SWAP( "c61.p7",  0x300000, 0x80000, CRC(82ec27af) SHA1(caf76268063ba91d28e8af684d60c2d71f29b9b9) )
	ROM_LOAD16_WORD_SWAP( "c61.p8",  0x380000, 0x80000, CRC(8d931196) SHA1(983e62efcdb4c8db6bce6acf4f86acb9447b565d) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c61.c1",   0x0000000, 0x400000, CRC(09d14566) SHA1(c96463654043f22da5e844c6da17aa9273dc3439) )
	ROM_LOAD64_WORD( "c61.c2",   0x0000002, 0x400000, CRC(ee962057) SHA1(24e359accb5f71a5863d7bad4088719fa547f88c) )
	ROM_LOAD64_WORD( "c61.c3",   0x0000004, 0x400000, CRC(604ece14) SHA1(880fb62b33ba4cceb38635e4ec056fac11a3c70f) )
	ROM_LOAD64_WORD( "c61.c4",   0x0000006, 0x400000, CRC(94a731e8) SHA1(1e784a3412e7361e3001494e1daf840ef8c20449) )
	ROM_LOAD64_WORD( "c61.c5",   0x1000000, 0x400000, CRC(4197973e) SHA1(93aeea1a480b5f452c8a40ae3fff956796b859fa) )
	ROM_LOAD64_WORD( "c61.c6",   0x1000002, 0x400000, CRC(438da4a0) SHA1(ca93b14c3a570f9dd582efbb3f0536a92e535042) )
	ROM_LOAD64_WORD( "c61.c7",   0x1000004, 0x400000, CRC(4db92d94) SHA1(f1b25ccc0627139ad5b287a8f2ab3b4a2fb8b8e4) )
	ROM_LOAD64_WORD( "c61.c8",   0x1000006, 0x400000, CRC(a2b0c6c0) SHA1(71016c01c1a706b73cf5b9ac7e384a030c6cf08d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c61.m1",   0x00000, 0x08000, CRC(c976e6f9) SHA1(281025e5aaf97c0aeddc8bd0f737d092daadad9e) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c61.m2",   0x28000, 0x20000, CRC(ce67d0d9) SHA1(324226597cc5a11603f04085fef7715a314ecc05) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c61.q1",   0x000000, 0x200000, CRC(37ac6d30) SHA1(ec67421fbf4a08a686e76792cb35e9cbf04d022d) )
	ROM_LOAD16_WORD_SWAP( "c61.q2",   0x200000, 0x200000, CRC(de092570) SHA1(a03d0df901f6ea79685eaed67db65bee14ec29c6) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshj.key",     0x00, 0x14, CRC(888761ac) SHA1(a1c72deedab2bafe5d594bba905a6274575b6e56) )
ROM_END

ROM_START( mshs04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c61.p1", 0x000000, 0x80000, CRC(bd951414) SHA1(5585bdd1484dc18c7630d689f60d91c068aafc97) )
	ROM_LOAD16_WORD_SWAP( "c61s04.p2", 0x080000, 0x80000, CRC(adbd5707) SHA1(79d56d5a28328ababec10e080e46d1bfa6d8cab7) )
	ROM_LOAD16_WORD_SWAP( "c61.p3",  0x100000, 0x80000, CRC(6a091b9e) SHA1(7fa54e69e1a1ca348cb08d892d55023e9a3ff4cb) )
	ROM_LOAD16_WORD_SWAP( "c61.p4",  0x180000, 0x80000, CRC(803e3fa4) SHA1(0acdeda65002521bf24130cbf06f9faa1dcef9e5) )
	ROM_LOAD16_WORD_SWAP( "c61.p5",  0x200000, 0x80000, CRC(c45f8e27) SHA1(4d28e0782c31ce56e728ac6ef5edd10437f00637) )
	ROM_LOAD16_WORD_SWAP( "c61.p6",  0x280000, 0x80000, CRC(9ca6f12c) SHA1(26ad682667b983b805e1f577426e5fca8ee3c82b) )
	ROM_LOAD16_WORD_SWAP( "c61.p7",  0x300000, 0x80000, CRC(82ec27af) SHA1(caf76268063ba91d28e8af684d60c2d71f29b9b9) )
	ROM_LOAD16_WORD_SWAP( "c61.p8",  0x380000, 0x80000, CRC(8d931196) SHA1(983e62efcdb4c8db6bce6acf4f86acb9447b565d) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c61.c1",   0x0000000, 0x400000, CRC(09d14566) SHA1(c96463654043f22da5e844c6da17aa9273dc3439) )
	ROM_LOAD64_WORD( "c61.c2",   0x0000002, 0x400000, CRC(ee962057) SHA1(24e359accb5f71a5863d7bad4088719fa547f88c) )
	ROM_LOAD64_WORD( "c61.c3",   0x0000004, 0x400000, CRC(604ece14) SHA1(880fb62b33ba4cceb38635e4ec056fac11a3c70f) )
	ROM_LOAD64_WORD( "c61.c4",   0x0000006, 0x400000, CRC(94a731e8) SHA1(1e784a3412e7361e3001494e1daf840ef8c20449) )
	ROM_LOAD64_WORD( "c61.c5",   0x1000000, 0x400000, CRC(4197973e) SHA1(93aeea1a480b5f452c8a40ae3fff956796b859fa) )
	ROM_LOAD64_WORD( "c61.c6",   0x1000002, 0x400000, CRC(438da4a0) SHA1(ca93b14c3a570f9dd582efbb3f0536a92e535042) )
	ROM_LOAD64_WORD( "c61.c7",   0x1000004, 0x400000, CRC(4db92d94) SHA1(f1b25ccc0627139ad5b287a8f2ab3b4a2fb8b8e4) )
	ROM_LOAD64_WORD( "c61.c8",   0x1000006, 0x400000, CRC(a2b0c6c0) SHA1(71016c01c1a706b73cf5b9ac7e384a030c6cf08d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c61.m1",   0x00000, 0x08000, CRC(c976e6f9) SHA1(281025e5aaf97c0aeddc8bd0f737d092daadad9e) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c61.m2",   0x28000, 0x20000, CRC(ce67d0d9) SHA1(324226597cc5a11603f04085fef7715a314ecc05) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c61.q1",   0x000000, 0x200000, CRC(37ac6d30) SHA1(ec67421fbf4a08a686e76792cb35e9cbf04d022d) )
	ROM_LOAD16_WORD_SWAP( "c61.q2",   0x200000, 0x200000, CRC(de092570) SHA1(a03d0df901f6ea79685eaed67db65bee14ec29c6) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "msh.key",      0x00, 0x14, CRC(b494368e) SHA1(8efc561cec2bcc17902d27ed4e27b7d2b9eccdbc) )
ROM_END

 /****************************
 19XX The War Against Destiny
*******************************/
ROM_START( 19xxs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c62s01.p1", 0x000000, 0x80000, CRC(03a35085) SHA1(224fab94df8691a8e68a6ff30a57497350624bc0) )
	ROM_LOAD16_WORD_SWAP( "c62u.p2", 0x080000, 0x80000, CRC(3111ab7f) SHA1(8bbce20ae7ba47949f4939b2f35014fb6decd283) )
	ROM_LOAD16_WORD_SWAP( "c62u.p3", 0x100000, 0x80000, CRC(38df4a63) SHA1(1303f7ab6296f1454907a24d64878bdbd1ef88a7) )
	ROM_LOAD16_WORD_SWAP( "c62u.p4", 0x180000, 0x80000, CRC(5c7e60d3) SHA1(26bf0936962051be871d7a7776cf78abfca5b5ee) )
	ROM_LOAD16_WORD_SWAP( "c62.p5",  0x200000, 0x80000, CRC(61c0296c) SHA1(9e225beccffd14bb53a32f8c0f2aef7f331dae30) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c62.c1",   0x0000000, 0x080000, CRC(427aeb18) SHA1(901029b5423e4bda85f592735036c06b7d426680) )
	ROM_LOAD64_WORD( "c62.c2",   0x0000002, 0x080000, CRC(63bdbf54) SHA1(9beb64ef0a8c92490848599d5d979bf42532609d) )
	ROM_LOAD64_WORD( "c62.c3",   0x0000004, 0x080000, CRC(2dfe18b5) SHA1(8a44364d9af6b9e1664b44b9235dc172182c9eb8) )
	ROM_LOAD64_WORD( "c62.c4",   0x0000006, 0x080000, CRC(cbef9579) SHA1(172413f220b242411218c7865e04014ec6417537) )
	ROM_LOAD64_WORD( "c62.c5",   0x0800000, 0x200000, CRC(e916967c) SHA1(3f937022166149a80585f91388de521055ca88ca) )
	ROM_LOAD64_WORD( "c62.c6",   0x0800002, 0x200000, CRC(6e75f3db) SHA1(4e1c8466eaa612102d0807d2e8bf1004e97476ea) )
	ROM_LOAD64_WORD( "c62.c7",   0x0800004, 0x200000, CRC(2213e798) SHA1(b1a9d5547f3f6c3ab59e8b761d224793c6ca33cb) )
	ROM_LOAD64_WORD( "c62.c8",   0x0800006, 0x200000, CRC(ab9d5b96) SHA1(52b755da401fde90c13181b02ab33e5e4b2aa1f7) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c62.m1",   0x00000, 0x08000, CRC(ef55195e) SHA1(813f465f2d392f6abeadbf661c54cf51171fa006) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c62.q1",   0x000000, 0x200000, CRC(d38beef3) SHA1(134e961b926a97cca5e45d3558efb98f6f278e08) )
	ROM_LOAD16_WORD_SWAP( "c62.q2",   0x200000, 0x200000, CRC(d47c96e2) SHA1(3c1b5563f8e7ee1c450b3592fcb319e928caec3c) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "19xxu.key",     0x00, 0x14, CRC(77e67ba1) SHA1(8c995bd00941ffe0145cb80e4f105ef8ef0a0001) )
ROM_END

ROM_START( 19xxs02 ) //19xxjr1c
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c62s02.p1", 0x000000, 0x80000, CRC(36aa1a2f) SHA1(8946961f5eeb19d7b75cd814fa6776703e0d5cc4) )
	ROM_LOAD16_WORD_SWAP( "c62s02.p2", 0x080000, 0x80000, CRC(936d2b48) SHA1(7620baea050122da16a5500b4a293efda55a4116) )
	ROM_LOAD16_WORD_SWAP( "c62s02.p3", 0x100000, 0x80000, CRC(e86c9a96) SHA1(a34b98d6dbfbb6fbd501720bb10003ce68920b7d) )
	ROM_LOAD16_WORD_SWAP( "c62s02.p4", 0x180000, 0x80000, CRC(67d76362) SHA1(12d78542a5fb09c5bf63196774a5437057197601) )
	ROM_LOAD16_WORD_SWAP( "c62.p5",  0x200000, 0x80000, CRC(61c0296c) SHA1(9e225beccffd14bb53a32f8c0f2aef7f331dae30) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c62s02.c1",   0x0000000, 0x080000, CRC(33c7141a) SHA1(d7af081e001d2cf0fcc6a2f93d14108e4843f9ee) )
	ROM_LOAD64_WORD( "c62s02.c2",   0x0000002, 0x080000, CRC(c64488d9) SHA1(4da8a9be134665b3a81d78d21a0df8c187f300a8) )
	ROM_LOAD64_WORD( "c62s02.c3",   0x0000004, 0x080000, CRC(1d676d81) SHA1(d415599a5d01d5eefbe5c7135f50f30c28403f8f) )
	ROM_LOAD64_WORD( "c62s02.c4",   0x0000006, 0x080000, CRC(9555afde) SHA1(eba87eb5350b477127714752665c249d9d6e4e7e) )
	ROM_LOAD64_WORD( "c62s02.c5",   0x0800000, 0x200000, CRC(0c887947) SHA1(3976aa6bb8e6708b07e98a1ac5ebdcdf4eddc1b9) )
	ROM_LOAD64_WORD( "c62s02.c6",   0x0800002, 0x200000, CRC(3a7b431b) SHA1(ad0a6ad86de043202c8648b6df2702c4f006ca28) )
	ROM_LOAD64_WORD( "c62s02.c7",   0x0800004, 0x200000, CRC(9c785b4d) SHA1(095ba0f2369b425918a00a435125060fcb70141a) )
	ROM_LOAD64_WORD( "c62s02.c8",   0x0800006, 0x200000, CRC(280f29c8) SHA1(8af6f82fca322072e8077b06b23b7d852d1fc75b) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c62.m1",   0x00000, 0x08000, CRC(ef55195e) SHA1(813f465f2d392f6abeadbf661c54cf51171fa006) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c62.q1",   0x000000, 0x200000, CRC(d38beef3) SHA1(134e961b926a97cca5e45d3558efb98f6f278e08) )
	ROM_LOAD16_WORD_SWAP( "c62.q2",   0x200000, 0x200000, CRC(d47c96e2) SHA1(3c1b5563f8e7ee1c450b3592fcb319e928caec3c) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "19xxj.key",    0x00, 0x14, CRC(9aafa71a) SHA1(82188cc69e59d5ce86d0e178cf6d9f8f04da0633) )
ROM_END

 /**************************************
 Dungeons & Dragons Shadow over Mystara
*****************************************/
ROM_START( ddsomak )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63ak.p1",  0x000000, 0x80000, CRC(20a53ecb) SHA1(bfb7c0bb2d70d45aee21e5dc73fa3ab0b2fc1bac) )
	ROM_LOAD16_WORD_SWAP( "c63ak.p2",  0x080000, 0x80000, CRC(e2fc9c29) SHA1(33dd08498d2e29abcb2e29128e5c09123326a272) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63k.p4",   0x180000, 0x80000, CRC(14c46332) SHA1(27db31f4d3a8c2e9608afc9b63ddfbb5e2406bda) )
	ROM_LOAD16_WORD_SWAP( "c63k.p5",   0x200000, 0x80000, CRC(9c6706d7) SHA1(afb4fe1013974a90ddcbe91db4875c9b793e16e2) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63k.p7",   0x300000, 0x80000, CRC(09ac4b22) SHA1(6ca23f58635743d9589e8219f9ba8d849a424263) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63k.c1",   0x0000000, 0x400000, CRC(651786dd) SHA1(b22670cb163ce5c9721b463fb540c215b3d1352c) )
	ROM_LOAD64_WORD( "c63k.c2",   0x0000002, 0x400000, CRC(173ce940) SHA1(82ca5a1222986e795273316df9f8c6757ab70b90) )
	ROM_LOAD64_WORD( "c63k.c3",   0x0000004, 0x400000, CRC(c18c9b32) SHA1(b7168647ec2e1a3e62d81061e7217da752773035) )
	ROM_LOAD64_WORD( "c63k.c4",   0x0000006, 0x400000, CRC(0436a109) SHA1(e40f92e7c0e331cbc90e823c3d860d1fd69fcbbc) )
	ROM_LOAD64_WORD( "c63k.c5",   0x1000000, 0x200000, CRC(fca8f094) SHA1(72095a26b50a6542714a3cf94b4df85700335913) )
	ROM_LOAD64_WORD( "c63k.c6",   0x1000002, 0x200000, CRC(aa1a1481) SHA1(40257ab293ca92ea1c57e9d414b0e1bf0a319be8) )
	ROM_LOAD64_WORD( "c63k.c7",   0x1000004, 0x200000, CRC(b278079a) SHA1(866ae90a71439eb82bec23048c2a927fe0cabd3c) )
	ROM_LOAD64_WORD( "c63k.c8",   0x1000006, 0x200000, CRC(60540da9) SHA1(eb62c6f116d1804f0818c89396c07be1d8b5b699) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsoma.key",   0x00, 0x14, CRC(8c3cc560) SHA1(ad19e78b938a67c9f5ed0dcd5c68b383e6ce0575) )
ROM_END

ROM_START( ddsomjk )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63k.p1",   0x000000, 0x80000, CRC(ce684dd4) SHA1(e54dfbf3836627af3accaad8e6349fcf8ed75fba) )
	ROM_LOAD16_WORD_SWAP( "c63k.p2",   0x080000, 0x80000, CRC(64212c8d) SHA1(6fff452b1fa2d86623c674fbf8528ea3b57790a9) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63k.p4",   0x180000, 0x80000, CRC(14c46332) SHA1(27db31f4d3a8c2e9608afc9b63ddfbb5e2406bda) )
	ROM_LOAD16_WORD_SWAP( "c63k.p5",   0x200000, 0x80000, CRC(9c6706d7) SHA1(afb4fe1013974a90ddcbe91db4875c9b793e16e2) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63k.p7",   0x300000, 0x80000, CRC(09ac4b22) SHA1(6ca23f58635743d9589e8219f9ba8d849a424263) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63k.c1",   0x0000000, 0x400000, CRC(651786dd) SHA1(b22670cb163ce5c9721b463fb540c215b3d1352c) )
	ROM_LOAD64_WORD( "c63k.c2",   0x0000002, 0x400000, CRC(173ce940) SHA1(82ca5a1222986e795273316df9f8c6757ab70b90) )
	ROM_LOAD64_WORD( "c63k.c3",   0x0000004, 0x400000, CRC(c18c9b32) SHA1(b7168647ec2e1a3e62d81061e7217da752773035) )
	ROM_LOAD64_WORD( "c63k.c4",   0x0000006, 0x400000, CRC(0436a109) SHA1(e40f92e7c0e331cbc90e823c3d860d1fd69fcbbc) )
	ROM_LOAD64_WORD( "c63k.c5",   0x1000000, 0x200000, CRC(fca8f094) SHA1(72095a26b50a6542714a3cf94b4df85700335913) )
	ROM_LOAD64_WORD( "c63k.c6",   0x1000002, 0x200000, CRC(aa1a1481) SHA1(40257ab293ca92ea1c57e9d414b0e1bf0a319be8) )
	ROM_LOAD64_WORD( "c63k.c7",   0x1000004, 0x200000, CRC(b278079a) SHA1(866ae90a71439eb82bec23048c2a927fe0cabd3c) )
	ROM_LOAD64_WORD( "c63k.c8",   0x1000006, 0x200000, CRC(60540da9) SHA1(eb62c6f116d1804f0818c89396c07be1d8b5b699) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsomj.key",   0x00, 0x14, CRC(d8dadb22) SHA1(e07b50ae464c35439333dd983e2acac48a1ce529) )
ROM_END

ROM_START( ddsoms01 ) //ddsomjc
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s01.p1", 0x000000, 0x80000, CRC(ed73e646) SHA1(d438e440f8de98cf3bc4d4c47fc8eb9202b0e995) )
	ROM_LOAD16_WORD_SWAP( "c63s01.p2", 0x080000, 0x80000, CRC(c5a6e4b5) SHA1(8f1f285fd73bcce22a1dfdff24dcd8680f791fdc) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63s01.p4", 0x180000, 0x80000, CRC(05c5fd8e) SHA1(21b7c8da9a671c98bdcdb5e65334396b57cc3914) )
	ROM_LOAD16_WORD_SWAP( "c63u.p5",   0x200000, 0x80000, CRC(909a0b8b) SHA1(58bda17c36063a79df8b5031755c7909a9bda221) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63s01.p7", 0x300000, 0x80000, CRC(1547eab4) SHA1(8bc05a1ab05f66e1413cf5fbcee47decbc0c12c5) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63js01.c1",   0x0000000, 0x400000, CRC(cf628d3e) SHA1(88a2c87fe14fd67d0b2122324779695329f97963) )
	ROM_LOAD64_WORD( "c63js01.c2",   0x0000002, 0x400000, CRC(b7a16e7b) SHA1(1168627ea6544750439887f92722d1d888a10bad) )
	ROM_LOAD64_WORD( "c63js01.c3",   0x0000004, 0x400000, CRC(abfc24b4) SHA1(97706ffc1d0dc1d15ba76f3205706e190404cdec) )
	ROM_LOAD64_WORD( "c63js01.c4",   0x0000006, 0x400000, CRC(2b6b77bf) SHA1(ca9b329012ad4caa539d35942be178f4cb5f92f3) )
	ROM_LOAD64_WORD( "c63js01.c5",   0x1000000, 0x200000, CRC(358674f5) SHA1(e1326e30377507d61ea315f590da578f17c88b4d) )
	ROM_LOAD64_WORD( "c63js01.c6",   0x1000002, 0x200000, CRC(005cd6e0) SHA1(f4f565149171ac348cd6148002042da078e6e54b) )
	ROM_LOAD64_WORD( "c63js01.c7",   0x1000004, 0x200000, CRC(01895a06) SHA1(2eaaf9d1005bef712d76e97f37eaba1cda873a5b) )
	ROM_LOAD64_WORD( "c63js01.c8",   0x1000006, 0x200000, CRC(623c5e89) SHA1(a5a04e9fab7f10d342635a25bfc9d7596350f44e) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsomj.key",   0x00, 0x14, CRC(d8dadb22) SHA1(e07b50ae464c35439333dd983e2acac48a1ce529) )
ROM_END

ROM_START( ddsoms02 ) //ddsmjr4p
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s02.p1", 0x000000, 0x80000, CRC(9f02d9bc) SHA1(301901a5324ffe13a6cb0d3b4347ca0700d5e800) )
	ROM_LOAD16_WORD_SWAP( "c63s02.p2", 0x080000, 0x80000, CRC(b422cea9) SHA1(6c8ee19a1dd8a82cc2b8d5eed0d70c2857bf0aba) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63u.p4",   0x180000, 0x80000, CRC(c26b5e55) SHA1(9590206f30459941880ff4b56c7f276cc78e3a22) )
	ROM_LOAD16_WORD_SWAP( "c63u.p5",   0x200000, 0x80000, CRC(909a0b8b) SHA1(58bda17c36063a79df8b5031755c7909a9bda221) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63u.p7",   0x300000, 0x80000, CRC(5f86279f) SHA1(c2a454e5f821b1cdd49f2cf0602e9bfb7ba63340) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsomj.key",   0x00, 0x14, CRC(d8dadb22) SHA1(e07b50ae464c35439333dd983e2acac48a1ce529) )
ROM_END

ROM_START( ddsoms03 ) //ddsomudp, ddsomud
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s03.p1", 0x000000, 0x80000, CRC(41429cbc) SHA1(dfd6011a52c8a8c5b42c85ee3c886cd3db8964b9) )
	ROM_LOAD16_WORD_SWAP( "c63s03.p2", 0x080000, 0x80000, CRC(11f7496d) SHA1(b0f64487f8b9e410195ae6810a30b58874c2497c) )
	ROM_LOAD16_WORD_SWAP( "c63s03.p3", 0x100000, 0x80000, CRC(c00d5fb6) SHA1(35b7011905f5f9d12a17171609e71c53b1e1ecb5) )
	ROM_LOAD16_WORD_SWAP( "c63s03.p4", 0x180000, 0x80000, CRC(5eaf9618) SHA1(e9381a81d2bd971666656835991109867341a9a5) )
	ROM_LOAD16_WORD_SWAP( "c63u.p5",   0x200000, 0x80000, CRC(909a0b8b) SHA1(58bda17c36063a79df8b5031755c7909a9bda221) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63u.p7",   0x300000, 0x80000, CRC(5f86279f) SHA1(c2a454e5f821b1cdd49f2cf0602e9bfb7ba63340) )
	ROM_LOAD16_WORD_SWAP( "c63s03.p8", 0x380000, 0x80000, CRC(33d55230) SHA1(245b3a99a29c0f11bae4409c1c51f02e102b0fc2) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )
ROM_END

ROM_START( ddsoms04 ) //ddsoma4p
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s04.p1", 0x000000, 0x80000, CRC(e28c61f2) SHA1(a15ba7e4d1c6e2e2c047e12edefc6b1564464496) )
	ROM_LOAD16_WORD_SWAP( "c63s04.p2", 0x080000, 0x80000, CRC(145efa6f) SHA1(2da422bf43c4b4abd20ddcf7b0dd4a37f23d756a) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63u.p4",   0x180000, 0x80000, CRC(c26b5e55) SHA1(9590206f30459941880ff4b56c7f276cc78e3a22) )
	ROM_LOAD16_WORD_SWAP( "c63u.p5",   0x200000, 0x80000, CRC(909a0b8b) SHA1(58bda17c36063a79df8b5031755c7909a9bda221) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63u.p7",   0x300000, 0x80000, CRC(5f86279f) SHA1(c2a454e5f821b1cdd49f2cf0602e9bfb7ba63340) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsoma.key",   0x00, 0x14, CRC(8c3cc560) SHA1(ad19e78b938a67c9f5ed0dcd5c68b383e6ce0575) )
ROM_END

ROM_START( ddsoms05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63j.p1",   0x000000, 0x80000, CRC(e6c8c985) SHA1(0736a84d7d9d37d51826eac6826a7728260bc625) )
	ROM_LOAD16_WORD_SWAP( "c63j.p2",   0x080000, 0x80000, CRC(8386c0bd) SHA1(59bfc71914ec2bb7d1b9f327b25d2399181d4bb2) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63u.p4",   0x180000, 0x80000, CRC(c26b5e55) SHA1(9590206f30459941880ff4b56c7f276cc78e3a22) )
	ROM_LOAD16_WORD_SWAP( "c63u.p5",   0x200000, 0x80000, CRC(909a0b8b) SHA1(58bda17c36063a79df8b5031755c7909a9bda221) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63u.p7",   0x300000, 0x80000, CRC(5f86279f) SHA1(c2a454e5f821b1cdd49f2cf0602e9bfb7ba63340) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD( "c63s05.c1",   0x0000000, 0x1000000, CRC(9b6a8bd7) SHA1(d6bf2c2c35904e0fe4c299a351c766b2e25e709c) )
	ROM_LOAD( "c63s05.c5",   0x1000000, 0x800000,  CRC(39b30ad6) SHA1(b2f0a1b97986484d449da9a4e85a13165002d6cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsomj.key",   0x00, 0x14, CRC(d8dadb22) SHA1(e07b50ae464c35439333dd983e2acac48a1ce529) )
ROM_END

ROM_START( ddsoms06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s06.p1", 0x000000, 0x80000, CRC(5a9574e5) SHA1(c810b9bf495d4cd44305e27992848aab207da922) )
	ROM_LOAD16_WORD_SWAP( "c63.p2",    0x080000, 0x80000, CRC(5b7052b6) SHA1(8a5f069f450da939d0f02518751cd9815d621d81) )
	ROM_LOAD16_WORD_SWAP( "c63s06.p3", 0x100000, 0x80000, CRC(554e9b24) SHA1(6b78662c0e377f5595cef9d2b49d6af0ece19fd1) )
	ROM_LOAD16_WORD_SWAP( "c63.p4",    0x180000, 0x80000, CRC(e0807e1e) SHA1(4b978f5f647fff84d456eb14c9fd202d9a276997) )
	ROM_LOAD16_WORD_SWAP( "c63.p5",    0x200000, 0x80000, CRC(bb777a02) SHA1(4b2c65a9129fc2262b35be1c10d06f60f5108981) )
	ROM_LOAD16_WORD_SWAP( "c63.p6",    0x280000, 0x80000, CRC(30970890) SHA1(fd366a9323230f6997006ab4cc216f9a97865ebe) )
	ROM_LOAD16_WORD_SWAP( "c63.p7",    0x300000, 0x80000, CRC(99e2194d) SHA1(cbcecdf5beeac3eac6c2c3fa395710e1b8347531) )
	ROM_LOAD16_WORD_SWAP( "c63.p8",    0x380000, 0x80000, CRC(e198805e) SHA1(37ae9d88d98c59337b657cfa6feb56e4f9cae95f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsom.key",    0x00, 0x14, CRC(541e425d) SHA1(9239f9ad7c2ed0d7d062da2db92b07104b5bb9a7) )
ROM_END

ROM_START( ddsoms07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s07.p1", 0x000000, 0x80000, CRC(cc650f5b) SHA1(b39dd217b8a4cf82f994e1657909ff001fc4721b) )
	ROM_LOAD16_WORD_SWAP( "c63j.p2",   0x080000, 0x80000, CRC(8386c0bd) SHA1(59bfc71914ec2bb7d1b9f327b25d2399181d4bb2) )
	ROM_LOAD16_WORD_SWAP( "c63u.p3",   0x100000, 0x80000, CRC(5eb1991c) SHA1(429a60b5396ff4192904867fbe0524268f0edbcb) )
	ROM_LOAD16_WORD_SWAP( "c63u.p4",   0x180000, 0x80000, CRC(c26b5e55) SHA1(9590206f30459941880ff4b56c7f276cc78e3a22) )
	ROM_LOAD16_WORD_SWAP( "c63s07.p5", 0x200000, 0x80000, CRC(9c520a00) SHA1(7f801f86ebc725bbbeae9eb832b843b282428ec1) )
	ROM_LOAD16_WORD_SWAP( "c63u.p6",   0x280000, 0x80000, CRC(e53c4d01) SHA1(bad872e4e793a39f68bc0e580772e982714b5876) )
	ROM_LOAD16_WORD_SWAP( "c63u.p7",   0x300000, 0x80000, CRC(5f86279f) SHA1(c2a454e5f821b1cdd49f2cf0602e9bfb7ba63340) )
	ROM_LOAD16_WORD_SWAP( "c63u.p8",   0x380000, 0x80000, CRC(ad954c26) SHA1(468c01735dbdb1114b37060546a660678290a97f) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "ddsomj.key",   0x00, 0x14, CRC(d8dadb22) SHA1(e07b50ae464c35439333dd983e2acac48a1ce529) )
ROM_END

ROM_START( ddsoms08 ) // Dungeons & Dragons: Shadow over Mystara (Plus decrypted version)
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c63s08.p1", 0x000000, 0x400000, CRC(6611a98b) SHA1(6ea5062199c9df600831b57fa279b7d48cfc6900) )

	ROM_REGION( 0x1800000, "gfx", 0 )
	ROM_LOAD64_WORD( "c63.c1",   0x0000000, 0x400000, CRC(a46b4e6e) SHA1(fb90f42868c581c481b4ceff9f692753fb186b30) )
	ROM_LOAD64_WORD( "c63.c2",   0x0000002, 0x400000, CRC(d5fc50fc) SHA1(bc692f17b18bb47a724cd5152377cd5ccd6e184a) )
	ROM_LOAD64_WORD( "c63.c3",   0x0000004, 0x400000, CRC(837c0867) SHA1(3d6db290a8f76299a23543f0ccf6a7905e1088ac) )
	ROM_LOAD64_WORD( "c63.c4",   0x0000006, 0x400000, CRC(bb0ec21c) SHA1(e43ccc1cf63ccd2b504cc9fd701af849a7321914) )
	ROM_LOAD64_WORD( "c63.c5",   0x1000000, 0x200000, CRC(6d824ce2) SHA1(0ccfe6c8a944937718e28a1a373b5822c7b7001b) )
	ROM_LOAD64_WORD( "c63.c6",   0x1000002, 0x200000, CRC(79682ae5) SHA1(ee84f4791c29ce9e2bae06ba3ec47ff4d2cd7054) )
	ROM_LOAD64_WORD( "c63.c7",   0x1000004, 0x200000, CRC(acddd149) SHA1(7f50de9b2d1cc733594c642be1804190519caffa) )
	ROM_LOAD64_WORD( "c63.c8",   0x1000006, 0x200000, CRC(117fb0c0) SHA1(15c01fa1a71b6469b0e1bde0ce5835c5ff9d938c) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c63.m1",   0x00000, 0x08000, CRC(99d657e5) SHA1(1528dd6b07a0e79951a35c0457c8a9c9770e9c78) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c63.m2",   0x28000, 0x20000, CRC(117a3824) SHA1(14f3a12170b601c5466c93af9d2f24e0b386b4e4) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c63.q1",   0x000000, 0x200000, CRC(98d0c325) SHA1(7406e8d943d77c468eb418c4113261f4ab973bbf) )
	ROM_LOAD16_WORD_SWAP( "c63.q2",   0x200000, 0x200000, CRC(5ea2e7fa) SHA1(0e6a9fd007f637adcb2226c902394f07de45e803) )
ROM_END

 /**********************
 Street Fighter Alpha 2
*************************/
ROM_START( sfa2s01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s01.p1", 0x000000, 0x80000, CRC(6cbeb97d) SHA1(054cf7a0bbcb84bcd77ff2c5a084754f2c7694aa) )
	ROM_LOAD16_WORD_SWAP( "c64.p2", 0x080000, 0x80000, CRC(22d17b26) SHA1(2d7a9cedae1bb2b7cfb80d2bfcf24cb7738df0bf) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64.p5",  0x200000, 0x80000, CRC(8e184246) SHA1(c51f6480cfa1dcec6c4713fd38c7a27338c3fa65) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s02.p1", 0x000000, 0x80000, CRC(46d0aff2) SHA1(3da96e4fb987fe21153dd55db0e42a409a3c4ba2) )
	ROM_LOAD16_WORD_SWAP( "c64.p2", 0x080000, 0x80000, CRC(22d17b26) SHA1(2d7a9cedae1bb2b7cfb80d2bfcf24cb7738df0bf) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64.p5",  0x200000, 0x80000, CRC(8e184246) SHA1(c51f6480cfa1dcec6c4713fd38c7a27338c3fa65) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s03.p1", 0x000000, 0x80000, CRC(2d0641e3) SHA1(a3655bb14f8b6636786ebb5f8531ba581d769178) )
	ROM_LOAD16_WORD_SWAP( "c64s03.p2", 0x080000, 0x80000, CRC(b15e7867) SHA1(540a47b6ee645c5e72b49749be3d6ab8fd182a72) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64.p5",  0x200000, 0x80000, CRC(8e184246) SHA1(c51f6480cfa1dcec6c4713fd38c7a27338c3fa65) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s04.p1", 0x000000, 0x80000, CRC(f6e6d427) SHA1(85ff5c9fcd6849bfb325c9362b79851f9a41c7b4) )
	ROM_LOAD16_WORD_SWAP( "c64u.p2", 0x080000, 0x80000, CRC(fae0e9c3) SHA1(d84cfbf16079f9987df683911b83896b80b52b1a) )
	ROM_LOAD16_WORD_SWAP( "c64u.p3", 0x100000, 0x80000, CRC(d02dd758) SHA1(581bcd451b1d081b9b73d4a1b485da9f29756613) )
	ROM_LOAD16_WORD_SWAP( "c64u.p4",  0x180000, 0x80000, CRC(c5c8eb63) SHA1(4ea033834c7b260877335296f88c0db484dea289) )
	ROM_LOAD16_WORD_SWAP( "c64u.p5",  0x200000, 0x80000, CRC(5de01cc5) SHA1(b19bfe970b217c96e782860fc3ae3fcb976ed30d) )
	ROM_LOAD16_WORD_SWAP( "c64u.p6",  0x280000, 0x80000, CRC(bea11d56) SHA1(a1d475066d36de7cc5d931671ccdcd89737bc7ee) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2u.key",    0x00, 0x14, CRC(4a8d91ef) SHA1(e22567ab83b35c39c6545742bc85ca98ae97f288) )
ROM_END

ROM_START( sfa2s05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s05.p1", 0x000000, 0x80000, CRC(93ef94ca) SHA1(3a5e596de94c8ab70f7e2077b5c4fa68c27162b6) )
	ROM_LOAD16_WORD_SWAP( "c64u.p2", 0x080000, 0x80000, CRC(fae0e9c3) SHA1(d84cfbf16079f9987df683911b83896b80b52b1a) )
	ROM_LOAD16_WORD_SWAP( "c64u.p3", 0x100000, 0x80000, CRC(d02dd758) SHA1(581bcd451b1d081b9b73d4a1b485da9f29756613) )
	ROM_LOAD16_WORD_SWAP( "c64u.p4",  0x180000, 0x80000, CRC(c5c8eb63) SHA1(4ea033834c7b260877335296f88c0db484dea289) )
	ROM_LOAD16_WORD_SWAP( "c64u.p5",  0x200000, 0x80000, CRC(5de01cc5) SHA1(b19bfe970b217c96e782860fc3ae3fcb976ed30d) )
	ROM_LOAD16_WORD_SWAP( "c64u.p6",  0x280000, 0x80000, CRC(bea11d56) SHA1(a1d475066d36de7cc5d931671ccdcd89737bc7ee) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2u.key",    0x00, 0x14, CRC(4a8d91ef) SHA1(e22567ab83b35c39c6545742bc85ca98ae97f288) )
ROM_END

ROM_START( sfa2s06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s06.p1", 0x000000, 0x80000, CRC(0abedf4b) SHA1(389c4f3d32f5ee001f1e36b8f5ebf5364b4af9af) )
	ROM_LOAD16_WORD_SWAP( "c64u.p2", 0x080000, 0x80000, CRC(fae0e9c3) SHA1(d84cfbf16079f9987df683911b83896b80b52b1a) )
	ROM_LOAD16_WORD_SWAP( "c64u.p3", 0x100000, 0x80000, CRC(d02dd758) SHA1(581bcd451b1d081b9b73d4a1b485da9f29756613) )
	ROM_LOAD16_WORD_SWAP( "c64u.p4",  0x180000, 0x80000, CRC(c5c8eb63) SHA1(4ea033834c7b260877335296f88c0db484dea289) )
	ROM_LOAD16_WORD_SWAP( "c64u.p5",  0x200000, 0x80000, CRC(5de01cc5) SHA1(b19bfe970b217c96e782860fc3ae3fcb976ed30d) )
	ROM_LOAD16_WORD_SWAP( "c64u.p6",  0x280000, 0x80000, CRC(bea11d56) SHA1(a1d475066d36de7cc5d931671ccdcd89737bc7ee) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2u.key",    0x00, 0x14, CRC(4a8d91ef) SHA1(e22567ab83b35c39c6545742bc85ca98ae97f288) )
ROM_END

ROM_START( sfa2s07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s07.p1", 0x000000, 0x80000, CRC(8e9124fc) SHA1(2982475156a5a6c4fd86e964ffe6fcf0061e00a1) )
	ROM_LOAD16_WORD_SWAP( "c64.p2", 0x080000, 0x80000, CRC(22d17b26) SHA1(2d7a9cedae1bb2b7cfb80d2bfcf24cb7738df0bf) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64.p5",  0x200000, 0x80000, CRC(8e184246) SHA1(c51f6480cfa1dcec6c4713fd38c7a27338c3fa65) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s08 )  // sfa2uhc
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s08.p1", 0x000000, 0x80000, CRC(916316e0) SHA1(e688b44a7a9a63e0435651e3f5510edae9bb72bf) )
	ROM_LOAD16_WORD_SWAP( "c64ur1.p2", 0x080000, 0x80000, CRC(ac46e5ed) SHA1(a01b57daba4c255d5f07465c553bcbfe51d9ab0d) )
	ROM_LOAD16_WORD_SWAP( "c64ur1.p3", 0x100000, 0x80000, CRC(6c0c79d3) SHA1(ae2a4e2903beec1f10fff6edac1a2385d6ac1c38) )
	ROM_LOAD16_WORD_SWAP( "c64u.p4",  0x180000, 0x80000, CRC(c5c8eb63) SHA1(4ea033834c7b260877335296f88c0db484dea289) )
	ROM_LOAD16_WORD_SWAP( "c64u.p5",  0x200000, 0x80000, CRC(5de01cc5) SHA1(b19bfe970b217c96e782860fc3ae3fcb976ed30d) )
	ROM_LOAD16_WORD_SWAP( "c64u.p6",  0x280000, 0x80000, CRC(bea11d56) SHA1(a1d475066d36de7cc5d931671ccdcd89737bc7ee) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2u.key",    0x00, 0x14, CRC(4a8d91ef) SHA1(e22567ab83b35c39c6545742bc85ca98ae97f288) )
ROM_END

ROM_START( sfa2s09 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s09.p1", 0x000000, 0x80000, CRC(f24e7b3a) SHA1(0cf5169fcf46dcea5a100bf75a5dcd791c51b671) )
	ROM_LOAD16_WORD_SWAP( "c64.p2", 0x080000, 0x80000, CRC(22d17b26) SHA1(2d7a9cedae1bb2b7cfb80d2bfcf24cb7738df0bf) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64.p5",  0x200000, 0x80000, CRC(8e184246) SHA1(c51f6480cfa1dcec6c4713fd38c7a27338c3fa65) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s10 ) //sf2cefk
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s10.p1", 0x000000, 0x80000, CRC(b37eb6d8) SHA1(f36d88d9f5af823cb953b66dfdb635f2d92c73b4) )
	ROM_LOAD16_WORD_SWAP( "c64s10.p2", 0x080000, 0x80000, CRC(a2776d86) SHA1(6f0f348d4b08468e034ecf11ff42f190bc68f490) )
	ROM_LOAD16_WORD_SWAP( "c64.p3",  0x100000, 0x80000, CRC(4b442a7c) SHA1(a0d7d229cff8efb2a253ff06270258b0b4d2761e) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",  0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64s10.p5",  0x200000, 0x80000, CRC(c300b32a) SHA1(9e3f97a18da91bc780de331390ac0aa2ff293e93) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",  0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2.key",     0x00, 0x14, CRC(1578dcb0) SHA1(a8bc83b341f9ea2bcc18861419bd574d159c6fcc) )
ROM_END

ROM_START( sfa2s11 ) // sfa2ultra
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64s11.p1", 0x000000, 0x80000, CRC(e0481264) SHA1(958894ef8dc76bbec2b38a8fa69385b51a345557) )
	ROM_LOAD16_WORD_SWAP( "c64u.p2", 0x080000, 0x80000, CRC(fae0e9c3) SHA1(d84cfbf16079f9987df683911b83896b80b52b1a) )
	ROM_LOAD16_WORD_SWAP( "c64u.p3", 0x100000, 0x80000, CRC(d02dd758) SHA1(581bcd451b1d081b9b73d4a1b485da9f29756613) )
	ROM_LOAD16_WORD_SWAP( "c64u.p4",  0x180000, 0x80000, CRC(c5c8eb63) SHA1(4ea033834c7b260877335296f88c0db484dea289) )
	ROM_LOAD16_WORD_SWAP( "c64u.p5",  0x200000, 0x80000, CRC(5de01cc5) SHA1(b19bfe970b217c96e782860fc3ae3fcb976ed30d) )
	ROM_LOAD16_WORD_SWAP( "c64u.p6",  0x280000, 0x80000, CRC(bea11d56) SHA1(a1d475066d36de7cc5d931671ccdcd89737bc7ee) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa2u.key",    0x00, 0x14, CRC(4a8d91ef) SHA1(e22567ab83b35c39c6545742bc85ca98ae97f288) )
ROM_END

ROM_START( sfz2j01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64j02.p1", 0x000000, 0x80000, CRC(4afbba27) SHA1(9bba80417763d3dd9614efc810908ef3d011c49d) )
	ROM_LOAD16_WORD_SWAP( "c64jr1.p2", 0x080000, 0x80000, CRC(ae4851a9) SHA1(4771bc22fe1b376b753a68506c012c52bd4b886d) )
	ROM_LOAD16_WORD_SWAP( "c64jr1.p3",  0x100000, 0x80000, CRC(98e8e992) SHA1(41745b63e6b3888081d189b8315ed3b7526b3d20) )
	ROM_LOAD16_WORD_SWAP( "c64.p4",   0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64jr1.p5", 0x200000, 0x80000, CRC(d910b2a2) SHA1(aa201660caa9cef993c147a1077c9e7767b34a78) )
	ROM_LOAD16_WORD_SWAP( "c64.p6",   0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2j.key",    0x00, 0x14, CRC(455bd098) SHA1(6a928a2d44f416ccdb0c09a8dd7466ac12f38110) )
ROM_END

ROM_START( sfz2k01 ) // sfz2jk
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64k01.p1", 0x000000, 0x80000, CRC(e46526a9) SHA1(07f2a35fb24d0dcfc48fdc0d5328d4c710a6cea7) )
	ROM_LOAD16_WORD_SWAP( "c64k01.p2", 0x080000, 0x80000, CRC(5f8f5bc3) SHA1(a46e357e81003c74f7bed8b661c73eb4eb647936) )
	ROM_LOAD16_WORD_SWAP( "c64j.p3", 0x100000, 0x80000, CRC(dd224156) SHA1(85d29f2a288430d51c53b88130f255131e5dc601) )
	ROM_LOAD16_WORD_SWAP( "c64j.p4", 0x180000, 0x80000, CRC(a45a75a6) SHA1(e9cd4ad08ac0d058e9e1660acb07eb350a141fd6) )
	ROM_LOAD16_WORD_SWAP( "c64k01.p5", 0x200000, 0x80000, CRC(515ceb77) SHA1(25269af66e480484d432fa12076ffe26ab958e37) )
	ROM_LOAD16_WORD_SWAP( "c64j.p6", 0x280000, 0x80000, CRC(92b66e01) SHA1(f09cb38aa49b22a9c98219fb2ad8a66b11fa5872) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64k01.c1",   0x0000000, 0x400000, CRC(10ef2d2b) SHA1(e2bac04e12763fea420ea544eef7b15f2b908b2a) )
	ROM_LOAD64_WORD( "c64k01.c2",   0x0000002, 0x400000, CRC(fcc1f004) SHA1(3480c1665f78fb3f7b0467e7dedf8b170e8a4b96) )
	ROM_LOAD64_WORD( "c64k01.c3",   0x0000004, 0x400000, CRC(e364b775) SHA1(f15218c33292049aa7fbc3e4a8de735473a5b9e3) )
	ROM_LOAD64_WORD( "c64k01.c4",   0x0000006, 0x400000, CRC(ea68b6a9) SHA1(d116adc03593e2809e32c3de55c5cf70bebf308e) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2j.key",    0x00, 0x14, CRC(455bd098) SHA1(6a928a2d44f416ccdb0c09a8dd7466ac12f38110) )
ROM_END

ROM_START( sfz2k02 ) // sfz2jr1k
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c64k02.p1", 0x000000, 0x80000, CRC(671306bd) SHA1(163b2e6dc53d57775addc26d9cf43dfd0ce2240f) )
	ROM_LOAD16_WORD_SWAP( "c64k02.p2", 0x080000, 0x80000, CRC(13cc798b) SHA1(9f18c1ce7dcd32633597fd5ee434494969285bc8) )
	ROM_LOAD16_WORD_SWAP( "c64jr1.p3", 0x100000, 0x80000, CRC(98e8e992) SHA1(41745b63e6b3888081d189b8315ed3b7526b3d20) )
	ROM_LOAD16_WORD_SWAP( "c64.p4", 0x180000, 0x80000, CRC(5b1d49c0) SHA1(f0a0c894c9cbe2b18e7f59058665949ee0025732) )
	ROM_LOAD16_WORD_SWAP( "c64k02.p5", 0x200000, 0x80000, CRC(213368e7) SHA1(a0e1cf497c32a63766da4ab385c755a55b12f27d) )
	ROM_LOAD16_WORD_SWAP( "c64.p6", 0x280000, 0x80000, CRC(0fe8585d) SHA1(0cd5369a5aa90c98d8dc1ff3342cd4d990631cff) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64k01.c1",   0x0000000, 0x400000, CRC(10ef2d2b) SHA1(e2bac04e12763fea420ea544eef7b15f2b908b2a) )
	ROM_LOAD64_WORD( "c64k01.c2",   0x0000002, 0x400000, CRC(fcc1f004) SHA1(3480c1665f78fb3f7b0467e7dedf8b170e8a4b96) )
	ROM_LOAD64_WORD( "c64k01.c3",   0x0000004, 0x400000, CRC(e364b775) SHA1(f15218c33292049aa7fbc3e4a8de735473a5b9e3) )
	ROM_LOAD64_WORD( "c64k01.c4",   0x0000006, 0x400000, CRC(ea68b6a9) SHA1(d116adc03593e2809e32c3de55c5cf70bebf308e) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2j.key",    0x00, 0x14, CRC(455bd098) SHA1(6a928a2d44f416ccdb0c09a8dd7466ac12f38110) )
ROM_END


/**************************************
Super Puzzle Fighter II { Turbo / X }
**************************************/
ROM_START( spf2t01 )
	ROM_REGION(CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c65t01.p1", 0x000000, 0x80000, CRC(ca1f3e42) SHA1(784214517f3ac3f5f727a18f50992d4fa3417726) )
	ROM_LOAD16_WORD_SWAP( "c65.p2",    0x080000, 0x80000, CRC(b80649e2) SHA1(5bfccd656aea7ff82e9a20bb5856f4ab99b5a007) )

	ROM_REGION( 0xC00000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c65.c1", 0x800000, 0x100000, CRC(2d4881cb) SHA1(fd3baa183c25bed153b19c251980e2fb761600e2) )
	ROM_LOAD64_WORD( "c65.c2", 0x800002, 0x100000, CRC(4b0fd1be) SHA1(377aafdcdb7a866b1c8487670e3598d8197976e4) )
	ROM_LOAD64_WORD( "c65.c3", 0x800004, 0x100000, CRC(e43aac33) SHA1(d041e0688c3807d3363861a7f216de43b34d846c) )
	ROM_LOAD64_WORD( "c65.c4", 0x800006, 0x100000, CRC(7f536ff1) SHA1(905b9d62ef7bef47297c7f4a4dd697aed6df38a5) )

	ROM_REGION(QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c65.m1",   0x00000, 0x08000, CRC(600fb2a3) SHA1(1fab1c2a23bf6ad8309d29ddbbc29435a8aeea13) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c65.m2",   0x28000, 0x20000, CRC(496076e0) SHA1(1ee4e135140afd0e8e03231e570cd77d140f6367) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c65.q1",   0x000000, 0x200000, CRC(78442743) SHA1(b61190bb586871de6d54af580e3e1d9cc0de0acb) )
	ROM_LOAD16_WORD_SWAP( "c65.q2",   0x200000, 0x200000, CRC(399d2c7b) SHA1(e849dea97b8d16540415c0d9bbc4f9f4eb755ec4) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "spf2tu.key",    0x00, 0x14, CRC(5d7b15e8) SHA1(c14c6b148761856bf83b31b52df83be461ac8d62) )
ROM_END

/*******************************************************
CPS-2 Suicide Tester (based on Super Puzzle Fighter II
********************************************************/
ROM_START( suicide )
	ROM_REGION(CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c65su.p1", 0x000000, 0x80000, CRC(4d5eea90) SHA1(c6f6361650d64401354111bf111bd924126b7035) )

	ROM_REGION( 0xC00000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c65.c1", 0x800000, 0x100000, CRC(2d4881cb) SHA1(fd3baa183c25bed153b19c251980e2fb761600e2) )
	ROM_LOAD64_WORD( "c65.c2", 0x800002, 0x100000, CRC(4b0fd1be) SHA1(377aafdcdb7a866b1c8487670e3598d8197976e4) )
	ROM_LOAD64_WORD( "c65.c3", 0x800004, 0x100000, CRC(e43aac33) SHA1(d041e0688c3807d3363861a7f216de43b34d846c) )
	ROM_LOAD64_WORD( "c65.c4", 0x800006, 0x100000, CRC(7f536ff1) SHA1(905b9d62ef7bef47297c7f4a4dd697aed6df38a5) )

	ROM_REGION(QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c65.m1",   0x00000, 0x08000, CRC(600fb2a3) SHA1(1fab1c2a23bf6ad8309d29ddbbc29435a8aeea13) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c65.m2",   0x28000, 0x20000, CRC(496076e0) SHA1(1ee4e135140afd0e8e03231e570cd77d140f6367) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c65.q1",   0x000000, 0x200000, CRC(78442743) SHA1(b61190bb586871de6d54af580e3e1d9cc0de0acb) )
	ROM_LOAD16_WORD_SWAP( "c65.q2",   0x200000, 0x200000, CRC(399d2c7b) SHA1(e849dea97b8d16540415c0d9bbc4f9f4eb755ec4) )
ROM_END

ROM_START( suicide2 )
	ROM_REGION(CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c65su2.p1", 0x000000, 0x80000, CRC(d61ba7e3) SHA1(bde345a1d4643adc854d4c7e86c04f72fee1a07b) )

	ROM_REGION( 0xC00000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c65.c1", 0x800000, 0x100000, CRC(2d4881cb) SHA1(fd3baa183c25bed153b19c251980e2fb761600e2) )
	ROM_LOAD64_WORD( "c65.c2", 0x800002, 0x100000, CRC(4b0fd1be) SHA1(377aafdcdb7a866b1c8487670e3598d8197976e4) )
	ROM_LOAD64_WORD( "c65.c3", 0x800004, 0x100000, CRC(e43aac33) SHA1(d041e0688c3807d3363861a7f216de43b34d846c) )
	ROM_LOAD64_WORD( "c65.c4", 0x800006, 0x100000, CRC(7f536ff1) SHA1(905b9d62ef7bef47297c7f4a4dd697aed6df38a5) )

	ROM_REGION(QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c65.m1",   0x00000, 0x08000, CRC(600fb2a3) SHA1(1fab1c2a23bf6ad8309d29ddbbc29435a8aeea13) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c65.m2",   0x28000, 0x20000, CRC(496076e0) SHA1(1ee4e135140afd0e8e03231e570cd77d140f6367) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c65.q1",   0x000000, 0x200000, CRC(78442743) SHA1(b61190bb586871de6d54af580e3e1d9cc0de0acb) )
	ROM_LOAD16_WORD_SWAP( "c65.q2",   0x200000, 0x200000, CRC(399d2c7b) SHA1(e849dea97b8d16540415c0d9bbc4f9f4eb755ec4) )
ROM_END

 /***************************
 Street Fighter Zero 2 Alpha
******************************/
ROM_START( sfz2alk )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67k.p1", 0x000000, 0x80000, CRC(3b795a57) SHA1(ce003f59f6b2f122c690596ac99ba467766f6a30) )
	ROM_LOAD16_WORD_SWAP( "c67k.p2", 0x080000, 0x80000, CRC(9559af19) SHA1(f15ba3404f6e35e082b082b2560ecbfdd1a49e59) )
	ROM_LOAD16_WORD_SWAP( "c67k.p3", 0x100000, 0x80000, CRC(d2cb29fa) SHA1(eb7271409ec30692a5b81b4a8e163902b249f4f1) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als01 ) // sfz2aljk
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s01.p1", 0x000000, 0x80000, CRC(7b6f1c89) SHA1(08825427ba32f6b919d24eb4a71fb478a5cc28b7) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s02.p1", 0x000000, 0x80000, CRC(3b259640) SHA1(5e84c1c376a63aaac3d4e77427aa9baa84751f5d) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s03.p1", 0x000000, 0x80000, CRC(A4ad2f9e) SHA1(67b0dd178c797811ba9fe312a8a1b3e3b730d2a1) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s04.p1", 0x000000, 0x80000, CRC(A60677ca) SHA1(0db18b745d26cf4ca86a7dfc875ff3e6ad895261) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s05.p1", 0x000000, 0x80000, CRC(Cfd9f59f) SHA1(7a81059350c3651e9d3f6f60b082c22e5b0dc48d) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s06.p1", 0x000000, 0x80000, CRC(F0fd8b97) SHA1(1c07ec9679c86bf04596bd6e55db4afcc382cbdf) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s07.p1", 0x000000, 0x80000, CRC(71c95ab3) SHA1(2fcf71f8ea18717f8dedb76118ed4a0e8759e7e9) )
	ROM_LOAD16_WORD_SWAP( "c67s17.p2", 0x080000, 0x80000, CRC(b124800a) SHA1(560e708e1296ac3e7e6b74bee99a152a0d1f6894) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s08.p1", 0x000000, 0x80000, CRC(fdb28eb2) SHA1(262b3e4b6c0fac9a7350dd241c776869a135a10d) )
	ROM_LOAD16_WORD_SWAP( "c67s17.p2", 0x080000, 0x80000, CRC(b124800a) SHA1(560e708e1296ac3e7e6b74bee99a152a0d1f6894) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als09 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s09.p1", 0x000000, 0x80000, CRC(744f029a) SHA1(7359d9070a1f88db4caddcaf74a164a671b56c9a) )
	ROM_LOAD16_WORD_SWAP( "c67s17.p2", 0x080000, 0x80000, CRC(b124800a) SHA1(560e708e1296ac3e7e6b74bee99a152a0d1f6894) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als10 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s10.p1", 0x000000, 0x80000, CRC(abc5f2e6) SHA1(b39e8615ac4bed377a418acdcf772eeee60c2274) )
	ROM_LOAD16_WORD_SWAP( "c67s10.p2", 0x080000, 0x80000, CRC(f51b61bf) SHA1(3192ff7e9d86465d9af0fbbf882d07aab82614f9) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67s10.p5", 0x200000, 0x80000, CRC(030fc34c) SHA1(1fadda6b35df0a501bf15de022e2e15b7284c999) )
	ROM_LOAD16_WORD_SWAP( "c67s10.p6", 0x280000, 0x80000, CRC(0e760f1d) SHA1(679e4ab16bb7f6a5c3e566e093816f9e9f678085) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als11 ) //sfz2adl
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s11.p1", 0x000000, 0x80000, CRC(34058853) SHA1(10af8afffb90428f184c5cfebd3590bccaf509f9) )
	ROM_LOAD16_WORD_SWAP( "c67s17.p2", 0x080000, 0x80000, CRC(b124800a) SHA1(560e708e1296ac3e7e6b74bee99a152a0d1f6894) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als12 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s12.p1", 0x000000, 0x80000, CRC(15ba7790) SHA1(57fa725a64b8ee9be21dc8659015552b1634d20d) )
	ROM_LOAD16_WORD_SWAP( "c67.p2", 0x080000, 0x80000, CRC(ae8ec36e) SHA1(b2f3de9e33169f6266aaabd5eae6c057ea10dcab) )
	ROM_LOAD16_WORD_SWAP( "c67.p3", 0x100000, 0x80000, CRC(f053a55e) SHA1(f98a8af5cd33a543a5596d59381f9adafed38854) )
	ROM_LOAD16_WORD_SWAP( "c67.p4", 0x180000, 0x80000, CRC(cfc0e7a8) SHA1(31ed58451c7a6ac88a8fccab369167694698f044) )
	ROM_LOAD16_WORD_SWAP( "c67.p5", 0x200000, 0x80000, CRC(5feb8b20) SHA1(13c79c9b72c3abf0a0b75d507d91ece71e460c06) )
	ROM_LOAD16_WORD_SWAP( "c67.p6", 0x280000, 0x80000, CRC(6eb6d412) SHA1(c858fec9c1dfea70dfcca629c1c24306f8ae6d81) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2al.key",   0x00, 0x14, CRC(2904963e) SHA1(f4fa44646746ab4c6f2e76eaba57a7aee32e2933) )
ROM_END

ROM_START( sfz2als13 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s13.p1", 0x000000, 0x80000, CRC(c6919918) SHA1(d599bce464b8be26ce11bf6264bdd1528a83b7d3) )
	ROM_LOAD16_WORD_SWAP( "c67.p2", 0x080000, 0x80000, CRC(ae8ec36e) SHA1(b2f3de9e33169f6266aaabd5eae6c057ea10dcab) )
	ROM_LOAD16_WORD_SWAP( "c67.p3", 0x100000, 0x80000, CRC(f053a55e) SHA1(f98a8af5cd33a543a5596d59381f9adafed38854) )
	ROM_LOAD16_WORD_SWAP( "c67.p4", 0x180000, 0x80000, CRC(cfc0e7a8) SHA1(31ed58451c7a6ac88a8fccab369167694698f044) )
	ROM_LOAD16_WORD_SWAP( "c67.p5", 0x200000, 0x80000, CRC(5feb8b20) SHA1(13c79c9b72c3abf0a0b75d507d91ece71e460c06) )
	ROM_LOAD16_WORD_SWAP( "c67.p6", 0x280000, 0x80000, CRC(6eb6d412) SHA1(c858fec9c1dfea70dfcca629c1c24306f8ae6d81) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2al.key",   0x00, 0x14, CRC(2904963e) SHA1(f4fa44646746ab4c6f2e76eaba57a7aee32e2933) )
ROM_END

ROM_START( sfz2als14 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s14.p1", 0x000000, 0x80000, CRC(450ea3a1) SHA1(957f0e597e80de3f18663c1fd973f707d436c039) )
	ROM_LOAD16_WORD_SWAP( "c67.p2", 0x080000, 0x80000, CRC(ae8ec36e) SHA1(b2f3de9e33169f6266aaabd5eae6c057ea10dcab) )
	ROM_LOAD16_WORD_SWAP( "c67.p3", 0x100000, 0x80000, CRC(f053a55e) SHA1(f98a8af5cd33a543a5596d59381f9adafed38854) )
	ROM_LOAD16_WORD_SWAP( "c67.p4", 0x180000, 0x80000, CRC(cfc0e7a8) SHA1(31ed58451c7a6ac88a8fccab369167694698f044) )
	ROM_LOAD16_WORD_SWAP( "c67.p5", 0x200000, 0x80000, CRC(5feb8b20) SHA1(13c79c9b72c3abf0a0b75d507d91ece71e460c06) )
	ROM_LOAD16_WORD_SWAP( "c67.p6", 0x280000, 0x80000, CRC(6eb6d412) SHA1(c858fec9c1dfea70dfcca629c1c24306f8ae6d81) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2al.key",   0x00, 0x14, CRC(2904963e) SHA1(f4fa44646746ab4c6f2e76eaba57a7aee32e2933) )
ROM_END

ROM_START( sfz2als15 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s15.p1", 0x000000, 0x80000, CRC(b2d81a68) SHA1(f59d1417fed645d1b4edec47195cf2e85d1c4fc4) )
	ROM_LOAD16_WORD_SWAP( "c67j.p2", 0x080000, 0x80000, CRC(e7ca87c7) SHA1(e44c930b27431dd2b983d93471a440d292e7a8bb) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als16 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s16.p1", 0x000000, 0x80000, CRC(d6493cc5) SHA1(b7123783b9f77a0ec2e995b599a96f291b178c95) )
	ROM_LOAD16_WORD_SWAP( "c67s16.p2", 0x080000, 0x80000, CRC(a3f56672) SHA1(7351929b857b710a658a0be7c9fb82edca89ddfe) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als17 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s17.p1", 0x000000, 0x80000, CRC(67bc6f45) SHA1(d810865d890fc7830078e5dc13002f4447a0b3ea) )
	ROM_LOAD16_WORD_SWAP( "c67s17.p2", 0x080000, 0x80000, CRC(b124800a) SHA1(560e708e1296ac3e7e6b74bee99a152a0d1f6894) )
	ROM_LOAD16_WORD_SWAP( "c67j.p3", 0x100000, 0x80000, CRC(c88ebf88) SHA1(e37cf232fc70b9a3254dea99754e288232f04e25) )
	ROM_LOAD16_WORD_SWAP( "c67j.p4", 0x180000, 0x80000, CRC(35ed5b7a) SHA1(b03cb92f594eb35fa374445f74930e9040a2baff) )
	ROM_LOAD16_WORD_SWAP( "c67j.p5", 0x200000, 0x80000, CRC(975dcb3e) SHA1(a2ca8e5a768e49cce9e2137ec0dcba9337ed2ad5) )
	ROM_LOAD16_WORD_SWAP( "c67j.p6", 0x280000, 0x80000, CRC(dc73f2d7) SHA1(09fa10e7d1ff5f0dac87a6cf3d66730e3ab9ad25) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c64.c1",   0x0000000, 0x400000, CRC(4d1f1f22) SHA1(659fb4305bcf0cbbbbec97ede6e68a8323b13308) )
	ROM_LOAD64_WORD( "c64.c2",   0x0000002, 0x400000, CRC(19cea680) SHA1(4cb88963a0fbcef191c8419b6379387c01b4c81e) )
	ROM_LOAD64_WORD( "c64.c3",   0x0000004, 0x400000, CRC(e01b4588) SHA1(c2936608fd75ff6cd5fa94c6d6d6f0c77c44a450) )
	ROM_LOAD64_WORD( "c64.c4",   0x0000006, 0x400000, CRC(0feeda64) SHA1(f5b350601437bd94b70d97feb23d791df19da6b3) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",   0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",   0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2alj.key",  0x00, 0x14, CRC(4c42320f) SHA1(0fabdab677416c5a8060526d997e6f80b26f9bb3) )
ROM_END

ROM_START( sfz2als18 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c67s18.p1", 0x000000, 0x80000, CRC(0e8e719b) SHA1(ef013adf386925c68f3d38159adfe447c8f259de) )
	ROM_LOAD16_WORD_SWAP( "c67s18.p2", 0x080000, 0x80000, CRC(bc7271a0) SHA1(601a0e21926a1d9aebebf41e6dc08523b6773338) )
	ROM_LOAD16_WORD_SWAP( "c67s18.p3", 0x100000, 0x80000, CRC(e19eee58) SHA1(f0a2f8606136450c375d9b43f182e4cee2ec1208) )
	ROM_LOAD16_WORD_SWAP( "c67.p4",  0x180000, 0x80000, CRC(cfc0e7a8) SHA1(31ed58451c7a6ac88a8fccab369167694698f044) )
	ROM_LOAD16_WORD_SWAP( "c67.p5",  0x200000, 0x80000, CRC(5feb8b20) SHA1(13c79c9b72c3abf0a0b75d507d91ece71e460c06) )
	ROM_LOAD16_WORD_SWAP( "c67.p6",  0x280000, 0x80000, CRC(6eb6d412) SHA1(c858fec9c1dfea70dfcca629c1c24306f8ae6d81) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c67s18.c1", 0x0000000, 0x400000, CRC(a3b979fe) SHA1(236378162562aea3e522a182bbf395b020452893) )
	ROM_LOAD64_WORD( "c67s18.c2", 0x0000002, 0x400000, CRC(ab0e6693) SHA1(6f00bdf5064fb1cb2e152c2731d26a11cd8bf376) )
	ROM_LOAD64_WORD( "c67s18.c3", 0x0000004, 0x400000, CRC(ce0913ba) SHA1(684c402c7ca1e50018ef439331b5bd002f573db8) )
	ROM_LOAD64_WORD( "c67s18.c4", 0x0000006, 0x400000, CRC(3c8cffe6) SHA1(26d4ed4a20a4e84b8c87c7120b181371e428ad58) )
	ROM_LOAD64_WORD( "c64.c5",   0x1000000, 0x100000, CRC(0560c6aa) SHA1(f2bed3a8efef18052b51a7f0f6a888a18db813a1) )
	ROM_LOAD64_WORD( "c64.c6",   0x1000002, 0x100000, CRC(ae940f87) SHA1(39ee26333abbe302ba76dced0196a2e6b3b1d02a) )
	ROM_LOAD64_WORD( "c64.c7",   0x1000004, 0x100000, CRC(4bc3c8bc) SHA1(6256963c515bf56f39b6e559afefd653ead56c54) )
	ROM_LOAD64_WORD( "c64.c8",   0x1000006, 0x100000, CRC(39e674c0) SHA1(8e771a2d8c2accad0463bccd21d7b23af0c895a1) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c64.m1",  0x00000, 0x08000, CRC(1bc323cf) SHA1(83fbd6e9b327700dc9f1c59700b7385bc3705749) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c64.m2",  0x28000, 0x20000, CRC(ba6a5013) SHA1(7814f3e56b69529b9860dd61c3b1e8d700244b03) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c64.q1",   0x000000, 0x200000, CRC(aa47a601) SHA1(a4d1ee89c84a3b9db06469bb66e85293b5aa9ac9) )
	ROM_LOAD16_WORD_SWAP( "c64.q2",   0x200000, 0x200000, CRC(2237bc53) SHA1(96d5693047e4cf1ed10a8ee1905cea267a278e92) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz2al.key",   0x00, 0x14, CRC(2904963e) SHA1(f4fa44646746ab4c6f2e76eaba57a7aee32e2933) )
ROM_END

 /***********
 Rockman 2
*************/
ROM_START( rockman2k )
	ROM_REGION(CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c66k.p1", 0x000000, 0x80000, CRC(6ba5e8d2) SHA1(73d925dee1fc3f910b13525703784a19045dd42a) )
	ROM_LOAD16_WORD_SWAP( "c66k.p2", 0x080000, 0x80000, CRC(211105c9) SHA1(72f83c58a2729e7a6d1a469c6bbc8236d722181a) )
	ROM_LOAD16_WORD_SWAP( "c66.p3",  0x100000, 0x80000, CRC(02ee9efc) SHA1(1b80c40389b51a03b930051f232630616c12e6c5) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c66k.c1",  0x800000, 0x200000, CRC(712ccd27) SHA1(45fa1380fb9f11624369b3d478713e8319f32322) )
	ROM_LOAD64_WORD( "c66k.c2",  0x800002, 0x200000, CRC(ba4cc30b) SHA1(75b2697de7891c66c64285cb12e1b28af5aec668) )
	ROM_LOAD64_WORD( "c66k.c3",  0x800004, 0x200000, CRC(53cb1a05) SHA1(91a34006d63c5d8c28ea1df15470abab45c69834) )
	ROM_LOAD64_WORD( "c66k.c4",  0x800006, 0x200000, CRC(7b019f2c) SHA1(cfbb1dbbca954a9d33d5b53e406c24316018b2be) )

	ROM_REGION(QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c66.m1",  0x00000, 0x08000, CRC(d18e7859) SHA1(0939fac70042d0b4db5c2fdcef1f79b95febd45e) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c66.m2",   0x28000, 0x20000, CRC(c463ece0) SHA1(5c3e41eb61610b3f8c431206f6672907e3a0bdb0) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c66.q1",   0x000000, 0x200000, CRC(2106174d) SHA1(0a35d9ca8ebcad74904b20648d5320f839d6377e) )
	ROM_LOAD16_WORD_SWAP( "c66.q2",   0x200000, 0x200000, CRC(546c1636) SHA1(f96b172ab899f2c6ee17a5dd1fb61af9432e3cd2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "rockman2j.key", 0x00, 0x14, CRC(c590187a) SHA1(f9140da0849711938c4d8a98fb38bc1504582a43) )
ROM_END


 /************************
 X-Men Vs. Street Fighter
***************************/
ROM_START( xmvsfs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.p1",   0x000000, 0x80000, CRC(db06413f) SHA1(c6d8aa1e43fc541e5b4e938258f27ab9ee30ca33) )
	ROM_LOAD16_WORD_SWAP( "c69.p2",   0x080000, 0x80000, CRC(ef015aef) SHA1(d3504cb8c38f720b1f4528157266db60c8c6c075) )
	ROM_LOAD16_WORD_SWAP( "c69s01.p3",  0x100000, 0x80000, CRC(ecd29e92) SHA1(047eedbca18f33a0f77937e8d2ba972092a05b98) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsf.key",    0x00, 0x14, CRC(d5c07311) SHA1(1b401ffc241436c4869486c174774b67e3bf3df8) )
ROM_END

ROM_START( xmvsfs02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69s02.p1", 0x000000, 0x80000, CRC(55eadea0) SHA1(4ebceb04ccd0bb7ccd99d4f8ff0e88a661425944) )
	ROM_LOAD16_WORD_SWAP( "c69r1.p2", 0x080000, 0x80000, CRC(5eb9c02e) SHA1(25a392913213b98ce1bbd463bf5e5e10729bde0c) )
	ROM_LOAD16_WORD_SWAP( "c69s02.p3",  0x100000, 0x80000, CRC(6b12c0d9) SHA1(0b7bb7fd0d9b080aef675463de1065efcb4a3309) )
	ROM_IGNORE( 0x3D4F52 )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsf.key",    0x00, 0x14, CRC(d5c07311) SHA1(1b401ffc241436c4869486c174774b67e3bf3df8) )
ROM_END

ROM_START( xmvsfs03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69s03.p1", 0x000000, 0x80000, CRC(ec5c1f37) SHA1(7c2b859f4c73aa5dbf59836319a7e639ab31b914) )
	ROM_LOAD16_WORD_SWAP( "c69r1.p2", 0x080000, 0x80000, CRC(5eb9c02e) SHA1(25a392913213b98ce1bbd463bf5e5e10729bde0c) )
	ROM_LOAD16_WORD_SWAP( "c69.p3",   0x100000, 0x80000, CRC(7db6025d) SHA1(2d74f48f83f45359bfaca28ab686625766af12ee) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsf.key",    0x00, 0x14, CRC(d5c07311) SHA1(1b401ffc241436c4869486c174774b67e3bf3df8) )
ROM_END

ROM_START( xmvsfs04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69s04.p1", 0x000000, 0x80000, CRC(ace532fc) SHA1(01a105c01be2c2beb4b50734810333769b8b8a4f) )
	ROM_LOAD16_WORD_SWAP( "c69jr1.p2",  0x080000, 0x80000, CRC(70a59b35) SHA1(786d9b243373024735848f785503c6aa883b1c2f) )
	ROM_LOAD16_WORD_SWAP( "c69.p3",  0x100000, 0x80000, CRC(7db6025d) SHA1(2d74f48f83f45359bfaca28ab686625766af12ee) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsfj.key",   0x00, 0x14, CRC(87576cda) SHA1(65905400f4462c175baa93b43e015e8596def31b) )
ROM_END

ROM_START( xmvsfs05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69js05.p1",  0x000000, 0x80000, CRC(1d46fdba) SHA1(fceec89ca0fa163b0edc8e055a6c7198f3520851) )
	ROM_LOAD16_WORD_SWAP( "c69jr1.p2",  0x080000, 0x80000, CRC(70a59b35) SHA1(786d9b243373024735848f785503c6aa883b1c2f) )
	ROM_LOAD16_WORD_SWAP( "c69.p3",  0x100000, 0x80000, CRC(7db6025d) SHA1(2d74f48f83f45359bfaca28ab686625766af12ee) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsfj.key",   0x00, 0x14, CRC(87576cda) SHA1(65905400f4462c175baa93b43e015e8596def31b) )
ROM_END

ROM_START( xmvsfs06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69s06.p1", 0x000000, 0x80000, CRC(be94fd2b) SHA1(f668d8fe1932434dfb9aec865a79ddac6c6496ef) )
	ROM_LOAD16_WORD_SWAP( "c69r1.p2", 0x080000, 0x80000, CRC(5eb9c02e) SHA1(25a392913213b98ce1bbd463bf5e5e10729bde0c) )
	ROM_LOAD16_WORD_SWAP( "c69.p3",  0x100000, 0x80000, CRC(7db6025d) SHA1(2d74f48f83f45359bfaca28ab686625766af12ee) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsf.key",    0x00, 0x14, CRC(d5c07311) SHA1(1b401ffc241436c4869486c174774b67e3bf3df8) )
ROM_END

ROM_START( xmvsfs07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c69s07.p1", 0x000000, 0x80000, CRC(ed7c235a) SHA1(c49bfeef0351165ee30c8433feb026acebd7a36a) )
	ROM_LOAD16_WORD_SWAP( "c69s07.p2", 0x080000, 0x80000, CRC(3a527f69) SHA1(72312d4aeaac07c4b4f91a0301948faf2f17d74d) )
	ROM_LOAD16_WORD_SWAP( "c69.p3",  0x100000, 0x80000, CRC(7db6025d) SHA1(2d74f48f83f45359bfaca28ab686625766af12ee) )
	ROM_LOAD16_WORD_SWAP( "c69.p4",   0x180000, 0x80000, CRC(e8e2c75c) SHA1(929408cb5d98e95cec75ea58e4701b0cbdbcd016) )
	ROM_LOAD16_WORD_SWAP( "c69.p5",   0x200000, 0x80000, CRC(08f0abed) SHA1(ef16c376232dba63b0b9bc3aa0640f9001ccb68a) )
	ROM_LOAD16_WORD_SWAP( "c69.p6",   0x280000, 0x80000, CRC(81929675) SHA1(19cf7afbc1daaefec40195e40ba74970f3906a1c) )
	ROM_LOAD16_WORD_SWAP( "c69.p7",   0x300000, 0x80000, CRC(9641f36b) SHA1(dcba3482d1ba37ccfb30d402793ee063c6621aed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c69.c1",   0x0000000, 0x400000, CRC(f6684efd) SHA1(c0a2f3a9e82ab8b084a500aec71ac633e947328c) )
	ROM_LOAD64_WORD( "c69.c2",   0x0000002, 0x400000, CRC(29109221) SHA1(898b8f678fd03c462ce0d8eb7fb3441ef601085b) )
	ROM_LOAD64_WORD( "c69.c3",   0x0000004, 0x400000, CRC(92db3474) SHA1(7b6f4c8ebfdac167b25f35029068b6253c141fe6) )
	ROM_LOAD64_WORD( "c69.c4",   0x0000006, 0x400000, CRC(3733473c) SHA1(6579da7145c95b3ad00844a5fc8c2e22c23365e2) )
	ROM_LOAD64_WORD( "c69.c5",   0x1000000, 0x400000, CRC(bcac2e41) SHA1(838ff24f7e8543a787a55a5d592c9517ce3b8b93) )
	ROM_LOAD64_WORD( "c69.c6",   0x1000002, 0x400000, CRC(ea04a272) SHA1(cd7c79037b5b4a39bef5156433e984dc4dc2c081) )
	ROM_LOAD64_WORD( "c69.c7",   0x1000004, 0x400000, CRC(b0def86a) SHA1(da3a6705ea7050fc5c2c10d33400ed67be9f455d) )
	ROM_LOAD64_WORD( "c69.c8",   0x1000006, 0x400000, CRC(4b40ff9f) SHA1(9a981d442132efff09a27408d74646ba357c7357) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c69.m1",   0x00000, 0x08000, CRC(3999e93a) SHA1(fefcff8a9a5c83df7655a16187cf9ba3e7efbb25) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c69.m2",   0x28000, 0x20000, CRC(101bdee9) SHA1(75920e88bf46fcd33a7957777a1d799818ffb0d6) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c69.q1",   0x000000, 0x200000, CRC(9cadcdbc) SHA1(64d3bd53b04daec84c9af4aa3ff010867b3d306d) )
	ROM_LOAD16_WORD_SWAP( "c69.q2",   0x200000, 0x200000, CRC(7b11e460) SHA1(a581c84acaaf0ce056841c15a6f36889e88be68d) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "xmvsf.key",    0x00, 0x14, CRC(d5c07311) SHA1(1b401ffc241436c4869486c174774b67e3bf3df8) )
ROM_END

 /***************
 Battle Circuit
******************/
ROM_START( batcirs01 ) //batcird
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c70s01.p1", 0x000000, 0x80000, CRC(03bd6707) SHA1(62eda0d68b9940f5d07a529d05e8c90fe6a8ad02) )
	ROM_LOAD16_WORD_SWAP( "c70s01.p2", 0x080000, 0x80000, CRC(c3ff82b6) SHA1(3b23b13e0588479a598dd43093a42cd0c9db1484) )
	ROM_LOAD16_WORD_SWAP( "c70d.p3", 0x100000, 0x80000, CRC(20bdbb14) SHA1(fe3a202741ca657b2b67e89050788b67d709a36d) )
	ROM_LOAD16_WORD_SWAP( "c70d.p4", 0x180000, 0x80000, CRC(b4d8f5bc) SHA1(dc5ca580ecfb051ded551663ea4e9f161f820f81) )
	ROM_LOAD16_WORD_SWAP( "c70s01.p5",   0x200000, 0x80000, CRC(b194270f) SHA1(e152d48760c92b84c748014ef68050f138f75cf5) )
	ROM_LOAD16_WORD_SWAP( "c70.p6",   0x280000, 0x80000, CRC(6aac85ab) SHA1(ad02d4185c2b3664fb96350d8ad317d3939a7554) )
	ROM_LOAD16_WORD_SWAP( "c70s01.p7",   0x300000, 0x80000, CRC(31865161) SHA1(2217a4b8ca1ed3fe52e9b9d4ead85ce7df3a6bf9) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c70.c1",   0x000000, 0x400000, CRC(dc705bad) SHA1(96e37147674bf9cd21c770897da59daac25d921a) )
	ROM_LOAD64_WORD( "c70.c2",   0x000002, 0x400000, CRC(e5779a3c) SHA1(bbd7fbe061e751388d2f02434144daf9b1e36640) )
	ROM_LOAD64_WORD( "c70.c3",   0x000004, 0x400000, CRC(b33f4112) SHA1(e501fd921c8bcede69946b029e05d422714c1040) )
	ROM_LOAD64_WORD( "c70.c4",   0x000006, 0x400000, CRC(a6fcdb7e) SHA1(7a28d5d7aa036d23d97fad17d0cdb8210dc8153a) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c70.m1",   0x00000, 0x08000, CRC(1e194310) SHA1(3b29de0aca9dbca59d6b50fb2509e2a913c6b0af) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c70.m2",   0x28000, 0x20000, CRC(01aeb8e6) SHA1(50a5d1cce0caf7c5143d4904431e8f41e2a57464) )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c70.q1",   0x000000, 0x200000, CRC(c27f2229) SHA1(df2459493af40937b6656a16fad43ff51bed2204) )
	ROM_LOAD16_WORD_SWAP( "c70.q2",   0x200000, 0x200000, CRC(418a2e33) SHA1(0642ddff2ab9255f154419da24ba644ed63f34ab) )
ROM_END

 /**************************************
 Marvel Super Heroes Vs. Street Fighter
*****************************************/
ROM_START( mshvsfs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s01.p1", 0x000000, 0x80000, CRC(3be3833c) SHA1(e5b3cc594e757772e94065c3cfd6e7c2ab021a71) )
	ROM_LOAD16_WORD_SWAP( "c72.p2", 0x080000, 0x80000, CRC(6ef799f9) SHA1(2d45dbf7bc277b84c6bcd9615ab3b80c42af7781) )
	ROM_LOAD16_WORD_SWAP( "c72s01.p3",  0x100000, 0x80000, CRC(66083ebc) SHA1(909ed753af95d000a872eec764d1e1a01abf1a28) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsf.key",   0x00, 0x14, CRC(64660867) SHA1(448eb440494c971800370f103b4d1f21a7266c6c) )
ROM_END

ROM_START( mshvsfs02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s02.p1", 0x000000, 0x80000, CRC(9da5d269) SHA1(4661105b3f3c3d36a4900da3e19db6079a0c08ed) )
	ROM_LOAD16_WORD_SWAP( "c72.p2", 0x080000, 0x80000, CRC(6ef799f9) SHA1(2d45dbf7bc277b84c6bcd9615ab3b80c42af7781) )
	ROM_LOAD16_WORD_SWAP( "c72.p3",  0x100000, 0x80000, CRC(1a5de0cb) SHA1(738a27f83704c208d36d73bf766d861ef2d51a89) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsf.key",   0x00, 0x14, CRC(64660867) SHA1(448eb440494c971800370f103b4d1f21a7266c6c) )
ROM_END

ROM_START( mshvsfs03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s03.p1", 0x000000, 0x80000, CRC(bdf7b172) SHA1(a3449a6ca319d40bcbab0de29ecb1b91afc2203d) )
	ROM_LOAD16_WORD_SWAP( "c72j.p2", 0x080000, 0x80000, CRC(32741ace) SHA1(36db3a3aeaf29369977593c051bf5665cffefb2d) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

ROM_START( mshvsfs04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s04.p1", 0x000000, 0x80000, CRC(c077afa4) SHA1(97b234825f47e3c1bc66ddd343b4b68c7ff45d15) )
	ROM_LOAD16_WORD_SWAP( "c72jh.p2", 0x080000, 0x80000, CRC(6031012f) SHA1(8905d52110f5c9da35ce4ec497c48ec73eb35e13) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

ROM_START( mshvsfs05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s05.p1", 0x000000, 0x80000, CRC(025f3d98) SHA1(fa2051f5c8185f8d26dbc8e7714d8a2c3a5625bd) )
	 ROM_IGNORE( 0x3D4F48 )
	ROM_LOAD16_WORD_SWAP( "c72jh.p2", 0x080000, 0x80000, CRC(6031012f) SHA1(8905d52110f5c9da35ce4ec497c48ec73eb35e13) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

ROM_START( mshvsfs06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s06.p1", 0x000000, 0x80000, CRC(86672cbb) SHA1(7dc683ed8cf5bc205851375deab0438a1105d581) )
	ROM_LOAD16_WORD_SWAP( "c72j.p2", 0x080000, 0x80000, CRC(32741ace) SHA1(36db3a3aeaf29369977593c051bf5665cffefb2d) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

ROM_START( mshvsfs07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s07.p1", 0x000000, 0x80000, CRC(54ecd389) SHA1(be6d34587de852d93d575f7d1e5001e43f4be9e9) )
	ROM_LOAD16_WORD_SWAP( "c72jh.p2", 0x080000, 0x80000, CRC(6031012f) SHA1(8905d52110f5c9da35ce4ec497c48ec73eb35e13) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

ROM_START( mshvsfs08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c72s08.p1", 0x000000, 0x80000, CRC(4c50cabc) SHA1(6139e3974d83fb4220aca84fa0ac6adcf23f45a5) )
	ROM_LOAD16_WORD_SWAP( "c72j.p2", 0x080000, 0x80000, CRC(32741ace) SHA1(36db3a3aeaf29369977593c051bf5665cffefb2d) )
	ROM_LOAD16_WORD_SWAP( "c72j.p3",  0x100000, 0x80000, CRC(77870dc3) SHA1(924a7c82456bb44d7b0be65af11dbe1a2420a3f0) )
	ROM_LOAD16_WORD_SWAP( "c72.p4",  0x180000, 0x80000, CRC(959f3030) SHA1(fbbaa915324815246738f3426232e623f039ce26) )
	ROM_LOAD16_WORD_SWAP( "c72.p5",  0x200000, 0x80000, CRC(7f915bdb) SHA1(683da09c5ba55e31b59aa95a8e13c45dc574ab3c) )
	ROM_LOAD16_WORD_SWAP( "c72.p6",  0x280000, 0x80000, CRC(c2813884) SHA1(49e5d4bc48f90c8146cb6aafb9240aff0119f1a7) )
	ROM_LOAD16_WORD_SWAP( "c72.p7",  0x300000, 0x80000, CRC(3ba08818) SHA1(9ab132a3cac55fcccebe6c99b6fb0ba1305f8f6e) )
	ROM_LOAD16_WORD_SWAP( "c72.p8",  0x380000, 0x80000, CRC(cf0dba98) SHA1(f4c1f8a6e7a79ecc6241d5268b3039f8a09ea516) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c72.c1",   0x0000000, 0x400000, CRC(29b05fd9) SHA1(e8fdb1ee5515a560eb4256ae4fd99bb1192e1a87) )
	ROM_LOAD64_WORD( "c72.c2",   0x0000002, 0x400000, CRC(faddccf1) SHA1(4ed03ea91883a0413325f57edcc1614120b5922c) )
	ROM_LOAD64_WORD( "c72.c3",   0x0000004, 0x400000, CRC(97aaf4c7) SHA1(6a054921cc14fe080cb3f62c391f8ae3cc7e8ba9) )
	ROM_LOAD64_WORD( "c72.c4",   0x0000006, 0x400000, CRC(cb70e915) SHA1(da4d2480d348ac6dfd01256a88f4f3db8357ae46) )
	ROM_LOAD64_WORD( "c72.c5",   0x1000000, 0x400000, CRC(b3b1972d) SHA1(0f2c3fb7de014181ee481ec35d0578b2c116c2dc) )
	ROM_LOAD64_WORD( "c72.c6",   0x1000002, 0x400000, CRC(08aadb5d) SHA1(3a2c222eca3e7df80ce69951b3db6442312751a4) )
	ROM_LOAD64_WORD( "c72.c7",   0x1000004, 0x400000, CRC(c1228b35) SHA1(7afdfb552888c79d0fbb30242b3d917b87fad57a) )
	ROM_LOAD64_WORD( "c72.c8",   0x1000006, 0x400000, CRC(366cc6c2) SHA1(6f2a789087c8e404c5227b927fa8328c03593243) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c72.m1",   0x00000, 0x08000, CRC(68252324) SHA1(138ef320ef27956b2ab5591d49a1315b7b0a194c) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c72.m2",   0x28000, 0x20000, CRC(b34e773d) SHA1(3bcf44bf06c35814cff29d244142db7abe05bd39) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c72.q1",   0x000000, 0x400000, CRC(86219770) SHA1(4e5b68d382a5aa37f8b0b6434c53a2b95f5f9a4d) )
	ROM_LOAD16_WORD_SWAP( "c72.q2",   0x400000, 0x400000, CRC(f2fd7f68) SHA1(28a30d55d3eaf963006c7cbe7c288099cd3ba536) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mshvsfj.key",  0x00, 0x14, CRC(565eeebb) SHA1(762844b59b2fcf529a26ad3dde8282415db926b3) )
ROM_END

 /******************
 Capcom Sports Club
*********************/
ROM_START( csclub01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c73s01.p1", 0x000000, 0x80000, CRC(383d9a0d) SHA1(8704eb52634a5d68606c07ae89382a31e342fcf4) )
	ROM_LOAD16_WORD_SWAP( "c73e.p2",   0x080000, 0x80000, CRC(74e6a4fe) SHA1(2a732a6e57088885e77256eb17ddd3ae523db09f) )
	ROM_LOAD16_WORD_SWAP( "c73e.p3",   0x100000, 0x80000, CRC(8ae0df19) SHA1(88e7bf1ee0e18d74748cecd875cb96524dfa01cf) )
	ROM_LOAD16_WORD_SWAP( "c73s01.p4", 0x180000, 0x80000, CRC(58e187c9) SHA1(f0857e4e62f26f4040da653bac9da6d3582e6283) )
	ROM_LOAD16_WORD_SWAP( "c73e.p5",   0x200000, 0x80000, CRC(003968fd) SHA1(95f59a29a404a1c1e86d5f43526a80aa97f25621) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c73.c01",  0x800000, 0x080000, CRC(335f07c3) SHA1(44e0385120e2c81fd1072e19b7e3ff05d42be226) )
	ROM_LOAD64_WORD( "c73.c02",  0x800002, 0x080000, CRC(3711b8ca) SHA1(ff7ba4f73d227212377327f4fcbe8f555ac4b9c9) )
	ROM_LOAD64_WORD( "c73.c03",  0x800004, 0x080000, CRC(0750d12a) SHA1(4c36cba88c58bdbfed923f56a6d489f42a4d0f6e) )
	ROM_LOAD64_WORD( "c73.c04",  0x800006, 0x080000, CRC(a756c7f7) SHA1(d0f44f8ded12291d5c79282eac45d088cb365b09) )
	ROM_LOAD64_WORD( "c73.c05",  0xa00000, 0x080000, CRC(ab215357) SHA1(c2600b5ba62a570f8a32de9c06f93ea8ae6cd854) )
	ROM_LOAD64_WORD( "c73.c06",  0xa00002, 0x080000, CRC(828a06d8) SHA1(ce1d147f1d747fcd90d93f7dcca0cdd24c85a971) )
	ROM_LOAD64_WORD( "c73.c07",  0xa00004, 0x080000, CRC(90a92f39) SHA1(75bef2440147bac417b48d61ff64b71ed5b9eb67) )
	ROM_LOAD64_WORD( "c73.c08",  0xa00006, 0x080000, CRC(fb7ccc73) SHA1(763e6fe1baf73341747c74d89df9443561fca4fa) )
	ROM_LOAD64_WORD( "c73.c09",  0xc00000, 0x080000, CRC(a2367381) SHA1(49d562be42c10cdf4e55e3b76c388f0b0121a967) )
	ROM_LOAD64_WORD( "c73.c10",  0xc00002, 0x080000, CRC(86ee4569) SHA1(725d82a1669f6f78fb4ef8756ceac8b444dcbd43) )
	ROM_LOAD64_WORD( "c73.c11",  0xc00004, 0x080000, CRC(d08ab012) SHA1(7f2e71b6bd85c6a3efbd417977261c21f3d6cb7c) )
	ROM_LOAD64_WORD( "c73.c12",  0xc00006, 0x080000, CRC(4d014297) SHA1(df172a3723793b9955ff1f65e76fe5c20fc37b89) )
	ROM_LOAD64_WORD( "c73.c13",  0xe00000, 0x080000, CRC(728aac1f) SHA1(2d04e8803f41af2372fc342fcd8a076c14338198) )
	ROM_LOAD64_WORD( "c73.c14",  0xe00002, 0x080000, CRC(c24f577f) SHA1(d3b97091e1f0171e087feb9d497c94a48872cd21) )
	ROM_LOAD64_WORD( "c73.c15",  0xe00004, 0x080000, CRC(41652583) SHA1(7132647dc9a29ce98866f489140703c5ed3d6051) )
	ROM_LOAD64_WORD( "c73.c16",  0xe00006, 0x080000, CRC(6754b1ef) SHA1(ab5d62056b19999ccecd0eeec7b7c5869ca8fea8) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c73.m1",   0x00000, 0x08000, CRC(ee162111) SHA1(ce8d4bd32bb10ee8b0274ba6fcef05a583b39d48) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c73e.q1",   0x000000, 0x080000, CRC(5a52afd5) SHA1(ab873ec556933b75be82ba249357cceb01a7a0bd) )
	ROM_LOAD16_WORD_SWAP( "c73e.q2",   0x080000, 0x080000, CRC(1408a811) SHA1(1d31e3cd505245b5ff4d3c55d5fa7017c0f1e168) )
	ROM_LOAD16_WORD_SWAP( "c73e.q3",   0x100000, 0x080000, CRC(4fb9f57c) SHA1(093e8e3a03b62783a84fe4ae239e9eb46cbfd71e) )
	ROM_LOAD16_WORD_SWAP( "c73e.q4",   0x180000, 0x080000, CRC(9a8f40ec) SHA1(c8db1ecfd6b08e9c83ae53a1d25c1387ab95535c) )
	ROM_LOAD16_WORD_SWAP( "c73e.q5",   0x200000, 0x080000, CRC(91529a91) SHA1(183569100ae98e17688e0e25932850e73a41eb88) )
	ROM_LOAD16_WORD_SWAP( "c73e.q6",   0x280000, 0x080000, CRC(9a345334) SHA1(330291400a73215c9797457507a86c90ba415247) )
	ROM_LOAD16_WORD_SWAP( "c73e.q7",   0x300000, 0x080000, CRC(aedc27f2) SHA1(55137f0f22c4823558e6a8ba76011695579a4f1f) )
	ROM_LOAD16_WORD_SWAP( "c73e.q8",   0x380000, 0x080000, CRC(2300b7b3) SHA1(f5ecbb45c24f7de1c1aa435870695551d4e343ca) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "csclub.key",   0x00, 0x14, CRC(903907d7) SHA1(d70384b64637dbbcc064d39f984f73fc48bbac44) )
ROM_END

ROM_START( csclub02 )  // Says Korea on the boot screen, but there's no Korean text in the game
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c73s02.p1", 0x000000, 0x80000, CRC(b146e8db) SHA1(a855b544e9eb19ece781debd560e73096c5a28af) )
	ROM_LOAD16_WORD_SWAP( "c73j.p2", 0x080000, 0x80000, CRC(60c632bb) SHA1(0d42c33aa476d2cc4efcdad78667353b88225966) )
	ROM_LOAD16_WORD_SWAP( "c73j.p3", 0x100000, 0x80000, CRC(ad042003) SHA1(1e167c88f3b0617c38c9f43bdc816045ac0296e0) )
	ROM_LOAD16_WORD_SWAP( "c73j.p4", 0x180000, 0x80000, CRC(169e4d40) SHA1(6540d89df5e76189d32b696be7626087fe26e33b) )
	ROM_LOAD16_WORD_SWAP( "c73.p5",  0x200000, 0x80000, CRC(01b05caa) SHA1(5b84487da68e6b6f2889c76bf9e070e25941988c) )

	ROM_REGION( 0x1000000, "gfx", ROMREGION_ERASE00 )
	ROM_LOAD64_WORD( "c73s02.c1",  0x800000, 0x200000, CRC(bbc331b6) SHA1(ba771603a9c308ec72b2524649f53e46c3fc0018) )
	ROM_LOAD64_WORD( "c73s02.c2",  0x800002, 0x200000, CRC(6b3e7280) SHA1(c560d872d392992d7dce3908bc258f7bdc0fe1a9) )
	ROM_LOAD64_WORD( "c73s02.c3",  0x800004, 0x200000, CRC(df65f3ee) SHA1(2724b4772095430e59fa2c01279c32ea8ad59bd4) )
	ROM_LOAD64_WORD( "c73s02.c4",  0x800006, 0x200000, CRC(1ccb5969) SHA1(4f942837b1e5f053fd3d375713abfdb3a8a3045d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c73.m1",   0x00000, 0x08000, CRC(ee162111) SHA1(ce8d4bd32bb10ee8b0274ba6fcef05a583b39d48) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c73.q1",   0x000000, 0x200000, CRC(a027b827) SHA1(6d58a63efc7bd5d07353d9b55826c01a3c416c33) )
	ROM_LOAD16_WORD_SWAP( "c73.q2",   0x200000, 0x200000, CRC(cb7f6e55) SHA1(b64e6b663fd09e887d2dc0f4b545e88688c0af55) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "csclubj.key",  0x00, 0x14, CRC(519a04db) SHA1(8f792831dc7e07fb621806c4e320a047f801e9b8) )
ROM_END

 /**************
 Pocket Fighter
*****************/
ROM_START( sgemfs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c74u.p1", 0x000000, 0x80000, CRC(ac2e8566) SHA1(5975aae46bded231c0f478f40c7257434ade36b0) )
	ROM_LOAD16_WORD_SWAP( "c74.p2",  0x080000, 0x80000, CRC(f4314c96) SHA1(c40ed74039bf0096eb3648b7243a8e697638e0a6) )
	ROM_LOAD16_WORD_SWAP( "c74.p3",  0x100000, 0x80000, CRC(215655f6) SHA1(242c0f4401520f2a3b0deafc3a807b18b987e496) )
	ROM_LOAD16_WORD_SWAP( "c74.p4",  0x180000, 0x80000, CRC(ea6f13ea) SHA1(1bc924a8a9da1d2ad7667685cdb92fe317a39aba) )
	ROM_LOAD16_WORD_SWAP( "c74s01.p5", 0x200000, 0x80000, CRC(dcbe118c) SHA1(c571058180e1ad317eb3819a4701d4e40e7787f1) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c74.c1",   0x0000000, 0x400000, CRC(22d72ab9) SHA1(653efd95c34b4b9d2ab0d219f41a99ca84e12214) )
	ROM_LOAD64_WORD( "c74.c2",   0x0000002, 0x400000, CRC(16a4813c) SHA1(bf5fce6008214f353414d1b64bea4ed0c7673670) )
	ROM_LOAD64_WORD( "c74.c3",   0x0000004, 0x400000, CRC(1097e035) SHA1(4bd51e4e9447af27d2cac1f6d2201e37c949912b) )
	ROM_LOAD64_WORD( "c74.c4",   0x0000006, 0x400000, CRC(d362d874) SHA1(30c42af18440496cc05e4418e4efa41172ae4ced) )
	ROM_LOAD64_WORD( "c74.c5",   0x1000000, 0x100000, CRC(0383897c) SHA1(aba14afa1d0c971afcee4317f480e88117d77b5e) )
	ROM_LOAD64_WORD( "c74.c6",   0x1000002, 0x100000, CRC(76f91084) SHA1(3d1e32467f2aa5dd6fb96bd5c866ecc9691660fc) )
	ROM_LOAD64_WORD( "c74.c7",   0x1000004, 0x100000, CRC(756c3754) SHA1(be2f709b90222a567f198f851cf07ffb0ad433d7) )
	ROM_LOAD64_WORD( "c74.c8",   0x1000006, 0x100000, CRC(9ec9277d) SHA1(b7ceeaca30dfcdf498b61a6961f0aa1a068b8ec4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c74.m1",   0x00000, 0x08000, CRC(254e5f33) SHA1(c413ec0630b9bdd15e64f42893eba8958a09b573) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c74.m2",   0x28000, 0x20000, CRC(6902f4f9) SHA1(9bfe4ddade3c666076d26a2b545120f6d059fd7c) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c74.q1",   0x000000, 0x400000, CRC(a5dea005) SHA1(3ae79baf6ff5bd527f82b26f164c7e3c65423ae2) )
	ROM_LOAD16_WORD_SWAP( "c74.q2",   0x400000, 0x400000, CRC(4ce235fe) SHA1(795b94557e954cc0e45fd3778b609064d57a34a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sgemf.key",    0x00, 0x14, CRC(3d604021) SHA1(f6189a7dcdd110f4d624cddfe2e51e49c40a0fdb) )
ROM_END

ROM_START( pfghtj01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c74j01.p1", 0x000000, 0x80000, CRC(d042b7c4) SHA1(d8bc507445f01d15fe57413d26d24376f1889183) )
	ROM_LOAD16_WORD_SWAP( "c74.p2",  0x080000, 0x80000, CRC(f4314c96) SHA1(c40ed74039bf0096eb3648b7243a8e697638e0a6) )
	ROM_LOAD16_WORD_SWAP( "c74.p3",  0x100000, 0x80000, CRC(215655f6) SHA1(242c0f4401520f2a3b0deafc3a807b18b987e496) )
	ROM_LOAD16_WORD_SWAP( "c74.p4",  0x180000, 0x80000, CRC(ea6f13ea) SHA1(1bc924a8a9da1d2ad7667685cdb92fe317a39aba) )
	ROM_LOAD16_WORD_SWAP( "c74.p5",  0x200000, 0x80000, CRC(5ac6d5ea) SHA1(9ce8e4668b565658597a868830545fb75a5eeaa6) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c74.c1",   0x0000000, 0x400000, CRC(22d72ab9) SHA1(653efd95c34b4b9d2ab0d219f41a99ca84e12214) )
	ROM_LOAD64_WORD( "c74.c2",   0x0000002, 0x400000, CRC(16a4813c) SHA1(bf5fce6008214f353414d1b64bea4ed0c7673670) )
	ROM_LOAD64_WORD( "c74.c3",   0x0000004, 0x400000, CRC(1097e035) SHA1(4bd51e4e9447af27d2cac1f6d2201e37c949912b) )
	ROM_LOAD64_WORD( "c74.c4",   0x0000006, 0x400000, CRC(d362d874) SHA1(30c42af18440496cc05e4418e4efa41172ae4ced) )
	ROM_LOAD64_WORD( "c74.c5",   0x1000000, 0x100000, CRC(0383897c) SHA1(aba14afa1d0c971afcee4317f480e88117d77b5e) )
	ROM_LOAD64_WORD( "c74.c6",   0x1000002, 0x100000, CRC(76f91084) SHA1(3d1e32467f2aa5dd6fb96bd5c866ecc9691660fc) )
	ROM_LOAD64_WORD( "c74.c7",   0x1000004, 0x100000, CRC(756c3754) SHA1(be2f709b90222a567f198f851cf07ffb0ad433d7) )
	ROM_LOAD64_WORD( "c74.c8",   0x1000006, 0x100000, CRC(9ec9277d) SHA1(b7ceeaca30dfcdf498b61a6961f0aa1a068b8ec4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c74.m1",   0x00000, 0x08000, CRC(254e5f33) SHA1(c413ec0630b9bdd15e64f42893eba8958a09b573) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c74.m2",   0x28000, 0x20000, CRC(6902f4f9) SHA1(9bfe4ddade3c666076d26a2b545120f6d059fd7c) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c74.q1",   0x000000, 0x400000, CRC(a5dea005) SHA1(3ae79baf6ff5bd527f82b26f164c7e3c65423ae2) )
	ROM_LOAD16_WORD_SWAP( "c74.q2",   0x400000, 0x400000, CRC(4ce235fe) SHA1(795b94557e954cc0e45fd3778b609064d57a34a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "pfghtj.key",   0x00, 0x14, CRC(62297638) SHA1(efe090ffa8992823cfd787ade736df5487d69ca7) )
ROM_END

ROM_START( pfghtj02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c74j02.p1", 0x000000, 0x80000, CRC(69c221b2) SHA1(3dcccf804b572384f288abd1175fd284fcd452d7) )
	ROM_LOAD16_WORD_SWAP( "c74.p2",  0x080000, 0x80000, CRC(f4314c96) SHA1(c40ed74039bf0096eb3648b7243a8e697638e0a6) )
	ROM_LOAD16_WORD_SWAP( "c74.p3",  0x100000, 0x80000, CRC(215655f6) SHA1(242c0f4401520f2a3b0deafc3a807b18b987e496) )
	ROM_LOAD16_WORD_SWAP( "c74.p4",  0x180000, 0x80000, CRC(ea6f13ea) SHA1(1bc924a8a9da1d2ad7667685cdb92fe317a39aba) )
	ROM_LOAD16_WORD_SWAP( "c74.p5",  0x200000, 0x80000, CRC(5ac6d5ea) SHA1(9ce8e4668b565658597a868830545fb75a5eeaa6) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c74.c1",   0x0000000, 0x400000, CRC(22d72ab9) SHA1(653efd95c34b4b9d2ab0d219f41a99ca84e12214) )
	ROM_LOAD64_WORD( "c74.c2",   0x0000002, 0x400000, CRC(16a4813c) SHA1(bf5fce6008214f353414d1b64bea4ed0c7673670) )
	ROM_LOAD64_WORD( "c74.c3",   0x0000004, 0x400000, CRC(1097e035) SHA1(4bd51e4e9447af27d2cac1f6d2201e37c949912b) )
	ROM_LOAD64_WORD( "c74.c4",   0x0000006, 0x400000, CRC(d362d874) SHA1(30c42af18440496cc05e4418e4efa41172ae4ced) )
	ROM_LOAD64_WORD( "c74.c5",   0x1000000, 0x100000, CRC(0383897c) SHA1(aba14afa1d0c971afcee4317f480e88117d77b5e) )
	ROM_LOAD64_WORD( "c74.c6",   0x1000002, 0x100000, CRC(76f91084) SHA1(3d1e32467f2aa5dd6fb96bd5c866ecc9691660fc) )
	ROM_LOAD64_WORD( "c74.c7",   0x1000004, 0x100000, CRC(756c3754) SHA1(be2f709b90222a567f198f851cf07ffb0ad433d7) )
	ROM_LOAD64_WORD( "c74.c8",   0x1000006, 0x100000, CRC(9ec9277d) SHA1(b7ceeaca30dfcdf498b61a6961f0aa1a068b8ec4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c74.m1",   0x00000, 0x08000, CRC(254e5f33) SHA1(c413ec0630b9bdd15e64f42893eba8958a09b573) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c74.m2",   0x28000, 0x20000, CRC(6902f4f9) SHA1(9bfe4ddade3c666076d26a2b545120f6d059fd7c) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c74.q1",   0x000000, 0x400000, CRC(a5dea005) SHA1(3ae79baf6ff5bd527f82b26f164c7e3c65423ae2) )
	ROM_LOAD16_WORD_SWAP( "c74.q2",   0x400000, 0x400000, CRC(4ce235fe) SHA1(795b94557e954cc0e45fd3778b609064d57a34a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "pfghtj.key",   0x00, 0x14, CRC(62297638) SHA1(efe090ffa8992823cfd787ade736df5487d69ca7) )
ROM_END

ROM_START( pfghtj03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c74j03.p1", 0x000000, 0x80000, CRC(a32904ec) SHA1(5a0b8b76300293d4af96ea2c9223c6f04523b7df) )
	ROM_LOAD16_WORD_SWAP( "c74.p2",  0x080000, 0x80000, CRC(f4314c96) SHA1(c40ed74039bf0096eb3648b7243a8e697638e0a6) )
	ROM_LOAD16_WORD_SWAP( "c74.p3",  0x100000, 0x80000, CRC(215655f6) SHA1(242c0f4401520f2a3b0deafc3a807b18b987e496) )
	ROM_LOAD16_WORD_SWAP( "c74.p4",  0x180000, 0x80000, CRC(ea6f13ea) SHA1(1bc924a8a9da1d2ad7667685cdb92fe317a39aba) )
	ROM_LOAD16_WORD_SWAP( "c74.p5",  0x200000, 0x80000, CRC(5ac6d5ea) SHA1(9ce8e4668b565658597a868830545fb75a5eeaa6) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c74.c1",   0x0000000, 0x400000, CRC(22d72ab9) SHA1(653efd95c34b4b9d2ab0d219f41a99ca84e12214) )
	ROM_LOAD64_WORD( "c74.c2",   0x0000002, 0x400000, CRC(16a4813c) SHA1(bf5fce6008214f353414d1b64bea4ed0c7673670) )
	ROM_LOAD64_WORD( "c74.c3",   0x0000004, 0x400000, CRC(1097e035) SHA1(4bd51e4e9447af27d2cac1f6d2201e37c949912b) )
	ROM_LOAD64_WORD( "c74.c4",   0x0000006, 0x400000, CRC(d362d874) SHA1(30c42af18440496cc05e4418e4efa41172ae4ced) )
	ROM_LOAD64_WORD( "c74.c5",   0x1000000, 0x100000, CRC(0383897c) SHA1(aba14afa1d0c971afcee4317f480e88117d77b5e) )
	ROM_LOAD64_WORD( "c74.c6",   0x1000002, 0x100000, CRC(76f91084) SHA1(3d1e32467f2aa5dd6fb96bd5c866ecc9691660fc) )
	ROM_LOAD64_WORD( "c74.c7",   0x1000004, 0x100000, CRC(756c3754) SHA1(be2f709b90222a567f198f851cf07ffb0ad433d7) )
	ROM_LOAD64_WORD( "c74.c8",   0x1000006, 0x100000, CRC(9ec9277d) SHA1(b7ceeaca30dfcdf498b61a6961f0aa1a068b8ec4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c74.m1",   0x00000, 0x08000, CRC(254e5f33) SHA1(c413ec0630b9bdd15e64f42893eba8958a09b573) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c74.m2",   0x28000, 0x20000, CRC(6902f4f9) SHA1(9bfe4ddade3c666076d26a2b545120f6d059fd7c) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c74.q1",   0x000000, 0x400000, CRC(a5dea005) SHA1(3ae79baf6ff5bd527f82b26f164c7e3c65423ae2) )
	ROM_LOAD16_WORD_SWAP( "c74.q2",   0x400000, 0x400000, CRC(4ce235fe) SHA1(795b94557e954cc0e45fd3778b609064d57a34a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "pfghtj.key",   0x00, 0x14, CRC(62297638) SHA1(efe090ffa8992823cfd787ade736df5487d69ca7) )
ROM_END

ROM_START( pfghtj04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c74j04.p1", 0x000000, 0x80000, CRC(5b91a900) SHA1(503fc8b5e687c11bfa5a3b55a7df8b22b8a02103) )
	ROM_LOAD16_WORD_SWAP( "c74.p2",  0x080000, 0x80000, CRC(f4314c96) SHA1(c40ed74039bf0096eb3648b7243a8e697638e0a6) )
	ROM_LOAD16_WORD_SWAP( "c74.p3",  0x100000, 0x80000, CRC(215655f6) SHA1(242c0f4401520f2a3b0deafc3a807b18b987e496) )
	ROM_LOAD16_WORD_SWAP( "c74.p4",  0x180000, 0x80000, CRC(ea6f13ea) SHA1(1bc924a8a9da1d2ad7667685cdb92fe317a39aba) )
	ROM_LOAD16_WORD_SWAP( "c74.p5",  0x200000, 0x80000, CRC(5ac6d5ea) SHA1(9ce8e4668b565658597a868830545fb75a5eeaa6) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c74.c1",   0x0000000, 0x400000, CRC(22d72ab9) SHA1(653efd95c34b4b9d2ab0d219f41a99ca84e12214) )
	ROM_LOAD64_WORD( "c74.c2",   0x0000002, 0x400000, CRC(16a4813c) SHA1(bf5fce6008214f353414d1b64bea4ed0c7673670) )
	ROM_LOAD64_WORD( "c74.c3",   0x0000004, 0x400000, CRC(1097e035) SHA1(4bd51e4e9447af27d2cac1f6d2201e37c949912b) )
	ROM_LOAD64_WORD( "c74.c4",   0x0000006, 0x400000, CRC(d362d874) SHA1(30c42af18440496cc05e4418e4efa41172ae4ced) )
	ROM_LOAD64_WORD( "c74.c5",   0x1000000, 0x100000, CRC(0383897c) SHA1(aba14afa1d0c971afcee4317f480e88117d77b5e) )
	ROM_LOAD64_WORD( "c74.c6",   0x1000002, 0x100000, CRC(76f91084) SHA1(3d1e32467f2aa5dd6fb96bd5c866ecc9691660fc) )
	ROM_LOAD64_WORD( "c74.c7",   0x1000004, 0x100000, CRC(756c3754) SHA1(be2f709b90222a567f198f851cf07ffb0ad433d7) )
	ROM_LOAD64_WORD( "c74.c8",   0x1000006, 0x100000, CRC(9ec9277d) SHA1(b7ceeaca30dfcdf498b61a6961f0aa1a068b8ec4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c74.m1",   0x00000, 0x08000, CRC(254e5f33) SHA1(c413ec0630b9bdd15e64f42893eba8958a09b573) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c74.m2",   0x28000, 0x20000, CRC(6902f4f9) SHA1(9bfe4ddade3c666076d26a2b545120f6d059fd7c) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c74.q1",   0x000000, 0x400000, CRC(a5dea005) SHA1(3ae79baf6ff5bd527f82b26f164c7e3c65423ae2) )
	ROM_LOAD16_WORD_SWAP( "c74.q2",   0x400000, 0x400000, CRC(4ce235fe) SHA1(795b94557e954cc0e45fd3778b609064d57a34a2) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "pfghtj.key",   0x00, 0x14, CRC(62297638) SHA1(efe090ffa8992823cfd787ade736df5487d69ca7) )
ROM_END

 /************************************
 Vampire Savior 2 The Lord of Vampire
***************************************/
ROM_START( vsav2s01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c76s01.p1", 0x000000, 0x80000, CRC(88153978) SHA1(f193cac22a55fffb98d0a8daef3ced66907fafee) )
	ROM_LOAD16_WORD_SWAP( "c76.p2", 0x080000, 0x80000, CRC(107c091b) SHA1(bf5c2e4339e1a66b3c819900cc9b723a537adf6b) )
	ROM_LOAD16_WORD_SWAP( "c76.p3", 0x100000, 0x80000, CRC(61979638) SHA1(4d5625a9a06926c1a42c8f6e3a4c943f17750ec2) )
	ROM_LOAD16_WORD_SWAP( "c76.p4", 0x180000, 0x80000, CRC(f37c5bc2) SHA1(d8c1040a6ee6b9fc677a6a32b99bf02b6a707812) )
	ROM_LOAD16_WORD_SWAP( "c76.p5", 0x200000, 0x80000, CRC(8f885809) SHA1(69dac07e1f483b6478f792d20a137d6a081fbea3) )
	ROM_LOAD16_WORD_SWAP( "c76.p6", 0x280000, 0x80000, CRC(2018c120) SHA1(de1184ab771c6f075cdefa744a28b09f78d91643) )
	ROM_LOAD16_WORD_SWAP( "c76.p7", 0x300000, 0x80000, CRC(fac3c217) SHA1(0e9dd54e401e6d7c4fe81107ffd27e42ca810fcb) )
	ROM_LOAD16_WORD_SWAP( "c76.p8", 0x380000, 0x80000, CRC(eb490213) SHA1(bf0416df66a33c7a4678ab4a047de334dfd3b31e) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c76.c1",   0x0000000, 0x400000, CRC(5c852f52) SHA1(528ce7fc9a0451e2e2d221dbf5e4a5796584e053) )
	ROM_LOAD64_WORD( "c76.c2",   0x0000002, 0x400000, CRC(a20f58af) SHA1(e873ad3e0fc8a06a5029113faf991f5c1b765316) )
	ROM_LOAD64_WORD( "c76.c3",   0x0000004, 0x400000, CRC(39db59ad) SHA1(da94f1529da82a6bf2129f51548412e1ab2b001a) )
	ROM_LOAD64_WORD( "c76.c4",   0x0000006, 0x400000, CRC(00c763a7) SHA1(0ff528e12e255ebf699101ac71f05b1f6bef7165) )
	ROM_LOAD64_WORD( "c76.c5",   0x1000000, 0x400000, CRC(cd09bd63) SHA1(e582b20a948ae54f52590496051688dbfae2bc9c) )
	ROM_LOAD64_WORD( "c76.c6",   0x1000002, 0x400000, CRC(e0182c15) SHA1(a924d53ab39f4d85173bdb92a197dde2db0dc3f7) )
	ROM_LOAD64_WORD( "c76.c7",   0x1000004, 0x400000, CRC(778dc4f6) SHA1(8d0cd1c387b4b6ac7f92bb2e5a25983856328cdc) )
	ROM_LOAD64_WORD( "c76.c8",   0x1000006, 0x400000, CRC(605d9d1d) SHA1(99bc27557741527ca678d7b6307164bc04ebedc6) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c76.m1",   0x00000, 0x08000, CRC(35190139) SHA1(07f8e53ea398461de5dcda9814dde7c09faf9f65) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c76.m2",   0x28000, 0x20000, CRC(c32dba09) SHA1(1fe337ff334fab79847f9677ba0e168e93daa1c8) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c76.q1",   0x000000, 0x400000, CRC(d67e47b7) SHA1(15a3f6779eccb10551ed94edf7e6e406a79b3de7) )
	ROM_LOAD16_WORD_SWAP( "c76.q2",   0x400000, 0x400000, CRC(6d020a14) SHA1(e98f862fac1e357c90949768bb2646263d9981a0) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "vsav2.key",    0x00, 0x14, CRC(289028ce) SHA1(35779f0284dc15591493c8ec75ecda801148f3e0) )
ROM_END

ROM_START( vsav2s02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c76s02.p1", 0x000000, 0x80000, CRC(868ce7b8) SHA1(4e91618c1e39adf2487bc6c9d117bd6d84ee68f3) )
	ROM_LOAD16_WORD_SWAP( "c76.p2", 0x080000, 0x80000, CRC(107c091b) SHA1(bf5c2e4339e1a66b3c819900cc9b723a537adf6b) )
	ROM_LOAD16_WORD_SWAP( "c76.p3", 0x100000, 0x80000, CRC(61979638) SHA1(4d5625a9a06926c1a42c8f6e3a4c943f17750ec2) )
	ROM_LOAD16_WORD_SWAP( "c76.p4", 0x180000, 0x80000, CRC(f37c5bc2) SHA1(d8c1040a6ee6b9fc677a6a32b99bf02b6a707812) )
	ROM_LOAD16_WORD_SWAP( "c76.p5", 0x200000, 0x80000, CRC(8f885809) SHA1(69dac07e1f483b6478f792d20a137d6a081fbea3) )
	ROM_LOAD16_WORD_SWAP( "c76.p6", 0x280000, 0x80000, CRC(2018c120) SHA1(de1184ab771c6f075cdefa744a28b09f78d91643) )
	ROM_LOAD16_WORD_SWAP( "c76.p7", 0x300000, 0x80000, CRC(fac3c217) SHA1(0e9dd54e401e6d7c4fe81107ffd27e42ca810fcb) )
	ROM_LOAD16_WORD_SWAP( "c76.p8", 0x380000, 0x80000, CRC(eb490213) SHA1(bf0416df66a33c7a4678ab4a047de334dfd3b31e) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c76.c1",   0x0000000, 0x400000, CRC(5c852f52) SHA1(528ce7fc9a0451e2e2d221dbf5e4a5796584e053) )
	ROM_LOAD64_WORD( "c76.c2",   0x0000002, 0x400000, CRC(a20f58af) SHA1(e873ad3e0fc8a06a5029113faf991f5c1b765316) )
	ROM_LOAD64_WORD( "c76.c3",   0x0000004, 0x400000, CRC(39db59ad) SHA1(da94f1529da82a6bf2129f51548412e1ab2b001a) )
	ROM_LOAD64_WORD( "c76.c4",   0x0000006, 0x400000, CRC(00c763a7) SHA1(0ff528e12e255ebf699101ac71f05b1f6bef7165) )
	ROM_LOAD64_WORD( "c76.c5",   0x1000000, 0x400000, CRC(cd09bd63) SHA1(e582b20a948ae54f52590496051688dbfae2bc9c) )
	ROM_LOAD64_WORD( "c76.c6",   0x1000002, 0x400000, CRC(e0182c15) SHA1(a924d53ab39f4d85173bdb92a197dde2db0dc3f7) )
	ROM_LOAD64_WORD( "c76.c7",   0x1000004, 0x400000, CRC(778dc4f6) SHA1(8d0cd1c387b4b6ac7f92bb2e5a25983856328cdc) )
	ROM_LOAD64_WORD( "c76.c8",   0x1000006, 0x400000, CRC(605d9d1d) SHA1(99bc27557741527ca678d7b6307164bc04ebedc6) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c76.m1",   0x00000, 0x08000, CRC(35190139) SHA1(07f8e53ea398461de5dcda9814dde7c09faf9f65) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c76.m2",   0x28000, 0x20000, CRC(c32dba09) SHA1(1fe337ff334fab79847f9677ba0e168e93daa1c8) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c76.q1",   0x000000, 0x400000, CRC(d67e47b7) SHA1(15a3f6779eccb10551ed94edf7e6e406a79b3de7) )
	ROM_LOAD16_WORD_SWAP( "c76.q2",   0x400000, 0x400000, CRC(6d020a14) SHA1(e98f862fac1e357c90949768bb2646263d9981a0) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "vsav2.key",    0x00, 0x14, CRC(289028ce) SHA1(35779f0284dc15591493c8ec75ecda801148f3e0) )
ROM_END

ROM_START( vsav2s03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c76s03.p1", 0x000000, 0x80000, CRC(31676894) SHA1(0cb25d691213accb43e81f284d29812de893b296) )
	ROM_LOAD16_WORD_SWAP( "c76.p2", 0x080000, 0x80000, CRC(107c091b) SHA1(bf5c2e4339e1a66b3c819900cc9b723a537adf6b) )
	ROM_LOAD16_WORD_SWAP( "c76.p3", 0x100000, 0x80000, CRC(61979638) SHA1(4d5625a9a06926c1a42c8f6e3a4c943f17750ec2) )
	ROM_LOAD16_WORD_SWAP( "c76.p4", 0x180000, 0x80000, CRC(f37c5bc2) SHA1(d8c1040a6ee6b9fc677a6a32b99bf02b6a707812) )
	ROM_LOAD16_WORD_SWAP( "c76.p5", 0x200000, 0x80000, CRC(8f885809) SHA1(69dac07e1f483b6478f792d20a137d6a081fbea3) )
	ROM_LOAD16_WORD_SWAP( "c76.p6", 0x280000, 0x80000, CRC(2018c120) SHA1(de1184ab771c6f075cdefa744a28b09f78d91643) )
	ROM_LOAD16_WORD_SWAP( "c76.p7", 0x300000, 0x80000, CRC(fac3c217) SHA1(0e9dd54e401e6d7c4fe81107ffd27e42ca810fcb) )
	ROM_LOAD16_WORD_SWAP( "c76.p8", 0x380000, 0x80000, CRC(eb490213) SHA1(bf0416df66a33c7a4678ab4a047de334dfd3b31e) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c76.c1",   0x0000000, 0x400000, CRC(5c852f52) SHA1(528ce7fc9a0451e2e2d221dbf5e4a5796584e053) )
	ROM_LOAD64_WORD( "c76.c2",   0x0000002, 0x400000, CRC(a20f58af) SHA1(e873ad3e0fc8a06a5029113faf991f5c1b765316) )
	ROM_LOAD64_WORD( "c76.c3",   0x0000004, 0x400000, CRC(39db59ad) SHA1(da94f1529da82a6bf2129f51548412e1ab2b001a) )
	ROM_LOAD64_WORD( "c76.c4",   0x0000006, 0x400000, CRC(00c763a7) SHA1(0ff528e12e255ebf699101ac71f05b1f6bef7165) )
	ROM_LOAD64_WORD( "c76.c5",   0x1000000, 0x400000, CRC(cd09bd63) SHA1(e582b20a948ae54f52590496051688dbfae2bc9c) )
	ROM_LOAD64_WORD( "c76.c6",   0x1000002, 0x400000, CRC(e0182c15) SHA1(a924d53ab39f4d85173bdb92a197dde2db0dc3f7) )
	ROM_LOAD64_WORD( "c76.c7",   0x1000004, 0x400000, CRC(778dc4f6) SHA1(8d0cd1c387b4b6ac7f92bb2e5a25983856328cdc) )
	ROM_LOAD64_WORD( "c76.c8",   0x1000006, 0x400000, CRC(605d9d1d) SHA1(99bc27557741527ca678d7b6307164bc04ebedc6) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c76.m1",   0x00000, 0x08000, CRC(35190139) SHA1(07f8e53ea398461de5dcda9814dde7c09faf9f65) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c76.m2",   0x28000, 0x20000, CRC(c32dba09) SHA1(1fe337ff334fab79847f9677ba0e168e93daa1c8) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c76.q1",   0x000000, 0x400000, CRC(d67e47b7) SHA1(15a3f6779eccb10551ed94edf7e6e406a79b3de7) )
	ROM_LOAD16_WORD_SWAP( "c76.q2",   0x400000, 0x400000, CRC(6d020a14) SHA1(e98f862fac1e357c90949768bb2646263d9981a0) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "vsav2.key",    0x00, 0x14, CRC(289028ce) SHA1(35779f0284dc15591493c8ec75ecda801148f3e0) )
ROM_END

 /***************************************
 Marvel Vs. Capcom Clash of Super Heroes
******************************************/
ROM_START( mvscs01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s01.p1", 0x000000, 0x80000, CRC(e557a885) SHA1(b7bf4e814660e7aaf1a8135ec70a43a6a6edb6bc) )
	ROM_LOAD16_WORD_SWAP( "c77uh.p2", 0x080000, 0x80000, CRC(05e4ba51) SHA1(21e7107d53c2416b215c9ff442a85e98489ac8ba) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvscu.key",    0x00, 0x14, CRC(a83db333) SHA1(7f7288ceadf233d913728f7c4a8841adcb5994e8) )
ROM_END

ROM_START( mvscs02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s02.p1", 0x000000, 0x80000, CRC(fc947e02) SHA1(22311dba153405fabe388b14d17618591d0523d6) )
	ROM_LOAD16_WORD_SWAP( "c77eb.p2", 0x080000, 0x80000, CRC(cac02153) SHA1(ee9f9da6fda53f21ba7b74367612c90281269690) )
//  ROM_LOAD16_WORD_SWAP( "c77e.p2", 0x080000, 0x80000, CRC(436c5a4e) SHA1(82f4586e888f2550c53bfdc93a53791a595e05bd) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvsc.key",     0x00, 0x14, CRC(7e101e09) SHA1(9d725a7c6bbc20e46f749eaec4bab15b0195077a) )
ROM_END

ROM_START( mvscs03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s03.p1", 0x000000, 0x80000, CRC(bb1d80c3) SHA1(c30966401ce2533aa4f23102531340d0f77566bd) )
	ROM_LOAD16_WORD_SWAP( "c77j.p2", 0x080000, 0x80000, CRC(07d212e8) SHA1(c5420e9bd580910c1f1d0264240aeef20aac30a7) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvscj.key",    0x00, 0x14, CRC(9dedbcaf) SHA1(6468dd20ba89e4f6dc03340d218694690151ebe0) )
ROM_END

ROM_START( mvscs04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s04.p1", 0x000000, 0x80000, CRC(051d944f) SHA1(6759f50d1452047efa75f4b7eb453972968e03aa) )
	ROM_LOAD16_WORD_SWAP( "c77j.p2", 0x080000, 0x80000, CRC(07d212e8) SHA1(c5420e9bd580910c1f1d0264240aeef20aac30a7) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvscj.key",    0x00, 0x14, CRC(9dedbcaf) SHA1(6468dd20ba89e4f6dc03340d218694690151ebe0) )
ROM_END

ROM_START( mvscs05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s05.p1", 0x000000, 0x80000, CRC(8a50f418) SHA1(17db6f6afbe7866a4803bf2a20fb9b01b2b80250) )
	ROM_LOAD16_WORD_SWAP( "c77j.p2", 0x080000, 0x80000, CRC(07d212e8) SHA1(c5420e9bd580910c1f1d0264240aeef20aac30a7) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvscj.key",    0x00, 0x14, CRC(9dedbcaf) SHA1(6468dd20ba89e4f6dc03340d218694690151ebe0) )
ROM_END

ROM_START( mvscs06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c77s06.p1", 0x000000, 0x80000, CRC(8f886e52) SHA1(5fcd465361452b3b163cbd62b6cd73835e2f9f54) )
	ROM_LOAD16_WORD_SWAP( "c77j.p2", 0x080000, 0x80000, CRC(07d212e8) SHA1(c5420e9bd580910c1f1d0264240aeef20aac30a7) )
	ROM_LOAD16_WORD_SWAP( "c77.p3",  0x100000, 0x80000, CRC(2d8c8e86) SHA1(b07d640a734c5d336054ed05195786224c9a6cd4) )
	ROM_LOAD16_WORD_SWAP( "c77.p4",  0x180000, 0x80000, CRC(8528e1f5) SHA1(cd065c05268ab581b05676da544baf6af642acac) )
	ROM_LOAD16_WORD_SWAP( "c77.p5",   0x200000, 0x80000, CRC(c3baa32b) SHA1(d35589847e0753e869ffcd7c3abed925bfdb0fa2) )
	ROM_LOAD16_WORD_SWAP( "c77.p6",   0x280000, 0x80000, CRC(bc002fcd) SHA1(0b6735a071a9274f7ab25c743271fc30411fe819) )
	ROM_LOAD16_WORD_SWAP( "c77.p7",   0x300000, 0x80000, CRC(c67b26df) SHA1(6e9969246c57269d7ba0992a5cc319c8910bf8a9) )
	ROM_LOAD16_WORD_SWAP( "c77.p8",   0x380000, 0x80000, CRC(0fdd1e26) SHA1(5fa684d823b4f4eec61ed9e9b8938af5272ae1ed) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c77.c1",   0x0000000, 0x400000, CRC(fa5f74bc) SHA1(79a619248938a85ce4f7794a704647b9cf564fbc) )
	ROM_LOAD64_WORD( "c77.c2",   0x0000002, 0x400000, CRC(71938a8f) SHA1(6982f7203458c1c46a1c1c13c0d0f2a5e109d271) )
	ROM_LOAD64_WORD( "c77.c3",   0x0000004, 0x400000, CRC(92741d07) SHA1(ddfd70eab7c983ab452194b1860059f8ad694459) )
	ROM_LOAD64_WORD( "c77.c4",   0x0000006, 0x400000, CRC(bcb72fc6) SHA1(46ab98dcdf6f5d611646a22a7355939ef5b2bbe5) )
	ROM_LOAD64_WORD( "c77.c5",   0x1000000, 0x400000, CRC(7f1df4e4) SHA1(ede92b31c1fe87f91b4fe74ac211f2fb5f863bc2) )
	ROM_LOAD64_WORD( "c77.c6",   0x1000002, 0x400000, CRC(90bd3203) SHA1(ed83208c486ea0f407b7e5d16a8cf242a6f73774) )
	ROM_LOAD64_WORD( "c77.c7",   0x1000004, 0x400000, CRC(67aaf727) SHA1(e0e69104e31d2c41e18c0d24e9ab962406a7ca9a) )
	ROM_LOAD64_WORD( "c77.c8",   0x1000006, 0x400000, CRC(8b0bade8) SHA1(c5732361bb4bf284c4d12a82ac2c5750b1f9d441) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c77.m1",   0x00000, 0x08000, CRC(41629e95) SHA1(36925c05b5fdcbe43283a882d021e5360c947061) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c77.m2",   0x28000, 0x20000, CRC(963abf6b) SHA1(6b784870e338701cefabbbe4669984b5c4e8a9a5) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c77.q1",   0x000000, 0x400000, CRC(850fe663) SHA1(81e519d05a08855f242ea2e17ee0859b449db895) )
	ROM_LOAD16_WORD_SWAP( "c77.q2",   0x400000, 0x400000, CRC(7ccb1896) SHA1(74caadf3282fcc6acffb1bbe3734106f81124121) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mvscj.key",    0x00, 0x14, CRC(9dedbcaf) SHA1(6468dd20ba89e4f6dc03340d218694690151ebe0) )
ROM_END

 /**********************
 Street Fighter Alpha 3
*************************/
ROM_START( sfa3s01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s01.p1", 0x000000, 0x80000, CRC(f4a16a84) SHA1(2533cc63116b7767ca7c8821370e436f5f35bd69) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s02.p1", 0x000000, 0x80000, CRC(16909b6d) SHA1(fd530401c1b2099a813c99034712b5a6a77e57e0) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s03.p1", 0x000000, 0x80000, CRC(f9d59c0a) SHA1(5ba28243ece202eba246ee3a33bea71822da3f28) )
	ROM_LOAD16_WORD_SWAP( "c78u.p2", 0x080000, 0x80000, CRC(5f78f0e7) SHA1(f4df30fd3515fe9f1125f470b96028052c61f57b) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfa3s04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s04.p1", 0x000000, 0x80000, CRC(c2fee397) SHA1(1618bd00323ce2d84d14c222577f0821b225a2e6) )
	ROM_LOAD16_WORD_SWAP( "c78u.p2", 0x080000, 0x80000, CRC(5f78f0e7) SHA1(f4df30fd3515fe9f1125f470b96028052c61f57b) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfa3s05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s05.p1", 0x000000, 0x80000, CRC(a2492303) SHA1(7e740a8fa5e47cba4d171dbed489470f4c235554) )
	ROM_LOAD16_WORD_SWAP( "c78u.p2", 0x080000, 0x80000, CRC(5f78f0e7) SHA1(f4df30fd3515fe9f1125f470b96028052c61f57b) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfa3s06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s06.p1", 0x000000, 0x80000, CRC(42ca1d66) SHA1(973a27730968bf9631618055c272c627d58a47ad) )
	ROM_LOAD16_WORD_SWAP( "c78s13.p2", 0x080000, 0x80000, CRC(01a7b266) SHA1(32bec1fa10641c6c155e71827aaa9853e946f8c6) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s07.p1", 0x000000, 0x80000, CRC(c04b48df) SHA1(e66d3fd367c0409757ad113e227c8b0c7368c21a) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s08.p1", 0x000000, 0x80000, CRC(55e3f332) SHA1(17f0c8c21221954513a2b869afb1eb1eb94637a3) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s09 ) //sfa3
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s09.p1", 0x000000, 0x80000, CRC(d411da59) SHA1(13368f3e47a695a9699ef35d3bd7ab5040e96323) )
	ROM_LOAD16_WORD_SWAP( "c78s09.p2", 0x080000, 0x80000, CRC(9e4c0cd1) SHA1(113c7237c7470d3b9fbd873390ddfb7966e864ab) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s09.p7",  0x300000, 0x80000, CRC(fd1c944b) SHA1(83e65312593444d1a949f8f8cec7ec6875e8f8eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s10 ) //sfa3xl
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s10.p1", 0x000000, 0x80000, CRC(d762a68b) SHA1(2755e59d37c3acd1226256614f86af576592d9d3) )
	ROM_LOAD16_WORD_SWAP( "c78s10.p2", 0x080000, 0x80000, CRC(af5336ec) SHA1(7afb7e9c74218e6e3b860102026be5cd8086d0cf) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s09.p7",  0x300000, 0x80000, CRC(fd1c944b) SHA1(83e65312593444d1a949f8f8cec7ec6875e8f8eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s11 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s11.p1", 0x000000, 0x80000, CRC(b2a99137) SHA1(cba8777cd241e270c19fe375489efc421cc01549) )
	ROM_LOAD16_WORD_SWAP( "c78s11.p2", 0x080000, 0x80000, CRC(3e5cefe6) SHA1(f889bc9f7212e27d5df50ebda909b60e85dbfe29) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78s11.c1", 0x0000000, 0x400000, CRC(f18ffe2d) SHA1(3b7251f3027461a847749c8238ff9b0a9ab1c405) )
	ROM_LOAD64_WORD( "c78s11.c2", 0x0000002, 0x400000, CRC(3283878c) SHA1(e879ad81be09f73949c188e45506f63a114999c9) )
	ROM_LOAD64_WORD( "c78s11.c3", 0x0000004, 0x400000, CRC(869e0ae2) SHA1(30e018f3b38dbdac6cd1d228865627811886624f) )
	ROM_LOAD64_WORD( "c78s11.c4", 0x0000006, 0x400000, CRC(81e0ebfa) SHA1(449b7afc0c88edbab51b27abef4be5ff3698470c) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfa3s12 ) //sfa3ce https://github.com/originalgrego/sfa3ce
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s12.p1", 0x000000, 0x80000, CRC(e6a3c330) SHA1(39c5c9219e9c974b861c1bc083e142b2db811d25) )
	ROM_LOAD16_WORD_SWAP( "c78s12.p2", 0x080000, 0x80000, CRC(78650280) SHA1(d9c2a4a8f4dc076d5a8b6db612270e6d30618f6f) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s12.p7",  0x300000, 0x80000, CRC(8353dae0) SHA1(b6fd70d95ed5180e4fa953b30f3668b64a24343a) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78s12.c1",   0x0000000, 0x400000, CRC(d941f463) SHA1(fae09d5d29ef3d9650440e589ac574c98f20b899) )
	ROM_LOAD64_WORD( "c78s12.c2",   0x0000002, 0x400000, CRC(d25f4fbf) SHA1(dee478f694c11f2ab17821f471ed2ed270d5d113) )
	ROM_LOAD64_WORD( "c78s12.c3",   0x0000004, 0x400000, CRC(5c210d31) SHA1(27e6f75640f1a8b06e23b820fdfcb22728d517cc) )
	ROM_LOAD64_WORD( "c78s12.c4",   0x0000006, 0x400000, CRC(a0b6f359) SHA1(4e053f29fda3211d7356d3af8005ad195b199c2f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfa3s13 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s13.p1", 0x000000, 0x80000, CRC(9411ced4) SHA1(45c963125242eb78992d7d13c3f773f00115ba97) )
	ROM_LOAD16_WORD_SWAP( "c78s13.p2", 0x080000, 0x80000, CRC(01a7b266) SHA1(32bec1fa10641c6c155e71827aaa9853e946f8c6) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s14 ) // sfa3nc
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s14.p1", 0x000000, 0x80000, CRC(4773ce1b) SHA1(91c5be4c1053a07104f9c18e876d73406951e274) )
	ROM_LOAD16_WORD_SWAP( "c78s13.p2", 0x080000, 0x80000, CRC(01a7b266) SHA1(32bec1fa10641c6c155e71827aaa9853e946f8c6) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s14.p7",  0x300000, 0x80000, CRC(8cf82012) SHA1(2e270ec70e55534e7c2ec2a011e4aeeecb94db03) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s15 ) // sfa3nch
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s14.p1", 0x000000, 0x80000, CRC(4773ce1b) SHA1(91c5be4c1053a07104f9c18e876d73406951e274) )
	ROM_LOAD16_WORD_SWAP( "c78s13.p2", 0x080000, 0x80000, CRC(01a7b266) SHA1(32bec1fa10641c6c155e71827aaa9853e946f8c6) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s15.p7",  0x300000, 0x80000, CRC(6cf78cc3) SHA1(9a69c9c7f4a308c5c9aef1141f45298e288fc1c0) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s16 ) // sfa3ncj
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s14.p1", 0x000000, 0x80000, CRC(4773ce1b) SHA1(91c5be4c1053a07104f9c18e876d73406951e274) )
	ROM_LOAD16_WORD_SWAP( "c78s13.p2", 0x080000, 0x80000, CRC(01a7b266) SHA1(32bec1fa10641c6c155e71827aaa9853e946f8c6) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s16.p7",  0x300000, 0x80000, CRC(1d13389a) SHA1(afda47e2196cb4176084bb35b1b34ee878439cf8) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s17 ) // sfa3sp2
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s17.p1", 0x000000, 0x80000, CRC(41b961b4) SHA1(e2865fa71b647b4a8a86cc260b13d6f9616859fa) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s18 ) // sfa3spp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s18.p1", 0x000000, 0x80000, CRC(8267ee23) SHA1(ff86b54bcc7bdfb95bd537a3be2c03093c6865e1) )
	ROM_LOAD16_WORD_SWAP( "c78e.p2", 0x080000, 0x80000, CRC(5ad3f721) SHA1(fec11cc5f63593f0181eb28ae85ad916686793eb) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3.key",     0x00, 0x14, CRC(54fa39c6) SHA1(a0d2f8e697a7a4201762cb02842581840b2a7f78) )
ROM_END

ROM_START( sfa3s19 ) // sfa3uhd
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78s19.p1", 0x000000, 0x80000, CRC(eb1a8aeb) SHA1(fc6ae740eeeeb1c2a0e65b154f81904e59925a50) )
	ROM_LOAD16_WORD_SWAP( "c78u.p2", 0x080000, 0x80000, CRC(5f78f0e7) SHA1(f4df30fd3515fe9f1125f470b96028052c61f57b) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

 /*********************
 Street Fighter Zero 3
************************/

ROM_START( sfz3j01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j01.p1", 0x000000, 0x80000, CRC(72bec860) SHA1(78bdbbc14294f4c73cac7ffcc457875d83e183e3) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j02.p1", 0x000000, 0x80000, CRC(11e24a3b) SHA1(B5954fedfd5d84cf45c2c1e63bc8a40fbf1d001c) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j03.p1", 0x000000, 0x80000, CRC(E4e4161b) SHA1(B16c6222e605de7e1dc0f9ee3df0b8e52df0241a) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j04.p1", 0x000000, 0x80000, CRC(49466a33) SHA1(Cfbcb50bc01a5bb1810bc31f0e8007c5e55160bf) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j05.p1", 0x000000, 0x80000, CRC(5bb1f542) SHA1(2b498aec0d4b6087219293784efad4fb1b909286) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j06.p1", 0x000000, 0x80000, CRC(B544e978) SHA1(582ee67cfabbcd6f2d6d92f9c94dbfd9f08f1459) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j07.p1", 0x000000, 0x80000, CRC(C16ef2e4) SHA1(D53bc7b0f84eabf78450bb4ea591a8958b1f5456) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j08.p1", 0x000000, 0x80000, CRC(1c1fafbe) SHA1(260ae52941ce8d039408ed3a40281e8c88ab8577) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j09 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j09.p1", 0x000000, 0x80000, CRC(0cc3e29a) SHA1(9942257385ebda7209f33a100551f26921a11fce) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j10 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p1", 0x000000, 0x80000, CRC(6ee0beae) SHA1(243436fb64628f70cd130c7029d365ae97f3f42d) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p2", 0x080000, 0x80000, CRC(a6e2978d) SHA1(27e350e78aa204670c0ee6c60baddee46a92a584) )
	ROM_LOAD16_WORD_SWAP( "c78r1.p3",  0x100000, 0x80000, CRC(05964b7d) SHA1(ac9fa2c69c712a01647f0572381d875b1eb90886) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p4",  0x180000, 0x80000, CRC(78ce2179) SHA1(98a6f55bbdc45167fcc04cd6c3b7d71ffab31911) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p5",  0x200000, 0x80000, CRC(398bf52f) SHA1(2c8880b65b83724b956294b903b5038091b543c5) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p6",  0x280000, 0x80000, CRC(866d0588) SHA1(f2e9ca1bb606e4d2e3c9b62dd80074670a2e8e45) )
	ROM_LOAD16_WORD_SWAP( "c78j10.p7",  0x300000, 0x80000, CRC(3187e93f) SHA1(7cedc92feed1d0533c4fde19568839b6f9d36a7b) )
	ROM_LOAD16_WORD_SWAP( "c78b.p8",   0x380000, 0x80000, CRC(a9717252) SHA1(7ee94ace2a49e4e5d30474e49c0da04a488010fe) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j11 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p1", 0x000000, 0x80000, CRC(6ee0beae) SHA1(243436fb64628f70cd130c7029d365ae97f3f42d) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p2", 0x080000, 0x80000, CRC(a6e2978d) SHA1(27e350e78aa204670c0ee6c60baddee46a92a584) )
	ROM_LOAD16_WORD_SWAP( "c78r1.p3",  0x100000, 0x80000, CRC(05964b7d) SHA1(ac9fa2c69c712a01647f0572381d875b1eb90886) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p4",  0x180000, 0x80000, CRC(78ce2179) SHA1(98a6f55bbdc45167fcc04cd6c3b7d71ffab31911) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p5",  0x200000, 0x80000, CRC(398bf52f) SHA1(2c8880b65b83724b956294b903b5038091b543c5) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p6",  0x280000, 0x80000, CRC(866d0588) SHA1(f2e9ca1bb606e4d2e3c9b62dd80074670a2e8e45) )
	ROM_LOAD16_WORD_SWAP( "c78j11.p7",  0x300000, 0x80000, CRC(c75191ae) SHA1(0bb65ee1b5675770b9fbf55ce7b8f1ae9aa10965) )
	ROM_LOAD16_WORD_SWAP( "c78b.p8",   0x380000, 0x80000, CRC(a9717252) SHA1(7ee94ace2a49e4e5d30474e49c0da04a488010fe) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j12 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p1", 0x000000, 0x80000, CRC(6ee0beae) SHA1(243436fb64628f70cd130c7029d365ae97f3f42d) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p2", 0x080000, 0x80000, CRC(a6e2978d) SHA1(27e350e78aa204670c0ee6c60baddee46a92a584) )
	ROM_LOAD16_WORD_SWAP( "c78r1.p3",  0x100000, 0x80000, CRC(05964b7d) SHA1(ac9fa2c69c712a01647f0572381d875b1eb90886) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p4",  0x180000, 0x80000, CRC(78ce2179) SHA1(98a6f55bbdc45167fcc04cd6c3b7d71ffab31911) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p5",  0x200000, 0x80000, CRC(398bf52f) SHA1(2c8880b65b83724b956294b903b5038091b543c5) )
	ROM_LOAD16_WORD_SWAP( "c78jr1.p6",  0x280000, 0x80000, CRC(866d0588) SHA1(f2e9ca1bb606e4d2e3c9b62dd80074670a2e8e45) )
	ROM_LOAD16_WORD_SWAP( "c78j12.p7",  0x300000, 0x80000, CRC(2d166f6c) SHA1(a8858232a38dd998868f332a827ad49700c78b3c) )
	ROM_LOAD16_WORD_SWAP( "c78b.p8",   0x380000, 0x80000, CRC(a9717252) SHA1(7ee94ace2a49e4e5d30474e49c0da04a488010fe) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j13 ) // sfz3ce
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j13.p1", 0x000000, 0x80000, CRC(1e369ac2) SHA1(a07df805c49953316d5d9d180eff249d194cf097) )
	ROM_LOAD16_WORD_SWAP( "c78s12.p2", 0x080000, 0x80000, CRC(78650280) SHA1(d9c2a4a8f4dc076d5a8b6db612270e6d30618f6f) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78s12.p7",  0x300000, 0x80000, CRC(8353dae0) SHA1(b6fd70d95ed5180e4fa953b30f3668b64a24343a) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78s12.c1",   0x0000000, 0x400000, CRC(d941f463) SHA1(fae09d5d29ef3d9650440e589ac574c98f20b899) )
	ROM_LOAD64_WORD( "c78s12.c2",   0x0000002, 0x400000, CRC(d25f4fbf) SHA1(dee478f694c11f2ab17821f471ed2ed270d5d113) )
	ROM_LOAD64_WORD( "c78s12.c3",   0x0000004, 0x400000, CRC(5c210d31) SHA1(27e6f75640f1a8b06e23b820fdfcb22728d517cc) )
	ROM_LOAD64_WORD( "c78s12.c4",   0x0000006, 0x400000, CRC(a0b6f359) SHA1(4e053f29fda3211d7356d3af8005ad195b199c2f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfa3u.key",    0x00, 0x14, CRC(4a8f98c1) SHA1(11953de12ed8fbb6f60ad03b1ba5e22a429b7cfa) )
ROM_END

ROM_START( sfz3j14 ) // sfz3jb
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j14.p1", 0x000000, 0x80000, CRC(d7eca311) SHA1(cb2156bb5b545782bf4c0387ba6995136d14452d) )
	ROM_LOAD16_WORD_SWAP( "c78j14.p2", 0x080000, 0x80000, CRC(ee836561) SHA1(9b3f6a7a7b11b76e4849698c7ce5f09c23bcdad0) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j15 ) // sfz3jemb
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j15.p1", 0x000000, 0x80000, CRC(1e103c5e) SHA1(2a96b8f62f4dcefadb4485c60e40074a6357a22a) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j16 ) // sfz3jhp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j16.p1", 0x000000, 0x80000, CRC(5719fd0c) SHA1(edfdbbc36173a00652ef136005e55171b446b6c2) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j17 ) // sfz3sep
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j17.p1", 0x000000, 0x80000, CRC(248da619) SHA1(54155279822dc8f754d753c696eeec1fd0e90c18) )
	ROM_LOAD16_WORD_SWAP( "c78j.p2", 0x080000, 0x80000, CRC(fcb31228) SHA1(093f40083b5a4e4cae433d5856c48014063fe6ad) )
	ROM_LOAD16_WORD_SWAP( "c78.p3",  0x100000, 0x80000, CRC(57fd0a40) SHA1(bc2d5f4d57117bbf58b1adb088e00424ef489e92) )
	ROM_LOAD16_WORD_SWAP( "c78.p4",  0x180000, 0x80000, CRC(f6305f8b) SHA1(3fd1ebdbad96103aca604e950b488e52460a71ec) )
	ROM_LOAD16_WORD_SWAP( "c78.p5",  0x200000, 0x80000, CRC(6eab0f6f) SHA1(f8d093dda65cf4e8a3000dc1b96355bb03dcb495) )
	ROM_LOAD16_WORD_SWAP( "c78.p6",  0x280000, 0x80000, CRC(910c4a3b) SHA1(dbd41280f9b16ad6a5b8f12092549970349395f1) )
	ROM_LOAD16_WORD_SWAP( "c78.p7",  0x300000, 0x80000, CRC(b29e5199) SHA1(c6c215eb5aa37f678a9cafcbd8620969fb5ca12f) )
	ROM_LOAD16_WORD_SWAP( "c78.p8",  0x380000, 0x80000, CRC(deb2ff52) SHA1(0aa4722aad68a04164946c78bf05752f947b4322) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j18 ) // sfz3te v1.1
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j18.p1", 0x000000, 0x80000, CRC(b57412fa) SHA1(8f607f194c551bf65b338773b578ff9e66dfacbc) )
	ROM_LOAD16_WORD_SWAP( "c78j18.p2", 0x080000, 0x80000, CRC(eea5e3ca) SHA1(d5193fb4fc6dfaede925511a48acf163d326d2ff) )
	ROM_LOAD16_WORD_SWAP( "c78b.p3",  0x100000, 0x80000, CRC(9b21518a) SHA1(5a928307cb90a98a62e7598cb101fb66d62b85f9) )
	ROM_LOAD16_WORD_SWAP( "c78b.p4",  0x180000, 0x80000, CRC(e7a6c3a7) SHA1(63441eb19efcbf9149f4b723d3e9191fa972de2a) )
	ROM_LOAD16_WORD_SWAP( "c78b.p5",  0x200000, 0x80000, CRC(ec4c0cfd) SHA1(1a5148e77bf633c728a8179dacb59c776f981bc4) )
	ROM_LOAD16_WORD_SWAP( "c78b.p6",  0x280000, 0x80000, CRC(5c7e7240) SHA1(33bdcdd1889f8fa77916373ed33b0854410d0263) )
	ROM_LOAD16_WORD_SWAP( "c78b.p7",  0x300000, 0x80000, CRC(c5589553) SHA1(cda1fdc2ab2f390a2358defd9923a2796093926d) )
	ROM_LOAD16_WORD_SWAP( "c78b.p8",  0x380000, 0x80000, CRC(a9717252) SHA1(7ee94ace2a49e4e5d30474e49c0da04a488010fe) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3j19 ) // sfz3te v1.2
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78j19.p1", 0x000000, 0x80000, CRC(2fb19531) SHA1(27c9badb2be5b231a240929a8a9d5e75677478b7) )
	ROM_LOAD16_WORD_SWAP( "c78j19.p2", 0x080000, 0x80000, CRC(01e60fc4) SHA1(f51b0a10183f310f195c24c5b68f480974404d08) )
	ROM_LOAD16_WORD_SWAP( "c78b.p3",  0x100000, 0x80000, CRC(9b21518a) SHA1(5a928307cb90a98a62e7598cb101fb66d62b85f9) )
	ROM_LOAD16_WORD_SWAP( "c78b.p4",  0x180000, 0x80000, CRC(e7a6c3a7) SHA1(63441eb19efcbf9149f4b723d3e9191fa972de2a) )
	ROM_LOAD16_WORD_SWAP( "c78b.p5",  0x200000, 0x80000, CRC(ec4c0cfd) SHA1(1a5148e77bf633c728a8179dacb59c776f981bc4) )
	ROM_LOAD16_WORD_SWAP( "c78b.p6",  0x280000, 0x80000, CRC(5c7e7240) SHA1(33bdcdd1889f8fa77916373ed33b0854410d0263) )
	ROM_LOAD16_WORD_SWAP( "c78b.p7",  0x300000, 0x80000, CRC(c5589553) SHA1(cda1fdc2ab2f390a2358defd9923a2796093926d) )
	ROM_LOAD16_WORD_SWAP( "c78b.p8",  0x380000, 0x80000, CRC(a9717252) SHA1(7ee94ace2a49e4e5d30474e49c0da04a488010fe) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78.c1",   0x0000000, 0x400000, CRC(0f7a60d9) SHA1(c69e0ee22537312909dacc86d2e4be319d54e426) )
	ROM_LOAD64_WORD( "c78.c2",   0x0000002, 0x400000, CRC(8e933741) SHA1(f4ac4bfe830dc7df9fe4f680e4e0c053e7cbd8fe) )
	ROM_LOAD64_WORD( "c78.c3",   0x0000004, 0x400000, CRC(d6e98147) SHA1(37f331fbb1284db446faecade6f484f58c0e1b2a) )
	ROM_LOAD64_WORD( "c78.c4",   0x0000006, 0x400000, CRC(f31a728a) SHA1(f14136564648f006c1b74afda78349f260524b5f) )
	ROM_LOAD64_WORD( "c78.c5",   0x1000000, 0x400000, CRC(5ff98297) SHA1(9e0ce43380b776c7a03872bafd4856f6fa60bda7) )
	ROM_LOAD64_WORD( "c78.c6",   0x1000002, 0x400000, CRC(52b5bdee) SHA1(7918204dc457f7a146d8fb8cf7242dfed3109fd8) )
	ROM_LOAD64_WORD( "c78.c7",   0x1000004, 0x400000, CRC(40631ed5) SHA1(c18c56822b90a71ca5fbdf3440eb2671011f3d8f) )
	ROM_LOAD64_WORD( "c78.c8",   0x1000006, 0x400000, CRC(763409b4) SHA1(af60a5116c1ca9050366a35ea29128921867f3cc) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "sfz3j.key",    0x00, 0x14, CRC(d30cca8d) SHA1(b05869902d4d5968d5f79ed6165eb4b78e1ddcdd) )
ROM_END

ROM_START( sfz3mix07 ) // 0.07
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p1", 0x000000, 0x80000, CRC(dc369f0e) SHA1(ac305a9d8990357a8cb07639cf4caacc30df595f) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p2", 0x080000, 0x80000, CRC(42b6a449) SHA1(7e11e37b17353e7e25d3e8d8fdb2dde1a5ceba7c) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p3", 0x100000, 0x80000, CRC(d1838163) SHA1(ef5c3feba944eb1d0ff5943482dbfce027bb5c36) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p4", 0x180000, 0x80000, CRC(c02b9143) SHA1(d9f2f0ba7ea52e09c6c78290a8ed8d2e72b53148) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p5", 0x200000, 0x80000, CRC(82f44dfa) SHA1(ff90ac8b44c3de715daf2b6da881f5f6e215bd42) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p6", 0x280000, 0x80000, CRC(e66748e2) SHA1(3bd98f122a28d774ed5e2ba835e4f21a115efdfe) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p7", 0x300000, 0x80000, CRC(732d899f) SHA1(42334a9645355b6bfd79744c901cf35b704bcf50) )
	ROM_LOAD16_WORD_SWAP( "c78mix07.p8", 0x380000, 0x80000, CRC(89449e2b) SHA1(4dc58fa945bce94b8c5541c4c6769f26fa840c4b) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix07.c1", 0x0000000, 0x400000, CRC(1b5fc5f9) SHA1(0790956b6a9ffbf2e7540931e4bf730aa57a2106) )
	ROM_LOAD64_WORD( "c78mix07.c2", 0x0000002, 0x400000, CRC(4f9de2d9) SHA1(61de76e576297a7609738024c8fb4775b951b088) )
	ROM_LOAD64_WORD( "c78mix07.c3", 0x0000004, 0x400000, CRC(1fdd472e) SHA1(1a9c2bdb5becb049626333ba99d962207fb4ac88) )
	ROM_LOAD64_WORD( "c78mix07.c4", 0x0000006, 0x400000, CRC(646a311f) SHA1(7e6c848cc5679dbe0e78cf13f389a32a59aa8a16) )
	ROM_LOAD64_WORD( "c78mix07.c5", 0x1000000, 0x400000, CRC(e96ce6cc) SHA1(47c21bd039821959a6b6bd81abbd7c2b33ea0576) )
	ROM_LOAD64_WORD( "c78mix07.c6", 0x1000002, 0x400000, CRC(b15d2507) SHA1(cf6c067e73d638a71bd41751fd9f30adfe092cc7) )
	ROM_LOAD64_WORD( "c78mix07.c7", 0x1000004, 0x400000, CRC(b52f88f3) SHA1(527168c0072d068ea9d7e68772b9196dd731e07c) )
	ROM_LOAD64_WORD( "c78mix07.c8", 0x1000006, 0x400000, CRC(8c7b3fa3) SHA1(ff8a296819315ad725b3a92893f4e9abb4aebd74) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix07a ) // 0.07a
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p1", 0x000000, 0x80000, CRC(a2a3a0f2) SHA1(720f1f77829423836ff7507998e458f630e98d03) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p2", 0x080000, 0x80000, CRC(21d71a16) SHA1(0c3d0b261a19b2c45220aa6eca1772627ebe2866) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p3", 0x100000, 0x80000, CRC(e33af008) SHA1(faeebee1ca4dbd7b099a5289e50479d54da5abec) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p4", 0x180000, 0x80000, CRC(fbbd8bd7) SHA1(4f649da00d772065b9f9784a35fab0b2cc57379d) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p5", 0x200000, 0x80000, CRC(41d5f43d) SHA1(53bbff96205d967d44b51884e829cbf0e6292801) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p6", 0x280000, 0x80000, CRC(f62eb173) SHA1(1859c7e1d611f4d3344f071c89bae81fdac95e15) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p7", 0x300000, 0x80000, CRC(de20ca4e) SHA1(a45db7b806847603d346fc70b6ee59a4dad3d250) )
	ROM_LOAD16_WORD_SWAP( "c78mix07a.p8", 0x380000, 0x80000, CRC(4a5c77a4) SHA1(615d7784c18d26936fecb8163a2b9d2b6ca88710) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix07.c1", 0x0000000, 0x400000, CRC(1b5fc5f9) SHA1(0790956b6a9ffbf2e7540931e4bf730aa57a2106) )
	ROM_LOAD64_WORD( "c78mix07.c2", 0x0000002, 0x400000, CRC(4f9de2d9) SHA1(61de76e576297a7609738024c8fb4775b951b088) )
	ROM_LOAD64_WORD( "c78mix07.c3", 0x0000004, 0x400000, CRC(1fdd472e) SHA1(1a9c2bdb5becb049626333ba99d962207fb4ac88) )
	ROM_LOAD64_WORD( "c78mix07.c4", 0x0000006, 0x400000, CRC(646a311f) SHA1(7e6c848cc5679dbe0e78cf13f389a32a59aa8a16) )
	ROM_LOAD64_WORD( "c78mix07.c5", 0x1000000, 0x400000, CRC(e96ce6cc) SHA1(47c21bd039821959a6b6bd81abbd7c2b33ea0576) )
	ROM_LOAD64_WORD( "c78mix07.c6", 0x1000002, 0x400000, CRC(b15d2507) SHA1(cf6c067e73d638a71bd41751fd9f30adfe092cc7) )
	ROM_LOAD64_WORD( "c78mix07.c7", 0x1000004, 0x400000, CRC(b52f88f3) SHA1(527168c0072d068ea9d7e68772b9196dd731e07c) )
	ROM_LOAD64_WORD( "c78mix07.c8", 0x1000006, 0x400000, CRC(8c7b3fa3) SHA1(ff8a296819315ad725b3a92893f4e9abb4aebd74) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix07b ) // 0.07b
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p1", 0x000000, 0x80000, CRC(906ad276) SHA1(ce78bdae817782945a23f79f0c34af9aed4c3eb8) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p2", 0x080000, 0x80000, CRC(4ef3bbe9) SHA1(f9c23450d109bffb7b5dc40fc8797514291af0a8) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p3", 0x100000, 0x80000, CRC(baa534fc) SHA1(5231ff2f4b8194d149e600b6c8f45f03342f449b) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p4", 0x180000, 0x80000, CRC(e85ca573) SHA1(834095f8d6c79cfc4f42c5e5dda313a18b993a88) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p5", 0x200000, 0x80000, CRC(f53a20d8) SHA1(59203376b19a98de525e950880552e5f2f205963) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p6", 0x280000, 0x80000, CRC(3bd7d2d4) SHA1(5bd1f24f17e8a3f70f5de3d5e99078dcc10997f7) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p7", 0x300000, 0x80000, CRC(1a93bd2d) SHA1(ff2dcbfac7a4d352d731ff5021d05e26204df79d) )
	ROM_LOAD16_WORD_SWAP( "c78mix07b.p8", 0x380000, 0x80000, CRC(8c75a221) SHA1(c722832f4a4fe71515337dbd9d3ac00fb2323ad3) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix07.c1", 0x0000000, 0x400000, CRC(1b5fc5f9) SHA1(0790956b6a9ffbf2e7540931e4bf730aa57a2106) )
	ROM_LOAD64_WORD( "c78mix07.c2", 0x0000002, 0x400000, CRC(4f9de2d9) SHA1(61de76e576297a7609738024c8fb4775b951b088) )
	ROM_LOAD64_WORD( "c78mix07.c3", 0x0000004, 0x400000, CRC(1fdd472e) SHA1(1a9c2bdb5becb049626333ba99d962207fb4ac88) )
	ROM_LOAD64_WORD( "c78mix07.c4", 0x0000006, 0x400000, CRC(646a311f) SHA1(7e6c848cc5679dbe0e78cf13f389a32a59aa8a16) )
	ROM_LOAD64_WORD( "c78mix07.c5", 0x1000000, 0x400000, CRC(e96ce6cc) SHA1(47c21bd039821959a6b6bd81abbd7c2b33ea0576) )
	ROM_LOAD64_WORD( "c78mix07.c6", 0x1000002, 0x400000, CRC(b15d2507) SHA1(cf6c067e73d638a71bd41751fd9f30adfe092cc7) )
	ROM_LOAD64_WORD( "c78mix07.c7", 0x1000004, 0x400000, CRC(b52f88f3) SHA1(527168c0072d068ea9d7e68772b9196dd731e07c) )
	ROM_LOAD64_WORD( "c78mix07.c8", 0x1000006, 0x400000, CRC(8c7b3fa3) SHA1(ff8a296819315ad725b3a92893f4e9abb4aebd74) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix08 ) // 0.08
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p1", 0x000000, 0x80000, CRC(dccb6f06) SHA1(35f3975954024edba1c524d266ac7cf41a264d59) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p2", 0x080000, 0x80000, CRC(8617a7c4) SHA1(b51f695f5e9a532ec303c086fc005e1771390835) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p3", 0x100000, 0x80000, CRC(0f9e0705) SHA1(de66d559d29aea8a9127c81d17c96a6f7bee892b) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p4", 0x180000, 0x80000, CRC(f328c438) SHA1(e8a237aa08b0cd93f5370ee90d919672fa454d68) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p5", 0x200000, 0x80000, CRC(5bf5ed94) SHA1(7bcb670c5788b689fc9c6cfc832247af40807bd5) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p6", 0x280000, 0x80000, CRC(f5d17042) SHA1(7f0aff92480f9516d9129411e2200fd3b2726ec5) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p7", 0x300000, 0x80000, CRC(0928ede4) SHA1(d643c559c869ab806c44576cdf5adf332147dcd1) )
	ROM_LOAD16_WORD_SWAP( "c78mix08.p8", 0x380000, 0x80000, CRC(0f369728) SHA1(fd99024a092bd941890431061187a1dc7de5cdfd) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix07.c1", 0x0000000, 0x400000, CRC(1b5fc5f9) SHA1(0790956b6a9ffbf2e7540931e4bf730aa57a2106) )
	ROM_LOAD64_WORD( "c78mix07.c2", 0x0000002, 0x400000, CRC(4f9de2d9) SHA1(61de76e576297a7609738024c8fb4775b951b088) )
	ROM_LOAD64_WORD( "c78mix07.c3", 0x0000004, 0x400000, CRC(1fdd472e) SHA1(1a9c2bdb5becb049626333ba99d962207fb4ac88) )
	ROM_LOAD64_WORD( "c78mix07.c4", 0x0000006, 0x400000, CRC(646a311f) SHA1(7e6c848cc5679dbe0e78cf13f389a32a59aa8a16) )
	ROM_LOAD64_WORD( "c78mix07.c5", 0x1000000, 0x400000, CRC(e96ce6cc) SHA1(47c21bd039821959a6b6bd81abbd7c2b33ea0576) )
	ROM_LOAD64_WORD( "c78mix07.c6", 0x1000002, 0x400000, CRC(b15d2507) SHA1(cf6c067e73d638a71bd41751fd9f30adfe092cc7) )
	ROM_LOAD64_WORD( "c78mix07.c7", 0x1000004, 0x400000, CRC(b52f88f3) SHA1(527168c0072d068ea9d7e68772b9196dd731e07c) )
	ROM_LOAD64_WORD( "c78mix07.c8", 0x1000006, 0x400000, CRC(8c7b3fa3) SHA1(ff8a296819315ad725b3a92893f4e9abb4aebd74) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix09 ) // 0.09
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p1", 0x000000, 0x80000, CRC(22962e92) SHA1(0fe33fd7629e4028ee2bef8f302bd4958fca0d8e) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p2", 0x080000, 0x80000, CRC(10ed184d) SHA1(b5a4afff5fecdea1e4c7baedc995968970b003d9) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p3", 0x100000, 0x80000, CRC(99964fde) SHA1(4c7c21ac7dd4a3ba9b0e396b9dff8fed37132796) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p4", 0x180000, 0x80000, CRC(2a63f25f) SHA1(e961e977d2a389ddc5b9e68e4e17acf00a268d99) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p5", 0x200000, 0x80000, CRC(7bfc7d3f) SHA1(ea580905ab0c755c1c391de327b9c68366a44ce3) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p6", 0x280000, 0x80000, CRC(a6d60e7a) SHA1(ab64f188172ec4e063abe8f6c3053ebe27df3b17) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p7", 0x300000, 0x80000, CRC(b1973865) SHA1(f18c12f2deaf965a887f5020a97d245e2fbd7d70) )
	ROM_LOAD16_WORD_SWAP( "c78mix09.p8", 0x380000, 0x80000, CRC(851002e1) SHA1(e82f3b928f1c7929ba4bc2fc6dbe46c45e202bef) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix09.c1", 0x0000000, 0x400000, CRC(71d4cee0) SHA1(2e9010c57aff5b47b14487b13eea1116dc735f8b) )
	ROM_LOAD64_WORD( "c78mix09.c2", 0x0000002, 0x400000, CRC(4985b5cd) SHA1(a91c0cfc00a5c31ddc488c919178f27c23fb9cd1) )
	ROM_LOAD64_WORD( "c78mix09.c3", 0x0000004, 0x400000, CRC(181eee89) SHA1(8906ebafa93d5ac64c0bfe5858adf3d2fb46391b) )
	ROM_LOAD64_WORD( "c78mix09.c4", 0x0000006, 0x400000, CRC(c496ea94) SHA1(4279ff24c540b8ddb191c407f3356bb849bc948f) )
	ROM_LOAD64_WORD( "c78mix07.c5", 0x1000000, 0x400000, CRC(e96ce6cc) SHA1(47c21bd039821959a6b6bd81abbd7c2b33ea0576) )
	ROM_LOAD64_WORD( "c78mix07.c6", 0x1000002, 0x400000, CRC(b15d2507) SHA1(cf6c067e73d638a71bd41751fd9f30adfe092cc7) )
	ROM_LOAD64_WORD( "c78mix07.c7", 0x1000004, 0x400000, CRC(b52f88f3) SHA1(527168c0072d068ea9d7e68772b9196dd731e07c) )
	ROM_LOAD64_WORD( "c78mix07.c8", 0x1000006, 0x400000, CRC(8c7b3fa3) SHA1(ff8a296819315ad725b3a92893f4e9abb4aebd74) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix10 ) // 0.10
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p1", 0x000000, 0x80000, CRC(12ee6b5a) SHA1(ca8551b750a64a6bd65fb13525428af3f6e89634) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p2", 0x080000, 0x80000, CRC(56aab557) SHA1(73b8e200c05ba8d4bceab10c3640826215040f21) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p3", 0x100000, 0x80000, CRC(d6118829) SHA1(30af1347bea9bad71f9404218fb1009178346f6b) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p4", 0x180000, 0x80000, CRC(3f3712fb) SHA1(bc960bec54c6cb9342a335b8d15f55a1fa2e230e) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p5", 0x200000, 0x80000, CRC(3ff0aaa7) SHA1(412d1dfe93d510fc92f91aeb4b4e1f17aa354acd) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p6", 0x280000, 0x80000, CRC(008d8e1e) SHA1(385ace30c3257f55188d0dcd08b84788c42a18c9) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p7", 0x300000, 0x80000, CRC(9642bc00) SHA1(f3d4a3ddad6773d728cbcdd01d1d15a2104de39e) )
	ROM_LOAD16_WORD_SWAP( "c78mix10.p8", 0x380000, 0x80000, CRC(56ac1a00) SHA1(23bd4a88d3b63d7f06c8130837b896f01ed52623) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix10.c1", 0x0000000, 0x400000, CRC(65ab82b8) SHA1(71fb84d64eb74809ce072e5be587145ddaba692b) )
	ROM_LOAD64_WORD( "c78mix10.c2", 0x0000002, 0x400000, CRC(ef8fbc0a) SHA1(2e4b27cc62f80c2e2a7d2e32ee98619b2e12b42e) )
	ROM_LOAD64_WORD( "c78mix10.c3", 0x0000004, 0x400000, CRC(652b1493) SHA1(89e6e1f2fb8c85168c934093e5b053ad80f82d14) )
	ROM_LOAD64_WORD( "c78mix10.c4", 0x0000006, 0x400000, CRC(0a1b38b9) SHA1(782e1a3b6c6e4be732420e449073571e7b140ccd) )
	ROM_LOAD64_WORD( "c78mix10.c5", 0x1000000, 0x400000, CRC(62496779) SHA1(8534226cc1074097fce296ec1ab6e453f9a2b69d) )
	ROM_LOAD64_WORD( "c78mix10.c6", 0x1000002, 0x400000, CRC(1e7aa3cb) SHA1(66bfe1d7897f9dfd02db0523e8296aa50f4cf8c5) )
	ROM_LOAD64_WORD( "c78mix10.c7", 0x1000004, 0x400000, CRC(95e161ce) SHA1(ef863b415fe4f07f5acf1e5082378c7603d8e58c) )
	ROM_LOAD64_WORD( "c78mix10.c8", 0x1000006, 0x400000, CRC(a6afdc2d) SHA1(6bfd7261246f19cc12364fe02ba090d456a482ce) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix11 ) // 0.11
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p1", 0x000000, 0x80000, CRC(c576f39a) SHA1(db535febc78b0ee17aaf0e11970ce3af595220e5) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p2", 0x080000, 0x80000, CRC(d1c963ad) SHA1(d293d6a6096d3e207747d7e838082f8014db2e91) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p3", 0x100000, 0x80000, CRC(29df08bf) SHA1(e2fbdc78e37010fe4dc2576a318948ec88b85193) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p4", 0x180000, 0x80000, CRC(fc18d833) SHA1(d668915c12b438776d9644d74ac2fb75119a99a7) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p5", 0x200000, 0x80000, CRC(67b83490) SHA1(f70886e7a88e0a4a1a17b022083b67bea9515351) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p6", 0x280000, 0x80000, CRC(6da03096) SHA1(f943cc2e1853cfdc1e36bb6ce04c44c77386f55b) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p7", 0x300000, 0x80000, CRC(3f008ce0) SHA1(e58e9289d2c08c00f68d888e8263daa950b60855) )
	ROM_LOAD16_WORD_SWAP( "c78mix11.p8", 0x380000, 0x80000, CRC(11d9171e) SHA1(7ce1f8c5d89f46c559e7b6332901632d2c0ee696) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix11.c1", 0x0000000, 0x400000, CRC(93183516) SHA1(a4435cf5d384294dc5f85325b8f47f166020fe7b) )
	ROM_LOAD64_WORD( "c78mix11.c2", 0x0000002, 0x400000, CRC(b06f14ce) SHA1(f653f8c10157102426430670f557d8fc2e0c70ec) )
	ROM_LOAD64_WORD( "c78mix11.c3", 0x0000004, 0x400000, CRC(661c1355) SHA1(4d53b8bbc466d947320c8c12bdff72b01493c20b) )
	ROM_LOAD64_WORD( "c78mix11.c4", 0x0000006, 0x400000, CRC(7227f353) SHA1(343534f1679858fae27970a859d54c6e46d16748) )
	ROM_LOAD64_WORD( "c78mix10.c5", 0x1000000, 0x400000, CRC(62496779) SHA1(8534226cc1074097fce296ec1ab6e453f9a2b69d) )
	ROM_LOAD64_WORD( "c78mix10.c6", 0x1000002, 0x400000, CRC(1e7aa3cb) SHA1(66bfe1d7897f9dfd02db0523e8296aa50f4cf8c5) )
	ROM_LOAD64_WORD( "c78mix10.c7", 0x1000004, 0x400000, CRC(95e161ce) SHA1(ef863b415fe4f07f5acf1e5082378c7603d8e58c) )
	ROM_LOAD64_WORD( "c78mix10.c8", 0x1000006, 0x400000, CRC(a6afdc2d) SHA1(6bfd7261246f19cc12364fe02ba090d456a482ce) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78.m1",   0x00000, 0x08000, CRC(de810084) SHA1(fd0b969b732921ed8b40c16fbfa30ee09c7a7cbd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix12 ) // 0.12
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p1", 0x000000, 0x80000, CRC(4eee8312) SHA1(0e439d21690125cc33151c51d71892bcf4babf55) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p2", 0x080000, 0x80000, CRC(3f6bac25) SHA1(e8439bffa1a2a8a058e2fb98bd433a484ef346dc) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p3", 0x100000, 0x80000, CRC(4314b417) SHA1(e7212535b5e60e049a162590f4c32143b93d190e) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p4", 0x180000, 0x80000, CRC(b15a331c) SHA1(94b53aa28f19139ec192f19256b65b8fb2d0271c) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p5", 0x200000, 0x80000, CRC(505ea66f) SHA1(037fddfaa65af1bbbc221300c8816a888b752a33) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p6", 0x280000, 0x80000, CRC(c9661960) SHA1(49879dbde4b9298ec1ca919ecaef243d311e142b) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p7", 0x300000, 0x80000, CRC(7a5a0d3c) SHA1(4c9eb75c4b555a37e39d67c1318f4735bf7702f7) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p8", 0x380000, 0x80000, CRC(07286674) SHA1(0c8aefd7380e03972eced07fffb4f569a3631057) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix11.c1", 0x0000000, 0x400000, CRC(93183516) SHA1(a4435cf5d384294dc5f85325b8f47f166020fe7b) )
	ROM_LOAD64_WORD( "c78mix11.c2", 0x0000002, 0x400000, CRC(b06f14ce) SHA1(f653f8c10157102426430670f557d8fc2e0c70ec) )
	ROM_LOAD64_WORD( "c78mix11.c3", 0x0000004, 0x400000, CRC(661c1355) SHA1(4d53b8bbc466d947320c8c12bdff72b01493c20b) )
	ROM_LOAD64_WORD( "c78mix11.c4", 0x0000006, 0x400000, CRC(7227f353) SHA1(343534f1679858fae27970a859d54c6e46d16748) )
	ROM_LOAD64_WORD( "c78mix10.c5", 0x1000000, 0x400000, CRC(62496779) SHA1(8534226cc1074097fce296ec1ab6e453f9a2b69d) )
	ROM_LOAD64_WORD( "c78mix10.c6", 0x1000002, 0x400000, CRC(1e7aa3cb) SHA1(66bfe1d7897f9dfd02db0523e8296aa50f4cf8c5) )
	ROM_LOAD64_WORD( "c78mix10.c7", 0x1000004, 0x400000, CRC(95e161ce) SHA1(ef863b415fe4f07f5acf1e5082378c7603d8e58c) )
	ROM_LOAD64_WORD( "c78mix10.c8", 0x1000006, 0x400000, CRC(a6afdc2d) SHA1(6bfd7261246f19cc12364fe02ba090d456a482ce) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78mix12.m1",   0x00000, 0x08000, CRC(85143fac) SHA1(65561f11780d5b5cd92783b5bf1bfa02bbfa7e10) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78mix12.m2",   0x28000, 0x20000, CRC(b0f7dd76) SHA1(4debfb4d1a3880d0679e3d035c74cceecab45d93) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78.q1",   0x000000, 0x400000, CRC(1c89eed1) SHA1(649a0b0a3eb72e2e69e9fb1ac51a58b70daa39f3) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

ROM_START( sfz3mix13 ) // 0.13
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p1", 0x000000, 0x80000, CRC(39b106fe) SHA1(71a653d69889e24ef08f16ed19510b5beb4e6c88) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p2", 0x080000, 0x80000, CRC(0cde4b42) SHA1(a87c5b0fd07881b6ea316a3dc8e8a0d4212b8ff3) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p3", 0x100000, 0x80000, CRC(b8b19c1f) SHA1(72a38eb482b20e2e6c95dbadd0ef9108bbda2868) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p4", 0x180000, 0x80000, CRC(35639da3) SHA1(7ad71481f38846e9c80556b241fcfacec638c66a) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p5", 0x200000, 0x80000, CRC(a9d9f83e) SHA1(a4728207aefed7a97fafab291a427278ef77044e) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p6", 0x280000, 0x80000, CRC(a85e33a5) SHA1(f6ce81bfa91008e60090df7cf8a9c73d4d8dee78) )
	ROM_LOAD16_WORD_SWAP( "c78mix12.p7", 0x300000, 0x80000, CRC(7a5a0d3c) SHA1(4c9eb75c4b555a37e39d67c1318f4735bf7702f7) )
	ROM_LOAD16_WORD_SWAP( "c78mix13.p8", 0x380000, 0x80000, CRC(3fa5f874) SHA1(46a39c1cc6010a0c500b4b79b8709a93a7995e3d) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c78mix11.c1", 0x0000000, 0x400000, CRC(93183516) SHA1(a4435cf5d384294dc5f85325b8f47f166020fe7b) )
	ROM_LOAD64_WORD( "c78mix11.c2", 0x0000002, 0x400000, CRC(b06f14ce) SHA1(f653f8c10157102426430670f557d8fc2e0c70ec) )
	ROM_LOAD64_WORD( "c78mix11.c3", 0x0000004, 0x400000, CRC(661c1355) SHA1(4d53b8bbc466d947320c8c12bdff72b01493c20b) )
	ROM_LOAD64_WORD( "c78mix11.c4", 0x0000006, 0x400000, CRC(7227f353) SHA1(343534f1679858fae27970a859d54c6e46d16748) )
	ROM_LOAD64_WORD( "c78mix10.c5", 0x1000000, 0x400000, CRC(62496779) SHA1(8534226cc1074097fce296ec1ab6e453f9a2b69d) )
	ROM_LOAD64_WORD( "c78mix10.c6", 0x1000002, 0x400000, CRC(1e7aa3cb) SHA1(66bfe1d7897f9dfd02db0523e8296aa50f4cf8c5) )
	ROM_LOAD64_WORD( "c78mix10.c7", 0x1000004, 0x400000, CRC(95e161ce) SHA1(ef863b415fe4f07f5acf1e5082378c7603d8e58c) )
	ROM_LOAD64_WORD( "c78mix10.c8", 0x1000006, 0x400000, CRC(a6afdc2d) SHA1(6bfd7261246f19cc12364fe02ba090d456a482ce) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c78mix13.m1",   0x00000, 0x08000, CRC(5ac9bfe5) SHA1(85fa8599de7b035ceb8ee6ffb88c93f94572a0cd) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78mix13.m2",   0x28000, 0x20000, CRC(68a17d87) SHA1(f6ebdabdeb1d94a3293cbe55de31c10900f45375) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c78mix13.q1",   0x000000, 0x400000, CRC(ab9415fb) SHA1(8de2f4576aafe631f762d3a5aeb720642b98d2e8) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END

 /*********
 Giga Wing
************/
ROM_START( gigawings01 )
	ROM_REGION(CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c79s01.p1", 0x000000, 0x80000, CRC(b5083d38) SHA1(aa99876a611bc5bfbe7a0053f01103b2047b4213) )
	ROM_LOAD16_WORD_SWAP( "c79u.p2", 0x080000, 0x80000, CRC(392f4118) SHA1(3bb0bd9503ef60892d5abd8640af524cf71da848) )
	ROM_LOAD16_WORD_SWAP( "c79.p3",  0x100000, 0x80000, CRC(3239d642) SHA1(2fe3984c46a72aedb30a28e3db5af2612bdf0045) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c79.c1",   0x000000, 0x400000, CRC(105530a4) SHA1(3be06c032985ea6bd3805d73a407bf748385087b) )
	ROM_LOAD64_WORD( "c79.c2",   0x000002, 0x400000, CRC(9e774ab9) SHA1(adea1e844f3d9ccd5ad116ff8277f16a96e68d76) )
	ROM_LOAD64_WORD( "c79.c3",   0x000004, 0x400000, CRC(466e0ba4) SHA1(9563455b95d36fafe508290659088b153539cfdf) )
	ROM_LOAD64_WORD( "c79.c4",   0x000006, 0x400000, CRC(840c8dea) SHA1(ea04afce17f00b45d3d2cd5140d0dd7ab4bccc00) )

	ROM_REGION(QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c79.m1",   0x00000, 0x08000, CRC(4c6351d5) SHA1(cef81fb7c4b8cb2ef1f8f3c27982aefbcbe38160) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c79.q1",   0x000000, 0x400000, CRC(e172acf5) SHA1(d7b0963d66165f3607d887741c5e7ab952bcf2ff) )
	ROM_LOAD16_WORD_SWAP( "c79.q2",   0x400000, 0x400000, CRC(4bee4e8f) SHA1(c440b5a38359ec3b8002f39690b79bf78703f5d0) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "gigawing.key", 0x00, 0x14, CRC(5076c26b) SHA1(81a0aa6768a1e94aed25503ad8b3814bb23c41b5) )
ROM_END

/****
 1944
*******/
ROM_START( 1944s01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c83s01.p1", 0x000000, 0x80000, CRC(9c3788d6) SHA1(58deffb77600202df2cc5640639ddcd9e9a3547c) )
	ROM_LOAD16_WORD_SWAP( "c83.p2",  0x080000, 0x80000, CRC(dba1c66e) SHA1(4764e77d4da5d19d9acded27df1e1bcba06b0fcf) )
	ROM_LOAD16_WORD_SWAP( "c83u.p3", 0x100000, 0x80000, CRC(ea813eb7) SHA1(34e0175a5f22d08c3538369b4bfd077a7427a128) )

	ROM_REGION( 0x1400000, "gfx", 0 )
	ROM_LOAD64_WORD( "c83.c1",   0x0000000, 0x400000, CRC(c9fca741) SHA1(1781d4fc18b6d6f79b7b39d9bcace750fb61a5cf) )
	ROM_LOAD64_WORD( "c83.c2",   0x0000002, 0x400000, CRC(f809d898) SHA1(a0b6af49e1780678d808c317b875161cedddb314) )
	ROM_LOAD64_WORD( "c83.c3",   0x0000004, 0x400000, CRC(15ba4507) SHA1(bed6a82bf1dc1aa501d4c2d098115a15e18d446a) )
	ROM_LOAD64_WORD( "c83.c4",   0x0000006, 0x400000, CRC(3dd41b8c) SHA1(676078baad789e25f6e5a79de29672587be7ff00) )
	ROM_LOAD64_WORD( "c83.c5",   0x1000000, 0x100000, CRC(3fe3a54b) SHA1(0a8e5cae141d24fd8b3cb11796c44728b0acd69e) )
	ROM_LOAD64_WORD( "c83.c6",   0x1000002, 0x100000, CRC(565cd231) SHA1(0aecd433fb4ca2de1aca9fbb1e314fb1f6979321) )
	ROM_LOAD64_WORD( "c83.c7",   0x1000004, 0x100000, CRC(63ca5988) SHA1(30137fa77573c84bcc24570bccb7dba61ddb413c) )
	ROM_LOAD64_WORD( "c83.c8",   0x1000006, 0x100000, CRC(21eb8f3b) SHA1(efa69f19a958047dd91a294c88857ed3133fcbef) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c83.m1",   0x00000, 0x08000, CRC(d2e44318) SHA1(33e45f6fe9fed098a4c072b8c39406aef1a949b2) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c83.q1",   0x000000, 0x400000, CRC(243e4e05) SHA1(83281f7290ac105a3f9a7507cbc11317d45ba706) )
	ROM_LOAD16_WORD_SWAP( "c83.q2",   0x400000, 0x400000, CRC(4fcf1600) SHA1(36f18c5d92b79433bdf7088b29a244708929d48e) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "1944u.key",     0x00, 0x14, CRC(61734f5b) SHA1(f0df9cf7772b48e6422e22bbce9340ee33bc09ba) )
ROM_END

ROM_START( 1944s02 ) // 1944da
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c83s02.p1", 0x000000, 0x80000, CRC(78188e42) SHA1(add31daba3e6916a1facfaf32feeaba228e9a6ab) )
	ROM_LOAD16_WORD_SWAP( "c83.p2",     0x080000, 0x80000, CRC(dba1c66e) SHA1(4764e77d4da5d19d9acded27df1e1bcba06b0fcf) )
	ROM_LOAD16_WORD_SWAP( "c83u.p3",    0x100000, 0x80000, CRC(ea813eb7) SHA1(34e0175a5f22d08c3538369b4bfd077a7427a128) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c83.c1",   0x0000000, 0x400000, CRC(c9fca741) SHA1(1781d4fc18b6d6f79b7b39d9bcace750fb61a5cf) )
	ROM_LOAD64_WORD( "c83.c2",   0x0000002, 0x400000, CRC(f809d898) SHA1(a0b6af49e1780678d808c317b875161cedddb314) )
	ROM_LOAD64_WORD( "c83.c3",   0x0000004, 0x400000, CRC(15ba4507) SHA1(bed6a82bf1dc1aa501d4c2d098115a15e18d446a) )
	ROM_LOAD64_WORD( "c83.c4",   0x0000006, 0x400000, CRC(3dd41b8c) SHA1(676078baad789e25f6e5a79de29672587be7ff00) )
	ROM_LOAD64_WORD( "c83.c5",   0x1000000, 0x100000, CRC(3fe3a54b) SHA1(0a8e5cae141d24fd8b3cb11796c44728b0acd69e) )
	ROM_LOAD64_WORD( "c83.c6",   0x1000002, 0x100000, CRC(565cd231) SHA1(0aecd433fb4ca2de1aca9fbb1e314fb1f6979321) )
	ROM_LOAD64_WORD( "c83.c7",   0x1000004, 0x100000, CRC(63ca5988) SHA1(30137fa77573c84bcc24570bccb7dba61ddb413c) )
	ROM_LOAD64_WORD( "c83.c8",   0x1000006, 0x100000, CRC(21eb8f3b) SHA1(efa69f19a958047dd91a294c88857ed3133fcbef) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c83.m1",   0x00000, 0x08000, CRC(d2e44318) SHA1(33e45f6fe9fed098a4c072b8c39406aef1a949b2) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c83.q1",   0x000000, 0x400000, CRC(243e4e05) SHA1(83281f7290ac105a3f9a7507cbc11317d45ba706) )
	ROM_LOAD16_WORD_SWAP( "c83.q2",   0x400000, 0x400000, CRC(4fcf1600) SHA1(36f18c5d92b79433bdf7088b29a244708929d48e) )
ROM_END

ROM_START( 1944s03 ) // 1944fp
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c83s03.p1", 0x000000, 0x80000, CRC(3239f3a2) SHA1(22f6e5772c3f2f98db79c9ec6809cb0343b7c877) )
	ROM_LOAD16_WORD_SWAP( "c83s03.p2",  0x080000, 0x80000, CRC(91297ec9) SHA1(3ef111613e758540a3187d972018b100bcb1652a) )
	ROM_LOAD16_WORD_SWAP( "c83u.p3", 0x100000, 0x80000, CRC(ea813eb7) SHA1(34e0175a5f22d08c3538369b4bfd077a7427a128) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c83.c1",   0x0000000, 0x400000, CRC(c9fca741) SHA1(1781d4fc18b6d6f79b7b39d9bcace750fb61a5cf) )
	ROM_LOAD64_WORD( "c83.c2",   0x0000002, 0x400000, CRC(f809d898) SHA1(a0b6af49e1780678d808c317b875161cedddb314) )
	ROM_LOAD64_WORD( "c83.c3",   0x0000004, 0x400000, CRC(15ba4507) SHA1(bed6a82bf1dc1aa501d4c2d098115a15e18d446a) )
	ROM_LOAD64_WORD( "c83.c4",   0x0000006, 0x400000, CRC(3dd41b8c) SHA1(676078baad789e25f6e5a79de29672587be7ff00) )
	ROM_LOAD64_WORD( "c83.c5",   0x1000000, 0x100000, CRC(3fe3a54b) SHA1(0a8e5cae141d24fd8b3cb11796c44728b0acd69e) )
	ROM_LOAD64_WORD( "c83.c6",   0x1000002, 0x100000, CRC(565cd231) SHA1(0aecd433fb4ca2de1aca9fbb1e314fb1f6979321) )
	ROM_LOAD64_WORD( "c83.c7",   0x1000004, 0x100000, CRC(63ca5988) SHA1(30137fa77573c84bcc24570bccb7dba61ddb413c) )
	ROM_LOAD64_WORD( "c83.c8",   0x1000006, 0x100000, CRC(21eb8f3b) SHA1(efa69f19a958047dd91a294c88857ed3133fcbef) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c83.m1",   0x00000, 0x08000, CRC(d2e44318) SHA1(33e45f6fe9fed098a4c072b8c39406aef1a949b2) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c83.q1",   0x000000, 0x400000, CRC(243e4e05) SHA1(83281f7290ac105a3f9a7507cbc11317d45ba706) )
	ROM_LOAD16_WORD_SWAP( "c83.q2",   0x400000, 0x400000, CRC(4fcf1600) SHA1(36f18c5d92b79433bdf7088b29a244708929d48e) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "1944fp.key",   0x00, 0x14, CRC(81b5e47e) SHA1(3dde33f070508859b04c4e4a393ea9548c48287c) )
ROM_END

/**************
Mighty Pang
**************/
ROM_START( mpangj01 ) // mpangjd
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c84j01.p1", 0x000000, 0x80000, CRC(dac63128) SHA1(e5ee8f6d698a28dbf54520473520e40efadf30e3) )
	ROM_LOAD16_WORD_SWAP( "c84j01.p2", 0x080000, 0x80000, CRC(d0b2592b) SHA1(f18c026776326f9bab70d1a8f66dd5fffb115b1b) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_BYTE( "c84.c1",   0x0000000, 0x200000, CRC(388db66b) SHA1(7416cce3d0dbea71c92ea9f72f5536146f757b45) )
	ROM_LOAD64_BYTE( "c84.c2",   0x0000001, 0x200000, CRC(aff1b494) SHA1(d376c02ce01e71a7707d3d3fe5b0ae59ce781686) )
	ROM_LOAD64_BYTE( "c84.c3",   0x0000002, 0x200000, CRC(a9c4857b) SHA1(66f538105c710d1480141e48a15b1a760f5ce985) )
	ROM_LOAD64_BYTE( "c84.c4",   0x0000003, 0x200000, CRC(f759df22) SHA1(1678e3e819dd808f3a6fdd52b7c933eac4777b5b) )
	ROM_LOAD64_BYTE( "c84.c5",   0x0000004, 0x200000, CRC(dec6b720) SHA1(331776e1cba3fb82071e7c2195dc4ae27b3613a2) )
	ROM_LOAD64_BYTE( "c84.c6",   0x0000005, 0x200000, CRC(f8774c18) SHA1(58e0ea4dd62e39bcfaa3a2be4ef08eb2f0bd3c00) )
	ROM_LOAD64_BYTE( "c84.c7",   0x0000006, 0x200000, CRC(c2aea4ec) SHA1(f5e2a815fa802598611efa48e5de97e929155e77) )
	ROM_LOAD64_BYTE( "c84.c8",   0x0000007, 0x200000, CRC(84d6dc33) SHA1(f5ababb479facc08c425381570644230c09334e7) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c84.m1",   0x00000, 0x08000, CRC(90c7adb6) SHA1(a2653e977e5e0457b249e098e5ca0abc93dac336) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x400000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c84.q1",   0x000000, 0x200000, CRC(318a2e21) SHA1(c573cd88f8279a062c73ef1d79cd8421dbdcd93e) )
	ROM_LOAD16_WORD_SWAP( "c84.q2",   0x200000, 0x200000, CRC(5462f4e8) SHA1(299fbdab700e735e6395c5d9e3f079bb2e3dbd73) )
ROM_END

 /*****************
 Progear no Arashi
********************/
ROM_START( progearj01 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c85j01.p1", 0x000000, 0x80000, CRC(d65d47f9) SHA1(d1c45f3e191730b7757f7925de8dca969900ded2) )
	ROM_LOAD16_WORD_SWAP( "c85jd.p2", 0x080000, 0x80000, CRC(be4b7799) SHA1(0414922296079ca9380a41bf3c628ce67acec06d) )

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_BYTE( "c85.c1",   0x0000000, 0x200000,  CRC(452f98b0) SHA1(a10e615c32098f6d25becd466da8faa967523a7b) )
	ROM_LOAD64_BYTE( "c85.c2",   0x0000001, 0x200000,  CRC(9e672092) SHA1(fce0b8b43a1c069262f4e3e81c1a04621e232c88) )
	ROM_LOAD64_BYTE( "c85.c3",   0x0000002, 0x200000,  CRC(ae9ddafe) SHA1(afbb26fed6cd0cb5c0099a10d35aeb453318c14d) )
	ROM_LOAD64_BYTE( "c85.c4",   0x0000003, 0x200000,  CRC(94d72d94) SHA1(df6a3fe49c008f73b160eb6f2a44dc371ff73cba) )
	ROM_LOAD64_BYTE( "c85.c5",   0x0000004, 0x200000,  CRC(48a1886d) SHA1(ebf44b42d784924e08a832a7e5f66a887bab244b) )
	ROM_LOAD64_BYTE( "c85.c6",   0x0000005, 0x200000,  CRC(172d7e37) SHA1(0eaedd24cd3fa87b6f35fbd63078d40c493c92d0) )
	ROM_LOAD64_BYTE( "c85.c7",   0x0000006, 0x200000,  CRC(9ee33d98) SHA1(85d1bd31940e35ac8c732165020881a2d65cd6b1) )
	ROM_LOAD64_BYTE( "c85.c8",   0x0000007, 0x200000,  CRC(848dee32) SHA1(c591288e86ad1624d0fe66563808af9fac786e64) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c85.m1",   0x00000, 0x08000, CRC(bdbfa992) SHA1(7c5496c1daaea6a7ab95c0b25625d325ec3427cc) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c85.q1",   0x000000, 0x200000, CRC(c0aac80c) SHA1(91784d35d4f7e113529bb5be6081b67094b150ea) )
	ROM_LOAD16_WORD_SWAP( "c85.q2",   0x200000, 0x200000, CRC(37a65d86) SHA1(374d562a4648734f82aa2ddb6d258e870896dd45) )
	ROM_LOAD16_WORD_SWAP( "c85.q3",   0x400000, 0x200000, CRC(d3f1e934) SHA1(5dcea28c873d0d472f5b94e07d97cd77ace2b252) )
	ROM_LOAD16_WORD_SWAP( "c85.q4",   0x600000, 0x200000, CRC(8b39489a) SHA1(fd790efaf37dc2c4c16f657941044e3e2d3c2711) )
ROM_END

ROM_START( progearj02 ) // halfway to hell
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c85j02.p1",   0x000000, 0x080000, CRC(55ce8d4a) SHA1(3b7342afbfa1244cb5cbf5be7391d3e1f8231822) ) // halfway.03
	ROM_LOAD16_WORD_SWAP( "c85j02.p2",   0x080000, 0x080000, CRC(71060b9e) SHA1(007a174ceca6ae080f19f088bf0fc6cd0fe2510c) ) // tohell.04

	ROM_REGION( 0x1000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c85bl.c1",   0x0000000, 0x400000, CRC(5194c198) SHA1(f9ae16cad8b30547b8dd3a1ea1d6e845d76ccefe) )
	ROM_LOAD64_WORD( "c85bl.c2",   0x0000002, 0x400000, CRC(b794e83f) SHA1(0332fa798b2955464ab336929866c9185bd4b520) )
	ROM_LOAD64_WORD( "c85bl.c3",   0x0000004, 0x400000, CRC(87f22918) SHA1(7f048d66593f385526bd2c669cf6b8ad58d12bbf) )
	ROM_LOAD64_WORD( "c85bl.c4",   0x0000006, 0x400000, CRC(65ffb45b) SHA1(9c21187519c1ec95c5a960b2c815ee41ace4fa7e) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c85.m1",   0x00000, 0x08000, CRC(bdbfa992) SHA1(7c5496c1daaea6a7ab95c0b25625d325ec3427cc) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c85j02.q1", 0x000000, 0x400000, CRC(33ebf625) SHA1(39e5f9afd37a258005b0143fa38b9c53b63f700d) ) // redlabel.11m
	ROM_LOAD16_WORD_SWAP( "c85j02.q2", 0x000000, 0x400000, CRC(47f25cf4) SHA1(714b5baf146d720cc86f77aeee5b1160f553d958) ) // redlabel.12m
ROM_END

 /************************************************
 Hyper Street Fighter II: The Anniversary Edition
***************************************************/
ROM_START( sf2prime3 ) // v0.3 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr3.p1", 0x000000, 0x80000, CRC(fd845fd6) SHA1(ff949bebb37facff71bfe799053d901caa600779) )
	ROM_LOAD16_WORD_SWAP( "c88pr3.p2", 0x080000, 0x80000, CRC(5fcdfebe) SHA1(99aac66532656b0e1f84c81ce419062162f9c592) )
	ROM_LOAD16_WORD_SWAP( "c88pr3.p3", 0x100000, 0x80000, CRC(9339eb7b) SHA1(ca95d414677d0ecbdea0bafaceac5c7add858b2c) )
	ROM_LOAD16_WORD_SWAP( "c88pr3.p4", 0x180000, 0x80000, CRC(67761d04) SHA1(2164f4f22c4a4d3426fcab4ee8de9c620c01dbb0) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr3.c1",   0x0000000, 0x800000, CRC(7c6a35f7) SHA1(72ef68880c9bf97fabee70944381bc299cb02e5c) )
	ROM_LOAD64_WORD( "c88pr3.c2",   0x0000002, 0x800000, CRC(7b35f3f7) SHA1(99c608055836f8469f567e15677c78337ba78426) )
	ROM_LOAD64_WORD( "c88pr3.c3",   0x0000004, 0x800000, CRC(3852deb5) SHA1(94feed9ac08a310243892219737845e4e7e648a0) )
	ROM_LOAD64_WORD( "c88pr3.c4",   0x0000006, 0x800000, CRC(0454efa8) SHA1(b56eed703951d1690ce5575376e279e679526979) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime4 ) // v0.4 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr4.p1", 0x000000, 0x80000, CRC(45c0c045) SHA1(bd6a77696b3a1f09ff275f00a37434f3c471f2eb) )
	ROM_LOAD16_WORD_SWAP( "c88pr4.p2", 0x080000, 0x80000, CRC(252397fd) SHA1(226bd6dbf155361cb7374be11acc5bfcfe4af210) )
	ROM_LOAD16_WORD_SWAP( "c88pr4.p3", 0x100000, 0x80000, CRC(642c22b8) SHA1(a92ea1006ba5e1e43f2614fb1f5e68b6f39a7490) )
	ROM_LOAD16_WORD_SWAP( "c88pr4.p4", 0x180000, 0x80000, CRC(910aeae4) SHA1(c3cc383c2e483daa8eed478fa957ecd18df1d0b9) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr4.c1",   0x0000000, 0x800000, CRC(3e5b9c03) SHA1(6266816f894edfcbd7ed9bf50da9416f344ea304) )
	ROM_LOAD64_WORD( "c88pr4.c2",   0x0000002, 0x800000, CRC(b388618b) SHA1(115a47fff503a780229dbe1e3f2e3478811d9258) )
	ROM_LOAD64_WORD( "c88pr4.c3",   0x0000004, 0x800000, CRC(ca3ae557) SHA1(fa8748d2780c644d1e5fbf719dc8840191965683) )
	ROM_LOAD64_WORD( "c88pr4.c4",   0x0000006, 0x800000, CRC(b1d2a1ef) SHA1(91d670f9d40b16f9eac4269bab8d2a385945ffa2) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime41 ) // v0.41 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr41.p1", 0x000000, 0x80000, CRC(8df8ef98) SHA1(06d694224ddedfe45d67c161ae761dd65f924b3b) )
	ROM_LOAD16_WORD_SWAP( "c88pr41.p2", 0x080000, 0x80000, CRC(8f5382e9) SHA1(55365b19e599c4e1e8a6987be095546239a5e623) )
	ROM_LOAD16_WORD_SWAP( "c88pr41.p3", 0x100000, 0x80000, CRC(82e8b3c0) SHA1(114abe3ff681b2f436b23646e0a14f9005a1b37b) )
	ROM_LOAD16_WORD_SWAP( "c88pr41.p4", 0x180000, 0x80000, CRC(da43b431) SHA1(ff55405df5800f6f842757e251c57823cb47db60) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr4.c1",   0x0000000, 0x800000, CRC(3e5b9c03) SHA1(6266816f894edfcbd7ed9bf50da9416f344ea304) )
	ROM_LOAD64_WORD( "c88pr4.c2",   0x0000002, 0x800000, CRC(b388618b) SHA1(115a47fff503a780229dbe1e3f2e3478811d9258) )
	ROM_LOAD64_WORD( "c88pr4.c3",   0x0000004, 0x800000, CRC(ca3ae557) SHA1(fa8748d2780c644d1e5fbf719dc8840191965683) )
	ROM_LOAD64_WORD( "c88pr4.c4",   0x0000006, 0x800000, CRC(b1d2a1ef) SHA1(91d670f9d40b16f9eac4269bab8d2a385945ffa2) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime45 ) // v0.45 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr45.p1", 0x000000, 0x80000, CRC(8edd9043) SHA1(3e84ff7d18b095a95a31bcbcfe07a29e973d88bf) )
	ROM_LOAD16_WORD_SWAP( "c88pr45.p2", 0x080000, 0x80000, CRC(cd728d92) SHA1(0462bc38d41d09e8fe056d126b4c3a9f0ffbe627) )
	ROM_LOAD16_WORD_SWAP( "c88pr45.p3", 0x100000, 0x80000, CRC(a8a6c3d4) SHA1(3bc3353a4f479a5670a42461b5e5adab02d08baf) )
	ROM_LOAD16_WORD_SWAP( "c88pr45.p4", 0x180000, 0x80000, CRC(c53e42ba) SHA1(0f10ed175ce073062dba4655d34b7d1f34e38176) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr4.c1",   0x0000000, 0x800000, CRC(3e5b9c03) SHA1(6266816f894edfcbd7ed9bf50da9416f344ea304) )
	ROM_LOAD64_WORD( "c88pr4.c2",   0x0000002, 0x800000, CRC(b388618b) SHA1(115a47fff503a780229dbe1e3f2e3478811d9258) )
	ROM_LOAD64_WORD( "c88pr4.c3",   0x0000004, 0x800000, CRC(ca3ae557) SHA1(fa8748d2780c644d1e5fbf719dc8840191965683) )
	ROM_LOAD64_WORD( "c88pr4.c4",   0x0000006, 0x800000, CRC(b1d2a1ef) SHA1(91d670f9d40b16f9eac4269bab8d2a385945ffa2) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime50 ) // v0.50 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr50.p1", 0x000000, 0x80000, CRC(adaea9d7) SHA1(fe77d951763cc54780a3fda305348fb46c193783) )
	ROM_LOAD16_WORD_SWAP( "c88pr50.p2", 0x080000, 0x80000, CRC(75dcbaf0) SHA1(3235a1c70c5a59c7578c4d2bb04fa9aa523d9182) )
	ROM_LOAD16_WORD_SWAP( "c88pr50.p3", 0x100000, 0x80000, CRC(bd0ea568) SHA1(d6553197ce1dfc176d89ce03821ff6db577329e6) )
	ROM_LOAD16_WORD_SWAP( "c88pr50.p4", 0x180000, 0x80000, CRC(ca5f7934) SHA1(412faf8826173a12bcdd57b997c837a3e7cdb7bb) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr50.c1",   0x0000000, 0x800000, CRC(f48a99a4) SHA1(942de5cf2a9720745625416781d38c2d8752d838) )
	ROM_LOAD64_WORD( "c88pr50.c2",   0x0000002, 0x800000, CRC(abf5f4b2) SHA1(bfc1de978df8f24a72083ae58400112a61ff0b2e) )
	ROM_LOAD64_WORD( "c88pr50.c3",   0x0000004, 0x800000, CRC(87dd1b40) SHA1(ff6c3f2cb5c959618365c1736b31efae591f2f07) )
	ROM_LOAD64_WORD( "c88pr50.c4",   0x0000006, 0x800000, CRC(b3395339) SHA1(81eaf5b1858fa4e296b2aeea910d1a1a4d9b6d7a) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime55 ) // v0.55 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr55.p1", 0x000000, 0x80000, CRC(27179418) SHA1(29dc63a4233c88a582c3e813cab0f65625ddba0e) )
	ROM_LOAD16_WORD_SWAP( "c88pr55.p2", 0x080000, 0x80000, CRC(d1c67804) SHA1(8eff49bfe848e54b916ea74883aca7aa78e03ab5) )
	ROM_LOAD16_WORD_SWAP( "c88pr55.p3", 0x100000, 0x80000, CRC(69701a6a) SHA1(a53b21008a74c7499f3a1f355f0ee4b94406fc26) )
	ROM_LOAD16_WORD_SWAP( "c88pr55.p4", 0x180000, 0x80000, CRC(f0899cc2) SHA1(5351f6ade352a93bde70f2b0d1508680f81f0456) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr55.c1",   0x0000000, 0x800000, CRC(9c022c5a) SHA1(ac045bdac4e30d2ae4517f4e42547957804b9160) )
	ROM_LOAD64_WORD( "c88pr55.c2",   0x0000002, 0x800000, CRC(78a40f11) SHA1(6a2d3ee953956c7679f3992b52963b6777ef29d6) )
	ROM_LOAD64_WORD( "c88pr55.c3",   0x0000004, 0x800000, CRC(379b08d6) SHA1(fe4fad819fd9c50fa09f83c81b610e9f4fb2adb1) )
	ROM_LOAD64_WORD( "c88pr55.c4",   0x0000006, 0x800000, CRC(23afa1b3) SHA1(0681ddc054495517d9088d2201f149ea4d0eb6fa) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime56 ) // v0.56 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr56.p1", 0x000000, 0x80000, CRC(4178d05d) SHA1(8fd77f28888d920e98fd6931881a4d53bb881f17) )
	ROM_LOAD16_WORD_SWAP( "c88pr56.p2", 0x080000, 0x80000, CRC(09e9f78b) SHA1(7904f92f604ed0546f4a9c3f2d24f16f7cd90c35) )
	ROM_LOAD16_WORD_SWAP( "c88pr56.p3", 0x100000, 0x80000, CRC(b020c201) SHA1(2745f63e768dc33514b68183d06adbba82839434) )
	ROM_LOAD16_WORD_SWAP( "c88pr56.p4", 0x180000, 0x80000, CRC(0b960430) SHA1(ebde7895fefff69e584a71cebe0ef03276121873) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr56.c1",   0x0000000, 0x800000, CRC(fb796487) SHA1(20a3ad6b2421c91d1d33db17a9bf473c7ed068b0) )
	ROM_LOAD64_WORD( "c88pr56.c2",   0x0000002, 0x800000, CRC(f5419f30) SHA1(24eb1dff53bfb10cdc882fd391b31c9d565bf94d) )
	ROM_LOAD64_WORD( "c88pr56.c3",   0x0000004, 0x800000, CRC(8266131f) SHA1(426b553860ac8770eaa51282e21d5e3f5d199da6) )
	ROM_LOAD64_WORD( "c88pr56.c4",   0x0000006, 0x800000, CRC(d6cc4ba6) SHA1(d3818f1c58fa995214eed0e04ab9a913ff657c7a) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime57 ) // v0.57 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr57.p1", 0x000000, 0x80000, CRC(bd9f494e) SHA1(5e2faaeb6e7c6eb9e17da3898f750ff33a0686aa) )
	ROM_LOAD16_WORD_SWAP( "c88pr57.p2", 0x080000, 0x80000, CRC(b8226d94) SHA1(60ebe8e48437d29b66d750050c10c7491e7506b5) )
	ROM_LOAD16_WORD_SWAP( "c88pr57.p3", 0x100000, 0x80000, CRC(e10a0cce) SHA1(88bf3fba5471c65361f9ddb6ce6d11525abf8e61) )
	ROM_LOAD16_WORD_SWAP( "c88pr57.p4", 0x180000, 0x80000, CRC(b3bba0ee) SHA1(ddb39146286dbc11ebb59d2606a151a652d65a3b) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr57.c1",   0x0000000, 0x800000, CRC(ca94dc69) SHA1(94f27fd924e19b05ed80eabaeab695a95b2e2482) )
	ROM_LOAD64_WORD( "c88pr57.c2",   0x0000002, 0x800000, CRC(ac2dc86a) SHA1(98fee6f5e53f6aa3a7d5dd076586bd68b970750f) )
	ROM_LOAD64_WORD( "c88pr57.c3",   0x0000004, 0x800000, CRC(7b87fb74) SHA1(b37618f06496752c089eb159dde0d1c7680723e7) )
	ROM_LOAD64_WORD( "c88pr57.c4",   0x0000006, 0x800000, CRC(e9af9e3f) SHA1(e8cf7778d7851078681013824067efc50b615949) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime59 ) // v0.59 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr59.p1", 0x000000, 0x80000, CRC(59143b8b) SHA1(d1bf03bd515f2db8b733c72f15eeb16bd3eaf8b8) )
	ROM_LOAD16_WORD_SWAP( "c88pr59.p2", 0x080000, 0x80000, CRC(409d4228) SHA1(2d63a988d522362ca814565cbf659acfaa4ef690) )
	ROM_LOAD16_WORD_SWAP( "c88pr59.p3", 0x100000, 0x80000, CRC(17aebd33) SHA1(975aa76c7d42918903477295f5d6de74e29d766e) )
	ROM_LOAD16_WORD_SWAP( "c88pr59.p4", 0x180000, 0x80000, CRC(25efe272) SHA1(98bfff893fe33e573a2b1fb4c64fe266272cff62) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr59.c1",   0x0000000, 0x800000, CRC(ef3434a7) SHA1(072302fe32e2bfa4c395945ddf6f3d6c06374c71) )
	ROM_LOAD64_WORD( "c88pr59.c2",   0x0000002, 0x800000, CRC(5c800140) SHA1(5993a6c9db7af3e5d85992b18df6d40160828318) )
	ROM_LOAD64_WORD( "c88pr59.c3",   0x0000004, 0x800000, CRC(816156ec) SHA1(36c1c47c78c314c4ff8c9c0cef6d0347a0a6a74f) )
	ROM_LOAD64_WORD( "c88pr59.c4",   0x0000006, 0x800000, CRC(9851a965) SHA1(9ce1fef748c9b0e3924082bac33410b3c0a69daf) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime60 ) // v0.60 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr60.p1", 0x000000, 0x80000, CRC(43cd297c) SHA1(8edf388061a596e1df6168a08bd6d1501b4a99c5) )
	ROM_LOAD16_WORD_SWAP( "c88pr60.p2", 0x080000, 0x80000, CRC(46590cc4) SHA1(baeacebd4d22c177b1921f6fe3c994e5855eabe9) )
	ROM_LOAD16_WORD_SWAP( "c88pr60.p3", 0x100000, 0x80000, CRC(ba37cb21) SHA1(f214d297b0ecbc48c439bb3c7b2f5ee16836c427) )
	ROM_LOAD16_WORD_SWAP( "c88pr60.p4", 0x180000, 0x80000, CRC(3d40c10d) SHA1(705fd6300ba6d07abeed2881b2f0929569b2c7b1) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr60.c1",   0x0000000, 0x800000, CRC(451adf88) SHA1(f96dd42edc948ed3a5eb5c3c0da47404522f58cd) )
	ROM_LOAD64_WORD( "c88pr60.c2",   0x0000002, 0x800000, CRC(3c9ce92a) SHA1(84b2f408df3b2520d40aacd68e60b33b7c0f9c4d) )
	ROM_LOAD64_WORD( "c88pr60.c3",   0x0000004, 0x800000, CRC(1f6bb4f8) SHA1(0a4c55afad9ad60a5007c4302a6a676e029193ad) )
	ROM_LOAD64_WORD( "c88pr60.c4",   0x0000006, 0x800000, CRC(9557a245) SHA1(8aa6ff993f634585ef28b7e91bcf856d9022dc6d) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime63 ) // v0.63 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr63.p1", 0x000000, 0x80000, CRC(3c118687) SHA1(fcfce8783319abea1883f735fed9200c4d4a1e1f) )
	ROM_LOAD16_WORD_SWAP( "c88pr63.p2", 0x080000, 0x80000, CRC(15463013) SHA1(dafab9f1534371ed4fb6cca71f58b739ad13f895) )
	ROM_LOAD16_WORD_SWAP( "c88pr63.p3", 0x100000, 0x80000, CRC(d1900881) SHA1(822ee1257dcf00ab5d564414abbf860a41f8e474) )
	ROM_LOAD16_WORD_SWAP( "c88pr63.p4", 0x180000, 0x80000, CRC(c9efd3cc) SHA1(67dda75d209bcbf71c613905447c46bfd0f5781c) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr63.c1",   0x0000000, 0x800000, CRC(24171a13) SHA1(1d87622826c7884819d2d9296cca63d3e3f91831) )
	ROM_LOAD64_WORD( "c88pr63.c2",   0x0000002, 0x800000, CRC(3fac6432) SHA1(e47d5ba7751facd7e7865d7b96b2b8aa498dfb15) )
	ROM_LOAD64_WORD( "c88pr63.c3",   0x0000004, 0x800000, CRC(61e2d574) SHA1(70d05b1fb7f26211dad5c84c89c83f04f93997cd) )
	ROM_LOAD64_WORD( "c88pr63.c4",   0x0000006, 0x800000, CRC(c60e7306) SHA1(a12e1184f619c1f3c6153019aeef476362add508) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( sf2prime ) // v0.66 - press 9 to insert coin
	ROM_REGION( CODE_SIZE, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_WORD_SWAP( "c88pr.p1", 0x000000, 0x80000, CRC(27b6ac88) SHA1(becdc139f0af175fbbc91c230753d095253d0acc) )
	ROM_LOAD16_WORD_SWAP( "c88pr.p2", 0x080000, 0x80000, CRC(8d9baac1) SHA1(3b302e2483f72a8a0f7327089de0c86620890ee3) )
	ROM_LOAD16_WORD_SWAP( "c88pr.p3", 0x100000, 0x80000, CRC(15f6c1b9) SHA1(66c8ae49a05ce50dd606867ff7ab5d08a02f1314) )
	ROM_LOAD16_WORD_SWAP( "c88pr.p4", 0x180000, 0x80000, CRC(095ee372) SHA1(644e756e2a1280c573b348632a8d3b77994b15dc) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88pr.c1",   0x0000000, 0x800000, CRC(51b072ab) SHA1(5bc384ea17aa2826904aa2f7b4be2f0905cc6383) )
	ROM_LOAD64_WORD( "c88pr.c2",   0x0000002, 0x800000, CRC(f236c5da) SHA1(4d30ff915447a4933f19f375be9116d34f80ef17) )
	ROM_LOAD64_WORD( "c88pr.c3",   0x0000004, 0x800000, CRC(ea223314) SHA1(0d49439eb0103b38e7c283b6c43fb77e39337dbf) )
	ROM_LOAD64_WORD( "c88pr.c4",   0x0000006, 0x800000, CRC(623b6cb3) SHA1(1427bcb56b62df3870e627b9f245b5864a8d26be) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88pr.m1",   0x00000, 0x08000, CRC(6ce233a7) SHA1(5ff00de2fa8f31e66c9518049828d532554cb316) )
	ROM_CONTINUE(           0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",     0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88pr.q1",   0x000000, 0x800000, CRC(cd8b2d9f) SHA1(bc4965b1cb6c211cdcf29ab5988702abd82effbc) )
ROM_END

ROM_START( hsf2s02 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s02.p1", 0x000000, 0x80000, CRC(b5952336) SHA1(e5396781d525343b285613255bbafa77aa53ed31) )
	ROM_LOAD16_WORD_SWAP( "c88s02.p2", 0x080000, 0x80000, CRC(7a02d7b6) SHA1(00c69673cadb86efaa8c96c778d3b4a9f61bd1e4) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",  0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",  0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",  0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",  0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",  0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",  0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )
ROM_END

ROM_START( hsf2s03 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s03.p1",  0x000000, 0x80000, CRC(0bf821b4) SHA1(7cb4e76ca58b151475e15e670235f2426eb8bd00) )
	ROM_LOAD16_WORD_SWAP( "c88s03.p2",  0x080000, 0x80000, CRC(c245f9a3) SHA1(bd2220f439c716d672531405c22fdc1d621b3109) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s04 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s04.p1",  0x000000, 0x80000, CRC(bf63d85b) SHA1(6ce1e31b85c9086e04de614b0c4a5280dfc2d46a) )
	ROM_LOAD16_WORD_SWAP( "c88s04.p2",  0x080000, 0x80000, CRC(c1c0c809) SHA1(ba26bbc4c6ff17bfcc87618d720a2bcba202e4ab) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s05 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s05.p1", 0x000000, 0x80000, CRC(24a21bd3) SHA1(4bf24c24ad8c14545accf0e5359dcee905ef45dc) )
	ROM_LOAD16_WORD_SWAP( "c88j1.p2",  0x080000, 0x80000, CRC(40072c4a) SHA1(85b95bd3c907b4276a31777e092b8c40d3763257) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s06 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s06.p1", 0x000000, 0x80000, CRC(08f66ef0) SHA1(53b16fbbd3395dca5538213e1896583cc315ad27) )
	ROM_LOAD16_WORD_SWAP( "c88s06.p2",  0x080000, 0x80000, CRC(ee7fc7e9) SHA1(1317af1636c36a1d80faff92691a01ac47cc7626) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s07 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s07.p1", 0x000000, 0x80000, CRC(d6fbe270) SHA1(ea7cc743127521404635aa608a1a23c62d251f4f) )
	ROM_LOAD16_WORD_SWAP( "c88s07.p2",  0x080000, 0x80000, CRC(50b4b202) SHA1(866b0a69ba188d6faed8ea2a821a02bc6ffc1f53) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s08 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s08.p1", 0x000000, 0x80000, CRC(bdeebd26) SHA1(26c5fcdbba22876fe22a399bd90e72892f0489f0) )
	ROM_LOAD16_WORD_SWAP( "c88j1.p2",  0x080000, 0x80000, CRC(40072c4a) SHA1(85b95bd3c907b4276a31777e092b8c40d3763257) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s09 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88j1.p1",  0x000000, 0x80000, CRC(00738f73) SHA1(99947a621f21a88dc4c425d9bfbc30b3c5f76ecd) )
	ROM_LOAD16_WORD_SWAP( "c88s09.p2",  0x080000, 0x80000, CRC(071f73b0) SHA1(9198db8a147ad416f4d6f2949467b8fadd4787d1) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s10 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s10.p1",  0x000000, 0x80000, CRC(f880c7a4) SHA1(c117a50e7cee6e4901ec3245dffda2df689b6d9c) )
	ROM_LOAD16_WORD_SWAP( "c88s10.p2",  0x080000, 0x80000, CRC(b69c62bb) SHA1(8d59377d5c34af4ea12b29b32f000a01a7e3c8d9) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s11 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s11.p1",  0x000000, 0x80000, CRC(252b335d) SHA1(68a710cbac6377cf3276289c3ee641be968ba15b) )
	ROM_LOAD16_WORD_SWAP( "c88j1.p2",  0x080000, 0x80000, CRC(40072c4a) SHA1(85b95bd3c907b4276a31777e092b8c40d3763257) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s12 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88j1.p1",  0x000000, 0x80000, CRC(00738f73) SHA1(99947a621f21a88dc4c425d9bfbc30b3c5f76ecd) )
	ROM_LOAD16_WORD_SWAP( "c88s12.p2",  0x080000, 0x80000, CRC(c46d367a) SHA1(45b36693f5e36c080018ac8ca5a6ff3d57c1b453) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s13 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s13.p1",  0x000000, 0x80000, CRC(75a74653) SHA1(c44d20797312f0f025f71d7a369b7c6e85b0656f) )
	ROM_LOAD16_WORD_SWAP( "c88s13.p2",  0x080000, 0x80000, CRC(87c71607) SHA1(cdc8f6fb5877ea8a39484ea07b49e6ff4ad82a38) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2j.key",    0x00, 0x14, CRC(19455a93) SHA1(925cee29b37cb7a4048383ac715ad96f83280d37) )
ROM_END

ROM_START( hsf2s14 )
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88u.p1",  0x000000, 0x80000, CRC(b308151e) SHA1(afdfd3b049c6435e2291bc35d8c26ff5bff223d8) )
	ROM_LOAD16_WORD_SWAP( "c88u.p2",  0x080000, 0x80000, CRC(327aa49c) SHA1(6719cd6ecc2a4487fdbf5cbcd47e35fc43000607) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88s14.p7",   0x300000, 0x80000, CRC(ed1c9127) SHA1(4e4da9fccbd62323dfdfff27a67db865fce54b70) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2.key",     0x00, 0x14, CRC(fc9b18c9) SHA1(457b6ba05458f1be9ebb8aa9cbab0a8808cb6857) )
ROM_END

ROM_START( hsf2s15 ) // difficulty fix
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c88s15.p1",  0x000000, 0x80000, CRC(2ef3f7db) SHA1(062eb0f2a38c23557cc0723e74ea458f7c3d6f61) )
	ROM_LOAD16_WORD_SWAP( "c88u.p2",  0x080000, 0x80000, CRC(327aa49c) SHA1(6719cd6ecc2a4487fdbf5cbcd47e35fc43000607) )
	ROM_LOAD16_WORD_SWAP( "c88.p3",   0x100000, 0x80000, CRC(dde34a35) SHA1(f5be2d2916db6e86e0886d61d55bddf138273ebc) )
	ROM_LOAD16_WORD_SWAP( "c88.p4",   0x180000, 0x80000, CRC(f4e56dda) SHA1(c6490707c2a416ab88612c2d73abbe5853d8cb92) )
	ROM_LOAD16_WORD_SWAP( "c88.p5",   0x200000, 0x80000, CRC(ee4420fc) SHA1(06cf76660b0c794d2460c52d9fe8334fff51e9de) )
	ROM_LOAD16_WORD_SWAP( "c88.p6",   0x280000, 0x80000, CRC(c9441533) SHA1(bf178fac1f060fcce3ff9118333c8517dadc9429) )
	ROM_LOAD16_WORD_SWAP( "c88.p7",   0x300000, 0x80000, CRC(3fc638a8) SHA1(2a42877b26c8abc437da46225701f0bba6e40058) )
	ROM_LOAD16_WORD_SWAP( "c88.p8",   0x380000, 0x80000, CRC(20d0f9e4) SHA1(80a5eeef9472e327b0d4ee26434bad109a9434ea) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c88.c1",   0x0000000, 0x800000, CRC(a6ecab17) SHA1(6749a4c8dc81f4b10f910c31c82cf6674e2a44eb) )
	ROM_LOAD64_WORD( "c88.c2",   0x0000002, 0x800000, CRC(10a0ae4d) SHA1(701b4900fbc8bef20efa1a706891c8df4bf14641) )
	ROM_LOAD64_WORD( "c88.c3",   0x0000004, 0x800000, CRC(adfa7726) SHA1(8d36ec125a8c91abfe5213893d794f8bc11c8acd) )
	ROM_LOAD64_WORD( "c88.c4",   0x0000006, 0x800000, CRC(bb3ae322) SHA1(ecd289d7a0fe365fdd7c5527cb17796002beb553) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c88.m1",   0x00000, 0x08000, CRC(c1a13786) SHA1(c7392c7efb15ea4042e75bd9007e974293d8935d) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c88.m2",   0x28000, 0x20000, CRC(2d8794aa) SHA1(c634affdc2568020cce6af97b4fa79925d9943f3) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c88.q1",   0x000000, 0x800000, CRC(0e15c359) SHA1(176108b0d76d821a849324680aba0cd04b5016c1) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "hsf2.key",     0x00, 0x14, CRC(fc9b18c9) SHA1(457b6ba05458f1be9ebb8aa9cbab0a8808cb6857) )
ROM_END

/*******************
  Mars Matrix
********************/
ROM_START( mmatrix01 ) // trap15 unfuck version
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c82s01.p1", 0x000000, 0x80000, CRC(a578097b) SHA1(7d7153d58930d07aca61b9cddab650b687db51ff) )
	ROM_LOAD16_WORD_SWAP( "c82.p2",    0x080000, 0x80000, CRC(0135fc6c) SHA1(e40c8fa51dcb300b3ee72dc7de137e0b39dea490) )
	ROM_LOAD16_WORD_SWAP( "c82s01.p3", 0x100000, 0x80000, CRC(a1fbd3d8) SHA1(87a2494c88de302b10bb70a218d74ccf6b3b59a8) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c82.c1",   0x0000000, 0x400000, CRC(04748718) SHA1(d2e84d9dcc779c08469d815ccd709f30705954b8) )
	ROM_LOAD64_WORD( "c82.c2",   0x0000002, 0x400000, CRC(38074f44) SHA1(2002c4862c156b314bc4f3372b713c48e0667ec3) )
	ROM_LOAD64_WORD( "c82.c3",   0x0000004, 0x400000, CRC(e4635e35) SHA1(48ef7a82df83b981ddd6138c241ca129ab770e8e) )
	ROM_LOAD64_WORD( "c82.c4",   0x0000006, 0x400000, CRC(4400a3f2) SHA1(d0aa805ccbb153896e5983da1c398d1df4f40371) )
	ROM_LOAD64_WORD( "c82.c5",   0x1000000, 0x400000, CRC(d52bf491) SHA1(2398895cfdcf86fc485472e33df2cc446539e977) )
	ROM_LOAD64_WORD( "c82.c6",   0x1000002, 0x400000, CRC(23f70780) SHA1(691ee8964815b0ce54704e7feb59ca79b634f26d) )
	ROM_LOAD64_WORD( "c82.c7",   0x1000004, 0x400000, CRC(2562c9d5) SHA1(e7defc3d33db632c4035ae069f2f2332c58afaf5) )
	ROM_LOAD64_WORD( "c82.c8",   0x1000006, 0x400000, CRC(583a9687) SHA1(1d0b08b1e88509245db3c2090f0201938fd750b4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c82s01.01",   0x00000, 0x08000, CRC(45a29ce5) SHA1(f06f4479188c21e8be08797e4d86769c85aaaa1b) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c82.q1",   0x000000, 0x400000, CRC(4180b39f) SHA1(cabb1c358eae1bb6cfed07f5b92e4acd38650667) )
	ROM_LOAD16_WORD_SWAP( "c82.q2",   0x400000, 0x400000, CRC(95e22a59) SHA1(b3431d170c0a1a0d826ad0af21300b9180e3f114) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mmatrix.key", 0x000000, 0x000014, CRC(8ed66bc4) SHA1(324d7bf9d95220ecab140b1385eba7087f1a9669) )
ROM_END

ROM_START( mmatrixj01 ) // trap15 unfuck version
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c82j01.p1", 0x000000, 0x80000, CRC(dec3c9da) SHA1(91cfecd18ac3181387355e7b43ae8466b44ccb53) )
	ROM_LOAD16_WORD_SWAP( "c82j.p2",   0x080000, 0x80000, CRC(d943a339) SHA1(ae3d217b35f92fc727bda3b14f13f3658dab3dd8) )
	ROM_LOAD16_WORD_SWAP( "c82j01.p3", 0x100000, 0x80000, CRC(c1a306fa) SHA1(3c7f2b4c86b8e96b13802bb942c6a7fbff041c86) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c82.c1",   0x0000000, 0x400000, CRC(04748718) SHA1(d2e84d9dcc779c08469d815ccd709f30705954b8) )
	ROM_LOAD64_WORD( "c82.c2",   0x0000002, 0x400000, CRC(38074f44) SHA1(2002c4862c156b314bc4f3372b713c48e0667ec3) )
	ROM_LOAD64_WORD( "c82.c3",   0x0000004, 0x400000, CRC(e4635e35) SHA1(48ef7a82df83b981ddd6138c241ca129ab770e8e) )
	ROM_LOAD64_WORD( "c82.c4",   0x0000006, 0x400000, CRC(4400a3f2) SHA1(d0aa805ccbb153896e5983da1c398d1df4f40371) )
	ROM_LOAD64_WORD( "c82.c5",   0x1000000, 0x400000, CRC(d52bf491) SHA1(2398895cfdcf86fc485472e33df2cc446539e977) )
	ROM_LOAD64_WORD( "c82.c6",   0x1000002, 0x400000, CRC(23f70780) SHA1(691ee8964815b0ce54704e7feb59ca79b634f26d) )
	ROM_LOAD64_WORD( "c82.c7",   0x1000004, 0x400000, CRC(2562c9d5) SHA1(e7defc3d33db632c4035ae069f2f2332c58afaf5) )
	ROM_LOAD64_WORD( "c82.c8",   0x1000006, 0x400000, CRC(583a9687) SHA1(1d0b08b1e88509245db3c2090f0201938fd750b4) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c82s01.m1",   0x00000, 0x08000, CRC(45a29ce5) SHA1(f06f4479188c21e8be08797e4d86769c85aaaa1b) )
	ROM_CONTINUE(         0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c82.q1",   0x000000, 0x400000, CRC(4180b39f) SHA1(cabb1c358eae1bb6cfed07f5b92e4acd38650667) )
	ROM_LOAD16_WORD_SWAP( "c82.q2",   0x400000, 0x400000, CRC(95e22a59) SHA1(b3431d170c0a1a0d826ad0af21300b9180e3f114) )

	ROM_REGION( 0x20, "key", 0 )
	ROM_LOAD( "mmatrixj.key", 0x000000, 0x000014, CRC(3b50d889) SHA1(fb749a5da0a799322ec131a15a017971e586c5fc) )
ROM_END


/*******************
  Misc hacks
********************/
ROM_START( ffightaec2 ) // ffightae_cps2
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "c07eac2.p1", 0x000000, 0x80000, CRC(b598d599) SHA1(f4e5ebc3c1900fbfb004f8e6532ffb8593622fe5) )
	ROM_LOAD16_WORD_SWAP( "c07aec2.p2", 0x080000, 0x80000, CRC(3615cfb9) SHA1(f83ebdb084505b3c35513f40666ad828846339d2) )

	ROM_REGION( 0x2000000, "gfx", 0 )
	ROM_LOAD64_WORD( "c07aec2.c1",     0x000000, 0x400000, CRC(3f4028c5) SHA1(4a4cf19422f4f0fc66ce18ea082320c5adb59750) )
	ROM_LOAD64_WORD( "c07aec2.c2",     0x000002, 0x400000, CRC(be3858b0) SHA1(ec9e1be10bba4c3b8bf35fca821cd7f4025dfb4a) )
	ROM_LOAD64_WORD( "c07aec2.c3",     0x000004, 0x400000, CRC(ed622314) SHA1(f7155a41d4fdbcdd4e626b86de18c391125298e3) )
	ROM_LOAD64_WORD( "c07aec2.c4",     0x000006, 0x400000, CRC(d65b53e9) SHA1(6df4aa177a38407814a35a3560da4e9c301b3fa0) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "c07aec2.m1",   0x00000, 0x08000, CRC(7ee68d38) SHA1(d533226911c23be34aa9df7d7ee37a0b2cf407ab) )
	ROM_CONTINUE(         0x10000, 0x18000 )
	ROM_LOAD( "c78.m2",   0x28000, 0x20000, CRC(72445dc4) SHA1(14fca7596ac45ba655016eef5b6120f9f9671c23) )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD16_WORD_SWAP( "c07aec2.q1",   0x000000, 0x400000, CRC(71af8d5a) SHA1(8e9dfcd1d44f792cff4b13f8b8f73aa8f9b0a2ec) )
	ROM_LOAD16_WORD_SWAP( "c78.q2",   0x400000, 0x400000, CRC(f392b13a) SHA1(fa04ce0370144a49bd1d5acd873eef87b0dc9d15) )
ROM_END



/*    YEAR  NAME        PARENT    MACHINE    INPUT      CLASS       INIT       MONITOR COMPANY          FULLNAME                    FLAGS */
GAME( 2000, mpangj01,   mpang,    dead_cps2, cps2_2p3b, cps2_state, init_cps2, ROT0, "Razoola", "Mighty! Pang (001011J, Phoenix Edition)", MACHINE_SUPPORTS_SAVE )

// 19XX The War Against Destiny
GAME( 1996, 19xxs01,    19xx,     cps2,      cps2_2p2b, cps2_state, init_cps2, ROT270, "DDJ", "19XX: The War Against Destiny (951207U, Ex Super Version)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, 19xxs02,    19xx,     cps2,      cps2_2p2b, cps2_state, init_cps2, ROT270, "hack", "19XX: The War Against Destiny (951207, Chinese)", MACHINE_SUPPORTS_SAVE )
// 1944 The Loop Master
GAME( 2000, 1944s01,    1944,     cps2,      cps2_2p2b, cps2_state, init_cps2, ROT0, "DDJ", "1944: The Loop Master (000620U, Strongest Fire Power)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, 1944s02,    1944,     dead_cps2, cps2_2p3b, cps2_state, init_cps2, ROT0, "Razoola", "1944: The Loop Master (000620U, Phoenix Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, 1944s03,    1944,     cps2,      cps2_2p2b, cps2_state, init_cps2, ROT0, "Qxs8", "1944: The Loop Master (000620U, Fire Power Plus, 2011-12-31)", MACHINE_SUPPORTS_SAVE )
// Alien vs. Predator
GAME( 2017, avsps01,    avsp,     cps2,      cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Alien vs. Predator (940520U, 1 Vs 3 Plus, 2017-12-30)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, avsps02,    avsp,     cps2,      cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Alien vs. Predator (940520U, Enhanced Edition, 2018-02-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, avsps03,    avsp,     dead_cps2, cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Alien vs. Predator (940520E, Ultimate Evolution Edition, 2020-05-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, avsps04,    avsp,     dead_cps2, cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Alien vs. Predator (940520E, Ultimate Evolution Edition, 2020-09-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, avsps05,    avsp,     cps2,      cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Alien vs. Predator (940520H, Modified Edition, 2020-08-30)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, avsps06,    avsp,     dead_cps2, cps2_3p3b, cps2_state, init_cps2, ROT0, "Razoola", "Alien vs. Predator (940520U, Phoenix edition)", MACHINE_SUPPORTS_SAVE )
// Armored Warriors
GAME( 2020, armwars01,  armwar,   dead_cps2, cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Armored Warriors (941011E, Full Attack Edition, 2020-05-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, armwars02,  armwar,   cps2,      cps2_3p3b, cps2_state, init_cps2, ROT0, "hack", "Armored Warriors (941011E, Full Attack Edition, 2020-08-30)", MACHINE_SUPPORTS_SAVE )
// Battle Circuit
GAME( 2019, batcirs01,  batcir,   dead_cps2, cps2_4p2b, cps2_state, init_cps2, ROT0, "hack", "Battle Circuit (970319E, Evolution, 2019-10-21)", MACHINE_SUPPORTS_SAVE )
// Capcom Sports Club
GAME( 1997, csclub01,   csclub,   cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Hooooook", "Capcom Sports Club (971017E, Time Increases)", MACHINE_SUPPORTS_SAVE )
GAME( 1997, csclub02,   csclub,   cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "hack", "Capcom Sports Club (970722, Korea)", MACHINE_SUPPORTS_SAVE )
// Cyberbots Fullmetal Madness
GAME( 1995, cybots01,   cybots,   cps2,      cybots,    cps2_state, init_cps2, ROT0, "Pipi899", "Cyberbots: Fullmetal Madness (950420J, Get Maximum Power On Attack)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, cybots02,   cybots,   cps2,      cybots,    cps2_state, init_cps2, ROT0, "KyleW", "Cyberbots: Fullmetal Madness (950424E, Access Mod)", MACHINE_SUPPORTS_SAVE )
// Dungeons & Dragons Shadow over Mystara
GAME( 1996, ddsomak,    ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619, Korea, alt)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, ddsomjk,    ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619, Korea)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, ddsoms01,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "Mushroom Chick", "Dungeons & Dragons: Shadow over Mystara (960619J, Chinese, 2017-04-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, ddsoms02,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619J, Full Attack Edition, 2020-08-31)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, ddsoms03,   ddsom,    dead_cps2, cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619U, Enhanced Edition, 2019-10-22)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, ddsoms04,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "Pipi899", "Dungeons & Dragons: Shadow over Mystara (960619A, 1vs4 Players, 2009-06-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, ddsoms05,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619J, Chinese)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, ddsoms06,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "Pipi899", "Dungeons & Dragons: Shadow over Mystara (960619E, Strengthen The Physical Model, 2009-06-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, ddsoms07,   ddsom,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "e107", "Dungeons & Dragons: Shadow over Mystara (960619J, Change the Final Strike condition, 2009-07-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, ddsoms08,   ddsom,    dead_cps2, cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Shadow over Mystara (960619U, Plus, 2016-08-25)", MACHINE_SUPPORTS_SAVE )
// Dungeons & Dragons: Tower of Doom
GAME( 2020, ddtods01,   ddtod,    cps2,      cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Tower of Doom (940412H, Full Attack Edition, 2020-08-31)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, ddtods02,   ddtod,    dead_cps2, cps2_4p4b, cps2_state, init_cps2, ROT0, "hack", "Dungeons & Dragons: Tower of Doom (940412E, Plus)", MACHINE_SUPPORTS_SAVE )
// Darkstalkers: The Night Warriors
GAME( 2016, dstlks01,   dstlk,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Darkstalkers: The Night Warriors (940705E, Simplify Edition, 2016-12-06)", MACHINE_SUPPORTS_SAVE )
// Vampire The Night Warriors
GAME( 2006, vampj01,    dstlk,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Vampire: The Night Warriors (940705J, Enable hidden characters, 2006-05-31)", MACHINE_SUPPORTS_SAVE )
// Giga Wing
GAME( 1999, gigawings01,gigawing, cps2,      cps2_2p2b, cps2_state, init_cps2, ROT0, "LB70", "Giga Wing (990222U, Ex Super Version V1)", MACHINE_SUPPORTS_SAVE )
// Hyper Street Fighter II
GAME( 2025, sf2prime3,  hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.3)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime4,  hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.4)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime41, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.41)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime45, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.45)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime50, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.50)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime55, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.55)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime56, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.56)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime57, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.57)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime59, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.59)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime60, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.60)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime63, hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.63)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, sf2prime,   hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter II': Prime (v0.66)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s02,    hsf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji/MasterStiller", "Hyper Street Fighter II: The Anniversary Edition (040202J, Enabled Hidden Characters In Normal Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s03,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blue-Ray", "Hyper Street Fighter II: The Anniversary Edition (031222J, Simplify The Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, hsf2s04,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Hyper Street Fighter II: The Anniversary Edition (031222J, Gouki Edition, 2018-07-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s05,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Can Choose Same Character)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s06,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Changed Character v2)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s07,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Easy Move v2)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s08,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Choose Hidden Character)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s09,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Hit Anywhere)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s10,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Level Plus)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s11,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Always Have Super Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s12,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Real Gouki)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s13,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Hyper Street Fighter II: The Anniversary Edition (031222J, Special Move For Zangief)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, hsf2s14,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blue-Ray", "Hyper Street Fighter II: The Anniversary Edition (040202U, 30% Blood)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, hsf2s15,    hsf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Hyper Street Fighter II: The Anniversary Edition (040202U, difficulty fix)", MACHINE_SUPPORTS_SAVE )
// Rockman 2
GAME( 1996, rockman2k,  megaman2, cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "hack", "Rockman 2: The Power Fighters (960708, Korea)", MACHINE_SUPPORTS_SAVE )
// Mars Matrix
GAME( 2025, mmatrix01,  mmatrix,  cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Trap15", "Mars Matrix: Hyper Solid Shooting (250412U)(improvement)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, mmatrixj01, mmatrix,  cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Trap15", "Mars Matrix: Hyper Solid Shooting (250412J)(improvement)", MACHINE_SUPPORTS_SAVE )
// Marvel Super Heroes
GAME( 2014, mshs01,     msh,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Marvel Super Heroes (951117J, Rise Again, 2014-12-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mshs02,     msh,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Marvel Super Heroes (951024E, Enhanced Edition, 2015-12-04)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, mshs03,     msh,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Super Heroes (951117J, Get maximum power on attack)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, mshs04,     msh,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Marvel Super Heroes (951024E, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
// Marvel Super Heroes Vs. Street Fighter
GAME( 2010, mshvsfs01,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Kakakawa", "Marvel Super Heroes Vs. Street Fighter (970625E, Substitute At Any Time, 2010-08-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, mshvsfs02,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Kakakawa", "Marvel Super Heroes Vs. Street Fighter (970625E, Enhanced Edition, 2013-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, mshvsfs03,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Super Heroes Vs. Street Fighter (970707J, Modify the Order, 2008-07-21)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, mshvsfs04,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Marvel Super Heroes Vs. Street Fighter (970707J, Rise Again, 2014-12-14)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mshvsfs05,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Marvel Super Heroes Vs. Street Fighter (970707J, Enhanced Edition, 2015-12-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, mshvsfs06,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blackheart", "Marvel Super Heroes Vs. Street Fighter (970707J, Easy Moves, 2009-04-23)", MACHINE_SUPPORTS_SAVE )
GAME( 1997, mshvsfs07,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Marvel Super Heroes Vs. Street Fighter (970707J, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 1997, mshvsfs08,  mshvsf,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Super Heroes Vs. Street Fighter (970707J, Get maximum power on attack)", MACHINE_SUPPORTS_SAVE )
// Marvel Vs. Capcom Clash of Super Heroes
GAME( 1998, mvscs01,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "0 DAY-S[EGCG]", "Marvel Vs. Capcom: Clash of Super Heroes (980123U, Enable EX.Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mvscs02,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Marvel Vs. Capcom: Clash of Super Heroes (980123E, Enhanced Edition, 2013-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, mvscs03,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Vs. Capcom: Clash of Super Heroes (980123J, Modify the Order V1, 2008-07-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, mvscs04,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Vs. Capcom: Clash of Super Heroes (980123J, Modify the Order V2, 2009-07-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, mvscs05,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blackheart", "Marvel Vs. Capcom: Clash of Super Heroes (980123J, Easy Moves, 2009-04-24)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, mvscs06,    mvsc,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Marvel Vs. Capcom: Clash of Super Heroes (980123J, Get maximum power on attack)", MACHINE_SUPPORTS_SAVE )
// Super Gem Fighter
GAME( 1997, sgemfs01,   sgemf,    cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "hack", "Super Gem Fighter (970904U, Color remix)", MACHINE_SUPPORTS_SAVE )
// Pocket Fighter
GAME( 2008, pfghtj01,   sgemf,    cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Pipi899", "Pocket Fighter (970904J, Command Change, 2008-01-12)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, pfghtj02,   sgemf,    cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Pipi899", "Pocket Fighter (970904J, Enhanced Power, 2008-07-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, pfghtj03,   sgemf,    cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Pipi899", "Pocket Fighter (970904J, Move Mod, 2007-10-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, pfghtj04,   sgemf,    cps2,      cps2_2p3b, cps2_state, init_cps2, ROT0, "Blackheart", "Pocket Fighter (970904J, Resurgence Lite, 2014-12-17)", MACHINE_SUPPORTS_SAVE )
// Progear No Arashi
GAME( 2001, progearj01, progear,  dead_cps2, cps2_2p3b, cps2_state, init_cps2, ROT0, "lb70", "Progear no Arashi (010117J, Crazy Fire Version V1)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, progearj02, progear,  dead_cps2, cps2_2p3b, cps2_state, init_cps2, ROT0, "Halfway House", "Halfway to Hell - Progear Red Label (2016-01-17 Red label ver)", MACHINE_SUPPORTS_SAVE )
// Super Street Fighter II The New Challengers
GAME( 1993, ssf2s01,    ssf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Super Street Fighter II: The New Challengers (931005J, Unknown Hack, 2012-09-12)", MACHINE_SUPPORTS_SAVE )
GAME( 1993, ssf2s02,    ssf2,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Razoola", "Super Street Fighter II: The New Challengers (930911ETC, Phoenix Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 1993, ssf2s03,    ssf2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Super Street Fighter II: The New Challengers (930911ETC, Zangief instruction simplification, 2009-01-05)", MACHINE_SUPPORTS_SAVE )
// Super Street Fighter II Turbo
GAME( 2014, ssf2t01,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "KrysoFun", "Super Street Fighter II Turbo (940223ETC, Accelerated Plus V0.9 Beta, 2014-12-16)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, ssf2t02,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Super Street Fighter II Turbo (940223ETC, Instruction Is Simplified, 2009-05-28)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2t03,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "Super Street Fighter II Turbo (940323U, Nude Cammy)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2t04,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Jason[FGCH]", "Super Street Fighter II Turbo (940323U, Retro color)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2t05,    ssf2t,    dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Razoola", "Super Street Fighter II Turbo (940223ETC, Phoenix Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2t06,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Cigarette Patch", "Super Street Fighter II Turbo (940223ETC, French Parody)", MACHINE_SUPPORTS_SAVE )
GAME( 2005, ssf2t07,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Shyma.X", "Super Street Fighter II Turbo (050401F, French, 2015-01-XX)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2t08,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "KrysoFun", "Super Street Fighter II Turbo (940223ETC, Plus v0.9 beta)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, ssf2t09,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Super Street Fighter II Turbo (940223ETC, difficulty fix)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, ssf2t10,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Super Street Fighter II Turbo (940223U, difficulty fix)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, ssf2tnl3,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.3 beta, 2020-05-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, ssf2tnl4,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.4 beta, 2020-11-13)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, ssf2tnl5,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.5 beta, 2021-06-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, ssf2tnl6,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.6 beta, 2022-02-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, ssf2tnl7,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.7 beta, 2022-07-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, ssf2tnl71,  ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.7.1 beta, 2022-09-06)", MACHINE_SUPPORTS_SAVE )
GAME( 2023, ssf2tnl8,   ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.8 beta, 2023-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, ssf2tnl,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Born2SPD", "Super Street Fighter II Turbo (New Legacy v0.9 beta, 2024-04-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, ssf2x01,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Super Street Fighter II X: Grand Master Challenge (940223J, Change FireBall, 2012-01-07)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2x02,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blue-Ray", "Super Street Fighter II X: Grand Master Challenge (940223J, Gouki Color Change)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2x03,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Super Street Fighter II X: Grand Master Challenge (940223J, Choose hidden characters easier)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2x04,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Jason[FGCH]", "Super Street Fighter II X: Grand Master Challenge (940223J, Retro color)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, ssf2x05,    ssf2t,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Shiro", "Super Street Fighter II X: Grand Master Challenge (940223J, Nude Cammy)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Alpha
GAME( 1995, sfas01,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji/MasterStiller", "Street Fighter Alpha: Warriors' Dreams (950727E, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfas02,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji/MasterStiller", "Street Fighter Alpha: Warriors' Dreams (950727E, Simplified)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, sfas03,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha: Warriors' Dreams (950727E, Easy Move, 2017-03-23)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfas04,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha: Warriors' Dreams (950727E, Enable Hidden Character, 2016-08-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfas05,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha: Warriors' Dreams (950727E, Full Power, 2016-08-26)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfas06,     sfa,      dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Razoola", "Street Fighter Alpha: Warriors' Dreams (950727U, Phoenix Edition)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Zero
GAME( 2007, sfzj01,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero (950727J, Command Change, 2007-12-22)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfzj02,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero (950727J, Enhanced Power)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfzj03,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero (950727J, Fist Punch Enhancement, 2009-06-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfzj04,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero (950727J, Moves Hack, 2007-11-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, sfzj05,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero (950727J, Super-Entry Force To Modify, 2008-02-17)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfzj06,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero (950727J, Enable hidden characters V2)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfzj07,     sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero (950727J, Enable hidden characters V1)", MACHINE_SUPPORTS_SAVE )
GAME( 1995, sfzk,       sfa,      cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero (950727, Korea)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Alpha 2
GAME( 2016, sfa2s01,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha 2 (960229E, Easy Move, 2016-11-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfa2s02,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha 2 (960229E, Full Power, 2016-09-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, sfa2s03,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha 2 (960229E, Press Select Button Changed Character, 2019-12-27)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfa2s04,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 2 (960430U, Command Change, 2007-12-16)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, sfa2s05,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 2 (960430U, Super Killing Force Modification, 2008-02-17)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfa2s06,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 2 (960430U, Cancellation Power)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfa2s07,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 2 (960229E, Simplified)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa2s08,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Alpha 2 (960306U, Unlock Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfa2s09,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 2 (960229E, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, sfa2s10,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "GOTVG", "Street Fighter Alpha 2 (960229E, Crazy Edition, 2019-04-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2023, sfa2s11,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 2 (960430U, Ultra Edition)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Zero 2
GAME( 1996, sfz2j01,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero 2 (960227J, Boss hack)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2k01,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero 2 (960430, Korea)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2k02,    sfa2,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero 2 (960227, Korea)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Zero 2 Alpha
GAME( 1996, sfz2alk,    sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero 2 Alpha (960805, Korea)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfz2als01,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Command Change, 12-10-2007)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfz2als02,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Easy Moves Hack, 2007-10-11)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2als03,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero 2 Alpha (960805J, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2als04,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Enhanced Power)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfz2als05,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Moves Hack, 2007-10-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, sfz2als06,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Super Combo, 2008-02-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, sfz2als07,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Dragon Edition v2.1, 2009-04-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, sfz2als08,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero 2 Alpha (960805J, Dragon Fighter Enhanced Edition, 2014-11-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, sfz2als09,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "MamePlus", "Street Fighter Zero 2 Alpha (960805J, Fatal Fury Chun-Li, 2019-03-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, sfz2als10,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "MamePlus", "Street Fighter Zero 2 Alpha (Super Golden, 2020-02-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfz2als11,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Zero 2 Alpha (960805J, Dragon Drop Simplified, 2016-10-31)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2als12,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero 2 Alpha (960826A, Simplified)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfz2als13,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Zero 2 Alpha (960826A, Easy Move, 2016-11-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfz2als14,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Zero 2 Alpha (960826A, Full Power, 2016-09-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, sfz2als15,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Enhanced Dan Version, 2008-12-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfz2als16,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Dragon Edition v1.0, 2009-03-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfz2als17,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 2 Alpha (960805J, Dragon Edition v2.0, 2009-04-24)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, sfz2als18,  sfz2al,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "BisonSAS", "Street Fighter Zero 2 Alpha (061225BR, Brazil)", MACHINE_SUPPORTS_SAVE ) // portuguese-brazilian hack fix
// Street Fighter Alpha 3
GAME( 2009, sfa3s01,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 3 (980904E, Modified Version Of The Directive, 2009-05-10)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfa3s02,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "Street Fighter Alpha 3 (980904E, Simplified)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfa3s03,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 3 (980904U, Moves Hack, 2007-11-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, sfa3s04,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Dodowang[EGCG]", "Street Fighter Alpha 3 (980904U, Unlock All Modes, 2004-04-18)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfa3s05,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blue-Ray", "Street Fighter Alpha 3 (980904U, 2vs1 27 Round)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, sfa3s06,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 3 (980904E, Dragon Edition, 2014-11-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfa3s07,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha 3 (980904E, Easy Move, 2016-11-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, sfa3s08,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "DDJ", "Street Fighter Alpha 3 (980904E, Full Power, 2016-09-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, sfa3s09,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 3 (980904E, Dragon Drop, 2020-04-09)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, sfa3s10,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 3 (980904E, Dragon Drop Simplified, 2020-04-09)", MACHINE_SUPPORTS_SAVE )
GAME( 2005, sfa3s11,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "BisonSAS & Alan Yagami", "Street Fighter Alpha 3 (050513BR, Brazil)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, sfa3s12,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Grego and Gnawtor", "Street Fighter Alpha 3 (210408U, Challenger's Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s13,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 3 (980904E, Xiang Long edition, 2009-05-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s14,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "shiro", "Street Fighter Alpha 3 (980904E, Nude Cammy Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s15,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 3 (980904E, Nude Chunli Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s16,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "hack", "Street Fighter Alpha 3 (980904E, Nude Juli & Juni Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s17,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 3 (980904E, Hidden Character Full Version Fix, 2009-09-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s18,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Alpha 3 (980904E, Boss Special, 2009-07-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfa3s19,    sfa3,     cps2,      cps2_2p6bt,cps2_state, init_cps2, ROT0, "Dodowang", "Street Fighter Alpha 3 (980904U, Revision Version)", MACHINE_SUPPORTS_SAVE )
// Street Fighter Zero 3
GAME( 1998, sfz3j01,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Balrog Lifts The Scene Crawl Limit)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j02,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Command Change)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j03,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Command Change V2)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j04,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Command Change V2.1)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j05,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Command Change V2.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfz3j06,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Command Change V3, 2007-12-22)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j07,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Enhanced Power)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfz3j08,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Hidden Character Full Version Restored, 2009-09-27)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j09,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blue-Ray", "Street Fighter Zero 3 (980904J, 2vs1 27 Round)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j10,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "Street Fighter Zero 3 (980727J, Nude Cammy)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j11,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "Street Fighter Zero 3 (980727J, Nude Chun-Li)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j12,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "Street Fighter Zero 3 (980727J, Nude Juli & Juni)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, sfz3j13,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Grego and Gnawtor", "Street Fighter Zero 3 (210408U, Challenger's Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 1998, sfz3j14,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "Street Fighter Zero 3 (980904J, Enable hidden characters)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfz3j15,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blacheart", "Street Fighter Zero 3 (980904J, Easy Moves, 2009-05-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, sfz3j16,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Moves hack, 2017-03-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, sfz3j17,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Street Fighter Zero 3 (980904J, Shin Edition, 2009-01-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, sfz3j18,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "0xZERO3", "Street Fighter Zero 3 (980629J, Training Edition v1.1)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3j19,    sfa3,     cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "0xZERO3", "Street Fighter Zero 3 (980629J, Training Edition v1.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix07,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.07)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix07a, sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.07a)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix07b, sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.07b)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix08,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.08)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix09,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.09)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix10,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.10)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix11,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.11)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix12,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.12)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, sfz3mix13,  sfa3,     dead_cps2, cps2_2p6b, cps2_state, init_cps2, ROT0, "Zero800", "Street Fighter Zero 3 (Mix 0.13)", MACHINE_SUPPORTS_SAVE )
// Super Puzzle Fighter II X
GAME( 1996, spf2t01,    spf2t,    cps2,      cps2_2p2b, cps2_state, init_cps2, ROT0, "hack", "Super Puzzle Fighter II Turbo (960620U, Boss Hack)", MACHINE_SUPPORTS_SAVE )
// CPS-2 Suicide Tester (derived from spf2t)
GAME( 2015, suicide,    0,        dead_cps2, cps2_2p2b, cps2_state, init_cps2, ROT0, "Razoola", "Suicide Test", MACHINE_SUPPORTS_SAVE )
GAME( 2015, suicide2,   suicide,  dead_cps2, cps2_2p2b, cps2_state, init_cps2, ROT0, "Razoola", "Suicide Test v2", MACHINE_SUPPORTS_SAVE )
// Vampire Savior 2 The Lord of Vampire
GAME( 2008, vsav2s01,   vsav2,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Vampire Savior 2: The Lord of Vampire (970913J, Command Change, 2008-04-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, vsav2s02,   vsav2,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "Vampire Savior 2: The Lord of Vampire (970913J, Infinite Power, 2008-07-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, vsav2s03,   vsav2,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blackheart", "Vampire Savior 2: The Lord of Vampire (970913J, Vampire Kingdom Study Order Simplification, 2009-04-30)", MACHINE_SUPPORTS_SAVE )
// X-Men Children of the Atom
GAME( 1994, xmcotas01,  xmcota,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "X-Men: Children of the Atom (941219J, Enable Hidden Characters)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, xmcotas02,  xmcota,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "X-Men: Children of the Atom (941219J, Enhanced Edition, 2013-01-09)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, xmcotas03,  xmcota,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Yumeji", "X-Men: Children of the Atom (941219J, Boss hack)", MACHINE_SUPPORTS_SAVE )
GAME( 1994, xmcotas04,  xmcota,   cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "X-Men: Children of the Atom (941222J, Enhanced power)", MACHINE_SUPPORTS_SAVE )
// X-Men Vs. Street Fighter
GAME( 1996, xmvsfs01,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "shiro", "X-Men Vs. Street Fighter (961004E, Nude Alpha Chun Li)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, xmvsfs02,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "hack", "X-Men Vs. Street Fighter (960910E, Enhanced Edition, 2015-12-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, xmvsfs03,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blackheart", "X-Men Vs. Street Fighter (960910E, Enhanced Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2008, xmvsfs04,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "X-Men Vs. Street Fighter (961004J, Modify the Order, 2008-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, xmvsfs05,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Pipi899", "X-Men Vs. Street Fighter (961004J, Enhanced power)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, xmvsfs06,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Blackheart", "X-Men Vs. Street Fighter (960910E, Easy Moves, 2009-04-22)", MACHINE_SUPPORTS_SAVE )
GAME( 1996, xmvsfs07,   xmvsf,    cps2,      cps2_2p6b, cps2_state, init_cps2, ROT0, "Ydmis", "X-Men Vs. Street Fighter (960910E, Change character in battle)", MACHINE_SUPPORTS_SAVE )
// Misc hacks
GAME( 2022, ffightaec2, 0,        dead_cps2, cps2_3p3b, cps2_state, init_cps2, ROT0, "Grego and Gnawtor", "Fight Fight Anniversary Edition (CPS2 hardware)", MACHINE_SUPPORTS_SAVE )


ROM_START( cps2xx )  // not working, bad tiles
	ROM_REGION( CODE_SIZE, "maincpu", 0 )
	ROM_LOAD( "cps2xx.68k",      0x000000, 0x010000, CRC(8414c946) SHA1(154f8dc8f86e1dd97f0455da6a1c72efa41a19e0) )

	ROM_REGION( 0x400000, "gfx", 0 )
	ROM_LOAD( "cps2xx.tile",     0x000000, 0x400000, CRC(eb9d5a2b) SHA1(61335ce00c2c6cec8a1302dbe6644f8cffc6ac9b) )

	ROM_REGION( QSOUND_SIZE, "audiocpu", 0 )
	ROM_LOAD( "cps2xx.z80",   0x00000, 0x08000, CRC(2d3b4220) SHA1(2b2d04d4282550fa9f6e1ad8528f20d1f2ac02eb) )
	ROM_CONTINUE(             0x10000, 0x18000 )

	ROM_REGION( 0x800000, "qsound", 0 )
	ROM_LOAD( "cps2xx.qs", 0x000000, 0x400000, CRC(627be4da) SHA1(bf7c98ff6dc8921794c26a51846caf0cb834a3e9) )
ROM_END

GAME( 2008, cps2xx, 0, dead_cps2, cps2_2p2b, cps2_state, init_cps2nc, ROT0, "hack", "CPS2XX demo", MACHINE_NOT_WORKING | MACHINE_SUPPORTS_SAVE )

