// license:GPL_2.0
// copyright-holders:Robbbert
// Metal Slug 4
#include "includes/neogeo.h"

//	Hacks for decrypted sets
//	ROM_FILL(0x1741,1,0x78) // select LEVEL-8 by default
//	ROM_FILL(0x1745,1,0x34) // turn on LEVEL number by default

void neogeo_state::init_mslug4hb() // hacks of mslug4
{
	init_neogeo();
	m_sprgen->m_fixed_layer_bank_type = 1;

	// decrypt m1 if needed
	if (memregion("audiocrypt"))
		m_cmc_prot->neogeo_cmc50_m1_decrypt(audiocrypt_region, audiocrypt_region_size, audiocpu_region, audio_region_size);

	// decrypt v roms if needed
	u8 *ram = memregion("ymsnd:adpcma")->base();
	if (ram[0x20] != 0x99)
	{
		//printf("ym=%X\n",ram[0x20]);
		m_pcm2_prot->neo_pcm2_snk_1999(ym_region, ym_region_size, 8);
	}

	// decrypt c roms if needed
	ram = memregion("sprites")->base();
	if (ram[0] != 0)
	{
		//printf("Sprites=%X\n",ram[0]);
		m_cmc_prot->cmc50_neogeo_gfx_decrypt(spr_region, spr_region_size, MSLUG4_GFX_KEY);
	}

	// if no s rom, copy info from end of c roms
	ram = memregion("fixed")->base();
	if (ram[0x100] == 0)
	{
		//printf("Fixed1=%X\n",ram[0x100]);
		m_cmc_prot->neogeo_sfix_decrypt(spr_region, spr_region_size, fix_region, fix_region_size);
	}
}

#if 0
ROM_START( mslug4 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263.p1",  0x000000, 0x100000, CRC(27e4def3) SHA1(a08785e8145981bb6b5332a3b2df7eb321253cca) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END
#endif

ROM_START( mslug4a )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263a.p1",  0x000000, 0x100000, CRC(61cdef09) SHA1(7c028fc416e4c32b11b895ec05d210749edaac55) )
	ROM_LOAD16_WORD_SWAP( "263a.p2",  0x100000, 0x400000, CRC(87dc01b9) SHA1(ddad7d72e53e0c6273384119f96b3b7f324ca237) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )

	NEO_BIOS_AUDIO_128K( "263nd.m1", CRC(ef5db532) SHA1(4aeba9e206b8f309610eb7e1891644f39aa61830) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4ar )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263ar.p1",  0x000000, 0x100000, CRC(f0c97843) SHA1(cb6a276d1c5a0b1d942b1f2eeb5f7c35f1500704) )
	ROM_LOAD16_WORD_SWAP( "263ar.p2",  0x100000, 0x400000, CRC(1464718d) SHA1(972f7993bde5fc429494939c2c8c9f32d6bfc07a) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )

	NEO_BIOS_AUDIO_128K( "263nd.m1", CRC(ef5db532) SHA1(4aeba9e206b8f309610eb7e1891644f39aa61830) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4eh2 ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh2.p1",   0x000000, 0x100000, CRC(2cb01721) SHA1(9a7e3a28f9f26848f36fa19d66ae9b7588e8dd7e) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4eh3 ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh3.p1",   0x000000, 0x100000, CRC(628f101f) SHA1(fc787b550c788dd8d8207927d679dd8ad7b50eb1) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4eh4 ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh4.p1",   0x000000, 0x100000, CRC(3d08cdbd) SHA1(b311a52c794e3ffc623dff6ead91ccd79c2f2af9) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4eh5 ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh5.p1",   0x000000, 0x100000, CRC(35d4a0f3) SHA1(94c55dfe8d00c1920b14fc1770a626fd4bdec325) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4eh6 ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh6.p1",   0x000000, 0x100000, CRC(246c7a6f) SHA1(46607bbd256b3af5092526f8dd57e0b211e55d88) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4eh ) /* Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eh.p1",    0x000000, 0x100000, CRC(42866fc5) SHA1(0ef57352b28fae2b884dfc021a2fd0bdf36456cb) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4kh ) /* Metal Slug 4 - Enhance by Creamymami and Fighters Kim - (Style remix 20030731) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263kh.p1",    0x000000, 0x100000, CRC(883680c2) SHA1(9ba71d9cf4eb8615cf6fe94b74c6436876dcb0b2) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4xg )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263xg.p1",    0x000000, 0x100000, CRC(358a28ce) SHA1(b998a77f73cbc42e8ee1f580bd3780c675197b8e) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )
	// fixes freeze in attract mode
	ROM_FILL(0xc56c6,1,0x1d)
	ROM_FILL(0xc56c7,1,0x40)
	ROM_FILL(0xc56d0,1,0x1d)
	ROM_FILL(0xc56d1,1,0x41)

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4d )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263.p1",  0x000000, 0x100000, CRC(27e4def3) SHA1(a08785e8145981bb6b5332a3b2df7eb321253cca) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4dh ) // Super D Version
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263dh.p1", 0x000000, 0x100000, CRC(af69d959) SHA1(2bc9796003c8742d681e11ad842978d918fbae40) )
	ROM_LOAD16_WORD_SWAP( "263dh.p2", 0x100000, 0x400000, CRC(2b863b30) SHA1(b5edc43d87faf6540e3154fcbab42efb148cbd04) )

	NEO_SFIX_MSLUG( "263dh.s1", CRC(c4f4ed0e) SHA1(bbf31c879d72cc843229b03db01399af98e02f01) )

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4eho ) /* [OLD] Metal Slug 4 - Enhance by Creamymami - (Style remix 20030414) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263eho.p1",   0x000000, 0x100000, CRC(41fea527) SHA1(17a8cf630b2ad6e58c51a2f1d01ceff2d1ef970e) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4fr ) /* Metal Slug 4 - Translation Hack by NEO-ARC - (French translation) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263fr.p1",    0x000000, 0x100000, CRC(a1343a37) SHA1(23ead1154427c67881b4670fd8ecf5089e32ac0b) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4i ) /* NeoArc Italian translation */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263i.p1",    0x000000, 0x100000, CRC(ffb20602) SHA1(4d3103d613a2452c95ae15b70670664354dce67b) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MSLUG( "263i.s1", CRC(1f67801e) SHA1(87c33e74599ca063da459f3c8562447bccc104e3) )

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4nd )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263nd.p1",   0x000000, 0x100000, CRC(4D7E6624) SHA1(125d5203e89cce23a851fa74cc8cbe003ef978f3) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263nd.m1", CRC(ef5db532) SHA1(4aeba9e206b8f309610eb7e1891644f39aa61830) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263nd.v1", 0x000000, 0x400000, CRC(c1b2af81) SHA1(532dca0a2b2e03d50c6ac3adc9ebceb413f61690) )
	ROM_LOAD( "263nd.v2", 0x400000, 0x400000, CRC(cbbdc6fa) SHA1(06abb738cf198804248ecfc92adea38f7f86f612) )
	ROM_LOAD( "263nd.v3", 0x800000, 0x400000, CRC(c4f1a3cc) SHA1(109e8db93875e1b1f3db293d1756b2bbebe63a28) )
	ROM_LOAD( "263nd.v4", 0xC00000, 0x400000, CRC(40126a0a) SHA1(4234e0f4d9a9dc486d7af1eec91a17840a57976d) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263nd.c3", 0x1000000, 0x800000, CRC(63fb79ff) SHA1(a7da0a554034792721abda4369a71b0c8045f334) )
	ROM_LOAD16_BYTE( "263nd.c4", 0x1000001, 0x800000, CRC(e8623126) SHA1(66c2b874cd55c628e7e6768d6f31180c29a734e7) )
	ROM_LOAD16_BYTE( "263nd.c5", 0x2000000, 0x400000, CRC(3348DC5D) SHA1(a119e80aa2b36a7d8c7e8debd0eb13441a19adff) )
	ROM_LOAD16_BYTE( "263nd.c6", 0x2000001, 0x400000, CRC(D90FC1A0) SHA1(0eaf5f658212c19a4cdbcdbff3b04389a2be76bb) )
ROM_END

ROM_START( mslug4sp ) // all confirmed: same as mslug4 except p roms
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263sp.p1", 0x000000, 0x100000, CRC(44b6f3d7) SHA1(d6c9b84e1758f731be21c7506ffb5c8837fbc19c) )
	ROM_LOAD16_WORD_SWAP( "263dh.p2", 0x100000, 0x400000, CRC(2b863b30) SHA1(b5edc43d87faf6540e3154fcbab42efb148cbd04) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh01.p1",  0x000000, 0x100000, CRC(968cce41) SHA1(f492a6ac798f6d282711391f14f8e44186e650fd) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh02.p1",  0x000000, 0x100000, CRC(0edd0cc9) SHA1(46c77a2d96550db95a7bcf8293ee50ef1b2a8813) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh03.p1",  0x000000, 0x100000, CRC(1bb1a16b) SHA1(E89c4009939d6318e38c4c3734f0b0df50430fba) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh04.p1",  0x000000, 0x100000, CRC(E624f7f6) SHA1(9c3072393ffe6cddf6f0cbcf1caf672590a9a9bc) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh05.p1",  0x000000, 0x100000, CRC(4ca241b5) SHA1(E5e958c3c10eae2069677fab66903539af40e6eb) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh06.p1",  0x000000, 0x100000, CRC(9f91f4c1) SHA1(63049a3ed3d9486ced5423affb8023ffc7e63cad) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh07.p1",  0x000000, 0x100000, CRC(810517b5) SHA1(1c825d5643787b3d89a48f988173fa4ac7033e02) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh08.p1",  0x000000, 0x100000, CRC(8b76b699) SHA1(Ad16d773ccb8a7892e6a53dd904846a46f56b540) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh09.p1",  0x000000, 0x100000, CRC(95e255ed) SHA1(552cda8a2bdfc9b2c901e98ba85e56cac54c88fa) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh10.p1",  0x000000, 0x100000, CRC(F1253b49) SHA1(1b44c0830bcfb52f5aa824ca1220b258f3c20633) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh11.p1",  0x000000, 0x100000, CRC(Cc0cfda1) SHA1(58893e160c51fe8b66dea8ade9e2ea7acf252d88) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh12.p1",  0x000000, 0x100000, CRC(A8cb9305) SHA1(23af0960326e317fb260cc2c86d849f6e286a641) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh13.p1",  0x000000, 0x100000, CRC(75a20c15) SHA1(97e303ab7591ab6063f09bb8d4849dad86139f95) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh14.p1",  0x000000, 0x100000, CRC(Bc2cd15d) SHA1(Ca27372e291c0b642f6b76d6461bc5da328909e7) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh15.p1",  0x000000, 0x100000, CRC(Efb1d83d) SHA1(F5ec172e0db9fb174c073e61eb1c5264cc50f24a) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh16.p1",  0x000000, 0x100000, CRC(E5c27911) SHA1(Ee60489b68ffd3a628c09c652c171b76dcb318bf) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh17.p1",  0x000000, 0x100000, CRC(B65f7071) SHA1(Bc5b1eb2aa66f6a20102e3f8d539f1e62dff62ce) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh18.p1",  0x000000, 0x100000, CRC(Fb569a65) SHA1(Ad2dbca8ff894cbe9a0b7c7ab555e9cc98550fe5) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh19.p1",  0x000000, 0x100000, CRC(D8ebbff9) SHA1(4c3958ba6df56a0b4805681bcc9cd8c00f048349) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh20.p1",  0x000000, 0x100000, CRC(61454e4d) SHA1(D23451f78eef57cbb4c73d96522f3d5e60ab0248) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh21 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh21.p1",  0x000000, 0x100000, CRC(D2981ed5) SHA1(F86675adf6f975347d8e504c9dc2ac9634df71fc) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh22 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh22.p1",  0x000000, 0x100000, CRC(A2b83229) SHA1(04e86f2d80c48948e01c4913f30227be8e6fd8b4) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh23 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh23.p1",  0x000000, 0x100000, CRC(6b36ef61) SHA1(7944901416c8ee31fc762620da17689cbcdb6a56) )
	ROM_LOAD16_WORD_SWAP( "263-ph2.sp2", 0x100000, 0x400000, CRC(bc3ec89e) SHA1(2cb0626bc4fa57e1d25f208e04532b570d87b3fb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh24 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263-ph1.p1",  0x000000, 0x100000, CRC(c67f5c8d) SHA1(12af74964843f103520d9f0825069ea2f67eeb2f) )
	ROM_LOAD16_WORD_SWAP( "263hh24.p2", 0x100000, 0x400000, CRC(6a0f5d76) SHA1(51988f17c3ebb78a7adbf48b8c2ee57665b9a53c) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh25 ) //mslug4dg
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh25.p1",  0x000000, 0x100000, CRC(36dfa877) SHA1(dd49b6b40d3c2cabac8d5efa71cceea8cf9fc4f8) )
	ROM_LOAD16_WORD_SWAP( "263hh25.p2", 0x100000, 0x400000, CRC(cf6feb75) SHA1(133e1d97a3ae14835dcb7b6a642c3968cd174547) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh26 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh26.p1",    0x000000, 0x100000, CRC(8901649d) SHA1(fa7f9a7166668c3e4f2dbcc0989eb966757ca05d) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4hh27 ) //mslug4lw
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh27.p1", 0x000000, 0x100000, CRC(417b7738) SHA1(2b55c0a19a85a72aaf745aef16fb796eb9e5c482) )
	ROM_LOAD16_WORD_SWAP( "263hh27.p2", 0x100000, 0x800000, CRC(37bce641) SHA1(74344b36f980beaceb225cc5cd5afaec9b05ded6) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh28 ) //mslug4lw
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh28.p1", 0x000000, 0x100000, CRC(09de4992) SHA1(ebb890833cfe66147fe429a20f143e54c8e88f96) )
	ROM_LOAD16_WORD_SWAP( "263hh40.p2", 0x100000, 0x800000, CRC(427eed0b) SHA1(6062f783d63748ec9fccad414d3c0a830295aad8) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh29 ) //mslug4mny
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh29.p1", 0x000000, 0x500000, CRC(a3aa70b6) SHA1(102a41ebeae7ec4d03725d25996b40d185ef7497) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh30 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh30.p1",  0x000000, 0x100000, CRC(03516faa) SHA1(C78e9da62fd440165a1c595b80092ebdf8bee576) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh31 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh31.p1",  0x000000, 0x100000, CRC(6bb85c5b) SHA1(98c338826a8bc8c593a49525aeb3474208335763) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh32 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh32.p1",  0x000000, 0x100000, CRC(B846b1d1) SHA1(C03b3f43dac6722bea23d3007393dd9ccde3958e) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh33 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh33.p1",   0x000000, 0x100000, CRC(414416d1) SHA1(78d3f7bc4a5e603c8035a2c9ece3969f9ee1b567) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh34 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh34.p1",    0x000000, 0x100000, CRC(a3ceab91) SHA1(f0e125e708bb466308e6846bb943022f4b5785a3) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4hh35 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh35.p1",  0x000000, 0x100000, CRC(D663ac14) SHA1(Da0449b3c68702f3edb71f01557d5050891e0d3a) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh36 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh36.p1",  0x000000, 0x100000, CRC(358e9ecd) SHA1(175f34505ab7979d6648c9c799ea492f19ce3ece) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh37 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh37.p1",  0x000000, 0x100000, CRC(8286dfd3) SHA1(5ce31cfe6d08327ae4c8598699bcd5269fd0a91d) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh38 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh38.p1",  0x000000, 0x100000, CRC(3f7ce3c5) SHA1(A0a9cf5d887f2ff9c048d2bb22cfba168b393df0) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh39 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh34.p1",    0x000000, 0x100000, CRC(a3ceab91) SHA1(f0e125e708bb466308e6846bb943022f4b5785a3) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh38.c1", 0x0000000, 0x800000, CRC(4586314e) SHA1(54a4b9731f0a3b48fce8a842b74fb699bfdf32f8) )
	ROM_LOAD16_BYTE( "263hh38.c2", 0x0000001, 0x800000, CRC(2e10ad0b) SHA1(38215adacd47a48c4640703c8a9f6234235c8ae8) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263hh38.c5", 0x2000000, 0x800000, CRC(658a0425) SHA1(ad54b9d5219c24f7214d755af520e6409a9314dd) )
	ROM_LOAD16_BYTE( "263hh38.c6", 0x2000001, 0x800000, CRC(17fb9d89) SHA1(8fd141f3db0ac0cd60157ddbd3d3b2f90fea522b) )
ROM_END

ROM_START( mslug4hh40 ) //mslug4ammor
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh40.p1", 0x000000, 0x100000, CRC(21b68d31) SHA1(97b287e2cbd4eb20fe65339c5d1d42b864e8a440) )
	ROM_LOAD16_WORD_SWAP( "263hh40.p2", 0x100000, 0x800000, CRC(427eed0b) SHA1(6062f783d63748ec9fccad414d3c0a830295aad8) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh41 )   // mslug4dr
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh41.p1",   0x000000, 0x100000, CRC(1c5b60d9) SHA1(8ee80711f03792009c0a9c7df3b7b3f7846c4f3b) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh42 ) //mslug4dr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh42.p1",   0x000000, 0x100000, CRC(4ae77816) SHA1(ba4284496d6db70d29fac720e73509c5bc277594) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh43 ) //mslug4maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh43.p1",   0x000000, 0x500000, CRC(13f8af0b) SHA1(eb6fcaaec8967175e070f823e2f99c4735c2f366) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh44 ) //mslug4dr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh44.p1",   0x000000, 0x100000, CRC(c2376c7c) SHA1(1d7a89b17abd3f1d565d041755e6935224453758) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh45 ) //mslug41v2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh45.p1",  0x000000, 0x100000, CRC(dddca463) SHA1(d93ca67aed8cdf0765713056a5b6a9a77f09c848) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh46 ) //mslug4c
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh46.p1",   0x000000, 0x100000, CRC(fb0effec) SHA1(8ac1875949e974c88f8ee0544957d5c396bf94ed) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh47 ) //mslug4dd
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263nd.p1",   0x000000, 0x100000, CRC(4D7E6624) SHA1(125d5203e89cce23a851fa74cc8cbe003ef978f3) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263nd.m1", CRC(ef5db532) SHA1(4aeba9e206b8f309610eb7e1891644f39aa61830) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263hh48.v2", 0x400000, 0x400000, CRC(94217b1e) SHA1(c468a192e2ec0952a20cfd9e391cf6c12346efb3) )
	ROM_LOAD( "263hh48.v3", 0x800000, 0x400000, CRC(7616fcec) SHA1(83006094379d0373b967603dcaa1cec69c2f746f) )
	ROM_LOAD( "263hh48.v4", 0xc00000, 0x400000, CRC(c5967f91) SHA1(874562109c3df9e1fdefbb3970092128aaa31a17) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh48 ) //mslug4c, mslug4dr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh48.p1",   0x000000, 0x100000, CRC(fc986dda) SHA1(8a47ba068ba679edb6432efbd35a946720ded368) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh49 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh49.p1",   0x000000, 0x100000, CRC(0132eff7) SHA1(07b100255d2cf9955ae28cfdd19fee3d7787832b) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh50 ) //mslug4c, mslug4dr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh50.p1",   0x000000, 0x100000, CRC(81fd4ae9) SHA1(0bb85d314b96e09e859d30f0a8714efc1884938b) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh51 ) //It is unknown whether an updated version or an older version.
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh51.p1",  0x000000, 0x100000, CRC(7c000d36) SHA1(9b60834d6fee94d6e841cd489cb4c0fb470d52b2) )
	ROM_LOAD16_WORD_SWAP( "263hh25.p2", 0x100000, 0x400000, CRC(cf6feb75) SHA1(133e1d97a3ae14835dcb7b6a642c3968cd174547) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh52 ) //mslug4dr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh52.p1",   0x000000, 0x100000, CRC(f8145f8d) SHA1(ba1df84c199e5f552c80ad7725f9cae5512fbb20) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh53 ) //mslug4maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh53.p1",  0x000000, 0x500000, CRC(65727473) SHA1(e0e29c131fed11d37997c208aeee92a68caaa4e4) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )

	//NEO_BIOS_AUDIO_ENCRYPTED_512K( "271hh53.m1", CRC(095c9345) SHA1(1ad7c698d059ff85e61726480dc816f79bc6160c) )
	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4hh54 ) //mslug4maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh54.p1",  0x000000, 0x500000, CRC(ae9e9d37) SHA1(ea85c99bcc12088e5196836284fb6180843cf4c4) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )
	//NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	//NEO_BIOS_AUDIO_ENCRYPTED_512K( "271hh53.m1", CRC(095c9345) SHA1(1ad7c698d059ff85e61726480dc816f79bc6160c) )
	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4hh55 ) //mslug4maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh55.p1",  0x000000, 0x500000, CRC(ed78da01) SHA1(c895b85509f67eef78dbfdb76c90faf5a30af73f) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )
	//NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	//NEO_BIOS_AUDIO_ENCRYPTED_512K( "271hh53.m1", CRC(095c9345) SHA1(1ad7c698d059ff85e61726480dc816f79bc6160c) )
	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4hh56 ) //mslug4sp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh56.p1", 0x000000, 0x100000, CRC(8e9a44bc) SHA1(abf8e0fd02b1cc74fc7741ff118126b4e06bfb32) )
	ROM_LOAD16_WORD_SWAP( "263dh.p2", 0x100000, 0x400000, CRC(2b863b30) SHA1(b5edc43d87faf6540e3154fcbab42efb148cbd04) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh57 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh57.p1",   0x000000, 0x100000, CRC(004519ea) SHA1(0ac6f48c24868a5f9d6eaa0a70727d49cca9f30b) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh58 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh58.p1",   0x000000, 0x100000, CRC(c8129049) SHA1(05399e7b216b53f7ce36853cc05c3120fed8dd13) )
	ROM_LOAD16_WORD_SWAP( "263.p2",  0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1",   0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2",   0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3",   0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4",   0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5",   0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6",   0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4hh59 ) //mslug4js
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh59.p1",   0x000000, 0x500000, CRC(5cba26bf) SHA1(1856dd658cdc73a82fa246359ca6f65c394b3032) )

	NEO_SFIX_512K( "263hh53.s1", CRC(1eaa05e0) SHA1(73a7e158c3c4fa602e17dcb517190fd91a9dbab8) )

	//NEO_BIOS_AUDIO_ENCRYPTED_512K( "271hh53.m1", CRC(095c9345) SHA1(1ad7c698d059ff85e61726480dc816f79bc6160c) )
	NEO_BIOS_AUDIO_64K( "263d.m1", CRC(0c4c42f8) SHA1(b7be47d909f5e4fcfe769ead0653d40e1e708d36) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263dh.v1", 0x000000, 0x800000, CRC(fd6b982e) SHA1(100313166c9ec57f1c540de05625c506b30ad13c) )
	ROM_LOAD( "263dh.v2", 0x800000, 0x800000, CRC(20125227) SHA1(2e350c0c580e87445bf103c01fc62b14f0c19216) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263d.c1", 0x0000000, 0x800000, CRC(a75ffcde) SHA1(97f405a95a56615ae49f79e1a69f98cc2f2434ef) )
	ROM_LOAD16_BYTE( "263d.c2", 0x0000001, 0x800000, CRC(5ab0d12b) SHA1(8a3d95dd2e9cc1b6dcf6a957fed43ee390248307) )
	ROM_LOAD16_BYTE( "263d.c3", 0x1000000, 0x800000, CRC(61af560c) SHA1(aa7bc45e03a6bbd18eb56d118d4932102ccb196a) )
	ROM_LOAD16_BYTE( "263d.c4", 0x1000001, 0x800000, CRC(f2c544fd) SHA1(179b064f81b49f5808d7a7a5bce28e95b09e5abe) )
	ROM_LOAD16_BYTE( "263d.c5", 0x2000000, 0x800000, CRC(84c66c44) SHA1(9273f44bf11891aa04ddd2cbb6442d084c2a2e04) )
	ROM_LOAD16_BYTE( "263d.c6", 0x2000001, 0x800000, CRC(5ed018ab) SHA1(e78501fa8a80960093a4d54ce952681a98300148) )
ROM_END

ROM_START( mslug4hh60 ) //mslug4xqjq
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh60.p1",   0x000000, 0x100000, CRC(d49685e0) SHA1(3701bff7f385974fbe12f3a5b15df119b1da6fca) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh61 ) //mslug4lw //Final Version//
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh61.p1", 0x000000, 0x100000, CRC(ad713169) SHA1(51c10dfa1b8fc3b0e7850c71920091dbd91d1ba5) )
	ROM_LOAD16_WORD_SWAP( "263hh40.p2", 0x100000, 0x800000, CRC(427eed0b) SHA1(6062f783d63748ec9fccad414d3c0a830295aad8) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4hh62 ) //mslug4lwp
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hh62.p1", 0x000000, 0x100000, CRC(657ebd6e) SHA1(2f2c5849d249df6cbfe412ea47e0f8d6da1568dd) )
	ROM_LOAD16_WORD_SWAP( "263hh27.p2", 0x100000, 0x800000, CRC(37bce641) SHA1(74344b36f980beaceb225cc5cd5afaec9b05ded6) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263hh48.v2", 0x400000, 0x400000, CRC(94217b1e) SHA1(c468a192e2ec0952a20cfd9e391cf6c12346efb3) )
	ROM_LOAD( "263hh48.v3", 0x800000, 0x400000, CRC(7616fcec) SHA1(83006094379d0373b967603dcaa1cec69c2f746f) )
	ROM_LOAD( "263hh62.v4", 0xc00000, 0x400000, CRC(35e79379) SHA1(7db3ccc72e008976a238af7ec3880969ed5dc893) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

/**************
  Metal Slug 4
*****************/

ROM_START( mslug4zb01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263zb01.p1",  0x000000, 0x100000, CRC(13040d33) SHA1(f8fc05307a617d04c6b22e76a259c60091acf2fe) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4zb02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263zb02.p1",  0x000000, 0x100000, CRC(97ca73ea) SHA1(3f2d3d15b73047891f904329900046224a86ae75) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4zb03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263zb03.p1",   0x000000, 0x100000, CRC(ea22bd49) SHA1(c55942394da9d11f9c42eefde841566fdd6c7ff7) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4zb04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263zb04.p1",   0x000000, 0x100000, CRC(934af7c7) SHA1(eaae1a9fb0ff8f5bafc588171f2b415c02e0e961) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mk01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mk01.p1",  0x000000, 0x100000, CRC(d7aa8e11) SHA1(c628aec510bb2c02d2f1e1e866cddbfd85c1e9e0) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mk02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mk02.p1",  0x000000, 0x100000, CRC(5364f0c8) SHA1(0cc52b699fe291b919320ad7a8a2e8f90b0e329a) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mk03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mk03.p1",   0x000000, 0x100000, CRC(2e8c3e6b) SHA1(3f29115f1ae5b4a87678f99a6d2892cc63e963f8) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mk04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mk04.p1",   0x000000, 0x100000, CRC(57e474e5) SHA1(8bc2cf768547ba93f47ae8934c7d47f0ca4f83fe) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mb01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mb01.p1",  0x000000, 0x100000, CRC(61890cd8) SHA1(fc84b87a8d702738bae85952089ec2f4c101cb94) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mb02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mb02.p1",  0x000000, 0x100000, CRC(e5477201) SHA1(56022fb5fc83478c435e5db751fb37de6252bbf4) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mb03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mb03.p1",   0x000000, 0x100000, CRC(98afbca2) SHA1(e3d903701c4c2e4f887edb08a8b8972bde2ecfaa) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4mb04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263mb04.p1",   0x000000, 0x100000, CRC(e1c7f62c) SHA1(2b140dc5eaacc2b8f1e6668735453e9a067eb630) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4erd01 ) // Exclusive in HBMAME
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263erd01.p1", 0x000000, 0x100000, CRC(45721afc) SHA1(e9c0d1e4a6b84c3475ad26d6a962f70537bb3b79) )
	ROM_LOAD16_WORD_SWAP( "263wh01.p2", 0x100000, 0x400000, CRC(fe1f929e) SHA1(2c4a1d19987844a1d4c05f9a07e112dfd338c980) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4erd02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263erd02.p1",   0x000000, 0x100000, CRC(750113bb) SHA1(85687305b42da94b626b0274a28c5ef60f6a69b6) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4erd03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263erd03.p1",   0x000000, 0x100000, CRC(46191695) SHA1(91c142d4b7ebbacc38ffa0befd9b6e914bc47df6) )
	ROM_LOAD16_WORD_SWAP( "263wh00.p2", 0x100000, 0x400000, CRC(0fc9c60a) SHA1(86fd8753fda5003c78c8622bccd001043ccc58a2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END

ROM_START( mslug4lwp01 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263lwp01.p1", 0x000000, 0x100000, CRC(50ee2908) SHA1(1cc9c92f0e87e35d8a1124acf54acb4fa33e3b67) )
	ROM_LOAD16_WORD_SWAP( "263lwp01.p2", 0x100000, 0x800000, CRC(d240abfd) SHA1(1e4c96df1861f17ff3b982be26e269d0cbdf20d5) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4lwp02 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263lwp02.p1", 0x000000, 0x100000, CRC(dec382a1) SHA1(829f3ad224ef6f248cb72ee65fd2c6eaa02122af) )
	ROM_LOAD16_WORD_SWAP( "263lwp01.p2", 0x100000, 0x800000, CRC(d240abfd) SHA1(1e4c96df1861f17ff3b982be26e269d0cbdf20d5) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4erms01 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263erms01.p1",  0x000000, 0x100000, CRC(515e8a0c) SHA1(64c9ef2704c91b21c469a5cffcf042ff84e614aa) )
	ROM_LOAD16_WORD_SWAP( "263wh03.p2", 0x100000, 0x400000, CRC(632d41d1) SHA1(a411b6657e540cca892687b16900ace75ca6bd24) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4erms02 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263erms02.p1",  0x000000, 0x100000, CRC(2cd6058a) SHA1(1168d6f0cb63d799b35f846b95ca98348c8e87a5) )
	ROM_LOAD16_WORD_SWAP( "263wh03.p2", 0x100000, 0x400000, CRC(632d41d1) SHA1(a411b6657e540cca892687b16900ace75ca6bd24) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4hqyvs01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hqyvs01.p1",    0x000000, 0x100000, CRC(7d0b5a9d) SHA1(29648dbd8b6fd023035d87a07181020d4d4d1b2d) )
	ROM_LOAD16_WORD_SWAP( "263wh03.p2", 0x100000, 0x400000, CRC(632d41d1) SHA1(a411b6657e540cca892687b16900ace75ca6bd24) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4hqyvs02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263hqyvs02.p1",    0x000000, 0x100000, CRC(0083d51b) SHA1(c89c8b52178867f00750b6cba2d19f127d1a32d6) )
	ROM_LOAD16_WORD_SWAP( "263wh03.p2", 0x100000, 0x400000, CRC(632d41d1) SHA1(a411b6657e540cca892687b16900ace75ca6bd24) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma01.p1",    0x000000, 0x100000, CRC(77ad246f) SHA1(56d308992ac6c6a16ee1509baaf40854de464bc0) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma02.p1",    0x000000, 0x100000, CRC(0a25abe9) SHA1(138538a5de7649a91033b3be2d2bb01ad0b49571) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma03.p1",    0x000000, 0x100000, CRC(6ec993bd) SHA1(1ad472eb613b53aae695a4f4f1a7a0e88fdbbfdb) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma04.p1",    0x000000, 0x100000, CRC(13411c3b) SHA1(160ce83a86f45b2eda17df3fa3561992f787dbf7) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma05.p1",    0x000000, 0x100000, CRC(6615fef3) SHA1(dbb6501b912765977a320f2009ea2dad64cbd241) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma06.p1",    0x000000, 0x100000, CRC(1b9d7175) SHA1(7f6db63ebd6ab7a9222620f8d5d2693a6480820f) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma07.p1",    0x000000, 0x100000, CRC(7f714921) SHA1(c8c787aa1922ad0d7ef9344ac6e175bbf9703557) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma08.p1",    0x000000, 0x100000, CRC(02f9c6a7) SHA1(e6f76fac17d7e57cd2b3fe2041a60061f094c084) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma09.p1",    0x000000, 0x100000, CRC(038721bb) SHA1(f60b5ed428a584a4f32c17b54035959e3e707270) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma10.p1",    0x000000, 0x100000, CRC(7e0fae3d) SHA1(edf190aecdf4d71282d8f877d3df405b5a491ca5) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma11.p1",    0x000000, 0x100000, CRC(314e4e1f) SHA1(2d9f76f967e3b33dc8064e175e1e64488d34288f) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma12.p1",    0x000000, 0x100000, CRC(4cc6c199) SHA1(8f9c7b9e21490d6d1156e592eb742001fff13618) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma13.p1",    0x000000, 0x100000, CRC(a5ec2d2d) SHA1(2c1d90d1bbca38ed37ee55986348b5234bd2ca6a) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma14.p1",    0x000000, 0x100000, CRC(d864a2ab) SHA1(262b0097e375a4e1caed42c2ba721eb9b1780ab2) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma15.p1",    0x000000, 0x100000, CRC(5c00fc19) SHA1(ad1c64b8234c6cf938d90fa8009f0ccacd07aa29) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma16.p1",    0x000000, 0x100000, CRC(2188739f) SHA1(30615574641f9b386901c17d8858f0d8582afdf8) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma17.p1",    0x000000, 0x100000, CRC(b454f7b1) SHA1(17dc0c4245a1fda077ae88d793eb652a90ca70e1) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma18.p1",    0x000000, 0x100000, CRC(c9dc7837) SHA1(f05a55d0e83eb5ba31af84479f89344967854910) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma19.p1",    0x000000, 0x100000, CRC(45644bcb) SHA1(70beebc198955aa720b4f988047c474d5e228476) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma20.p1",    0x000000, 0x100000, CRC(38ecc44d) SHA1(e7eb7e1ecc1fd11b6783ae61aeed3507b7955d16) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma21 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma21.p1",    0x000000, 0x100000, CRC(bc889aff) SHA1(e892238972e72f59e944ff0cfa3406781c7fa4cd) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rma22 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rma22.p1",    0x000000, 0x100000, CRC(c1001579) SHA1(7379bd64f2d2374bf3317f6a8dacea1e7e4741b9) )
	ROM_LOAD16_WORD_SWAP( "263wh04.p2", 0x100000, 0x400000, CRC(fd627d9a) SHA1(587c009ce7e6652e41a9bb9f039866ea8ef1e6e7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmb01 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb01.p1", 0x000000, 0x100000, CRC(6108972e) SHA1(07de8de1f081aad6390ffe1b43276994e4ebb5fe) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb02 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb02.p1", 0x000000, 0x100000, CRC(1c8018a8) SHA1(e72bc2f6dde5f627e88a261e2ebd48ea13a7fd00) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb03 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb03.p1", 0x000000, 0x100000, CRC(786c20fc) SHA1(66c8e2d48ab5d3ab11cb2d8cf94d04fee1c926d9) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb04 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb04.p1", 0x000000, 0x100000, CRC(05e4af7a) SHA1(195488d2e238aa269b904432cde1dea1c6224329) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb05 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb05.p1", 0x000000, 0x100000, CRC(70b04db2) SHA1(e96052afa566eddcb9a9c66e0804fb44b9d473e3) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb06 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb06.p1", 0x000000, 0x100000, CRC(0d38c234) SHA1(e7e0aad19a0ab0cdce86517066a17f45a372881e) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb07 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb07.p1", 0x000000, 0x100000, CRC(69d4fa60) SHA1(4cbd0386b42112dd9fa73a3f823fda50c2ee4f15) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb08 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb08.p1", 0x000000, 0x100000, CRC(145c75e6) SHA1(d3d745cbaee79830a649eac8b7f713d0094cdb7f) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb09 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb09.p1", 0x000000, 0x100000, CRC(152292fa) SHA1(56ac75a7d46d198819ce62a4cd2f135ce8264407) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb10 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb10.p1", 0x000000, 0x100000, CRC(68aa1d7c) SHA1(50fbb3d7cebce870587869d7ead2e41e6699f51e) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb11 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb11.p1", 0x000000, 0x100000, CRC(27ebfd5e) SHA1(cb70606b2b83fffe484b9df3fbe86001aef48628) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb12 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb12.p1", 0x000000, 0x100000, CRC(5a6372d8) SHA1(9cb05312efb6d9ee73636602fca70e0c32fd8230) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb13 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb13.p1", 0x000000, 0x100000, CRC(b3499e6c) SHA1(951069e7a8bd3643b9482dd26ef58d9189dda6b6) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb14 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb14.p1", 0x000000, 0x100000, CRC(cec111ea) SHA1(6d43c0f40b2768a8c37f7d33afcfed3ef04221bb) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb15 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb15.p1", 0x000000, 0x100000, CRC(4aa54f58) SHA1(2d35627b24e6a29cb112015e51bc6196d3a72792) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb16 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb16.p1", 0x000000, 0x100000, CRC(372dc0de) SHA1(c894bc2105e97a771d6a05e3652ecb92f9533664) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb17 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb17.p1", 0x000000, 0x100000, CRC(a2f144f0) SHA1(149b2004eec5e68395d23109b1bf73ea48717287) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb18 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb18.p1", 0x000000, 0x100000, CRC(df79cb76) SHA1(2278991bb82ba12a074c708ced7f8b748dcd0dd3) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb19 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb19.p1", 0x000000, 0x100000, CRC(53c1f88a) SHA1(10ab64931b8a95e7f287a796d6dedefe2c71371d) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb20 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb20.p1", 0x000000, 0x100000, CRC(2e49770c) SHA1(260ac6bc58d0b40915631818c9dbfb95b4b52105) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb21 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb21.p1", 0x000000, 0x100000, CRC(aa2d29be) SHA1(ce6898541fa9e7020f81e9ad780a37e753cf5787) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmb22 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmb22.p1", 0x000000, 0x100000, CRC(d7a5a638) SHA1(89eeb73b52da859a788aedae6cd6827e9ac2d135) )
	ROM_LOAD16_WORD_SWAP( "263wh05.p2", 0x100000, 0x800000, CRC(36351369) SHA1(4f9b55a41c33609f0bdb0e27aad14b675d07c605) )

	NEO_SFIX_128K( "263.s1", CRC(a9446774) SHA1(c5a309fd8ee6d6750a15c82e710218a3755e38b2) )

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263nd.c1", 0x0000000, 0x800000, CRC(361ddda6) SHA1(95f329019660f1ec7f15f6ea1e0c2bfc84b02ca8) )
	ROM_LOAD16_BYTE( "263nd.c2", 0x0000001, 0x800000, CRC(15d192c4) SHA1(0b9afb62a1d4d764d616408b09e17a05fc4a87e7) )
	ROM_LOAD16_BYTE( "263lw.c3", 0x1000000, 0x800000, CRC(e296612c) SHA1(57eb1861b738247aaf0643641268f676b71ed025) )
	ROM_LOAD16_BYTE( "263lw.c4", 0x1000001, 0x800000, CRC(c22e3ad0) SHA1(11ce301d4e5b4b1b76e2b82d18c4a9b8b56eeb20) )
	ROM_LOAD16_BYTE( "263lw.c5", 0x2000000, 0x400000, CRC(288cd91f) SHA1(a195be13d4ef19705cd3f08be1ec8cdacb29f159) )
	ROM_LOAD16_BYTE( "263lw.c6", 0x2000001, 0x400000, CRC(b015aeee) SHA1(24e12e72b82eea9e52a4cefc774efb3bd7db822f) )
ROM_END

ROM_START( mslug4rmc01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc01.p1",   0x000000, 0x100000, CRC(c2d716bd) SHA1(6835325a3e219d48822c7256964ab3c34fd1b7fe) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc02.p1",   0x000000, 0x100000, CRC(bf5f993b) SHA1(b1590d23affaf360a87212ad6719d26232a73aee) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc03.p1",   0x000000, 0x100000, CRC(dbb3a16f) SHA1(ec192b09c6d37849bd47da8e278666ad3ab7369a) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc04.p1",   0x000000, 0x100000, CRC(a63b2ee9) SHA1(4471b417459a529e0cb99691ffcfc031287df4d8) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc05.p1",   0x000000, 0x100000, CRC(d36fcc21) SHA1(81a01b70cd92536905087dd250cb9500166191d5) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc06.p1",   0x000000, 0x100000, CRC(aee743a7) SHA1(654720eddbcdea57bf17045b05f10e2218e6581a) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc07.p1",   0x000000, 0x100000, CRC(ca0b7bf3) SHA1(1dbfae36ddd11b45d22248584382d0b353ab986c) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc08.p1",   0x000000, 0x100000, CRC(b783f475) SHA1(3f50d19fa5eba6c3d6f457912f02002f051890dd) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc09.p1",   0x000000, 0x100000, CRC(b6fd1369) SHA1(807d6c23261868baad859324a3c3799b7e201fb7) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc10.p1",   0x000000, 0x100000, CRC(cb759cef) SHA1(de8ba430599ef4c15919f0ce7a3a787536cb879e) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc11.p1",   0x000000, 0x100000, CRC(84347ccd) SHA1(6f91131e905e5eac7617735922d08575bf3c5b9f) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc12.p1",   0x000000, 0x100000, CRC(f9bcf34b) SHA1(2fb48809f02230e74b4bce0f6defa4f07ae47cbe) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc13.p1",   0x000000, 0x100000, CRC(10961fff) SHA1(db05b1462221fffacc444f8363f1bab3dfd77a31) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc14.p1",   0x000000, 0x100000, CRC(6d1e9079) SHA1(409696172636ab1f497bd6f5a6387b31a5a988b0) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc15.p1",   0x000000, 0x100000, CRC(e97acecb) SHA1(ce4cf59f530713ecd215d1eafdbcf4750a022ac4) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc16.p1",   0x000000, 0x100000, CRC(94f2414d) SHA1(e6b67b2c71f1ee35355842692d49e69c2272eb0f) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc17.p1",   0x000000, 0x100000, CRC(012ec563) SHA1(b9beb072f7cbacb091085d8911d6962c939bfe08) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc18.p1",   0x000000, 0x100000, CRC(7ca64ae5) SHA1(9d28f14d99f88fae07b884a40c9f123ed4f7b4e6) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc19.p1",   0x000000, 0x100000, CRC(f01e7919) SHA1(28aa6c429825b8121693372e91076d7feabc33ec) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc20.p1",   0x000000, 0x100000, CRC(8d96f69f) SHA1(66cabe7780a30f3d00c2efaa77ec8df7a4b07021) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc21 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc21.p1",   0x000000, 0x100000, CRC(09f2a82d) SHA1(48d5a10220bc0d645935bbe75243b775eb733e76) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4rmc22 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263rmc22.p1",   0x000000, 0x100000, CRC(747a27ab) SHA1(8ea8ef8f501b517965a51e92b1167ca3f7d62f56) )
	ROM_LOAD16_WORD_SWAP( "263wh06.p2", 0x100000, 0x400000, CRC(b87a68ba) SHA1(e5c8091307e90b32f3a56d96bb51a708cd205278) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_128K( "263lw.m1", CRC(49b1453e) SHA1(e6296e1d6bb604f1a15cf8d1b273e97b6eb7cced) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263lw.v1", 0x000000, 0x400000, CRC(8cb5a9ef) SHA1(272ad312f8694acf9190ebf48d1c8a5fec73c130) )
	ROM_LOAD( "263lwl.v2", 0x400000, 0x400000, CRC(c9572c14) SHA1(4338aaceada29ea1cd2baf0d6ada4911246f5b09) )
	ROM_LOAD( "263lwl.v3", 0x800000, 0x400000, CRC(e7c14624) SHA1(1d17f7e7cfe9bb03f1a374b31427c4e5203433f2) )
	ROM_LOAD( "263lwl.v4", 0xc00000, 0x400000, CRC(b1e5ac70) SHA1(0d6eea68085c0e6cd7c7e29edb06f05a712f6d62) )
	ROM_IGNORE(0x400000)

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263hh50.c1", 0x0000000, 0x800000, CRC(6e53b397) SHA1(5ace71164b860a9a7fcf87395cb200a2baf06b6e) )
	ROM_LOAD16_BYTE( "263hh50.c2", 0x0000001, 0x800000, CRC(D1a7d312) SHA1(81180989e40b79f2be61115560154a2b1ece0304) )
	ROM_LOAD16_BYTE( "263hh50.c3", 0x1000000, 0x800000, CRC(325d475e) SHA1(E6acdc51af211a856745391c2b7098eef4ddcc8f) )
	ROM_LOAD16_BYTE( "263hh50.c4", 0x1000001, 0x800000, CRC(5c908d0f) SHA1(5092d8d215e85e7faa7f989e8ee16644dc16fe84) )
	ROM_LOAD16_BYTE( "263hh50.c5", 0x2000000, 0x800000, CRC(B85f3ae8) SHA1(4f73e5c7024e337d65b323447226b474e20a9738) )
	ROM_LOAD16_BYTE( "263hh50.c6", 0x2000001, 0x800000, CRC(9dfdad34) SHA1(Cfcdbf1d6b058ecccb8b1cc775397d0404bd5859) )
ROM_END

ROM_START( mslug4unity )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "263unity.p1",  0x000000, 0x100000, CRC(ef3501b6) SHA1(ffbf98407e9646590a59887c42aab47f3a2d67dd) )
	ROM_LOAD16_WORD_SWAP( "263.p2", 0x100000, 0x400000, CRC(fdb7aed8) SHA1(dbeaec38f44e58ffedba99e70fa1439c2bf0dfa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_128K( "263.m1", CRC(46ac8228) SHA1(5aeea221050c98e4bb0f16489ce772bf1c80f787) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "263.v1", 0x000000, 0x800000, CRC(01e9b9cd) SHA1(0b045c2999449f7dab5ae8a42e957d5b6650431e) )
	ROM_LOAD( "263.v2", 0x800000, 0x800000, CRC(4ab2bf81) SHA1(77ccfa48f7e3daddef5fe5229a0093eb2f803742) )

	ROM_REGION( 0x3000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "263.c1", 0x0000000, 0x800000, CRC(84865f8a) SHA1(34467ada896eb7c7ca58658bf2a932936d8b632c) )
	ROM_LOAD16_BYTE( "263.c2", 0x0000001, 0x800000, CRC(81df97f2) SHA1(2b74493b8ec8fd49216a627aeb3db493f76124e3) )
	ROM_LOAD16_BYTE( "263.c3", 0x1000000, 0x800000, CRC(1a343323) SHA1(bbbb5232bba538c277ce2ee02e2956ca2243b787) )
	ROM_LOAD16_BYTE( "263.c4", 0x1000001, 0x800000, CRC(942cfb44) SHA1(d9b46c71726383c4581fb042e63897e5a3c92d1b) )
	ROM_LOAD16_BYTE( "263.c5", 0x2000000, 0x800000, CRC(a748854f) SHA1(2611bbedf9b5d8e82c6b2c99b88f842c46434d41) )
	ROM_LOAD16_BYTE( "263.c6", 0x2000001, 0x800000, CRC(5c8ba116) SHA1(6034db09c8706d4ddbcefc053efbc47a0953eb92) )
ROM_END


//    YEAR  NAME             PARENT    MACHINE        INPUT   CLASS          INIT          MONITOR COMPANY                 FULLNAME FLAGS
GAME( 2021, mslug4a,         mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "GOTVG", "Metal Slug 4 20th Anniversary (GOTVG Ver.2021 Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, mslug4ar,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack", "Metal Slug 4 Enemies Reset Fusion 20th Anniversary (Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4d,         mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Mega", "Metal Slug 4 (Decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, mslug4dh,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "HappyASR [EGCG]", "Metal Slug 4 (Super D Version)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh2,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh3,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 3)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh4,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 4)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh5,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 5)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh6,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 6)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eh,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix, 2003-04-14 Set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4eho,       mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami", "Metal Slug 4 (Style Remix Old)", MACHINE_SUPPORTS_SAVE )
GAME( 2005, mslug4fr,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Arkatrad", "Metal Slug 4 (Neo Arc French Traduction Rev.1)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, mslug4i,         mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Evoboy", "Metal Slug 4 (Traduction Italian)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4kh,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami and Fighters Kim", "Metal Slug 4 (Style remix, 2003-07-31)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4nd,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Mega Enterprise / Playmore Corporation", "Metal Slug 4 (Fully decrypted)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mslug4sp,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack", "Metal Slug 4 (Super Enhanced Version, 2015-05-10)", MACHINE_SUPPORTS_SAVE ) // Crashing in the final mission
GAME( 2002, mslug4xg,        mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "ZKW",    "Metal Slug 4 (PPX Team Hack, Remixed)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh01,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90",            "Metal Slug 4 (248 grenades, 2020-06-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh02,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Big Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh03,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Fire Bomb)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh04,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Stone)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh05,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Prisoner Never Lost)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh06,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Big Flame Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh07,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Big Heavy Machine Gun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh08,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Big Laser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh09,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Big Rocket Launcher With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh10,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Big Shotgun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh11,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Cannon With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh12,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Drop Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh13,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Dual Machine Gun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh14,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Enemy Chaser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh15,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Flame Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh16,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Heavy Machine Gun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh17,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Iron Lizard With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh18,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Laser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh19,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Rocket Launcher With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh20,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Satellite With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh21,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Shotgun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh22,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Super Grenade With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh23,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Creamymami[EGCG]",    "Metal Slug 4 (Weapons Thunder Cloud With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh24,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Eddids",              "Metal Slug 4 (Fix The Black Background Of Title)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, mslug4hh25,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Multi-Function Version, 2017-12-25)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, mslug4hh26,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Shyma.X",    "Metal Slug 4 (Neo Arc French Traduction Rev.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, mslug4hh27,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",    "Metal Slug 4 (Last Bullet, 2016-03-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, mslug4hh28,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",    "Metal Slug 4 (Last Bullet, 2016-10-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, mslug4hh29,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",    "Metal Slug 4 (Mummy Edition, 2020-08-31)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh30,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (Change Character)", MACHINE_SUPPORTS_SAVE ) //It crashea changing character at the beginning of the final mission.
GAME( 2002, mslug4hh31,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (Change Weapon)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh32,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (Change Zombie)", MACHINE_SUPPORTS_SAVE ) //It crashea when changing character at the beginning of the final mission.
GAME( 2002, mslug4hh33,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ", "Metal Slug 4 (Jump In Mid Air)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh34,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Shyma.X",    "Metal Slug 4 (Neo Arc French Traduction Rev.3)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh35,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (Quick Go Next Mission)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh36,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Eddids[FGCH]",    "Metal Slug 4 (Unlimited Credits In Console Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh37,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (War Chariot V1)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh38,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "DDJ",    "Metal Slug 4 (War Chariot V2)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, mslug4hh39,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Mame Neht", "Metal Slug 4 (Neo Arc French Traduction (Version Unknown))", MACHINE_SUPPORTS_SAVE )
GAME( 2016, mslug4hh40,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack", "Metal Slug 4 (Ammunition Random Edition, 2016-07-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh41,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",  "Metal Slug 4 (Enemies Resetting Version, 2019-01-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh42,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",  "Metal Slug 4 (Enemies Resetting Version, 2019-02-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh43,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",     "Metal Slug 4 (Burst Enhanced Version, 2020-09-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh44,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",       "Metal Slug 4 (Enemies Resetting Version, 2019-04-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh45,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",       "Metal Slug 4 (Generation 1V2, 2019-05-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh46,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 4 (Enemies Resetting Version, 2019-04-25)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh47,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "GOTVG", "Metal Slug 4 (Fully Decrypted [?] Version)", MACHINE_SUPPORTS_SAVE ) //FBADROID
GAME( 2019, mslug4hh48,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 4 (Enemies Resetting Version, 2019-07-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug4hh49,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack", "Metal Slug 4 (Shotgun Flash Off)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug4hh50,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 4 (Enemies Resetting Version, 2019-11-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug4hh51,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Multi-Function Version, 2018-10-05)", MACHINE_SUPPORTS_SAVE ) //The date of the ips is taken into account
GAME( 2020, mslug4hh52,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "XiaShuiDaoMeiRenYu",  "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh53,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Burst Enhanced Edition, 2020-03-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh54,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Burst Enhanced Edition, 2020-03-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh55,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Burst Enhanced Edition, 2020-04-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mslug4hh56,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Super Enhanced Version, 2020-04-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh57,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "I love Nimes",     "Metal Slug 4 (Burst Enhanced Version, 2020-03-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh58,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "I love Nimes",     "Metal Slug 4 (Burst Enhanced Version, 2020-09-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh59,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",             "Metal Slug 4 (Zombie Crisis, 2020-08-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hh60,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",             "Metal Slug 4 (Rise Of The Apes, 2020-08-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, mslug4hh61,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",             "Metal Slug 4 (Last Bullet, 2017-07-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, mslug4hh62,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "hack",             "Metal Slug 4 (Last Bullet Enhanced Edition, 2017-11-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4zb01,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Zombie Players Mode Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4zb02,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Zombie Players Mode Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) //Multi-Function Version 2017-12-25
GAME( 2020, mslug4zb03,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Zombie Players Mode Enemies Resetting Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2020-02-10
GAME( 2020, mslug4zb04,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Zombie Players Mode Enemies Resetting Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2019-04-15, Multi-Function Version 2017-12-25
GAME( 2020, mslug4mk01,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Monkeys Players Mode Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4mk02,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Monkeys Players Mode Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) //Multi-Function Version 2017-12-25
GAME( 2020, mslug4mk03,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Monkeys Players Mode Enemies Resetting Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2020-02-10
GAME( 2020, mslug4mk04,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Monkeys Players Mode Enemies Resetting Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2019-04-15, Multi-Function Version 2017-12-25
GAME( 2020, mslug4mb01,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Mummy Players Mode Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4mb02,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/I love Nimes",         "Metal Slug 4 (Mummy Players Mode Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) //Multi-Function Version 2017-12-25
GAME( 2020, mslug4mb03,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Mummy Players Mode Enemies Resetting Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2020-02-10
GAME( 2020, mslug4mb04,      mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",         "Metal Slug 4 (Mummy Players Mode Enemies Resetting Multi-Function Edition, 2020-10-01)", MACHINE_SUPPORTS_SAVE ) // Enemies Resetting Edition 2019-04-15, Multi-Function Version 2017-12-25
GAME( 2020, mslug4erd01,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90",                     "Metal Slug 4 (Enemies Resetting Version, 2019-04-15)(Multi-Function)", MACHINE_SUPPORTS_SAVE ) // Cannot update the current version anymore causes crashing
GAME( 2020, mslug4erd02,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Generation 1V2)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4erd03,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Gaston90/XiaShuiDaoMeiRenYu/I love Nimes",  "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Burst Enhanced Version)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug4lwp01,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Gaston90",                     "Metal Slug 4 (Last Bullet Multi-Function, 2016-10-16 (Prototype))", MACHINE_SUPPORTS_SAVE ) //Edition 2018
GAME( 2020, mslug4lwp02,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Gaston90",                     "Metal Slug 4 (Last Bullet Multi-Function, 2017-07-27 (Prototype))", MACHINE_SUPPORTS_SAVE ) //Edition 2020
GAME( 2020, mslug4erms01,    mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Creamymami[EGCG],I love Nimes)",                     "Metal Slug 4 (Enemies Resetting Multi-Function Version, 2019-04-15)(Revised Version Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )// Cannot update the current version anymore causes crashing
GAME( 2020, mslug4erms02,    mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Creamymami[EGCG],I love Nimes)",                     "Metal Slug 4 (Enemies Resetting Multi-Function Version, 2019-04-15)(Revised Version Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )// Cannot update the current version anymore causes crashing
GAME( 2020, mslug4hqyvs01,   mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],I love Nimes)",             "Metal Slug 4 (Multi-Function Version, 2017-12-25)(Revised Version Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4hqyvs02,   mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],I love Nimes)",             "Metal Slug 4 (Multi-Function Version, 2017-12-25)(Revised Version Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma01,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Flame Shot Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma02,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Flame Shot Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma03,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma04,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma05,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Laser Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma06,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Laser Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma07,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma08,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma09,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Shotgun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma10,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Big Shotgun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma11,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Cannon Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma12,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Cannon Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma13,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Dual Machine Gun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma14,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Dual Machine Gun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma15,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Enemy Chaser Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma16,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Enemy Chaser Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma17,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Satellite Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma18,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Satellite Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma19,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Super Grenade Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma20,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Super Grenade Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma21,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Thunder Cloud Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rma22,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Revised Version Thunder Cloud Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb01,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb02,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb03,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb04,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb05,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Laser Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb06,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Laser Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb07,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb08,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb09,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Shotgun Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb10,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Big Shotgun Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb11,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Cannon Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb12,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Cannon Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb13,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Dual Machine Gun Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb14,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Dual Machine Gun Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb15,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb16,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb17,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Satellite Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb18,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Satellite Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb19,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Super Grenade Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb20,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Super Grenade Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb21,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmb22,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_neogeo,    ROT0, "Team Remix(Gaston90,Creamymami[EGCG])",    "Metal Slug 4 (Last Bullet, 2017-07-27)(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-10-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc01,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc02,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc03,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc04,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc05,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Laser Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc06,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Laser Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc07,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc08,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc09,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Shotgun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc10,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Big Shotgun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc11,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Cannon Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc12,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Cannon Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc13,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Dual Machine Gun Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc14,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Dual Machine Gun Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc15,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc16,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc17,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Satellite Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc18,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Satellite Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc19,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Super Grenade Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc20,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Super Grenade Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc21,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug4rmc22,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "Team Remix(Gaston90,XiaShuiDaoMeiRenYu,Shyma.X,Creamymami[EGCG],DDJ,I love Nimes)",    "Metal Slug 4 (Enemies Resetting Version, 2020-02-10)(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, mslug4unity,     mslug4,   neogeo_noslot, neogeo, neogeo_state,  init_mslug4hb,  ROT0, "hack",    "Metal Slug 4 Unity", MACHINE_SUPPORTS_SAVE )

