// license:GPL_2.0
// copyright-holders:Robbbert
#include "../mame/drivers/taito_f3.cpp"

/*******************
 Cleopatra Fortune
********************/
ROM_START( cleopatr01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e28-10hc01.bin", 0x000000, 0x80000, CRC(20bb1f31) SHA1(48e24d0b2aa3cc06db8ccbe05e5d48e0a46de239) )
	ROM_LOAD32_BYTE("e28-09hc01.bin", 0x000001, 0x80000, CRC(a5811b99) SHA1(0ce61e9e093f002d331a5b822b19b86fb3cc6d40) )
	ROM_LOAD32_BYTE("e28-08hc01.bin", 0x000002, 0x80000, CRC(32f4bd9d) SHA1(8b7aa973cc4db466c791ee61633a76e5ec1f1897) )
	ROM_LOAD32_BYTE("e28-07hc01.bin", 0x000003, 0x80000, CRC(16eab942) SHA1(b2cf401ade7280f1789c27a24046421fea5e8a94) )

	ROM_REGION(0x100000, "sprites" , 0)
	ROM_LOAD16_BYTE("e28-02hc01.bin", 0x000000, 0x080000, CRC(1f9eda37) SHA1(9288df554eaeccbcf231fc2245d87aebf8e0c137) )
	ROM_LOAD16_BYTE("e28-01hc01.bin", 0x000001, 0x080000, CRC(e1fab776) SHA1(933d83685d1c5585d7b5799759ce38c5df98a709) )

	EMPTY_SPRITE_HIDATA(0x080000)

	ROM_REGION(0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("e28-06hc01.bin", 0x000000, 0x100000, CRC(07f83157) SHA1(b39edbb4de4790b808a4be7d0761b7666006e6b4) )
	ROM_LOAD32_WORD("e28-05hc01.bin", 0x000002, 0x100000, CRC(e40904c9) SHA1(90291ca27a592adf493a459a89cb43b166857157) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e28-04.bin", 0x000000, 0x100000, CRC(57aef029) SHA1(5c07209015d4749d1ffb3e9c1a890e6cfeec8cb0) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e28-11.bin", 0x100000, 0x20000, CRC(01a06950) SHA1(94d22cd839f9027e9d45264c366e0cb5d698e0b6) )
	ROM_LOAD16_BYTE("e28-12.bin", 0x100001, 0x20000, CRC(dc19260f) SHA1(fa0ca03a236326652e4f9898d07cd837c1507a9d) )

	ROM_REGION16_BE(0x400000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e28-03.bin", 0x000000, 0x200000, CRC(15c7989d) SHA1(7cc63d93e5c1f9f52f889e973bbefd5e6f7ce807) )
ROM_END

ROM_START( cleopatr02 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e28-10.bin", 0x000000, 0x80000, CRC(013fbc39) SHA1(d36ac44609b88e1da35c98dda381042e0112ea00) )
	ROM_LOAD32_BYTE("e28-09.bin", 0x000001, 0x80000, CRC(1c48a1f9) SHA1(791d321c03073cdd0269b970f926897446d2a6fb) )
	ROM_LOAD32_BYTE("e28-08.bin", 0x000002, 0x80000, CRC(7564f199) SHA1(ec4b19edb0660ad478f6c0ec27d701368696a2e4) )
	ROM_LOAD32_BYTE("e28-wrd.bin", 0x000003, 0x80000, CRC(544dd2e9) SHA1(11ad1ce4202937108f23c44de2244da570452ce1) )

	ROM_REGION(0x100000, "sprites" , 0)
	ROM_LOAD16_BYTE("e28-02.bin", 0x000000, 0x080000, CRC(b20d47cb) SHA1(6888e5564688840fed1c123ab38467066cd59c7f) )
	ROM_LOAD16_BYTE("e28-01.bin", 0x000001, 0x080000, CRC(4440e659) SHA1(71dece81bac8d638473c6531fed5c32798096af9) )

	EMPTY_SPRITE_HIDATA(0x080000)

	ROM_REGION(0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("e28-06.bin", 0x000000, 0x100000, CRC(21d0c454) SHA1(f4c815984b19321cfab303fa6f21d9cad35b09f2) )
	ROM_LOAD32_WORD("e28-05.bin", 0x000002, 0x100000, CRC(2870dbbc) SHA1(4e412b90cbd9a05956cde3d8cff615ebadca9db6) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e28-04.bin", 0x000000, 0x100000, CRC(57aef029) SHA1(5c07209015d4749d1ffb3e9c1a890e6cfeec8cb0) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e28-11.bin", 0x100000, 0x20000, CRC(01a06950) SHA1(94d22cd839f9027e9d45264c366e0cb5d698e0b6) )
	ROM_LOAD16_BYTE("e28-12.bin", 0x100001, 0x20000, CRC(dc19260f) SHA1(fa0ca03a236326652e4f9898d07cd837c1507a9d) )

	ROM_REGION16_BE(0x400000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e28-03.bin", 0x000000, 0x200000, CRC(15c7989d) SHA1(7cc63d93e5c1f9f52f889e973bbefd5e6f7ce807) )
ROM_END

/************
 Akkanbeder
*************/
ROM_START( akkanvdr01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e06-14hc01.20", 0x000000, 0x20000, CRC(f1f71f95) SHA1(b0d44fb3972f3b844855a9778df2d4bd026e5403) )
	ROM_LOAD32_BYTE("e06-13hc01.19", 0x000001, 0x20000, CRC(5e94d31b) SHA1(631607d4283dbbb9c8e6b3a71d742ef8f24887c5) )
	ROM_LOAD32_BYTE("e06-12hc01.18", 0x000002, 0x20000, CRC(eccc4cc4) SHA1(1d7317c8c58db9e4a95b3eed4474e8c04ece7444) )
	ROM_LOAD32_BYTE("e06-11hc01.17", 0x000003, 0x20000, CRC(ee3e952d) SHA1(5fd7db1bcb060b2efcb8ab0805f8e15c456cfb2c) )

	ROM_REGION(0x200000, "sprites" , 0)
	ROM_LOAD16_BYTE("e06-03hc03", 0x000000, 0x100000, CRC(6565b5c7) SHA1(5dc548dfd498ef6771b942168eb6d7d6e262912c) )
	ROM_LOAD16_BYTE("e06-02hc02", 0x000001, 0x100000, CRC(eae1fe61) SHA1(90f9477883ae3d4f7a2947acf748de4364b63384) )

	ROM_REGION( 0x100000, "sprites_hi", 0 )
	ROM_LOAD       ("e06-01hc01", 0x000000, 0x100000, CRC(b2091836) SHA1(a849fbe0f6db36e76ca20de7f5b96bd60a139905) )

	ROM_REGION(0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("e06-08hc01", 0x000000, 0x100000, CRC(882c4fe4) SHA1(f5b80d498fcd42725b8c96afdfb2cb7e0a4195fb) )
	ROM_LOAD32_WORD("e06-07hc01", 0x000002, 0x100000, CRC(c11cd737) SHA1(d597b53ad7739665fd4265177719fc57a1af0199) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e06-06hc01", 0x000000, 0x100000, CRC(c1cd5367) SHA1(0560f033169145f12d80211e4210399abda2a0e5) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e06-09.32", 0x100000, 0x40000, CRC(9bcafc87) SHA1(10b3f6da00a41550fe6a705232f0e33fda3c7e7c) )
	ROM_LOAD16_BYTE("e06-10.33", 0x100001, 0x40000, CRC(b752b61f) SHA1(e948a8af19c70ba8b8e908c869bc88ed0cac8420) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e06-04", 0x000000, 0x200000, CRC(1dac29df) SHA1(ed68a41def148dcf4057cfac87a2a563c6882e1d) )
	ROM_LOAD16_BYTE("e06-05", 0x400000, 0x200000, CRC(f370ff15) SHA1(4bc464d1c3a28326c8b1ae2036387954cb1dd813) )
ROM_END

/**************
 Arabian Magic
***************/
ROM_START( arabianm01 ) //arabianmjc
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d29-23hc01.ic40", 0x000000, 0x40000, CRC(dd54b8ed) SHA1(2584ae22e52d2f5990cf0857ddd5707f8df4beb0) )
	ROM_LOAD32_BYTE("d29-22hc01.ic38", 0x000001, 0x40000, CRC(4605b9e1) SHA1(0d050754c37fdab7596385daf242054d50882872) )
	ROM_LOAD32_BYTE("d29-21hc01.ic36", 0x000002, 0x40000, CRC(b3b115c1) SHA1(31a7abf491c8cc568415d8684584137041c7c6b9) )
	ROM_LOAD32_BYTE("d29-20hc01.ic34", 0x000003, 0x40000, CRC(e2725176) SHA1(fe738d76efd491cf449909470a5c7f5023de6e38) )

	ROM_REGION(0x200000, "sprites" , 0)
	ROM_LOAD16_BYTE("d29-03hc01.ic66", 0x000000, 0x100000, CRC(281fd530) SHA1(6db5095ae49b12709086010fa112500e45901081) )
	ROM_LOAD16_BYTE("d29-04hc01.ic67", 0x000001, 0x100000, CRC(29dc7a2d) SHA1(2cf49f7680fead656f474442a4f0c8fd403d79a1) )

	ROM_REGION( 0x100000, "sprites_hi", 0 )
	ROM_LOAD       ("d29-05hc01.ic68", 0x000000, 0x100000, CRC(445b2514) SHA1(2fd20bab02bd0bf242ef6c35ea2dc65c0e44ee91) )

	ROM_REGION(0x100000, "tilemap" , 0)
	ROM_LOAD32_WORD("d29-06hc01.ic49", 0x000000, 0x080000, CRC(7dc3841a) SHA1(fb13be3adf2d6eea628cda3b374c7c42766dfb76) )
	ROM_LOAD32_WORD("d29-07hc01.ic50", 0x000002, 0x080000, CRC(1716b706) SHA1(629698dcc7be88dffb70a9eb065542b7f2848812) )

	ROM_REGION( 0x080000, "tilemap_hi", 0 )
	ROM_LOAD       ("d29-08hc01.ic51", 0x000000, 0x080000, CRC(531ef983) SHA1(89d072c285677f35ca3564f7dc4018e2f0410ee6) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d29-18.ic5", 0x100000, 0x20000, CRC(d97780df) SHA1(d0f9d2fd7ce13f620bb44083bf012f67dda4b10b) )
	ROM_LOAD16_BYTE("d29-19.ic6", 0x100001, 0x20000, CRC(b1ad365c) SHA1(1cd26d8feaaa06b50dfee32e9b7950b8ee92ac55) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d29-01.ic17", 0x000000, 0x200000, CRC(545ac4b3) SHA1(f89513fca8a03cab11160aa1f0a9c3adbc8bda08) )
	ROM_LOAD16_BYTE("d29-02.ic18", 0x600000, 0x100000, CRC(ed894fe1) SHA1(5bf2fb6abdcf25bc525a2c3b29dbf7aca0b18fea) )
ROM_END

/*****************
 Bubble Memories
******************/
ROM_START( bubblem01 ) // Black Edition
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("bmbe.20", 0x000000, 0x080000, CRC(c4a1e3c2) SHA1(a49aac034aa75b76553f700dfff155635048c291) )
	ROM_LOAD32_BYTE("bmbe.19", 0x000001, 0x080000, CRC(bd9c3812) SHA1(3b6d7ca84ec81c32f604ff1883f37272eaf4efa2) )
	ROM_LOAD32_BYTE("bmbe.18", 0x000002, 0x080000, CRC(c5a6ec87) SHA1(2f64647f23e34b978adbbd09373dd1e1e9100259) )
	ROM_LOAD32_BYTE("bmbe.17", 0x000003, 0x080000, CRC(a15e492d) SHA1(2f05f8b26a50d57a82362dd0b34bf0e85ecfca97) )

	ROM_REGION( 0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e21-02.rom", 0x000000, 0x200000, CRC(b7cb9232) SHA1(ba71cb98d49eadebb26d9f53bbaec1dc211077f5) )
	ROM_LOAD16_BYTE("e21-01.rom", 0x000001, 0x200000, CRC(a11f2f99) SHA1(293c5996600cad05bf98f936f5f820d93d546099) )

	EMPTY_SPRITE_HIDATA(0x200000)

	ROM_REGION( 0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("e21-07.rom", 0x000000, 0x100000, CRC(7789bf7c) SHA1(bc8ef1696adac99a1fabae9b79afcd3461cf323b) )
	ROM_LOAD32_WORD("e21-06.rom", 0x000002, 0x100000, CRC(997fc0d7) SHA1(58a546f739072fedebfe7c972fe85f72107726b2) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e21-05.rom", 0x000000, 0x100000, CRC(07eab58f) SHA1(ae2d7b839b39d88d11652df74804a39230674467) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("e21-12.32", 0x100000, 0x40000, CRC(34093de1) SHA1(d69d6b5f10b8fe86f727d739ed5aecceb15e01f7) )
	ROM_LOAD16_BYTE("e21-13.33", 0x100001, 0x40000, CRC(9e9ec437) SHA1(b0265b688846c642d240b2f3677d2330d31eaa87) )

	ROM_REGION16_BE( 0x800000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e21-03.rom", 0x000000, 0x200000, CRC(54c5f83d) SHA1(10a993199c8d5a1361bd29a4b92c404451c6da01) )
	ROM_LOAD16_BYTE("e21-04.rom", 0x400000, 0x200000, CRC(e5af2a2d) SHA1(62a49504decc7160b710260218920d2d6d2af8f0) )

	ROM_REGION16_BE( 0x80, "eeprom", 0 )
	ROM_LOAD("bubblem.nv", 0x0000, 0x0080, CRC(9a59326e) SHA1(071dbfbfd77f7020476ddb54c93f5fafa7a08159) )
ROM_END

ROM_START( bubblemu01 ) // Black Edition
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("bmube.20", 0x000000, 0x080000, CRC(926a235e) SHA1(d41f00c130573020b51f7012d4db59f066ff8cfc) )
	ROM_LOAD32_BYTE("bmube.19", 0x000001, 0x080000, CRC(59e7ce8d) SHA1(610e0d2e57ccfee2283cac8ef784e2b1803a7e10) )
	ROM_LOAD32_BYTE("bmube.18", 0x000002, 0x080000, CRC(d6ae69ab) SHA1(b4e9656beae3ebfa3ca21c56929b871f15dc6843) )
	ROM_LOAD32_BYTE("bmube.17", 0x000003, 0x080000, CRC(7372711a) SHA1(5072fd80a9b0be94e45cf4f16839010f40e7c953) )

	ROM_REGION( 0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e21-02.rom", 0x000000, 0x200000, CRC(b7cb9232) SHA1(ba71cb98d49eadebb26d9f53bbaec1dc211077f5) )
	ROM_LOAD16_BYTE("e21-01.rom", 0x000001, 0x200000, CRC(a11f2f99) SHA1(293c5996600cad05bf98f936f5f820d93d546099) )

	EMPTY_SPRITE_HIDATA(0x200000)

	ROM_REGION( 0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("e21-07.rom", 0x000000, 0x100000, CRC(7789bf7c) SHA1(bc8ef1696adac99a1fabae9b79afcd3461cf323b) )
	ROM_LOAD32_WORD("e21-06.rom", 0x000002, 0x100000, CRC(997fc0d7) SHA1(58a546f739072fedebfe7c972fe85f72107726b2) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e21-05.rom", 0x000000, 0x100000, CRC(07eab58f) SHA1(ae2d7b839b39d88d11652df74804a39230674467) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("e21-12.32", 0x100000, 0x40000, CRC(34093de1) SHA1(d69d6b5f10b8fe86f727d739ed5aecceb15e01f7) )
	ROM_LOAD16_BYTE("e21-13.33", 0x100001, 0x40000, CRC(9e9ec437) SHA1(b0265b688846c642d240b2f3677d2330d31eaa87) )

	ROM_REGION16_BE( 0x800000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e21-03.rom", 0x000000, 0x200000, CRC(54c5f83d) SHA1(10a993199c8d5a1361bd29a4b92c404451c6da01) )
	ROM_LOAD16_BYTE("e21-04.rom", 0x400000, 0x200000, CRC(e5af2a2d) SHA1(62a49504decc7160b710260218920d2d6d2af8f0) )

	ROM_REGION16_BE( 0x80, "eeprom", 0 )
	ROM_LOAD("bubblemu.nv", 0x0000, 0x0080, CRC(a503276c) SHA1(f07dd49decee7e8e7551e37b9b0f612bfaf8a2b0) )
ROM_END

/*****************
 Bubble Symphony
******************/
ROM_START( bubsymph01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d90hc01-12", 0x000000, 0x40000, CRC(1ae40f57) SHA1(56cfcfc69b0f29a2f13745f47462dd442c422260) )
	ROM_LOAD32_BYTE("d90hc01-11", 0x000001, 0x40000, CRC(bc2ad86a) SHA1(3bbc20396fa328901747dcd6c88cf2a90e852ccb) )
	ROM_LOAD32_BYTE("d90hc01-10", 0x000002, 0x40000, CRC(db7c9cc2) SHA1(11786688b5525b0429532e53580e93dba2afd18a) )
	ROM_LOAD32_BYTE("d90hc01-09", 0x000003, 0x40000, CRC(20a5f8a1) SHA1(50070b30c166350b397bec3ffc4038adcb3289b5) )

	ROM_REGION(0x200000, "sprites" , 0)
	ROM_LOAD16_BYTE("d90hc01-03", 0x000000, 0x100000, CRC(9e610be0) SHA1(d8663197e052c17f6cd507a9e0fc5be53060b483) )
	ROM_LOAD16_BYTE("d90hc01-02", 0x000001, 0x100000, CRC(881e91a1) SHA1(3e273c831b1d620bfc97d803636988d397b494ad) )

	ROM_REGION( 0x100000, "sprites_hi", 0 )
	ROM_LOAD       ("d90hc01-01", 0x000000, 0x100000, CRC(4a577d64) SHA1(37acf59c3d3dd2fe9dda30c30cbbc4cad548af8f) )

	ROM_REGION(0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("d90hc01-08", 0x000000, 0x100000, CRC(f57f521d) SHA1(7e40352dc6a5d2423d79e5d4ebe8b70b66c94fe8) )
	ROM_LOAD32_WORD("d90hc01-07", 0x000002, 0x100000, CRC(fe765764) SHA1(a8c466eac3516468ff694b6a487ae7722f373a50) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("d90hc01-06", 0x000000, 0x100000, CRC(f3a70b9c) SHA1(5fd676db3783dbd905b53b0e9e6199371dca88a7) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d90-13.ic32", 0x100000, 0x40000, CRC(6762bd90) SHA1(771db0382bc8dab2caf13d0fc20648366c685829) )
	ROM_LOAD16_BYTE("d90-14.ic33", 0x100001, 0x40000, CRC(8e33357e) SHA1(68b81693c22e6357e37244f2a416818a81338138) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d90-04", 0x000000, 0x200000, CRC(feee5fda) SHA1(b89354013ec4d34bcd51ecded412effa66dd2f2f) )
	ROM_LOAD16_BYTE("d90-05", 0x400000, 0x200000, CRC(c192331f) SHA1(ebab05b3681c70b373bc06c1826be1cc397d3af7) )
ROM_END

/***********
 Dan-Ku-Ga
************/
ROM_START( dankuga01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("dkg_mpr3hc01.20", 0x000000, 0x80000, CRC(1da88664) SHA1(d9569ad4b20776521db937f70986a72364a03eb8) )
	ROM_LOAD32_BYTE("dkg_mpr2hc01.19", 0x000001, 0x80000, CRC(db215d0e) SHA1(2b46e9b523feb4efcf032ce2feafeb1c9d929c49) )
	ROM_LOAD32_BYTE("dkg_mpr1hc01.18", 0x000002, 0x80000, CRC(da6345f8) SHA1(9ec64f3ad6a0135aa35dcd4aeff183856adaf35a) )
	ROM_LOAD32_BYTE("dkg_mpr0hc01.17", 0x000003, 0x80000, CRC(6e54b3af) SHA1(473c7ca4096a9a71f3bd7fb52334ea7a0ee08726) )

	ROM_REGION(0xD00000, "sprites" , 0)
	ROM_LOAD16_BYTE("d84-03.rom", 0x000000, 0x200000, CRC(d786f552) SHA1(f73146892f714b5706d568fc8a135fddaa656570) )
	ROM_LOAD16_BYTE("d84-04.rom", 0x000001, 0x200000, CRC(d1f32b5d) SHA1(35289cce64fdbb8d966dd1d5307b5393be5e7799) )
	ROM_LOAD16_BYTE("d84-06.rom", 0x400000, 0x200000, CRC(fa924dab) SHA1(28a8c3cd701f8df0c53069bb576bb2a820f3a331) )
	ROM_LOAD16_BYTE("d84-07.rom", 0x400001, 0x200000, CRC(54517a6b) SHA1(6e2c213c7ec1a3b78ad7e71db2326602557fd0f8) )
	ROM_LOAD16_BYTE("d84-09.rom", 0x800000, 0x200000, CRC(faa78d98) SHA1(da3a2c5a45dd169743f113aa08e574f732e1f0fd) )
	ROM_LOAD16_BYTE("d84-10.rom", 0x800001, 0x200000, CRC(b84b7320) SHA1(f5de0d6da50d8ed753607b51e46bc9a4572ef431) )
	ROM_LOAD16_BYTE("d84-19.rom", 0xc00000, 0x080000, CRC(6ddf77e5) SHA1(a1323acaed37fce62a19e63a0800d9d1dc2cfff7) )
	ROM_LOAD16_BYTE("d84-20.rom", 0xc00001, 0x080000, CRC(f85041e5) SHA1(6b2814514338f550d6aa14dbe39e848e8e64edee) )

	ROM_REGION( 0x680000, "sprites_hi", 0 )
	ROM_LOAD       ("d84-05.rom", 0x000000, 0x200000, CRC(31a3c75d) SHA1(1a16ccb6a0a03ab715e5b016ab3b1b2cd0f1ae41) )
	ROM_LOAD       ("d84-08.rom", 0x200000, 0x200000, CRC(07347bf1) SHA1(34bd359933acdec7fd1ce047092a30d1177afc2c) )
	ROM_LOAD       ("d84-11.rom", 0x400000, 0x200000, CRC(a062c1d4) SHA1(158912aa3dd75c3961bf738f9ac9034f0b005b60) )
	ROM_LOAD       ("d84-21.rom", 0x600000, 0x080000, CRC(89f68b66) SHA1(95916f02f71357324effe59da4f847f2f30ea34a) )

	ROM_REGION(0x600000, "tilemap" , 0)
	ROM_LOAD32_WORD("d84-12.rom", 0x000000, 0x200000, CRC(66a7a9aa) SHA1(a7d21f8b6370d16de3c1569019f2ad71d36e7a61) )
	ROM_LOAD32_WORD("d84-13.rom", 0x000002, 0x200000, CRC(ae125516) SHA1(d54e76e398ab0b0fb82f3154ba54fc823ff49a1a) )
	ROM_LOAD32_WORD("d84-16.rom", 0x400000, 0x100000, CRC(bcff9b2d) SHA1(0ca50ec809564eddf0ba7448a8fae9087d3b600b) )
	ROM_LOAD32_WORD("d84-17.rom", 0x400002, 0x100000, CRC(0be37cc3) SHA1(b10c10b93858cad0c962ef614cfd6daea712ef6b) )

	ROM_REGION( 0x300000, "tilemap_hi", 0 )
	ROM_LOAD       ("d84-14.rom", 0x000000, 0x200000, CRC(2b2e693e) SHA1(03eb37fa7dc68d54bf0f1800b8c0b581c344a40f) )
	ROM_LOAD       ("d84-18.rom", 0x200000, 0x100000, CRC(e812bcc5) SHA1(3574e4a99232d9fc7989ec5d1e8fe76b4b30784a) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d84-26.32", 0x100000, 0x40000, CRC(4f5b8563) SHA1(1d4e06cbea7bc73a99d6e30be714fff420151bbc) )
	ROM_LOAD16_BYTE("d84-27.33", 0x100001, 0x40000, CRC(fb0cb1ba) SHA1(16a79b53651a6131f7636db19738b456b7c28bff) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d84-01.rom", 0x400000, 0x200000, CRC(9ad22149) SHA1(48055822e0cea228cdecf3d05ac24e50979b6f4d) )
	ROM_LOAD16_BYTE("d84-02.rom", 0x800000, 0x200000, CRC(9e1827e4) SHA1(1840881b0f8f7b6225e6ffa12a8d4b463554988e) )
	ROM_LOAD16_BYTE("d84-15.rom", 0xe00000, 0x100000, CRC(31ceb152) SHA1(d9d0bc631a6a726376f566a49605b50485ac7bf4) )
ROM_END

ROM_START( dankuga02 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("dkg_mpr3hc02.20", 0x000000, 0x80000, CRC(2c2a5aff) SHA1(b9d8104f5dd929750ac97aca3ecf225df1d70cc8) )
	ROM_LOAD32_BYTE("dkg_mpr2hc02.19", 0x000001, 0x80000, CRC(cc5506f5) SHA1(5d473a967392f405785bfbc102baf761baf53c21) )
	ROM_LOAD32_BYTE("dkg_mpr1hc02.18", 0x000002, 0x80000, CRC(7e1112ed) SHA1(5f85e7e4b389cd148c4ad16cb761f2adead4ea4a) )
	ROM_LOAD32_BYTE("dkg_mpr0hc02.17", 0x000003, 0x80000, CRC(a8a90a31) SHA1(87e0765742638cc93c7b0deba90f271f574c02c8) )

	ROM_REGION(0xD00000, "sprites" , 0)
	ROM_LOAD16_BYTE("d84-03.rom", 0x000000, 0x200000, CRC(d786f552) SHA1(f73146892f714b5706d568fc8a135fddaa656570) )
	ROM_LOAD16_BYTE("d84-04.rom", 0x000001, 0x200000, CRC(d1f32b5d) SHA1(35289cce64fdbb8d966dd1d5307b5393be5e7799) )
	ROM_LOAD16_BYTE("d84-06.rom", 0x400000, 0x200000, CRC(fa924dab) SHA1(28a8c3cd701f8df0c53069bb576bb2a820f3a331) )
	ROM_LOAD16_BYTE("d84-07.rom", 0x400001, 0x200000, CRC(54517a6b) SHA1(6e2c213c7ec1a3b78ad7e71db2326602557fd0f8) )
	ROM_LOAD16_BYTE("d84-09.rom", 0x800000, 0x200000, CRC(faa78d98) SHA1(da3a2c5a45dd169743f113aa08e574f732e1f0fd) )
	ROM_LOAD16_BYTE("d84-10.rom", 0x800001, 0x200000, CRC(b84b7320) SHA1(f5de0d6da50d8ed753607b51e46bc9a4572ef431) )
	ROM_LOAD16_BYTE("d84-19.rom", 0xc00000, 0x080000, CRC(6ddf77e5) SHA1(a1323acaed37fce62a19e63a0800d9d1dc2cfff7) )
	ROM_LOAD16_BYTE("d84-20.rom", 0xc00001, 0x080000, CRC(f85041e5) SHA1(6b2814514338f550d6aa14dbe39e848e8e64edee) )

	ROM_REGION( 0x680000, "sprites_hi", 0 )
	ROM_LOAD       ("d84-05.rom", 0x000000, 0x200000, CRC(31a3c75d) SHA1(1a16ccb6a0a03ab715e5b016ab3b1b2cd0f1ae41) )
	ROM_LOAD       ("d84-08.rom", 0x200000, 0x200000, CRC(07347bf1) SHA1(34bd359933acdec7fd1ce047092a30d1177afc2c) )
	ROM_LOAD       ("d84-11.rom", 0x400000, 0x200000, CRC(a062c1d4) SHA1(158912aa3dd75c3961bf738f9ac9034f0b005b60) )
	ROM_LOAD       ("d84-21.rom", 0x600000, 0x080000, CRC(89f68b66) SHA1(95916f02f71357324effe59da4f847f2f30ea34a) )

	ROM_REGION(0x600000, "tilemap" , 0)
	ROM_LOAD32_WORD("d84-12.rom", 0x000000, 0x200000, CRC(66a7a9aa) SHA1(a7d21f8b6370d16de3c1569019f2ad71d36e7a61) )
	ROM_LOAD32_WORD("d84-13.rom", 0x000002, 0x200000, CRC(ae125516) SHA1(d54e76e398ab0b0fb82f3154ba54fc823ff49a1a) )
	ROM_LOAD32_WORD("d84-16.rom", 0x400000, 0x100000, CRC(bcff9b2d) SHA1(0ca50ec809564eddf0ba7448a8fae9087d3b600b) )
	ROM_LOAD32_WORD("d84-17.rom", 0x400002, 0x100000, CRC(0be37cc3) SHA1(b10c10b93858cad0c962ef614cfd6daea712ef6b) )

	ROM_REGION( 0x300000, "tilemap_hi", 0 )
	ROM_LOAD       ("d84-14.rom", 0x000000, 0x200000, CRC(2b2e693e) SHA1(03eb37fa7dc68d54bf0f1800b8c0b581c344a40f) )
	ROM_LOAD       ("d84-18.rom", 0x200000, 0x100000, CRC(e812bcc5) SHA1(3574e4a99232d9fc7989ec5d1e8fe76b4b30784a) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d84-26.32", 0x100000, 0x40000, CRC(4f5b8563) SHA1(1d4e06cbea7bc73a99d6e30be714fff420151bbc) )
	ROM_LOAD16_BYTE("d84-27.33", 0x100001, 0x40000, CRC(fb0cb1ba) SHA1(16a79b53651a6131f7636db19738b456b7c28bff) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d84-01.rom", 0x400000, 0x200000, CRC(9ad22149) SHA1(48055822e0cea228cdecf3d05ac24e50979b6f4d) )
	ROM_LOAD16_BYTE("d84-02.rom", 0x800000, 0x200000, CRC(9e1827e4) SHA1(1840881b0f8f7b6225e6ffa12a8d4b463554988e) )
	ROM_LOAD16_BYTE("d84-15.rom", 0xe00000, 0x100000, CRC(31ceb152) SHA1(d9d0bc631a6a726376f566a49605b50485ac7bf4) )
ROM_END

/*************************
 Darius Gaiden
**************************/
ROM_START( dariusg01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("dge_mpr3.bin", 0x000000, 0x80000, CRC(1c1e24a7) SHA1(eafde331c3be5be55d0d838a84017f357ff92634) )
	ROM_LOAD32_BYTE("dge_mpr2.bin", 0x000001, 0x80000, CRC(7be23e23) SHA1(4764355f51e207f4538dd753aea59bf2689835de) )
	ROM_LOAD32_BYTE("dge_mpr1.bin", 0x000002, 0x80000, CRC(bc030f6f) SHA1(841396911d26ddfae0c9863431e02e0b5e762ac6) )
	ROM_LOAD32_BYTE("dge_wrd.bin",  0x000003, 0x80000, CRC(2bb37270) SHA1(98bc07894e92ca9cce34fc7390f40d3357783e3f) )

	ROM_REGION(0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("d87-03.bin", 0x000000, 0x200000, CRC(4be1666e) SHA1(35ba7bcf29ec7a8f8b6944ee3544693d4df1bfc2) )
	ROM_LOAD16_BYTE("d87-04.bin", 0x000001, 0x200000, CRC(2616002c) SHA1(003f98b740a697274385b8da03c78f3c6f7b5e89) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("d87-05.bin", 0x000000, 0x200000, CRC(4e5891a9) SHA1(fd08d848079841c9237fa359a850980fd00114d8) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("d87-06.bin", 0x000000, 0x200000, CRC(3b97a07c) SHA1(72cdeffedeab0c1bd0e47f03172085390a2be393) )
	ROM_LOAD32_WORD("d87-17.bin", 0x000002, 0x200000, CRC(e601d63e) SHA1(256a6aeb5633fe1db407fad567169a9d0c911219) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("d87-08.bin", 0x000000, 0x200000, CRC(76d23602) SHA1(ca53ea6641182c44a4038bbeaa5effb1687f1980) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d87-13.bin", 0x100000, 0x40000, CRC(15b1fff4) SHA1(28692b731ae98a47c2c5e11a8a71b61a813d9a64) )
	ROM_LOAD16_BYTE("d87-14.bin", 0x100001, 0x40000, CRC(eecda29a) SHA1(6eb238e47bc7bf635ffbdbb25fb06a37db980ef8) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d87-01.bin", 0x000000, 0x200000, CRC(3848a110) SHA1(802e91695a526f665c7fd261f0a7639a0b883c9e) )
	ROM_LOAD16_BYTE("d87-02.bin", 0x400000, 0x200000, CRC(9250abae) SHA1(07cae8edbc3cca0a95022d9b40a5c18a55350b67) )
ROM_END

/*************************
 Elevator Action Returns
**************************/
ROM_START( elvactr01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e02-12hc01.20", 0x000000, 0x80000, CRC(eaaefe10) SHA1(d13e41ea42fd3d7915a1391925a1029c88c40b12) )
	ROM_LOAD32_BYTE("e02-11hc01.19", 0x000001, 0x80000, CRC(990c1409) SHA1(3922137958d54715941c612425567f23e74d17ae) )
	ROM_LOAD32_BYTE("e02-10hc01.18", 0x000002, 0x80000, CRC(b9a54080) SHA1(0999662fed8c36d96186114384d68dc9251b9262) )
	ROM_LOAD32_BYTE("e02-09hc01.17", 0x000003, 0x80000, CRC(7fb5f049) SHA1(a40a79c06a855695769cd5e59729be85dd74c7b1) )

	ROM_REGION(0x400000, "sprites", 0 )
	ROM_LOAD16_BYTE("e02-03hc01.12", 0x000000, 0x200000, CRC(86ec9f36) SHA1(d989742bdd9237fa37730090ceb2324c83c1675f) )
	ROM_LOAD16_BYTE("e02-02hc01.8",  0x000001, 0x200000, CRC(3484fa1d) SHA1(06573ac3738dbceb7812cd0666f1b5fd24fb65c1) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e02-01hc01.4",  0x000000, 0x200000, CRC(9dd378b7) SHA1(9f9a08da225288287993ddcd165d442a777d1af6) )

	ROM_REGION(0x400000, "tilemap", 0 )
	ROM_LOAD32_WORD("e02-08hc01.47", 0x000000, 0x200000, CRC(e884fad1) SHA1(b95f53b1a413fe39b83ec850b45366c4fd8cadf5) )
	ROM_LOAD32_WORD("e02-07hc01.45", 0x000002, 0x200000, CRC(b1553a44) SHA1(12d8f008bb3311c9de529d459a5e4e3c256ba1ae) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e02-06hc01.43", 0x000000, 0x200000, CRC(44ef81a0) SHA1(e7a32fe6302a12d5cc061671ad192fbadd4cdec6) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e02-13.32", 0x100000, 0x40000, CRC(80932702) SHA1(c468234d03aa31b2aa0c3bd6bec32034216c2ae4) )
	ROM_LOAD16_BYTE("e02-14.33", 0x100001, 0x40000, CRC(706671a5) SHA1(1ac90647d617e73f12a67274a025ae43a6b3a316) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e02-04.38", 0x000000, 0x200000, CRC(b74307af) SHA1(deb42415049efa2df70e7b25ba8b1b716aa227f1) )
	ROM_LOAD16_BYTE("e02-05.39", 0x400000, 0x200000, CRC(eb729855) SHA1(85253efe794e8b5ffaf16bcb1123bca831e776a5) )
ROM_END

/*************************
 Gekirindan
**************************/
ROM_START( gekiridn01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e11-12.ic20", 0x000000, 0x40000, CRC(6a7aaacf) SHA1(a8114c84e76c75c908a61d985d96aa4eb9a0ac5a) )
	ROM_LOAD32_BYTE("e11-11.ic19", 0x000001, 0x40000, CRC(2284a08e) SHA1(3dcb91be0d3491ad5e77efd30bacd506dad0f848) )
	ROM_LOAD32_BYTE("e11-10.ic18", 0x000002, 0x40000, CRC(8795e6ba) SHA1(9128c29fdce3276f55aad47451e4a507470c8b9f) )
	ROM_LOAD32_BYTE("e11-15.ic17", 0x000003, 0x40000, CRC(5aef1fd8) SHA1(a94884e39172e664759bff53a6dd2f93422d3299) )

	ROM_REGION(0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e11-03.ic12", 0x000000, 0x200000, CRC(f73877c5) SHA1(1f6b7c0b8a0aaab3e5427d21de7fad3d3cbf737a) )
	ROM_LOAD16_BYTE("e11-02.ic8",  0x000001, 0x200000, CRC(5722a83b) SHA1(823c20a33016a5506ca5415ec615c3d2546ca9ab) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e11-01.ic4",  0x000000, 0x200000, CRC(c2cd1069) SHA1(9744dd3d8a6d9200cea4429dafce5620b60e2960) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("e11-08.ic47", 0x000000, 0x200000, CRC(907f69d3) SHA1(0899ed58edcae22144625c349c9d2fe4d46d11e3) )
	ROM_LOAD32_WORD("e11-07.ic45", 0x000002, 0x200000, CRC(ef018607) SHA1(61b602b13754c3be21caf76acbfc10c87518ba47) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e11-06.ic43", 0x000000, 0x200000, CRC(200ce305) SHA1(c80a0b96510913a6411e6763fb72bf413fb792da) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e11-13.bin",  0x100000, 0x20000, CRC(51a11ff7) SHA1(c03042489d71423667f25856d15aa6a363ea6c92) )
	ROM_LOAD16_BYTE("e11-14.bin",  0x100001, 0x20000, CRC(dce2ba91) SHA1(00bc353c7747a7954365b587d7bc759ee5dc09c2) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e11-04.ic38", 0x000000, 0x200000, CRC(e0ff4fb1) SHA1(81e186e3a692af1da316b8085a729c4f103d9a52) )
	ROM_LOAD16_BYTE("e11-05.ic41", 0x400000, 0x200000, CRC(a4d08cf1) SHA1(ae2cabef7b7bcb8a788988c73d7af6fa4bb2c444) )
ROM_END

ROM_START( gekiridn02 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e11-12c.bin", 0x000000, 0x40000, CRC(448308ce) SHA1(22eac25158bd3a0349aa4f1f041473b93030ee43) )
	ROM_LOAD32_BYTE("e11-11c.bin", 0x000001, 0x40000, CRC(8ae457c4) SHA1(f1d74d99c916df90a74be0ff80b05b0f31284306) )
	ROM_LOAD32_BYTE("e11-10c.bin", 0x000002, 0x40000, CRC(b1ff4529) SHA1(9e8366d9d90ad4155aab3828523daff09e3d400d) )
	ROM_LOAD32_BYTE("e11-09c.bin", 0x000003, 0x40000, CRC(24d884ff) SHA1(35ddb21608c781a0674a4244c8e5c0aa6dc220eb) )

	ROM_REGION(0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e11-03c.bin", 0x000000, 0x200000, CRC(2b0dab58) SHA1(7c70a2104fbbfde32fa006bfafe30c3d9708cb10) )
	ROM_LOAD16_BYTE("e11-02c.bin", 0x000001, 0x200000, CRC(a2c4fa4f) SHA1(2ad73ce8431f1199dd32df83352dc4f85345529f) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e11-01c.bin", 0x000000, 0x200000, CRC(e19874b3) SHA1(a8d6806133977a7decefafff5d7b249803add70b) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("e11-08c.bin", 0x000000, 0x200000, CRC(93884253) SHA1(6d0530db64c84bf7b2ad47e94036ecd8c81418b6) )
	ROM_LOAD32_WORD("e11-07c.bin", 0x000002, 0x200000, CRC(15ca8ac2) SHA1(33cbcc96e5144e5910c67c99815958d8f004287e) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e11-06c.bin", 0x000000, 0x200000, CRC(0acc71d3) SHA1(455c70ec8f1087189170160d5683545bbea1fe9a) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e11-13.bin",  0x100000, 0x20000, CRC(51a11ff7) SHA1(c03042489d71423667f25856d15aa6a363ea6c92) )
	ROM_LOAD16_BYTE("e11-14.bin",  0x100001, 0x20000, CRC(dce2ba91) SHA1(00bc353c7747a7954365b587d7bc759ee5dc09c2) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e11-04.ic38", 0x000000, 0x200000, CRC(e0ff4fb1) SHA1(81e186e3a692af1da316b8085a729c4f103d9a52) )
	ROM_LOAD16_BYTE("e11-05.ic41", 0x400000, 0x200000, CRC(a4d08cf1) SHA1(ae2cabef7b7bcb8a788988c73d7af6fa4bb2c444) )
ROM_END

/************************************
 Grid Seeker: Project Storm Hammer
*************************************/
ROM_START( gseeker01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d40_12hc01.rom", 0x000000, 0x40000, CRC(63894ca7) SHA1(2d8821a088c7d2cfc1a4d117b723d5a40c2a12b6) )
	ROM_LOAD32_BYTE("d40_11hc01.rom", 0x000001, 0x40000, CRC(287358f1) SHA1(a57f53b7093d5db856f136bb11be3508133559a7) )
	ROM_LOAD32_BYTE("d40_10hc01.rom", 0x000002, 0x40000, CRC(af11d645) SHA1(fe5b8068b6263ece28892efa51bd0e2b0df5bb50) )
	ROM_LOAD32_BYTE("d40-09hc01.34",  0x000003, 0x40000, CRC(2d8f3978) SHA1(f9d6548b44f33017430d31c94756e2b5516e492b) )

	ROM_REGION(0x200000, "sprites" , 0)
	ROM_LOAD16_BYTE("d40_03hc01.rom", 0x000000, 0x100000, CRC(644f60c1) SHA1(9af611a3efb115bab17b7aa4f4c87ede1426731d) )
	ROM_LOAD16_BYTE("d40_04hc01.rom", 0x100001, 0x080000, CRC(23a6a9e1) SHA1(ecf1ff6a21991d3596a3a6924134f4ebb8a996fd) )
	ROM_CONTINUE(0,0x80000)
	ROM_LOAD16_BYTE("d40_15hc01.rom", 0x000000, 0x080000, CRC(277f6629) SHA1(4f8c1dc9c2c62da52212dfde40d03c40672eed1a) )
	ROM_LOAD16_BYTE("d40_16hc01.rom", 0x000001, 0x080000, CRC(ec221d06) SHA1(d524c990e4c81d12fa82792064944e9f76c9df08) )

	EMPTY_SPRITE_HIDATA(0x100000)

	ROM_REGION(0x200000, "tilemap" , 0)
	ROM_LOAD32_WORD("d40_05hc01.rom", 0x000000, 0x100000, CRC(b30e97e2) SHA1(ba187ac7f0cc1904adc75350dd2d6fc1cee0b0ce) )
	ROM_LOAD32_WORD("d40_06hc01.rom", 0x000002, 0x100000, CRC(5a5c7d5a) SHA1(4f37c3ece53eb9f94b49fd2b215101a72a7055d0) )

	EMPTY_TILEMAP_HIDATA(0x100000)

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d40_07.rom", 0x100000, 0x20000, CRC(7e9b26c2) SHA1(d88ad39a9d70b4a5bd3f83e0d4d0725f659f1d2a) )
	ROM_LOAD16_BYTE("d40_08.rom", 0x100001, 0x20000, CRC(9c926a28) SHA1(9d9ee75eb895edc381c3ab4df5af941f84cd2073) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d40_01.rom", 0x000000, 0x200000, CRC(ee312e95) SHA1(885553950c2b2195d664639bf7e0d1ffa3e8346a) )
	ROM_LOAD16_BYTE("d40_02.rom", 0x600000, 0x100000, CRC(ed894fe1) SHA1(5bf2fb6abdcf25bc525a2c3b29dbf7aca0b18fea) )

	ROM_REGION16_BE( 0x80, "eeprom", 0 )
	ROM_LOAD("gseeker.nv", 0x0000, 0x0080, CRC(3e24cc80) SHA1(42173cf6aa40bb5015d01f62312fc2ff8d81fb65) )
ROM_END

/****************
 Kaiser Knuckle
*****************/
ROM_START( kaiserkn01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d84-25hc01.20", 0x000000, 0x80000, CRC(f7b8cf53) SHA1(9c1d17f5fe05190fa9b93f2853955416342e47ec) )
	ROM_LOAD32_BYTE("d84-24hc01.19", 0x000001, 0x80000, CRC(9c93aeae) SHA1(d9eb6972648cffde24dfddf9dc7dad81ffd07a56) )
	ROM_LOAD32_BYTE("d84-23hc01.18", 0x000002, 0x80000, CRC(1c7802e0) SHA1(7dd6b53582d9617cfb159451ce73cf7419f626db) )
	ROM_LOAD32_BYTE("d84-29hc01.17", 0x000003, 0x80000, CRC(8a68185d) SHA1(065202c5be0aa60393c65cc62fd46a583c46c72e) )

	ROM_REGION(0xd00000, "sprites" , 0)
	ROM_LOAD16_BYTE("d84-03.rom", 0x000000, 0x200000, CRC(d786f552) SHA1(f73146892f714b5706d568fc8a135fddaa656570) )
	ROM_LOAD16_BYTE("d84-04.rom", 0x000001, 0x200000, CRC(d1f32b5d) SHA1(35289cce64fdbb8d966dd1d5307b5393be5e7799) )
	ROM_LOAD16_BYTE("d84-06.rom", 0x400000, 0x200000, CRC(fa924dab) SHA1(28a8c3cd701f8df0c53069bb576bb2a820f3a331) )
	ROM_LOAD16_BYTE("d84-07.rom", 0x400001, 0x200000, CRC(54517a6b) SHA1(6e2c213c7ec1a3b78ad7e71db2326602557fd0f8) )
	ROM_LOAD16_BYTE("d84-09.rom", 0x800000, 0x200000, CRC(faa78d98) SHA1(da3a2c5a45dd169743f113aa08e574f732e1f0fd) )
	ROM_LOAD16_BYTE("d84-10.rom", 0x800001, 0x200000, CRC(b84b7320) SHA1(f5de0d6da50d8ed753607b51e46bc9a4572ef431) )
	ROM_LOAD16_BYTE("d84-19.rom", 0xc00000, 0x080000, CRC(6ddf77e5) SHA1(a1323acaed37fce62a19e63a0800d9d1dc2cfff7) )
	ROM_LOAD16_BYTE("d84-20.rom", 0xc00001, 0x080000, CRC(f85041e5) SHA1(6b2814514338f550d6aa14dbe39e848e8e64edee) )

	ROM_REGION( 0x680000, "sprites_hi", 0 )
	ROM_LOAD       ("d84-05.rom", 0x000000, 0x200000, CRC(31a3c75d) SHA1(1a16ccb6a0a03ab715e5b016ab3b1b2cd0f1ae41) )
	ROM_LOAD       ("d84-08.rom", 0x200000, 0x200000, CRC(07347bf1) SHA1(34bd359933acdec7fd1ce047092a30d1177afc2c) )
	ROM_LOAD       ("d84-11.rom", 0x400000, 0x200000, CRC(a062c1d4) SHA1(158912aa3dd75c3961bf738f9ac9034f0b005b60) )
	ROM_LOAD       ("d84-21.rom", 0x600000, 0x080000, CRC(89f68b66) SHA1(95916f02f71357324effe59da4f847f2f30ea34a) )

	ROM_REGION(0x600000, "tilemap" , 0)
	ROM_LOAD32_WORD("d84-12.rom", 0x000000, 0x200000, CRC(66a7a9aa) SHA1(a7d21f8b6370d16de3c1569019f2ad71d36e7a61) )
	ROM_LOAD32_WORD("d84-13.rom", 0x000002, 0x200000, CRC(ae125516) SHA1(d54e76e398ab0b0fb82f3154ba54fc823ff49a1a) )
	ROM_LOAD32_WORD("d84-16.rom", 0x400000, 0x100000, CRC(bcff9b2d) SHA1(0ca50ec809564eddf0ba7448a8fae9087d3b600b) )
	ROM_LOAD32_WORD("d84-17.rom", 0x400002, 0x100000, CRC(0be37cc3) SHA1(b10c10b93858cad0c962ef614cfd6daea712ef6b) )

	ROM_REGION( 0x300000, "tilemap_hi", 0 )
	ROM_LOAD       ("d84-14.rom", 0x000000, 0x200000, CRC(2b2e693e) SHA1(03eb37fa7dc68d54bf0f1800b8c0b581c344a40f) )
	ROM_LOAD       ("d84-18.rom", 0x200000, 0x100000, CRC(e812bcc5) SHA1(3574e4a99232d9fc7989ec5d1e8fe76b4b30784a) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d84-26.32", 0x100000, 0x40000, CRC(4f5b8563) SHA1(1d4e06cbea7bc73a99d6e30be714fff420151bbc) )
	ROM_LOAD16_BYTE("d84-27.33", 0x100001, 0x40000, CRC(fb0cb1ba) SHA1(16a79b53651a6131f7636db19738b456b7c28bff) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d84-01.rom", 0x400000, 0x200000, CRC(9ad22149) SHA1(48055822e0cea228cdecf3d05ac24e50979b6f4d) )
	ROM_LOAD16_BYTE("d84-02.rom", 0x800000, 0x200000, CRC(9e1827e4) SHA1(1840881b0f8f7b6225e6ffa12a8d4b463554988e) )
	ROM_LOAD16_BYTE("d84-15.rom", 0xe00000, 0x100000, CRC(31ceb152) SHA1(d9d0bc631a6a726376f566a49605b50485ac7bf4) )
ROM_END

ROM_START( kaiserkn02 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d84-25hc02.20", 0x000000, 0x80000, CRC(e55c530c) SHA1(4114b6ff4204fafe25a654a0411ebaa1cfed9f3e) )
	ROM_LOAD32_BYTE("d84-24hc02.19", 0x000001, 0x80000, CRC(6e55c3d2) SHA1(c2c0d3cc2c5f0b2cbef2f09eb678a7b8ade176f2) )
	ROM_LOAD32_BYTE("d84-23hc02.18", 0x000002, 0x80000, CRC(15ac582b) SHA1(a4af2f641360b9551539d73ff113a8dc70e15f0c) )
	ROM_LOAD32_BYTE("d84-22hc02.17", 0x000003, 0x80000, CRC(5d44734c) SHA1(be9dd23227d27815366d615b2680bd48c6e896bd) )

	ROM_REGION(0xd00000, "sprites" , 0)
	ROM_LOAD16_BYTE("d84-03.rom", 0x000000, 0x200000, CRC(d786f552) SHA1(f73146892f714b5706d568fc8a135fddaa656570) )
	ROM_LOAD16_BYTE("d84-04.rom", 0x000001, 0x200000, CRC(d1f32b5d) SHA1(35289cce64fdbb8d966dd1d5307b5393be5e7799) )
	ROM_LOAD16_BYTE("d84-06.rom", 0x400000, 0x200000, CRC(fa924dab) SHA1(28a8c3cd701f8df0c53069bb576bb2a820f3a331) )
	ROM_LOAD16_BYTE("d84-07.rom", 0x400001, 0x200000, CRC(54517a6b) SHA1(6e2c213c7ec1a3b78ad7e71db2326602557fd0f8) )
	ROM_LOAD16_BYTE("d84-09.rom", 0x800000, 0x200000, CRC(faa78d98) SHA1(da3a2c5a45dd169743f113aa08e574f732e1f0fd) )
	ROM_LOAD16_BYTE("d84-10.rom", 0x800001, 0x200000, CRC(b84b7320) SHA1(f5de0d6da50d8ed753607b51e46bc9a4572ef431) )
	ROM_LOAD16_BYTE("d84-19.rom", 0xc00000, 0x080000, CRC(6ddf77e5) SHA1(a1323acaed37fce62a19e63a0800d9d1dc2cfff7) )
	ROM_LOAD16_BYTE("d84-20.rom", 0xc00001, 0x080000, CRC(f85041e5) SHA1(6b2814514338f550d6aa14dbe39e848e8e64edee) )

	ROM_REGION( 0x680000, "sprites_hi", 0 )
	ROM_LOAD       ("d84-05.rom", 0x000000, 0x200000, CRC(31a3c75d) SHA1(1a16ccb6a0a03ab715e5b016ab3b1b2cd0f1ae41) )
	ROM_LOAD       ("d84-08.rom", 0x200000, 0x200000, CRC(07347bf1) SHA1(34bd359933acdec7fd1ce047092a30d1177afc2c) )
	ROM_LOAD       ("d84-11.rom", 0x400000, 0x200000, CRC(a062c1d4) SHA1(158912aa3dd75c3961bf738f9ac9034f0b005b60) )
	ROM_LOAD       ("d84-21.rom", 0x600000, 0x080000, CRC(89f68b66) SHA1(95916f02f71357324effe59da4f847f2f30ea34a) )

	ROM_REGION(0x600000, "tilemap" , 0)
	ROM_LOAD32_WORD("d84-12.rom", 0x000000, 0x200000, CRC(66a7a9aa) SHA1(a7d21f8b6370d16de3c1569019f2ad71d36e7a61) )
	ROM_LOAD32_WORD("d84-13.rom", 0x000002, 0x200000, CRC(ae125516) SHA1(d54e76e398ab0b0fb82f3154ba54fc823ff49a1a) )
	ROM_LOAD32_WORD("d84-16.rom", 0x400000, 0x100000, CRC(bcff9b2d) SHA1(0ca50ec809564eddf0ba7448a8fae9087d3b600b) )
	ROM_LOAD32_WORD("d84-17.rom", 0x400002, 0x100000, CRC(0be37cc3) SHA1(b10c10b93858cad0c962ef614cfd6daea712ef6b) )

	ROM_REGION( 0x300000, "tilemap_hi", 0 )
	ROM_LOAD       ("d84-14.rom", 0x000000, 0x200000, CRC(2b2e693e) SHA1(03eb37fa7dc68d54bf0f1800b8c0b581c344a40f) )
	ROM_LOAD       ("d84-18.rom", 0x200000, 0x100000, CRC(e812bcc5) SHA1(3574e4a99232d9fc7989ec5d1e8fe76b4b30784a) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d84-26.32", 0x100000, 0x40000, CRC(4f5b8563) SHA1(1d4e06cbea7bc73a99d6e30be714fff420151bbc) )
	ROM_LOAD16_BYTE("d84-27.33", 0x100001, 0x40000, CRC(fb0cb1ba) SHA1(16a79b53651a6131f7636db19738b456b7c28bff) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d84-01.rom", 0x400000, 0x200000, CRC(9ad22149) SHA1(48055822e0cea228cdecf3d05ac24e50979b6f4d) )
	ROM_LOAD16_BYTE("d84-02.rom", 0x800000, 0x200000, CRC(9e1827e4) SHA1(1840881b0f8f7b6225e6ffa12a8d4b463554988e) )
	ROM_LOAD16_BYTE("d84-15.rom", 0xe00000, 0x100000, CRC(31ceb152) SHA1(d9d0bc631a6a726376f566a49605b50485ac7bf4) )
ROM_END

/************
 Land Maker
*************/
ROM_START( landmakr01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e61-13hc01.20", 0x000000, 0x80000, CRC(ff7afcc8) SHA1(a3c8d1c3987c3266c62c056656fd3ea456749080) )
	ROM_LOAD32_BYTE("e61-12hc01.19", 0x000001, 0x80000, CRC(2be4297d) SHA1(fb1ab2e39755317ebf084df349fa0ab6a641d7e2) )
	ROM_LOAD32_BYTE("e61-11hc01.18", 0x000002, 0x80000, CRC(dbc10844) SHA1(2cf377cad0837cc3a25a679a6fe41beff38b20b4) )
	ROM_LOAD32_BYTE("e61-10hc01.17", 0x000003, 0x80000, CRC(42d37d39) SHA1(adb10fcd33a7d8daef111405b596858fe2da6452) )

	ROM_REGION(0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e61-03hc01.12",0x000000, 0x200000, CRC(08e6acb4) SHA1(1edaf0810682f6e3932a69942c4a83169329baf1) )
	ROM_LOAD16_BYTE("e61-02hc01.08",0x000001, 0x200000, CRC(e2f9d072) SHA1(bf47ad233d6cceb552b8e5efadb5130f2529a59f) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e61-01hc01.04",0x000000, 0x200000, CRC(cb6b638c) SHA1(eceea8404f71aaaf8b81aaa6601967d130cb9fd2) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("e61-09hc01.47", 0x000000, 0x200000, CRC(d2e78354) SHA1(3a6e67da77970a69051828a4fb82131d74b5595e) )
	ROM_LOAD32_WORD("e61-08hc01.45", 0x000002, 0x200000, CRC(831bf12a) SHA1(41ac84ff13454caf9eec29a01e974123e2eb8e54) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e61-07.43", 0x000000, 0x200000, CRC(4a57965d) SHA1(8e80788e0f47fb242da9af3aa19077dc0ec829b8) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("eh61-14.32", 0x100000, 0x20000, CRC(b905f4a7) SHA1(613b954e3e129fd44b4ce64958f16e5636012d6e) )
	ROM_LOAD16_BYTE("eh61-15.33", 0x100001, 0x20000, CRC(87909869) SHA1(7b90c23899a673966cac3352d375d17b83e66596) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e61-04.38", 0x400000, 0x200000, CRC(c27aec0c) SHA1(e95da2db07a20a53662ebd45c033966e8a22a15a) )
	ROM_LOAD16_BYTE("e61-05.39", 0x800000, 0x200000, CRC(83920d9d) SHA1(019e39ae85d1129f6d3b8460c4b1bd925f868ee2) )
	ROM_LOAD16_BYTE("e61-06.40", 0xc00000, 0x200000, CRC(2e717bfe) SHA1(1be54cd2ec65d8fd49a5c09b5d27791fd7a320d4) )
ROM_END

ROM_START( landmakr02 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e61-13.20", 0x000000, 0x80000, CRC(0af756a2) SHA1(2dadac6873f2491ee77703f07f00dde2aa909355) )
	ROM_LOAD32_BYTE("e61-12.19", 0x000001, 0x80000, CRC(636b3df9) SHA1(78a5bf4977bb90d710942188ce5016f3df499feb) )
	ROM_LOAD32_BYTE("e61-11.18", 0x000002, 0x80000, CRC(279a0ee4) SHA1(08380286737b33db76a79b27d0df5faba17dfb96) )
	ROM_LOAD32_BYTE("e61-wrd.17", 0x000003, 0x80000, CRC(34a5939e) SHA1(4fbcdd0b57cbd589b554d1751394df8389293966) )

	ROM_REGION(0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e61-03.12",0x000000, 0x200000, CRC(e8abfc46) SHA1(fbde006f9822af3ed8debec525270d329981ea21) )
	ROM_LOAD16_BYTE("e61-02.08",0x000001, 0x200000, CRC(1dc4a164) SHA1(33b412d9653099aaff8ed5e62d1ba4fc30aa9058) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e61-01.04",0x000000, 0x200000, CRC(6cdd8311) SHA1(7810a5a81f3b5a730d2088c79b12fffd77659b5b) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("e61-09.47", 0x000000, 0x200000, CRC(6ba29987) SHA1(b63c12523e19da66b3ca07c3548ac81bf57b59a1) )
	ROM_LOAD32_WORD("e61-08.45", 0x000002, 0x200000, CRC(76c98e14) SHA1(c021c325ab4ae410fa54e2eab61d34318867432b) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e61-07.43", 0x000000, 0x200000, CRC(4a57965d) SHA1(8e80788e0f47fb242da9af3aa19077dc0ec829b8) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("eh61-14.32", 0x100000, 0x20000, CRC(b905f4a7) SHA1(613b954e3e129fd44b4ce64958f16e5636012d6e) )
	ROM_LOAD16_BYTE("eh61-15.33", 0x100001, 0x20000, CRC(87909869) SHA1(7b90c23899a673966cac3352d375d17b83e66596) )

	ROM_REGION16_BE(0x1000000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e61-04.38", 0x400000, 0x200000, CRC(c27aec0c) SHA1(e95da2db07a20a53662ebd45c033966e8a22a15a) )
	ROM_LOAD16_BYTE("e61-05.39", 0x800000, 0x200000, CRC(83920d9d) SHA1(019e39ae85d1129f6d3b8460c4b1bd925f868ee2) )
	ROM_LOAD16_BYTE("e61-06.40", 0xc00000, 0x200000, CRC(2e717bfe) SHA1(1be54cd2ec65d8fd49a5c09b5d27791fd7a320d4) )
ROM_END

ROM_START( landmakr03 )
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("e61-19s03.20", 0x000000, 0x80000, CRC(585f410c) SHA1(188ef37fccd4d16b11f5052cb5252ada22d37b4b) )
	ROM_LOAD32_BYTE("e61-18s03.19", 0x000001, 0x80000, CRC(58f9e498) SHA1(6e8c2b1de8da7bc044b2d274845d96ec9e3f6bf4) )
	ROM_LOAD32_BYTE("e61-17s03.18", 0x000002, 0x80000, CRC(6e15a67b) SHA1(056dc1ecf845961d8a331b054520ca0bb80663d5) )
	ROM_LOAD32_BYTE("e61-16s03.17", 0x000003, 0x80000, CRC(253c94b6) SHA1(32ce61bfbea1b31b8005562a2d9d4b3edd24fa98) )

	ROM_REGION( 0x400000, "sprites" , 0)
	ROM_LOAD16_BYTE("e61-03.12",0x000000, 0x200000, CRC(e8abfc46) SHA1(fbde006f9822af3ed8debec525270d329981ea21) )
	ROM_LOAD16_BYTE("e61-02.08",0x000001, 0x200000, CRC(1dc4a164) SHA1(33b412d9653099aaff8ed5e62d1ba4fc30aa9058) )

	ROM_REGION( 0x200000, "sprites_hi", 0 )
	ROM_LOAD       ("e61-01.04",0x000000, 0x200000, CRC(6cdd8311) SHA1(7810a5a81f3b5a730d2088c79b12fffd77659b5b) )

	ROM_REGION( 0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("e61-09s03.47", 0x000000, 0x200000, CRC(bac13c54) SHA1(33578ace8019547d28cb0db54ab05ba7ec566434) )
	ROM_LOAD32_WORD("e61-08s03.45", 0x000002, 0x200000, CRC(52288694) SHA1(d9d0f2a060131693b75ae71716138cdd075add7e) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("e61-07s03.43", 0x000000, 0x200000, CRC(f521c022) SHA1(6f01f7b9c2c3db45f8dae46d0c815e3b0b70c18c) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("e61-14.32", 0x100000, 0x40000, CRC(18961bbb) SHA1(df054def35a49c0754356c15ec15336cbf28b063) )
	ROM_LOAD16_BYTE("e61-15.33", 0x100001, 0x40000, CRC(2c64557a) SHA1(768007162d5d2cbe650c735bc1af2c10ed13b046) )

	ROM_REGION16_BE( 0x1000000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e61-04.38", 0x400000, 0x200000, CRC(c27aec0c) SHA1(e95da2db07a20a53662ebd45c033966e8a22a15a) )
	ROM_LOAD16_BYTE("e61-05.39", 0x800000, 0x200000, CRC(83920d9d) SHA1(019e39ae85d1129f6d3b8460c4b1bd925f868ee2) )
	ROM_LOAD16_BYTE("e61-06.40", 0xc00000, 0x200000, CRC(2e717bfe) SHA1(1be54cd2ec65d8fd49a5c09b5d27791fd7a320d4) )
ROM_END

/***************
 Light Bringer
****************/
ROM_START( lightbr01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("d69-20hc01.bin", 0x000000, 0x80000, CRC(5b29e745) SHA1(a20ffaf53cb7572217ad5e92d3641927b1998eab) )
	ROM_LOAD32_BYTE("d69-13hc01.bin", 0x000001, 0x80000, CRC(0764221f) SHA1(1465f51396348c12c7d272232699eb69bd46bf9b) )
	ROM_LOAD32_BYTE("d69-15hc01.bin", 0x000002, 0x80000, CRC(66c3a572) SHA1(122bdab9becdd2df0f43c2a34e079cf1625159b9) )
	ROM_LOAD32_BYTE("d69-14hc01.bin", 0x000003, 0x80000, CRC(c1588074) SHA1(0e5c1677f89953791837d1293cc924cfa7fe54e5) )

	ROM_REGION(0x600000, "sprites" , 0)
	ROM_LOAD16_BYTE("d69-06.bin", 0x000000, 0x200000, CRC(cb4aac81) SHA1(15d315c6b9695cc2fe07defc67c7a4fb26de1950) )
	ROM_LOAD16_BYTE("d69-07.bin", 0x000001, 0x200000, CRC(b749f984) SHA1(39fd662bdc42e812519181a640a83e29e300826a) )
	ROM_LOAD16_BYTE("d69-09hc01.bin", 0x400000, 0x100000, CRC(dbac0bf3) SHA1(ff17a43fc0b2f6b41b8394ad00e00b2683e2287a) )
	ROM_LOAD16_BYTE("d69-10hc01.bin", 0x400001, 0x100000, CRC(50673c49) SHA1(62f3fa18c39c0149ec021c5617d2989d546550aa) )

	ROM_REGION( 0x300000, "sprites_hi", 0 )
	ROM_LOAD       ("d69-08.bin", 0x000000, 0x200000, CRC(5b68d7d8) SHA1(f2ee3dd7100a3c9d8f402fe36dae2bc66cb17be3) )
	ROM_LOAD       ("d69-11hc01.bin", 0x200000, 0x100000, CRC(1988fb12) SHA1(790bfaf765bad2665381b6b752d2c26c010b4e4e) )

	ROM_REGION(0x400000, "tilemap" , 0)
	ROM_LOAD32_WORD("d69-03hc01.bin", 0x000000, 0x200000, CRC(36fab42f) SHA1(6e3f78eda7aaa3b565b495dfe4b40a5abb3c3449) )
	ROM_LOAD32_WORD("d69-04hc01.bin", 0x000002, 0x200000, CRC(4a63f543) SHA1(37748b843bb001a4ceb5f10e3a3ab409d242395f) )

	ROM_REGION( 0x200000, "tilemap_hi", 0 )
	ROM_LOAD       ("d69-05hc01.bin", 0x000000, 0x200000, CRC(f84c9c40) SHA1(2e1945ecd904d41d4bca9fbde0083b0c78037b2f) )

	ROM_REGION(0x140000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("d69-18.bin", 0x100000, 0x20000, CRC(04600d7b) SHA1(666cfab09b61fd6e0bc4ff277018ebf1cda01b0e) )
	ROM_LOAD16_BYTE("d69-19.bin", 0x100001, 0x20000, CRC(1484e853) SHA1(4459c18ba005786483c652857e527c6093efb036) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("d69-01.bin", 0x000000, 0x200000, CRC(9ac93ac2) SHA1(1c44f6ba95505f85b0c8a90395f09d2a49da3553) )
	ROM_LOAD16_BYTE("d69-02.bin", 0x400000, 0x200000, CRC(dce28dd7) SHA1(eacfc98349b0608fc1a944c11f0483fb6caa4445) )
ROM_END

/****************
 Puzzle Bobble 2
****************/
ROM_START( pbobble2s01 )
	ROM_REGION(0x200000, "maincpu", 0)
	ROM_LOAD32_BYTE("e10-29.20", 0x000000, 0x40000, CRC(f1e9ad3f) SHA1(8689d85f30e075d21e4be01a2a097a850a921c47) )
	ROM_LOAD32_BYTE("e10-28.19", 0x000001, 0x40000, CRC(412a3602) SHA1(d754e6ac886676d2c1eb52de3a727894f316e6b5) )
	ROM_LOAD32_BYTE("e10-27.18", 0x000002, 0x40000, CRC(88cc0b5c) SHA1(bb08a7b8b37356376052ed03f8515677811823c0) )
	ROM_LOAD32_BYTE("e10-wrd.17", 0x000003, 0x40000, CRC(4bcc216b) SHA1(45e9250414201fa5ad866b32b0285973fd06367c) )

	ROM_REGION(0x200000, "sprites" , 0)
	ROM_LOAD16_BYTE("e10-02.rom", 0x000000, 0x100000, CRC(c0564490) SHA1(cbe9f880192c08f4d1db21d5ba14073b97e5f1d3) )
	ROM_LOAD16_BYTE("e10-01.rom", 0x000001, 0x100000, CRC(8c26ff49) SHA1(cbb514c061106003d2ae2b6c43958b24feaad656) )

	EMPTY_SPRITE_HIDATA(0x100000)

	ROM_REGION(0x200000, "tilemap" , ROMREGION_ERASE00)
	ROM_LOAD32_WORD("e10-07.rom", 0x000000, 0x100000, CRC(dcb3c29b) SHA1(b80c3a8ce53d696c57675e654c9927ef8687759e) )
	ROM_LOAD32_WORD("e10-06.rom", 0x000002, 0x100000, CRC(1b0f20e2) SHA1(66b44d059c2896abac2f0e7fc932489dee440ba0) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e10-05.rom", 0x000000, 0x100000, CRC(81266151) SHA1(aa3b144f32995425db97efce440e234a3c7a6715) )

	ROM_REGION(0x180000, "taito_en:audiocpu", 0)
	ROM_LOAD16_BYTE("e10-30.32", 0x100000, 0x40000, CRC(bb090c1e) SHA1(af2ff23d6f9bd56c25530cb9bf9f452b6f5210f5) )
	ROM_LOAD16_BYTE("e10-31.33", 0x100001, 0x40000, CRC(f4b88d65) SHA1(c74dcb4bed979039fad1d5c7528c14ce4db1d5ec) )

	ROM_REGION16_BE(0x800000, "taito_en:ensoniq" , ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e10-04.rom", 0x000000, 0x200000, CRC(5c0862a6) SHA1(f916f63b8629239e3221e1e231e1b39962ef38ba) )
	ROM_LOAD16_BYTE("e10-03.rom", 0x400000, 0x200000, CRC(46d68ac8) SHA1(ad014e9f0d458308014959ca6823077f581ab088) )
ROM_END

/****************
 Puzzle Bobble 3
****************/
ROM_START( pbobble3s01 )
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("h01.12", 0x000000, 0x80000, CRC(0febed38) SHA1(dbac198cb25881b44dfd6fc2a0483947cba81d96) )
	ROM_LOAD32_BYTE("h01.11", 0x000001, 0x80000, CRC(4b61e414) SHA1(d8a97d90d35b057c0224813b47e302a1a83db246) )
	ROM_LOAD32_BYTE("h01.10", 0x000002, 0x80000, CRC(737f6a4f) SHA1(102578f4b192482e1bbf700cdb776f810f14e0af) )
	ROM_LOAD32_BYTE("h01.16", 0x000003, 0x80000, CRC(1d708518) SHA1(4ca41c4e5dc161f97c40ae72828d393994feb1df) )

	ROM_REGION( 0x200000, "sprites" , 0 )
	ROM_LOAD16_BYTE("e29-02.rom", 0x000000, 0x100000, CRC(437391d3) SHA1(b3cc64c68553d37e0bd09e0dece14901d8df5866) )
	ROM_LOAD16_BYTE("e29-01.rom", 0x000001, 0x100000, CRC(52547c77) SHA1(d0cc8b8915cec1506c9733a1ce1638038ea93d25) )

	EMPTY_SPRITE_HIDATA(0x100000)

	ROM_REGION( 0x200000, "tilemap" , 0 )
	ROM_LOAD32_WORD("e29-08.rom", 0x000000, 0x100000, CRC(7040a3d5) SHA1(ea284ec530aac20348f84122e38a508bbc283f44) )
	ROM_LOAD32_WORD("e29-07.rom", 0x000002, 0x100000, CRC(fca2ea9b) SHA1(a87ebedd0d16657288df434a70b8933fafe0ca25) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e29-06.rom", 0x000000, 0x100000, CRC(c16184f8) SHA1(ded417d9d116b5a2f7518fa404bc2dda1c6a6366) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("e29-13.rom", 0x100000, 0x40000, CRC(1ef551ef) SHA1(527defe8f35314304adb4b483285b08cd6ebe865) )
	ROM_LOAD16_BYTE("e29-14.rom", 0x100001, 0x40000, CRC(7ee7e688) SHA1(d65aa9c449e1d64f10d1be9727a9d93ab1571e65) )

	ROM_REGION16_BE( 0x1000000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e29-03.rom", 0x400000, 0x200000, CRC(a4371658) SHA1(26510a3f6de97f49b10dfc5cb9b7da947a44bfcb) )
	ROM_LOAD16_BYTE("e29-04.rom", 0x800000, 0x200000, CRC(d1f42457) SHA1(2c77be6365deb5ef215da0c66da23b415623bdb1) )
	ROM_LOAD16_BYTE("e29-05.rom", 0xc00000, 0x200000, CRC(e33c1234) SHA1(84c336ed6fd8723e824889fe7b52c284be659e62) )
ROM_END

ROM_START( pbobble3s02 )
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("h02.12", 0x000000, 0x80000, CRC(c22eda63) SHA1(f6968fea221608bd210fae8fa6fd80045def9fe0) )
	ROM_LOAD32_BYTE("h02.11", 0x000001, 0x80000, CRC(531e2891) SHA1(5ce0708ddba9d900b755e842c1d5a9e67986c52d) )
	ROM_LOAD32_BYTE("h02.10", 0x000002, 0x80000, CRC(ba599730) SHA1(7611fbe426d5c9fcd0d0346d57bd44a98035d1b2) )
	ROM_LOAD32_BYTE("h02.16", 0x000003, 0x80000, CRC(412e7ca4) SHA1(84f5616397832855c16e0c6a635a6f08e908f87e) )

	ROM_REGION( 0x200000, "sprites" , 0 )
	ROM_LOAD16_BYTE("e29-02.rom", 0x000000, 0x100000, CRC(437391d3) SHA1(b3cc64c68553d37e0bd09e0dece14901d8df5866) )
	ROM_LOAD16_BYTE("e29-01.rom", 0x000001, 0x100000, CRC(52547c77) SHA1(d0cc8b8915cec1506c9733a1ce1638038ea93d25) )

	EMPTY_SPRITE_HIDATA(0x100000)

	ROM_REGION( 0x200000, "tilemap" , 0 )
	ROM_LOAD32_WORD("e29-08.rom", 0x000000, 0x100000, CRC(7040a3d5) SHA1(ea284ec530aac20348f84122e38a508bbc283f44) )
	ROM_LOAD32_WORD("e29-07.rom", 0x000002, 0x100000, CRC(fca2ea9b) SHA1(a87ebedd0d16657288df434a70b8933fafe0ca25) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD       ("e29-06.rom", 0x000000, 0x100000, CRC(c16184f8) SHA1(ded417d9d116b5a2f7518fa404bc2dda1c6a6366) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("e29-13.rom", 0x100000, 0x40000, CRC(1ef551ef) SHA1(527defe8f35314304adb4b483285b08cd6ebe865) )
	ROM_LOAD16_BYTE("e29-14.rom", 0x100001, 0x40000, CRC(7ee7e688) SHA1(d65aa9c449e1d64f10d1be9727a9d93ab1571e65) )

	ROM_REGION16_BE( 0x1000000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("e29-03.rom", 0x400000, 0x200000, CRC(a4371658) SHA1(26510a3f6de97f49b10dfc5cb9b7da947a44bfcb) )
	ROM_LOAD16_BYTE("e29-04.rom", 0x800000, 0x200000, CRC(d1f42457) SHA1(2c77be6365deb5ef215da0c66da23b415623bdb1) )
	ROM_LOAD16_BYTE("e29-05.rom", 0xc00000, 0x200000, CRC(e33c1234) SHA1(84c336ed6fd8723e824889fe7b52c284be659e62) )
ROM_END

/************
 Twin Qix
************/
ROM_START( twinqix01 )
	ROM_REGION( 0x200000, "maincpu", 0 )
	ROM_LOAD32_BYTE("mpr0-3.b60", 0x000000, 0x40000, CRC(1a63d0de) SHA1(7d8d8a6c9c7f9dfc0a8a528a905e33388b8fe13d) )
	ROM_LOAD32_BYTE("mpr0-2.b61", 0x000001, 0x40000, CRC(45a70987) SHA1(8cca6845064d943fd28416143e60399188b023cd) )
	ROM_LOAD32_BYTE("mpr0-1.b62", 0x000002, 0x40000, CRC(531f9447) SHA1(4d18efaad9c3dd2b14d3125c0f9e18cfcde3a1f2) )
	ROM_LOAD32_BYTE("h01.b63",    0x000003, 0x40000, CRC(3dcd1dab) SHA1(6dbeda16b3c79c2de92076eba5aeb8386a1c8f87) )

	ROM_REGION( 0x100000, "sprites" , 0 )
	ROM_LOAD16_BYTE("obj0-0.a08", 0x000000, 0x080000, CRC(c6ea845c) SHA1(9df710637e8f64f7fec232b5ebbede588e07c2db) )
	ROM_LOAD16_BYTE("obj0-1.a20", 0x000001, 0x080000, CRC(8c12b7fb) SHA1(8a52870fb9f508148619763fb6f37dd74b5386ca) )

	EMPTY_SPRITE_HIDATA(0x080000)

	ROM_REGION( 0x200000, "tilemap" , 0 )
	ROM_LOAD32_BYTE("scr0-0.b07",  0x000000, 0x080000, CRC(9a1b9b34) SHA1(ddf9c6ba0f9c340b580573e1d96ac76b1cd35beb) )
	ROM_LOAD32_BYTE("scr0-1.b06",  0x000001, 0x080000, CRC(e9bef879) SHA1(7e720f5054a1ef3a28353f1c221f4cf15d3b7428) )
	ROM_LOAD32_BYTE("scr0-2.b05",  0x000002, 0x080000, CRC(cac6854b) SHA1(c97fb7de48e1644695bbe431587d6c1be01ea62d) )
	ROM_LOAD32_BYTE("scr0-3.b04",  0x000003, 0x080000, CRC(ce063034) SHA1(2ecff74427d7d2fa8d1db4ac87481d123d7ce003) )

	ROM_REGION( 0x100000, "tilemap_hi", 0 )
	ROM_LOAD16_BYTE("scr0-4.b03",  0x000000, 0x080000, CRC(d32280fe) SHA1(56b120128c5e4b8c6598a1de51269e6702a63175) )
	ROM_LOAD16_BYTE("scr0-5.b02",  0x000001, 0x080000, CRC(fdd1a85b) SHA1(1d94a4858baef3e78c456049dc58249a574205fe) )

	ROM_REGION( 0x180000, "taito_en:audiocpu", 0 )
	ROM_LOAD16_BYTE("spr0-1.b66", 0x100000, 0x40000, CRC(4b20e99d) SHA1(faf184daea0f1131bafa50edb48bd470d4c0b141) )
	ROM_LOAD16_BYTE("spr0-0.b65", 0x100001, 0x40000, CRC(2569eb30) SHA1(ec804131025e600198cd8342925823340e7ef458) )

	ROM_REGION16_BE( 0x400000, "taito_en:ensoniq", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE("snd-0.b43",  0x000000, 0x80000, CRC(ad5405a9) SHA1(67ee42498d2c3c00015237b3b5cd020f9a7c4a18) )
	ROM_LOAD16_BYTE("snd-1.b44",  0x100000, 0x80000, CRC(274864af) SHA1(47fefee23038bb751bdf6b6f48312ba0b6e38b90) )
	ROM_LOAD16_BYTE("snd-14.b10", 0x200000, 0x80000, CRC(26312451) SHA1(9f947a11592fd8420fc581914bf16e7ade75390c) )
	ROM_LOAD16_BYTE("snd-15.b11", 0x300000, 0x80000, CRC(2edaa9dc) SHA1(72fead505c4f44e5736ff7d545d72dfa37d613e2) )
ROM_END

/*    YEAR  NAME            PARENT    MACHINE        INPUT       INIT             MONITOR COMPANY                 FULLNAME FLAGS */
// Akkanbeder
GAME( 1995, akkanvdr01,        spcinv95, f3_224a, f3, taito_f3_state, init_spcinv95, ROT270, "hack",     "Akkanbeder (Chinese)", 0 )
// Arabian Magic
GAME( 2017, arabianm01,        arabianm, f3_224a, f3, taito_f3_state, init_arabianm, ROT0,   "hack",     "Arabian Magic (Chinese, 2017-04-27)", 0 )
// Bubble Memories
GAME( 2020, bubblem01,         bubblem,  f3_224a, f3, taito_f3_state, init_bubblem,  ROT0,   "rtw, MetalliC", "Bubble Memories: Black Edition (World)", 0 )
GAME( 2020, bubblemu01,        bubblem,  f3_224a, f3, taito_f3_state, init_bubblem,  ROT0,   "rtw, MetalliC", "Bubble Memories: Black Edition (USA)", 0 )
// Bubble Symphony
GAME( 1994, bubsymph01,        bublbob2, f3_224a, f3, taito_f3_state, init_bubsymph, ROT0,   "hack",     "Bubble Symphony (Chinese)", 0 )
// Cleopatra Fortune
GAME( 1996, cleopatr01,        cleopatr, f3_224a, f3, taito_f3_state, init_cleopatr, ROT0,   "hack",     "Cleopatra Fortune (Chinese)", 0 )
GAME( 1996, cleopatr02,        cleopatr, f3_224a, f3, taito_f3_state, init_cleopatr, ROT0,   "hack",     "Cleopatra Fortune (Unknown Hack)", 0 )
// Dan-Ku-Ga
GAME( 1994, dankuga01,         dankuga,  f3_224a, kn, taito_f3_state, init_kaiserkn, ROT0,   "hack",     "Dan-Ku-Ga (Plus)", 0 )
GAME( 1994, dankuga02,         dankuga,  f3_224a, kn, taito_f3_state, init_kaiserkn, ROT0,   "Yumeji",   "Dan-Ku-Ga (Enable Hidden Characters)", 0 )
// Darius Gaiden
GAME( 1994, dariusg01,         dariusg,  f3,      f3, taito_f3_state, init_dariusg,  ROT0,   "hack",     "Darius Gaiden (Unknown Hack)", 0 )
// Elevator Action Returns
GAME( 1994, elvactr01,         elvactr,  f3,      f3, taito_f3_state, init_elvactr,  ROT0,   "hack",     "Elevator Action Returns (Chinese)", 0 )
// Gekirindan
GAME( 1995, gekiridn01,        gekiridn, f3,      f3, taito_f3_state, init_gekirido, ROT270, "hack",     "Gekirindan (Unknown Hack)", 0 )
GAME( 1995, gekiridn02,        gekiridn, f3,      f3, taito_f3_state, init_gekirido, ROT270, "hack",     "Gekirindan (Chinese)", 0 )
// Grid Seeker: Project Storm Hammer
GAME( 1992, gseeker01,         gseeker,  f3_224b, f3, taito_f3_state, init_gseeker,  ROT90,  "hack",     "Grid Seeker: Project Storm Hammer (Chinese)", 0 )
// Kaiser Knuckle
GAME( 1994, kaiserkn01,        kaiserkn, f3_224a, kn, taito_f3_state, init_kaiserkn, ROT0,   "Yumeji",   "Kaiser Knuckle (Enable Hidden Characters)", 0 )
GAME( 1994, kaiserkn02,        kaiserkn, f3_224a, kn, taito_f3_state, init_kaiserkn, ROT0,   "hack",     "Kaiser Knuckle (Plus)", 0 )
// Land Maker
GAME( 1998, landmakr01,        landmakr, f3,      f3, taito_f3_state, init_landmakr, ROT0,   "hack",     "Land Maker (Chinese)", 0 )
GAME( 1998, landmakr02,        landmakr, f3,      f3, taito_f3_state, init_landmakr, ROT0,   "hack",     "Land Maker (Unknown Hack)", 0 )
GAME( 2023, landmakr03,        landmakr, f3,      f3, taito_f3_state, init_landmakr, ROT0,   "ywy, MA97","Land Maker (English translation of the story line)", 0 )
// Light Bringer
GAME( 2017, lightbr01,         lightbr,  f3_224a, f3, taito_f3_state, init_lightbr,  ROT0,   "hack",     "Light Bringer (Chinese, 2017-04-26)", 0 )
// Puzzle Bobble 2
GAME( 1995, pbobble2s01,       pbobble2, f3,      f3, taito_f3_state, init_pbobbl2x, ROT0,   "hack",     "Puzzle Bobble 2 (Bobble 2X Hack)", 0 )
// Puzzle Bobble 3
GAME( 2022, pbobble3s01,       pbobble3, f3,      f3, taito_f3_state, init_pbobble3, ROT0,   "Bankbank", "Puzzle Bobble 3 (Recarbonated)", 0 )
GAME( 2022, pbobble3s02,       pbobble3, f3,      f3, taito_f3_state, init_pbobble3, ROT0,   "Bankbank", "Puzzle Bobble 3 (Recarbonated, 2p only)", 0 )
// Twin Qix
GAME( 1995, twinqix01,         twinqix,  f3_224a, f3, taito_f3_state, init_twinqix,  ROT0,   "hack",     "Twin Qix (Ver 1.0A 1995/01/17, Japan)", 0 )

