/******************************************************************************
***********   .d8888b.   .d8888b    *******************************************
**********   d88P  Y88b d88P  Y88b   ******************************************
*            888    888        888   ******************************************
*    8888b.  888    888      .d88P   ******************************************
*   888 "88b 888    888  .od888P"  ********************************************
*   888  888 888    888 d88P"    **********************************************
*   888  888 Y88b  d88P 888"        *******************************************
*   888  888  "Y8888P"  888888888            Open Kaillera: http://okai.sf.net
******************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <time.h>
#include <cstdio>
#include <iostream>
#include <cstdlib>
#include "k_socket.h"
//#include "spcharlist.h"

using namespace std;

char bufrer[256000];


typedef struct {
	char LISTSTR[512];
	time_t timeout;
	in_addr addr;
} wg_st;

#include "nSTL.h"

slist<wg_st, 255> waiting_games;

#define wgl_timeout 62
#define wgl_timeoutr 30

void n02_Debug_(char * file, int Line, char * msg) {
	printf("%s:%i> %s\n", file, Line, msg);
}
//#define n02_Debug(X) n02_Debug_(__FILE__,__LINE__,X);
#define n02_Debug(X) 


int nfd = 0;
int create_socket(int type, unsigned short * port){
	int sock;
	struct sockaddr_in addr;
	socklen_t addr_size;
	sock = socket(AF_INET, type, 0);
	if (sock < 0) {
		printf("socket creation failed errno=%d\n", errno);
        return -1;
	}
	////bind to any local address
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	addr.sin_port = htons(*port);
	if (bind(sock, (struct sockaddr *)&addr,sizeof(addr)) < 0) {
		closesocket(sock);
		printf("socket bind failed errno=%d\n", errno);
        return -1;
	}
	//if port is 0, determine the allocated port
	if (*port == 0){
		addr_size = sizeof(addr);
		getsockname(sock, (struct sockaddr*)&addr, &addr_size);
		*port = ntohs(addr.sin_port);
	}
	if (nfd < sock)
		nfd = sock;
	//enable its non-blocking mode...
	addr_size = 1;
#ifdef linux
	ioctl(sock, FIONBIO, &addr_size);
#else
	ioctl(sock, FIONBIO, (unsigned long*)&addr_size);
#endif

	
	return sock;
}

void close_socket(int sock){
	shutdown(sock, 2);
	closesocket(sock);
}

void setup_addr(struct sockaddr_in * addr, char * ip, unsigned short port) {
	memset(addr, 0, sizeof(struct sockaddr_in));
	addr->sin_family = AF_INET;
    addr->sin_addr.s_addr = inet_addr(ip);
    addr->sin_port = htons(port);;
}

int check_socket(int sock, int time){
	
#if defined(linux)
	struct TIMEVAL tv;
#else
	TIMEVAL tv;
#endif
	fd_set fd;
	int secs, usecs;
	
	//Initialize the time to wait
	secs = 0;
	usecs = 0;
	if (time >= 1000) {
		usecs = time % 1000;
		secs = time - usecs;
		usecs *= 1000;
		secs /= 1000;
	} else {
		secs = 0;
		usecs = time * 1000;
	}
	tv.tv_sec = secs;
	tv.tv_usec = usecs;
	
	//initialize fd structure
	FD_ZERO(&fd);
	FD_SET(sock, &fd);
	
	select(sock + 1, &fd, 0, 0, &tv);
	
	if (FD_ISSET(sock, &fd))
		return 1;
	else
		return 0;
	
}



#define SRVPORT 27889

int main(int argc, char * args[]) {
	n02_Debug("Initializing sockets");
	k_socket::Initialize();

	unsigned short localtcpport = SRVPORT;
	SOCKET socktcp = create_socket(SOCK_STREAM, &localtcpport);
	if (socktcp == -1)
		return 1;

	listen(socktcp, 2);
	

	n02_Debug("Sockets initialized");
	k_socket sock;
	if (sock.initialize(SRVPORT)) {
		n02_Debug("Socket initialized");
		bool rewrite = true;
		while (true) {
//			n02_Debug("loop");
			sockaddr_in saddr;


			socklen_t addremotesize = sizeof(saddr);
			SOCKET e = accept(socktcp, (struct sockaddr*)&saddr, &addremotesize);

			if (e != INVALID_SOCKET) {
				char IP[128];
				sprintf(IP, "%s:%i", inet_ntoa(saddr.sin_addr), ntohs(saddr.sin_port));
				printf("%s> TCP/HTTP\n", IP);

				unsigned long addr_size = 0;
#ifdef linux
				ioctl(e, FIONBIO, &addr_size);
#else
				ioctl(e, FIONBIO, (unsigned long*)&addr_size);
#endif
				if (check_socket(socktcp, 1000)) {
					char buf[1500];
					recv(e, buf, 1500, 0);
				}
				send(e, bufrer, strlen(bufrer), 0);//, (struct sockaddr*)&saddr, addremotesize);
				close_socket(e);
			}

			k_socket::check_sockets(0, 50);
			time_t ti = time(0);
			if (sock.has_data()) {
				char buf[2000];
				int bflen = 510;
				if (sock.check_recv(buf, &bflen, false, &saddr) && bflen > 5) {
					sock.set_addr(&saddr);

					buf[bflen]=0;
					memcpy(buf, buf+1, bflen);
					if (strstr(buf, "\n")!=NULL) continue;
					char IP[128];
					sprintf(IP, "%s:%i", inet_ntoa(saddr.sin_addr), ntohs(saddr.sin_port));
					printf("%s> %s\n", IP, buf);
					if (strcmp(buf, "WHATISMYIP")==0) {
						char RETB[201];
						sprintf(RETB+1, "IPIS %s", IP);
						RETB[0] = 0;
						sock.send(RETB, strlen(RETB+1)+2);
					} else if (strncmp(buf, "ENLISP ", 7) == 0) {
						n02_Debug("ENLISP");
						memcpy(buf, buf+7, bflen);
						int p = 0;
						char * rtr = buf + strlen(buf);
						while (rtr-- > buf) {
							if (*rtr == '|')
								p++;
						}
						if (p==3) {
							int x;
							for (x = 0; x < waiting_games.length; x++) {
								if (waiting_games[x].addr.s_addr == saddr.sin_addr.s_addr) {
									waiting_games.items[x].timeout = ti + wgl_timeoutr;
									//sprintf(waiting_games.items[x].LISTSTR, "%s|%s|", buf, IP);
									break;
								}
							}
							if (x == waiting_games.length && waiting_games.length < 250) {
								rtr = buf + strlen(buf);
								while (*rtr != '|') {rtr--;}
								*rtr=0;
								int port = atoi(rtr + 1);
								sprintf(IP, "%s:%i", inet_ntoa(saddr.sin_addr), port);
								wg_st ax;
								ax.addr.s_addr = saddr.sin_addr.s_addr;
								ax.timeout = ti + wgl_timeout;
								sprintf(ax.LISTSTR, "%s|%s|", buf, IP);
								waiting_games.add(ax);
								rewrite = true;
							}
						}
					} else if (strncmp(buf, "ENLIST ", 7) == 0) {
						n02_Debug("ENLIST");
						memcpy(buf, buf+7, bflen);
						int p = 0;
						char * rtr = buf + strlen(buf);
						while (rtr-- > buf) {
							if (*rtr == '|')
								p++;
						}
						if (p==2) {
							int x;
							for (x = 0; x < waiting_games.length; x++) {
								if (waiting_games[x].addr.s_addr == saddr.sin_addr.s_addr) {
									waiting_games.items[x].timeout = ti + wgl_timeoutr;
									sprintf(waiting_games.items[x].LISTSTR, "%s|%s|", buf, IP);
									break;
								}
							}
							if (x == waiting_games.length && waiting_games.length < 250) {
								wg_st ax;
								ax.addr.s_addr = saddr.sin_addr.s_addr;
								ax.timeout = ti + wgl_timeout;
								sprintf(ax.LISTSTR, "%s|%s|", buf, IP);
								waiting_games.add(ax);
								rewrite = true;
							}
						}
					} else if (strcmp(buf, "UNENLIST") == 0) {
						n02_Debug("UNLIST");
						int x;
						for (x = 0; x < waiting_games.length; x++) {
							if (waiting_games[x].addr.s_addr == saddr.sin_addr.s_addr) {
								waiting_games.removei(x);
								rewrite = true;
								break;
							}
						}
					} else {
						char RETB[201];
						sprintf(RETB+1, "Be nice and fuck off %s %s", IP, buf);
						RETB[0] = 0;
						sock.send(RETB, strlen(RETB+1)+2);
					}
				}
			}
			for (int x = 0; x < waiting_games.length; x++) {
				if (waiting_games.items[x].timeout < ti) {
					n02_Debug("TIMEOUT");
					waiting_games.removei(x);
					x--;
					rewrite = true;
				}
			}
			if (rewrite) {
				n02_Debug("REWRITE");
				rewrite = false;
				char * bptr = bufrer;
				*bptr = 0;
				strcat(bptr, "\r\n\r\n");
				bptr += strlen(bptr);
				for (int i=0; i< waiting_games.length; i++) {
					strcat(bptr, waiting_games.items[i].LISTSTR);
					bptr += strlen(bptr);
				}
				strcat(bptr, "\n\n\n\n");
				/*
				FILE * f = fopen("C:\\xampp\\htdocs\\glist.txt", "w+");
				for (int i=0; i< waiting_games.length; i++) {
					fprintf(f, "%s", waiting_games.items[i].LISTSTR);
				}
				fprintf(f, "\n\n\n\n");
				fclose(f);
				*/
			}
			
		}
		sock.close();
		close_socket(socktcp);
	} else {
		printf("Socket error: %i", errno);
	}
	k_socket::Cleanup();
	return EXIT_SUCCESS;
}
