/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.reflection.StringToObjectConverter;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;

public class DefaultNanoContainer
implements NanoContainer {
    private static final Map primitiveNameToBoxedName = new HashMap();
    private final List urls = new ArrayList();
    private final StringToObjectConverter converter = new StringToObjectConverter();
    private final MutablePicoContainer picoContainer;
    private final ClassLoader parentClassLoader;
    private ClassLoader componentClassLoader;
    private boolean componentClassLoaderLocked;

    private static String getClassName(String primitiveOrClass) {
        String fromMap = (String)primitiveNameToBoxedName.get(primitiveOrClass);
        return fromMap != null ? fromMap : primitiveOrClass;
    }

    public DefaultNanoContainer(ClassLoader parentClassLoader, MutablePicoContainer picoContainer) {
        this.parentClassLoader = parentClassLoader;
        if (picoContainer == null) {
            throw new NullPointerException("picoContainer");
        }
        this.picoContainer = picoContainer;
    }

    public DefaultNanoContainer(ClassLoader parentClassLoader) {
        this(parentClassLoader, (MutablePicoContainer)new DefaultPicoContainer());
    }

    public DefaultNanoContainer(MutablePicoContainer picoContainer) {
        this(DefaultNanoContainer.class.getClassLoader(), picoContainer);
    }

    public DefaultNanoContainer(NanoContainer parent) {
        this(parent.getComponentClassLoader(), (MutablePicoContainer)new DefaultPicoContainer((PicoContainer)parent.getPico()));
    }

    public DefaultNanoContainer() {
        this(DefaultNanoContainer.class.getClassLoader(), (MutablePicoContainer)new DefaultPicoContainer());
    }

    public ComponentAdapter registerComponentImplementation(String componentImplementationClassName) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        return this.picoContainer.registerComponentImplementation(this.loadClass(componentImplementationClassName));
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName) throws ClassNotFoundException {
        Class componentImplementation = this.loadClass(componentImplementationClassName);
        return this.picoContainer.registerComponentImplementation(key, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName, Parameter[] parameters) throws ClassNotFoundException {
        Class componentImplementation = this.loadClass(componentImplementationClassName);
        return this.picoContainer.registerComponentImplementation(key, componentImplementation, parameters);
    }

    public ComponentAdapter registerComponentImplementation(Object key, String componentImplementationClassName, String[] parameterTypesAsString, String[] parameterValuesAsString) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        Class<?> componentImplementation = this.getComponentClassLoader().loadClass(componentImplementationClassName);
        return this.registerComponentImplementation(parameterTypesAsString, parameterValuesAsString, key, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(String componentImplementationClassName, String[] parameterTypesAsString, String[] parameterValuesAsString) throws PicoRegistrationException, ClassNotFoundException, PicoIntrospectionException {
        Class<?> componentImplementation = this.getComponentClassLoader().loadClass(componentImplementationClassName);
        return this.registerComponentImplementation(parameterTypesAsString, parameterValuesAsString, componentImplementation, componentImplementation);
    }

    private ComponentAdapter registerComponentImplementation(String[] parameterTypesAsString, String[] parameterValuesAsString, Object key, Class componentImplementation) throws ClassNotFoundException {
        Parameter[] parameters = new Parameter[parameterTypesAsString.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class paramTypeClass = this.loadClass(parameterTypesAsString[i]);
            Object value = this.converter.convertTo(paramTypeClass, parameterValuesAsString[i]);
            parameters[i] = new ConstantParameter(value);
        }
        return this.picoContainer.registerComponentImplementation(key, componentImplementation, parameters);
    }

    private Class loadClass(String componentImplementationClassName) throws ClassNotFoundException {
        String cn = DefaultNanoContainer.getClassName(componentImplementationClassName);
        ClassLoader classLoader = this.getComponentClassLoader();
        return classLoader.loadClass(cn);
    }

    public void addClassLoaderURL(URL url) {
        if (this.componentClassLoaderLocked) {
            throw new IllegalStateException("ClassLoader URLs cannot be added once this ContainerAdapter is locked");
        }
        this.urls.add(url);
    }

    public ClassLoader getComponentClassLoader() {
        if (this.componentClassLoader == null) {
            URL[] urlz = this.urls.toArray(new URL[this.urls.size()]);
            this.componentClassLoaderLocked = true;
            this.componentClassLoader = new URLPrintingClassLoader(urlz, this.parentClassLoader);
        }
        return this.componentClassLoader;
    }

    public MutablePicoContainer getPico() {
        return this.picoContainer;
    }

    public Object getComponentInstanceOfType(String componentType) {
        try {
            Class<?> compType = this.getComponentClassLoader().loadClass(componentType);
            Object componentInstance = this.picoContainer.getComponentInstanceOfType(compType);
            return componentInstance;
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException("Can't resolve class as type '" + componentType + "'");
        }
    }

    static {
        primitiveNameToBoxedName.put("int", Integer.class.getName());
        primitiveNameToBoxedName.put("byte", Byte.class.getName());
        primitiveNameToBoxedName.put("short", Short.class.getName());
        primitiveNameToBoxedName.put("long", Long.class.getName());
        primitiveNameToBoxedName.put("float", Float.class.getName());
        primitiveNameToBoxedName.put("double", Double.class.getName());
        primitiveNameToBoxedName.put("boolean", Boolean.class.getName());
    }

    public static class URLPrintingClassLoader
    extends URLClassLoader {
        public URLPrintingClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(this.getPrettyURLs(), e);
            }
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(this.getPrettyURLs(), e);
            }
        }

        private String getPrettyURLs() {
            String result = "Classloader URLs (classpath):\n";
            URL[] urls = this.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                result = result + url.toString() + "\n";
            }
            return result;
        }
    }
}

