/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ScriptedContainerBuilderFactory {
    public static final String GROOVY = ".groovy";
    public static final String BEANSHELL = ".bsh";
    public static final String JAVASCRIPT = ".js";
    public static final String JYTHON = ".py";
    public static final String XML = ".xml";
    private static final Map extensionToBuilders = new HashMap();
    private ScriptedContainerBuilder containerBuilder;

    public ScriptedContainerBuilderFactory(File compositionFile, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        this(new FileReader(ScriptedContainerBuilderFactory.fileExists(compositionFile)), ScriptedContainerBuilderFactory.getBuilderClassName(compositionFile), classLoader);
    }

    public ScriptedContainerBuilderFactory(File compositionFile) throws IOException, ClassNotFoundException {
        this(new FileReader(ScriptedContainerBuilderFactory.fileExists(compositionFile)), ScriptedContainerBuilderFactory.getBuilderClassName(compositionFile), ScriptedContainerBuilderFactory.class.getClassLoader());
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClass) throws ClassNotFoundException {
        this(composition, builderClass, ScriptedContainerBuilderFactory.class.getClassLoader());
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClass, ClassLoader classLoader) throws ClassNotFoundException {
        DefaultPicoContainer dpc = new DefaultPicoContainer();
        dpc.registerComponentInstance((Object)composition);
        dpc.registerComponentInstance((Object)classLoader);
        DefaultNanoContainer defaultReflectionContainerAdapter = new DefaultNanoContainer((MutablePicoContainer)dpc);
        ComponentAdapter componentAdapter = defaultReflectionContainerAdapter.registerComponentImplementation(builderClass);
        this.containerBuilder = (ScriptedContainerBuilder)componentAdapter.getComponentInstance((PicoContainer)defaultReflectionContainerAdapter.getPico());
    }

    private static File fileExists(File file) throws FileNotFoundException {
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
    }

    private static String getBuilderClassName(File compositionFile) throws IOException {
        String language = ScriptedContainerBuilderFactory.getExtension(compositionFile);
        return ScriptedContainerBuilderFactory.getBuilderClassName(language);
    }

    public static String getBuilderClassName(String extension) {
        return (String)extensionToBuilders.get(extension);
    }

    private static String getExtension(File file) throws IOException {
        return file.getCanonicalPath().substring(file.getCanonicalPath().lastIndexOf("."));
    }

    public ScriptedContainerBuilder getContainerBuilder() {
        return this.containerBuilder;
    }

    static {
        extensionToBuilders.put(GROOVY, "org.nanocontainer.script.groovy.GroovyContainerBuilder");
        extensionToBuilders.put(BEANSHELL, "org.nanocontainer.script.bsh.BeanShellContainerBuilder");
        extensionToBuilders.put(JAVASCRIPT, "org.nanocontainer.script.rhino.JavascriptContainerBuilder");
        extensionToBuilders.put(XML, "org.nanocontainer.script.xml.XMLContainerBuilder");
        extensionToBuilders.put(JYTHON, "org.nanocontainer.script.jython.JythonContainerBuilder");
    }
}

