/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086UserEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.ConnectionRejected;
import org.emulinker.kaillera.controller.v086.protocol.ServerACK;
import org.emulinker.kaillera.controller.v086.protocol.ServerStatus;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.ConnectedEvent;
import org.emulinker.kaillera.model.event.UserEvent;
import org.emulinker.kaillera.model.exception.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACKAction
implements V086Action,
V086UserEventHandler {
    private static Log log = LogFactory.getLog(ACKAction.class);
    private static final String desc = "ACKAction";
    private static ACKAction singleton = new ACKAction();
    private static int numAcksForSpeedTest = 3;
    private int actionCount = 0;
    private int handledCount = 0;

    public static ACKAction getInstance() {
        return singleton;
    }

    private ACKAction() {
    }

    @Override
    public int getActionPerformedCount() {
        return this.actionCount;
    }

    @Override
    public int getHandledEventCount() {
        return this.handledCount;
    }

    @Override
    public String toString() {
        return desc;
    }

    @Override
    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        ++this.actionCount;
        KailleraUser user = clientHandler.getUser();
        if (user.isLoggedIn()) {
            return;
        }
        clientHandler.addSpeedMeasurement();
        if (clientHandler.getSpeedMeasurementCount() > numAcksForSpeedTest) {
            user.setPing(clientHandler.getAverageNetworkSpeed());
            user.setPing(clientHandler.getBestNetworkSpeed());
            log.debug((Object)("Calculated " + user + " ping time: average=" + clientHandler.getAverageNetworkSpeed() + ", best=" + clientHandler.getBestNetworkSpeed()));
            try {
                user.login();
            }
            catch (LoginException e) {
                try {
                    clientHandler.send(new ConnectionRejected(clientHandler.getNextMessageNumber(), user.getName(), user.getID(), e.getMessage()));
                }
                catch (MessageFormatException e2) {
                    log.error((Object)"Failed to contruct new ConnectionRejected", (Throwable)e);
                }
                throw new FatalActionException("Login failed: " + e.getMessage());
            }
        }
        try {
            clientHandler.send(new ServerACK(clientHandler.getNextMessageNumber()));
        }
        catch (MessageFormatException e) {
            log.error((Object)"Failed to contruct new ServerACK", (Throwable)e);
            return;
        }
    }

    @Override
    public void handleEvent(UserEvent event, V086Controller.V086ClientHandler clientHandler) {
        boolean bl;
        ++this.handledCount;
        ConnectedEvent connectedEvent = (ConnectedEvent)event;
        KailleraServer server = connectedEvent.getServer();
        KailleraUser thisUser = connectedEvent.getUser();
        ArrayList<ServerStatus.User> users = new ArrayList<ServerStatus.User>();
        ArrayList<ServerStatus.Game> games = new ArrayList<ServerStatus.Game>();
        try {
            for (KailleraUser kailleraUser : server.getUsers()) {
                if (kailleraUser.getStatus() == 2 || kailleraUser.equals(thisUser)) continue;
                users.add(new ServerStatus.User(kailleraUser.getName(), kailleraUser.getPing(), (byte)kailleraUser.getStatus(), kailleraUser.getID(), kailleraUser.getConnectionType()));
            }
        }
        catch (MessageFormatException e) {
            log.error((Object)"Failed to contruct new ServerStatus.User", (Throwable)e);
            return;
        }
        try {
            for (KailleraGame kailleraGame : server.getGames()) {
                games.add(new ServerStatus.Game(kailleraGame.getRomName(), (short)kailleraGame.getID(), kailleraGame.getClientType(), kailleraGame.getOwner().getName(), kailleraGame.getNumPlayers() + "/" + 2, (byte)kailleraGame.getStatus()));
            }
        }
        catch (MessageFormatException e) {
            log.error((Object)"Failed to contruct new ServerStatus.User", (Throwable)e);
            return;
        }
        int counter = 0;
        boolean bl2 = false;
        ArrayList<ServerStatus.User> usersSubList = new ArrayList<ServerStatus.User>();
        ArrayList<ServerStatus.Game> gamesSubList = new ArrayList<ServerStatus.Game>();
        while (!users.isEmpty()) {
            ServerStatus.User user = (ServerStatus.User)users.get(0);
            users.remove(0);
            if (counter + user.getLength() >= 400) {
                this.sendServerStatus(clientHandler, usersSubList, gamesSubList, counter);
                usersSubList = new ArrayList();
                gamesSubList = new ArrayList();
                counter = 0;
                boolean bl3 = true;
            }
            counter += user.getLength();
            usersSubList.add(user);
        }
        while (!games.isEmpty()) {
            ServerStatus.Game game = (ServerStatus.Game)games.get(0);
            games.remove(0);
            if (counter + game.getLength() >= 400) {
                this.sendServerStatus(clientHandler, usersSubList, gamesSubList, counter);
                usersSubList = new ArrayList();
                gamesSubList = new ArrayList();
                counter = 0;
                bl = true;
            }
            counter += game.getLength();
            gamesSubList.add(game);
        }
        if (usersSubList.size() > 0 || gamesSubList.size() > 0 || !bl) {
            this.sendServerStatus(clientHandler, usersSubList, gamesSubList, counter);
        }
    }

    private void sendServerStatus(V086Controller.V086ClientHandler clientHandler, List<ServerStatus.User> users, List<ServerStatus.Game> games, int counter) {
        StringBuilder sb = new StringBuilder();
        for (ServerStatus.Game game : games) {
            sb.append(game.getGameID());
            sb.append(",");
        }
        log.debug((Object)("Sending ServerStatus to " + clientHandler.getUser() + ": " + users.size() + " users, " + games.size() + " games in " + counter + " bytes, games: " + sb.toString()));
        try {
            clientHandler.send(new ServerStatus(clientHandler.getNextMessageNumber(), users, games));
        }
        catch (MessageFormatException e) {
            log.error((Object)"Failed to contruct new ServerStatus for users", (Throwable)e);
        }
    }
}

