/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.protocol.CachedGameData;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.GameData;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.exception.GameDataException;

public class CachedGameDataAction
implements V086Action {
    private static Log log = LogFactory.getLog(CachedGameDataAction.class);
    private static final String desc = "CachedGameDataAction";
    private static CachedGameDataAction singleton = new CachedGameDataAction();
    private static Log keyLog = LogFactory.getLog((String)"KEYLOG");
    private int actionCount = 0;

    public static CachedGameDataAction getInstance() {
        return singleton;
    }

    private CachedGameDataAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        try {
            int key = ((CachedGameData)message).getKey();
            byte[] data = clientHandler.getClientGameDataCache().get(key);
            clientHandler.getUser().addGameData(data);
        }
        catch (GameDataException e) {
            log.debug((Object)("Game data error: " + e.getMessage()));
            if (e.hasResponse()) {
                try {
                    clientHandler.send(new GameData(clientHandler.getNextMessageNumber(), e.getResponse()));
                }
                catch (MessageFormatException e2) {
                    log.error((Object)("Failed to contruct GameData message: " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.error((Object)("Game data error!  The client cached key " + ((CachedGameData)message).getKey() + " was not found in the cache!"), (Throwable)e);
            try {
                clientHandler.send(new GameChat_Notification(clientHandler.getNextMessageNumber(), "Error", "Game Data Error!  Game state will be inconsistent!"));
            }
            catch (MessageFormatException e2) {
                log.error((Object)"Failed to contruct new GameChat_Notification", (Throwable)e);
            }
        }
    }
}

