/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.GameOwnerCommandAction;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.GameChat;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.GameChat_Request;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.event.GameChatEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.exception.GameChatException;

public class GameChatAction
implements V086Action,
V086GameEventHandler {
    public static final String ADMIN_COMMAND_ESCAPE_STRING = "/";
    private static Log log = LogFactory.getLog(GameChatAction.class);
    private static final String desc = "GameChatAction";
    private static GameChatAction singleton = new GameChatAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static GameChatAction getInstance() {
        return singleton;
    }

    private GameChatAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof GameChat_Request)) {
            throw new FatalActionException("Received incorrect instance of GameChat: " + message);
        }
        ++this.actionCount;
        GameChat_Request gameChatMessage = (GameChat_Request)message;
        try {
            clientHandler.getUser().gameChat(gameChatMessage.getMessage(), gameChatMessage.getNumber());
        }
        catch (GameChatException e) {
            log.debug((Object)("Failed to send game chat message: " + e.getMessage()));
        }
        if (((GameChat)message).getMessage().startsWith(ADMIN_COMMAND_ESCAPE_STRING)) {
            try {
                GameOwnerCommandAction.getInstance().performAction(message, clientHandler);
            }
            catch (FatalActionException e) {
                log.warn((Object)("GameOwner command failed, processing as chat: " + e.getMessage()));
            }
        }
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        GameChatEvent gameChatEvent = (GameChatEvent)event;
        try {
            clientHandler.send(new GameChat_Notification(clientHandler.getNextMessageNumber(), gameChatEvent.getUser().getName(), gameChatEvent.getMessage()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct GameChat_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

