/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.CachedGameData;
import org.emulinker.kaillera.controller.v086.protocol.GameData;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.event.GameDataEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.exception.GameDataException;

public class GameDataAction
implements V086Action,
V086GameEventHandler {
    private static Log log = LogFactory.getLog(GameDataAction.class);
    private static final String desc = "GameDataAction";
    private static GameDataAction singleton = new GameDataAction();
    private static Log keyLog = LogFactory.getLog((String)"KEYLOG");
    private int actionCount = 0;
    private int handledCount = 0;

    public static GameDataAction getInstance() {
        return singleton;
    }

    private GameDataAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        block4: {
            try {
                byte[] data = ((GameData)message).getGameData();
                int key = clientHandler.getClientGameDataCache().add(data);
                clientHandler.getUser().addGameData(data);
            }
            catch (GameDataException e) {
                log.debug((Object)("Game data error: " + e.getMessage()));
                if (!e.hasResponse()) break block4;
                try {
                    clientHandler.send(new GameData(clientHandler.getNextMessageNumber(), e.getResponse()));
                }
                catch (MessageFormatException e2) {
                    log.error((Object)("Failed to contruct GameData message: " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        byte[] data = ((GameDataEvent)event).getData();
        int key = clientHandler.getServerGameDataCache().indexOf(data);
        if (key < 0) {
            key = clientHandler.getServerGameDataCache().add(data);
            try {
                clientHandler.send(new GameData(clientHandler.getNextMessageNumber(), data));
            }
            catch (MessageFormatException e) {
                log.error((Object)("Failed to contruct GameData message: " + e.getMessage()), (Throwable)e);
            }
        } else {
            try {
                clientHandler.send(new CachedGameData(clientHandler.getNextMessageNumber(), key));
            }
            catch (MessageFormatException e) {
                log.error((Object)("Failed to contruct CachedGameData message: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

