/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.Quit_Notification;
import org.emulinker.kaillera.controller.v086.protocol.Quit_Request;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.event.UserQuitEvent;
import org.emulinker.kaillera.model.exception.ActionException;

public class QuitAction
implements V086Action,
V086ServerEventHandler {
    private static Log log = LogFactory.getLog(QuitAction.class);
    private static final String desc = "QuitAction";
    private static QuitAction singleton = new QuitAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static QuitAction getInstance() {
        return singleton;
    }

    private QuitAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof Quit_Request)) {
            throw new FatalActionException("Received incorrect instance of Quit: " + message);
        }
        ++this.actionCount;
        Quit_Request quitRequest = (Quit_Request)message;
        try {
            clientHandler.getUser().quit(quitRequest.getMessage());
        }
        catch (ActionException e) {
            throw new FatalActionException("Failed to quit: " + e.getMessage());
        }
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        UserQuitEvent userQuitEvent = (UserQuitEvent)event;
        try {
            KailleraUser user = userQuitEvent.getUser();
            clientHandler.send(new Quit_Notification(clientHandler.getNextMessageNumber(), user.getName(), user.getID(), userQuitEvent.getMessage()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct Quit_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

