/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.QuitGame_Notification;
import org.emulinker.kaillera.controller.v086.protocol.QuitGame_Request;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.UserQuitGameEvent;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.QuitGameException;

public class QuitGameAction
implements V086Action,
V086GameEventHandler {
    private static Log log = LogFactory.getLog(QuitGameAction.class);
    private static final String desc = "QuitGameAction";
    private static QuitGameAction singleton = new QuitGameAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static QuitGameAction getInstance() {
        return singleton;
    }

    private QuitGameAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof QuitGame_Request)) {
            throw new FatalActionException("Received incorrect instance of QuitGame: " + message);
        }
        ++this.actionCount;
        try {
            clientHandler.getUser().quitGame();
        }
        catch (DropGameException e) {
            log.debug((Object)("Failed to drop game: " + e.getMessage()));
        }
        catch (QuitGameException e) {
            log.debug((Object)("Failed to quit game: " + e.getMessage()));
        }
        catch (CloseGameException e) {
            log.debug((Object)("Failed to close game: " + e.getMessage()));
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            log.error((Object)"Sleep Interrupted!", (Throwable)e);
        }
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        UserQuitGameEvent userQuitEvent = (UserQuitGameEvent)event;
        try {
            KailleraUser user = userQuitEvent.getUser();
            clientHandler.send(new QuitGame_Notification(clientHandler.getNextMessageNumber(), user.getName(), user.getID()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct QuitGame_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

