/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.UnsignedUtil;

public class CachedGameData
extends V086Message {
    public static final byte ID = 19;
    public static final String DESC = "Cached Game Data";
    private int key;

    public CachedGameData(int messageNumber, int key) throws MessageFormatException {
        super(messageNumber);
        this.key = key;
    }

    public byte getID() {
        return 19;
    }

    public String getDescription() {
        return DESC;
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        return this.getInfoString() + "[key=" + this.key + "]";
    }

    public int getBodyLength() {
        return 2;
    }

    public void writeBodyTo(ByteBuffer buffer) {
        buffer.put((byte)0);
        UnsignedUtil.putUnsignedByte(buffer, this.key);
    }

    public static CachedGameData parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 2) {
            throw new ParseException("Failed byte count validation!");
        }
        byte b = buffer.get();
        return new CachedGameData(messageNumber, UnsignedUtil.getUnsignedByte(buffer));
    }
}

