/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.master.client;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.connectcontroller.ConnectController;
import org.emulinker.kaillera.master.PublicServerInformation;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.master.client.MasterListUpdateTask;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraServer;

public class KailleraMasterUpdateTask
implements MasterListUpdateTask {
    private static Log log = LogFactory.getLog(KailleraMasterUpdateTask.class);
    private PublicServerInformation publicInfo;
    private ConnectController connectController;
    private KailleraServer kailleraServer;
    private StatsCollector statsCollector;
    private HttpClient httpClient;

    public KailleraMasterUpdateTask(PublicServerInformation publicInfo, ConnectController connectController, KailleraServer kailleraServer, StatsCollector statsCollector) {
        this.publicInfo = publicInfo;
        this.connectController = connectController;
        this.kailleraServer = kailleraServer;
        this.statsCollector = statsCollector;
        this.publicInfo = publicInfo;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectionTimeout(5000);
        this.httpClient.setTimeout(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchMaster() {
        List createdGamesList = this.statsCollector.getStartedGamesList();
        StringBuilder createdGames = new StringBuilder();
        List list = createdGamesList;
        synchronized (list) {
            Iterator iter = createdGamesList.iterator();
            while (iter.hasNext()) {
                createdGames.append(iter.next());
                createdGames.append("|");
            }
            createdGamesList.clear();
        }
        StringBuilder waitingGames = new StringBuilder();
        for (KailleraGame kailleraGame : this.kailleraServer.getGames()) {
            if (kailleraGame.getStatus() != 0) continue;
            waitingGames.append(kailleraGame.getID());
            waitingGames.append("|");
            waitingGames.append(kailleraGame.getRomName());
            waitingGames.append("|");
            waitingGames.append(kailleraGame.getOwner().getName());
            waitingGames.append("|");
            waitingGames.append(kailleraGame.getOwner().getClientType());
            waitingGames.append("|");
            waitingGames.append(kailleraGame.getNumPlayers());
            waitingGames.append("|");
        }
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("servername", this.publicInfo.getServerName()), new NameValuePair("port", Integer.toString(this.connectController.getBindPort())), new NameValuePair("nbusers", Integer.toString(this.kailleraServer.getNumUsers())), new NameValuePair("maxconn", Integer.toString(this.kailleraServer.getMaxUsers())), new NameValuePair("version", "0.86"), new NameValuePair("nbgames", Integer.toString(this.kailleraServer.getNumGames())), new NameValuePair("location", this.publicInfo.getLocation()), new NameValuePair("ip", this.publicInfo.getConnectAddress()), new NameValuePair("url", this.publicInfo.getWebsite())};
        GetMethod getMethod = new GetMethod("http://www.kaillera.com/touch_server.php");
        getMethod.setQueryString(params);
        getMethod.setRequestHeader("Kaillera-games", createdGames.toString());
        getMethod.setRequestHeader("Kaillera-wgames", waitingGames.toString());
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                log.error((Object)("Failed to touch Kaillera Master: " + getMethod.getStatusLine()));
            } else {
                log.info((Object)"Touching Kaillera Master done");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to touch Kaillera Master: " + e.getMessage()));
        }
        finally {
            if (getMethod != null) {
                try {
                    getMethod.releaseConnection();
                }
                catch (Exception e) {}
            }
        }
    }
}

